# plugs/update.py
#
#

""" run mercurial pull -u """

__copyright__ = 'this file is in the public domain'

from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.generic import gozerpopen
from gozerbot.plughelp import plughelp
from gozerbot.lockmanager import lockmanager
import os, os.path

plughelp.add('update', 'do a mercurial update')

def handle_hgupdate(bot, ievent):
    """ update .. update the bot with mercurial hg pull -u """
    args = [""] * 3
    args[0] = "hg"
    args[1] = "pull"
    args[2] = "-u"
    try:
        proces = gozerpopen(args)
    except Exception, ex:
        ievent.reply('error running popen: %s' % str(ex))
        return
    data = proces.fromchild.readlines()
    returncode = proces.close()
    if returncode != 0:
        ievent.reply("no changes")
        return
    # show response
    res = []
    for line in data:
        res.append(line.strip())
    if res:
        ievent.reply(" .. ".join(res))

def handle_svnupdate(bot, ievent):
    args = ['svn', 'update']
    ievent.reply('running svn update')
    try:
        proces = gozerpopen(args)
    except Exception, ex:
        ievent.reply('error running popen: %s' % str(ex))
        return
    data = proces.fromchild.readlines()
    returncode = proces.close()
    if returncode != 0:
        ievent.reply('error running svn update')
        return
    res = []
    for line in data:
        res.append(line.strip())
    if res:
        ievent.reply(" .. ".join(res))

def handle_update(bot, ievent):
    lockmanager.acquire('up')
    if os.path.isdir('.hg'):
        handle_hgupdate(bot, ievent)
        lockmanager.release('up')
        return
    if os.path.isdir('.svn'):
        handle_svnupdate(bot, ievent)
        lockmanager.release('up')
        return
    ievent.reply('i need a svn or mercurial repository for update to work')
    lockmanager.release('up')

cmnds.add('update', handle_update, 'OPER')
examples.add('update', 'update the bot with mercurial or subversion', 'update')
