# web/dispatch.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import waitforqueue
from gozerbot.fleet import fleet
from gozerbot.ircevent import Ircevent
from gozerbot.plugins import plugins
from gozerbot.thr import start_new_thread
from gozerbot.config import config
from gozerplugs.plugs.webserver import httpd
from cgi import escape
from urllib import unquote_plus
import Queue, time

def handle_dispatch(event):
    input = unquote_plus(event.path)
    if config['jabberenable']:
        bot = fleet.byname('jabbermain')
    else:
        bot = fleet.byname('main')
    ievent = Ircevent()
    try:
        what = input.split('?', 1)[1]
    except IndexError:
        return ["dispatch what ?",]
    if what.startswith("command="):
        what = what[8:]
    ievent.txt = what
    ievent.nick = 'web'
    ievent.userhost = 'web@web'
    ievent.channel = 'web'
    q = Queue.Queue()
    ievent.queues.append(q)
    ievent.speed = 3
    ievent.bot = bot
    result = []
    if plugins.woulddispatch(bot, ievent):
        start_new_thread(plugins.trydispatch, (bot, ievent))
    else:
        return ["can't dispatch %s" % what, ]
    result = waitforqueue(q, 60)
    if not result:
        return ["can't dispatch %s" % what, ]
    return result

if httpd:
    httpd.addhandler('dispatch', handle_dispatch)
