# tests/test_country.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
import unittest, Queue

plugins.reload('gozerplugs.plugs', 'country')

class test_country(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'

    def test_country(self):
        result = self.b.test('country')
        self.assert_(stringinlist('<countrycode>', result))

    def test_country2(self):
        result = self.b.test('country nl')
        self.assert_(stringinlist('Netherlands', result))

    def test_country3(self):
        result = self.b.test('country .nl')
        self.assert_(stringinlist('Netherlands', result))

    def test_country4(self):
        result = self.b.test('country netherlands')
        self.assert_(stringinlist('NL', result))
