# plugs/reverse.py
#
# Hans van Kranenburg <hans@knorrie.org>

""" reverse string or list """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import waitforqueue
from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.plughelp import plughelp

plughelp.add('reverse', 'reverse string or list')

def handle_reverse(bot, ievent):
    """ reverse string or pipelined list """
    if ievent.inqueue:
        result = waitforqueue(ievent.inqueue, 5)
    elif not ievent.rest:
        ievent.missing('<text to reverse>')
        return
    else:
        result = ievent.rest
    ievent.reply(result[::-1])

cmnds.add('reverse', handle_reverse, 'USER')
examples.add('reverse', 'reverse text', '!reverse gozerbot')
