#! /usr/bin/env python
#
# Quick'n'dirty doc generator
#
# TODO:
#  * look for author in the hg heads
#  * map user<>full name in this file
#  * use gozerbot to actually process the output of the commands, if able
#

from gozerbot.generic import handle_exception, enable_logging, toascii, \
splittxt
from gozerbot.plugins import plugins
from gozerbot.ircevent import Ircevent
from gozerbot.examples import examples
from gozerbot.bot import Bot
from gozerbot.users import users
from gozerbot.plughelp import plughelp
from gozerbot.commands import cmnds
from gozerbot.aliases import aliasreverse
from gozerbot.config import config
from gozerbot.fleet import fleet
import os
import sys
reload(sys)
sys.setdefaultencoding('utf-8')
import re
import time
donot = ['quit', 'reboot', 'jump']
config.load()
oldlevel = config['loglevel']
config['loglevel'] = 100
enable_logging()
bot = Bot('test@test', 'test')
bot.channels.setdefault('#test', {})
bot.channels.setdefault('#dunkbots', {})
bot.userhosts['dunker'] = 'bart@gozerbot.org'
bot.userhosts['test'] = 'test@test'
fleet.addbot(bot)
plugins.regplugins()
time.sleep(3)

try:
    users.add('test', ['test@test', ], ['OPER', 'USER', 'QUOTE'])
except Exception, ex:
    pass

def gendoc(f):
    base = os.path.basename(f).replace('.py', '')
    print '=' * (len(base)+2)
    print ' %s ' % base.upper()
    print '=' * (len(base)+2)
    print "| \n"
    print "about"
    print "-----"
    print "| \n"
    try:
        author = plugins.plugs[base].__author__
        print ":author:  %s" % author.strip()
    except AttributeError:
        print ":author:  Bart Thate <bart@gozerbot.org>"
    print ":contact: IRCNET/#dunkbots"
    print ":website: http://plugins.gozerbot.org"
    try:
        license = plugins.plugs[base].__license__
        print ":license:  %s" % license.strip()
    except AttributeError:
        print ":license: Public Domain"
    print " "
    print "| \n"
    data = {'author': 'unknown', 'description': '', 'commands':[], 'examples':{}, \
'descriptions':{}, 'callbacks': {}, 'aliases': {}}
    data['description'] = plughelp[base]
    cmndlist = []
    for j, z in cmnds.iteritems():
        if j in donot:
            continue
        if z.plugname == base:
            cmndlist.append(j)
    try:
        first = plugins.plugs[base].__gendocfirst__
        for i in first[::-1]: 
            try:
                cmndlist.remove(i)
            except ValueError:
                continue
            cmndlist.insert(0,i)
    except AttributeError:
        pass
    for command in cmndlist:
        data['commands'].append(command)
        alias = aliasreverse(command)
        if alias:
            data['aliases'][command] = alias
        try:
            ex = examples[command]
        except Exception, exx:
            continue
        data['examples'][command] = []
        exampleslist = re.split('\d\)', ex.example)
        for e in exampleslist:
            data['examples'][command].append(e.strip())
            data['descriptions'][command] = ex.descr

    print "description"
    print "-----------"
    print "| \n"
    print data['description']
    print "\n| \n"
    print 'commands'
    print "--------"
    print "| \n"
    data['commands'].sort()
    teller = 1
    for command in data['commands']:
        if data['aliases'].has_key(command):
            print '\n%s) %s (%s)' % (teller, command, data['aliases'][command])
        else:
            print '\n%s) %s' % (teller, command)
        if data['descriptions'].has_key(command):
            print '\n    %s' % data['descriptions'][command]
        if data['examples'].has_key(command):
            for i in data['examples'][command]:
                if not i:
                     continue
                print '\n    ::\n\n        <user> !%s' % i.strip()
                output = None
                try:
                    output = bot.test(i.strip(), 5)
                    result = toascii(' .. '.join(output))
                    for j in splittxt(result, 50):
                        print '        <output> %s' % j
                except Exception, ex:
                    handle_exception()
                    print i
        teller += 1

#config['loglevel'] = oldlevel

if __name__ == '__main__':
    if len(sys.argv) != 2 or not os.path.isfile(sys.argv[1]):
        print '%s <file>' % sys.argv[0]
        sys.exit(1)
    gendoc(sys.argv[1])
    sys.stdout.flush()
