# tests/test_infoitem.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
import unittest, Queue

plugins.reload('gozerplugs.plugs', 'infoitem')

class test_infoitem(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'

    def test_adddinfoitem(self):
        result = self.b.test('test1 = m')
        self.assert_(stringinlist('i need', result))

    def test_adddinfoitem2(self):
        result = self.b.test('test1 = mekker')
        self.b.test('forget test1 mekker')
        self.assert_(stringinlist('add', result))

    def test_question(self):
        result = self.b.test('test11?')
        self.assert_(stringinlist('no infoitems', result))

    def test_question(self):
        self.b.test('test1 = mekker')
        result = self.b.test('test1?')
        self.b.test('forget test1 mekker')
        self.assert_(stringinlist('mekker', result))

    def test_forget(self):
        result = self.b.test('forget test1')
        self.assert_(stringinlist('<item>', result))

    def test_forget2(self):
        result = self.b.test('forget test1 b')
        self.assert_(stringinlist('i need', result))

    def test_forget3(self):
        result = self.b.test('forget blamekkertest1 bla')
        self.assert_(stringinlist('failed', result))

    def test_forget4(self):
        self.b.test('test1 = mekker')
        result = self.b.test('forget test1 mekker')
        self.assert_(stringinlist('item deleted', result))

    def test_searchdescr(self):
        result = self.b.test('sd')
        self.assert_(stringinlist('<txt>', result))

    def test_searchdescr2(self):
        self.b.test('test1 = mekker')
        result = self.b.test('sd mek')
        self.b.test('forget test1 mekker')
        self.assert_(stringinlist('mekker', result))

    def test_searchinfo(self):
        result = self.b.test('si')
        self.assert_(stringinlist('<txt>', result))

    def test_searchinfo2(self):
        self.b.test('test1 = mekker')
        result = self.b.test('si test')
        self.b.test('forget test1 mekker')
        self.assert_(stringinlist('test1', result))
