# tests/test_split.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import rlog
from gozerbot.plugins import plugins
from gozerbot.bot import Bot
import unittest, time

class test_split(unittest.TestCase):
    b = Bot('me')
    plugins.reload('gozerplugs.plugs', 'ops')

    def sendoverload(self, txt):
        rlog(10, 'bot-send', txt) 
        if "PONG" in txt:
            self.gotcha = 1

    def test_split_join(self):
        self.b.send = self.sendoverload
        self.gotcha = 0
        for i in range(100):
            self.b.fakein(':dunk!dunk@localhost QUIT :*.')
        for i in range(100):
            self.b.fakein(':dunk!dunk@localhost JOIN :#dunkbots')
        self.b.fakein('PING :bla')
        self.assertEqual(self.gotcha, 1)

    def test_splitted(self):
        for i in range(100):
            self.b.fakein(':dunk!dunk@localhost QUIT :*.')
        for i in range(100):
            self.b.fakein(':dunk!dunk@localhost JOIN :#dunkbots')
        time.sleep(1)
        self.assertEqual(self.b.splitted, [])
