# web/karma.py
#
#

""" show all karma items """

__copyright__ = 'this file is in the public domain'

from gozerbot.config import config
if config['dbenable']:
    from gozerbot.db import db
else:
    from gozerplugs.plugs.karma import karma
from gozerplugs.plugs.webserver import httpd

def handle_karma(event):
    """ show all pickled karma items """
    result = []
    resultlist = []
    for i, j in karma.karma.iteritems():
        resultlist.append((i,j))
    resultlist.sort(lambda x, y: cmp(y[1], x[1]))
    for i in resultlist:
        result.append("%s = %s" % (i[0], i[1]))
    if not result:
        return ['no karma items', ]
    return result

def handle_karmadb(event):
    """ show all database karma items """
    result = []
    dbresult = db.execute(""" SELECT item, value FROM karma ORDER BY \
value DESC""")
    if not dbresult:
        return ['no karma items', ]
    for i in dbresult:
        result.append("%s = %s" % (i[0], i[1]))
    return result

if httpd:
    if not config['dbenable']:
        httpd.addhandler('karma', handle_karma)
    else:
        httpd.addhandler('karma', handle_karmadb)
