# tests/test_autovoice.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
from gozerbot.config import config
import unittest, time, Queue

plugins.reload('gozerplugs.plugs', 'autovoice')

class test_autovoice(unittest.TestCase):
    b = Bot()
    b.channels.setdefault('#test', {})
    
    def __init__(self, bla):
        unittest.TestCase.__init__(self, bla)
        self.b.userhosts['test'] = 'test@test'
        self.b.send = self.sendoverload
        self.queue = Queue.Queue()
        self.b.state['opchan'].append('#test')

    def sendoverload(self, txt):
        self.queue.put(txt)
        self.queue.put(None)

    def test_autovoiceon(self):
        result = self.b.test('autovoice-on')
        self.assert_(stringinlist('enabled', result))

    def test_autovoiceon2(self):
        self.b.test('autovoice-on')
        self.b.fakein(':test!test@test JOIN :#test')
        result = waitforqueue(self.queue, 2)
        self.assert_(stringinlist('+v', result))

    def test_autovoiceoff(self):
        result = self.b.test('autovoice-off')
        self.assert_(stringinlist("disabled", result))

    def test_autovoiceoff2(self):
        self.b.test('autovoice-off')
        self.b.fakein(':test!test@test JOIN :#test')
        result = waitforqueue(self.queue, 2)
        self.assertEqual(result, [])
