/*
Copyright (C) 2000-2005  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

/*Patch for list of gp functions. Must be include after header.h.*/
typedef enum {GPuser_private,
              GPgpmany,GPgplist,
              GPinstall,GPaddhelp,
              GPgrandO,
              GPbreak,GPnext,GPreturn,
              GPfor,GPforstep,GPforstepvec,GPforprime,GPforvec,GPfordiv,
              GPdoloop,
              GPlabel,
              GPglobal,GPlocal,
              GPif,
              GPprod,GPsum,GPsumdiv,GPprodeuler,
              GPuntil,GPwhile,
              GPmakevec,GPmakemat,
              GPvector,GPvectorsmall,GPvectorv,GPmatrix,
              GPinitfunc,GPcopyarg
} GPspec_private;

struct patchfunc_s
{
  char *gpname;
  char *code;
  int type;
  GPspec_private mode;
  int spec;
} patchfunc[]={
/*Override previous definition in pari/src/init.c*/
{"O",NULL,Ggen,0,GPgrandO},
{"break",NULL,Gvoid,0,GPbreak},
{"next",NULL,Gvoid,0,GPnext},
{"for","GGIG",Gnotype,(1<<Msemicomma),GPfor},
{"fordiv",NULL,Gnotype,(1<<Msemicomma),GPfordiv},
{"forstep","GIGGGG",Gnotype,(1<<Msemicomma),GPforstep},
{"forvec",NULL,Gnotype,(1<<Msemicomma),GPforvec},
{"forprime",NULL,Gnotype,(1<<Msemicomma),GPforprime},
{"if","GII",Gnotype,(1<<Msemicomma),GPif},
{"prod","NULL",Gnotype,(1<<Msemicomma),GPprod},
{"prodeuler",NULL,Gnotype,(1<<Msemicomma),GPprodeuler},
{"return",NULL,Gnotype,(1<<Mterm),GPreturn},
{"sum",NULL,Gnotype,(1<<Msemicomma),GPsum},
{"sumdiv",NULL,Gnotype,(1<<Msemicomma),GPsumdiv},
{"until","EI",Gnotype,(1<<Msemicomma),GPuntil},
{"vector",NULL,Gnotype,(1<<Msemicomma),GPvector},
{"vectorsmall",NULL,Gnotype,(1<<Msemicomma),GPvectorsmall},
{"vectorv",NULL,Gnotype,(1<<Msemicomma),GPvectorv},
{"matrix",NULL,Gnotype,(1<<Msemicomma),GPmatrix},
{"while","EI",Gnotype,(1<<Msemicomma),GPwhile},
{"_doloop","I",Gnotype,(1<<Msemicomma),GPdoloop},
/* New definition*/
{"local",NULL,Gnotype,(1<<Msemicomma),GPlocal},
{"global",NULL,Gnotype,(1<<Msemicomma),GPglobal},
{"_makevec","*",Gnotype,(1<<Msemicomma),GPmakevec},
{"_makemat","*",Gnotype,(1<<Msemicomma),GPmakemat},
{"_gerepilelist",NULL,Gnotype,0,GPgplist},
{"_gerepilemany",NULL,Gvoid,(1<<Msemicomma),GPgpmany},
{"_initfunc","",Gvoid,(1<<Msemicomma),GPinitfunc},
{"_copyarg","",Gvoid,(1<<Msemicomma),GPcopyarg},
{"_label",NULL,Gvoid,0,GPlabel},
{"forstepvec","GIGGGG",Gnotype,(1<<Msemicomma),GPforstepvec},
{"install",NULL,Gnotype,(1<<Msemicomma),GPinstall},
{"addhelp",NULL,Gnotype,(1<<Msemicomma),GPaddhelp},
{NULL,NULL,0,0,0}};
