/*
Copyright (C) 2000-2003  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "header.h"
char *nameparse;
int linecount;
static void 
msgprefix(int n)
{
  if (n>0)
    fprintf(stderr,"%s:%d: ",nameparse,tree[n].lineno);
  else
  {
    switch(n)
    {
    case err_func:
      fprintf(stderr,"%s:%s: ",nameparse,currfunc==-1?"toplevel":lfunc[currfunc].gpname); 
      break;
    case err_parse:
      fprintf(stderr,"%s:%d: ",nameparse,linecount); 
      break;
    case err_desc:
      fprintf(stderr,"func.dsc:<loading>: "); 
      break;
    }
  }
}

void die(int n, const char *format, ...)
{
  va_list ap;
  va_start(ap, format);
  fprintf(stderr,"Error:");
  msgprefix(n);
  vfprintf(stderr,format,ap);
  fprintf(stderr,"\n"); 
  printnode(stderr,n);
  fprintf(stderr,"\n"); 
  exit(1);
}

extern int do_warning;

void warning(int n, const char *format, ...)
{
  va_list ap;
  va_start(ap, format);
  if (do_warning)
  {
    fprintf(stderr,"Warning:");
    msgprefix(n);
    vfprintf(stderr,format,ap);
    fprintf(stderr,"\n"); 
    printnode(stderr,n);
    fprintf(stderr,"\n");
  }
  va_end(ap);
}

int listtostack(int n, int f, int *stack, int nbmax, const char *error,int nerr)
{
  int x,i,nb;
  if (n==-1) return 0;
  for(x=n,i=0;tree[x].f==f && i<nbmax;x=tree[x].x,i++);
  if (i==nbmax)
    die(nerr,"Too many args for `%s'",error);
  nb=i+1;
  for(x=n;i>0;stack[i]=tree[x].y,x=tree[x].x,i--);
  stack[0]=x;
  return nb;
}
int listcalltostack(int n, int fnum, int *stack, int nbmax, const char *error,int nerr)
{
  int x=n, i=0, nb;
  if (n==-1) return 0;
  while(1)
  {
    int xx=tree[x].x;
    int xy=tree[x].y;
    if (tree[x].f!=Fentryfunc || xx!=fnum) break;
    x=tree[xy].x;
    i++;
    if (i>=nbmax)
      die(nerr,"Too many args for `%s'",error);
  }
  nb=i+1;
  for(x=n;i>0;i--)
  {
    int y=tree[x].y;
    x=tree[y].x;
    stack[i]=tree[y].y;
  }
  stack[0]=x;
  return nb;
}
int listtostackparent(int n, int f, int *stack, int nbmax, const char *error,int nerr)
{
  int x,i,nb;
  if (n==-1) return 0;
  nbmax--;
  for(x=n,i=0;tree[x].f==f && i<nbmax;x=tree[x].x,i++);
  if (i==nbmax)
    die(nerr,"Too many args for `%s'",error);
  nb=i--;
  for(x=n;i>=0;stack[i]=x,x=tree[x].x,i--);
  return nb;
}

int genlistargs(int n,int *stack,int min,int max)
{
  const char *name=value[tree[n].x].val.str;
  int y=tree[n].y;
  int nb=(y==GNOARG)?0:listtostack(y,Flistarg,stack,max,name,n);
  if(nb<min)
    die(n,"Too few args for `%s'",name);
  return nb;
}

int genlistcats(int y,int *stack,int max)
{
  return listcalltostack(y,OPcat,stack,max,"concatenation",y);
}

PPproto parseproto(char const **q, char *c)
{
  char  const *p=*q;
  long i;
  switch(*p)
  {
  case 0:
    return PPend;
  case 'D':
    switch(p[1])
    {
    case 0:
      die(-1,"incomplete prototype");
    case 'G':
    case '&':
    case 'V':
    case 'I':
    case 'n':
      *c=p[1];
      *q=p+2;
      return PPdefault;
    default:
      for(i=0;*p && i<2;p++) i+=*p==',';
      if (i<2)
        die(-1,"incomplete prototype");
      *c=p[-2];
      *q=p;
      return PPdefaultmulti;
    }
    break;
  case '=':
    *c=*p;
    *q=p+1;
    return PPsep;
  case '*':
    *c=*p;
    *q=p+1;
    return PPmultiarg;
  case 's':
    if (p[1]=='*')
    {
      *c=*++p;
      *q=p+1;
      return PPmultiarg;
    }/*Fall Through*/
  default:
    *c=*p;
    *q=p+1;
    return PPstd;
  }
}

char *xstrndup(const char *s, size_t n)
{
  char *t=(char*)malloc(n+1);
  long i;
  for(i=0;i<n;i++) t[i]=s[i];
  t[i]=0;
  return t;
}
