/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GPASS_PASSWORD_TREE_H__
#define __GPASS_PASSWORD_TREE_H__

#include "window.h"

G_BEGIN_DECLS

GError *gpass_entry_tree_initialize(GPassWindow *window);
GError *gpass_entry_tree_build(GPassWindow *window);

void gpass_entry_tree_push_insert_command(GPassWindow *window,
                                          GPassEntry *entry,
                                          const gchar *description);
void gpass_entry_tree_insert(GPassWindow *window, GPassEntry *target,
                             GPassEntry *parent, GPassEntry *sibling);

void gpass_entry_tree_push_unlink_command(GPassWindow *window,
                                          const gchar *description);
void gpass_entry_tree_unlink(GPassWindow *window, GPassEntry *target,
                             GPassEntry *parent, GPassEntry *sibling);

void gpass_entry_tree_push_move_command(GPassWindow *window, GPassEntry *target,
                                        GPassEntry *parent, GPassEntry *previous);
void gpass_entry_tree_move_after(GPassWindow *window, GPassEntry *target,
                                 GPassEntry *parent, GPassEntry *previous);

void gpass_entry_tree_change_entry(GPassWindow *window, GPassEntry *target,
                                   GPassEntry *entry);

G_END_DECLS

#endif /* #ifndef __GPASS_PASSWORD_TREE_H__ */
