#!/usr/bin/env python
# GPixPod - organize photos on your iPod, freely!
# Copyright (C) 2006 Flavio Gargiulo (FLAGAR.com)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

import gtk, gtk.glade, sys, os, gobject, cPickle, webbrowser, re, locale, gettext, signal, copy
if os.path.basename(sys.argv[0]) == 'gpixpod.py':
    if os.path.dirname(sys.argv[0]) != '':
        os.chdir(os.path.dirname(sys.argv[0]))
from threading import Thread
import imgconvert
from mh import *
from utils import *
# Internationalization
#locale.setlocale(locale.LC_ALL, 'it_IT.UTF-8')
#locale.setlocale(locale.LC_ALL, '')
gettext.bindtextdomain('gpixpod', 'po')
gettext.textdomain('gpixpod')
gettext.install('gpixpod', 'po', True)
gtk.glade.bindtextdomain('gpixpod', 'po')
try:
    from ipodhal import *
except ImportError:
    print _("iPod HAL autodetection disabled")


class GPixPod:
    """ Main GUI interface """

    def __init__(self):
        """ Initialize variables and the main window """
	# Preferences
        self.homedir = os.path.expanduser('~')
	self.preferencesdir = os.path.join(self.homedir, '.gpixpod')
	if not os.path.isdir(self.preferencesdir):
	    os.mkdir(self.preferencesdir)
	self.preferencesfile = os.path.join(self.preferencesdir, 'config')
	# Default preferences
	self.prefs = self.defaultprefs = {'ipod_model':None, 'ipod_autodetect':True, 'ipod_mountpoint':"/mnt/ipod", 'ipod_askbeforeopen':True, 'photo_copyfullres':True,
	                                  'path_lastphotodb':self.homedir, 'path_lastimages':self.homedir, 'path_lastsavedimages':self.homedir,
                                          'path_thumbscache':os.path.join(self.preferencesdir, '.SingleThumbs'), 'photo_behaviour':'Fit', 'photo_autorotate':'No',
                                          'gui_toolbar':True, 'gui_treeviewpreviews':False, 'gui_detailspane':True}
	# Overriding default preferences
	try:
	    self.LoadPreferences()
	except IOError:
	    print _("Using default preferences")

    def GUI(self):
	""" Build the GUI, of course to be called right after instantiation and application launch """
        self.win_callbacks = {'on_addalbum1_activate':(self.ShowGetLine, self.AddAlbum, _('Add new photo album'), _('Enter the name of the new album:'),
	                                               _('New Photo Album')),
	                      'on_addalbumbutton_clicked':(self.ShowGetLine, self.AddAlbum, _('Add new photo album'), _('Enter the name of the new album:'), 
			                                   _('New Photo Album')),
	                      'on_addphoto1_activate':(self.ShowChooser, self.AddPhotoChooser, _('Images'), 'PIXBUF', True, self.prefs['path_lastimages'], True),
			      'on_addphotobutton_clicked':(self.ShowChooser, self.AddPhotoChooser, _('Images'), 'PIXBUF', True, self.prefs['path_lastimages'], True),
                              'on_rename_album1_activate':self.ShowRenameAlbum,
			      'on_add_full_resolution_activate':(self.ShowChooser, self.AddFullResolution, _('Image'), 'PIXBUF', False, self.prefs['path_lastimages'], True),
			      'on_remove_full_resolution_activate':self.RemoveFullResolution,
                              'on_add_photo_reference1_activate':(self.ShowGetLine, self.AddReference, _('Choose photo'), _('Enter a Photo ID:'), '100'),
                              'on_delete_reference1_activate':self.DeleteReference,
			      'on_donate1_activate':(self.LaunchBrowser, 'https://www.paypal.com/xclick/business=flagar%40gmail.com&item_name=Helping+GPixPod+development&no_shipping=1&tax=0&currency_code=EUR&lc=US'),
                              'on_ipodinfo1_activate':self.ShowIpodInfo,
	                      'on_about1_activate':self.ShowAbout, 'on_delete1_activate':self.Delete,
			      'on_aboutbutton_clicked':self.ShowAbout, 'on_deletebutton_clicked':self.Delete,
			      'on_preferences1_activate':self.ShowPreferences,
			      'on_eject1_activate':self.Eject, 'on_ejectbutton_clicked':self.Eject,
	                      'on_quit1_activate':self.Quit, 'on_window1_destroy':self.Quit,
			      'on_quitbutton_clicked':self.Quit, 'on_window1_destroy':self.Quit,
			      'on_open1_activate':(self.ShowChooser, self.Open, 'iPod Photo Database', 'Photo Database', False, self.prefs['path_lastphotodb']),
			      'on_openbutton_clicked':(self.ShowChooser, self.Open, 'iPod Photo Database', 'Photo Database', False, self.prefs['path_lastphotodb']),
			      'on_new1_activate':(self.ShowChooser, self.CreateNew, None, None, False, None, False, gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER,
			                          _('Select the iPod folder mountpoint')),
			      'on_treeview1_row_activated':self.DetailsDoubleClick, 'on_treeview1_cursor_changed':self.Details,
			      'on_notebook1_switch_page':self.NotebookPage,
			      'on_expander1_activate':(self.ExpandThumbnail, 0), 'on_expander2_activate':(self.ExpandThumbnail, 1),
			      'on_expander3_activate':(self.ExpandThumbnail, 2), 'on_expander4_activate':(self.ExpandThumbnail, 3),
			      'on_save1_activate':self.Save, 'on_savebutton_clicked':self.Save,
			      'on_treeview1_unselect_all':self.HideActions,
			      #'on_window1_state_changed':self.Opening,
			      'on_spinbutton1_value_changed':self.ZoomImage,
			      'on_saveimagebutton_clicked':(self.ShowChooser, self.SaveImage, _('Images'), 'PIXBUF', False, self.prefs['path_lastsavedimages'], 
			                                    False, gtk.FILE_CHOOSER_ACTION_SAVE, _('Save image')),
                              'on_new_album_from_unreferenced_photos1_activate':self.NewAlbumFromUnreferencedPhotos,
			      'on_cleancache1_activate':self.CleanCache, 'on_rescue_database1_activate':self.Rescue,
                              'on_progresspausebutton_clicked':self.PauseProgress, 'on_progressstopbutton_clicked':self.StopProgress,
                              'on_toolbar2_activate':self.ToggleToolbar,
                              'on_list_previews1_activate':self.TogglePreviews, 'on_details_pane1_activate':self.ToggleDetails}
	self.win = gtk.glade.XML('gpixpod.glade', 'window1', 'gpixpod')
	self.win.signal_autoconnect(self.win_callbacks)
	self.window = self.win.get_widget('window1')
        self.treeview = self.win.get_widget('treeview1')
        self.notebook = self.win.get_widget('notebook1')
        if os.path.isfile('GPixPod_icon.png'):
            self.icon = 'GPixPod_icon.png'
        elif os.path.isfile('/usr/share/gpixpod/GPixPod_icon.png'):
            self.icon = '/usr/share/gpixpod/GPixPod_icon.png'
        else:
            self.icon = None
        if os.path.isfile('GPixPod.png'):
            self.logo = 'GPixPod.png'
        elif os.path.isfile('/usr/share/gpixpod/GPixPod.png'):
            self.logo = '/usr/share/gpixpod/GPixPod.png'
        else:
            self.logo = None
        if os.path.isfile('ipod.png'):
            self.ipodicon = 'ipod.png'
        elif os.path.isfile('/usr/share/gpixpod/ipod.png'):
            self.ipodicon = '/usr/share/gpixpod/ipod.png'
        else:
            self.ipodicon = None
        if os.path.isfile('photoalbum.png'):
            self.photoalbumicon = 'photoalbum.png'
        elif os.path.isfile('/usr/share/gpixpod/photoalbum.png'):
            self.photoalbumicon = '/usr/share/gpixpod/photoalbum.png'
        else:
            self.photoalbumicon = None
        if self.icon:
            self.window.set_icon_from_file(self.icon)
        if self.photoalbumicon:
            self.win.get_widget('detailsphotoalbumimage').set_from_file(self.photoalbumicon)
	self.current_photo_id = None
	self.imageipodthumb0 = self.win.get_widget('imageipodthumb0')
        self.imageipodthumb1 = self.win.get_widget('imageipodthumb1')
      	self.imageipodthumb2 = self.win.get_widget('imageipodthumb2')
 	self.imageipodthumb3 = self.win.get_widget('imageipodthumb3')
	self.label = self.win.get_widget('label1')
	self.label.set_line_wrap(True)
	self.image = self.win.get_widget('image1')
	self.savefilename = None
	self.imagehbox = self.win.get_widget('imagehbox')
	self.imagehbox.hide()
	self.spinbutton = self.win.get_widget('spinbutton1')
	self.statusbar = self.win.get_widget('statusbar1')
	self.statusbar_context = self.statusbar.get_context_id('GPixPod')
	self.statusbar.push(self.statusbar_context, _('Please connect the iPod...'))
	self.progressbar = self.win.get_widget('progressbar1')
	self.progresslabel = self.win.get_widget('label3')
        self.progresspausebutton = self.win.get_widget('progresspausebutton')
        self.progressstopbutton = self.win.get_widget('progressstopbutton')
	#self.current_album = 0
	# Lists to mark the new changes
	self.albums_to_add = []
	self.albums_to_delete = []
	self.albums_to_rename = []  # the entry is the corresponding tuple of album ID and new name
	self.photos_to_delete = []
	self.photos_to_add = []  # the entry is the corresponding tuple of filename path, parent album ID, and full resolution option
        self.fullres_to_add = []  # the entry is a tuple of 2 elements: filename and photo ID
        self.fullres_to_delete = []  # the entry is the photo ID
        self.references_to_add = []  # the entry is a tuple of 2 elements: a photo ID and an album ID
        self.references_album_to_delete = []  # the entry is the album ID
        self.references_photo_to_delete = []  # the entry is a tuple of 2 elements: a photo ID and an album ID
	# Setting sensitiveness
	self.SetSensitive(('save1', 'savebutton', 'addalbum1', 'addalbumbutton', 'rename_album1', 'eject1', 'ejectbutton', 'ipodinfo1', 'spinbutton1', 'saveimagebutton', 'add_full_resolution', 'remove_full_resolution', 'new_album_from_unreferenced_photos1', 'list_previews1', 'expander1', 'expander2', 'expander3', 'expander4', 'cleancache1', 'rescue_database1'), False)
	self.HideActions(None)  # hide "Add Photo" and "Delete" by default
        self.tosave = False
	self.DB = None  # Used to check if a Photo Database is loaded
        # Updating GUI sections as previous status
        self.win.get_widget('details_pane1').set_active(self.prefs['gui_detailspane'])
        self.win.get_widget('toolbar2').set_active(self.prefs['gui_toolbar'])
        # Continue starting
	if os.name == 'nt' and not os.path.isfile('DONATED'):
            self.DonateForGPixPod()
            gobject.timeout_add(300000, self.DonateForGPixPod)
	if sys.modules.has_key('ipodhal') and self.prefs['ipod_autodetect']:  # If ipodhal.py has been imported successfully (python-dbus/hal/gnomevfs are available),
	    gobject.idle_add(self.HALdetect)  # Checking in a loop events of connection and removal of an iPod
        else:
	    self.Opening(None)

    def SetSensitive(self, widget_list, state):
        """ Change sensitivity in the same way for a group of widgets """
        for widget_name in widget_list:
            self.win.get_widget(widget_name).set_sensitive(state)

    def StatusBarNotify(self, sentence):
        """ Display a sentence on the statusbar """
        self.statusbar.push(self.statusbar_context, sentence)

    def HALdetect(self):
        """ Detect using HAL """
	if sys.modules.has_key('ipodhal') and self.prefs['ipod_autodetect']:
	    #ipodHal will connect to HAL via DBUS
	    #and 2 signal are implemented to detect ipod
	    ipod_hal = iPodHal()
	    #Connect to some signal
	    ipod_hal.connect("ipod-added", self.OnIpodConnect)
	    ipod_hal.connect("ipod-removed", self.OnIpodDisconnect)
	    #Launch the detection 
	    #if ipod already present signal 'ipod-added' is emit now
	    ipod_hal.start_monitor()

    def Opening(self, widget):
        """ Prepare to open the Photo Database, trying to find it and evaluating command line argument """
	#if len(sys.argv) > 1:
	#    self.DBOpen(sys.argv[1])
	#else:
	standard_path = self.prefs['ipod_mountpoint']
	standard_loc = os.path.join(standard_path, 'Photos', 'Photo Database')
	if os.path.isfile(standard_loc):
	    if self.prefs['ipod_askbeforeopen'] == False or self.Ask(_('<b>Photo Database</b> found.'), _('Do you want to load the Photo Database found in the <b>iPod</b> attached to <b><i>%s</i></b>?') % standard_path):
	        self.DBOpen(standard_loc)
	    else:
		self.ShowChooser(None, self.Open, 'iPod Photo Database', 'Photo Database', False, self.prefs['path_lastphotodb'])
	elif os.path.isdir(os.path.join(standard_path, 'iPod_Control')):
	    if self.prefs['ipod_askbeforeopen'] == False or self.Ask(_('<b>iPod</b> found, attached to <b><i>%s</i></b>.') % standard_path, _('But Photo Database <b>not found</b>. Do you want to create a new one?')):
	        self.DBOpen(standard_loc)
	    else:
	        self.ShowChooser(None, self.Open, 'iPod Photo Database', 'Photo Database', False, self.prefs['path_lastphotodb'])
        else:
	    self.ShowChooser(None, self.Open, 'iPod Photo Database', 'Photo Database', False, self.prefs['path_lastphotodb'])

    def ToSave(self, unsaved=True):
        """ Mark the Photo Database to be saved, new changes are happened. """
        if unsaved:
            self.tosave = True
	    if self.window.get_title()[0] != '*':  # Already marked as unsaved, thus we avoid multiple alterisks! ;-)
                self.window.set_title('*%s' % self.window.get_title())
	    self.win.get_widget('save1').set_sensitive(True)
	    self.win.get_widget('savebutton').set_sensitive(True)
	else:
            self.tosave = False
	    self.window.set_title(self.window.get_title()[1:])
	    self.win.get_widget('save1').set_sensitive(False)
	    self.win.get_widget('savebutton').set_sensitive(False)

    def Open(self, widget):  # To be called from signal of the file chooser
        """ Let select the Photo Database by file selection """
        filename = self.filechooser.get_filename()
	self.filechooser.destroy()
        self.DBOpen(filename)

    def CreateNew(self, widget):
        """ Create a new Photo Database from scratch, after got the iPod mountpoint from the user """
	mountpoint = self.filechooser.get_filename()
	self.filechooser.destroy()
	filename = os.path.join(mountpoint, 'Photos', 'Photo Database')
	self.DBOpen(filename)
        self.DB.dbcopyfullres = self.prefs['photo_copyfullres']

    def CheckIpodModel(self, photodb_filename):
        """ Check for a supported iPod model """
	ipod_mountpoint = photodb_filename.replace(os.path.join('', 'Photos', 'Photo Database'), '') 
	self.ipod_model = getIpodModel(ipod_mountpoint)
	if self.ipod_model == '5G' or self.ipod_model == 'Photo':
	    pass
        elif self.ipod_model == 'Nano':
            self.win.get_widget('expander1label').set_markup(_('<b>Fullscreen iPod image</b>'))
            self.win.get_widget('expander2label').set_markup(_('<b>Small iPod thumbnail</b>'))
            self.win.get_widget('expander3').hide()
            self.win.get_widget('expander4').hide()
	elif self.ipod_model == 'Color':
	    self.Say(_('You are using an <b>iPod %s</b>. Your model is considered as an iPod Photo and nothing is guaranteed to work.') % self.ipod_model,
	             _('<b>Create backups before.</b> You have been warned! And please, report your feedback!'), gtk.MESSAGE_WARNING)
        else:
	    self.Say(_('You are using an <b>iPod %s</b>. Please <b>quit now</b>: your model is not supported, and it never will be.') % self.ipod_model,
	             _('It does not have a color screen and it does not support photos!'), gtk.MESSAGE_ERROR)
	    if self.Ask(_('<b>Quit now?</b>')):
	        gtk.main_quit()
		sys.exit()

    def ToggleProgress(self):
        """ Show/hide progress bar and related label at the bottom of the main window """
        if self.progressbar.get_property('visible'):
            self.progressbar.hide()
            self.progresslabel.hide()
        else:
            self.progressbar.show()
            self.progresslabel.show()

    def PauseProgress(self, widget):
        """ Temporarily stop work managed by the progressbar after clicked the (therefore available) pause button, to continue saving later """
        self.work_left = False
        self.progresspausebutton.set_sensitive(False)
        self.progresspausebutton.hide()
        self.progressstopbutton.set_sensitive(False)
        self.progressstopbutton.hide()
        self.ToggleProgress()
        self.SetSensitive(('treeview1', 'open1', 'openbutton', 'addalbum1', 'addalbumbutton', 'cleancache1', 'rescue_database1', 'save1', 'savebutton'), True)

    def StopProgress(self, widget):
        """ Stop completely the work managed by the progressbar, after clicked the stop button, and save the Photo Database at the current status """
        self.work_left = False
        self.photos_to_add = []
        self.photos_to_delete = []
        self.albums_to_add = []
        self.albums_to_delete = []
        self.albums_to_rename = []
        self.fullres_to_add = []
        self.fullres_to_delete = []
        self.references_to_add = []
        self.references_photo_to_delete = []
        self.references_album_to_delete = []
        self.SaveDB()

    def Kill(self, signal_no, stack):
        """ React to SIGTERM saving the Photo Database before quitting. """
        if self.tosave and self.DB != None:
            print _("Interruption requested. Please wait while saving at the current status...")
            self.work_left = False
            self.Rescue(None)
            self.SaveDB(False)
        gtk.main_quit()

    def DBOpen(self, filename):
        """ Actually open the Photo Database and process it """
	self.CheckIpodModel(filename)
	# The while loop is needed to update the GTK widgets.
	# The GTK interface is event-driven, so functions and code from outside the mainloop
	# will prevent to properly update widgets.
	# The while loop below together with another one, "while gtk.events_pending()" and 
	# the initialization of another gtk.main_iteration() seems to solve everything.
        self.syncfn = os.path.join(self.preferencesdir, 'sync')
        try:
            syncf = open(self.syncfn)
            self.sync = list(cPickle.load(syncf))
            syncf.close()
        except:
            self.sync = []
	self.work_left = True
        while self.work_left:
            self.statusbar.push(self.statusbar_context, _('Opening %s...') % filename)
	    self.ToggleProgress()
	    self.progresslabel.set_text(_('Opening Photo Database... It could take several minutes, depending on its size!'))
	    while gtk.events_pending():
	        gtk.main_iteration()
	    self.DB = MH(filename, self.prefs['path_thumbscache'], False, ipodmodel=self.prefs['ipod_model'])  # Delay opening, to control progress
            thopen = Thread(target=self.DB.Open)
            thopen.start()  # Actually opening and processing Photo Database
            while thopen.isAlive():
                self.progressbar.set_fraction(self.DB.progress)
                while gtk.events_pending():
                    gtk.main_iteration()
	    self.progressbar.set_fraction(0.5)
	    while gtk.events_pending():
	        gtk.main_iteration()
            # Creating initial converted thumbs directories
            self.converted_thumbs_dir = os.path.join(self.DB.dbdir, '.ConvertedThumbs')
            if not os.path.isdir(self.converted_thumbs_dir):
                os.mkdir(self.converted_thumbs_dir)
            for convthumb in self.DB.thumbsizes:
                if not os.path.isdir(os.path.join(self.converted_thumbs_dir, '%sx%s' % (convthumb[0], convthumb[1]))):
                    os.mkdir(os.path.join(self.converted_thumbs_dir, '%sx%s' % (convthumb[0], convthumb[1])))
            self.progressbar.set_fraction(0.7)
            while gtk.events_pending():
                gtk.main_iteration()
            # If database is empty with no photos yet, getting copy / not copy full resolution image option from preferences
            if len(self.DB.Photos()) == 0:
                self.DB.dbcopyfullres = self.prefs['photo_copyfullres']
            self.progressbar.set_fraction(0.8)
            while gtk.events_pending():
                gtk.main_iteration()
            # Updating GUI
	    if len(self.treeview.get_columns()) == 2:
     	        self.treeview.remove_column(self.columnpx)
                self.treeview.remove_column(self.column)
            elif len(self.treeview.get_columns()) == 1:
                self.treeview.remove_column(self.column)
	    self.Populate()
	    self.window.set_title('%s - GPixPod' % filename)
            self.SetSensitive(('addalbum1', 'addalbumbutton', 'new_album_from_unreferenced_photos1', 'cleancache1', 'rescue_database1', 'list_previews1'), True)
	    self.progressbar.set_fraction(1)
	    while gtk.events_pending():
	        gtk.main_iteration()
            self.ToggleProgress()
            self.statusbar.push(self.statusbar_context, _('Photo Database %s opened.') % filename)
	    while gtk.events_pending():
	        gtk.main_iteration()
	    self.work_left = False
	self.prefs['path_lastphotodb'] = self.DB.dbdir  # Remembering the directory of the last opened Photo Database

    def Save(self, widget):
        """ Save the changes to the Photo Database """
	# The while loop is needed to update the GTK widgets.
	# The GTK interface is event-driven, so functions and code from outside the mainloop
	# will prevent to properly update widgets.
	# The while loop below together with another one, "while gtk.events_pending()" and 
	# the initialization of another gtk.main_iteration() seems to solve everything.	
        self.work_left = True
	while self.work_left:
	    self.ToggleProgress()
	    self.SetSensitive(('treeview1', 'open1', 'openbutton', 'save1', 'savebutton', 'addalbum1', 'addalbumbutton', 'addphoto1', 'addphotobutton', 'delete1', 'deletebutton', 'new_album_from_unreferenced_photos1', 'cleancache1', 'rescue_database1'), False)
            self.progresspausebutton.show()
            self.progresspausebutton.set_sensitive(True)
            self.progressstopbutton.show()
            self.progressstopbutton.set_sensitive(True)
            if len(self.photos_to_delete) > 0 or len(self.albums_to_delete) > 0:
                self.DB.RemoveThumbsCache(os.path.join(self.DB.dbdir, '.ConvertedThumbs'))
            fullres_to_add_len = len(self.fullres_to_add)
            self.progresslabel.set_text(_('Adding full resolution images to photos...'))
            self.progressbar.set_fraction(0)
            while gtk.events_pending():
                gtk.main_iteration()
            for x in range(fullres_to_add_len):
                if not self.work_left:
                    break
                fullres_to_add_item = self.fullres_to_add.pop(0)
                self.sync.append(fullres_to_add_item[0])
                self.DB.AddFullResolutionToPhoto(*fullres_to_add_item)
                self.progressbar.set_fraction((x + 1.0)/fullres_to_add_len)
                while gtk.events_pending():
                    gtk.main_iteration()
            #self.fullres_to_add = []  # Reset
            if not self.work_left:
                break
            fullres_to_delete_len = len(self.fullres_to_delete)
            self.progresslabel.set_text(_('Deleting full resolution images from photos...'))
            self.progressbar.set_fraction(0)
            while gtk.events_pending():
                gtk.main_iteration()
            for x in range(fullres_to_delete_len):
                if not self.work_left:
                    break
                fullres_to_delete_item = self.fullres_to_delete.pop(0)
                if fullres_to_delete_item in self.sync:
                    self.sync.remove(fullres_to_delete_item)
                self.DB.RemoveFullResolutionFromPhoto(fullres_to_delete_item)
                self.progressbar.set_fraction((x + 1.0)/fullres_to_delete_len)
                while gtk.events_pending():
                    gtk.main_iteration()
            #self.fullres_to_delete = []  # Reset
            if not self.work_left:
                break
	    albums_to_add_len = len(self.albums_to_add)
	    self.progresslabel.set_text(_('Adding albums...'))
            self.progressbar.set_fraction(0)
            while gtk.events_pending():
	        gtk.main_iteration()
	    for x in range(albums_to_add_len):  # Adding photo albums
                if not self.work_left:
                    break
	        self.DB.AddAlbum(self.albums_to_add.pop(0))
	        self.progressbar.set_fraction((x + 1.0)/albums_to_add_len)
	        while gtk.events_pending():
	            gtk.main_iteration()
	    #self.albums_to_add = []  # Reset
            if not self.work_left:
                break
            references_to_add_len = len(self.references_to_add)
            self.progresslabel.set_text(_('Adding photo references...'))
            self.progressbar.set_fraction(0)
            while gtk.events_pending():
                gtk.main_iteration()
            for x in range(references_to_add_len):
                if not self.work_left:
                    break
                self.DB.AddPhotoToAlbum(*self.references_to_add.pop(0))
                self.progressbar.set_fraction((x + 1.0)/references_to_add_len)
                while gtk.events_pending():
                    gtk.main_iteration()
            if not self.work_left:
                break
	    albums_to_rename_len = len(self.albums_to_rename)
	    self.progresslabel.set_text(_('Renaming albums...'))
	    while gtk.events_pending():
	        gtk.main_iteration()
            for x in range(albums_to_rename_len):  # Renaming photo albums
                if not self.work_left:
                    break
	        self.DB.RenameAlbum(*self.albums_to_rename.pop(0))
	        self.progressbar.set_fraction((x + 1.0)/albums_to_rename_len)
	        while gtk.events_pending():
	            gtk.main_iteration()
	    #self.albums_to_rename = []  # Reset
            if not self.work_left:
                break
	    photos_to_add_len = len(self.photos_to_add)
	    self.progresslabel.set_text(_('Adding photos...'))
	    self.progressbar.set_fraction(0)
	    while gtk.events_pending():
	        gtk.main_iteration()
	    for x in range(photos_to_add_len):  # Adding photos
                if not self.work_left:
                    break
                photo_to_add = self.photos_to_add.pop(0)
                self.sync.append(photo_to_add)
	        self.DB.AddPhoto(*photo_to_add)
	        self.progressbar.set_fraction((x + 1.0)/photos_to_add_len)
		self.progressbar.set_text(_('%s of %s - %s%%') % (x+1, photos_to_add_len, 100*(x+1)/photos_to_add_len))
	        while gtk.events_pending():
	            gtk.main_iteration()
	    #self.photos_to_add = []  # Reset
            if not self.work_left:
                break
            references_photo_to_delete_len = len(self.references_photo_to_delete)
            self.progresslabel.set_text(_('Deleting photo references...'))
            self.progressbar.set_fraction(0)
            while gtk.events_pending():
                gtk.main_iteration()
            for x in range(references_photo_to_delete_len):
                if not self.work_left:
                    break
                self.DB.RemovePhotoFromAlbum(*self.references_photo_to_delete.pop(0))
                self.progressbar.set_fraction((x + 1.0)/references_photo_to_delete_len)
                while gtk.events_pending():
                    gtk.main_iteration()
            if not self.work_left:
                break
            references_album_to_delete_len = len(self.references_album_to_delete)
            self.progresslabel.set_text(_('Deleting whole photo album references...'))
            self.progressbar.set_fraction(0)
            while gtk.events_pending():
                gtk.main_iteration()
            for x in range(references_album_to_delete_len):
                if not self.work_left:
                    break
                self.DB.RemoveAlbum(self.references_album_to_delete.pop(0))
                self.progressbar.set_fraction((x + 1.0)/references_album_to_delete_len)
                while gtk.events_pending():
                    gtk.main_iteration()
            if not self.work_left:
                break
	    photos_to_delete_len = len(self.photos_to_delete)
	    self.progresslabel.set_text(_('Deleting photos...'))
	    self.progressbar.set_fraction(0)
	    while gtk.events_pending():
	        gtk.main_iteration()
	    for x in range(photos_to_delete_len):  # Deleting photos
                if not self.work_left:
                    break
                photo_to_delete = self.photos_to_delete.pop(0)
                if photo_to_delete in self.sync:
                    self.sync.remove(photo_to_delete)
	        self.DB.RemovePhoto(photo_to_delete)
	        self.progressbar.set_fraction((x + 1.0)/photos_to_delete_len)
		self.progressbar.set_text(_('%s of %s - %s%%') % (x+1, photos_to_delete_len, 100*(x+1)/photos_to_delete_len))
	        while gtk.events_pending():
	            gtk.main_iteration()
	    #self.photos_to_delete = []  # Reset
            if not self.work_left:
                break
	    albums_to_delete_len = len(self.albums_to_delete)
	    self.progresslabel.set_text(_('Deleting albums...'))
	    self.progressbar.set_fraction(0)
	    while gtk.events_pending():
	        gtk.main_iteration()
	    for x in range(albums_to_delete_len):  # Deleting photo albums
                if not self.work_left:
                    break
	        self.DB.RemoveAlbumAndPhotos(self.albums_to_delete.pop(0))
	        self.progressbar.set_fraction((x + 1.0)/albums_to_delete_len)
		self.progressbar.set_text(_('%s of %s - %s%%') % (x+1, albums_to_delete_len, 100*(x+1)/albums_to_delete_len))
	        while gtk.events_pending():
	            gtk.main_iteration()
	    #self.albums_to_delete = []  # Reset
            if not self.work_left:
                break
            self.SaveDB()

    def SaveDB(self, reopen=True):
        """ Finish the saving process actually saving the Photo Database and re-opening it """
        try:
            # Saving Photo Database procedure
            self.progresspausebutton.set_sensitive(False)
            self.progresspausebutton.hide()
            self.progressstopbutton.set_sensitive(False)
            self.progressstopbutton.hide()
	    self.progresslabel.set_text(_('Saving Photo Database...'))
	    self.progressbar.set_text(_('Please wait... (it could take several minutes!)'))
	    while gtk.events_pending():
	        gtk.main_iteration()
            self.DB.progress = 0.0
            thsave = Thread(target=self.DB.Save)
            thsave.start()  # Actually saving the new-generated Photo Database file
            while thsave.isAlive():
                self.progressbar.set_fraction(self.DB.progress)
                while gtk.events_pending():
                    gtk.main_iteration()
	    self.ToSave(False)  # Marking as saved
	    self.statusbar.push(self.statusbar_context, _('Photo Database saved.'))
            self.sync = set(self.sync)
            syncf = open(self.syncfn, 'w+')
            cPickle.dump(self.sync, syncf)
            syncf.close()
            if reopen:
                self.DBOpen(self.DB.dbname)  # Re-opening the Photo Database to let user eventually continue work
       	        self.SetSensitive(('treeview1', 'open1', 'openbutton', 'addalbum1', 'addalbumbutton', 'cleancache1', 'rescue_database1', 'new_album_from_unreferenced_photos1'), True)
	    self.ToggleProgress()
	    while gtk.events_pending():
	        gtk.main_iteration()
	    self.work_left = False
        except KeyboardInterrupt:
            pass

    def GetDBLists(self):  # Probably not very useful. Maybe to delete, after merging in Populate() and checking all other possible dependencies.
        """ Refresh list variables for photo albums and photos """
        self.albums = self.DB.Albums()
	self.photos = self.DB.Photos()

    def Populate(self):
        """ Fill the tree view with the Photo Database contents """
        self.tree = gtk.TreeStore(gtk.gdk.Pixbuf, gobject.TYPE_STRING)
	self.GetDBLists()
	for album in self.albums[1:]:
	    albumroot = self.tree.append(None, [None, '<b>%s</b>' % album.name])
	    for pic in album.pics:
                if len(self.photos) <= (pic-100) or self.photos[pic-100].fullres == None:
                    fullresname = _('<i>No full resolution image</i>')
                else:
                    fullresname = self.photos[pic-100].fullres.split(':')[-1]
	        self.tree.append(albumroot, [None, '%s. %s' % (str(pic), fullresname)])
	self.treeview.set_model(self.tree)
	self.cell = gtk.CellRendererText()
	#self.cell.set_property('editable', True)
	#self.cell.connect('edited', self.Rename)
	self.column = gtk.TreeViewColumn(_('Photo Albums'), self.cell, markup=1)
        self.cellpx = gtk.CellRendererPixbuf()
        #self.cell2.set_property('stock-id', gtk.STOCK_ABOUT);
        self.columnpx = gtk.TreeViewColumn(_('Previews'), self.cellpx, pixbuf=0)
	self.treeview.append_column(self.columnpx)
        self.treeview.append_column(self.column)
	# Enable Drag & Drop (DND) for the treeview
	targets = [('text/plain', 1, 1),
                   ('TEXT', 1, 2),
                   ('STRING', 1, 3)]
# Drag outside not working and not so much useful: to delete
#        targets2 = gtk.target_list_add_image_targets()
#        targets2 = gtk.target_list_add_text_targets(targets2)
#   	 self.treeview.enable_model_drag_source(gtk.gdk.BUTTON1_MASK, targets2, gtk.gdk.ACTION_COPY)
        self.treeview.enable_model_drag_dest(targets, gtk.gdk.ACTION_COPY)
#        self.treeview.connect("drag_data_get", self.TreeviewDrag)
        self.treeview.connect("drag_data_received", self.TreeviewDrop)
        self.win.get_widget('list_previews1').set_active(self.prefs['gui_treeviewpreviews'])

    def PopulateIcons(self):
        """ Populate left-side list thumbnails previews icons """
        if self.photoalbumicon:
            albumpx = gtk.gdk.pixbuf_new_from_file_at_size(self.photoalbumicon, 48, 48)
        else:
            albumpx = None
        a = 0
        for album in self.albums[1:]:
            self.tree.set_value(self.tree.get_iter((a,)), 0, albumpx)
            p = 0
            for pic in album.pics:
                convthumb = os.path.join(self.DB.dbdir, '.ConvertedThumbs', '%sx%s' % (self.DB.thumbsizes[-1][0], self.DB.thumbsizes[-1][1]), '%s.png' % str(pic))
                if not os.path.isfile(convthumb):
                    thumb = os.path.join(self.DB.sglthumbsdir, '%sx%s' % (self.DB.thumbsizes[-1][0], self.DB.thumbsizes[-1][1]), str(pic))
                    thumbf = open(thumb)
                    thumbcon = thumbf.read()
                    thumbf.close()
                    imgconvert.fromRGB565(thumbcon, self.DB.thumbsizes[-1][0], self.DB.thumbsizes[-1][1], True, False, convthumb)
                self.tree.set_value(self.tree.get_iter((a, p)), 0, gtk.gdk.pixbuf_new_from_file(convthumb))
                while gtk.events_pending():
                    gtk.main_iteration()
                p += 1
            a += 1

    def DestroyIcons(self):
        """ Destroy left-side list thumbnails previews icons """
        a = 0
        for album in self.albums[1:]:
            self.tree.set_value(self.tree.get_iter((a,)), 0, None)
            p = 0
            for pic in album.pics:
                self.tree.set_value(self.tree.get_iter((a, p)), 0, None)
                while gtk.events_pending():
                    gtk.main_iteration()
                p += 1
            a += 1

    def TogglePreviews(self, widget):
        """ Toggle left-side list previews """
        self.prefs['gui_treeviewpreviews'] = self.win.get_widget('list_previews1').get_active()
        if self.prefs['gui_treeviewpreviews']:
            if len(self.treeview.get_columns()) == 1:
                self.treeview.insert_column(self.columnpx, 0)
            self.PopulateIcons()
        else:
            self.DestroyIcons()
            if len(self.treeview.get_columns()) == 2:
                self.treeview.remove_column(self.columnpx)

    def ToggleToolbar(self, widget):
        """ Toggle the toolbar """
        self.prefs['gui_toolbar'] = self.win.get_widget('toolbar2').get_active()
        if self.prefs['gui_toolbar']:
            self.win.get_widget('toolbar1').show()
        else:
            self.win.get_widget('toolbar1').hide()

    def ToggleDetails(self, widget):
        """ Toggle right-side details pane """
        self.prefs['gui_detailspane'] = self.win.get_widget('details_pane1').get_active()
        if self.prefs['gui_detailspane']:
            self.win.get_widget('notebook1').show()
            self.Details(None)
        else:
            self.win.get_widget('notebook1').hide()

    def Details(self, widget): #, path, column):
        """ React to single-click on the tree view, displaying the details if a photo is selected. """
	self.ShowActions(None)
        self.win.get_widget('remove_full_resolution').set_sensitive(False)
        self.win.get_widget('add_full_resolution').set_sensitive(False)
        self.win.get_widget('delete_reference1').set_sensitive(False)
        item_selected = self.treeview.get_selection().get_selected()[1]
        path = self.tree.get_path(item_selected)
        if self.win.get_widget('details_pane1').get_active():
            self.ClearDetails()
            if len(path) > 1:  # We are interacting with an image.
                self.SetSensitive(('expander1', 'expander2', 'expander3', 'expander4'), True)
                self.imagehbox.show()
	        album = None
	        if len(self.albums) > (path[0]+1):
	            album = self.albums[path[0]+1]
	        if album != None and len(album.pics) > path[1] and self.photos_to_add.count(album.pics[path[1]]) == 0 and self.photos_to_delete.count(album.pics[path[1]]) == 0:
	            # Not added now, the image was already there; neither deleted.
                    self.current_photo_id = album.pics[path[1]]
                    self.win.get_widget('delete_reference1').set_sensitive(True)  # Do deleting reference possible, since image is already stored.
                    if self.DB.HasFullResolution(self.current_photo_id):
                        self.notebook.set_current_page(1)
	                #fullres = '%s' % self.photos[album.pics[path[1]]-100].fullres.replace('\000', '')  # Removing null characters
                        fullres = u"%s" % self.photos[album.pics[path[1]]-100].fullres
                        fullres = fullres.encode('utf-8')
	                photofile = os.path.join(self.DB.dbdir, *fullres.split(':')[1:])  # Converting from iPod (Mac) relative path to absolute native path
	                self.ShowImage(photofile, path[0]+1, album.pics[path[1]])
                        if self.fullres_to_delete.count(self.current_photo_id) == 0:
	                    self.win.get_widget('remove_full_resolution').set_sensitive(True)
                    else:
                        self.label.set_markup(_('<i>No full resolution image</i>'))
                        self.notebook.set_current_page(2)
                        self.win.get_widget('label4').set_sensitive(False)
                        self.win.get_widget('expander1').emit('activate')
                        fullres_add_sensitive = True
                        for fullres_addition in self.fullres_to_add:
                            if fullres_addition[1] == self.current_photo_id:
	                        fullres_add_sensitive = False
                                break
                        self.win.get_widget('add_full_resolution').set_sensitive(fullres_add_sensitive)
                else:  # The image has been just added
		    itemtext = self.tree[(path[0], path[1])][1]
		    itemdot = itemtext.find('.')
		    for new_photo in self.photos_to_add:
		        if new_photo[1] == (path[0]+1) and os.path.basename(new_photo[0]) == itemtext[itemdot+2:]:
		            self.ShowImage(new_photo[0], path[0]+1, itemtext[:itemdot], False)
		            self.current_photo_id = None  # Thumbnails do not exist yet
			    break
		    #self.label.set_text(_('Image has been just added. Its details will be available after saved.'))
	    elif len(path) == 1:  # We are interacting with an album.
                self.notebook.set_current_page(0)
                self.ShowAlbum(path[0]+1)
        if len(path) > 1:
            self.win.get_widget('rename_album1').set_sensitive(False)
        elif len(path) == 1:
            self.win.get_widget('rename_album1').set_sensitive(True)
            self.win.get_widget('delete_reference1').set_sensitive(True)
	    if self.treeview.row_expanded(path):  # The album row is already expanded, so we collapse it.
	        self.treeview.collapse_row(path)
            else:
	        self.treeview.expand_to_path(path)

    def ShowAlbum(self, album_id):
        """ Show album details in the proper (first) notebook page """
        album_iter = self.tree.get_iter((album_id-1,))
        album_name = self.tree.get_value(album_iter, 1)
        album_n_pics = self.tree.iter_n_children(album_iter)
        if album_id >= len(self.albums):
            statuscolor = '#990000'
            statusname = _('To be created')
        else:
            statuscolor = '#009900'
            statusname = _('Available')
        self.win.get_widget('detailsphotoalbumlabel').set_markup(_('Photo Album:\t\t<b>%s</b>\nPhoto Album ID:\t<b>%s</b>\nNumber of photos:\t<b>%s</b>\nStatus:\t\t<b><span foreground="%s">%s</span></b>') %
                                                                 (album_name, album_id, album_n_pics, statuscolor, statusname))

    def ShowImage(self, photofile, album_id, photo_id, saved=True):
        """ Show image in the details pane on the right """
        self.ShowAlbum(album_id)
	if os.path.isfile(photofile):
	    self.details_photofile = photofile
	    self.savefilename = os.path.basename(photofile)
	    self.SetSensitive(('spinbutton1', 'saveimagebutton'), True)
            pixbuf = gtk.gdk.pixbuf_new_from_file(photofile)
            width = pixbuf.get_width()
            height = pixbuf.get_height()
            if saved:
                imgstatuscolor = '#009900'
	        imgstatusname = _('Saved')
	    else:
	        imgstatuscolor = '#990000'
	        imgstatusname = _('Not saved yet')
            self.label.set_markup(_('Photo Album: <b>%s</b> \nPhoto ID: <b>%s</b> \nPhoto path: <b>%s</b> \nOriginal size: <b>%sx%s</b> \nStatus: <b><span foreground="%s">%s</span></b>') % 
                                  (self.albums[album_id].name, photo_id, photofile, width, height, imgstatuscolor, imgstatusname))
	    win_width, win_height = self.window.get_size()
            ratio_width, ratio_height = getRatioSize(width, height, win_width-316, win_height-196)
            pixbuf = pixbuf.scale_simple(ratio_width, ratio_height, gtk.gdk.INTERP_BILINEAR)  # To update, offering the possibility to change the zoom level
            self.image.set_from_pixbuf(pixbuf)
	    self.spinbutton.set_value(ratio_width*100/width)
            #self.current_album = path[0]+1
	else:
	    self.details_photofile = self.savefilename = None
	    self.ClearDetails()
	    self.label.set_text(_('Full resolution photo not found. Maybe have you deleted it?'))

    def SaveImage(self, widget):
        """ Save the image currently displayed in the details pane on the right """
	if self.details_photofile != None:
	    photosavename = self.filechooser.get_filename()
	    self.filechooser.destroy()
	    shutil.copy(self.details_photofile, photosavename)
	    self.prefs['path_lastsavedimages'] = os.path.dirname(photosavename)

    def ZoomImage(self, widget):
        """ Change the zoom of the image currently displayed in the details pane on the right """
	if self.details_photofile != None:
            while gtk.events_pending():
                gtk.main_iteration()
	    pixbuf = gtk.gdk.pixbuf_new_from_file(self.details_photofile)
	    new_width = int(pixbuf.get_width()*self.spinbutton.get_value()/100)
	    new_height = int(pixbuf.get_height()*self.spinbutton.get_value()/100)
	    pixbuf = pixbuf.scale_simple(new_width, new_height, gtk.gdk.INTERP_BILINEAR)
	    self.image.set_from_pixbuf(pixbuf)
            while gtk.events_pending():
                gtk.main_iteration()

    def DetailsDoubleClick(self, widget, path, column):
        """ React to double-click on the tree view, asking to rename if a photo album is selected. """
	if len(path) == 1:  # The double-click occurred on an album
            self.ShowRenameAlbum(None)

    def ShowRenameAlbum(self, widget):
        """ Show the dialog to rename a photo album """
        path = self.GetCurrentTVPath()
	self.ShowGetLine(None, self.RenameAlbum, _('Rename photo album'), _('Enter the new name for the album "%s"') % self.tree[(path[0],)][1], 
	                 self.tree[(path[0],)][1][3:-4])
   
    def ClearDetails(self):
        """ Clear the displayed photo details (right pane) with default values """
	self.image.set_from_pixbuf(None)
	self.label.set_text('')
        self.CollapseThumbnails()
	self.SetSensitive(('spinbutton1', 'saveimagebutton', 'expander1', 'expander2', 'expander3', 'expander4'), False)

    def NotebookPage(self, widget, page, page_num):
        """ Manage page switching on the notebook (details pane on the right) """
        if page_num == 1:  # Then we are processing the thumbnails page
            pass
#            self.win.get_widget('expander1').emit('activate')
#            if self.current_photo_id != None and self.current_photo_id > 0:
#                thumbs = []
#                convthumbs = []
#                for thumb in self.DB.thumbsizes:
#                    thumbs.append(os.path.join(self.DB.dbdir, '.SingleThumbs', '%sx%s' % (thumb[0], thumb[1]), str(self.current_photo_id)))
#                    convthumbs.append(os.path.join(self.DB.dbdir, '.ConvertedThumbs', '%sx%s' % (thumb[0], thumb[1]), '%s.png' % str(self.current_photo_id)))
#                if not os.path.isfile(convthumbs[0]):
#                    while gtk.events_pending():
#                        gtk.main_iteration()
#                    fromInterlacedUYVY(thumbs[0], convthumbs[0])
#                    while gtk.events_pending():
#                        gtk.main_iteration()
#                self.imageipodthumb0.set_from_file(convthumbs[0])
#                for thumbx in (1, 2, 3):
#                    if not os.path.isfile(convthumbs[thumbx]):
#                        while gtk.events_pending():
#                            gtk.main_iteration()
#                        fromRGB565(thumbs[thumbx], self.DB.thumbsizes[thumbx][0], self.DB.thumbsizes[thumbx][1], savefilename=convthumbs[thumbx])
#                        while gtk.events_pending():
#                            gtk.main_iteration()
#                    self.win.get_widget('imageipodthumb%s' % thumbx).set_from_file(convthumbs[thumbx])
#                self.current_photo_id = None
                   
    def ExpandThumbnail(self, widget, thumb_index):
        """ Expand and display the thumbnail with the specified index in the second page of the right pane """
        # FIXME: Image is set every time, a way should be found to avoid setting again if already set
        expander = self.win.get_widget('expander%s' % (thumb_index+1))
        gdkwin = widget.window
        if expander.get_expanded() == False and self.current_photo_id != None and self.current_photo_id > 0:
            gdkwin.set_cursor(gtk.gdk.Cursor(gtk.gdk.WATCH))
            thumb = os.path.join(self.DB.sglthumbsdir, '%sx%s' % (self.DB.thumbsizes[thumb_index][0], self.DB.thumbsizes[thumb_index][1]), str(self.current_photo_id))
            convthumb = os.path.join(self.DB.dbdir, '.ConvertedThumbs', '%sx%s' % (self.DB.thumbsizes[thumb_index][0], self.DB.thumbsizes[thumb_index][1]), '%s.png' % 
                                     str(self.current_photo_id))
            thumbf = open(thumb)
            thumbcon = thumbf.read()
            thumbf.close()
            if thumb_index == 0 and self.ipod_model != 'Nano':
                if not os.path.isfile(convthumb):
                    while gtk.events_pending():
                        gtk.main_iteration()
                    #fromInterlacedUYVY(thumb, convthumb)
                    imgconvert.fromInterlacedUYVY(thumbcon, convthumb)
                    while gtk.events_pending():
                        gtk.main_iteration()
                self.imageipodthumb0.set_from_file(convthumb)
            else:
                if not os.path.isfile(convthumb):
                    while gtk.events_pending():
                        gtk.main_iteration()
                    if thumb_index == 0 and self.ipod_model == 'Nano':
                        #fromRGB565(thumb, self.DB.thumbsizes[thumb_index][0], self.DB.thumbsizes[thumb_index][1], False, savefilename=convthumb)
                        imgconvert.fromRGB565(thumbcon, self.DB.thumbsizes[thumb_index][0], self.DB.thumbsizes[thumb_index][1], False, True, convthumb)
                    elif thumb_index == 1 and (self.ipod_model == 'Photo' or self.ipod_model == 'Color'):
                        #fromRGB565(thumb, self.DB.thumbsizes[thumb_index][1], self.DB.thumbsizes[thumb_index][0], True, True, savefilename=convthumb)
                        imgconvert.fromRGB565(thumbcon, self.DB.thumbsizes[thumb_index][0], self.DB.thumbsizes[thumb_index][1], True, True, convthumb)
                    else:
                        #fromRGB565(thumb, self.DB.thumbsizes[thumb_index][0], self.DB.thumbsizes[thumb_index][1], savefilename=convthumb)
                        imgconvert.fromRGB565(thumbcon, self.DB.thumbsizes[thumb_index][0], self.DB.thumbsizes[thumb_index][1], True, False, convthumb)
                    while gtk.events_pending():
                        gtk.main_iteration()
                self.win.get_widget('imageipodthumb%s' % thumb_index).set_from_file(convthumb)
            gdkwin.set_cursor(None)

    def CollapseThumbnails(self):
        """ Collapse all the thumbnails expanders and reset their images """
        self.win.get_widget('expander1').set_expanded(False)
        self.win.get_widget('expander2').set_expanded(False)
        self.win.get_widget('expander3').set_expanded(False)
        self.win.get_widget('expander4').set_expanded(False)
        self.imageipodthumb0.set_from_file(None)
        self.imageipodthumb1.set_from_file(None)
        self.imageipodthumb2.set_from_file(None)
        self.imageipodthumb3.set_from_file(None)
 
    def Eject(self, widget):
        """ Eject the connected detected iPod """
        ejecting_i, ejecting_o = os.popen4('eject %s' % self.ipod_mountpoint)
        ejecting_i.close()
        ejecting_result = ejecting_o.read()
        if ejecting_result == 'eject: unable to eject, last error: Invalid argument\n':
            self.Say(_('<b>iPod ejected</b>, but the <i>Do not disconnect</i> message seems to be still shown on the iPod.'), '%s %s' % 
                     (_('To let disappear the message from the iPod, make your <i>eject</i> executable <i>setuid root</i>'),
		      _('(<tt>chmod +s `which eject`</tt> as <i>root</i>)')))
        ejecting_o.close()
    
    def Quit(self, widget):
        """ Manage quitting, asking to save if there are unsaved changes. """
        if self.win.get_widget('save1').get_property('sensitive'):
	    if self.Ask(_('There are changes <b>not</b> saved.'), _('Do you want to save before quit?')):
	        self.Save(None)
	self.WritePreferences()
        if self.DB != None:
            self.DB.RemoveThumbsCache(os.path.join(self.DB.dbdir, '.ConvertedThumbs'))
        gtk.main_quit()

    def ShowGetLine(self, widget, ok_function, title=None, message=None, entrytext=None):
        """ Show a dialog to let enter a new line (e.g. to add a new album, or to renaming an existing one) """
        self.getline = gtk.glade.XML('gpixpod.glade', 'dialog2', 'gpixpod')
	self.getlineinput = self.getline.get_widget('dialog2')
        if self.icon:
	    self.getlineinput.set_icon_from_file(self.icon)
	self.getlineinput.set_default_response(gtk.RESPONSE_OK)
	self.getline_callbacks = {'on_cancelbutton1_clicked':self.DestroyGetLine, 'on_okbutton1_clicked':ok_function}	
	self.getline.signal_autoconnect(self.getline_callbacks)
	if title != None:
	    self.getlineinput.set_title(title)
	if message != None:
	    label = self.getline.get_widget('label2')
	    label.set_markup(message)
	if entrytext != None:
	    entry = self.getline.get_widget('entry1')
	    entry.set_text(entrytext)
	    entry.select_region(0, -1)

    def DestroyGetLine(self, widget):
        """ Actually destroy the GetLine dialog when receiving the destroy signal """
        self.getlineinput.destroy()

    def AddPhotoChooser(self, widget):
        """ Switch AddPhoto (with/without full resolution) action according to the fullres checkbutton """
        if self.chooser.get_widget('fullrescheckbutton').get_active():
            self.AddPhoto(None, None, True)
        else:
            self.AddPhoto(None, None, False)

    def ShowChooser(self, widget, ok_function, filter_name=None, pattern=None, multiple=False, path=None, preview=False, chooser_type=None, title=None):
        """ Show file chooser, to select and open file based on the pattern specified, passing to the specified function """
        self.chooser_callbacks = {'on_button1_clicked':self.DestroyChooser, 'on_button2_clicked':ok_function}
        self.chooser = gtk.glade.XML('gpixpod.glade', 'filechooserdialog1', 'gpixpod')
	self.chooser.signal_autoconnect(self.chooser_callbacks)
	self.filechooser = self.chooser.get_widget('filechooserdialog1')
        if self.icon:
            self.filechooser.set_icon_from_file(self.icon)
	self.filechooser.set_select_multiple(multiple)
	if path != None:
	    self.filechooser.set_current_folder(path)
	if filter_name != None and pattern != None:
	    filter = gtk.FileFilter()
	    filter.set_name(filter_name)
	    if pattern == 'PIXBUF' and chooser_type == None:  # Making sure we are not saving, too!
	        filter.add_pixbuf_formats()
                self.chooser.get_widget('imagebehaviourexpander').show_all()
                self.chooser.get_widget('imagebehaviourexpander').set_sensitive(True)
                self.chooser.get_widget('autorotateexpander').show_all()
                self.chooser.get_widget('autorotateexpander').set_sensitive(True)
                if self.prefs['photo_behaviour'] == 'Zoom':
                    self.chooser.get_widget('imagebehaviour_radiobutton2').set_active(True)
                elif self.prefs['photo_behaviour'] == 'Stretch':
                    self.chooser.get_widget('imagebehaviour_radiobutton3').set_active(True)
                else:
                    self.chooser.get_widget('imagebehaviour_radiobutton1').set_active(True)
                if self.prefs['photo_autorotate'] == 'CW':
                    self.chooser.get_widget('autorotatecwfradiobutton').set_active(True)
                elif self.prefs['photo_autorotate'] == 'CCW':
                    self.chooser.get_widget('autorotateccwfradiobutton').set_active(True)
                else:
                    self.chooser.get_widget('autorotatefradiobutton').set_active(True)
                self.chooser.get_widget('fullrescheckbutton').show()
                self.chooser.get_widget('fullrescheckbutton').set_active(self.DB.dbcopyfullres)
                self.chooser.get_widget('fullrescheckbutton').set_sensitive(True)
                self.chooser.get_widget('recursivecheckbutton').show()
                self.chooser.get_widget('recursivecheckbutton').set_sensitive(True)
                self.chooser.get_widget('duplicatescheckbutton').show()
                self.chooser.get_widget('duplicatescheckbutton').set_sensitive(True)
            else:
	        filter.add_pattern(pattern)
	    self.filechooser.add_filter(filter)
	if chooser_type != None:
	    self.filechooser.set_action(chooser_type)
	if chooser_type == gtk.FILE_CHOOSER_ACTION_SAVE:
	    self.filechooser.set_do_overwrite_confirmation(True)
	    if self.savefilename != None:
	        self.filechooser.set_current_name(self.savefilename)
	if title != None:
	    self.filechooser.set_title(title)
	if preview:
	    self.chooser.signal_connect('on_filechooserdialog1_selection_changed', self.ChooserUpdatePreview)
	    self.filechooser_previewbox = gtk.VBox()
	    self.filechooser_previewbox.set_size_request(200, 200)
	    self.filechooser_preview = gtk.Image()
	    self.filechooser_previewlabel = gtk.Label()
	    self.filechooser_previewbox.pack_start(self.filechooser_preview)
	    self.filechooser_previewbox.pack_start(self.filechooser_previewlabel)
	    self.filechooser.set_preview_widget(self.filechooser_previewbox)
	    self.filechooser_previewbox.show_all()

    def ChooserUpdatePreview(self, widget):
        """ Update the preview widget set in the file chooser on change of selection """
	preview_filename = self.filechooser.get_preview_filename()
	if preview_filename != None and os.path.isfile(preview_filename):
	    self.filechooser.set_preview_widget_active(True)
	    pixbuf = gtk.gdk.pixbuf_new_from_file(preview_filename)
	    # Calculating proper width/height with ratio within limits
	    new_width = width = pixbuf.get_width()
	    new_height = height = pixbuf.get_height()
	    max_width = 200
	    max_height = 200
	    if new_width > max_width or new_height > max_height:
	        new_width = max_width
	        new_height = max_width*height/width
 	        if new_height > max_height:
	            new_height = max_height
	            new_width = max_height*width/height
	    pixbuf = pixbuf.scale_simple(new_width, new_height, gtk.gdk.INTERP_TILES)  # INTER_TILES is a bit faster, since quality is not needed here
	    self.filechooser_preview.set_from_pixbuf(pixbuf)
	    preview_info = gtk.gdk.pixbuf_get_file_info(preview_filename)  # a tuple: pixbuf dictionary, width, height
	    preview_stat = os.stat(preview_filename)
	    preview_date = time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(preview_stat[8]))  # Last modified date of the image file
	    preview_size = preview_stat[6]/1024  # Size in Kb
	    self.filechooser_previewlabel.set_markup('<i>%s, %sx%s, %s KB</i>\n%s' % (preview_info[0]['name'], width, height, preview_size, preview_date))
	else:
	    self.filechooser.set_preview_widget_active(False)

    def DestroyChooser(self, widget):
        """ Actually destroy the FileChooser dialog when receiving the destroy signal """
        self.filechooser.destroy()

    def AddAlbum(self, widget, album_name=None):
        """ Add a new album to the tree view, marking to actually add it when saving """
        if album_name == None:
            album_name = self.getline.get_widget('entry1').get_text()
	    self.getlineinput.destroy()
	self.albums_to_add.append(album_name)  # Mark the new album to be added when saving
	#self.GetDBLists()
        if self.photoalbumicon and self.win.get_widget('list_previews1').get_active():
            albumpx = gtk.gdk.pixbuf_new_from_file(self.photoalbumicon)
        else:
            albumpx = None
	self.tree.append(None, [albumpx, '<b>%s</b>' % album_name])  # Adding the new album to the tree view
	self.ToSave()  # Marking as unsaved

    def RenameAlbum(self, widget):
        """ Rename an album in the tree view, marking to actually renaming it when saving """
        new_album_name = self.getline.get_widget('entry1').get_text()
	self.getlineinput.destroy()
	item_selected = self.treeview.get_selection().get_selected()[1]
	path_selected = self.tree.get_path(item_selected)
	self.albums_to_rename.append((path_selected[0]+1, new_album_name))  # Mark the album to be actually renamed when saving
	self.tree.set_value(self.tree.get_iter((path_selected[0],)), 1, '<b>%s</b>' % new_album_name)  # Updating tree view row
	self.ToSave()  # Marking as unsaved

    def GetImageBehaviour(self):
        """ Get selected image behaviour """
        behaviour = 'Fit'
        if self.chooser.get_widget('imagebehaviour_radiobutton2').get_active():
            behaviour = 'Zoom'
        if self.chooser.get_widget('imagebehaviour_radiobutton3').get_active():
            behaviour = 'Stretch'
        return behaviour

    def AddPhoto(self, widget, filenames=None, copyfullres=None):  # Third argument added to let the function being called by DND
        """ Add new photo(s) to the tree view, marking to actually add it/them when saving """
        if copyfullres == True:
            fullreslabel = _(' <i>(with full resolution)</i>')
        elif copyfullres == False:
            fullreslabel = _(' <i>(without full resolution)</i>')
        else:
            copyfullres = self.DB.dbcopyfullres
            fullreslabel = ''
	path = self.GetCurrentTVPath()
	album_selected = self.tree.get_iter((path[0],))  # The parent album is obtained from the first element of the path
	if filenames == None:
	    filenames = self.filechooser.get_filenames()
            behaviour = self.GetImageBehaviour()
            if self.chooser.get_widget('imagebehaviour_radiobutton2').get_active():
                behaviour = 'Zoom'
            if self.chooser.get_widget('imagebehaviour_radiobutton3').get_active():
                behaviour = 'Stretch'
            if self.chooser.get_widget('autorotatecwfradiobutton').get_active():
                autorotate = 'CW'
            elif self.chooser.get_widget('autorotateccwfradiobutton').get_active():
                autorotate = 'CCW'
            else:
                autorotate = None
            if self.chooser.get_widget('recursivecheckbutton').get_active():
                filenames = expand_paths(filenames, True)
            if self.chooser.get_widget('duplicatescheckbutton').get_active():
                filenames2 = []
                for filename in filenames:
                    if filename not in self.sync:
                        filenames2.append(filename)
                filenames = filenames2
            self.filechooser.destroy()
        if len(filenames) > 0:
            self.prefs['path_lastimages'] = os.path.dirname(filenames[-1])  # Remembering last images directory
	    for filename in filenames:
	        if os.path.isfile(filename) and gtk.gdk.pixbuf_get_file_info(filename):
                        self.photos_to_add.append((filename, path[0]+1, copyfullres, behaviour, autorotate))  # Mark the new photo to be actually added when saving
                        new_photo_id = len(self.photos)+99+len(self.photos_to_add)
	                #self.GetDBLists()  # Or completely rePopulate?
		        # Adding the new photo to the tree view
	                self.tree.append(album_selected, [None,
                                                          '%s. %s%s' % (new_photo_id, os.path.basename(filename), fullreslabel)])
	    self.ToSave()  # Marking as unsaved

#    def AddPhotoWithFR(self, widget):
#        """ Add new photo(s) including full resolution image, regardless of the global setting """
#        path = self.GetCurrentTVPath()
#        album_selected = self.tree.get_iter((path[0],))
#        filenames = self.filechooser.get_filenames()
#        behaviour = self.GetImageBehaviour()
#        self.filechooser.destroy()
#        for filename in filenames:
#            if os.path.isfile(filename):
#                self.photos_to_add.append((filename, path[0]+1, True, behaviour))
#                new_photo_id = len(self.photos)+99+len(self.photos_to_add)
#                self.tree.append(album_selected, ['%s <i>(%s)</i>. %s' % (new_photo_id, _('with full resolution'), os.path.basename(filename))])
#        self.ToSave()
#        self.prefs['path_lastimages'] = os.path.dirname(filename)
#
#    def AddPhotoWithoutFR(self, widget):
#        """ Add new photo(s) excluding full resolution image, regardless of the global setting """
#        path = self.GetCurrentTVPath()
#        album_selected = self.tree.get_iter((path[0],))
#        filenames = self.filechooser.get_filenames()
#        behaviour = self.GetImageBehaviour()
#        self.filechooser.destroy()
#        for filename in filenames:
#            if os.path.isfile(filename):
#                self.photos_to_add.append((filename, path[0]+1, False, behaviour))
#                new_photo_id = len(self.photos)+99+len(self.photos_to_add)
#                self.tree.append(album_selected, ['%s <i>(%s)</i>. %s' % (new_photo_id, _('without full resolution'), os.path.basename(filename))])
#        self.ToSave()
#        self.prefs['path_lastimages'] = os.path.dirname(filename)

    def AddReference(self, widget, photo_id=None):
        """ Add a reference to an already existing photo in the currently selected photo album """
        path = self.GetCurrentTVPath()
        album_selected = self.tree.get_iter((path[0],))
        album_id = path[0]+1
        if photo_id == None:
            photo_id = self.getline.get_widget('entry1').get_text()
            self.getlineinput.destroy()
        photo_id = int(photo_id)
        if len(self.photos) > (photo_id-100):
            self.references_to_add.append((photo_id, album_id))
            if self.photos[photo_id-100].fullres == None:
                fullresname = _('<i>No full resolution image</i>')
            else:
                fullresname = self.photos[photo_id-100].fullres.split(':')[-1]
            self.tree.append(album_selected, [None, '%s. %s' % (photo_id, fullresname)])
            self.ToSave()
        else:
            self.Say(_('<b>Not existing photo!</b>'), _('The number is not a valid Photo ID.'), gtk.MESSAGE_WARNING)

    def DeleteReference(self, widget):
        """ Remove the reference related to the currently selected photo, or to all children photos if a photo album is selected instead """
        path = self.GetCurrentTVPath()
        item_selected = self.treeview.get_selection().get_selected()[1]
        if len(path) == 1:
            if self.Ask('<b>%s</b>' % _('Delete all photo album references?'), _('No photos will be deleted, but all the photo album references.')):
                self.references_album_to_delete.append(path[0]+1)
                self.tree.remove(item_selected)
                self.ToSave()
                self.HideActions(None)
                self.ClearDetails()
        elif len(path) > 1:
            self.references_photo_to_delete.append((self.GetCurrentTVPhotoID(), path[0]+1))
            self.tree.remove(item_selected)
            self.ToSave()
            self.HideActions(None)
            self.ClearDetails()

    def GetCurrentTVPath(self):
        """ Get the path of the currently selected item in the treeview """
        item_selected = self.treeview.get_selection().get_selected()[1]
        path = self.tree.get_path(item_selected)
        return path

    def GetCurrentTVText(self):
        """ Get the text of the currently selected item in the treeview """
        path = self.GetCurrentTVPath()
        text = self.tree[(path[0], path[1])][1]
        return text
        
    def SetCurrentTVText(self, text):
        """ Set the specified text on the currently selected item in the treeview """
        path = self.GetCurrentTVPath()
        self.tree[(path[0], path[1])][1] = text

    def GetCurrentTVPhotoID(self):
        """ Get the photo ID from the currently selected item in the treeview """
        text = self.GetCurrentTVText()
        dot = text.find('.')
        return int(text[:dot])

    def AddFullResolution(self, widget):
        """ Add a full resolution image to the current photo """
        filename = self.filechooser.get_filename()
        self.filechooser.destroy()
        photo_id = self.GetCurrentTVPhotoID()
        self.fullres_to_add.append((filename, photo_id))
        self.SetCurrentTVText('%s. %s <i>(%s)</i>' % (photo_id, os.path.basename(filename), _('available after saved')))
        self.win.get_widget('add_full_resolution').set_sensitive(False)
        self.ToSave()

    def RemoveFullResolution(self, widget):
        """ Remove the full resolution image from the current photo """
        if self.Ask('<b>Remove full resolution photo?</b>', 'Are you sure to remove the full resolution image from the currently selected photo?'):
            photo_id = self.GetCurrentTVPhotoID()
            self.fullres_to_delete.append(photo_id)
            self.SetCurrentTVText('%s. <i>%s</i>' % (photo_id, _('Full resolution image will be deleted after saved')))
            self.win.get_widget('remove_full_resolution').set_sensitive(False)
            self.ToSave()

    def Delete(self, widget):
        """ Delete either a photo or a whole album from the tree view, marking to actually delete it when saving """
        item_selected = self.treeview.get_selection().get_selected()[1]
	path_selected = self.tree.get_path(item_selected)
	if len(path_selected) == 1:  # then we are deleting an album
	    if self.Ask(_('Are you sure to delete the whole album?')):
	        self.tree.remove(item_selected)  # Removing the photo album and its children from tree view
	        self.albums_to_delete.append(path_selected[0]+1)  # Marking the album to be deleted
		self.ToSave()  # Marking as unsaved
	else:  # then the request of deletion is for a photo
	    # Getting the photo id from the content of the row of the tree view, the first part (before the first dot, see the row in the GUI)
	    photo_id = int(self.tree.get_value(item_selected, 1).split('.')[0])
	    self.photos_to_delete.append(photo_id)  # Marking the photo to be actually deleted when saving
	    self.tree.remove(item_selected)  # Removing the photo from the tree view
	    self.ToSave()  # Marking as unsaved
	self.ClearDetails()  # We clear the image details (right pane)
	self.HideActions(None)  # After deleting, we lose the selection: thus we should at least hide the related actions.

# not working yet and to delete
#    def TreeviewDrag(self, treeview, context, selection, target_id, etime):
#        """ Manage dragging out from the treeview """
#        treeselection = treeview.get_selection()
#        model, iter = treeselection.get_selected()
#        path = model.get_path(iter)
#        data = model.get_value(iter, 0)
#        #selection.set(selection.target, 8, data)
#        album = self.albums[path[0]+1]
#        fullres = '%s' % self.photos[album.pics[path[1]]-100].fullres.replace('\000', '')  # Removing null characters
#        photofile = os.path.join(self.DB.dbdir, *fullres.split(':')[1:])  # Converting from iPod (Mac) relative path to absolute native path
#        print photofile
#        if os.path.isfile(photofile):
#            pixbuf = gtk.gdk.pixbuf_new_from_file(photofile)
#            selection.set('image/pixbuf', 8, pixbuf)

    def TreeviewDrop(self, treeview, context, x, y, selection, info, etime):
        """ Manage dropping inside the treeview """
        model = treeview.get_model()
        sel = treeview.get_selection()
        data = selection.data
        data = data.replace('file://', '')
        data = data.split()
        drop_info = treeview.get_dest_row_at_pos(x, y)
        if drop_info:
            path, position = drop_info
            sel.select_path(path[:1])
        else:
            sel.select_path((len(model)-1))
        data2 = []
        for filename in data:
            filenamepart, ext = os.path.splitext(filename)
            if re.match('[jJ][pP][eE]?[gG]|[pP][nN][gG]|[sS][vV][gG]|[wW][bB][mM][pP]|[wW][mM][fF]|[bB][mM][pP]|[gG][iI][fF]|[tT][iI][fF][fF]|[xX][pP][mM]', 
	                ext[1:]) != None:
                if gtk.gdk.pixbuf_get_file_info(filename) != None:
                    data2.append(filename)
        if len(data) > 0:
            self.AddPhoto(None, data2)
#        if context.action == gtk.gdk.ACTION_MOVE:
#            context.finish(True, True, etime)
#        return

    def ShowActions(self, widget):
        """ Show "Add Photo" and "Delete" actions (to be called when a treeview item is selected) """
        self.win.get_widget('addphoto1').set_sensitive(True)
	self.win.get_widget('addphotobutton').set_sensitive(True)
	self.win.get_widget('delete1').set_sensitive(True)
	self.win.get_widget('deletebutton').set_sensitive(True)
        self.win.get_widget('add_photo_reference1').set_sensitive(True)
        self.win.get_widget('delete_reference1').set_sensitive(True)
        
    def HideActions(self, widget):
        """ Hide "Add Photo" and "Delete" actions (to be called when no treeview items are selected) """
        self.win.get_widget('addphoto1').set_sensitive(False)
	self.win.get_widget('addphotobutton').set_sensitive(False)
	self.win.get_widget('delete1').set_sensitive(False)
	self.win.get_widget('deletebutton').set_sensitive(False)
        self.win.get_widget('add_photo_reference1').set_sensitive(False)
        self.win.get_widget('delete_reference1').set_sensitive(False)

    def NewAlbumFromUnreferencedPhotos(self, widget):
        """ Generate a new photo album containing all the currently unreferenced (orphaned) photos """
        photos = self.DB.FindLostPhotos()
        if len(photos) > 0:
            self.AddAlbum(None, str(_('Previously unreferenced photos')))
            album_id = len(self.albums)+len(self.albums_to_add)-len(self.albums_to_delete)-1
            self.treeview.get_selection().select_path((album_id-1,))
            for photo_id in photos:
                self.AddReference(None, int(photo_id))
            #if len(self.references_photo_to_delete) > 0:
            #    for photo_id in self.references_photo_to_delete:
            #        self.AddReference(None, photo_id[0])
            #if len(self.references_album_to_delete) > 0:
            #    for album_id in self.references_album_to_delete:
            #        if len(self.albums) > album_id:
            #            for photo_id in self.albums[album_id].pics:
            #                self.AddReference(None, photo_id)
        else:
            self.Say('<b>%s</b>' % _('No unreferenced photos'), _('There are not unreferenced photos. Each existing photo is linked to at least one photo album.'))

    def CleanCache(self, widget):  # More useful for development purposes than for users, maybe to be moved away
        """ Clean the single thumbnails cache """
	if self.Ask(_('<b>Are you sure to remove thumbnails cache?</b>'), '%s%s' %
	            (_('Thumbnails cache is automatically removed when saving, only in rare cases you would remove it manually.\n'),
		     _('It is recommended to <b>cancel</b> right away, unless you know what are you doing.'))):
            self.DB.RemoveThumbsCache()  # Actually removing cache
            self.DB.RemoveThumbsCache(os.path.join(self.DB.dbdir, '.ConvertedThumbs'))  # Removing PNG converted thumbs, too
	    self.win.get_widget('cleancache1').set_sensitive(False)
	    self.Say('<b>%s</b>' % _('Thumbnails cache removed!'))

    def Rescue(self, widget):
        """ Check the database for incongruences and try to fix it """
        dblinescopy = copy.deepcopy(self.DB.dblines)
        self.DB.Rescue()
        if dblinescopy == self.DB.dblines:
            self.StatusBarNotify(_('Nothing has been modified. Photo Database seems in a proper status.'))
        else:
            self.StatusBarNotify(_('Photo Database has been modified. Please save now to complete the rescue.'))
            self.ToSave()

    def ShowIpodInfo(self, widget):
        """ Show the iPod info dialog """
        self.ipodinfo = gtk.glade.XML('gpixpod.glade', 'ipodinfodialog', 'gpixpod')
        self.ipodinfodlg = self.ipodinfo.get_widget('ipodinfodialog')
        self.ipodinfo.signal_connect('on_ipodinfookbutton_clicked', self.DestroyIpodInfo)
        if self.ipodicon:
            self.ipodinfodlg.set_icon_from_file(self.ipodicon)
            self.ipodinfo.get_widget('ipodimage').set_from_file(self.ipodicon)
        try:
            i,o = os.popen4('df -h %s' % self.ipod_mountpoint)
            dfo = o.read()
            i.close(); o.close()
            dfo = dfo[dfo.find('\n')+1:].split()
            self.ipodinfo.get_widget('ipodinfospace').set_fraction(int(dfo[4][:-1])/100.0)
            self.ipodinfo.get_widget('ipodinfospace').set_text(dfo[4])
            self.ipodinfo.get_widget('ipodinfototalspace').set_markup('<b>%s</b>' % dfo[1])
            self.ipodinfo.get_widget('ipodinfousedspace').set_markup('<b>%s</b>' % dfo[2])
            self.ipodinfo.get_widget('ipodinfoavailablespace').set_markup('<b>%s</b>' % dfo[3])
            self.ipodinfo.get_widget('ipodinfodevice').set_markup('<b>%s</b>' % dfo[0])
            self.ipodinfo.get_widget('ipodinfomountpoint').set_markup('<b>%s</b>' % dfo[5])
            self.ipodinfo.get_widget('ipodinfophotodb').set_markup(_('<b>%s photos in %s albums</b>') % (len(self.DB.Photos()), len(self.DB.Albums())-1))
            self.ipodinfo.get_widget('ipodinfomodel').set_markup('<b>%s</b>' % self.ipod_model)
            i,o = os.popen4('du -sh %s' % self.DB.dbdir)
            duo = o.read()
            duo = duo.split()[0]
            self.ipodinfo.get_widget('ipodinfousedforphotos').set_markup('<b>%s</b>' % duo)
            i.close(); o.close()
        except:
            pass

    def DestroyIpodInfo(self, widget):
        """ Destroy th iPod info dialog """
        self.ipodinfodlg.destroy()

    def ShowAbout(self, widget):
        """ Show the about dialog """
	gtk.about_dialog_set_url_hook(self.LaunchBrowser)
        self.about = gtk.glade.XML('gpixpod.glade', 'aboutdialog1', 'gpixpod')
	self.aboutdlg = self.about.get_widget('aboutdialog1')
        if self.icon:
	    self.aboutdlg.set_icon_from_file(self.icon)
        if self.logo:
            self.aboutdlg.set_logo(gtk.gdk.pixbuf_new_from_file(self.logo))

    def ShowPreferences(self, widget):
        """ Show the preferences dialog """
	self.preferences = gtk.glade.XML('gpixpod.glade', 'preferencesdialog', 'gpixpod')
	self.preferencesdlg = self.preferences.get_widget('preferencesdialog')
        if self.icon:
            self.preferencesdlg.set_icon_from_file(self.icon)
        self.LoadDefaultPreferences()
	self.preferences_callbacks = {'on_cancelbutton2_clicked':self.DestroyPreferences, 'on_okbutton2_clicked':self.StorePreferences,
	                              'on_defaultsbutton_clicked':self.RestoreDefaultPreferences, 'on_copyfullrescheckbutton_toggled':self.CopyFullResolution}
	self.preferences.signal_autoconnect(self.preferences_callbacks)

    def LoadDefaultPreferences(self):
        """ Load the default preferences """
	self.preferences.get_widget('autodetectcheckbutton').set_active(self.prefs['ipod_autodetect'])
	self.preferences.get_widget('copyfullrescheckbutton').set_active(self.prefs['photo_copyfullres'])
	self.preferences.get_widget('askbeforeopencheckbutton').set_active(self.prefs['ipod_askbeforeopen'])
	self.preferences.get_widget('impfilechooserbutton').set_current_folder(self.prefs['ipod_mountpoint'])
        if self.prefs['path_thumbscache'] == None:
            self.preferences.get_widget('thumbscacheipodradiobutton').set_active(True)
        else:
            self.preferences.get_widget('thumbscachehomeradiobutton').set_active(True)
        if self.prefs['photo_behaviour'] == 'Zoom':
            self.preferences.get_widget('imagebehaviourzoomradiobutton').set_active(True)
        elif self.prefs['photo_behaviour'] == 'Stretch':
            self.preferences.get_widget('imagebehaviourstretchradiobutton').set_active(True)
        else:
            self.preferences.get_widget('imagebehaviourfitradiobutton').set_active(True)
        if self.prefs['photo_autorotate'] == 'CW':
            self.preferences.get_widget('autorotatecwradiobutton').set_active(True)
        elif self.prefs['photo_autorotate'] == 'CCW':
            self.preferences.get_widget('autorotateccwradiobutton').set_active(True)
        else:
            self.preferences.get_widget('autorotateradiobutton').set_active(True)
        ipodm = self.preferences.get_widget('ipodmodelcombobox')
        if self.prefs['ipod_model'] == 'Nano':
            ipodm.set_active(1)
        elif self.prefs['ipod_model'] == 'Photo':
            ipodm.set_active(2)
        elif self.prefs['ipod_model'] == 'Color':
            ipodm.set_active(3)
        elif self.prefs['ipod_model'] == '5G':
            ipodm.set_active(4)
        else:
            ipodm.set_active(0)

    def RestoreDefaultPreferences(self, widget):
        """ Restore the default preferences """
	self.prefs = self.defaultprefs
	self.LoadDefaultPreferences()

    def DestroyPreferences(self, widget):
        """ Destroy the preferences dialog after received the destroy signal """
	self.preferencesdlg.destroy()

    def StorePreferences(self, widget):
        """ Store the preferences """
	self.prefs['ipod_autodetect'] = self.preferences.get_widget('autodetectcheckbutton').get_active()
	self.prefs['photo_copyfullres'] = self.preferences.get_widget('copyfullrescheckbutton').get_active()
	self.prefs['ipod_mountpoint'] = self.preferences.get_widget('impfilechooserbutton').get_current_folder()
	self.prefs['ipod_askbeforeopen'] = self.preferences.get_widget('askbeforeopencheckbutton').get_active()
        if self.preferences.get_widget('thumbscachehomeradiobutton').get_active():
            self.prefs['path_thumbscache'] = os.path.join(self.preferencesdir, '.SingleThumbs')
        else:
            self.prefs['path_thumbscache'] = None
        if self.preferences.get_widget('imagebehaviourzoomradiobutton').get_active():
            self.prefs['photo_behaviour'] = 'Zoom'
        elif self.preferences.get_widget('imagebehaviourstretchradiobutton').get_active():
            self.prefs['photo_behaviour'] = 'Stretch'
        else:
            self.prefs['photo_behaviour'] = 'Fit'
        if self.preferences.get_widget('autorotatecwradiobutton').get_active():
            self.prefs['photo_autorotate'] = 'CW'
        elif self.preferences.get_widget('autorotateccwradiobutton').get_active():
            self.prefs['photo_autorotate'] = 'CCW'
        else:
            self.prefs['photo_autorotate'] = 'No'
        ipodm = self.preferences.get_widget('ipodmodelcombobox').get_active()
        if ipodm == 1:
            self.prefs['ipod_model'] = 'Nano'
        elif ipodm == 2:
            self.prefs['ipod_model'] = 'Photo'
        elif ipodm == 3:
            self.prefs['ipod_model'] = 'Color'
        elif ipodm == 4:
            self.prefs['ipod_model'] = '5G'
        else:
            self.prefs['ipod_model'] = None
	self.WritePreferences()
	self.LoadPreferences()
	self.preferencesdlg.destroy()

    def WritePreferences(self):
        """ Write the preferences on file """
	prf = open(self.preferencesfile, 'w+')
	cPickle.dump(self.prefs, prf)
	prf.close()

    def LoadPreferences(self):
        """ Load the preferences """
	prf = open(self.preferencesfile, 'r')
        loadedprefs = cPickle.load(prf)
	# Overriding default preferences
	for prefkey, prefvalue in loadedprefs.iteritems():
	    self.prefs[prefkey] = prefvalue
	prf.close()

    def CopyFullResolution(self, widget):
        """ Choose to copy / not copy full resolution photo on the iPod """
        if widget.get_active():
            s = _('<b>Full resolution copies of your photos will be uploaded on your iPod</b>')
        else:
            s = _('<b>Full resolution copies of your photos will not be uploaded on your iPod</b>')
        self.Say(s, _('This is now the default action of drag &amp; drop and of the <i>Add Photo</i> button. You can always use the <i>Add Photo with/without full resolution</i> buttons to override this setting'))

    def Ask(self, sentence, secondary=None):
        """ Pop-up a question message dialog """
        self.questionbox = gtk.MessageDialog(self.window, 0, gtk.MESSAGE_QUESTION, gtk.BUTTONS_OK_CANCEL)
        if self.icon:
            self.questionbox.set_icon_from_file(self.icon)
	self.questionbox.set_markup(sentence)
	if secondary != None:
	    self.questionbox.format_secondary_markup(secondary)
	response = self.questionbox.run()
	self.questionbox.destroy()
	if response == -5:  # The numeric code (-5) is returned from GTK when pressing the OK button
	    return True
	else:
	    return False

    def Say(self, sentence, secondary=None, msg_type=gtk.MESSAGE_INFO):
        """ Pop-up one button info message box """
        self.messagebox = gtk.MessageDialog(self.window, gtk.DIALOG_MODAL, msg_type, gtk.BUTTONS_OK)
        if self.icon:
            self.messagebox.set_icon_from_file(self.icon)
	self.messagebox.set_markup(sentence)
	if secondary != None:
	    self.messagebox.format_secondary_markup(secondary)
	self.messagebox.run()
	self.messagebox.destroy()

    def LaunchBrowser(self, widget, link):
        """ Launch a browser for the specified link """
	webbrowser.open(link)

    def DonateForGPixPod(self):
        """ If running on Windows, ask for a donation sometimes """
        if self.Ask(_('<b>GPixPod development needs your help.</b>'),
                    _('If you like GPixPod, please consider buying it from <i>http://www.flagar.com/en/software/gpixpod</i> or donating by PayPal <i>(then you could ask the author to remove this message)</i>. Proceed now?')):
            self.LaunchBrowser(None, 'https://www.paypal.com/xclick/business=flagar%40gmail.com&item_name=Helping+GPixPod+development&no_shipping=1&tax=0&currency_code=EUR&lc=US')
        return True

    def CheckForVFATFS(self, mountpoint):
        """ Avoid querying about managing iPodLinux ext2/ext3 partitions, which should not contain Photos/Photo Databases! """
        result = False
        mounts = open('/proc/mounts')
        for line in mounts:
            contents = line.split()
            if contents[1] == mountpoint and contents[2] == 'vfat':
                result = True
                break
        mounts.close()
        return result

    def OnIpodConnect(self, ipod_hal, ipod_udi):
        """ Do stuff when an iPod has been connected """
        self.SetSensitive(('eject1', 'ejectbutton', 'ipodinfo1'), True)
        mountpoint = ipod_hal.get_ipod_mount_point(ipod_udi)
        self.ipod_mountpoint = mountpoint
        standard_loc = os.path.join(mountpoint, 'Photos', 'Photo Database')
        if self.CheckForVFATFS(mountpoint):
            model = getIpodModel(mountpoint)
            if model in ('5G', 'Nano', 'Photo', 'Color'):
	        if os.path.isfile(standard_loc):
                    if self.prefs['ipod_askbeforeopen'] == False or self.Ask(_('<b>iPod %s</b> and existing <b>Photo Database</b> found.') % model, _('Do you want to load the Photo Database found in the iPod attached to <b><i>%s</i></b>?') % mountpoint):
		        self.DBOpen(standard_loc)
	        else:
	            if self.Ask(_('<b>iPod %s</b> found, attached to <b><i>%s</i></b>.') % (model, mountpoint), _('But Photo Database <b>not found</b>. Do you want to create a new one?')):
	                self.DBOpen(standard_loc)
            else:
                self.Say(_('<b>iPod</b> found, attached to <b><i>%s</i></b>.') % mountpoint, _('But model <b>not autodetected</b>. You should really specify your iPod model in <i>Preferences</i> now.'))
                self.ShowPreferences(None)
        
    def OnIpodDisconnect(self, ipod_hal, ipod_udi):
        """ Do stuff when the iPod has been disconnected """
        mountpoint = ipod_hal.get_ipod_mount_point(ipod_udi)
        if self.CheckForVFATFS(mountpoint):
            self.SetSensitive(('eject1', 'ejectbutton', 'ipodinfo1'), False)
            if self.DB != None:
                if self.win.get_widget('save1').get_property('sensitive'):
                    unsaved_changes = _('All the unsaved changes will be lost.')
                else:
                    unsaved_changes = _('There are not unsaved changes.')
                if self.Ask(_('<b>iPod</b> disconnected. Do you want to <b>exit</b> now?'), unsaved_changes):
                    gtk.main_quit()
                else: 
                    self.Say(_('Please <b>reconnect the iPod</b> and <b>without loading again the Photo Database</b>'),
                             _('Not reconnecting means that you could not save your changes, resulting in a crash. And re-opening would abort all changes'),
                             gtk.MESSAGE_WARNING)


if __name__ == '__main__':  # FIXME: add exceptions handler!
    if len(sys.argv) > 1:
        import gpixpod_cli
        gpixpod_cli.option_parse()
    else:
        gpixpod = GPixPod()
        signal.signal(signal.SIGTERM, gpixpod.Kill)
        gpixpod.GUI()
        gtk.main()
