/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  main.c: ....

  Copyright (C)  2001-2005  Alexandru Csete.

  Authors: Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#include <stdio.h>
#include <gnome.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include <libgnomeui/gnome-window-icon.h>
#include <libgnomevfs/gnome-vfs.h>
#include <gal/e-paned/e-hpaned.h>
#include <math.h>
#include <locale.h>
#include "defaults.h"
#include "sattabs.h"
#include "satconfig.h"
#include "callbacks.h"
#include "timeout.h"
#include "clock.h"
#include "sun.h"
#include "moon.h"
#include "satlog.h"
#include "satdata.h"
#include "engine.h"
#include "engine-panel.h"
#include "qth.h"
#include "satlist.h"
#include "satmap.h"
#include "newuser.h"
#include "iconbar.h"
#include "satmodules.h"
#include "sattarget.h"
#include "sattree.h"
#include "satloc-tree.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define LISTNAME "default"

extern GnomeUIInfo menubar[];  /* menubar.c */
extern GnomeUIInfo toolbar[];  /* toolbar.c */
extern gboolean USEROK;        /* newuser.c - is set to TRUE if user has been configured properly */
extern gboolean CONFIGOK;
extern gboolean CONFIGERROR;


GtkWidget *app;
GtkWidget *appbar;
GtkWidget *vbox,*toolhbox,*horibox;
GConfClient *client;

sat_t *sat;

/* private function protos */
static void reopen_modules (void);
static void do_tree_hack (void);

/* CONFIGVERSION:
     CFGVER 0.4 is used for SW version 0.4.0
                                       0.4.99.1;0.4.99.2;0.4.99.3;0.4.99.4;0.4.99.5;0.4.99.6;0.4.99.7
     CFGVER 0.5 is used for SW version 0.4.99.8
*/
#define CONFIGVERSION 0.5


int main(int argc, char *argv[])
{
	gchar *path,*title;
	guint i=0;

#ifdef ENABLE_NLS
	setlocale (LC_ALL, "");
	bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain (PACKAGE);
#endif

	gnome_init (PACKAGE, VERSION, argc, argv);
	gnome_vfs_init ();

	/* window icon - must be called BEFORE gnome_app_new ??? */
	path = g_strconcat (PACKAGE_PIXMAPS_DIR, G_DIR_SEPARATOR_S, "icons",
			    G_DIR_SEPARATOR_S, "gpredict-icon.png", NULL);
	gnome_window_icon_set_default_from_file (path);
	g_free (path);

	/* create application */
	title = g_strconcat ("Gnome Predict ", VERSION, NULL);
	app = gnome_app_new (PACKAGE, title);
	g_free (title);
	gnome_window_icon_set_from_default (GTK_WINDOW (app));

	/* init GConf */
	if (!gconf_is_initialized ())
		gconf_init (argc, argv, NULL);

	client = gconf_client_get_default ();
	gconf_client_add_dir (client, "/apps/gpredict",
			      GCONF_CLIENT_PRELOAD_RECURSIVE,
			      NULL);

	/* Initialize logger */
	satlog_init ();

	/* Check whether we have a QTH configured using GConf (ver 1.0).
	   If not, run the newuser druid, which will automatically convert
	   any existing pre-1.0 configuration files to the proper GConf
	   configuration.
	*/
	if (gconf_client_get_float (client, "/apps/gpredict/version", NULL) < CONFIGVERSION) {
		g_print ("CONFIG NOT OK!\n");
		satlog_log (SAT_LOG_INFO, _("Configuration is not up to date!"));
		satconfig_open ();
		if (!CONFIGOK) {
			if (CONFIGERROR) {
				/* An error occured - inform user */
				GtkWidget *dialog;

				dialog = gnome_app_error (GNOME_APP (app),
							  _("An error occured while saving the settings!\n"\
							    "Please check your settings manually!"));
				if (dialog)
					gtk_widget_show_all (dialog);
			}
			else {
				/* User pressed cancel */
				gconf_client_remove_dir (client, "/apps/gpredict", NULL);
				gnome_vfs_shutdown ();
				gtk_widget_destroy (app);
				return 1;
			}
		}
		gconf_client_set_float (client, "/apps/gpredict/version", CONFIGVERSION, NULL);
		gconf_client_suggest_sync (client, NULL);
	}
	else {
		satlog_log (SAT_LOG_INFO, _("Configuration OK."));
	}

	/* initialize engine */
	i = engine_init ();

	/* initialize log */
	if (gconf_client_get_bool (client, SATLOG_VISIBLE_PATH, NULL))
		satlog_show ();

	gtk_window_set_default_size (GTK_WINDOW (app), 800, 550 );
	gtk_signal_connect (GTK_OBJECT (app), "delete_event",
			    GTK_SIGNAL_FUNC (gtk_main_quit),
			    NULL );

	gnome_app_create_menus (GNOME_APP (app), menubar);
	gnome_app_create_toolbar (GNOME_APP (app), toolbar);

	/* Pack iconbar and tabs */
	horibox = e_hpaned_new ();
	e_paned_add1 (E_PANED (horibox), iconbar_create ());
	e_paned_add2 (E_PANED (horibox), sattabs_create ());

	/* Vertical Box */
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), horibox, TRUE, TRUE, 0);

	gtk_box_pack_start (GTK_BOX (vbox), gtk_hseparator_new (), FALSE, FALSE, 0);

	/* Bottom infobox of the main window */
	toolhbox = gtk_hbox_new (FALSE, 1);
	gtk_box_pack_start (GTK_BOX (toolhbox), sun_create (),
			    FALSE, FALSE, 2);
	gtk_box_pack_start (GTK_BOX (toolhbox), moon_create (),
			    FALSE, FALSE, 2);
/* #if defined (HAVE_HAMLIB) */
/* 	gtk_box_pack_start (GTK_BOX (toolhbox), sattarget_create (), */
/* 			    FALSE, FALSE, 2); */
/* #endif */
	gtk_box_pack_end (GTK_BOX (vbox), toolhbox, FALSE, FALSE, 0);

	gnome_app_set_contents (GNOME_APP (app), GTK_WIDGET (vbox));

	appbar = gnome_appbar_new (FALSE, TRUE, GNOME_PREFERENCES_USER );
	gnome_app_set_statusbar (GNOME_APP (app), appbar);

	gtk_widget_show_all (app);

	/* start modules */
	engine_start ();
	clock_timer_start ();
	sun_timer_start ();
	moon_timer_start ();
	reopen_modules ();
/* 	engine_panel_open (); */
/* 	do_tree_hack (); */

	gtk_main ();


	/* clean up modules */
	sattabs_destroy ();

	gconf_client_remove_dir (client, "/apps/gpredict", NULL);

	g_free (path);
	engine_close ();
	gnome_vfs_shutdown ();

	return 0;
}



static void reopen_modules ()
{
	/* This function reopens the modules that
	   were open before the program was closed
	   the last time.
	*/
	gchar **list;
	guint num,i;

	/* lists */
	satmodules_get_modules (SATMOD_TYPE_LIST, &num, &list);
	for (i=0; i<num; i++) {
		satlist_open (g_strdup (list[i]), FALSE);
		iconbar_remove_module (list[i], SATMOD_TYPE_LIST);
	}
	g_strfreev (list);
	/* maps */
	satmodules_get_modules (SATMOD_TYPE_MAP, &num, &list);
	for (i=0; i<num; i++) {
		satmap_open (g_strdup (list[i]), FALSE);
		iconbar_remove_module (list[i], SATMOD_TYPE_MAP);
	}
	g_strfreev (list);
}


static void
do_tree_hack ()
{
	GtkWidget *dialog,*swin,*tree;
	gchar **loc,**web,*filter;

	loc = g_strsplit ("/home/alexc/tmp<!SEP>"\
			  "/usr/share/gpredict/data",
			  "<!SEP>", 0);
	web = g_strsplit ("groundstation.sourceforge.net/test",
			  "<!SEP>", 0);
	filter = g_strdup ("*.tle");


	tree = sattree_load_uris_recursive (loc, web, filter, SATTREE_MODE_FILE);

	g_strfreev (loc);
	g_strfreev (web);
	g_free (filter);

	/* scrolled window */
	swin = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_container_add (GTK_CONTAINER (swin), tree);

	/* create window */
	dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (dialog), "GURBER-TREE HACK");
	gtk_window_set_policy (GTK_WINDOW (dialog), TRUE, TRUE, TRUE);
	gtk_window_set_default_size (GTK_WINDOW (dialog), 300, 400);

	gtk_container_add (GTK_CONTAINER (dialog), swin);

	gtk_widget_show_all (dialog);

}
