/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*

  satpref-general.c: general preferences (widgets and funcs).

  Copyright (C)  2001-2005  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#include <gnome.h>
#include <gconf/gconf-client.h>
#include "iconbar-popup-menu.h"
#include "sattabs.h"
#include "satpref.h"
#include "satpref-general.h"
#include "clock.h"

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif


GtkWidget *showloc,*cfmchk,*tabchk;
extern GConfClient *client;          /* main.c */

extern gboolean clock_show_local;

/* private function prototypes */
static void satpref_general_toggle_changed (GtkToggleButton *, gpointer);



GtkWidget *satpref_general (void)
{
	/* This function creates the widgets for the General preferences page.
	 */
	GtkWidget *vbox;
	GtkTooltips *kooltips;

	/* show UTC check box */
	showloc = gtk_check_button_new_with_label (_("Show local time instead of UTC"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (showloc),
				      gconf_client_get_bool (client, CLOCK_SHOW_LOCAL_TIME_PATH, NULL));
	gtk_signal_connect (GTK_OBJECT (showloc), "toggled",
			    GTK_SIGNAL_FUNC (satpref_general_toggle_changed),
			    NULL);

	/* "Ask for confirmation" check box */
	cfmchk = gtk_check_button_new_with_label (_("Ask for confirmation when attempting to "\
						    "delete a module."));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cfmchk),
				      !gconf_client_get_bool (client, 
							      ICONBAR_POPUP_ITEM_DELETE_CONFIRM_PATH,
							      NULL));
	gtk_signal_connect (GTK_OBJECT (cfmchk), "toggled",
			    GTK_SIGNAL_FUNC (satpref_general_toggle_changed),
			    NULL);
	kooltips = gtk_tooltips_new ();
	gtk_tooltips_set_tip (kooltips, cfmchk,
			      _("If you check this box, you will always be asked for confirmation "\
				"when you attempt to delete an existing module. This way you can "\
				"avoid deleting modules by mistake."), NULL);

	/* Always show tabs? */
	tabchk = gtk_check_button_new_with_label (_("Always show TABS in notebook."));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (tabchk),
				      gconf_client_get_bool (client, 
							     SATTABS_CONFIG_SHOW_TABS_PATH,
							     NULL));
	gtk_signal_connect (GTK_OBJECT (tabchk), "toggled",
			    GTK_SIGNAL_FUNC (satpref_general_toggle_changed),
			    NULL);
	kooltips = gtk_tooltips_new ();
	gtk_tooltips_set_tip (kooltips, tabchk,
			      _("If you check this box, the tabs in the notebook will always "\
				"be shown. Otherwise, tabs will only be shown, if there are "\
				"more than one pages in the notebook."), NULL);

	/* Main vertical box */
	vbox = gtk_vbox_new (TRUE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), showloc, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), cfmchk, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), tabchk, FALSE, FALSE, 0);

	return vbox;
}

void 
satpref_general_apply (void)
{
	/* time format */
	clock_show_local= gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (showloc)),
	gconf_client_set_bool (client,
			       CLOCK_SHOW_LOCAL_TIME_PATH,
			       clock_show_local,
			       NULL);

	/* confirmation */
	gconf_client_set_bool (client,
			       ICONBAR_POPUP_ITEM_DELETE_CONFIRM_PATH,
			       !gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cfmchk)),
			       NULL);

	/* show tabs */
	gconf_client_set_bool (client,
			       SATTABS_CONFIG_SHOW_TABS_PATH,
			       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (tabchk)),
			       NULL);
}


static void
satpref_general_toggle_changed (GtkToggleButton *button, gpointer data)
{
	/* This function is called when the state of a toggle button changes.
	   It notifies the gnome-preferences engine, that a change has occured
	   so the "apply" callback should be called when the dialog is closed
	   via the "OK" button.
	*/
	satpref_changed ();
}
