#!/bin/sh

####################################################
# 1. Uninstall GPRename if it is already installed #
####################################################

# First all the config files from each directory in /home
for i in /home/*
do 
   if [[ -e "$i/.gprename" ]];     then rm -fv "$i/.gprename";     fi
   if [[ -e "$i/.gprename_log" ]]; then rm -fv "$i/.gprename_log"; fi
done

# Secondly what's left
if [[ -e "/root/.gprename" ]];                          then rm -fv  "/root/.gprename"; fi
if [[ -e "/root/.gprename_log" ]];                      then rm -fv  "/root/.gprename_log"; fi
if [[ -e "/usr/local/bin/gprename" ]];                  then rm -fv  "/usr/local/bin/gprename"; fi
if [[ -e "/usr/local/share/gprename" ]];                then rm -frv "/usr/local/share/gprename"; fi
if [[ -e "/usr/share/applications/gprename.desktop" ]]; then rm -fv  "/usr/share/applications/gprename.desktop"; fi


#######################
# 2. Install GPRename #
#######################

mkdir -p /usr/local/share/gprename
mkdir -p /usr/local/share/gprename/bin
mkdir -p /usr/local/share/gprename/languages
mkdir -p /usr/local/share/gprename/icon

cp -v bin/gprename			/usr/local/bin
cp -v bin/gprename.pl			/usr/local/share/gprename/bin
cp -v bin/gprename.desktop		/usr/share/applications
cp -v languages/lang*			/usr/local/share/gprename/languages
cp -v icon/gprename*			/usr/local/share/gprename/icon
cp -v COPYING README			/usr/local/share/gprename
cp -v gprename-install.sh		/usr/local/share/gprename
cp -v gprename-uninstall.sh		/usr/local/share/gprename

chmod -R 755 /usr/local/share/gprename
chmod    755 /usr/local/bin/gprename

echo -e "\nInstallation completed."
