/* $Id: details.cc,v 1.9 2001/04/17 04:11:54 bergo Exp $ */

/*

    GPS - Graphical Process Statistics
    Copyright (C) 1999-2000 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include "transient.h"
#include "details.h"
#include "diefast.h"
#include "polling.h"
#include "netpolling.h"
#include "msgbox.h"
#include "importglobals.h"
#include "userinfo.h"

#include "pixmaps/dtitle1.xpm"
#include "pixmaps/dtitle2.xpm"
#include "pixmaps/dtitle3.xpm"
#include "pixmaps/dtitle4.xpm"

GtkWidget *pdlg;
gint cur_prop=-1;

void open_details(gint thepid,char *thehost) {
  GtkWidget *v1,*h1,*hs,*dis,*tbl;

  if (netcritical)
    return;

  pdlg=gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_transient_for(GTK_WINDOW(pdlg),MainWindow);
  gtk_window_set_position(GTK_WINDOW(pdlg),GTK_WIN_POS_CENTER);
  gtk_widget_realize(pdlg);
  gtk_window_set_policy(GTK_WINDOW(pdlg),TRUE,TRUE,TRUE); /* 0.3.6 */
  //  gtk_widget_set_usize(pdlg,650,405);
  gtk_window_set_title(GTK_WINDOW(pdlg),"Details");
  gtk_container_set_border_width(GTK_CONTAINER(pdlg),4);
  
  v1=gtk_vbox_new(FALSE,2);
  gtk_container_add(GTK_CONTAINER(pdlg),v1);

  tbl=gtk_table_new(32,5,FALSE);
  gtk_box_pack_start(GTK_BOX(v1),tbl,TRUE,TRUE,2);

  if (fill_table(thepid,thehost,GTK_TABLE(tbl))<0)
    return;

  hs=gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(v1),hs,FALSE,FALSE,4);

  h1=gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(h1), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(h1), 5);

  gtk_box_pack_start(GTK_BOX(v1),h1,FALSE,FALSE,6);

  dis=gtk_button_new_with_label("Dismiss");
  GTK_WIDGET_SET_FLAGS(dis,GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(h1),dis,TRUE,TRUE,0);

  gtk_signal_connect(GTK_OBJECT(dis),"clicked",
		     GTK_SIGNAL_FUNC(dismiss_details),NULL);

  gtk_widget_grab_default(dis);

  gtk_widget_show(v1);
  gtk_widget_show(h1);
  gtk_widget_show(hs);
  gtk_widget_show(dis);
  gtk_widget_show(tbl);
  gtk_widget_show(pdlg);
  gtk_grab_add(pdlg);

  cur_prop=thepid;
}

void dismiss_details(GtkWidget *wid,gpointer data) {
  gtk_grab_remove(pdlg);
  gtk_widget_destroy(pdlg);
}

int fill_table(gint p,char *thehost,GtkTable *tbl) {
  GtkWidget *l1,*l2,*sw,*cl,*fl,*fw;
  char b2[512];
  gchar *tpo[2];
  int i;
  ProcessItem *pi;
  NetworkDetailsPoller *ndp;
  GList *pt;
  
  gtk_table_set_col_spacings(tbl,4);

  // <vr>
  l1=gtk_vseparator_new();
  gtk_table_attach(tbl,l1,2,3,0,30,GTK_FILL,GTK_FILL,4,0);
  gtk_widget_show(l1);

  mk_cell_pic(tbl,dtitle1_xpm,0,0);
  mk_cell_pic(tbl,dtitle2_xpm,3,0);
  mk_cell_pic(tbl,dtitle3_xpm,3,9);
  mk_cell_pic(tbl,dtitle4_xpm,0,12); /* 0.3.6 */

  /* the left column's top clist */

  fw=gtk_scrolled_window_new(NULL,NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(fw),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_NEVER);  

  fl=gtk_clist_new(2);
  gtk_clist_set_shadow_type(GTK_CLIST(fl),GTK_SHADOW_ETCHED_IN);
  gtk_clist_set_selection_mode(GTK_CLIST(fl),GTK_SELECTION_BROWSE);
  gtk_clist_set_column_title(GTK_CLIST(fl),0,"What");
  gtk_clist_set_column_title(GTK_CLIST(fl),1,"Who");
  gtk_clist_column_titles_passive(GTK_CLIST(fl));
  gtk_clist_column_titles_hide(GTK_CLIST(fl));
  gtk_clist_set_column_width(GTK_CLIST(fl),0,60);
  gtk_clist_set_column_width(GTK_CLIST(fl),1,100);
  /*  gtk_clist_set_column_auto_resize(GTK_CLIST(fl),0,TRUE);
      gtk_clist_set_column_auto_resize(GTK_CLIST(fl),1,TRUE);*/

  gtk_container_add(GTK_CONTAINER(fw),fl);
  gtk_table_attach_defaults(tbl,fw,0,2,1,12);

  strcpy(b2," ");
  tpo[0]=b2;
  tpo[1]=b2;
  for(i=0;i<12;i++)
    gtk_clist_append(GTK_CLIST(fl),(gchar **)tpo);

  /* clist ends */

  if (strcmp(thehost,this_host)==0) { /* local process */
    while(!enter_mutex()) usleep(13);
    details_poller->poll(p);
    pi=details_poller->item;
    exit_mutex();
  } else {
    pi=NULL;
    for(pt=detailswatch;pt!=NULL;pt=g_list_next(pt)) {
      ndp=(NetworkDetailsPoller *)(pt->data);
      if (ndp->isHost(thehost)) {
	ndp->poll(p);
	pi=ndp->item;
	break;
      }
    }
  }

  if (pi==NULL) {
    gtk_widget_destroy(pdlg);
    message_box(MainWindow,
		ERR_DETAIL_NOT_FOUND,
		"Error",
		MSGBOX_OK,
		MSGBOX_ICON_ERROR);
    return -1;
  }

  /* OWNER */
  setitemvalue(GTK_CLIST(fl),"Owner",0,1,4,5);
  setitemvalue(GTK_CLIST(fl),pi->owner,1,2,4,5);

  /* COMMAND LINE */
  setitemvalue(GTK_CLIST(fl),"Commmand Line",0,1,3,4);
  setitemvalue(GTK_CLIST(fl),pi->longname,1,2,3,4);

  /* PID */
  setitemvalue(GTK_CLIST(fl),"PID",0,1,1,2);
  setitemvalue(GTK_CLIST(fl),pi->pid,1,2,1,2);

  /* NAME */
  setitemvalue(GTK_CLIST(fl),"Name",0,1,2,3);
  setitemvalue(GTK_CLIST(fl),pi->name,1,2,2,3);

  /* HOST */
  setitemvalue(GTK_CLIST(fl),"Hostname",0,1,5,6);
  setitemvalue(GTK_CLIST(fl),pi->machine,1,2,5,6);

  /* STATE */
  setleftlabel(tbl,"State",3,4,16,17);
  l2=gtk_label_new(pi->state);
  lable_attach(tbl,l2,4,5,16,17);
  gtk_widget_show(l2);

  /* PPID */
  setitemvalue(GTK_CLIST(fl),"PPID (Parent PID)",0,1,6,7);
  setitemvalue(GTK_CLIST(fl),pi->ppid,1,2,6,7);

  /* PGID */
  setitemvalue(GTK_CLIST(fl),"PGID (Process Group ID)",0,1,7,8);
  setitemvalue(GTK_CLIST(fl),pi->pgid,1,2,7,8);

  /* SID */
  setitemvalue(GTK_CLIST(fl),"SID (Session ID)",0,1,8,9);
  setitemvalue(GTK_CLIST(fl),pi->sid,1,2,8,9);

  /* TTY */
  setitemvalue(GTK_CLIST(fl),"TTY",0,1,9,10);
  setitemvalue(GTK_CLIST(fl),pi->tty,1,2,9,10);

  /* TPGID */
  setitemvalue(GTK_CLIST(fl),"TPGID (TTY owner's PGID)",0,1,10,11);
  setitemvalue(GTK_CLIST(fl),pi->tpgid,1,2,10,11);

  /* FLAGS */
  setitemvalue(GTK_CLIST(fl),"Flags",0,1,12,13);
  setitemvalue(GTK_CLIST(fl),pi->flags,1,2,12,13);

  // minflt
  setleftlabel(tbl,"Process Minor (page) faults",3,4,4,5);
  setleftlabel(tbl," ",3,4,4,5);
  l2=gtk_label_new(pi->minflt);
  lable_attach(tbl,l2,4,5,4,5);
  gtk_widget_show(l2);

  // cminflt
  setleftlabel(tbl,"Children Minor faults",3,4,5,6);
  l2=gtk_label_new(pi->cminflt);
  lable_attach(tbl,l2,4,5,5,6);
  gtk_widget_show(l2);

  // majflt
  setleftlabel(tbl,"Process Major faults",3,4,6,7);
  l2=gtk_label_new(pi->majflt);
  lable_attach(tbl,l2,4,5,6,7);
  gtk_widget_show(l2);

  // cmajflt
  setleftlabel(tbl,"Children Major faults",3,4,7,8);
  l2=gtk_label_new(pi->cmajflt);
  lable_attach(tbl,l2,4,5,7,8);
  gtk_widget_show(l2);

  // utime
  setleftlabel(tbl,"Jiffies in user mode",3,4,10,11);
  l2=gtk_label_new(pi->uj);
  lable_attach(tbl,l2,4,5,10,11);
  gtk_widget_show(l2);

  // stime
  setleftlabel(tbl,"Jiffies in kernel mode",3,4,11,12);
  l2=gtk_label_new(pi->kj);
  lable_attach(tbl,l2,4,5,11,12);
  gtk_widget_show(l2);

  // cutime
  setleftlabel(tbl,"Children jiffies in user mode",3,4,12,13);
  l2=gtk_label_new(pi->cuj);
  lable_attach(tbl,l2,4,5,12,13);
  gtk_widget_show(l2);

  // cstime
  setleftlabel(tbl,"Children jiffies in kernel mode",3,4,13,14);
  l2=gtk_label_new(pi->ckj);
  lable_attach(tbl,l2,4,5,13,14);
  gtk_widget_show(l2);

  // counter
#ifdef HAVELINUXPROCFS
  setleftlabel(tbl,"Maximum jiffies in next timeslice",3,4,14,15);
#else
  setleftlabel(tbl,"Priority",3,4,14,15);
#endif
  l2=gtk_label_new(pi->priority);
  lable_attach(tbl,l2,4,5,14,15);
  gtk_widget_show(l2);

  // nicety
  setleftlabel(tbl,"Nicety",3,4,15,16);
  l2=gtk_label_new(pi->nice);
  lable_attach(tbl,l2,4,5,15,16);
  gtk_widget_show(l2);

  // start time
  setitemvalue(GTK_CLIST(fl),"Start time",0,1,11,12);
  setitemvalue(GTK_CLIST(fl),pi->start,1,2,11,12);

  // vsize
  setleftlabel(tbl,"SIZE (bytes)",3,4,1,2);
  l2=gtk_label_new(pi->size);
  lable_attach(tbl,l2,4,5,1,2);
  gtk_widget_show(l2);

  // RSS
  setleftlabel(tbl,"RSS (bytes)",3,4,2,3);
  l2=gtk_label_new(pi->rss);
  lable_attach(tbl,l2,4,5,2,3);
  gtk_widget_show(l2);

  // RLIM
  setleftlabel(tbl,"RSS Limit (bytes)",3,4,3,4);
  l2=gtk_label_new(pi->rssl);
  lable_attach(tbl,l2,4,5,3,4);
  gtk_widget_show(l2);

  // SIGNALS

  sw=gtk_scrolled_window_new(NULL,NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_NEVER);  

  cl=gtk_clist_new(2);
  gtk_clist_set_shadow_type(GTK_CLIST(cl),GTK_SHADOW_ETCHED_IN);
  gtk_clist_set_selection_mode(GTK_CLIST(cl),GTK_SELECTION_BROWSE);
  gtk_clist_set_column_title(GTK_CLIST(cl),0,"What");
  gtk_clist_set_column_title(GTK_CLIST(cl),1,"Signals");
  gtk_clist_column_titles_passive(GTK_CLIST(cl));
  gtk_clist_column_titles_hide(GTK_CLIST(cl));
  gtk_clist_set_column_width(GTK_CLIST(cl),0,60);
  gtk_clist_set_column_width(GTK_CLIST(cl),1,100);
  gtk_clist_set_column_auto_resize(GTK_CLIST(cl),1,TRUE);
  gtk_container_add(GTK_CONTAINER(sw),cl);
  gtk_table_attach_defaults(tbl,sw,0,2,13,30);

  tpo[0]=b2;

  // pending signals
  tpo[1]=pi->sigpend;
  strcpy(b2,"Pending");
  gtk_clist_append(GTK_CLIST(cl),(gchar **)tpo);

  // blocked signals
  tpo[1]=pi->sigblock;
  strcpy(b2,"Blocked");
  gtk_clist_append(GTK_CLIST(cl),(gchar **)tpo);

  // ignored signals
  tpo[1]=pi->sigign;
  strcpy(b2,"Ignored");
  gtk_clist_append(GTK_CLIST(cl),(gchar **)tpo);

  // caught signals
  tpo[1]=pi->sigcau;
  strcpy(b2,"Caught");
  gtk_clist_append(GTK_CLIST(cl),(gchar **)tpo);

  gtk_clist_columns_autosize(GTK_CLIST(fl));
  gtk_widget_show(fl);
  gtk_widget_show(fw); // top clist

  gtk_widget_set_usize(fw,360,-1);

  gtk_widget_show(cl);
  gtk_widget_show(sw); // signal clist

  gtk_signal_connect(GTK_OBJECT(fl),"select_row",
		     GTK_SIGNAL_FUNC(details_first_list_select),NULL);

  return 0;
}

void lable_attach(GtkTable *t,GtkWidget *w,gint l,gint r,gint u,gint d) {
  GtkWidget *f;
  if ((l==0)||(l==3)) {
    f=gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(f),w,FALSE,FALSE,0);
  } else {
    f=gtk_hbox_new(FALSE,0);
    gtk_box_pack_end(GTK_BOX(f),w,FALSE,FALSE,0);
  }
  gtk_table_attach_defaults(t,f,l,r,u,d);
  gtk_widget_show(f);
}

void setitemvalue(GtkCList *cl,char *text,gint l,gint r,gint u,gint d) {
  if (text==NULL)
    text=" ";
   gtk_clist_set_text(cl,u-1,l,text);
}

void setleftlabel(GtkTable *t,char *text,gint l,gint r,gint u,gint d) {
  GtkWidget *f,*la;

  f=gtk_hbox_new(FALSE,0);
  la=gtk_label_new(text);
  gtk_box_pack_start(GTK_BOX(f),la,FALSE,FALSE,0);
  gtk_table_attach_defaults(t,f,l,r,u,d);
  gtk_widget_show(la);
  gtk_widget_show(f);
}

void mk_cell_pic(GtkTable *t,char **xpm,gint l,gint u) {
  GtkStyle *style;
  GtkWidget *h,*p;
  GdkBitmap *mask;
  GdkPixmap *dp;
  style=gtk_widget_get_style(pdlg);
  dp=gdk_pixmap_create_from_xpm_d(pdlg->window,&mask,
				  &style->bg[GTK_STATE_NORMAL],
				  (gchar **)xpm);
  p=gtk_pixmap_new(dp,mask);
  h=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(h),p,FALSE,FALSE,0);
  gtk_table_attach_defaults(t,h,l,l+1,u,u+1);
  gtk_widget_show(p);
  gtk_widget_show(h);
}

/* Additions: 0.5.2 */

// double click over user name pops user info box
// double click over PPID, PGID pops details of given
// process if available
void details_first_list_select(GtkCList *cl,gint row,
			       gint column,GdkEventButton *geb,
			       gpointer data)
{
  char *p;
  int pn,me;
  ProcessItem *pi;
  char hst[128];

  if (geb==NULL)
    return;
  if (geb->type!=GDK_2BUTTON_PRESS)
    return;

  switch(row) {
  case 3:
    gtk_clist_get_text(cl,3,1,(gchar **)(&p));
    uinfo_pop(p);
    break;
  case 5: // PPID
  case 6: // PGID
  case 7: // SID
  case 9: // TPGID
    gtk_clist_get_text(cl,row,1,(gchar **)(&p));
    pn=atoi(p);
    gtk_clist_get_text(cl,0,1,(gchar **)(&p));
    me=atoi(p);
    gtk_clist_get_text(cl,4,1,(gchar **)(&p));
    strcpy(hst,p);
    if ((pn<=0)||(me==pn))
      return;
    while(!enter_mutex()) usleep(13);
    details_poller->poll(pn);
    pi=details_poller->item;
    exit_mutex();
    if (pi==NULL) {
      message_box(GTK_WINDOW(pdlg),
		  ERR_GONE_PID,
		  "Failure",
		  MSGBOX_OK,
		  MSGBOX_ICON_EXCLAMATION);
      return;
    }
    gtk_grab_remove(pdlg);
    gtk_widget_destroy(pdlg);
    open_details(pn,hst);
    break;
  }
}
