/* $Id: tabledata.h,v 1.4 2000/02/20 21:45:36 bergo Exp $ */

#ifndef GPS_TABLEDATA_H

#define MAXTDATA 16

/// an auxiliary linked list of vectors used to help sorting the process list.
class tabledata {
 public:

  /// trivial constructor
  tabledata();

  /// trivial destructor
  ~tabledata();

  /// returns next node, NULL if none exists.
  tabledata *getNext();

  /// sets next node on list to be x.
  void setNext(tabledata *x);

  /// returns the number of nodes in the list.
  int count();

  /// sets the i-th value to a.
  void setv(int i,char *a);

  /// returns the i-th value.
  char * getv(int i);

  /// appends td to this list
  void add(tabledata *td);

  /// sets current item selected
  void select_item();

  /// returns whether this item is selected
  gboolean selected();

 private:
  tabledata *next;
  char *pointers[MAXTDATA];
  gboolean selflag;
};

#define GPS_TABLEDATA_H
#endif
