/* gpsk31  - PSK31 for Linux with a GTK+ Interface
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 0.2.4- May 2000
 *
 */

/*
 * Different functions, mostly initializations
 */

#include <time.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <math.h>
#include <string.h>
#include "misc.h"
#include "spectrum.h"
#include "main_screen.h"
#include "globals.h"
#include "server.h"
#include <unistd.h>
#include <stdlib.h>

static int x,y;			/* The edge of the phase scope line */

GdkGC *gc_dcd_on;		// The Phase scope colors
GdkGC *gc_dcd_off;
GdkGC *gc_black;


void
phase_scope_init ()
{
  GdkColor color;
  GdkColormap *cmap;

  cmap = gdk_colormap_get_system ();
  gdk_color_parse ("black", &color); 

  if (!gdk_color_alloc (cmap, &color))
    g_error ("Couldn't allocate color");

  gc_black = gdk_gc_new (main_screen.phase_scope);
  gdk_gc_set_foreground (gc_black, &color);
  gdk_gc_set_line_attributes (gc_black, 3, GDK_LINE_SOLID, GDK_CAP_ROUND,
			      GDK_JOIN_ROUND);


  gdk_color_parse (ini_settings.phase_scope_dcd_on_color, &color);

  if (!gdk_color_alloc (cmap, &color))
    g_error ("Couldn't allocate color");

  gc_dcd_on = gdk_gc_new (main_screen.phase_scope);
  gdk_gc_set_foreground (gc_dcd_on, &color);
  gdk_gc_set_line_attributes (gc_dcd_on, 3, GDK_LINE_SOLID, GDK_CAP_ROUND,
			      GDK_JOIN_ROUND);

  gdk_color_parse (ini_settings.phase_scope_dcd_off_color, &color);

  if (!gdk_color_alloc (cmap, &color))
    g_error ("Couldn't allocate color");

  gc_dcd_off = gdk_gc_new (main_screen.phase_scope);
  gdk_gc_set_foreground (gc_dcd_off, &color);
  gdk_gc_set_line_attributes (gc_dcd_off, 3, GDK_LINE_SOLID,
			      GDK_CAP_ROUND, GDK_JOIN_ROUND);

}

void
draw_arc ()			// Draw the Arc for the Phase Scope
{


  GdkGC *gc;
  GdkColormap *cmap;
  GdkColor color;
  cmap = gdk_colormap_get_system ();

  gdk_color_parse (ini_settings.phase_scope_arc_color, &color);
  gdk_color_alloc (cmap, &color);

  gc = gdk_gc_new (main_screen.phase_scope);
  gdk_gc_set_foreground (gc, &color);
  gdk_gc_set_line_attributes (gc, 3, GDK_LINE_SOLID, GDK_CAP_ROUND,
			      GDK_JOIN_ROUND);

  gdk_draw_arc (main_screen.phase_scope, gc, 0, 3, 3, 93, 
			93, 0, 23040);
  x = 50;
  y = 50;
}


void
draw_scope (int phdelta, int strength, int dcd)	// Draw a line in the Phase
						// scope
{
  float fudge = 2.0 * M_PI / 256.0;
  float theta;
  theta = phdelta * fudge;

  gdk_draw_line (main_screen.phase_scope, gc_black, 50, 50, x, y);	// erase old line

  /* This is ugly... I do not like it. Weak signals should also look weak... */

  // int phase_magnitude = (strength +64) /2;


  int phase_magnitude = (int) ((strength + 30) / 1.6);   /* This is better? */
  if (phase_magnitude > 42) phase_magnitude = 42;
  else if (phase_magnitude < 0) phase_magnitude = 0;

  x = (int) (50 + (float) phase_magnitude * cos (theta + M_PI_2));
  y = (int) (50 - (float) phase_magnitude * sin (theta + M_PI_2));

  if (dcd == 0)
    gdk_draw_line (main_screen.phase_scope, gc_dcd_off, 50, 50, x, y);
  else
    gdk_draw_line (main_screen.phase_scope, gc_dcd_on, 50, 50, x, y);

  gdk_draw_pixmap (main_screen.phase_drawing->window,
		   main_screen.phase_drawing->
		   style->fg_gc[GTK_WIDGET_STATE (main_screen.phase_drawing)],
		   main_screen.phase_scope, 0, 0, 0, 0, 100, 100);


}
