#include "eval/majorPiece.h"
#include "osl/record/csaString.h"
#include "osl/record/csaRecord.h"

#include "gtest/gtest.h"

using namespace osl;
using namespace osl::state;
using namespace osl::record;

TEST(NumPiecesBetweenBishopAndKingTest, countBetween)
{
  {
    const NumEffectState state(CsaString(
				 "P1-KY-KE-GI-KI * -KI * -KE-OU\n"
				 "P2 * -HI *  *  *  *  * -GI-KY\n"
				 "P3-FU-FU-FU-FU-FU-FU-FU-FU-FU\n"
				 "P4 *  *  *  *  *  *  *  *  * \n"
				 "P5-KA *  *  *  *  *  *  *  * \n"
				 "P6 *  *  *  *  *  *  *  *  * \n"
				 "P7+FU+FU+FU+FU+FU+FU+FU+FU+FU\n"
				 "P8 * +KA *  *  *  *  * +HI * \n"
				 "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
				 "+\n").getInitialState());
    ASSERT_EQ(1,
	      gpsshogi::NumPiecesBetweenBishopAndKingAll::countBetween(
		state,
		state.kingSquare<BLACK>(),
		state.pieceAt(Square(9, 5))));
    ASSERT_EQ(0,
	      gpsshogi::NumPiecesBetweenBishopAndKingSelf::countBetween(
		state,
		state.kingSquare<BLACK>(),
		state.pieceAt(Square(9, 5))));
    ASSERT_EQ(1,
	      gpsshogi::NumPiecesBetweenBishopAndKingOpp::countBetween(
		state,
		state.kingSquare<BLACK>(),
		state.pieceAt(Square(9, 5))));
    ASSERT_EQ(3,
	      gpsshogi::NumPiecesBetweenBishopAndKingAll::countBetween(
		state,
		state.kingSquare<WHITE>(),
		state.pieceAt(Square(8, 8))));
    ASSERT_EQ(1,
	      gpsshogi::NumPiecesBetweenBishopAndKingSelf::countBetween(
		state,
		state.kingSquare<WHITE>(),
		state.pieceAt(Square(8, 8))));
    ASSERT_EQ(2,
	      gpsshogi::NumPiecesBetweenBishopAndKingOpp::countBetween(
		state,
		state.kingSquare<WHITE>(),
		state.pieceAt(Square(8, 8))));
  }
  {
    const NumEffectState state(CsaString(
				 "P1-KY-KE-GI-KI * -KI * -KE-OU\n"
				 "P2 * -HI *  *  *  *  * -GI-KY\n"
				 "P3-FU-FU-FU-FU-FU-FU-FU-FU-FU\n"
				 "P4 * -KA *  *  *  *  *  *  * \n"
				 "P5 *  *  *  *  *  *  *  *  * \n"
				 "P6 * +KA *  *  *  *  *  *  * \n"
				 "P7+FU+FU+FU+FU+FU+FU+FU+FU+FU\n"
				 "P8 *  *  *  *  *  *  * +HI * \n"
				 "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
				 "+\n").getInitialState());
    ASSERT_EQ(8,
	      gpsshogi::NumPiecesBetweenBishopAndKingAll::countBetween(
		state,
		state.kingSquare<WHITE>(),
		state.pieceAt(Square(8, 6))));
    ASSERT_EQ(8,
	      gpsshogi::NumPiecesBetweenBishopAndKingSelf::countBetween(
		state,
		state.kingSquare<WHITE>(),
		state.pieceAt(Square(8, 6))));
    ASSERT_EQ(8,
	      gpsshogi::NumPiecesBetweenBishopAndKingOpp::countBetween(
		state,
		state.kingSquare<WHITE>(),
		state.pieceAt(Square(8, 6))));
  }
}

TEST(BishopBishopPieceTest, feature)
{
  {
    const NumEffectState state(CsaString(
				 "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
				 "P2 * -HI *  *  *  *  * -KA * \n"
				 "P3-FU-FU-FU-FU-FU-FU * -FU-FU\n"
				 "P4 *  *  *  *  *  * -FU *  * \n"
				 "P5 *  *  *  *  *  *  *  *  * \n"
				 "P6 *  *  *  *  *  *  *  *  * \n"
				 "P7+FU+FU+FU+FU+FU+FU+FU+FU+FU\n"
				 "P8 * +KA *  *  *  *  * +HI * \n"
				 "P9+KY+KE+GI+KI+OU+KI+GI+KE+KY\n"
				 "+\n").getInitialState());
    gpsshogi::BishopBishopPiece bbp;
    gpsshogi::IndexCacheI<gpsshogi::MaxActiveWithDuplication> features;
    bbp.featuresOneNonUniq(state, features);
    ASSERT_EQ(1, features.size());
    ASSERT_EQ(bbp.index(osl::newPtypeO(BLACK, PAWN), true, true),
	      features[0].first);
  }
  {
    const NumEffectState state(CsaString(
				 "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
				 "P2 * -HI *  *  *  *  * -KA * \n"
				 "P3-FU-FU-FU-FU-FU-FU * -FU-FU\n"
				 "P4 *  *  *  *  *  * -FU *  * \n"
				 "P5 *  *  *  *  *  *  *  *  * \n"
				 "P6 *  *  *  *  *  *  *  *  * \n"
				 "P7+FU+FU+FU+FU+FU+FU+FU+FU+FU\n"
				 "P8 * +KA+GI *  *  *  * +HI * \n"
				 "P9+KY+KE * +KI+OU+KI+GI+KE+KY\n"
				 "+\n").getInitialState());
    gpsshogi::BishopBishopPiece bbp;
    gpsshogi::IndexCacheI<gpsshogi::MaxActiveWithDuplication> features;
    bbp.featuresOneNonUniq(state, features);
    ASSERT_EQ(1, features.size());
    ASSERT_EQ(features[0].first,
	      bbp.index(osl::newPtypeO(BLACK, PAWN), false, true));
  }

  {
    const NumEffectState state(CsaString(
				 "P1-KY-KE-GI-KI-OU-KI-GI-KE-KY\n"
				 "P2 * -HI *  *  *  *  * -KA * \n"
				 "P3-FU-FU-FU-FU-FU-FU * -FU-FU\n"
				 "P4 *  *  *  *  *  * -FU *  * \n"
				 "P5 *  *  *  *  *  *  *  *  * \n"
				 "P6 *  *  * +GI *  *  *  *  * \n"
				 "P7+FU+FU+FU+FU+FU+FU+FU+FU+FU\n"
				 "P8 * +KA *  *  *  *  * +HI * \n"
				 "P9+KY+KE * +KI+OU+KI+GI+KE+KY\n"
				 "+\n").getInitialState());
    gpsshogi::BishopBishopPiece bbp;
    gpsshogi::IndexCacheI<gpsshogi::MaxActiveWithDuplication> features;
    bbp.featuresOneNonUniq(state, features);
    ASSERT_EQ(0, features.size());
  }
}
