#ifndef _KIFU_ANALIZER_H
#define _KIFU_ANALIZER_H
#include "osl/game_playing/alphaBetaPlayer.h"
#include "osl/game_playing/gameState.h"

#include "osl/state/simpleState.h"
#include "osl/stl/vector.h"
#include <qdialog.h>

struct Result
{
  Result(osl::Move move, osl::Move computed_move,
	 int value, int depth)
    : move(move), computed_move(computed_move),
      value(value), depth(depth) {
  }
  osl::Move move;
  osl::Move computed_move;
  int value;
  int depth;
};

class KifuAnalyzer : public QDialog
{
public:
  KifuAnalyzer(const osl::state::SimpleState &state,
	       const osl::stl::vector<osl::Move> &moves,
	       QWidget *parent = 0, const char *name = 0);
private:
  void addResult(const osl::Move move,
		 const osl::game_playing::SearchPlayer& player,
		 const osl::game_playing::GameState& state);
  osl::state::SimpleState initial_state;
  const osl::stl::vector<osl::Move> moves;
  osl::stl::vector<Result> result;
};

#endif // _KIFU_ANALIZER_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
