#include "moveList.h"

#include "gpsshogi/gui/util.h"
#include <functional>
#include <numeric>

MoveList::MoveList(QWidget *parent)
  : Q3ListBox(parent), state(osl::state::SimpleState(osl::HIRATE))
{
}

size_t MoveList::numMoves() const
{
  return moves.size();
}

osl::Move MoveList::getMove(unsigned int n) const
{
  if (n < moves.size())
    return moves[n];
  else
    return osl::Move::INVALID();
}

int MoveList::getTime(unsigned int n) const
{
  if (n < timeList.size())
    return timeList[n];
  else
    return 0;
}

void MoveList::setState(const osl::state::SimpleState& initialState,
			const osl::vector<osl::Move>& m,
			const osl::vector<int>& t,
			const osl::vector<QString>& c)
{
  clear();
  state = initialState;
  moves = m;
  timeList = t;
  const bool has_time = std::accumulate(t.begin(), t.end(), 0, std::plus<int>()) > 0;
  osl::NumEffectState s(state);
  for (unsigned int i = 0; i < m.size(); i++)
  {
    QString moveNumber;
    moveNumber.sprintf("%3d  ", i + 1);
    QString ms = (i == 0)
      ? gpsshogi::gui::Util::moveToString(m[i], s)
      : gpsshogi::gui::Util::moveToString(m[i], s, m[i-1]);
    QString text = moveNumber + ms;
    if (has_time)
      text += QString(" %1").arg(t[i], 6);
    if (i < c.size() && c[i].size() > 0)
      text += QString("*");
    insertItem(new Q3ListBoxText(text));
    s.makeMove(m[i]);
  }
}

void MoveList::pushMove(osl::Move move)
{
  moves.push_back(move);
  int time = 1;
  timeList.push_back(time);

  QString moveNumber;
  moveNumber.sprintf("%3d  ", (int)moves.size());
  insertItem(new Q3ListBoxText(moveNumber
			       + gpsshogi::gui::Util::moveToString(move)
			       + ",          " + QString("%1").arg(time)));
}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
