#ifndef _PIECE_PAIR_H
#define _PIECE_PAIR_H
#include "gpsshogi/gui/board.h"
#include "osl/container/pieceValues.h"

class PiecePair : public gpsshogi::gui::Board
{
public:
  PiecePair(const osl::state::NumEffectState& state,
	    QWidget *parent = 0);
protected:
  void paintPiece(QPainter *painter, int x, int y, osl::Piece piece);
  virtual void updateValues() = 0;
  osl::container::PieceValues values;
};

class OpeningPair : public PiecePair
{
public:
  OpeningPair(const osl::state::NumEffectState& state,
	      QWidget *parent = 0)
    : PiecePair(state, parent) {
    updateValues();
  }
protected:
  void updateValues();
};

class EndingPieces : public PiecePair
{
public:
  EndingPieces(const osl::state::NumEffectState& state,
	       QWidget *parent = 0)
    : PiecePair(state, parent) {
    updateValues();
  }
protected:
  void updateValues();
};

class ProgressPieces : public PiecePair
{
Q_OBJECT
public:
  ProgressPieces(const osl::state::NumEffectState& state,
		 QWidget *parent = 0)
    : PiecePair(state, parent) {
    updateValues();
  }
  int progress16();
public slots:
  void setProgress(int progress);
protected:
  void updateValues();
};

#endif //_PIECE_PAIR_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
