/* A Bison parser, made by GNU Bison 1.875c.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     LABEL = 258,
     IDENTIFIER = 259,
     CBLOCK = 260,
     ENDC = 261,
     ERRORLEVEL = 262,
     FILL = 263,
     LIST = 264,
     NUMBER = 265,
     PROCESSOR = 266,
     STRING = 267,
     INCLUDE = 268,
     UPPER = 269,
     HIGH = 270,
     LOW = 271,
     LSH = 272,
     RSH = 273,
     GREATER_EQUAL = 274,
     LESS_EQUAL = 275,
     EQUAL = 276,
     NOT_EQUAL = 277,
     LOGICAL_AND = 278,
     LOGICAL_OR = 279,
     ASSIGN_PLUS = 280,
     ASSIGN_MINUS = 281,
     ASSIGN_MULTIPLY = 282,
     ASSIGN_DIVIDE = 283,
     ASSIGN_MODULUS = 284,
     ASSIGN_LSH = 285,
     ASSIGN_RSH = 286,
     ASSIGN_AND = 287,
     ASSIGN_OR = 288,
     ASSIGN_XOR = 289,
     INCREMENT = 290,
     DECREMENT = 291,
     TBL_NO_CHANGE = 292,
     TBL_POST_INC = 293,
     TBL_POST_DEC = 294,
     TBL_PRE_INC = 295,
     CONCAT = 296,
     VAR = 297,
     DEBUG_FILE = 298,
     DEBUG_LINE = 299,
     VARLAB_BEGIN = 300,
     VAR_BEGIN = 301,
     VAR_END = 302
   };
#endif
#define LABEL 258
#define IDENTIFIER 259
#define CBLOCK 260
#define ENDC 261
#define ERRORLEVEL 262
#define FILL 263
#define LIST 264
#define NUMBER 265
#define PROCESSOR 266
#define STRING 267
#define INCLUDE 268
#define UPPER 269
#define HIGH 270
#define LOW 271
#define LSH 272
#define RSH 273
#define GREATER_EQUAL 274
#define LESS_EQUAL 275
#define EQUAL 276
#define NOT_EQUAL 277
#define LOGICAL_AND 278
#define LOGICAL_OR 279
#define ASSIGN_PLUS 280
#define ASSIGN_MINUS 281
#define ASSIGN_MULTIPLY 282
#define ASSIGN_DIVIDE 283
#define ASSIGN_MODULUS 284
#define ASSIGN_LSH 285
#define ASSIGN_RSH 286
#define ASSIGN_AND 287
#define ASSIGN_OR 288
#define ASSIGN_XOR 289
#define INCREMENT 290
#define DECREMENT 291
#define TBL_NO_CHANGE 292
#define TBL_POST_INC 293
#define TBL_POST_DEC 294
#define TBL_PRE_INC 295
#define CONCAT 296
#define VAR 297
#define DEBUG_FILE 298
#define DEBUG_LINE 299
#define VARLAB_BEGIN 300
#define VAR_BEGIN 301
#define VAR_END 302




/* Copy the first part of user declarations.  */
#line 1 "parse.y"

/* Parser for gpasm
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003, 2004 
   James Bowman, Craig Franklin

This file is part of gputils.

gputils is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

gputils is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with gputils; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "stdhdr.h"

#include "libgputils.h"
#include "gpasm.h"
#include "evaluate.h"
#include "gperror.h"
#include "directive.h"
#include "lst.h"
#include "macro.h"
#include "coff.h"
#include "scan.h"

void yyerror(char *message)
{
  gperror(103, message);
}

int yylex(void);
extern int _16bit_core;

/************************************************************************/

/* Some simple functions for building parse trees */

static struct pnode *mk_pnode(enum pnode_tag tag)
{
  struct pnode *new = malloc(sizeof(*new));
  new->tag = tag;
  return new;
}

struct pnode *mk_constant(int value)
{
  struct pnode *new = mk_pnode(constant);
  new->value.constant = value;
  return new;
}

static struct pnode *mk_symbol(char *value)
{
  struct pnode *new = mk_pnode(symbol);
  new->value.symbol = value;
  return new;
}

static struct pnode *mk_string(char *value)
{
  struct pnode *new = mk_pnode(string);
  new->value.string = value;
  return new;
}

struct pnode *mk_list(struct pnode *head, struct pnode *tail)
{
  struct pnode *new = mk_pnode(list);
  new->value.list.head = head;
  new->value.list.tail = tail;
  return new;
}

static struct pnode *mk_2op(int op, struct pnode *p0, struct pnode *p1)
{
  struct pnode *new = mk_pnode(binop);
  new->value.binop.op = op;
  new->value.binop.p0 = p0;
  new->value.binop.p1 = p1;
  return new;
}

static struct pnode *mk_1op(int op, struct pnode *p0)
{
  struct pnode *new = mk_pnode(unop);  new->value.unop.op = op;
  new->value.unop.p0 = p0;
  return new;
}

/************************************************************************/
/* shared functions */

gpasmVal set_label(char *label, struct pnode *parms)
{
  gpasmVal value = 0;

  if (asm_enabled()) {
    value = do_or_append_insn("set", parms);
    if (!state.mac_prev) {
      set_global(label, value, TEMPORARY, gvt_constant);
    }
  }

  return value;
}

int return_op(int operation) 
{
  /* returns an operator for the replacement of i+=1 with i=i+1*/
  switch(operation) {
  case ASSIGN_PLUS:     return '+';
  case ASSIGN_MINUS:    return '-';
  case ASSIGN_MULTIPLY: return '*';
  case ASSIGN_DIVIDE:   return '/';
  case ASSIGN_MODULUS:  return '%';
  case ASSIGN_LSH:      return LSH;
  case ASSIGN_RSH:      return RSH;
  case ASSIGN_AND:      return '&';
  case ASSIGN_OR:       return '|';
  case ASSIGN_XOR:      return '^'; 
  default:
    assert(0); /* Unhandled operator */ 
  }

  return 0;
}

void next_line(int value)
{
  char l[BUFSIZ];
  char *e = l;

  if ((state.src->type == src_macro) || 
      (state.src->type == src_while)) {
    /* while loops can be defined inside a macro or nested */
    if (state.mac_prev) {
      state.lst.line.linetype = none;
      if (state.mac_body)
	state.mac_body->src_line = strdup(state.src->lst.m->src_line);
    }

    if (((state.src->type == src_while) || (state.lst.expand)) &&
        (state.pass == 2)) {
      assert(state.src->lst.m->src_line != NULL);
      lst_format_line(state.src->lst.m->src_line, value);
    }
    
    if (state.src->lst.m->next) {
      state.src->lst.m = state.src->lst.m->next;
    }
  } else if ((state.src->type == src_file) &&
             (state.src->lst.f != NULL)) {
    fgets(l, BUFSIZ, state.src->lst.f);
    l[strlen(l) - 1] = '\0';	/* Eat the trailing newline */

    if (state.mac_prev) {
      state.lst.line.linetype = none;
      if (state.mac_body)
	state.mac_body->src_line = strdup(l);
    }

    if (state.pass == 2) {
      lst_format_line(e, value);
    }
  }

  state.src->line_number++;

  switch (state.next_state) {
    case state_exitmacro:
      execute_exitm();
      break;

    case state_include:
      open_src(state.next_buffer.file, 1);
      free(state.next_buffer.file);
      break;

    case state_macro:
      /* push the label for local directive */
      state.stTop = push_macro_symbol_table(state.stTop);
      execute_macro(state.next_buffer.macro, 0);
      break;

    case state_section:
      /* create a new coff section */
      coff_new_section(state.obj.new_sec_name, 
                       state.obj.new_sec_addr, 
                       state.obj.new_sec_flags);
      break;

    case state_while:
      execute_macro(state.next_buffer.macro, 1);
      break;

    default:
      break;
  }
 
}


/************************************************************************/



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 218 "parse.y"
typedef union YYSTYPE {
  gpasmVal i;
  char *s;
  struct pnode *p;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 391 "parse.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 403 "parse.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   define YYSTACK_ALLOC alloca
#  endif
# else
#  if defined (alloca) || defined (_ALLOCA_H)
#   define YYSTACK_ALLOC alloca
#  else
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   412

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  67
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  41
/* YYNRULES -- Number of rules. */
#define YYNRULES  119
/* YYNRULES -- Number of states. */
#define YYNSTATES  182

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   302

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      61,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    59,     2,     2,    65,    58,    25,     2,
      66,    62,    56,    54,    63,    55,     2,    57,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    64,     2,
      23,    30,    24,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    27,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    26,     2,    60,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    28,    29,
      31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     4,     5,     9,    13,    17,    21,    26,
      31,    35,    39,    42,    44,    46,    49,    50,    55,    58,
      59,    64,    65,    70,    73,    77,    84,    92,    93,   101,
     102,   109,   114,   115,   118,   120,   123,   126,   130,   132,
     136,   138,   142,   144,   146,   148,   150,   152,   154,   156,
     158,   160,   162,   164,   167,   171,   173,   175,   177,   181,
     183,   185,   189,   191,   193,   197,   199,   201,   205,   207,
     209,   211,   213,   217,   219,   221,   223,   225,   227,   229,
     231,   235,   237,   239,   241,   245,   247,   249,   251,   255,
     257,   259,   261,   263,   266,   268,   270,   272,   274,   276,
     278,   280,   282,   284,   286,   290,   292,   294,   296,   298,
     300,   304,   308,   310,   314,   318,   320,   324,   325,   330
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      68,     0,    -1,    -1,    -1,    68,    69,    70,    -1,    68,
       1,    61,    -1,    49,    12,    61,    -1,    50,    10,    61,
      -1,   104,    81,    83,    61,    -1,   104,    30,    83,    61,
      -1,   104,    42,    61,    -1,   104,    41,    61,    -1,   104,
      71,    -1,    71,    -1,    61,    -1,    13,    61,    -1,    -1,
      11,    72,     4,    61,    -1,     9,    61,    -1,    -1,     9,
      73,   105,    61,    -1,    -1,     7,    74,    82,    61,    -1,
       4,    61,    -1,     4,    82,    61,    -1,     8,     4,    62,
      63,    83,    61,    -1,     8,     4,    82,    62,    63,    83,
      61,    -1,    -1,     5,    83,    61,    75,    77,     6,    61,
      -1,    -1,     5,    61,    76,    77,     6,    61,    -1,     5,
       1,     6,    61,    -1,    -1,    77,    78,    -1,    61,    -1,
      79,    61,    -1,   104,    61,    -1,   104,    83,    61,    -1,
      80,    -1,    79,    63,    80,    -1,   103,    -1,   103,    64,
      83,    -1,    31,    -1,    32,    -1,    33,    -1,    34,    -1,
      35,    -1,    36,    -1,    37,    -1,    38,    -1,    39,    -1,
      40,    -1,    83,    -1,    83,    63,    -1,    83,    63,    82,
      -1,    84,    -1,    12,    -1,    86,    -1,    84,    85,    86,
      -1,    30,    -1,    88,    -1,    86,    87,    88,    -1,    29,
      -1,    90,    -1,    88,    89,    90,    -1,    28,    -1,    92,
      -1,    90,    91,    92,    -1,    25,    -1,    26,    -1,    27,
      -1,    94,    -1,    92,    93,    94,    -1,    23,    -1,    24,
      -1,    21,    -1,    22,    -1,    19,    -1,    20,    -1,    96,
      -1,    94,    95,    96,    -1,    17,    -1,    18,    -1,    98,
      -1,    96,    97,    98,    -1,    54,    -1,    55,    -1,   100,
      -1,    98,    99,   100,    -1,    56,    -1,    57,    -1,    58,
      -1,   102,    -1,   101,   102,    -1,    14,    -1,    15,    -1,
      16,    -1,    55,    -1,    59,    -1,    60,    -1,    54,    -1,
     103,    -1,    10,    -1,    65,    -1,    66,    83,    62,    -1,
      56,    -1,    44,    -1,    45,    -1,    46,    -1,     4,    -1,
      52,    83,    62,    -1,    52,    83,    53,    -1,     3,    -1,
      51,    83,    62,    -1,    51,    83,    53,    -1,   106,    -1,
     106,    63,   105,    -1,    -1,     4,   107,    85,    86,    -1,
      86,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   315,   315,   319,   318,   324,   331,   339,   347,   359,
     368,   377,   386,   451,   464,   473,   478,   478,   485,   490,
     490,   497,   497,   504,   509,   514,   530,   547,   546,   565,
     564,   580,   586,   588,   595,   597,   604,   613,   624,   626,
     630,   637,   645,   645,   645,   646,   646,   646,   646,   647,
     647,   647,   650,   655,   661,   668,   670,   677,   679,   685,
     688,   690,   696,   699,   701,   707,   710,   712,   718,   718,
     718,   721,   723,   729,   729,   729,   729,   729,   729,   732,
     734,   740,   740,   743,   745,   751,   751,   754,   756,   762,
     762,   762,   765,   767,   773,   773,   773,   773,   773,   773,
     773,   776,   781,   786,   791,   796,   801,   806,   811,   818,
     823,   828,   836,   841,   849,   859,   864,   872,   871,   883
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "LABEL", "IDENTIFIER", "CBLOCK", "ENDC",
  "ERRORLEVEL", "FILL", "LIST", "NUMBER", "PROCESSOR", "STRING", "INCLUDE",
  "UPPER", "HIGH", "LOW", "LSH", "RSH", "GREATER_EQUAL", "LESS_EQUAL",
  "EQUAL", "NOT_EQUAL", "'<'", "'>'", "'&'", "'|'", "'^'", "LOGICAL_AND",
  "LOGICAL_OR", "'='", "ASSIGN_PLUS", "ASSIGN_MINUS", "ASSIGN_MULTIPLY",
  "ASSIGN_DIVIDE", "ASSIGN_MODULUS", "ASSIGN_LSH", "ASSIGN_RSH",
  "ASSIGN_AND", "ASSIGN_OR", "ASSIGN_XOR", "INCREMENT", "DECREMENT",
  "TBL_NO_CHANGE", "TBL_POST_INC", "TBL_POST_DEC", "TBL_PRE_INC", "CONCAT",
  "VAR", "DEBUG_FILE", "DEBUG_LINE", "VARLAB_BEGIN", "VAR_BEGIN",
  "VAR_END", "'+'", "'-'", "'*'", "'/'", "'%'", "'!'", "'~'", "'\\n'",
  "')'", "','", "':'", "'$'", "'('", "$accept", "program", "@1", "line",
  "statement", "@2", "@3", "@4", "@5", "@6", "const_block", "const_line",
  "const_def_list", "const_def", "assign_equal_ops", "parameter_list",
  "expr", "e9", "e9op", "e8", "e8op", "e7", "e7op", "e6", "e6op", "e5",
  "e5op", "e4", "e4op", "e3", "e3op", "e2", "e2op", "e1", "e1op", "e0",
  "cidentifier", "label_concat", "list_block", "list_expr", "@7", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,    60,    62,    38,   124,    94,   278,   279,
      61,   280,   281,   282,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,    43,    45,    42,    47,    37,    33,
     126,    10,    41,    44,    58,    36,    40
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    67,    68,    69,    68,    68,    70,    70,    70,    70,
      70,    70,    70,    70,    71,    71,    72,    71,    71,    73,
      71,    74,    71,    71,    71,    71,    71,    75,    71,    76,
      71,    71,    77,    77,    78,    78,    78,    78,    79,    79,
      80,    80,    81,    81,    81,    81,    81,    81,    81,    81,
      81,    81,    82,    82,    82,    83,    83,    84,    84,    85,
      86,    86,    87,    88,    88,    89,    90,    90,    91,    91,
      91,    92,    92,    93,    93,    93,    93,    93,    93,    94,
      94,    95,    95,    96,    96,    97,    97,    98,    98,    99,
      99,    99,   100,   100,   101,   101,   101,   101,   101,   101,
     101,   102,   102,   102,   102,   102,   102,   102,   102,   103,
     103,   103,   104,   104,   104,   105,   105,   107,   106,   106
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     0,     3,     3,     3,     3,     4,     4,
       3,     3,     2,     1,     1,     2,     0,     4,     2,     0,
       4,     0,     4,     2,     3,     6,     7,     0,     7,     0,
       6,     4,     0,     2,     1,     2,     2,     3,     1,     3,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     3,     1,     1,     1,     3,     1,
       1,     3,     1,     1,     3,     1,     1,     3,     1,     1,
       1,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     1,     1,     3,     1,     1,     1,     3,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     1,     1,     1,     1,
       3,     3,     1,     3,     3,     1,     3,     0,     4,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       2,     0,     1,     0,     0,     5,   112,     0,     0,    21,
       0,    19,    16,     0,     0,     0,     0,    14,     4,    13,
       0,   109,   102,    56,    94,    95,    96,   106,   107,   108,
       0,   100,    97,   105,    98,    99,    23,   103,     0,     0,
      52,    55,    57,    60,    63,    66,    71,    79,    83,    87,
       0,    92,   101,     0,    29,     0,     0,     0,    18,     0,
       0,    15,     0,     0,     0,     0,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,     0,     0,    12,     0,
       0,     0,    24,    53,    59,     0,    62,     0,    65,     0,
      68,    69,    70,     0,    77,    78,    75,    76,    73,    74,
       0,    81,    82,     0,    85,    86,     0,    89,    90,    91,
       0,    93,     0,    32,    27,     0,     0,     0,   109,   119,
       0,   115,     0,     6,     7,   114,   113,     0,    11,    10,
       0,   111,   110,   104,    54,    58,    61,    64,    67,    72,
      80,    84,    88,    31,     0,    32,    22,     0,     0,     0,
      20,     0,    17,     9,     8,     0,    34,    33,     0,    38,
      40,     0,     0,     0,     0,     0,   116,    30,    35,     0,
       0,    36,     0,     0,    25,     0,   118,    39,    41,    37,
      28,    26
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     4,    18,    19,    60,    59,    56,   145,   113,
     144,   157,   158,   159,    79,    39,    40,    41,    85,    42,
      87,    43,    89,    44,    93,    45,   100,    46,   103,    47,
     106,    48,   110,    49,    50,    51,    52,   161,   120,   121,
     149
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -130
static const short yypact[] =
{
    -130,   270,  -130,   -55,   319,  -130,  -130,    35,     9,  -130,
       8,   -41,  -130,   -35,    16,    28,   186,  -130,  -130,  -130,
     351,  -130,  -130,  -130,  -130,  -130,  -130,  -130,  -130,  -130,
     186,  -130,  -130,  -130,  -130,  -130,  -130,  -130,   186,   -20,
     -19,    13,    17,    20,    33,   201,    14,   -37,    46,  -130,
      32,  -130,  -130,    50,  -130,     1,   186,   105,  -130,   203,
      62,  -130,     6,    11,   -48,   186,  -130,  -130,  -130,  -130,
    -130,  -130,  -130,  -130,  -130,  -130,    12,    24,  -130,   186,
     -46,    37,  -130,   186,  -130,   250,  -130,   250,  -130,   250,
    -130,  -130,  -130,   250,  -130,  -130,  -130,  -130,  -130,  -130,
     250,  -130,  -130,   250,  -130,  -130,   250,  -130,  -130,  -130,
     250,  -130,    25,  -130,  -130,    44,    43,    48,    78,    17,
      51,    53,    52,  -130,  -130,  -130,  -130,    57,  -130,  -130,
      61,  -130,  -130,  -130,  -130,    17,    20,    33,   201,    14,
     -37,    46,  -130,  -130,    31,  -130,  -130,   186,    60,    13,
    -130,   203,  -130,  -130,  -130,    63,  -130,  -130,   -52,  -130,
      47,   128,   124,    64,   186,   250,  -130,  -130,  -130,     0,
     186,  -130,    65,    68,  -130,    70,    17,  -130,  -130,  -130,
    -130,  -130
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
    -130,  -130,  -130,  -130,    94,  -130,  -130,  -130,  -130,  -130,
     -12,  -130,  -130,   -34,  -130,   -54,    -8,  -130,   -15,   -58,
    -130,    49,  -130,    56,  -130,    54,  -130,    41,  -130,    34,
    -130,    40,  -130,    38,  -130,   102,  -129,   150,     4,  -130,
    -130
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -118
static const short yytable[] =
{
      55,   119,   115,   117,    21,   125,     5,   131,    64,   168,
      53,   169,    57,    21,   126,   160,   132,   104,   105,    22,
      58,    23,    80,    24,    25,    26,    61,   135,    62,   134,
      81,   101,   102,   160,     6,    21,    21,   155,    63,    21,
     160,    82,    22,    84,    83,    22,    86,    23,    88,    24,
      25,    26,    30,    27,    28,    29,   112,   127,    90,    91,
      92,    30,   114,    31,    32,    33,   122,   123,    34,    35,
      54,   130,   124,   128,    37,    38,    27,    28,    29,    27,
      28,    29,    16,    30,    30,   129,   143,    30,    33,    31,
      32,    33,   156,   119,    34,    35,    36,    37,    38,   133,
      37,    38,   107,   108,   109,   146,   147,   176,  -117,    21,
     148,   170,   150,   152,    78,    22,   151,    23,   153,    24,
      25,    26,   154,   164,   167,   174,   179,     6,    21,   180,
     173,   181,    21,   162,   165,   177,   136,   140,    22,   163,
      23,   139,    24,    25,    26,   137,   141,   138,   142,    27,
      28,    29,   111,   172,    20,   166,   175,    30,     0,    31,
      32,    33,   178,     0,    34,    35,     0,   116,     0,     0,
      37,    38,    27,    28,    29,    16,    30,     0,     0,     0,
      30,     0,    31,    32,    33,   156,     0,    34,    35,   171,
      21,     0,     0,    37,    38,     0,    22,     0,    23,     0,
      24,    25,    26,     0,     0,     0,     0,   118,     0,     0,
       0,     0,     0,    22,     0,     0,     0,    24,    25,    26,
      94,    95,    96,    97,    98,    99,     0,     0,     0,     0,
      27,    28,    29,     0,     0,     0,     0,     0,    30,     0,
      31,    32,    33,     0,     0,    34,    35,    27,    28,    29,
       0,    37,    38,     0,    21,    30,     0,    31,    32,    33,
      22,     0,    34,    35,    24,    25,    26,     0,    37,    38,
       2,     3,     0,    -3,    -3,    -3,     0,    -3,    -3,    -3,
       0,    -3,     0,    -3,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    27,    28,    29,     0,     0,     0,
       0,     0,    30,     0,    31,    32,    33,     0,     0,    34,
      35,     0,     0,     0,     0,    37,    38,     0,     0,    -3,
      -3,    -3,     6,     7,     8,     0,     9,    10,    11,     0,
      12,    -3,    13,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     7,     8,     0,     9,    10,
      11,     0,    12,     0,    13,     0,     0,     0,    14,    15,
      16,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      17,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    17
};

static const short yycheck[] =
{
       8,    59,    56,    57,     4,    53,    61,    53,    16,    61,
       1,    63,     4,     4,    62,   144,    62,    54,    55,    10,
      61,    12,    30,    14,    15,    16,    61,    85,    12,    83,
      38,    17,    18,   162,     3,     4,     4,     6,    10,     4,
     169,    61,    10,    30,    63,    10,    29,    12,    28,    14,
      15,    16,    52,    44,    45,    46,     6,    65,    25,    26,
      27,    52,    61,    54,    55,    56,     4,    61,    59,    60,
      61,    79,    61,    61,    65,    66,    44,    45,    46,    44,
      45,    46,    51,    52,    52,    61,    61,    52,    56,    54,
      55,    56,    61,   151,    59,    60,    61,    65,    66,    62,
      65,    66,    56,    57,    58,    61,    63,   165,    30,     4,
      62,    64,    61,    61,    20,    10,    63,    12,    61,    14,
      15,    16,    61,    63,    61,    61,    61,     3,     4,    61,
       6,    61,     4,   145,   149,   169,    87,   103,    10,   147,
      12,   100,    14,    15,    16,    89,   106,    93,   110,    44,
      45,    46,    50,   161,     4,   151,   164,    52,    -1,    54,
      55,    56,   170,    -1,    59,    60,    -1,    62,    -1,    -1,
      65,    66,    44,    45,    46,    51,    52,    -1,    -1,    -1,
      52,    -1,    54,    55,    56,    61,    -1,    59,    60,    61,
       4,    -1,    -1,    65,    66,    -1,    10,    -1,    12,    -1,
      14,    15,    16,    -1,    -1,    -1,    -1,     4,    -1,    -1,
      -1,    -1,    -1,    10,    -1,    -1,    -1,    14,    15,    16,
      19,    20,    21,    22,    23,    24,    -1,    -1,    -1,    -1,
      44,    45,    46,    -1,    -1,    -1,    -1,    -1,    52,    -1,
      54,    55,    56,    -1,    -1,    59,    60,    44,    45,    46,
      -1,    65,    66,    -1,     4,    52,    -1,    54,    55,    56,
      10,    -1,    59,    60,    14,    15,    16,    -1,    65,    66,
       0,     1,    -1,     3,     4,     5,    -1,     7,     8,     9,
      -1,    11,    -1,    13,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    44,    45,    46,    -1,    -1,    -1,
      -1,    -1,    52,    -1,    54,    55,    56,    -1,    -1,    59,
      60,    -1,    -1,    -1,    -1,    65,    66,    -1,    -1,    49,
      50,    51,     3,     4,     5,    -1,     7,     8,     9,    -1,
      11,    61,    13,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     4,     5,    -1,     7,     8,
       9,    -1,    11,    -1,    13,    -1,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      61,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    61
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,    68,     0,     1,    69,    61,     3,     4,     5,     7,
       8,     9,    11,    13,    49,    50,    51,    61,    70,    71,
     104,     4,    10,    12,    14,    15,    16,    44,    45,    46,
      52,    54,    55,    56,    59,    60,    61,    65,    66,    82,
      83,    84,    86,    88,    90,    92,    94,    96,    98,   100,
     101,   102,   103,     1,    61,    83,    74,     4,    61,    73,
      72,    61,    12,    10,    83,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    71,    81,
      83,    83,    61,    63,    30,    85,    29,    87,    28,    89,
      25,    26,    27,    91,    19,    20,    21,    22,    23,    24,
      93,    17,    18,    95,    54,    55,    97,    56,    57,    58,
      99,   102,     6,    76,    61,    82,    62,    82,     4,    86,
     105,   106,     4,    61,    61,    53,    62,    83,    61,    61,
      83,    53,    62,    62,    82,    86,    88,    90,    92,    94,
      96,    98,   100,    61,    77,    75,    61,    63,    62,   107,
      61,    63,    61,    61,    61,     6,    61,    78,    79,    80,
     103,   104,    77,    83,    63,    85,   105,    61,    61,    63,
      64,    61,    83,     6,    61,    83,    86,    80,    83,    61,
      61,    61
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)		\
   ((Current).first_line   = (Rhs)[1].first_line,	\
    (Current).first_column = (Rhs)[1].first_column,	\
    (Current).last_line    = (Rhs)[N].last_line,	\
    (Current).last_column  = (Rhs)[N].last_column)
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if defined (YYMAXDEPTH) && YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 3:
#line 319 "parse.y"
    { 
          state.lst.line.was_org = state.org; 
          state.lst.line.linetype = none; 
          state.next_state = state_nochange;
        }
    break;

  case 5:
#line 325 "parse.y"
    { 
	  next_line(0);
	}
    break;

  case 6:
#line 332 "parse.y"
    {
          if ((state.mode == relocatable) && (state.debug_info)) {
	    state.obj.debug_file = coff_add_filesym(yyvsp[-1].s, 0);
          }
	  next_line(0);
	}
    break;

  case 7:
#line 340 "parse.y"
    {
	  if ((state.mode == relocatable) && (state.debug_info)) {
	    state.obj.debug_line = yyvsp[-1].i;
          }
          next_line(0);
	}
    break;

  case 8:
#line 348 "parse.y"
    {
	  struct pnode *parms;
	  int exp_result;

          exp_result = do_insn("set", mk_list(yyvsp[-1].p, NULL));          
          parms = mk_list(mk_2op(return_op(yyvsp[-2].i), 
                                 mk_symbol(yyvsp[-3].s), 
                                 mk_constant(exp_result)), NULL);
	  next_line(set_label(yyvsp[-3].s, parms));
	}
    break;

  case 9:
#line 360 "parse.y"
    {
	  struct pnode *parms;

	  /* implements i = 6 + 1 */           
	  parms = mk_list(yyvsp[-1].p, NULL);
	  next_line(set_label(yyvsp[-3].s, parms));
	}
    break;

  case 10:
#line 369 "parse.y"
    {
	  struct pnode *parms;

	  /* implements i-- */           
	  parms = mk_list(mk_1op(DECREMENT, mk_symbol(yyvsp[-2].s)), NULL);
	  next_line(set_label(yyvsp[-2].s, parms));
	}
    break;

  case 11:
#line 378 "parse.y"
    {
          struct pnode *parms;

	  /* implements i++ */          
	  parms = mk_list(mk_1op(INCREMENT, mk_symbol(yyvsp[-2].s)), NULL);
	  next_line(set_label(yyvsp[-2].s, parms));
	}
    break;

  case 12:
#line 387 "parse.y"
    {
	  if (asm_enabled() && (state.lst.line.linetype == none))
	    state.lst.line.linetype = insn;
	  
	  if (asm_enabled()) {
	    if (state.mac_head) {
	      /* This is a macro definition.  Set it up */
	      struct symbol *mac;
	      struct macro_head *h = NULL;

	      mac = get_symbol(state.stMacros, yyvsp[-1].s);
	      if (mac)
		h = get_symbol_annotation(mac);

	      /* It's not an error if macro was defined on pass 1 and
		 we're in pass 2. */
	      if (h &&
		  !((h->pass == 1) && (state.pass == 2))) {
		gperror(GPE_DUPLICATE_MACRO, NULL);
	      } else {
		if (!mac)
		  mac = add_symbol(state.stMacros, yyvsp[-1].s);
		annotate_symbol(mac, state.mac_head);
		h = state.mac_head;
		h->line_number = state.src->line_number;
		h->file_symbol = state.src->file_symbol;
	      }
	      h->pass = state.pass;
 	      
	      /* The macro is defined so allow calls. */
	      if (state.pass == 2)
	        h->defined = 1;

	      state.mac_head = NULL;
	    } else if (!state.mac_prev) {
	      /* Outside a macro, just define the label. */
	      switch (state.lst.line.linetype) {
	      case sec:
		strncpy(state.obj.new_sec_name, yyvsp[-1].s, 78);
		break;
	      case set:
		set_global(yyvsp[-1].s, yyvsp[0].i, TEMPORARY, gvt_constant);
		break;
              case org:
	      case equ:
		set_global(yyvsp[-1].s, yyvsp[0].i, PERMANENT, gvt_constant);
		break;
	      case insn:
		set_global(yyvsp[-1].s, yyvsp[0].i << _16bit_core, PERMANENT, gvt_address);
		break;
	      case res:
		set_global(yyvsp[-1].s, yyvsp[0].i, PERMANENT, gvt_static);
                break;
	      case dir:
                gperror(GPE_ILLEGAL_LABEL, NULL);
                break;
              default:
		break;
	      }
	    }
	  }
	  next_line(yyvsp[0].i);
	}
    break;

  case 13:
#line 452 "parse.y"
    {
	  if (state.mac_head) {
	    /* This is a macro definition, but the label was missing */
	    state.mac_head = NULL;
	    gperror(GPE_NO_MACRO_NAME, NULL);
	  } else {
	    next_line(0);
	  }
	}
    break;

  case 14:
#line 465 "parse.y"
    {
	  if (!state.mac_prev) {
	    yyval.i = state.org;
	  } else {
	    macro_append();
	  }
	}
    break;

  case 15:
#line 474 "parse.y"
    {
	  yyval.i = do_or_append_insn("include", mk_list(mk_string(yyvsp[-1].s), NULL));
	}
    break;

  case 16:
#line 478 "parse.y"
    {  force_ident = 1; }
    break;

  case 17:
#line 480 "parse.y"
    {
	  yyval.i = do_or_append_insn(yyvsp[-3].s, mk_list(mk_symbol(yyvsp[-1].s), NULL));
	  force_ident = 0;
	}
    break;

  case 18:
#line 486 "parse.y"
    {
	  yyval.i = do_or_append_insn(yyvsp[-1].s, NULL);
	}
    break;

  case 19:
#line 490 "parse.y"
    {  force_decimal = 1; }
    break;

  case 20:
#line 492 "parse.y"
    {
	  yyval.i = do_or_append_insn(yyvsp[-3].s, yyvsp[-1].p);
	  force_decimal = 0;
	}
    break;

  case 21:
#line 497 "parse.y"
    {  force_decimal = 1; }
    break;

  case 22:
#line 499 "parse.y"
    {
	  yyval.i = do_or_append_insn(yyvsp[-3].s, yyvsp[-1].p);
	  force_decimal = 0;
	}
    break;

  case 23:
#line 505 "parse.y"
    {
	  yyval.i = do_or_append_insn(yyvsp[-1].s, NULL);
	}
    break;

  case 24:
#line 510 "parse.y"
    {
	  yyval.i = do_or_append_insn(yyvsp[-2].s, yyvsp[-1].p);
	}
    break;

  case 25:
#line 515 "parse.y"
    {
	  int number;
	  int i;

          if (!state.mac_prev) {
            number = eval_fill_number(yyvsp[-1].p);

            for (i = 0; i < number; i++) {
              yyval.i = do_insn(yyvsp[-4].s, NULL);
            }
          } else {
	    macro_append();
	  }
	}
    break;

  case 26:
#line 531 "parse.y"
    {
	  int number;
	  int i;

          if (!state.mac_prev) {
            number = eval_fill_number(yyvsp[-1].p);

            for (i = 0; i < number; i++) {
              yyval.i = do_insn(yyvsp[-5].s, yyvsp[-4].p);
            }
          } else {
	    macro_append();
	  }
	}
    break;

  case 27:
#line 547 "parse.y"
    {
	  if (!state.mac_prev) {
	    begin_cblock(yyvsp[-1].p);
	  } else {
	    macro_append();
	  }
	  next_line(0);
	}
    break;

  case 28:
#line 557 "parse.y"
    {
	  if (state.mac_prev) {
	    macro_append();
	  }
	  yyval.i = 0;
	}
    break;

  case 29:
#line 565 "parse.y"
    {
	  if (state.mac_prev) {
	    macro_append();
	  }
	  next_line(0);
	}
    break;

  case 30:
#line 573 "parse.y"
    {
	  if (state.mac_prev) {
	    macro_append();
	  }
	  yyval.i = 0;
	}
    break;

  case 31:
#line 581 "parse.y"
    {
	  yyval.i = 0;
  	}
    break;

  case 33:
#line 589 "parse.y"
    {
	  next_line(0);
	}
    break;

  case 35:
#line 598 "parse.y"
    {
	  if (state.mac_prev) {
	    macro_append();
	  }
	}
    break;

  case 36:
#line 605 "parse.y"
    {
	  if (!state.mac_prev) {
	    cblock_expr(mk_symbol(yyvsp[-1].s));
	  } else {
	    macro_append();
	  }
	}
    break;

  case 37:
#line 614 "parse.y"
    {
	  if (!state.mac_prev) {
	    cblock_expr_incr(mk_symbol(yyvsp[-2].s), yyvsp[-1].p);
	  } else {
	    macro_append();
	  }
	}
    break;

  case 40:
#line 631 "parse.y"
    {
	  if (!state.mac_prev) {
	    cblock_expr(yyvsp[0].p);
	  }
	}
    break;

  case 41:
#line 638 "parse.y"
    {
	  if (!state.mac_prev) {
	    cblock_expr_incr(yyvsp[-2].p, yyvsp[0].p);
	  }
	}
    break;

  case 52:
#line 651 "parse.y"
    {
	  yyval.p = mk_list(yyvsp[0].p, NULL);
	}
    break;

  case 53:
#line 656 "parse.y"
    {
	  gperror(GPE_BADCHAR, "Illegal Character (,)");
          yyval.p = mk_list(yyvsp[-1].p, NULL);
	}
    break;

  case 54:
#line 662 "parse.y"
    {
	  yyval.p = mk_list(yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 56:
#line 671 "parse.y"
    {
	  yyval.p = mk_string(yyvsp[0].s);
        }
    break;

  case 58:
#line 680 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 61:
#line 691 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 64:
#line 702 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 67:
#line 713 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 72:
#line 724 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 80:
#line 735 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 84:
#line 746 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 88:
#line 757 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 93:
#line 768 "parse.y"
    {
	  yyval.p = mk_1op(yyvsp[-1].i, yyvsp[0].p);
	}
    break;

  case 101:
#line 777 "parse.y"
    {
	  yyval.p = yyvsp[0].p;
        }
    break;

  case 102:
#line 782 "parse.y"
    {
	  yyval.p = mk_constant(yyvsp[0].i);
	}
    break;

  case 103:
#line 787 "parse.y"
    {
	  yyval.p = mk_symbol("$");
	}
    break;

  case 104:
#line 792 "parse.y"
    {
	  yyval.p = yyvsp[-1].p;
	}
    break;

  case 105:
#line 797 "parse.y"
    {
	  yyval.p = mk_constant(TBL_NO_CHANGE);
	}
    break;

  case 106:
#line 802 "parse.y"
    {
	  yyval.p = mk_constant(yyvsp[0].i);
	}
    break;

  case 107:
#line 807 "parse.y"
    {
	  yyval.p = mk_constant(yyvsp[0].i);
	}
    break;

  case 108:
#line 812 "parse.y"
    {
	  yyval.p = mk_constant(yyvsp[0].i);
	}
    break;

  case 109:
#line 819 "parse.y"
    { 
          yyval.p = mk_symbol(yyvsp[0].s);
        }
    break;

  case 110:
#line 824 "parse.y"
    {
          yyval.p = mk_2op(CONCAT, mk_symbol(yyvsp[-2].s), mk_1op(VAR, yyvsp[-1].p));
        }
    break;

  case 111:
#line 829 "parse.y"
    {
          yyval.p = mk_2op(CONCAT, mk_symbol(yyvsp[-2].s), 
                        mk_2op(CONCAT, mk_1op(VAR, yyvsp[-1].p), mk_symbol(yyvsp[0].s)));
        }
    break;

  case 112:
#line 837 "parse.y"
    { 
          yyval.s = yyvsp[0].s;
        }
    break;

  case 113:
#line 842 "parse.y"
    {
          if (asm_enabled() && !state.mac_prev) {
	    yyval.s = evaluate_concatenation(mk_2op(CONCAT,  mk_symbol(yyvsp[-2].s), 
                           mk_1op(VAR, yyvsp[-1].p)));
	  }
        }
    break;

  case 114:
#line 850 "parse.y"
    {
          if (asm_enabled() && !state.mac_prev) {
            yyval.s = evaluate_concatenation(mk_2op(CONCAT,  mk_symbol(yyvsp[-2].s), 
                      mk_2op(CONCAT, mk_1op(VAR, yyvsp[-1].p), mk_symbol(yyvsp[0].s))));
	  }
        }
    break;

  case 115:
#line 860 "parse.y"
    {
	  yyval.p = mk_list(yyvsp[0].p, NULL);
	}
    break;

  case 116:
#line 865 "parse.y"
    {
	  yyval.p = mk_list(yyvsp[-2].p, yyvsp[0].p);
	}
    break;

  case 117:
#line 872 "parse.y"
    {
	  if (strcasecmp(yyvsp[0].s, "p") == 0) { 
            force_ident = 1;
          }
        }
    break;

  case 118:
#line 878 "parse.y"
    {
	  yyval.p = mk_2op(yyvsp[-1].i, mk_symbol(yyvsp[-3].s), yyvsp[0].p);
	  force_ident = 0;
	}
    break;

  case 119:
#line 884 "parse.y"
    {
	  yyval.p = yyvsp[0].p;
	}
    break;


    }

/* Line 1000 of yacc.c.  */
#line 2134 "parse.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  const char* yyprefix;
	  char *yymsg;
	  int yyx;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 0;

	  yyprefix = ", expecting ";
	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		yysize += yystrlen (yyprefix) + yystrlen (yytname [yyx]);
		yycount += 1;
		if (yycount == 5)
		  {
		    yysize = 0;
		    break;
		  }
	      }
	  yysize += (sizeof ("syntax error, unexpected ")
		     + yystrlen (yytname[yytype]));
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yyprefix = ", expecting ";
		  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			yyp = yystpcpy (yyp, yyprefix);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yyprefix = " or ";
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {
		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
		 yydestruct (yystos[*yyssp], yyvsp);
	       }
        }
      else
	{
	  YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
	  yydestruct (yytoken, &yylval);
	  yychar = YYEMPTY;

	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

#ifdef __GNUC__
  /* Pacify GCC when the user code never invokes YYERROR and the label
     yyerrorlab therefore never appears in user code.  */
  if (0)
     goto yyerrorlab;
#endif

  yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 889 "parse.y"


