/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2003 Bert Vermeulen
    Copyright (C) 2002-2003 Peter Stamfest

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: dt_entry.c,v 1.12 2003/11/02 07:20:43 stamfest Exp $ */

#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <config.h>

#include "dt_entry.h"

#include "common.h"
#include "util.h"
#include "errorchain.h"
#include "input.h"
#include "tinput.h"
#include "browse.h"
#include "encode.h"
#include "ldif.h" /* for b64_decode */
#include "syntax.h"
#include "dtutil.h"


static dt_entry_handler dt_entry_handler_vtab = {
     {
	  "Entry", 
	  TRUE,
	  TRUE,

	  dt_entry_get_widget,
	  dt_entry_get_data,
	  dt_entry_set_data,
	  bervalLDAPMod
     },
#if GTK_MAJOR < 2
     decode_utf8, /* encode method */
     encode_utf8, /* decode method */
#else
     /* gtk2 uses UTF-8 natively! Yipieeh */
     NULL,
     NULL,
#endif
};

display_type_handler *dt_entry_get_handler() {
     return (display_type_handler *) &dt_entry_handler_vtab;
}


GtkWidget *dt_entry_get_widget(int error_context,
			       struct formfill *form, GByteArray *data,
			       GtkSignalFunc *activatefunc,
			       gpointer funcdata) 
{
    GtkWidget *inputbox;


    inputbox = gtk_entry_new();
    if(activatefunc)
	gtk_signal_connect_object(GTK_OBJECT(inputbox), "activate",
				  GTK_SIGNAL_FUNC(activatefunc), 
				  (gpointer) funcdata);
    dt_entry_set_data(form, data, inputbox);

    return inputbox;
}

GByteArray *dt_entry_get_data(struct formfill *form, GtkWidget *widget) 
{
    return editable_get_text(GTK_EDITABLE(widget));
}

void dt_entry_set_data(struct formfill *form, GByteArray *data,
		       GtkWidget *widget) 
{
     editable_set_text(GTK_EDITABLE(widget), data,
		       DT_ENTRY(form->dt_handler)->encode,
		       DT_ENTRY(form->dt_handler)->decode);
}

#if GTK_MAJOR < 2
GByteArray *decode_utf8(const char *val, int len)
{
     GByteArray *gb = g_byte_array_new();

     if (gb) {
	  gb = g_byte_array_set_size(gb, len + 1);
	  memset(gb->data, 0, len + 1);
	  decode_string(gb->data, val, len);
	  /* trusting g_byte_array_set_size to keep that nul-byte - FIXME */
	  g_byte_array_set_size(gb, strlen(gb->data));
     }
/*       printf("identity %s %d\n", gb->data, len); */
     return gb;
}

GByteArray *encode_utf8(const char *val, int len)
{
     GByteArray *gb = g_byte_array_new();

     if (gb) {
	  gb = g_byte_array_set_size(gb, 2 * len + 1);
	  memset(gb->data, 0, 2 * len + 1);
	  encode_string(gb->data, val, len);
	  /* trusting g_byte_array_set_size to keep that nul-byte */
	  g_byte_array_set_size(gb, strlen(gb->data));
     }
     return gb;
}
#endif

/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
