/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_My_DRIVER_H)
#define __INC_My_DRIVER_H


#include "gql++/driver.h"

namespace GQL
{

namespace MySQL
{

class MyDriver : public Driver
{
    typedef std::map<std::string, std::string> property_type;
  public:
    MyDriver(Yehia::PluginManager& mgr);

    virtual bool accept_url(const std::string& str) const;
    virtual Connection *connect(const std::string& url,
                                const property_type& prop);
    
    virtual std::vector<DriverPropertyInfo> get_property_info(
            const std::string& url,
            const property_type& props) const;

    property_type parse_url(
            const std::string& url,
            const property_type& props = property_type()) const;
    
    const std::string& host() const;
    const std::string& port() const;
    const std::string& database() const;
  private:
    property_type props_;
};


}
}

#endif
