/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_PG_DATABASE_METADATA_H)
#define __INC_PG_DATABASE_METADATA_H

#include "gql++/database-metadata.h"
#include "connection.h"

namespace GQL
{

namespace PG
{

class PGDatabaseMetaData : public DatabaseMetaData
{
  public:
    PGDatabaseMetaData(PGConnection *conn);
    virtual ResultSet *get_tables(const std::string& catalog,
                                  const std::string& schema_pattern,
                                  const std::string& table_name_pattern,
                                  const vector<string>& types);

    virtual ResultSet *get_columns(const std::string& catalog,
                                   const std::string& schema_pattern,
                                   const std::string& table_name_pattern,
                                   const std::string& table_name_pattern);

    virtual ResultSet *get_primary_keys(const std::string& catalog,
                                        const std::string& schema,
                                        const std::string& table);

    ResultSet *get_xrefs(const std::string& ptable, const std::string& ftable);

    virtual ResultSet *get_cross_reference(const std::string& pcat,
                                           const std::string& pschema,
                                           const std::string& ptable,
                                           const std::string& fcatalog,
                                           const std::string& fschema,
                                           const std::string& ftable) {
      return get_xrefs(ptable, ftable);
    }
    virtual ResultSet *get_imported_keys(const std::string& cat,
                                         const std::string& schema,
                                         const std::string& table) {
      return get_xrefs("", table);
    }
    virtual ResultSet *get_exported_keys(const std::string& cat,
                                         const std::string& schema,
                                         const std::string& table) {
      return get_xrefs(table, "");
    }
    
    virtual ResultSet *get_index_info(const std::string& cat,
                                      const std::string& schema,
                                      const std::string& table,
                                      bool unique,
                                      bool approximate);
  private:
    PGConnection *conn_;
};

}

}

#endif
