#include "gql++/mod-result-set.h"

namespace GQL
{

using namespace std;

ModResultSetMetaData::ModResultSetMetaData(int cols)
{
  ncols_ = cols;
  
  col_labels_ = new string[ncols_];
  col_names_ = new string[ncols_];
  col_types_ = new SQLType[ncols_];
}

ModResultSetMetaData::~ModResultSetMetaData()
{
  delete[] col_labels_;
  delete[] col_names_;
  delete[] col_types_;
}

void ModResultSetMetaData::set_column_label(int i, const std::string& s)
{
  if (i < 0 || i >= ncols_)
    throw SQLException("Attempt to access invalid field");
  
  col_labels_[i] = s;
}

void ModResultSetMetaData::set_column_name(int i, const std::string& s)
{
  if (i < 0 || i >= ncols_)
    throw SQLException("Attempt to access invalid field");
  
  col_names_[i] = s;
}

void ModResultSetMetaData::set_column_type(int i, const SQLType& type)
{
  if (i < 0 || i >= ncols_)
    throw SQLException("Attempt to access invalid field");
  
  col_types_[i] = type;
}

void ModResultSetMetaData::set_column_info(int i, const SQLType& type, 
                                           const std::string& name,
                                           const std::string& label)
{
  if (i < 0 || i >= ncols_)
    throw SQLException("Attempt to access invalid field");

  col_names_[i] = name;
  col_labels_[i] = label;
  col_types_[i] = type;
}

ModResultSet::ModResultSet(Connection *conn, int cols) : ResultSet(conn)
{
  cols_ = cols;
  rowno_ = -1;
  metadata_ = 0;
}

ModResultSet::~ModResultSet()
{
  for (vector<string **>::size_type i = 0; i < rows_.size(); i++)
  {
    for (int j = 0; j < cols_; j++)
      delete rows_[i][j];
    delete[] rows_[i];
  }
  if (metadata_)
    metadata_->unreference();
}

bool ModResultSet::next() throw(SQLException)
{
  if ((int)rows_.size() > rowno_ + 1)
  {
    rowno_++;
    return true;
  }
  return false;
}

SQLObject *ModResultSet::get(int i, SQLObject *obj) const throw(SQLException)
{
  if (i < 0 || i >= cols_)
    throw SQLException("Attempt to access invalid field");

  if (rows_[rowno_][i] == 0)
    obj->set_null();
  else
    obj->from_string(*rows_[rowno_][i]);

  return obj;
}

void ModResultSet::append(const char *const*tuple)
{
  string **new_tuple = new string *[cols_];
  
  for (int i = 0; i < cols_; i++)
    new_tuple[i] = tuple[i] ? new string(tuple[i]) : 0;

  rows_.push_back(new_tuple);
}

void ModResultSet::append(string **tuple)
{
  string **new_tuple = new string *[cols_];
  
  for (int i = 0; i < cols_; i++)
    new_tuple[i] = tuple[i];
  
  rows_.push_back(new_tuple);
}

const ResultSetMetaData *ModResultSet::get_meta_data() const
{
  if (!metadata_)
  {
    const_cast<ModResultSet *>(this)->metadata_ = 
      manage(new ModResultSetMetaData(cols_));
    metadata_->reference();
  }
  return metadata_;
}

void ModResultSet::set_meta_data(ResultSetMetaData *metadata)
{
  if (metadata_)
    metadata_->unreference();
  
  metadata_ = metadata;
  
  if (metadata_)
    metadata_->reference();
}

}


