#include <sys/ioctl.h>

#include "app.h"

namespace GQLShell
{

using namespace std;

void App::usage(ostream& os)
{
  os << "This is gql-shell, a interactive SQL database terminal" << endl
     << endl
     << "Usage:" << endl
     << "  gql-shell [options] URL" << endl
     << endl
     << "Connects to database URL, where URL has the following syntax:" << endl
     << "  [gql:]<driver-id>:<db-id>" << endl
     << "    <driver-id> is the name of the DB driver." << endl
     << "      To list available drivers, use --list-drivers." << endl
     << "    <db-id> is the driver-dependant database identifier, " << endl
     << "      normally the database name." << endl
     << endl
     << "Options:" << endl
     << endl
     << "  -h, --help                  Print this help" << endl
     << "  -V, --version               Print version information" << endl
     << "  -v, --verbose=VERBOSITY     Increase/set verbosity" << endl
     << "  -l, --list-drivers          Output list of available DB drivers" 
     << endl
     << "  -U USER, --username USER    Set database user name"  << endl
     << "  -W, --password=PASSWD       Set database password" << endl
     << endl
     << endl
     << "Report bugs to <gql-user@lists.sourceforge.net>." << endl;
}

#ifndef TIOCGWINSZ
struct winsize
{
    int ws_row;
    int ws_col;
};
#endif

void App::slash_usage()
{
  bool  usePipe = false;
  const char *pagerenv;
  FILE *fout;
  struct winsize screen_size;

#ifdef TIOCGWINSZ
  if (interactive() &&
      (ioctl(fileno(stdout), TIOCGWINSZ, &screen_size) == -1 ||
       screen_size.ws_col == 0 ||
       screen_size.ws_row == 0))
  {
#endif
    screen_size.ws_row = 24;
    screen_size.ws_col = 80;
#ifdef TIOCGWINSZ
  }
#endif
  
  if (interactive()  &&
      (pagerenv = getenv("PAGER")) &&
      (pagerenv[0] != '\0') &&
      screen_size.ws_row <= 39 &&
      (fout = popen(pagerenv, "w")))
  {
    usePipe = true;
#ifndef WIN32
    //pqsignal(SIGPIPE, SIG_IGN);
#endif
  }
  else
    fout = stdout;
  
  fprintf(fout, " \\copyright      show GQL-Shell usage and distribution terms\n");
  fprintf(fout, " \\d TABLE       describe table (or view, index, sequence)\n");
  fprintf(fout, " \\d{t|i|s|v}... list tables/indexes/sequences/views\n");
  fprintf(fout, " \\g FILENAME     send SQL command to server (and write results to file or |pipe)\n");
  fprintf(fout, " \\h NAME         help on syntax of SQL commands, * for all commands\n");
  fprintf(fout, " \\q              quit gql-shell\n");
  fprintf(fout, " \\r              reset (clear) the query buffer\n");
  
  if (usePipe)
  {
    pclose(fout);
  }
}
void App::print_copyright(std::ostream& os)
{
  os << "gql-shell Interactive DB frontend" << endl << endl
     << "Copyright (c) 2002 Andreas Rottmann" << endl;
}

void App::help_sql(const std::string& topic, std::ostream& os)
{
  if (topic.empty())
  {
    os << "Available help:" << endl;
    os << "*** Sorry, not yet implemented ***" << endl;
  }
  else
  {
    os << "Sorry, no help available for '" << topic << "'. " 
       << "Try \\h with no arguments to see available help." << endl;
  }
}


}
