// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: Granule.h,v 1.16 2005/11/13 02:50:48 vlg Exp $
//------------------------------------------------------------------------------
//                            Granule.h
//------------------------------------------------------------------------------
//  Copyright (c) 2004,2005 by Vladislav Grinchenko 
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Wed Dec 31 23:18:34 2003
//
//------------------------------------------------------------------------------
#ifndef Granule_H
#define Granule_H

#ifdef HAVE_CONFIG_H
#    include "config.h"
#endif

#include <libxml/parser.h>
#include <libxml/xmlIO.h>

#include <string>
using std::string;

#include <gtkmm.h>

#include <assa/GenServer.h>
#include <assa/Singleton.h>
#include <assa/TimeVal.h>

#include "DeckManager.h"

class MainWindow;

class Granule :
    public virtual sigc::trackable,
    public ASSA::GenServer,
    public ASSA::Singleton<Granule>
{
public:
    Granule ();
    ~Granule ();

	virtual void init (int* argc_, char* argv_[], const char* help_);

    virtual void init_service   ();
    virtual void process_events ();

    bool timer_cb ();

	MainWindow*  get_main_window () { return m_main_window; }

	/** Overload XML parser default entity loader.
	 */
    static xmlParserInputPtr 
	my_xml_entity_loader (const char*      url_, 
						  const char*      id_, 
						  xmlParserCtxtPtr ctxt_);

public: // Common utilities used everywhere
	static gchar*   strip_pango_markup     (const char* src_);
	static void     remove_common_prefixes (gchar*& src_);

	/** Search DOM XML parser tree for the first element that
		matches the xpath_.
	*/
	static xmlChar* get_node_by_xpath (xmlDocPtr parser_, const char* xpath_);

	/** Validate pango markup
		@return true on success; false if entry is invalid
	*/
	static bool check_markup (const Glib::ustring& str_);

private:
	void dump_package_envs ();

private:
	ASSA::TimeVal    m_timeout;

	/** Options */
    std::string      m_gtk_options;
	int              m_secs_in_day;
	int              m_secs_in_week;

    Gtk::Main*       m_kit;
    MainWindow*      m_main_window;
	sigc::connection m_tconn;

    static xmlExternalEntityLoader m_default_entity_loader;
};

/* Useful definitions */

#define GRANULE    Granule::get_instance()

#define REACTOR    GRANULE->get_reactor()
#define MAINWIN    GRANULE->get_main_window()
#define DECKMGR    MAINWIN->get_deck_manager()
#define DECKLIST   MAINWIN->get_deck_list()
#define CARDBOX    MAINWIN->get_cardbox()
#define TOPMENUBAR MAINWIN->get_top_menubar()

/**
 * Run Reactor's event loop.
 */
inline bool
Granule::
timer_cb ()
{
	ASSA::TimeVal tv (m_timeout);
    REACTOR->waitForEvents (&tv);
    return true;
}


#endif // Granule_H

