// -*- c++ -*-
//------------------------------------------------------------------------------
//                              CardView.h
//------------------------------------------------------------------------------
// $Id: CardView.h,v 1.20 2006/09/06 02:07:59 vlg Exp $
//
//  Copyright (c) 2004-2005 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//
//  Date: Feb 15, 2004
//------------------------------------------------------------------------------
#ifndef CARD_VIEW_H
#define CARD_VIEW_H

#include <glibmm/ustring.h>
#include <gtkmm/textview.h>
#include <gtkmm/entry.h>
#include <gtkmm/dialog.h>

class Gtk::Button;
class Gtk::TextView;
class Gtk::Entry;

#ifdef IS_HILDON
#    include <hildon-widgetsmm/appview.h>
#endif

#include "Granule-main.h"
#include "CardViewHelpDialog.h"

class VCard;
class DeckView;
class EditControls;

#ifdef IS_HILDON
class CardView : public Hildon::AppView
#else
class CardView : public Gtk::Window
#endif
{
public:
	/** Create dialog to view and/or edit an existing card.
		If card_ is NULL, create dialog to add new card(s). 
		User might add more then one card at once without closing the dialog.
	 */
	CardView (VCard* card_ = NULL);

	/** Remember window size when resized.
	 */
	void size_allocate_cb (Gtk::Allocation& size_);

	/** Our own implementation of run().
	 *
	 *  @param disable_cancel_ if true, disables cancel button.
	 */
	int run (bool disable_cancel_ = false);

	/** This run is called by DeckView to add a new card
		(or multiple cards without closing the dialog)
	*/
	int run (DeckView& deckview_);

private:
	virtual bool on_key_press_event (GdkEventKey* event_);

	void on_add_clicked       ();
	void on_addnclose_clicked ();
	void on_help_clicked      ();
	void on_cancel_clicked    ();

#ifdef IS_HILDON
	void hildon_im_close_cb ();
#endif

	void clear_dialog ();

	void take_snapshot ();
	bool text_modified ();

private:
	VCard* m_card;
	bool   m_syntax_error;
	bool   m_keep_open;
	int    m_response;
	
	// -*- GUI components -*-
	//
	Gtk::Button*    m_cancel_button;
	Gtk::Button*    m_add_n_close_button;
	Gtk::Button*    m_add_button;
	Gtk::Button*    m_help_button;

	Gtk::TextView*  m_front_text;
	Gtk::TextView*  m_back_text;
	Gtk::TextView*  m_example_text;
	Gtk::TextView*  m_altspell_text;

	// -*- Snapshot to detect true changes -*-
	//
	Glib::ustring   m_snapshot_front;
	Glib::ustring   m_snapshot_back;
	Glib::ustring   m_snapshot_example;
	Glib::ustring   m_snapshot_altspell;

	EditControls*   m_edit_controls;

	CardViewHelpDialog m_help_dialog;
};


#endif /* CARD_VIEW_H */
