// -*- c++ -*-
//------------------------------------------------------------------------------
//                               MyFileOpenDialog.h
//------------------------------------------------------------------------------
// $Id: MyFileOpenDialog.h,v 1.4 2007/01/02 00:15:41 vlg Exp $
//------------------------------------------------------------------------------
//  Copyright (c) 2006 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version
//  2 of the License, or (at your option) any later version.
//------------------------------------------------------------------------------
#ifndef MY_FILE_OPEN_DIALOG_H
#define MY_FILE_OPEN_DIALOG_H

#include <vector>
#include <gtkmm/filechooserdialog.h>
#include <gtkmm/fileselection.h>

#include "Granule-main.h"
#include "Granule.h"

class MyFileOpenDialog
{
public:
	MyFileOpenDialog (const Glib::ustring& title_,
					  Gtk::Widget*         parent_,
					  const Glib::ustring& filter_name_    = "",
					  const Glib::ustring& filter_pattern_ = "");

	~MyFileOpenDialog ();

	/** For single-entry
	 */
	void          set_current_name (const Glib::ustring& name_);
	Glib::ustring get_filename     () const;

	/** For multi-entries
	 */
	void set_select_multiple (bool v_ = true);
	std::vector<Glib::ustring> get_filenames () const;

	int  run  ();
	void show ();
	void hide ();

private:

#ifdef OBSOLETE
	Gtk::FileSelection*     m_dialog;
#else
	Gtk::FileChooserDialog* m_dialog;
#endif
	bool m_multi_choice;		// If true, allows to select multiple items
};

//------------------------------------------------------------------------------
// Inline functions
//------------------------------------------------------------------------------
inline
MyFileOpenDialog::
~MyFileOpenDialog ()
{
	if (m_dialog) {
		delete m_dialog;
		m_dialog = NULL;
	}
}

inline Glib::ustring 
MyFileOpenDialog::
get_filename () const
{
	return (m_dialog->get_filename ());
}

inline void
MyFileOpenDialog::
set_current_name (const Glib::ustring& name_)
{
#ifdef OBSOLETE
	m_dialog->set_filename (name_);
#else
	m_dialog->set_current_name (name_);
#endif
}

inline void 
MyFileOpenDialog::
set_select_multiple (bool v_) 
{ 
#ifdef OBSOLETE
	m_dialog->set_select_multiple (v_);
#else
	m_dialog->set_select_multiple (v_);
#endif
}

inline int
MyFileOpenDialog::
run ()
{
	return (m_dialog->run ());
}
	
inline void
MyFileOpenDialog::
hide ()
{
	m_dialog->hide ();
}

inline void
MyFileOpenDialog::
show ()
{
	m_dialog->show ();
}



#endif /* MY_FILE_OPEN_DIALOG_H */
