#!/bin/sh
# Run this to generate all the initial makefiles, etc.

test -n "$srcdir" || srcdir=`dirname "$0"`
test -n "$srcdir" || srcdir=.

olddir=`pwd`
cd $srcdir

rm -rf autom4te.cache

AUTORECONF=$(which autoreconf 2>/dev/null)
GTKDOCIZE=$(which gtkdocize 2>/dev/null)

set -x

if test -z $GTKDOCIZE; then
        echo "*** You don't have gtk-doc installed; the API reference will"
        echo "*** not be available to the build."
        rm -f gtk-doc.make
        echo "# This file is autogenerated" > gtk-doc.make
        echo "EXTRA_DIST =" >> gtk-doc.make
        echo "CLEANFILES =" >> gtk-doc.make
else
        gtkdocize || exit $?
fi

if test -z $AUTORECONF; then
        echo "*** No autoreconf found, please install it ***"
        exit 1
else
        autoreconf --force --install --verbose || exit $?
fi

# NOCONFIGURE is used by gnome-common
if test -z "$NOCONFIGURE"; then
        if test -z "$*"; then
                echo "*** I am going to run ./configure with no arguments - if you wish"
                echo "*** to pass any to it, please specify them on the $0 command line."
        fi
fi

cd "$olddir"
test -n "$NOCONFIGURE" || "$srcdir/configure" "$@"

{ set +x; } 2>/dev/null
