#! /usr/bin/perl

my $optimise = 0;	# 0 = no optimisations, 1 = optimise


my $INPUT="phrases.lang";
my $OUTPUT="phrases.h";

print "# Transforming $INPUT -> $OUTPUT ... ";

open (IFH, "<$INPUT") or die "Can't open '$INPUT': $_\n";
open (OFH, ">$OUTPUT") or die "Can't open '$OUTPUT': $_\n";

print OFH <<EOL;
//
//	$OUTPUT: Automatically generated - do not edit!
//		(edit $INPUT instead, and re-run init-phrases.pl)
//

static const char *phrases_raw =
EOL

while (<IFH>) {
	# Skip comment lines and blank lines
	if ($optimise) {
		next if /^#/;
		next if /^$/;
	}

	# Remove newline char
	chomp;

	# Escape quotation marks
	$_ =~ s/"/\\\"/g;
	$_ =~ s/\\\\"/\\\\\\"/g;

	# Some minor kludges
	$_ =~ s/\(\\*\)/()/g if /^#/;

	print OFH "\"$_\\n\"\n";
}

print OFH <<EOL;
;

// The End.
EOL

close IFH;
close OFH;

print "done!\n";
