#include "dbmi.h"
#include "macros.h"

int
db__send_success()
{
    DB_SEND_INT (DB_OK);
    return DB_OK;
}

int
db__send_failure()
{
    DB_SEND_INT (DB_FAILED);
    DB_SEND_C_STRING (db_get_error_msg());
    return DB_OK;
}

int
db__recv_return_code (ret_code)
    int *ret_code;
{
    dbString err_msg;

/* get the return code first */
    DB_RECV_INT (ret_code);

/* if OK, we're done here */
    if (*ret_code == DB_OK)
	return DB_OK;

/* should be DB_FAILED */
    if (*ret_code != DB_FAILED)
    {
	db_protocol_error();
	return DB_PROTOCOL_ERR;
    }
/* get error message from driver */
    db_init_string (&err_msg);
    DB_RECV_STRING (&err_msg);

    db_error(db_get_string(&err_msg));
    db_free_string (&err_msg);

    return DB_OK;
}
