
#ifndef _TRANSPORT_H
#define _TRANSPORT_H

extern int LOC_get_location_with_box(int cx,int cy, int *wx, int *wy, int *button);
extern int LOC_get_location_with_box_old(int cx,int cy, int *wx, int *wy, int *button);
extern int LOC_get_location_with_line(int cx, int cy, int *wx, int *wy, int *button);
extern int LOC_get_location_with_line_old(int cx, int cy, int *wx, int *wy, int *button);
extern int LOC_get_location_with_pointer(int *wx, int *wy, int *button);
extern int LOC_get_location_with_pointer_old(int *wx, int *wy, int *button);
extern int LOC_open_driver(void);
extern int LOC__open_quiet(void);
extern int LOC_stabilize(void);
extern int LOC_kill_driver(void);
extern int LOC_close_driver(void);
extern int LOC_release_driver(void);
extern int LOC_pad_create(const char *pad);
extern int LOC_pad_current(char *name);
extern int LOC_pad_delete(void);
extern int LOC_pad_invent(char *pad);
extern int LOC_pad_list(char ***list, int *count);
extern int LOC_pad_select(const char *pad);
extern int LOC_pad_append_item(const char *item, const char *value, int replace);
extern int LOC_pad_delete_item(const char *name);
extern int LOC_pad_get_item(const char *name, char ***list, int *count);
extern int LOC_pad_list_items(char ***list, int *count);
extern int LOC_pad_set_item(const char *name, const char *value);
extern int LOC_screen_left(void);
extern int LOC_screen_rite(void);
extern int LOC_screen_bot(void);
extern int LOC_screen_top(void);
extern int LOC_get_num_colors(int *n);
extern int LOC_color_table_float(void);
extern int LOC_color_table_fixed(void);
extern int LOC_color_offset(int n);
extern int LOC_color(int index);
extern int LOC_standard_color(int index);
extern int LOC_RGB_color(unsigned char red, unsigned char grn, unsigned char blu);
extern int LOC_reset_color(unsigned char red, unsigned char grn, unsigned char blu, int index);
extern int LOC_reset_colors(int min, int max, unsigned char *red, unsigned char *grn, unsigned char *blu);
extern int LOC_line_width(int width);
extern int LOC_erase(void);
extern int LOC_move_abs(int x, int y);
extern int LOC_move_rel(int x, int y);
extern int LOC_cont_abs(int x, int y);
extern int LOC_cont_rel(int x, int y);
extern int LOC_polydots_abs(int *xarray, int *yarray, int number);
extern int LOC_polydots_rel(int *xarray, int  *yarray, int number);
extern int LOC_polyline_abs(int *xarray, int  *yarray, int number);
extern int LOC_polyline_rel(int *xarray, int *yarray, int number);
extern int LOC_polygon_abs(int *xarray, int *yarray, int number);
extern int LOC_polygon_rel(int *xarray, int *yarray, int number);
extern int LOC_box_abs(int x1, int y1, int x2, int y2);
extern int LOC_box_rel(int x, int y);
extern int LOC_text_size(int width, int height);
extern int LOC_text_rotation(float rotation);
extern int LOC_set_window(int t, int b, int l, int r);
extern int LOC_text(const char *text);
extern int LOC_get_text_box(const char *text, int *t, int *b, int *l, int *r);
extern int LOC_font(const char *name);
extern int LOC_font_freetype(const char *name);
extern int LOC_charset(const char *name);
extern int LOC_font_freetype_release(void);
extern int LOC_panel_save(const char *name, int t, int b, int l, int r);
extern int LOC_panel_restore(const char *name);
extern int LOC_panel_delete(const char *name);
extern int LOC_set_RGB_color(unsigned char *r, unsigned char *g, unsigned char *b);
extern int LOC_RGB_raster(int n, int nrows, unsigned char *red, unsigned char *grn, unsigned char *blu, unsigned char *nul);
extern int LOC_raster_char(int num, int nrows, int withzero, const unsigned char *ras);
extern int LOC_raster_int(int num, int nrows, int withzero, const int *ras);

extern int REM_get_location_with_box(int cx,int cy, int *wx, int *wy, int *button);
extern int REM_get_location_with_box_old(int cx,int cy, int *wx, int *wy, int *button);
extern int REM_get_location_with_line(int cx, int cy, int *wx, int *wy, int *button);
extern int REM_get_location_with_line_old(int cx, int cy, int *wx, int *wy, int *button);
extern int REM_get_location_with_pointer(int *wx, int *wy, int *button);
extern int REM_get_location_with_pointer_old(int *wx, int *wy, int *button);
extern int REM_open_driver(void);
extern int REM__open_quiet(void);
extern int REM_stabilize(void);
extern int REM_kill_driver(void);
extern int REM_close_driver(void);
extern int REM_release_driver(void);
extern int REM_pad_create(const char *pad);
extern int REM_pad_current(char *name);
extern int REM_pad_delete(void);
extern int REM_pad_invent(char *pad);
extern int REM_pad_list(char ***list, int *count);
extern int REM_pad_select(const char *pad);
extern int REM_pad_append_item(const char *item, const char *value, int replace);
extern int REM_pad_delete_item(const char *name);
extern int REM_pad_get_item(const char *name, char ***list, int *count);
extern int REM_pad_list_items(char ***list, int *count);
extern int REM_pad_set_item(const char *name, const char *value);
extern int REM_screen_left(void);
extern int REM_screen_rite(void);
extern int REM_screen_bot(void);
extern int REM_screen_top(void);
extern int REM_get_num_colors(int *n);
extern int REM_color_table_float(void);
extern int REM_color_table_fixed(void);
extern int REM_color_offset(int n);
extern int REM_color(int index);
extern int REM_standard_color(int index);
extern int REM_RGB_color(unsigned char red, unsigned char grn, unsigned char blu);
extern int REM_reset_color(unsigned char red, unsigned char grn, unsigned char blu, int index);
extern int REM_reset_colors(int min, int max, unsigned char *red, unsigned char *grn, unsigned char *blu);
extern int REM_line_width(int width);
extern int REM_erase(void);
extern int REM_move_abs(int x, int y);
extern int REM_move_rel(int x, int y);
extern int REM_cont_abs(int x, int y);
extern int REM_cont_rel(int x, int y);
extern int REM_polydots_abs(int *xarray, int *yarray, int number);
extern int REM_polydots_rel(int *xarray, int  *yarray, int number);
extern int REM_polyline_abs(int *xarray, int  *yarray, int number);
extern int REM_polyline_rel(int *xarray, int *yarray, int number);
extern int REM_polygon_abs(int *xarray, int *yarray, int number);
extern int REM_polygon_rel(int *xarray, int *yarray, int number);
extern int REM_box_abs(int x1, int y1, int x2, int y2);
extern int REM_box_rel(int x, int y);
extern int REM_text_size(int width, int height);
extern int REM_text_rotation(float rotation);
extern int REM_set_window(int t, int b, int l, int r);
extern int REM_text(const char *text);
extern int REM_get_text_box(const char *text, int *t, int *b, int *l, int *r);
extern int REM_font(const char *name);
extern int REM_font_freetype(const char *name);
extern int REM_charset(const char *name);
extern int REM_font_freetype_release(void);
extern int REM_panel_save(const char *name, int t, int b, int l, int r);
extern int REM_panel_restore(const char *name);
extern int REM_panel_delete(const char *name);
extern int REM_set_RGB_color(unsigned char *r, unsigned char *g, unsigned char *b);
extern int REM_RGB_raster(int n, int nrows, unsigned char *red, unsigned char *grn, unsigned char *blu, unsigned char *nul);
extern int REM_raster_char(int num, int nrows, int withzero, const unsigned char *ras);
extern int REM_raster_int(int num, int nrows, int withzero, const int *ras);

struct transport
{
	int (*open_driver)(void);
	int (*open_quiet)(void);
	int (*stabilize)(void);
	int (*kill_driver)(void);
	int (*close_driver)(void);
	int (*release_driver)(void);

	int (*screen_left)(void);
	int (*screen_rite)(void);
	int (*screen_bot)(void);
	int (*screen_top)(void);
	int (*get_num_colors)(int *);
	int (*color_table_float)(void);
	int (*color_table_fixed)(void);
	int (*color_offset)(int);
	int (*color)(int);
	int (*standard_color)(int);
	int (*RGB_color)(unsigned char, unsigned char, unsigned char);
	int (*reset_color)(unsigned char, unsigned char, unsigned char, int);
	int (*reset_colors)(int, int, unsigned char *, unsigned char *, unsigned char *);
	int (*line_width)(int);
	int (*erase)(void);
	int (*move_abs)(int, int);
	int (*move_rel)(int, int);
	int (*cont_abs)(int, int);
	int (*cont_rel)(int, int);
	int (*polydots_abs)(int *, int *, int);
	int (*polydots_rel)(int *, int  *, int);
	int (*polyline_abs)(int *, int  *, int);
	int (*polyline_rel)(int *, int *, int);
	int (*polygon_abs)(int *, int *, int);
	int (*polygon_rel)(int *, int *, int);
	int (*box_abs)(int, int, int, int);
	int (*box_rel)(int, int);
	int (*text_size)(int, int);
	int (*text_rotation)(float);
	int (*set_window)(int, int, int, int);
	int (*text)(const char *);
	int (*get_text_box)(const char *, int *, int *, int *, int *);
	int (*font)(const char *);
	int (*font_freetype)(const char *);
	int (*charset)(const char *);
	int (*font_freetype_release)(void);
	int (*panel_save)(const char *, int, int, int, int);
	int (*panel_restore)(const char *);
	int (*panel_delete)(const char *);
	int (*set_RGB_color)(unsigned char *, unsigned char *, unsigned char *);
	int (*RGB_raster)(int n, int nrows, unsigned char *, unsigned char *, unsigned char *, unsigned char *);
	int (*raster_char)(int, int, int, const unsigned char *);
	int (*raster_int)(int, int, int, const int *);

	int (*get_location_with_box)(int, int, int *, int *, int *);
	int (*get_location_with_box_old)(int, int, int *, int *, int *);
	int (*get_location_with_line)(int, int, int *, int *, int *);
	int (*get_location_with_line_old)(int, int, int *, int *, int *);
	int (*get_location_with_pointer)(int *, int *, int *);
	int (*get_location_with_pointer_old)(int *, int *, int *);

	int (*pad_create)(const char *);
	int (*pad_current)(char *);
	int (*pad_delete)(void);
	int (*pad_invent)(char *);
	int (*pad_list)(char ***, int *);
	int (*pad_select)(const char *);
	int (*pad_append_item)(const char *, const char *, int);
	int (*pad_delete_item)(const char *);
	int (*pad_get_item)(const char *, char ***, int *);
	int (*pad_list_items)(char ***, int *);
	int (*pad_set_item)(const char *, const char *);
};

extern const struct transport *trans;

#endif /* _TRANSPORT_H */

