/* interface.h
 * Copyright (C) 2005 Sylvain Cresto <scresto@gmail.com>
 *
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

#ifndef _G_INTERFACE_H
#define _G_INTERFACE_H

extern GSList *Gmedialist;
extern Tmyentry Gtypeicosize[];
extern Tmediaentry Gdefaultmedia[];
extern void remplire_combo_vitesse(GtkComboBox *Acombo, Tdriveinfo *Adrive, gchar *Aselvalue);
extern void show_graverwindow(Tgrave *Ag, gchar *Aaction, gchar *Atitle);
extern GtkWidget* create_addfileselection (GtkWindow *AParent);
extern GtkWidget* create_adddirselection (GtkWindow *AParent);
extern GtkMenu *create_gtkpopupmenudata(GtkWidget *Aliste, Tgrave *Ag);
extern GtkMenu *create_gtkpopupmenuaudio(GtkWidget *Aliste, Tgrave *Ag);
extern GtkMenu *create_gtkpopupmenudevices(GtkWidget *Aliste, Tgrave *Ag);
extern GtkMenu *create_gtkpopupmenucharset(GtkWidget *Aliste, Tgrave *Ag);
extern GtkMenu *create_gtkpopupmenudisplay(GtkWidget *Aliste, Tgrave *Ag);
extern GtkMenu *create_gtkpopupmenuformatdvd(Tgrave *Ag);
extern GtkWidget* create_addpisteselection (GtkWindow *AParent);
extern Tgrave *create_window_encours(GtkWidget *AParent);
extern Tgrave* manage_main_window (guint64 *Aaudiolen, guint64 *Aaudiomaxlen,
    guint64 *Adatasize, guint64 *Adatamaxsize, guint64 *Advddatasize, guint64 *Advddatamaxsize);
extern GtkWidget* create_isoselection (GtkWindow *Aparent, GtkFileChooserAction Atype);
extern void about_graveman (void);
extern void welcome_to_graveman(void);
extern void switch_pbar_status(GtkProgressBar *Apbar, guint64 Amaxlen, guint64 Acurlen, Ttypemajpbar Aupdatetext);
extern void prepare_combobox_graveur(Tgrave *Ag, gchar *Abasename);
extern void prepare_combobox_vitesse(GtkComboBox *Acombobox);
extern void update_combo_graveur(Tgrave *Ag);
extern void prepare_listedata(GtkTreeView *Atreedata, gchar *Atitle);
extern void prepare_listeaudio(GtkTreeView *Atreeaudio);
extern void prepare_popups(Tgrave *Ag);
extern void prepare_disable_when_iso(Tgrave *Ag, gchar *Abasename, const gchar *Afirst, ...);
extern void prepare_disable_when(Tgrave *Ag, gchar *Abasename, const gchar *Afirst, ...);
extern void show_erasecdrwwindow(Tgrave *Ag);
extern void show_fixcdwindow(Tgrave *Ag);
extern void manage_combobox_devicebus(GtkComboBox *Acombobox, Tdriveinfo *Adrive);
extern Tgrave *create_dialog_edit_device(GtkWidget *Aparent, Tdriveinfo *Adrive);
extern Tgrave *create_dialog_add_device(GtkWidget *Aparent);
extern Tgrave *addmediaformat(Tgrave *Aparent);
extern void manage_interface(Tgrave *Ag, gint Aaction);
extern void gtk_toggle_top_menu(GtkTreeView *Atopmenu, gpointer Adata);
extern Tgrave *create_dialog_confirm_operation (GtkWidget *Aparent, gchar *Alabel, 
                      gchar *Acheckboxlbl, gboolean Acheckboxstatus);
extern Tgrave *create_dialog_select_dvdoperation (GtkWidget *Aparent, gint Atypedvd);
extern void update_status_bar_display(Tgrave *Ag);
extern void show_dvdformatwindow(Tgrave *Ag, gchar *Atitle, Ttypeformatdvd Aoperation);
extern void prepare_properties_devicestreeview(GtkTreeView *Atreeview);
extern gboolean expand_list_icons(GtkTreeView *Aliste, gboolean Aetat);

#endif

/*
 * vim:et:ts=8:sts=2:sw=2
 */
