/*
 * Grdc - GTK+/Gnome Remote Desktop Client
 * Copyright (C) 2009 - Vic Lee 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA 02111-1307, USA.
 */
 

#ifndef __GRDCSTRINGARRAY_H__
#define __GRDCSTRINGARRAY_H__

G_BEGIN_DECLS

typedef GPtrArray GrdcStringArray;

#define grdc_string_array_new g_ptr_array_new
#define grdc_string_array_index(array,i) (gchar*)g_ptr_array_index(array,i)
GrdcStringArray* grdc_string_array_new_from_string (const gchar *strs);
GrdcStringArray* grdc_string_array_new_from_allocated_string (gchar *strs);
void grdc_string_array_add (GrdcStringArray* array, const gchar *str);
gint grdc_string_array_find (GrdcStringArray* array, const gchar *str);
void grdc_string_array_remove_index (GrdcStringArray* array, gint i);
void grdc_string_array_remove (GrdcStringArray* array, const gchar *str);
void grdc_string_array_intersect (GrdcStringArray* array, const gchar *dest_strs);
gchar* grdc_string_array_to_string (GrdcStringArray* array);
#define grdc_string_array_free(array) g_ptr_array_free(array,TRUE)

G_END_DECLS

#endif  /* __GRDCSTRINGARRAY_H__  */

