headings 11
Tests 17
add "Añadir variables"
adf "Contraste aumentado de Dickey-Fuller"
arch "Contraste ARCH"
chow "Contraste de Chow"
coeffsum "Suma de coeficientes"
coint "Contraste de cointegración de Engle-Granger"
coint2 "Contraste de cointegración de Johansen"
cusum "Contraste CUSUM"
hausman "Contraste de Hausman (diagnósticos de panel)"
leverage "Observations influyentes"
lmtest "Contrastes LM"
meantest "Diferencia de medias"
omit "Omisión de variables"
reset "Ramsey's RESET"
restrict "Restricciones lineales"
runs "Contraste de rachas"
vartest "Diferencia de varianzas"
Estimation 21
ar "Estimación autorregresiva"
arma "Modelo ARMA"
corc "Procedimiento de Cochrane-Orcutt"
dialog "Caja de diálogo de Modelo"
garch "Modelo GARCH"
hccm "Estimación HCCM"
hilu "Estimación de Hildreth-Lu"
hsk "Estimaciones corregidas de heterocedasticidad"
lad "Estimación de mínima desviación absoluta"
logistic "Regresión logística"
logit "Regresión Logit"
mpols "MCO de precisión Múltiple"
nls "Mínimos cuadrados no lineales"
ols "Mínimos Cuadrados Ordinarios"
pooled "MCO combinados"
probit "Modelo Probit"
pwe "Estimador de Prais-Winsten"
tobit "Modelo Tobit"
tsls "Mínimos cuadrados en dos etapas"
var "Autorregresión vectorial"
wls "Mínimos cuadrados ponderados"
Graphs 7
boxplot "Gráficos de caja"
factorized "Gráfico con factor de separación"
graphing "Graphing"
graphpag "Página de gráficos de Gretl"
3-D "Gráficos tridimensionales"
rmplot "Gráfico Rango-Media"
scatters "Gráficos bivariantes múltiples"
Dataset 14
compact "Compactar datos"
export "Exportar datos"
genr "Generar una variable nueva"
label "Editar los atributos de una variable"
markers "Añadir marcadores de caja"
missing "valores ausentes"
nulldata "Crear un conjunto de datos vacío"
online "Bases de datos de acceso en línea"
panel "Datos de panel"
sampling "Establecer el rango muestral"
setobs "Frequencia y observación inicial"
setmiss "Código de valor ausente"
sim "Simulación"
store "Guardar datos"
Statistics 4
corrgm "Correlograma"
pca "Análisis de componentes principales"
pergm "Periodograma"
spearman "Correlación por rangos de Spearmans"
Utilities 1
modeltab "La tabla de modelos"
Programming 1
seed "Semilla aleatoria"
Prediction 1
fcasterr "Predicciones con intervalos de confianza"

# add Tests "Añadir variables"

Las variables elegidas se añaden al modelo anterior y se estima el nuevo modelo. Si se añade más de una variable, se mostrará el estadístico <@itl="F"> para las variable añadidas (Sólo para el método MCO) y su valor p. Un valor p inferior a 0.05 indica que los coeficientes son conjuntamente significativos al nivel del 5 por ciento. 

Menú gráfico: Ventana de Modelo, /Contrastes/Añadir variables

Instrucción de guión: <@ref="add">

# adf Tests "Contraste aumentado de Dickey-Fuller"

Esta instrucción n¡requiere un orden de retardos entero. 

Calcula los estadísticos para dos contrastes de Dickey-Fuller. En cada caso la hipótesis nula es que la variable seleccionada presenta una raíz unitaria. El primero es un estadístico <@itl="t"> basado en el modelo 

  <@fig="adf1">

La hipótesis nula es que <@itl="g"> = 0. En el segundo contraste (aumentado) se realiza la estimación de una regresión no retringida (cuyos regresores son una constante, una tendencia temporal, el primer retardo de la variable y <@var="orden"> retardos de la primera diferencia) y una versión restringida (quitando la tendencia temporal y el primer retardo). El estadístico de contraste es 

  <@fig="adf2">

donde <@itl="T"> es el tamaño de la muestra, <@itl="k"> el número de parámetros del modelo no restringido, y los subíndices <@itl="u"> y <@itl="r"> denotan el modelo no restringido y el restringido respectivamente. Hay que señalar que los valores críticos para estos estadísticos no son los habituales; se muestra el valor p cuando es posible determinarlo. 

Menú gráfico: /Variable/Contraste aumentado de Dickey-Fuller

Instrucción de guión: <@ref="adf">

# ar Estimation "Estimación autorregresiva"

Computa las estimaciones de los parámetros usando el procedimiento iterativo generalizado de Cochrane–Orcutt (ver Sección 9.5 del libro de Ramanathan). Las iteraciones terminan cuando dos sumas de cuadrados residuales sucesivas no difieren en más del 0.005 por ciento o después de 20 iteraciones. 

La "lista de retardos AR" especifica la estructura de la perturbación. Por ejemplo, la entrada "1 3 4" corresponde al proceso: 

  <@fig="arlags">

Menú gráfico: /Modelo/Serie temporal/Estimación autorregresiva

Instrucción de guión: <@ref="ar">

# arch Tests "Contraste ARCH"

Estainstrucción requiere un número de retardos entero. 

Contrasta la existencia de ARCH (Autoregressive Conditional Heteroskedasticity -- Heterocedasticidad condicional autorregresiva) del orden especificado, en el modelo. Si el estadístico de contraste LM tiene un valor p inferior a 0.10, entonces también se realiza la estimación del modelo ARCH. Si la predicción de la varianza de cualquier observación, en la regresión auxiliar, no es positiva entonces se usa en su lugar el correspondiente residuo al cuadrado. Después se realiza una estimación por mínimos cuadrados ponderados sobre el modelo original. 

Ver también <@ref="garch">. 

Menú gráfico: Ventana de Modelo, /Contrastes/ARCH

Instrucción de guión: <@ref="arch">

# arma Estimation "Modelo ARMA"

Cuando se elige desde el menú de Variable, estima un modelo ARMA (Autoregressive, Moving Average). Cuando se elige desde el menú de Modelo ("ARMAX"), estima un modelo ARMAX, es decir, con regresores exógenos adicionales. 

Por defecto se usa la función "nativa" ARMA de gretl; en el caso de un modelo ARMA univariante se puede usar X-12-ARIMA en su lugar (si está instalado el paquete X-12-ARIMA para gretl). 

El algoritmo ARMA nativo de gretl ha sido, en su mayor parte, creado por Riccardo "Jack" Lucchetti. Utiliza un procedimiento de máxima verosimilitud condicional, implementado por medio de la estimación por mínimos cuadrados iterativos de la regresión del producto externo del gradiente (OPG, outer product of the gradient regression). Ver <@pdf="el manual de gretl "> para entender la lógica de este procedimiento. Los coeficientes AR (y los de cualquier regresor adicional) se inicializan por medio de la estimación por MCO de un AR, y los coeficientes MA se inicializan asignándoles valor cero. 

El valor del coeficiente AIC para los modelos ARMA se calcula de acuerdo con la definición usada en el programa X-12-ARIMA, es decir 

  <@fig="aic">

donde <@itl="L"> es la log-verosimilitud y <@itl="k"> es el número total de parámetros estimados. La "frecuencia" que se presenta asociada a las raíces AR y MA es el valor λ que soluciona 

  <@fig="lambda">

donde <@itl="z"> es la raíz en cuestión y <@itl="r"> es su módulo. 

Menú gráfico: /Variable/Modelo ARMA, /Modelo/Serie temporal/ARMAX
Otro acceso: Menú emergente de la ventana principal (selección simple)

Instrucción de guión: <@ref="arma">

# boxplot Graphs "Gráficos de caja"

Estos gráficos (debidos a Tukey y Chambers) muestran la distribución de una variable. La caja central recoge el 50 por ciento intermedio de los datos, es decir, está acotada por el primero y tercer cuartiles. Las "patillas" se extienden hasta los valores mínimo y máximo. Se dibuja una línea a lo largo de la caja en el lugar de la mediana. 

En el caso de gráficos de caja recortados, el recorte muestra los límites de un intervalo de aproximadamente el 90 por ciento de confianza para la mediana. Este intervalo se obtienen por el método bootstrap. 

Después de cada variable especificada en la instrucción boxplot, se puede añadir una expresión booleana entre paréntesis para limitar la muestra para la variable en cuestión. Debe de insertarse un espacio entre el nombre o número de la variable y la expresión. Supongamos que usted tiene valores de los salarios de hombres y mujeres, y tiene una variable ficticia <@lit="SEXO"> con valor 1 para los hombres y 0 para las mujeres. En este caso usted puede dibujar gráficos de caja comparativos usando la siguiente línea en el cuadro de diálogo de los gráficos de caja: 

<code>          
	salary (GENDER=1) salary (GENDER=0)
</code>

Algunos detalles de los gráficos de caja de gretl pueden controlarse por medio de un fichero (de texto plano) llamado <@lit=".boxplotrc">. Para más detalles sobre esto ver <@pdf="el manual de gretl ">. 

Menú gráfico: /Datos/Gráficos/Gráficos de caja

Instrucción de guión: <@ref="boxplot">

# chow Tests "Contraste de Chow"

Esta instrucción requiere un número de observaciones (o fecha, en el caso de datos con fechas). 

Primero debe ejecutarse una regresión por MCO. Crea una variable ficticia que es igual a 1 desde el punto de corte especificado en <@var="obs"> hasta el final de la muestra y 0 en el resto. También crea los términos de interacción entre esta variable ficticia y las variables independientes originales. Se ejecuta una regresión aumentada incluyendo estos términos y se calcula un estadístico <@itl="F">, tomando la regresión aumentada como 'no restringida' y la original como 'restringida'. Este estadístico es adecuado para contrastar la hipótesis nula de que no hay cambio estructural en el punto de ruptura indicado. 

Menú gráfico: Ventana de Modelo, /Contrastes/Contraste de Chow

Instrucción de guión: <@ref="chow">

# coeffsum Tests "Suma de coeficientes"

Esta instrucción requiere una lista de variables, que se elige a partir del conjunto de variables independientes de un modelo dado. 

Calcula la suma de los coeficientes de las variables de la lista especificada. Presenta la suma junto con su desviación típica y el valor p para la hipótesis nula de que la suma es cero. 

Hay que señalar la diferencia entre esta instrucción y <@ref="omit">, que contrasta la hipótesis nula de que los coeficientes de un subconjunto de variables independientes son todos iguales a cero zero. 

Menú gráfico: Ventana de Modelo, /Contrastes/Suma de coeficientes

Instrucción de guión: <@ref="coeffsum">

# coint Tests "Contraste de cointegración de Engle-Granger"

Contraste de cointegración de Engle–Granger. Esta instrucción realiza los contrastes de Dickey–Fuller aumentados de la hipótesis nula de que cada una de las variables de la lista tiene una raíz unitaria, usando el orden de retardos dado. Se estima la ecuación cointegrante y se realiza un contraste ADF sobre los residuos de esta regresión. También se presenta el estadístico de Durbin–Watson para la regresión cointegrante. Hay que señalar que ninguno de estos estadísticos de contraste puede compararse con las tablas estadísticas usuales. 

Menú gráfico: /Modelo/Serie temporal/Contrates de cointegración/Engle-Granger

Instrucción de guión: <@ref="coint">

# coint2 Tests "Contraste de cointegración de Johansen"

Realiza el contraste de la traza de Johansen para contrastar cointegración entre las variables de la lista para el orden dado. Los valores críticos se computan por medio de la aproximación gamma de J. Doornik (Doornik, 1998). Para detalles sobre este contraste ver el libro de Hamilton, <@itl="Time Series Analysis"> (1994), Capítulo 20. 

Se presenta aquí la siguiente tabla como guía para la interpretación de los resultados ofrecidos por el contraste, para el caso de 3 variables. <@lit="H0"> denota la hipótesis nula, <@lit="H1"> la hipótesis alternativa y <@lit="c"> el número de relaciones cointegrantes. 

<code>          
            Rango   Contraste de la traza     Contraste Lmax 
                          H0     H1              H0     H1
             ---------------------------------------------------
              0          c = 0  c = 3          c = 0  c = 1
              1          c = 1  c = 3          c = 1  c = 2
              2          c = 2  c = 3          c = 2  c = 3
             ---------------------------------------------------
</code>

Menú gráfico: /Modelo/Serie temporal/Contraste de cointegración/Johansen

Instrucción de guión: <@ref="coint2">

# compact Dataset "Compactar datos"

Cuando usted añade a un conjunto de datos una serie que es de una frecuencia mayor, es necesario "compactar" la nueva serie. Por ejemplo, será necesario compactar una serie mensual para encajarla en un conjunto de datos trimestral. 

Además, es posible que alguna vez usted desee compactar un conjunto de datos completo para transformarlo en datos de frecuencia más baja (por ejemplo, antes de añadir al conjunto de datos una variable de frecuencia inferior). 

Gretl ofrece cuatro opciones de compactado: 

<indent>
Promediar: el valor que se escribe en el conjunto de datos será la media aritmética de los valores relevantes de la serie. Por ejemplo, el valor poara el primer trimestre de 1990 será la media de los valores de Enero, Febrero y Marzo de 1990. 
</indent>

<indent>
Sumar: el valor que se escribe en el conjunto de datos será la suma de los valores de frecuencia mayor relevantes. Por ejemplo, el valor del primer trimestre será la suma de los valores de Enero, Febrero y Marzo. 
</indent>

<indent>
Asignar valores de final del periodo: el valor que se escribe en el conjunto de datos es el último valor relevante de los datos de frecuencia mayor. Por ejemplo, el valor del primer trimestre de 1990 sería el valor de Marzo de 1990. 
</indent>

<indent>
Asignar valores de inicio del periodo: el valor escrito en el conjunto de datos es el primer valor relevante de los datos de frecuencia mayor. Por ejemplo, al primer trimestre de 1990 se le asignaría el valor de Enero de 1990. 
</indent>

Cuando se compacta un conjunto de datos completo, la elección que usted efectúa en esta caja de diálogo establece el método por defecto. Pero si usted ha establecido un método de compactado para una variable individual (elemento de menú "Variable/Editar atributos") se usa ese método en lugar del método por defecto. Si ya está establecido el método de compactado para todas las variables, no se presenta aquí la elección de un método de compactado por defecto. 

# corc Estimation "Procedimiento de Cochrane-Orcutt"

Computa estimaciones de los parámetros usando el procedimiento iterativo de Cochrane–Orcutt (ver Sección 9.4 del libro de Ramanathan). Las iteraciones finalizan cuando dos estimaciones sucesivas del coeficiente de autocorrelación no difieren en más de 0,001 o después de 20 iteraciones. 

Menú gráfico: /Modelo/Serie temporal/Cochrane-Orcutt

Instrucción de guión: <@ref="corc">

# corrgm Statistics "Correlograma"

Presenta los valores de la función de autocorrelación para la <@var="variable"> especificada (por nombre o por número). Ver Ramanathan, Sección 11.7. Es por tanto <@fig="autocorr"> donde <@itl="ut"> es la <@itl="t">-ésima observación de la variable <@itl="u"> y <@itl="s"> es el número de retardos. 

También se presentan las autocorrelaciones parciales, siendo éstas los coeficientes una vez descontado el efecto de los demás retardos intervinientes. Esta instrucción también representa el correlograma y muestra el estadístico <@itl="Q"> de Box–Pierce para el contraste de la hipótesis nula de que la serie es "ruido blanco". Este se distribuye asintóticamente como una chi-cuadrado con grados de libertad igual al número de retardos utilizados. 

Si se especifica un valor para <@var="retardo_max"> entonces el tamaño del correlograma se limita como máximo a ese número de retardos, en los demás casos se determina automáticamente. 

Menú gráfico: /Variable/Correlograma
Otro acceso: Menú emergente de la ventana principal (cuando se hace 
      una selección simple)

Instrucción de guión: <@ref="corrgm">

# cusum Tests "Contraste CUSUM"

Debe realizarse después de la estimación de un modelo por MCO. Realiza el contraste CUSUM de estabilidad de los parámetros. Se obtiene una serie de errores de predición (escalados) un período hacia adelante al ejecutar una serie de regresiones: la primera regresión utiliza las primeras <@itl="k"> observaciones y se usa para generar una predicción de la variable dependiente en la observación <@itl="k"> + 1; la segunda utiliza las primeras <@itl="k"> + 1 observaciones y genera una predicción para la observación <@itl="k"> + 2, y así sucesivamente (donde <@itl="k"> es el número de parámetros en el modelo original). Se muestra y se representa graicamente la suma acumulada de los errores de predicción escalados. La hipótesis nula de estabilidad en los parámetros se rechaza al nivel de significación del 5 por ciento si la suma acumulada se sale de la banda de 95 por ciento de confianza. 

También se presenta el estadístico <@itl="t"> de Harvey–Collier para contrastar la hipótesis nula de estabilidad de los parámetros. Para más detalles ver Capítulo 7 del libro de Greene <@itl="Econometric Analysis">. 

Menú gráfico: Ventana de Modelo, /Contrastes/CUSUM

Instrucción de guión: <@ref="cusum">

# dialog Estimation "Caja de diálogo de Modelo"

Para seleccionar la variable dependiente, marque una variable en la lista de la izquierda y presione el botón "Elegir->" que apunta a la zona de definición de la variable dependiente. Si usted marca el cuadrado "Selección por defecto", la variable indicada será preseleccionada como variable dependiente cuando se vuelva a abrir de nuevo la caja de diálogo de Modelo. Atajo: haga doble click sobre una variable de la izquierda para seleccionarla como variable dependiente y establcerla así por defecto. 

Para seleccionar las variables independientes márquelas a la izquierda y presione el botón "Añadir->" (o haga click con el botón derecho del ratón). Usted puede marcar varias variables contíguas manteniendo pulsado el botón izquierdo del ratón y desplazándolo. Puede marcar un grupo de variables no contíguas haciendo click sobre ellas al mismo tiempo que pulsa la tecla <@lit="Ctrl">. 

# export Dataset "Exportar datos"

Se pueden exportar los datos en formato CSV (Comma-Separated Values): estos datos pueden abrirse desde programas de hoja de cálculos y muchos otros programas de aplicaciones. 

También se pueden exportar los datos en los formatos nativos de GNU R o GNU octave. Para más información sobre estos programas (que ambos soportan análisis estadísticos avanzados) vea por favor sus respectivos sitios web, http://www.r-project.org/ y http://www.octave.org/ 

# factorized Graphs "Gráfico con factor de separación"

Esta orden requiere la selección de tres variables, de las cuales la última debe ser una variable ficticia (con valores 1 o 0). La variable Y se representa con respecto a la variable X, con los puntos de datos coloreados de manera diferente dependiendo del valor de la tercera variable. 

Ejemplo: suponga que tenemos datos sobre salarios y nivel de educación para una muestra de varias personas, también tenemos una variable ficticia con valor 1 para los hombres y 0 para las mujeres (como en el fichero de Ramanatha <@lit="data7-2">). Un gráfico "con factor de separación" de <@lit="SALARIO"> con respecto a <@lit="EDUCACION"> usando la variable ficticia <@lit="SEXO"> como factor, mostrará los puntos de datos para los hombres de un color y los de las mujeres de otro (con una leyenda para poder identificarlos). 

# fcasterr Prediction "Predicciones con intervalos de confianza"

Después de estimar un modelo por medio de MCO usted puede usar esta instrucción para mostrar los valores ajustados para el rango de observaciones determinado, las desviaciones típicas de estos valores ajustados y los intervalos de confianza del 95 por ciento. 

Las desviaciones típicas se calculan de la forma descrita en el Capítulo 6 del libro de Wooldridge <@itl="Introductory Econometrics">. Estas tienen en cuenta dos fuentes de variabilidad: la asociada al valor esperado de la variable dependiente condicionado a los valores dados de las variables independientes, y la varianza de los residuos de la regresión. 

Menú gráfico: Ventana de Modelo, /Datos del modelo/Predicciones con desviaciones típicas

Instrucción de guión: <@ref="fcasterr">

# garch Estimation "Modelo GARCH"

Estima un modelo GARCH (GARCH = Generalized Autoregressive Conditional Heteroskedasticity), o un modelo univariante o, si se seleccionan variables independientes, un modelo que incluye éstas como variables exógenas. La ecuación de la varianza condicional se muestra a continuación. 

  <@fig="garch_h">

El algoritmo GARCH de gretl es básicamente el de Fiorentini, Calzolari y Panattoni (1996), y se usa con el amable permiso del profesor Fiorentini. 

Con esta instrucción están disponibles varias variantes de las estimaciones de la matriz de covarianzas de los coeficientes. Por defecto se usa el Hessiano a no ser que se marque el cuadrado "Desviaciones típicas robustas", en cuyo caso se utiliza la matriz de covarianzas QML (White). Se pueden especificar otras posibilidades (p.ej. la matriz de información, o el estimador Bollerslev–Wooldridge) usando la instrucción <@ref="set">. 

Menú gráfico: /Modelo/Serie temporal/GARCH

Instrucción de guión: <@ref="garch">

# genr Dataset "Generar una variable nueva"

Crea variables nuevas, normalmente como transformaciones de variables ya existentes. Ver también <@ref="diff">, <@ref="logs">, <@ref="lags">, <@ref="ldiff">, <@ref="multiply"> y <@ref="square"> como atajos. 

Los operadores aritméticos soportados son, en orden de precedencia: <@lit="^"> (exponenciación); <@lit="*">, <@lit="/"> y <@lit="%"> (módulo o resto); <@lit="+"> y <@lit="-">. 

Los operadores Booleanos disponibles son (de nuevo, en orden de precedencia): <@lit="!"> (negación), <@lit="&"> (Y lógico), <@lit="|"> (O lógico), <@lit=">">, <@lit="<">, <@lit="=">, <@lit=">="> (mayor o igual que), <@lit="<="> (menor o igual que) y <@lit="!="> (distinto que). Se pueden usar operadores Booleanos para construir variables ficticias: por ejemplo <@lit="(x > 10)"> devuelve 1 si <@lit="x"> > 10, y 0 en otro caso. 

Las funciones se clasifican en: 

<indent>
Funcione matemáticas estándar: <@lit="abs">, <@lit="cos">, <@lit="exp">, <@lit="int"> (parte entera), <@lit="ln"> (logaritmo natural: <@lit="log"> es un sinónimo), <@lit="sin">, <@lit="sqrt">. 
</indent>

<indent>
Funciones estadísticas: <@lit="max"> (valor máximo de una serie), <@lit="min"> (mínimo), <@lit="mean"> (media aritmética), <@lit="median">, <@lit="var"> (varianza) <@lit="sd"> (desviación típica), <@lit="sst"> (suma de desviaciones desde la media, al cuadrado), <@lit="sum">, <@lit="cov"> (covarianza), <@lit="corr"> (coeficiente de correlación), <@lit="pvalue">, <@lit="sort">, <@lit="cum"> (acumulación, o suma secuencial), <@lit="resample"> (remuestrear una serie con reemplazamiento, con el propósito de hacer bootstrap), <@lit="hpfilt"> (Filtro de Hodrick–Prescott: esta función devuelve el "componente cíclico" de la serie). 
</indent>

<indent>
Funciones de series temporales: <@lit="diff"> (primera diferencia), <@lit="ldiff"> (diferencia logarítmica, o primera diferencia del logaritmo natural). Para generar retardos de una variable <@lit="x">, se usa la sintaxis <@lit="x(-N)">, donde <@lit="N"> representa la longitud deseada del retardo; para generar adelantos, se usa <@lit="x(+N)">. 
</indent>

<indent>
Funciones de conjunto de datos: <@lit="misszero"> (reemplaza los códigos de observación ausente de una serie dada con ceros); <@lit="zeromiss"> (la operación inversa a <@lit="misszero">); <@lit="nobs"> (devuelve el número de observaciones válidas de una serie de datos determinada), <@lit="missing"> (para cada observación, devuelve 1 si el argumento tiene una observación ausente, y 0 en caso contrario); <@lit="ok"> (el opuesto de <@lit="missing">). 
</indent>

<indent>
Números pseudo-aleatorios: <@lit="uniform">, <@lit="normal">. 
</indent>

Todas las funciones de arriba excepto <@lit="cov">, <@lit="corr">, <@lit="pvalue">, <@lit="uniform"> y <@lit="normal"> toman como único argumento o el nombre de una variable (nótese que, en una fórmula <@lit="genr">, no es posible referirse a las variables por su número de ID) o una expresión que se evalúa en una variable (p.ej. <@lit="ln((x1+x2)/2)">). <@lit="cov"> y <@lit="corr"> requieren dos argumentos, y devuelven respectivamente la covarianza y el coeficiente de correlación entre sus argumentos. La función <@lit="pvalue"> toma los mismos argumentos que la instrucción <@ref="pvalue">, pero en este contexto deben introducirse comas entre los argumentos. Esta función devuelve un valor p a una cola y, en el caso de las distribuciones normal y t, es para la "cola corta". Con la normal, por ejemplo, tanto 1,96 como -1,96 darán un resultado de aproximadamente 0,025. 

<@lit="uniform()"> y <@lit="normal()">, que no toman arguamentos, devuelven series de números pseudo-aleatorios extraídos de la distribución uniforme (0–1) y normal estándar respectivamente (ver también la instrucción <@ref="set">, opción <@lit="seed">). La series de datos uniformes se generan utilizando el Mersenne Twister; para series normales se usa el método de Box y Muller (1958), tomando la entrada del Mersenne Twister. 

Además de los operadores y funciones ya mencionados, hay algunos usos especiales de <@lit="genr">: 

<indent>
<@lit="genr time"> crea una variable de tendencia temporal (1,2,3,…) llamada <@lit="time">. <@lit="genr index"> hace lo mismo, excepto que ahora la variable se denomina <@lit="index">. 
</indent>

<indent>
<@lit="genr dummy"> crea variables ficticias hasta la periodicidad de los datos. P.ej. en el caso de datos trimestrales (periodicidad 4), el programa crea <@lit="dummy_1"> = 1 para el primer trimestre y 0 en los demás trimestres, <@lit="dummy_2"> = 1 para el segundo trimestre y 0 en los demás, y así sucesivamente. 
</indent>

<indent>
<@lit="genr paneldum"> crea un conjunto de variables ficticias especiales para ser usadas con un conjunto de datos de panel — ver <@ref="panel">. 
</indent>

Usando <@lit="genr"> se pueden recuperar los valores de algunas variables internas que se definen al ejecutar una regresión, de la siguiente foprma: 

<indent>
<@lit="$ess">: suma de cuadrados de los residuos 
</indent>

<indent>
<@lit="$rsq">: R-cuadrado no corregido 
</indent>

<indent>
<@lit="$T">: número de observaciones usadas 
</indent>

<indent>
<@lit="$df">: grados de libertad 
</indent>

<indent>
<@lit="$trsq">: TR-cuadrado (el tamaño muestral por el R-cuadrado) 
</indent>

<indent>
<@lit="$sigma">: desviación típica de los residuos 
</indent>

<indent>
<@lit="$aic">: Criterio de información de Akaike 
</indent>

<indent>
<@lit="$bic">: Criterio de información de Schwarz 
</indent>

<indent>
<@lit="$lnl">: logaritmo de la verosimilitud (donde es aplicable) 
</indent>

<indent>
<@lit="coeff">(<@var="var">): coeficiente estimado para la variable <@var="var"> 
</indent>

<indent>
<@lit="stderr">(<@var="var">): desviación típica estimada para la variable <@var="var"> 
</indent>

<indent>
<@lit="rho">(<@var="i">): coeficiente autorregresivo de <@var="i">-ésimo orden de los residuos 
</indent>

<indent>
<@lit="vcv">(<@var="x1">,<@var="x2">): covarianza entre los coeficientes para las variables nombradas <@var="x1"> y <@var="x2"> 
</indent>

Nota: En el programa en línea de instrucciones, las instrucciones <@lit="genr"> que recuperan datos relativos a un modelo siempre hacen referencia al último modelo estimado. Esto también es cierto para el programa en modo GUI, si uno usa <@lit="genr"> en la "consola de gretl" o introduce una fórmula usando la opción "Definir nueva variable" del menú de Variable en la ventana principal. Sin embargo, con el GUI, usted tiene la posibilidad de recuperar datos de cualquier modelo que actualmente se esté mostrando en una ventana (sea o no el modelo más reciente). Usted puede hacer esto bajo el menú "Datos del Modelo" de la ventana del modelo. 

Las series internas <@lit="uhat"> e <@lit="yhat"> contienen, respectivamente, los residuos y los valores ajustados de la última regresión. 

También están disponibles dos variables "internas" relacionadas con el conjunto de datos actual: <@lit="$nobs"> contiene el número de observaciones del rango muestral actual (que puede ser o no igual a <@lit="$T">, el número de observaciones usadas al estimar el último modelo), y <@lit="$pd"> contiene la frecuencia o periodicidad de los datos (p.ej 4 para datos trimestrales). 

La variable <@lit="t"> sirve como índice de las observaciones. Por ejemplo <@lit="genr dum = (t=15)"> generará una variable ficticia que toma valor 1 para la observación 15, y 0 en las demás. La variable <@lit="obs"> es similar pero más flexible: usted puede usarla para extraer observaciones particulares por fecha o nombre. Por ejemplo, <@lit="genr d = (obs>1986:4)"> o <@lit="genr d = (obs="CA")">. La última forma presupone que las observaciones tienen etiquetas; la etiqueta debe ponerse entre comillas. 

Pueden utilizarse valores escalares de una serie en el contexto de una fórmula <@lit="genr">, usando la sintaxis <@var="nombre_var"><@lit="["><@var="obs"><@lit="]">. El valor <@var="obs"> puede darse por número o fecha. Ejemplos: <@lit="x[5]">, <@lit="CPI[1996:01]">. Para datos diarios data, se debe de usar la forma <@var="YYYY:MM:DD">, p.ej. <@lit="ibm[1970:01:23]">. 

Se puede modificar una observación individual de una serie por medio de <@lit="genr">. Para hacerlo, hay que adjuntar al nombre de la variable en el lado izquierdo de la fórmula, entre corchetes, un número de observación válido o una fecha. Por ejemplo, <@lit="genr x[3] = 30"> o <@lit="genr x[1950:04] = 303.7">. 

Aquí hay un par de sugerencias sobre variable ficticias: 

<indent>
Supongamos que <@lit="x"> está codificada con los valores 1, 2, o 3 y usted quiere tres variables ficticias, <@lit="d1"> = 1 si <@lit="x"> = 1, 0 en otro caso, <@lit="d2"> = 1 si <@lit="x"> = 2, y así sucesivamente. Para crearlas, use las instrucciones: 
</indent>

<code>          
	    genr d1 = (x=1)
	    genr d2 = (x=2)
	    genr d3 = (x=3)
</code>

<indent>
Para crear <@lit="z"> = <@lit="max(x,y)"> do 
</indent>

<code>          
	    genr d = x>y
	    genr z = (x*d)+(y*(1-d))
</code>

Menú gráfico: /Variable/Definir nueva variable
Otro acceso: Menú emergente de la ventana principal

Instrucción de guión: <@ref="genr">

# graphing Graphs "Graphing"

Gretl llama a un programa aparte, gnuplot, para generar los gráficos. Gnuplot es un programa con muchas características y miles de opciones. Gretl le proporciona acceso directo, por medio de un interfaz gráfico, a un subconjunto de esas opciones e intenta elegir los valores adecuados por usted; también le permite tomar completamente el control sobre el gráfico, si usted lo desea. 

Cuando se está mostrando un gráfico, usted puede hacer click sobre la ventana del gráfico para que aparezca un menú emergente con las siguientes opciones: 

<indent>
Guardar como postscript: guarda el gráfico en formato postscript encapsulado (EPS) 
</indent>

<indent>
Guardar como PNG: lo guarda en formato PNG (Portable Network Graphics) 
</indent>

<indent>
Guardar a sesión como icono: el gráfico aparecerá como un icono cuando usted seleccione "Vista de iconos" desde el menú de sesión 
</indent>

<indent>
Zoom: le permite seleccionar un área dentro del gráfico para verla con más detalle 
</indent>

<indent>
Imprimir: (sólo en el escritorio Gnome de Linux y en MS Windows) le permite imprimir el gráfico directamente 
</indent>

<indent>
Copiar al portapapeles: (sólo en MS Windows) le permite pegar el gráfico en aplicaciones Windows tales como MS Word 
</indent>

<indent>
Editar: abre un controlador para el gráfico que le permite ajustar varios aspectos de su apariencia 
</indent>

<indent>
Cerrar: cierra la ventana del gráfico 
</indent>

Si Vd. conoce gnuplot y desea tener un control más detallado sobre la apariencia de un gráfico que el que está disponible por medio del controlador gráfico (opción "Editar" option), usted tiene dos opciones: 

<indent>
Una vez que el gráfico se ha guardado como un icono de sesión, usted puede hacer click con el botón derecho del ratón para que aparezca un nuevo menú emergente. Una de las opciones aquí es "Editar las instrucciones del graficos", lo cual abre una ventana de edición que contiene las instrucciones actuales de gnuplot. Vd. puede editar esas instrucciones y guardarlas para un procesado futuro o enviarlas a gnuplot (con el elemento de menú "Archivo/Enviar a gnuplot" en la ventana de edición de instrucciones de gnuplot). 
</indent>

<indent>
Otra manera de guardar las instrucciones del gráfico (o guardar el gráfico representado en formatos distintos de EPS o PNG) es usar el elemento "Editar" del menú emergente del gráfico para invocar al controlador gráfico, después hacer click sobre la solapa "Salida a fichero" en el controlador. Entonces se le presenta un menú con varios formatos en los que guardar el gráfico. 
</indent>

Para conocer más sobre gnuplot, ver http://ricardo.ecn.wfu.edu/gnuplot.html o http://www.gnuplot.info 

# graphpag Graphs "Página de gráficos de Gretl"

La "página de gráficos" en la ventana de sesión sólo funcionará si Vd. tiene el sistema de proceso de textos LaTeX instalado, y es capaz de generar y ver una salida postscript. 

En la ventana de iconos de sesión, Vd. puede arrastrar hasta ocho gráficos al icono de página de gráficos. Cuando usted hace doble click sobre la página de gráficos (o click con el botón derecho y selecciona "Mostrar"), se formará una página con los gráficos elegidos y se abrirá con su visualizador de postscript. Desde allí usted podrá imprimir la página. 

Para vaciar la página de gráficos, pulse con el botón derecho sobre su icono y seleccione "Vaciar". 

En sistemas diferentes de MS Windows, es posible que usted tenga que ajustar las preferencias de gretl para seleccionar el programa que usa para ver ficheros postscript. Puede encontrarlas bajo la solapa "Programas" en la caja de diálogo de preferencias de gretl (bajo el menú Archivo en la ventana principal). 

# 3-D Graphs "Gráficos tridimensionales"

Este servicio funciona mejor si usted tiene instalado gnuplot 3.8 o superior. En ese caso Vd. puede manipular el gráfico tridimensional con el ratón (rotarlo y expandir o contraer los ejes). 

Al formar un gráfico 3-D, nótese que se representará como eje vertical el eje Z. Así que si usted tiene alguna variable dependiente que cree puede verse influída por dos variables independientes, debería poner la variable dependiente en el eje Z y las variables independientes sobre los ejes X e Y. 

Al contrario que en la mayoría de los demás gráficos de gretl, los gráficos tridimensionales los controla gnuplot en lugar del propio gretl. Así que el menú de edición de gráficos de gretl no está disponible. 

# hausman Tests "Contraste de Hausman (diagnósticos de panel)"

Este contraste sólo está disponible después de haber estimado un modelo mediante la instrucción <@ref="pooled"> (ver también <@lit="panel"> y <@lit="setobs">). Contrasta el modelo simple combinado contra sus alternativas principales, el modelo de efectos fijos y el modelo de efectos aleatorios. 

El modelo de efectos fijos añade una variable ficticia para todas menos una de las unidades de sección cruzada, permitiendo al intercepto de la regresión variar a través de estas unidades. Se presenta un estadístico <@itl="F"> para el contraste de significación conjunta de estas variables ficticias. El modelo de efectos aleatorios descompone la varianza residual en dos partes, una parte específica de las unidades de sección cruzada y la otra específica de cada observación particular. (Este estimador sólo puede computarse si el número de unidades de sección cruzada es mayor que el número de parámetros a estimar.) El estadístico LM de Breusch–Pagan sirve para contrastar la hipótesis nula (de que el estimador MCO combinado es el adecuado) contra la alternativa de efectos aleatorios. 

El modelo de MCO combinados puede ser rechazado contra ambas alternativas, el modelo de efectos fijos y el de efectos aleatorios. Si el error específico de unidad o grupo está incorrelacionado con las variables independientes, el estimador de efectos aleatorios es más eficiente que el estimador de efectos fijos; en caso contrario el estimador de efectos aleatorios sería inconsistente y sería preferible el estimador de efectos fijos. La hipótesis nula para el contraste de Hausman es que el error específico de grupo no está tan correlacionado (así que es preferible el modelo de efectos aleatorios). Un valor p bajo para este contraste es un síntoma en contra del modelo de efectos aleatorios y a favor del modelo de efectos fijos. 

Menú gráfico: Ventana de Modelo, /Contrastes/Diagnósticos de panel

Instrucción de guión: <@ref="hausman">

# hccm Estimation "Estimación HCCM"

Matriz de covarianzas consistente ante heterocedasticidad: esta instrucción ejecuta una regresión en la que los coeficientes se estiman mediante un procedimiento MCO estándar, pero las desviaciones típicas de los coeficientes estimados se calculan de una manera que es robusta ante heterocedasticidad, en concreto usando el procedimiento "jackknife" de MacKinnon–White. 

Menú gráfico: /Modelo/HCCM

Instrucción de guión: <@ref="hccm">

# hilu Estimation "Estimación de Hildreth-Lu"

Calcula estimaciones de los parámetros del modelo especificado usando el procedimiento de búsqueda de Hildreth–Lu search procedure (refinado mediante el procedimiento CORC). Este procedimiento está diseñado para corregir las estimaciones teniendo en cuenta la correlación serial del término de error. La suma de cuadrados de los residuos del modelo transformado se representa con respecto al valor de rho desde –0.99 hasta 0.99. 

Menú gráfico: /Modelo/Serie temporal/Hildreth-Lu

Instrucción de guión: <@ref="hilu">

# hsk Estimation "Estimaciones corregidas de heterocedasticidad"

Se calcula una regresión por MCO y se guardan los residuos. El logaritmo del cuadrado de los residuos entonces pasa a ser la variable dependiente en una regresión auxiliar, en cuyo lado derecho están las variables independientes originales más sus cuadrados. Los valores ajustados en la regresión auxiliar se usan entonces para construir una serie de ponderaciones y el modelo original se reestima utilizando mínimos cuadrados ponderados. El resultado final se presenta en un informe. 

La serie de ponderaciones se forma como <@fig="hsk">, donde <@itl="y*"> denota los valores ajustados mediante la regresión auxiliar. 

Menú gráfico: /Modelo/Corregido de Heterocedasticidad

Instrucción de guión: <@ref="hsk">

# label Dataset "Editar los atributos de una variable"

En esta caja de diálogo Vd. puede: 

* Renombrar una variable. 

* Añadir o editar una descricpción de la variable: esta aparecerá junto al nombre de la variable en la ventana principal de gretl. 

* Añadir o editar el "nombre a mostrar" para la variable. Esta cadena de caracteres (máximo 19 caracteres) se muestra en lugar del nombre de la variable cuando la variable se representa en un gráfico. Así, por ejemplo, Vd. puede asociar una cadena más comprensible como "tipo de interés a tres meses" a una variable que tenga un nombre más críptico como "t3". 

* (En el caso de un conjunto de datos de series temporales) establecer el método de compactado para la variable. Este método será el que se use si usted decide reducir la frecuencia del conjunto de datos, o si usted actualiza la variable importándola desde una base de datos donde la variable esté a una frecuencia mayor que en su conjunto de datos. 

Menú gráfico: /Variable/Editar atributos
Otro acceso: Menú emergente de la ventana principal

Instrucción de guión: <@ref="label">

# lad Estimation "Estimación de mínima desviación absoluta"

Calcula una regresión que minimiza la suma de las desviaciones absolutas de los valores observados de la variable dependiente con respecto a los ajustados. La estimaciones de los coeficientes se derivan usando el algoritmo simplex de Barrodale–Roberts; se muestra un aviso si la solución no es única. Las desviaciones típicas se derivan utilizando el procedimiento bootstrap con 500 extracciones. 

Menú gráfico: /Modelo/Mínima devsiación absoluta

Instrucción de guión: <@ref="lad">

# leverage Tests "Observations influyentes"

Debe ejecutarse inmediatamente después de una instrucción <@lit="MCO">. Calcula el apalancamiento (<@itl="h">, que debe estar entre 0 y 1) para cada punto de datos de la muestra sobre la que se estimó el último modelo. Presenta el residuo (<@itl="u">) de cada observación junto a su apalancamiento y una medida de su influencia sobre las estimaciones, <@fig="influence">. Los "puntos palanca" para los cuales el valor de <@itl="h"> es mayor que 2<@itl="k">/<@itl="n"> (donde <@itl="k"> es el número de parámetros estimados y <@itl="n"> es el tamaño muestral) se marcan con un asterisco. Para más detalles sobre los conceptos de apalancamiento e influencia ver Davidson and MacKinnon (1993, Capítulo 2). 

También se presentan los valores DFFITS: estos son los "residuos studentizados" (residuos predichos divididos por sus desviaciones típicas) multiplicados por <@fig="dffit">. Para más detalles sobre residuos studentizados y DFFITS ver el libro de G. S. Maddala, <@itl="Introduction to Econometrics">, capítulo 12; y también Belsley, Kuh y Welsch (1980). En resumen, un "residuo predicho" es la diferencia entre el valor observado de la variable dependiente en la observación <@itl="t"> y el valor ajustado para la observación <@itl="t"> obtenido de una regresión en la que se omite esa observación (o se añade una variable ficticia con valor 1 sólo para la observación <@itl="t">); el residuo studentizado se obtiene dividiendo el residuo predicho por su desviación típica. 

El icono "+" en la parte de arriba de la ventana del contraste de apalancamiento abre una caja de diálogo que le permite guardar una o más de las variables del contraste al conjunto de datos actual. 

Menú gráfico: Ventana de Modelo, /Contrastes/observaciones influyentes

Instrucción de guión: <@ref="leverage">

# lmtest Tests "Contrastes LM"

Bajo este encabezamiento se agrupan varios contrastes de hipótesis. Lo que tienen en común es que el contraste requiere la estimación de una regresión auxiliar, en la que la variable dependiente es el residuo de alguna regresión "original". Las variables del lado derecho inluyen a las de la regresión original ademas de algunos términos adicionales. El estadístico de contraste se calcula como (tamaño muestral * R-cuadrado) de la regresión auxiliar: este se distribuye como una chi-cuadrado con grados de libertad igual al número de términos adicionales, bajo la hipótesis nula de que los términos adicionales no tienen poder explicativo sobre lois residuos. Un valor "grande" del estadístico (valor p pequeño) sugiere que esa hipótesis nula debería ser rechazada. 

Menú gráfico: Ventan de Modelo, /Contrastes

Instrucción de guión: <@ref="lmtest">

# logistic Estimation "Regresión logística"

Regresión logística: desarrolla una regresión MCO utilizando la transformación logística de la variable dependiente, 

  <@fig="logistic1">

La variable dependiente debe ser estrictamente positiva. Si es una fracción decimal, entre 0 y 1, por defecto se usa un valor ymax (el máximo asintótico de la variable dependiente) de 1. Si la variable dependiente es un porcentaje, entre 0 y 100, por defecto el valor de ymax es 100. Se presenta una caja de diálogo que le permite especificar un máximo diferente, si usted lo desea. El valor de ymax proporcionado debe ser mayor que todos los valores observados de la variable dependiente. 

Los valores ajustados y los residuos de la regresión se transforman automáticamente usando 

  <@fig="logistic2">

donde <@itl="x"> representa o un valor ajustado o un residuo de la regresión MCO usando la variable dependiente transformada. Los valores que se presentan son así comparables con los valores originales de la variable dependiente. 

Nótese que si la variable dependiente es binaria, en lugar de esto se debería usar la instrucción <@lit="logit">. 

Menú gráfico: /Modelo/Logístico

Instrucción de guión: <@ref="logistic">

# logit Estimation "Regresión Logit"

Regresión binomial logit. La variable dependiente debería ser una variable binaria. Se obtienen las estimaciones máximo-verosímiles de los coeficientes de las variables <@var="varindeps"> por medio del método EM (Expectation–Maximization method, ver Ruud, 2000, Capítulo 27). Como el modelo no es lineal las pendientes dependen de los valores de las variables independientes: las poendientes que se presentan se han evaluado en la media de dichas variables. La hipótesis de que todos los coeficientes, aparte de la constante, son cero se contrasta mediante el estadístico chi-cuadrado. 

Si Vd. desea utilizar logit para el análisis de proporciones (donde la variable dependiente, para cada observación, es la proporción de casos que tienen una determinada característica, en lugar de un 1 o un 0 indicando si la característica está presente o no) no debería usar la instrucción <@lit="logit">, sino mejor debería construir la variable logit (p.ej. <@lit="genr lgt_p = log(p/(1 - p))">) y usarla como variable dependiente en una regresión MCO. Ver Ramanathan, Capítulo 12. 

Menú gráfico: /Modelo/Logit

Instrucción de guión: <@ref="logit">

# markers Dataset "Añadir marcadores de caja"

Esta orden requiere el nombre de un fichero que contenga los "marcadores de caja", es decir, pequeñas cadenas de caracteres para identificar a las observaciones individuales del conjunto de datos. Estas cadenas de caracteres no deberían tener más de 8 caracteres. El fichero debería contener un marcador por línea y debería de haber exactamente tantos marcadores como observaciones haya en el conjunto de datos. Si se satisfacen estas condiciones y se encuentra el fichero especificado se añadirán los marcadores de caja; serán visibles cuando usted elija "Mostrar valores" en el menú de Datos de gretl. 

# meantest Tests "Diferencia de medias"

Calcula el estadístico t para la hipótesis nula de que las medias poblacionales de dos variables elegidas son iguales y muestra su valor p. La instrucción puede invocarse con o sin el supuesto de que las varianzas de las dos variables son iguales (aunque esto implicará una diferencia en el estadístico de contraste sólo si hay un número diferente de valores no ausentes para las dos variables). 

Menú gráfico: /Datos/Diferencia de medias

Instrucción de guión: <@ref="meantest">

# missing Dataset "valores ausentes"

Establece un valor numérico que se interpretará como "ausente" o "no disponible", o para una serie de datos concreta (en el menú de Variable) o globalmente para el conjunto de datos completo (en el menú de Muestra). 

Gretl tiene su propio código interno para los valores ausentes, pero a veces los datos que se importan pueden emplear un código diferente. Por ejemplo, si una serie particular se codifica de manera que el valor -1 indica "no disponible", Vd. puede seleccionar "Establecer código de 'valor perdido'" bajo el menú de Variable y escribir el valor "-1" (sin las comillas). Gretl entonces leerá los -1s como valores ausentes. 

# modeltab Utilities "La tabla de modelos"

En la investigación econométrica es frecuente estimar varios modelos para una variable dependiente común—los modelos pueden ser diferentes respecto a las variables independientes que incluyen, o quizás respecto al estimador utilizado. En esta situación es coveniente presentar los resultados de las regresiones en forma de tabla, donde cada columna contiene los resultados para un modelo dado (estimaciones de los coeficientes y desviaciones típicas), y cada fila contiene las estimaciones dadas por los diferentes modelos para una misma variable. 

Gretl proporciona un método para construir dicha tabla (y copiarla en texto plano, LaTeX o formato RTF). Hé aquí cómo hacerlo: 

<indent>
1. 1. Estimar un modelo que Vd. desea incluir en la tabla y en la ventana del modelo, bajo el menú Archivo, seleccionar "Guardar a sesión como icono" o "Guardar a sesión como icono y cerrar". 
</indent>

<indent>
2. 2. Repetir el paso 1 para los otros modelos que desee incluir en la tabla (hasta un total de seis). 
</indent>

<indent>
3. 3. Cuando haya acabado de estimar los modelos, abra la vista de iconos de su sesión gretl (seleccionando "Vista de iconos " bajo el menú de Sesión en la ventana principal de gretl, o pulsando sobre el icono de "vista de iconos de sesión" en la barra de herramientas de gretl). 
</indent>

<indent>
4. 4. En la vista de iconos de sesión hay un icono de nombre "Tabla de Modelos". Decida qué modelo desea que aparezca en la columna de la izquierda en la Tabla de modelos y añádalo a la tabla o arrastrando su icono al icono de la tabla de modelos o pulsando con el botón derecho del ratón sobre el icono del modelo y seleccionando "Añadir a la tabla de modelos" en el menú que entonces surge. 
</indent>

<indent>
5. 5. Repetir el paso 4 para los demás modelos que desee incluir en la tabla. El segundo modelo elegido aparecerá en la segunda columna desde la izquierda, y así sucesivamente. 
</indent>

<indent>
6. 6. Cuando haya acabado de formar la tabla de modelos, puede verla haciendo doble click sobre su icono. En el menú Editar de la ventana que aparece, tiene Vd. la opción de copiar la tabla al portapapeles en varios formatos diferentes. 
</indent>

<indent>
7. 7. Si el orden de los modelos en la tabla no es el que Vd. deseaba pulse con el botón derecho del ratón sobre el icono de la tabla de modelos y elija "Vaciar". Después vuelva al paso 4 anterior e inténtelo otra vez. 
</indent>

Menú gráfico: Ventana de sesión, icono de Tabla de modelos

Instrucción de guión: <@ref="modeltab">

# mpols Estimation "MCO de precisión Múltiple"

Computa las estimaciones MCO para el modelo especificado, usando aritmética de punto flotante con precisión múltiple. Esta instrucción sólo está disponible si gretl se compila con soporte para la biblioteca Gnu de Precisión Múltiple (GMP). 

Menú gráfico: /Modelo/MCO de alta precisión

Instrucción de guión: <@ref="mpols">

# nls Estimation "Mínimos cuadrados no lineales"

Desarrolla la estimación por Mínimos Cuadrados No Lineales (NLS) utilizando una versión modificada del algoritmo de Levenberg–Marquandt. Usted debe suministrar la especificación de una función; también se recomienda que, si es posible, suministre las expresiones de las derivadas de la función con respecto a cada uno de los parámetros. 

Ejemplo: Supongamos que tenemos un conjunto de datos con las variables C e Y (p.ej. greene11_3.gdt) y deseamos estimar una función de consumo no lineal de la forma 

  <@fig="greene_Cfunc">

Los parámetros alfa, beta y gamma deben añadirse primero al conjunto de datos y hay que asignarles unos valores iniciales. Esto puede hacerse usando la instrucción genr o por medio de los menús. Las expresiones "genr" que corresponda pueden escribirse dentro de la ventana de especificación de MC no lineales antes de la especificación de la función. 

En la ventana de MC no lineales escribiremos las siguientes líneas: 

<code>          
	C = alfa + beta * Y^gamma
	deriv alfa = 1
	deriv beta = Y^gamma
	deriv gamma = beta * Y^gamma * log(Y)
</code>

La primera línea determina la función de regresión y las tres siguientes líneas proporcionan las derivadas de la función con respecto a cada uno de los parámetros. Si no se proporcionan las líneas "deriv", se computa una aproximación numérica al Jacobiano. 

Si los parámetros alfa, beta y gamma no se hubieran declarado previamente, podríamos escribir las siguientes líneas justo antes de las que se han presentado arriba: 

<code>          
	genr alfa = 1
	genr beta = 1
	genr gamma = 1
</code>

Para más detalles sobre la estimación por MC. no lineales ver <@pdf="el manual de gretl ">. 

Menú gráfico: /Modelo/Mínimos cuadrados no lineales

Instrucción de guión: <@ref="nls">

# nulldata Dataset "Crear un conjunto de datos vacío"

Forma un conjunto de datos "vacío", que contiene sólo una constante y una variable índice, con periodicidad 1 y el número de observaciones especificado. Esto puede usarse para hacer simulaciones: algunas de las instrucciones <@lit="genr"> (p.ej. <@lit="genr uniform()">, <@lit="genr normal()">) generan, desde cero, datos ficticios para rellenar el conjunto de datos. Esta instrucción puede ser útil también junto a la instrucción <@lit="loop">. Ver también la opción "seed" de la instrucción <@ref="set">. 

Menú gráfico: /Archivo/Crear conjunto de datos

Instrucción de guión: <@ref="nulldata">

# ols Estimation "Mínimos Cuadrados Ordinarios"

Calcula las estimaciones de Mínimos Cuadrados Ordinarios (MCO) para el modelo especificado. 

Además de las estimaciones de los coeficientes y de las desviaciones típicas, el programa también presenta los valores p de los estadísticos <@itl="t"> (a dos colas) y <@itl="F">. Un valor p inferior a 0,01 indica significatividad al nivel del 1 por ciento y se denota mediante <@lit="***">. <@lit="**"> indica un nivel de significatividad entre el 1 y 5 por ciento y <@lit="*"> indica significatividad entre el 5 y 10 por ciento. También se presentan algunos estadísticos de selección de modelos (se describen en Ramanathan, Sección 4.3). 

Si se da la opción <@lit="--no-df-corr">, no se aplica la corrección habitual de grados de libertad al calcular la estimación de la varianza de las perturbaciones (y así tampoco en la estimación de las desviaciones típicas de los estimadores de los parámetros). 

La opción <@lit="--print-final"> es aplicable sólo en el contexto de un bucle (ver <@ref="loop">). Se encarga de que las regresiones se ejecuten "silenciosamente" en todas las iteraciones excepto la iteración final del bucle. Ver <@pdf="el manual de gretl "> para más detalles. 

Menú gráfico: /Modelo/Mínimos cuadrados ordinarios
Otro acceso: Botón beta con sombrero en la barra de herramientas

Instrucción de guión: <@ref="ols">

# omit Tests "Omisión de variables"

Esta instrucción debe invocarse justo después de una instrucción de estimación. Las variables seleccionadas se omiten del modelo anterior y se estima el nuevo modelo. Si se omite más de una variable, se presentará el estadístico <@itl="F"> de Wald para las variables omitidas y su valor p (sólo para el método MCO). Un valor p inferior a 0,05 indica que los coeficientes son conjuntamente significativos al nivel de significación del 5 por ciento. 

Menú gráfico: ventana de Modelo, /Contrastes/omitir variables

Instrucción de guión: <@ref="omit">

# online Dataset "Bases de datos de acceso en línea"

Gretl es capaz de acceder a las bases de datos de la Universidad de Wake Forest (para que esto funcione, su ordenador debe estar conectado a internet). 

Bajo el menú "Archivo, Revisar bases de datos", seleccione el elemento "sobre servidor". Entonces tendría que aparecer una ventana presentando una lista de bases de datos en formato gretl disponibles en Wake Forest. (Esto puede llevar un tiempo, dependiendo de dónde se encuentre usted y de la velocidad de su conexión a internet.) Junto al nombre de la base de datos y su pequeña descripción aparecerá una columna de "estado local": esto le indica si usted tiene ya la base de datos instalada localmente (en su disco duro) y si es así, si está actualizada con la versión del servidor. 

Si usted tiene una determinada base de datos instalada localmente y está actualizada, no hay ninguna ventaja al acceder a ella por medio del servidor. Pero para una base de datos que no esté instalada y actualizada, es posible que usted desee obtener el listado de las series que contiene: para ello pulse sobre "Obtener listado de series". Esto abre una nueva ventana, desde la que Vd. puede ver los valores de una serie determinada, representar esos valores o importarlos al espacio de trabajo de gretl. Estas tareas pueden llevarse a cabo usando el menú "Series" o por medio del menú emergente que aparece cuando usted pulsa con el botón derecho sobre una serie determinada. También puede buscar a lo largo del listado la variable que a Vd. le interese (mediante el elemento "Buscar" del menú). 

Si Vd. desea un acceso a los datos más rapido, o si desea acceder a la base de datos estando su ordenador fuera de línea (desconectado de internet), seleccione la línea que contiene la base de datos que Vd. desea y pulse el botón "Instalar". esto descargará la base de datos en formato comprimido, lo descomprimirá y lo instalará en su disco duro. A partir de entonces usted debería encontrarlo bajo el menú "Archivo, Revisar bases de datos, nativa gretl". 

# panel Dataset "Datos de panel"

Aquí hay dos opciones "series temporales apiladas" y "secciones cruzadas apiladas". Si Vd. quiere utilizar la instrucción "MC combinados" y sus correspondientes diagnósticos de panel, Gretl debe conocer cómo están organizados sus datos. 

"Series temporales apiladas" significa que los bloques en el fichero de datos tienen la estructura de series temporales para cada una de las unidades de sección cruzada. Por ejemplo, las primeras 10 filas de datos podrían representar los valores de ciertas variables para el país A durante 10 periodos, las siguientes 10 filas los valores para el país B durante los mismos 10 periodos, y así sucesivamente. 

"Seciones cruzadas apiladas" significa que los bloques del fichero de datos tienen la estructura de secciones cruzadas para cada uno de los periodos temporales. Por ejemplo, las primeras 6 filas de datos posrían representar los valores de ciertas variables para los países A, ..., F para el año 1970, las 6 siguientes filas, los valores para los mismos países en el año 1971, y así sucesivamente. 

Si Vd. guarda su ficherode datos después de establecer este atributo, esta información se grabará al fichero y así no tendrá que introducirla de nuevo. 

Hay que señalar que este elemento de menú no altera la estructura de su conjunto de datos de panel, sólo fija la interpretación de esa estructura por parte de gretl. Si desea convertir un panel de datos que actualmente está en forma de secciones cruzadas apiladas a la forma de series temporales apiladas, use el elemento de menú "Reestructurar panel". 

Menú gráfico: /Muestra/Interpretar como panel

Instrucción de guión: <@ref="panel">

# pca Statistics "Análisis de componentes principales"

Análisis de componentes principales. Presenta los valores propios de la matriz de correlación de las variables de la lista <@var="listavar"> y la proporción de la varianza conjunta explicada por cada uno de los componentes. También presenta los vectores propios correspondientes (o "ponderaciones de los componentes"). 

Si se da la opción <@lit="--save">, los componentes con valorres propios mayores que 1,0 se guardan como variables en el conjunto de datos, con nombres <@lit="PC1">, <@lit="PC2"> y así sucesivamente. Estas variables artificiales se forman como la suma de (ponderaciones de los componentes) por (<@lit="Xi"> estandarizadas), donde <@lit="Xi"> denota la <@itl="i">-ésima variable de la lista <@var="listavar">. 

Si se da la opción <@lit="--save-all">, se guardan todos los componentes de la manera que se ha descrito arriba. 

Menú gráfico: Menú emergente de la ventana principal (selección múltiple)

Instrucción de guión: <@ref="pca">

# pergm Statistics "Periodograma"

Calcula y presenta (y si no se ejecuta en modo batch, representa gráficamente) el espectro de la variable especificada. Sin la opción <@lit="--bartlett"> se ofrece el periodograma muestral; con dicha opción, se utiliza una ventana de retardos de Bartlett de longitud <@fig="tworootT"> (donde <@itl="T"> es el tamaño muestral) para estimar el espectro (ver Capítulo 18 del libro de Greene <@itl="Econometric Analysis">). Cuando se presenta el periodograma muestral, también se proporciona un contraste <@itl="t"> sobre integración fraccional de la serie ("memoria larga"): la hipótesis nula es que el orden de integración es cero. 

Menú gráfico: /Variable/Espectro
Otro acceso: Menú emergente de la ventana principal (selección simple)

Instrucción de guión: <@ref="pergm">

# pooled Estimation "MCO combinados"

Estima un modelo vía MCO (ver <@ref="ols"> para los detalles sobre su sintaxis), y lo marca como 'combinado' o 'modelo de panel', de manera que se hace disponible el contraste de <@ref="hausman">. 

Menú gráfico: /Modelo/MCO combinados (panel)

Instrucción de guión: <@ref="pooled">

# probit Estimation "Modelo Probit"

La variable dependiente debería ser una variable binaria. Se obtienen las estimaciones máximo-verosímiles de los coeficientes de las variables <@var="varindeps"> por medio de mínimos cuadrados iterativos (el método EM o Expectation–Maximization). Como el modelo no es lineal las pendientes dependen de los valores de las variables independientes: las pendientes que se presentan están evaluadas en las medias de dichas variables. El estadístico chi-cuadrado sirve para contrastar la hipótesis nula de que todos los coeficientes, excepto la constante, son cero. 

El análisis Probit de proporciones no está aún implementado en gretl. 

Menú gráfico: /Modelo/Probit

Instrucción de guión: <@ref="probit">

# pwe Estimation "Estimador de Prais-Winsten"

Calcula estimaciones de los parámetros utilizando el procedimiento de Prais–Winsten, un método de Mínimos cuadrados generalizados factibles que está diseñado para tener en cuenta la autocorrelación de primer orden del término de error. El procedimiento es iterativo, igual que <@ref="corc">; la diferencia es que mientras el método de Cochrane–Orcutt desperdicia la primera observación, el de Prais–Winsten la utiliza. Para más detalles, ver por ejemplo el Capítulo 13 del libro de Greene <@itl="Econometric Analysis"> (2000). 

Menú gráfico: /Modelo/Serie temporal/Prais-Winsten

Instrucción de guión: <@ref="pwe">

# reset Tests "Ramsey's RESET"

Debe ejecutarse después de la estimación de un modelo vía MCO. Realiza el contraste de especificación de modelos (no linealidad) RESET de Ramsey. Para ello añade a la regresión el cuadrado y el cubo de los valores ajustados y calcula el estadístico <@itl="F"> para la hipótesis nula de que los parámetros de las dos variables añadidas son cero. 

Menú gráfico: Ventana de Modelo, /Contrastes/Contraste RESET de Ramsey

Instrucción de guión: <@ref="reset">

# restrict Tests "Restricciones lineales"

Evalúa un conjunto de restricciones sobre los parámetros del último modelo estimado. En modo "guión de instrucciones", el conjunto de restricciones debe incluirse entre "restrict" y "end restrict", pero en la caja de diálogo sobre restricciones (en el entorno gráfico) pueden omitirse esas líneas. 

Cada restricción del conjunto debe expresarse como una ecuación, con una combinación lineal de los parámetros a la izquierda y un valor numérico a la derecha del signo igual. Los parámetros se referencian en la forma b<@var="N">, donde <@var="N"> representa la posición en la lista de regresores, comenzando en cero. Por ejemplo, <@lit="b1"> denota al segundo parámetro de la regresión. 

El segundo y siguientes términos <@lit="bN"> de una ecuación pueden ir premultiplicados por un número, utilizando <@lit="*"> para representar la multiplicación, por ejemplo <@lit="3.5*b4">. 

He aquí un ejemplo de un conjunto de restricciones: 

<code>          
	restrict
	 b1 = 0
	 b2 - b3 = 0
	 b4 + 2*b5 = 1
	end restrict
</code>

Las restricciones se evalúan mediante un contraste F de Wald, usando la matriz de covarianzas de los coeficientes del modelo en cuestión. 

Menú gráfico: Ventana de Modelo, /Contrastes/Restricciones lineales

Instrucción de guión: <@ref="restrict">

# rmplot Graphs "Gráfico Rango-Media"

Gráfico Rango–media plot: esta instrucción crea un sencillo gráfico para ayudar a decidir si una serie temporal, <@itl="y">(t), tiene varianza constante o no. Se toma la muestra completa t=1,...,T y se divide en pequeñas submuestras de tamaño arbitrario <@itl="k">. La primera submuestra se forma con <@itl="y">(1),...,<@itl="y">(k), la segunda con <@itl="y">(k+1), ..., <@itl="y">(2k), y así sucesivamente. Para cada submuetra se calcula la media muestral y el rango (= el máximo menos el mínimo), y se forma un gráfico con las medias en el eje horizontal y los rangos en el vertical. Así, cada submuestra está representada por un punto en este plano. Si la varianza de la serie es constante, se espera que los rangos de las submuestras sean independientes de las medias; si vemos que los puntos se distribuyen a lo largo de una línea de creciente, esto sugiere que la varianza de la serie aumenta con la media; si los puntos siguen una línea decreciente esto indica que la varianza disminuye a medida que la media aumenta. 

Además del gráfico, gretl presenta las medias y los rangos de cada submuestra, el coeficiente para la pendiente en una regresión MCO de los rangos sobre las medias y el valor p para el contraste de la hipótesis nula de que dicha pendiente es cero. Si el coeficiente de la pendiente es significativo, al nivel de significación del 10 por ciento, se muestra también en el gráfico la recta de regresión estimada de los rangos sobre las medias. 

Menú gráfico: /Variable/Gráfico rango-media

Instrucción de guión: <@ref="rmplot">

# runs Tests "Contraste de rachas"

Realiza el contraste "rachas" (no paramétrico) de aleatoriedad de la variable especificada. Si Vd. desea contrastar la aleatoriedad de las desviaciones respecto a la mediana, para una variable denominada <@lit="x1"> con mediana distinta de cero, puede hacer lo siguiente: 

<code>          
	genr signx1 = x1 - median(x1)
	runs signx1
</code>

Menú gráfico: /Variable/Contraste de rachas

Instrucción de guión: <@ref="runs">

# sampling Dataset "Establecer el rango muestral"

El menú Muestra ofrece varias maneras de seleccionar una submuestra a partir del conjunto de datos actual. 

Si Vd. elige "Muestra/Sample/Definir, a partir de v. ficticia..." se le indica que seleccione una variable ficticia (indicadora), que debe tener los valores 0 o 1 para cada observación. La muestra se restringirá entonces a las observaciones para las cuales la variable ficticia vale 1. 

Si Vd. elige "Muestra/Restringir, a partir de criterio..." es necesario que Vd. proporcione una expresión Booleana (lógica) del mismo tipo que Vd. usaría para definir una variable ficticia. Por ejemplo, la expresión "sqft > 1400" seleccionará sólo casos para los que la variable sqft tiene un valor mayor que 1400. Las condiciones pueden estar concatenadas utilizando para ello los operadores lógicos "&"(AND) y "|" (OR), y puede aplicarse también la negación usando "!" (NOT). 

El elemento de menú "Muestra/Quitar todas las obs. con valores perdidos" redefine la muestra de manera que se excluyen todas las observaciones para las cuales faltan los valores de una o más variables (se dejan sólo los datos completos). 

Para seleccionar las observaciones para las cuales una variable particular no tiene valores ausentes, use "Muestra/Restringir, a partir de criterio..." e introduzca la condición Booleana "!missing(nombre_var)" (reemplac "nombre_var" por el nombre de la variable que Vd. desee usar). 

Si las observaciones tienen nombre (marcas de caja), Vd. puede remuestrear de manera que se excluya una observación particular, utilizando por ejemplo "obs!="France"" como condición Booleana. El nombre de la observación debe estar incluido entre comillas. 

Al definir una muestra a partir de una variable ficticia, una expresión Booleana o por el criterio de los valores perdidos, hay que señalar que cualquier información "estructural" en el encabezamiento del fichero de datos (con respecto a la estructura de series temporales o de panel) se pierde. Vd. puede reimponerla de nuevo usando el menú "Muestra/Establecer frecuencia, observación inicial...". 

Véase <@pdf="el manual de gretl "> para más detalles. 

# scatters Graphs "Gráficos bivariantes múltiples"

Dibuja un conjunto de gráficos por parejas de la variable elegida del eje "Y" con respecto a cada una de las variables elegidas del eje "X". Revisar un conjunto de gráficos como estos puede ser útil al realizar análisis exploratorio de datos. El número máximo de gráficos es seis; cualquier otra variable extra en la lista de variables del eje X será ignorada. 

Menú gráfico: /Datos/Gráficos bivariantes múltiples

Instrucción de guión: <@ref="scatters">

# seed Programming "Semilla aleatoria"

Requiere como entrada un número entero. Establece la semilla para el generador de números pseudoaleatorios que se utiliza bajo el menú Datos, Añadir variables, Aleatoria normal y Aleatoria uniforme. Por defecto, la semilla se establece cuando se inicia el programa usando la hora del sistema. Si Vd. desea obtener secuencias de números pseudoaleatorios repetibles necesitará determinar la semilla de forma manual. 

# setobs Dataset "Frequencia y observación inicial"

Esta instrucción se usa para forzar al programa a interpretar el conjunto de datos actual como series temporales o como panel, cuando los datos se han leído como series simples sin fechas. Se necesitan dos parámetros: una frecuencia entera y una cadena de caracteres para la observación inicial (normalmente una fecha). He aquí algunos ejemplos de código válido: 

Menú gráfico: /Muestra/Establecer frecuencia, observación inicial

Instrucción de guión: <@ref="setobs">

# setmiss Dataset "Código de valor ausente"

Determina un valor numérico que se intepretará como "ausente" o "no disponible", o para una serie de datos concreta (bajo el menú de Variable) o globalmente para el conjunto de datos completo (bajo el menú de Muestra). 

Gretl tiene su cpropio código inetrno para manejar valores ausentes, pero a veces los datos importados emplean un código diferente. Por ejemplo, si una serie particular está codificada de manera que el valor de -1 indica "no disponible", Vd. puede seleccionar "Establecer código de 'valor perdido'" en el menú de Variable y escribir allí el valor "-1" (sin las comillas). Entonces gretl leerá los -1s como observaciones ausentes. 

Menú gráfico: /Muestra/Establecer código de 'valor perdido'

Instrucción de guión: <@ref="setmiss">

# sim Dataset "Simulación"

Simula valores para <@var="nombre_var"> para el rango muestral actual o para el rango <@var="obs_inicial"> hasta <@var="obs_final"> si se dan estos argumentos. La variable <@var="y"> debe haber sido definida antes con valores iniciales apropiados. La fórmula utilizada es 

  <@fig="simformula">

Los términos <@lit="ai(t)"> pueden ser números constantes o nombres de variables definidas previamente; esos términos pueden ir precedidos de un signo menos. 

Esta instrucción ya no se recomienda. En su lugar debería de usarse <@ref="genr">. 

Instrucción de guión: <@ref="sim">

# spearman Statistics "Correlación por rangos de Spearmans"

Calcula el coeficiente de correlación por rangos de Spearman para un par de variables especificado. No es necesario antes ordenar y hacer el ranking de las variables, la función se encarga de ello. 

El ranking automático es de mayor a menor (es decir, el mayor valor de los datos obtiene rango 1). Si Vd. necesita invertir este ranking cree una nueva variable que sea el negativo de la primera original. Por ejemplo: 

<code>          
	genr altx = -x
	spearman altx y
</code>

Menú gráfico: /Modelo/Correlación por Rangos

Instrucción de guión: <@ref="spearman">

# store Dataset "Guardar datos"

Guarda el conjunto de datos completo o, si se suministra una lista <@var="listavar">, el subconjunto especificado de variables del conjunto de datos actual, al fichero dado en <@var="fichero_de_datos">. 

Por defecto los datos se guardan en formato gretl "nativo", pero las distintas opciones permiten guardarlos en varios formatos alternativos. Los datos CSV (Comma-Separated Values) pueden ser leídos por programas de hoja de cálculos y también pueden manipularse mediante un editor de textos. Los formatos de Octave, R y PcGive están diseñados para el uso con estos respectivos programas. La compresión mediante Gzip puede ser útil para grandes conjuntos de datos. Ver <@pdf="el manual de gretl "> para detalles sobre los distintos formatos. 

Hay que señalar que las variables escalares no serán guardadas automáticamente: si Vd. desea guardar escalares debe escribirlas explícitamente en la lista <@var="listavar">. 

Menú gráfico: /Archivo/Guardar datos; /Archivo/Exportar datos

Instrucción de guión: <@ref="store">

# tobit Estimation "Modelo Tobit"

Estima un modelo Tobit. Este modelo puede ser adecuado cuando la variable dependiente es una variable "truncada". Por ejemplo, se observan valores positivos y cero de las compras de bienes duraderos por parte de las familias, pero no valores negativos. Sin embargo las decisiones sobre tales compras pueden considerarse como resultados de una disposición subyacente a la compra que puede ser negativa en algunos casos. Para detalles ver el libro de Greene <@itl="Econometric Analysis">, Capítulo 20. 

Menú gráfico: /Modelo/Tobit

Instrucción de guión: <@ref="tobit">

# tsls Estimation "Mínimos cuadrados en dos etapas"

Esta instrucción necesita la selección de dos listas de variables: las variables independientes del modelo y una lista de "instrumentos". La última recoge las variables exógenas y/o predeterminadas que pueden usarse como regresores para obtener valores ajustados para las variables endógenas del lado derecho. 

Si alguna de las variables del lado derecho del modelo son exógenas, deberían estar incluidas en ambas listas. 

Menú gráfico: /Modelo/Mínimos cuadrados en dos etapas

Instrucción de guión: <@ref="tsls">

# var Estimation "Autorregresión vectorial"

Este mandato necesita la especificación de: 

<indent>
- la variable dependiente de la primera ecuación del sistema VAR; 
</indent>

<indent>
- el orden de retardos, es decir, el número de retardos de cada variable que deberían incluirse en el sistema; 
</indent>

<indent>
- los posibles términos determinísticos (es decir, la constante, tendencia temporal, variables ficticias estacionales, etc); y 
</indent>

<indent>
- una lista de variables independientes, cuyos retardos se incluirán en el lado derecho de las ecuaciones (nota: no incluir en esta lista variables retardadas -- serán añadidas automáticamente). 
</indent>

Se ejecutará una regresión por separado para cada variable del sistema. La salida de cada ecuación contiene los contrastes F para restricciones cero de todos los retardos de cada una de las variables, un contraste F para el máximo retardo, descomposiciones de la varianza de predicción y funciones impulso respuesta. 

Las descomposiciones de la varianza y las funciones impulso-respuesta se basan en la descomposición de Cholesky de la matriz de covarianzas contemporánea, y en este contexto el orden en el que se dan las variables (estocásticas) es importante. La primera variable de la lista se supone que es "más exógena" dentro del periodo. 

Menú gráfico: /Modelo/Serie temporal/Autorregresión vectorial (VAR)

Instrucción de guión: <@ref="var">

# vartest Tests "Diferencia de varianzas"

Calcula el estadístico <@itl="F"> para contrastar la hipótesis nula de que las varianzas poblacionales de las dos variables seleccionadas son iguales y muestra su valor p. 

Menú gráfico: /Datos/Diferencia de varianzas

Instrucción de guión: <@ref="vartest">

# wls Estimation "Mínimos cuadrados ponderados"

Supongamos que "wtvar" denota la variable seleccionada en la caja "Variable de ponderaciones". Se ejecuta una regresión por MCO en la que la variable dependiente es el producto de wtvar por la variable dependiente elegida, y las variables independientes también se multiplican por wtvar. Si wtvar es una variable ficticia, esto es equivalente a eliminar todas las observaciones en las que wtvar toma valor cero. 

Menú gráfico: /Modelo/Mínimos cuadrados ponderados

Instrucción de guión: <@ref="wls">
