headings 10
Tests 21
add
addto
adf
arch
chow
coeffsum
coint
coint2
cusum
hausman
leverage
lmtest
meantest
omit
omitfrom
reset
restrict
runs
testuhat
vartest
vif
Estimation 21
ar
arima
corc
equation
garch
hccm
hilu
hsk
lad
logistic
logit
mpols
nls
ols
probit
pwe
system
tobit
tsls
var
wls
Graphs 6
boxplot
gnuplot
graph
plot
rmplot
scatters
Dataset 15
data
delete
genr
info
setinfo
labels
nulldata
open
panel
rename
setobs
setmiss
smpl
store
varlist
Statistics 7
corr
corrgm
freq
pca
pergm
spearman
summary
Utilities 6
criteria
help
modeltab
pvalue
quit
shell
Transformations 6
diff
lags
ldiff
logs
rhodiff
square
Programming 9
else
end
endif
endloop
function
if
loop
run
set
Printing 5
eqnprint
outfile
print
printf
tabprint
Prediction 2
fcast
fcasterr

# add Tests

Argumento:  listavar 
Opciones:   --vcv (mostrar matriz de covarianzas)
            --quiet (no muetra las estimaciones del modelo aumentado)
Ejemplos:   add 5 7 9
            add xx yy zz

Debe utilizarse después de una instrucción de estimación. Las variables
de listavar se añaden al modelo anterior y se estima el nuevo modelo. Si se
añade más de una variable, se presenta el estadístico F para las
variables añadidas (sólo para el método MCO) junto con su valor-p. Un
valor-p inferior a 0.05 indica que los coeficientes son conjuntamente
significativos al nivel del 5 por ciento.

Si se usa la opción --quiet el resultado que se muestra es sólo el
estadístico para el contraste de significación conjunta de las variables
añadidas, en los demás casos se presentan también las estimaciones del
modelo aumentado. En este último caso, la opción --vcv hace que también
se presente la matriz de covarianzas de los coeficientes.

Menú gráfico: Ventana de Modelo, /Contrastes/Añadir variables

# addto Tests

Argumentos: ID_modelo listavar 
Opción:     --quiet (no mostrar las estimaciones del modelo aumentado)
Ejemplo:    addto 2 5 7 9

Funciona como la instrucción "add", salvo que Vd. especifica un modelo
previo (usando su identificador --ID-- de modelo, que se presenta al
principio de los resultados del modelo) que se toma como base para añadir
las variables. En el ejemplo de arriba se añaden las variables números 5,
7 y 9 al Modelo 2.

Menú gráfico: Ventana de Modelo, /Contrastes/añadir variables

# adf Tests

Argumentos: orden nombre_var 
Ejemplo:    adf 2 x1

Calcula los estadísticos para dos contrastes de Dickey-Fuller. En cada caso
la hipótesis nula es que la variable seleccionada presenta una raíz
unitaria. El primero es un estadístico t basado en el modelo

  (1 - L)x(t) = m + gx(t-1) + e(t)

La hipótesis nula es que g = 0. En el segundo contraste (aumentado) se
realiza la estimación de una regresión no retringida (cuyos regresores son
una constante, una tendencia temporal, el primer retardo de la variable y
"orden" retardos de la primera diferencia) y una versión restringida
(quitando la tendencia temporal y el primer retardo). El estadístico de
contraste es

  F(2, T-k) = [(ESSr - ESSu)/2] / [ESSu/(T - k)]

donde T es el tamaño de la muestra, k el número de parámetros del modelo
no restringido, y los subíndices u y r denotan el modelo no restringido y
el restringido respectivamente. Hay que señalar que los valores críticos
para estos estadísticos no son los habituales; se muestra el valor p cuando
es posible determinarlo.

Menú gráfico: /Variable/Contraste aumentado de Dickey-Fuller

# ar Estimation

Argumentos: retardos ; vardep varindeps 
Opción:     --vcv (mostrar la matriz de covarianzas)
Ejemplo:    ar 1 3 4 ; y 0 x1 x2 x3

Computa las estimaciones de los parámetros usando el procedimiento
iterativo generalizado de Cochrane-Orcutt (ver Sección 9.5 del libro de
Ramanathan). Las iteraciones terminan cuando dos sumas de cuadrados
residuales sucesivas no difieren en más del 0.005 por ciento o después de
20 iteraciones.

"retardos" es una lista de retardos de los residuos, que termina con un
punto y coma. En el ejemplo anterior el término de error se especifica como

  u(t) = rho(1)*u(t-1) + rho(3)*u(t-3) + rho(4)*u(t-4)

Menú gráfico: /Modelo/Serie temporal/Estimación autorregresiva

# arch Tests

Argumentos: orden vardep varindeps 
Ejemplo:    arch 4 y 0 x1 x2 x3

Contrasta la existencia de ARCH (Autoregressive Conditional
Heteroskedasticity -- Heterocedasticidad condicional autorregresiva) del
orden especificado, en el modelo. Si el estadístico de contraste LM tiene
un valor p inferior a 0.10, entonces también se realiza la estimación del
modelo ARCH. Si la predicción de la varianza de cualquier observación, en
la regresión auxiliar, no es positiva entonces se usa en su lugar el
correspondiente residuo al cuadrado. Después se realiza una estimación por
mínimos cuadrados ponderados sobre el modelo original.

Ver también "garch".

Menú gráfico: Ventana de Modelo, /Contrastes/ARCH

# arima Estimation

Argumentos: p q ; vardep [ varindeps ] 
Opciones:   --native (Usar rutina nativa plugin (por defecto))
            --x-12-arima (usar el programa X-12-ARIMA para realizar la estimación)
            --verbose (mostrar detalles de las iteraciones)
            --vcv (mostrar la matriz de covarianzas)
Ejemplos:   arma 1 2 ; y
            arma 2 2 ; y 0 x1 x2 --verbose

Si no se da una lista varindeps, estima un modelo ARMA (Autoregressive,
Moving Average) univariante. Los valores enteros p y q representan los
órdenes AR y MA respectivamente. Si se añade una lista varindeps, el
modelo pasa a ser un ARMAX.

Por defecto se usa la función "nativa" ARMA de gretl; en el caso de un
modelo ARMA univariante se puede usar X-12-ARIMA en su lugar (si está
instalado el paquete X-12-ARIMA para gretl).

La sopciones dadas arriba pueden combinarse, pero la matriz de covarianzas
no está disponible cuando se realiza la estimación mediante X-12-ARIMA.

El algoritmo ARMA nativo de gretl ha sido, en su mayor parte, creado por
Riccardo "Jack" Lucchetti. Utiliza un procedimiento de máxima verosimilitud
condicional, implementado por medio de la estimación por mínimos cuadrados
iterativos de la regresión del producto externo del gradiente (OPG, outer
product of the gradient regression). Ver el manual de gretl para entender la
lógica de este procedimiento. Los coeficientes AR (y los de cualquier
regresor adicional) se inicializan por medio de la estimación por MCO de un
AR, y los coeficientes MA se inicializan asignándoles valor cero.

El valor del coeficiente AIC para los modelos ARMA se calcula de acuerdo con
la definición usada en el programa X-12-ARIMA, es decir

  AIC = -2L + 2k

donde L es la log-verosimilitud y k es el número total de parámetros
estimados. La "frecuencia" que se presenta asociada a las raíces AR y MA es
el valor lambda que soluciona

  z = r * exp(i*2*pi*lambda)

donde z es la raíz en cuestión y r es su módulo.

Menú gráfico: /Variable/Modelo ARMA, /Modelo/Serie temporal/ARMAX
Otro acceso:  Menú emergente de la ventana principal (selección simple)

# boxplot Graphs

Argumento:  listavar 
Opción:     --notches (presenta el intervalo de confianza 90 por ciento para la mediana)

Estos gráficos (debidos a Tukey y Chambers) muestran la distribución de
una variable. La caja central recoge el 50 por ciento intermedio de los
datos, es decir, está acotada por el primero y tercer cuartiles. Las
"patillas" se extienden hasta los valores mínimo y máximo. Se dibuja una
línea a lo largo de la caja en el lugar de la mediana.

En el caso de gráficos de caja recortados, el recorte muestra los límites
de un intervalo de aproximadamente el 90 por ciento de confianza para la
mediana. Este intervalo se obtienen por el método bootstrap.

Después de cada variable especificada en la instrucción boxplot, se puede
añadir una expresión booleana entre paréntesis para limitar la muestra
para la variable en cuestión. Debe de insertarse un espacio entre el nombre
o número de la variable y la expresión. Supongamos que usted tiene valores
de los salarios de hombres y mujeres, y tiene una variable ficticia SEXO con
valor 1 para los hombres y 0 para las mujeres. En este caso usted puede
dibujar gráficos de caja comparativos usando la siguiente "listavar":

	salary (GENDER=1) salary (GENDER=0)

Algunos detalles de los gráficos de caja de gretl pueden controlarse por
medio de un fichero (de texto plano) llamado .boxplotrc. Para más detalles
sobre esto ver el manual de gretl.

Menú gráfico: /Datos/Gráficos/Gráficos de caja

# chow Tests

Argumento:  obs 
Ejemplos:   chow 25
            chow 1988:1

Primero debe ejecutarse una regresión por MCO. Crea una variable ficticia
que es igual a 1 desde el punto de corte especificado en obs hasta el final
de la muestra y 0 en el resto. También crea los términos de interacción
entre esta variable ficticia y las variables independientes originales. Se
ejecuta una regresión aumentada incluyendo estos términos y se calcula un
estadístico F, tomando la regresión aumentada como 'no restringida' y la
original como 'restringida'. Este estadístico es adecuado para contrastar
la hipótesis nula de que no hay cambio estructural en el punto de ruptura
indicado.

Menú gráfico: Ventana de Modelo, /Contrastes/Contraste de Chow

# coeffsum Tests

Argumento:  listavar 
Ejemplo:    coeffsum xt xt_1 xr_2

Debe ejecutarse después de una regresión. Calcula la suma de los
coeficientes de las variables de la lista listavar. Presenta la suma junto
con su desviación típica y el valor p para la hipótesis nula de que la
suma es cero.

Hay que señalar la diferencia entre esta instrucción y "omit", que
contrasta la hipótesis nula de que los coeficientes de un subconjunto de
variables independientes son todos iguales a cero zero.

Menú gráfico: Ventana de Modelo, /Contrastes/Suma de coeficientes

# coint Tests

Argumentos: orden vardep varindeps 
Ejemplo:    coint 4 y x1 x2

Contraste de cointegración de Engle-Granger. Esta instrucción realiza los
contrastes de Dickey-Fuller aumentados de la hipótesis nula de que cada una
de las variables de la lista tiene una raíz unitaria, usando el orden de
retardos dado. Se estima la ecuación cointegrante y se realiza un contraste
ADF sobre los residuos de esta regresión. También se presenta el
estadístico de Durbin-Watson para la regresión cointegrante. Hay que
señalar que ninguno de estos estadísticos de contraste puede compararse
con las tablas estadísticas usuales.

Menú gráfico: /Modelo/Serie temporal/Contrates de cointegración/Engle-Granger

# coint2 Tests

Argumentos: orden vardep varindeps 
Opción:     --verbose (mostrar los detalles de las regresiones auxiliares)
Ejemplos:   coint2 2 y x
            coint2 4 y x1 x2 --verbose

Realiza el contraste de la traza de Johansen para contrastar cointegración
entre las variables de la lista para el orden dado. Los valores críticos se
computan por medio de la aproximación gamma de J. Doornik (Doornik, 1998).
Para detalles sobre este contraste ver el libro de Hamilton, Time Series
Analysis (1994), Capítulo 20.

Se presenta aquí la siguiente tabla como guía para la interpretación de
los resultados ofrecidos por el contraste, para el caso de 3 variables. H0
denota la hipótesis nula, H1 la hipótesis alternativa y c el número de
relaciones cointegrantes.

            Rango   Contraste de la traza     Contraste Lmax 
                          H0     H1              H0     H1
             ---------------------------------------------------
              0          c = 0  c = 3          c = 0  c = 1
              1          c = 1  c = 3          c = 1  c = 2
              2          c = 2  c = 3          c = 2  c = 3
             ---------------------------------------------------

Menú gráfico: /Modelo/Serie temporal/Contraste de cointegración/Johansen

# corc Estimation

Argumentos: vardep varindeps 
Opción:     --vcv (mostrar la matriz de covarianzas)
Ejemplo:    corc 1 0 2 4 6 7

Computa estimaciones de los parámetros usando el procedimiento iterativo de
Cochrane-Orcutt (ver Sección 9.4 del libro de Ramanathan). Las iteraciones
finalizan cuando dos estimaciones sucesivas del coeficiente de
autocorrelación no difieren en más de 0,001 o después de 20 iteraciones.

Menú gráfico: /Modelo/Serie temporal/Cochrane-Orcutt

# corr Statistics

Argumento:  [ listavar ] 
Ejemplo:    corr y x1 x2 x3

Presenta los coeficientes de correlación por pares para las variables de
listavar, o para todas las variables del conjunto de datos, si no se
proporciona listavar.

Menú gráfico: /Datos/Matriz de correlación
Otro acceso:  Menú emergente de la ventana principal (cuando se hace 
      selección múltiple)

# corrgm Statistics

Argumentos: variable [ retardo_max ] 
Ejemplo:    corrgm x 12

Presenta los valores de la función de autocorrelación para la variable
especificada (por nombre o por número). Ver Ramanathan, Sección 11.7. Es
por tanto rho(u(t), u(t-s)) donde u_t es la t-ésima observación de la
variable u y s es el número de retardos.

También se presentan las autocorrelaciones parciales, siendo éstas los
coeficientes una vez descontado el efecto de los demás retardos
intervinientes. Esta instrucción también representa el correlograma y
muestra el estadístico Q de Ljung-Box para el contraste de la hipótesis
nula de que la serie es "ruido blanco". Este se distribuye asintóticamente
como una chi-cuadrado con grados de libertad igual al número de retardos
utilizados.

Si se especifica un valor para retardo_max entonces el tamaño del
correlograma se limita como máximo a ese número de retardos, en los demás
casos se determina automáticamente.

Menú gráfico: /Variable/Correlograma
Otro acceso:  Menú emergente de la ventana principal (cuando se hace 
      una selección simple)

# criteria Utilities

Argumentos: scr T k 
Ejemplo:    criteria 23.45 45 8

Calcula los estadísticos de selección de modelos (ver Ramanathan, Sección
4.3), dados scr (suma de cuadrados de los residuos), el número de
observaciones (T), y el número de coeficientes (k). T, k, y scr pueden ser
valores numéricos o nombres de variables definidas previamente.

# cusum Tests

Debe realizarse después de la estimación de un modelo por MCO. Realiza el
contraste CUSUM de estabilidad de los parámetros. Se obtiene una serie de
errores de predición (escalados) un período hacia adelante al ejecutar una
serie de regresiones: la primera regresión utiliza las primeras k
observaciones y se usa para generar una predicción de la variable
dependiente en la observación k + 1; la segunda utiliza las primeras k + 1
observaciones y genera una predicción para la observación k + 2, y así
sucesivamente (donde k es el número de parámetros en el modelo original).
Se muestra y se representa graicamente la suma acumulada de los errores de
predicción escalados. La hipótesis nula de estabilidad en los parámetros
se rechaza al nivel de significación del 5 por ciento si la suma acumulada
se sale de la banda de 95 por ciento de confianza.

También se presenta el estadístico t de Harvey-Collier para contrastar la
hipótesis nula de estabilidad de los parámetros. Para más detalles ver
Capítulo 7 del libro de Greene Econometric Analysis.

Menú gráfico: Ventana de Modelo, /Contrastes/CUSUM

# data Dataset

Argumento:  listavar 

Lee las variables de listavar desde una base de datos (de gretl o RATS 4.0),
que debe de haber sido abierta previamente usando la instrucción "open".
Además, se debe de establecer una frecuencia y un rango muestral para los
datos usando las instrucciones "setobs" y "smpl" antes de usar esta orden.
He aquí un ejemplo completo:

	open macrodat.rat
	setobs 4 1959:1
	smpl ; 1999:4
	data GDP_JP GDP_UK

Estas instrucciones abren una base de datos denominada macrodat.rat,
establecen un conjunto de datos trimestral que empieza en el primer
trimestre de 1959 y acaba en el cuarto trimestre de 1999, y después
importan las series denominadas GDP_JP y GDP_UK.

Si las series que van a ser leídas son de una frecuencia mayor que el
conjunto de datos actual, se debe especificar un método de compactado como
en las siguientes líneas:

	data (compact=average) 
	LHUR PUNEW

Los cuatro métodos de compactado disponibles son "average" (promediar: toma
la media de las observaciones de frecuencia mayor), "last" (última: usa la
última observación), "first" y "sum".

Menú gráfico: /Archivo/Revisar bases de datos

# delete Dataset

Argumento:  [ listavar ] 

Borra las variables de la lista (dadas mediante nombre o número) del
conjunto de datos. Debe usarse con precaución: no se pide confirmación, y
cualquier variable con número de ID mayor será renumerada.

Si con esta instrucción no se proporciona una lista listavar, se borra la
última variable (la de número ID mayor) del conjunto de datos.

Menú gráfico: Menú emergente de la ventana principal (selección simple)

# diff Transformations

Argumento:  listavar 

Se obtiene la primera diferencia de cada variable de la lista listavar y el
resultado se guarda en una nueva variable cuyo nombre tiene el prefijo d_.
Así "diff x y" crea las nuevas variables d_x = x(t) - x(t-1) y d_y = y(t) -
y(t-1).

Menú gráfico: /Datos/Añadir variables/Primeras diferencias

# else Programming

Ver "if".

# end Programming

Cierra un bloque de instrucciones de algunos tipos. Por ejemplo, end system
termina un sistema de ecuaciones (Ver "system").

# endif Programming

Ver "if".

# endloop Programming

Marca el final de un bucle de instrucciones. Ver "loop".

# eqnprint Printing

Argumento:  [ -f nombre_de_fichero ] 
Opción:     --complete (Crea un documento completo)

Debe ejecutarse después de la estimación de un modelo. Presenta el modelo
estimado en formato de ecuación LaTeX. Si se especifica un nombre de
fichero usando la opción -f la salida va a ese fichero, en caso contrario
va a una fichero cuyo nombre tiene la forma equation_N.tex, donde N es el
número de modelos estimados hasta el momento en la sesión actual. Ver
también "tabprint".

Si se aplica la opción --complete, el fichero LaTeX es un documento
completo, listo para ser procesado; en caso contrario deberá incluirse
dentro de un documento previamente preparado.

Menú gráfico: Ventana de Modelo, /LaTeX

# equation Estimation

Argumentos: vardep varindeps 
Ejemplo:    equation y x1 x2 x3 const

Sirve pare especificar una ecuación dentro de un sistema de ecuaciones (ver
"system"). La sintaxis para especificar una ecuación dentro de un sistema
SUR (Ecuaciones de regresión aparentemente no relacinadas) es la misma que,
por ejemplo, la de MCO (ver "ols"). Para una ecuación dentro de un sistema
de Mínimos Cuadrados en Tres Etapas se puede (a) dar la especificación de
una ecuación de tipo MCO y proporcionar una lista común de instrumentos
usando la opción "instr" (ver de nuevo "system"), o (b) usar la misma
sintaxis de definición de ecuaciones que para "tsls".

# fcast Prediction

Argumentos: [ obs_inic obs_fin ] var_ajustada 
Ejemplos:   fcast 1997:1 2001:4 f1
            fcast fit2

Debe ejecutarse después de una instrucción de estimación. Se generan
predicciones para el dominio muestral especificado (o el dominio muestral
mayor posible si no se han proporcionado obs_inic y obs_fin) y los valores
se guardan como var_ajustada, que luego puede mostrarse o representarse
gráficamente. Las variables del lado derecho son las del modelo original.
No se pueden sustituir por otras variables. Si se especifica un proceso de
error autorregresivo (para "hilu", "corc", y "ar") la predicción se hace
condicionada un paso adelante y tiene en cuenta el proceso del error.

Menú gráfico: Ventana de Modelo, /Datos del Modelo/Predicciones con desviaciones típicas

# fcasterr Prediction

Argumentos: obs_inic obs_fin 

Después de estimar un modelo por medio de MCO usted puede usar esta
instrucción para mostrar los valores ajustados para el rango de
observaciones determinado, las desviaciones típicas de estos valores
ajustados y los intervalos de confianza del 95 por ciento.

Las desviaciones típicas se calculan de la forma descrita en el Capítulo 6
del libro de Wooldridge Introductory Econometrics. Estas tienen en cuenta
dos fuentes de variabilidad: la asociada al valor esperado de la variable
dependiente condicionado a los valores dados de las variables
independientes, y la varianza de los residuos de la regresión.

Menú gráfico: Ventana de Modelo, /Datos del modelo/Predicciones con desviaciones típicas

# freq Statistics

Argumento:  var 

Presenta la distribución de frecuencias de la variable var (que se da por
nombre o número); también muestra los resultados del contraste de
normalidad de Doornik-Hansen. En modo interactivo, se presenta un gráfico
de la distribución.

Menú gráfico: /Variable/Distribución de frecuencias

# function Programming

Define una función.

# garch Estimation

Argumentos: p q ; vardep [ varindeps ] 
Opciones:   --robust (Desviaciones típicas robustas)
            --verbose (muestra los detalles de las iteraciones)
            --vcv (presenta la matriz de covarianzas)
Ejemplos:   garch 1 1 ; y
            garch 1 1 ; y 0 x1 x2 --robust

Estima un modelo GARCH (GARCH = Generalized Autoregressive Conditional
Heteroskedasticity), o un modelo univariante o, si se especifican varindeps,
un modelo que incluye las variables exógenas dadas. Los valoires enteros p
y q representan los órdenes de retardos en la ecuación de la varianza
condicional.

  h(t) = sum(i=1 to q) a(i)*u(t-i) + sum(j=1 to p) b(j)*h(t-j)

El algoritmo GARCH de gretl es básicamente el de Fiorentini, Calzolari y
Panattoni (1996), y se usa con el amable permiso del profesor Fiorentini.

Con esta instrucción están disponibles varias variantes de las
estimaciones de la matriz de covarianzas de los coeficientes. Por defecto se
usa el Hessiano a no ser que se indique la opción --robust, en cuyo caso se
utiliza la matriz de covarianzas QML (White). Se pueden especificar otras
posibilidades (p.ej. la matriz de información, o el estimador
Bollerslev-Wooldridge) usando la instrucción "set".

Menú gráfico: /Modelo/Serie temporal/GARCH

# genr Dataset

Argumentos: nueva_var = fórmula 

Crea variables nuevas, normalmente como transformaciones de variables ya
existentes. Ver también "diff", "logs", "lags", "ldiff" y "square" como
atajos.

Los operadores aritméticos soportados son, en orden de precedencia: ^
(exponenciación); *, / y % (módulo o resto); + y -.

Los operadores Booleanos disponibles son (de nuevo, en orden de
precedencia): ! (negación), && (Y lógico), || (O lógico), >, <, =, >=
(mayor o igual que), <= (menor o igual que) y != (distinto que). Se pueden
usar operadores Booleanos para construir variables ficticias: por ejemplo (x
> 10) devuelve 1 si x > 10, y 0 en otro caso.

Las funciones se clasifican en:

  Funcione matemáticas estándar: abs, cos, exp, int (parte entera), ln
  (logaritmo natural: log es un sinónimo), sin, sqrt.

  Funciones estadísticas: max (valor máximo de una serie), min (mínimo),
  mean (media aritmética), median, var (varianza) sd (desviación típica),
  sst (suma de desviaciones desde la media, al cuadrado), sum, cov
  (covarianza), corr (coeficiente de correlación), pvalue, sort, cum
  (acumulación, o suma secuencial), resample (remuestrear una serie con
  reemplazamiento, con el propósito de hacer bootstrap), hpfilt (Filtro de
  Hodrick-Prescott: esta función devuelve el "componente cíclico" de la
  serie).

  Funciones de series temporales: diff (primera diferencia), ldiff
  (diferencia logarítmica, o primera diferencia del logaritmo natural).
  Para generar retardos de una variable x, se usa la sintaxis "x(-N)", donde
  N representa la longitud deseada del retardo; para generar adelantos, se
  usa "x(+N)".

  Funciones de conjunto de datos: misszero (reemplaza los códigos de
  observación ausente de una serie dada con ceros); zeromiss (la operación
  inversa a misszero); nobs (devuelve el número de observaciones válidas
  de una serie de datos determinada), missing (para cada observación,
  devuelve 1 si el argumento tiene una observación ausente, y 0 en caso
  contrario); ok (el opuesto de missing).

  Números pseudo-aleatorios: uniform, normal.

Todas las funciones de arriba excepto cov, corr, pvalue, uniform y normal
toman como único argumento o el nombre de una variable (nótese que, en una
fórmula "genr", no es posible referirse a las variables por su número de
ID) o una expresión que se evalúa en una variable (p.ej. ln((x1+x2)/2)).
cov y corr requieren dos argumentos, y devuelven respectivamente la
covarianza y el coeficiente de correlación entre sus argumentos. La
función pvalue toma los mismos argumentos que la instrucción "pvalue",
pero en este contexto deben introducirse comas entre los argumentos. Esta
función devuelve un valor p a una cola y, en el caso de las distribuciones
normal y t, es para la "cola corta". Con la normal, por ejemplo, tanto 1,96
como -1,96 darán un resultado de aproximadamente 0,025.

uniform() y normal(), que no toman arguamentos, devuelven series de números
pseudo-aleatorios extraídos de la distribución uniforme (0-1) y normal
estándar respectivamente (ver también la instrucción "set", opción
seed). La series de datos uniformes se generan utilizando el Mersenne
Twister; para series normales se usa el método de Box y Muller (1958),
tomando la entrada del Mersenne Twister.

Además de los operadores y funciones ya mencionados, hay algunos usos
especiales de "genr":

  "genr time" crea una variable de tendencia temporal (1,2,3,...) llamada
  "time". "genr index" hace lo mismo, excepto que ahora la variable se
  denomina index.

  "genr dummy" crea variables ficticias hasta la periodicidad de los datos.
  P.ej. en el caso de datos trimestrales (periodicidad 4), el programa crea
  dummy_1 = 1 para el primer trimestre y 0 en los demás trimestres, dummy_2
  = 1 para el segundo trimestre y 0 en los demás, y así sucesivamente.

  "genr paneldum" crea un conjunto de variables ficticias especiales para
  ser usadas con un conjunto de datos de panel -- ver "panel".

Usando "genr" se pueden recuperar los valores de algunas variables internas
que se definen al ejecutar una regresión, de la siguiente foprma:

  $ess: suma de cuadrados de los residuos

  $rsq: R-cuadrado no corregido

  $T: número de observaciones usadas

  $df: grados de libertad

  $trsq: TR-cuadrado (el tamaño muestral por el R-cuadrado)

  $sigma: desviación típica de los residuos

  $aic: Criterio de información de Akaike

  $bic: Criterio de información de Schwarz

  $lnl: logaritmo de la verosimilitud (donde es aplicable)

  coeff(var): coeficiente estimado para la variable var

  stderr(var): desviación típica estimada para la variable var

  rho(i): coeficiente autorregresivo de i-ésimo orden de los residuos

  vcv(x1,x2): covarianza entre los coeficientes para las variables nombradas
  x1 y x2

Nota: En el programa en línea de instrucciones, las instrucciones "genr"
que recuperan datos relativos a un modelo siempre hacen referencia al
último modelo estimado. Esto también es cierto para el programa en modo
GUI, si uno usa "genr" en la "consola de gretl" o introduce una fórmula
usando la opción "Definir nueva variable" del menú de Variable en la
ventana principal. Sin embargo, con el GUI, usted tiene la posibilidad de
recuperar datos de cualquier modelo que actualmente se esté mostrando en
una ventana (sea o no el modelo más reciente). Usted puede hacer esto bajo
el menú "Datos del Modelo" de la ventana del modelo.

Las series internas uhat e yhat contienen, respectivamente, los residuos y
los valores ajustados de la última regresión.

También están disponibles dos variables "internas" relacionadas con el
conjunto de datos actual: $nobs contiene el número de observaciones del
rango muestral actual (que puede ser o no igual a $T, el número de
observaciones usadas al estimar el último modelo), y $pd contiene la
frecuencia o periodicidad de los datos (p.ej 4 para datos trimestrales).

La variable t sirve como índice de las observaciones. Por ejemplo genr dum
= (t=15) generará una variable ficticia que toma valor 1 para la
observación 15, y 0 en las demás. La variable obs es similar pero más
flexible: usted puede usarla para extraer observaciones particulares por
fecha o nombre. Por ejemplo, genr d = (obs>1986:4) o genr d = (obs="CA"). La
última forma presupone que las observaciones tienen etiquetas; la etiqueta
debe ponerse entre comillas.

Pueden utilizarse valores escalares de una serie en el contexto de una
fórmula genr, usando la sintaxis nombre_var[obs]. El valor obs puede darse
por número o fecha. Ejemplos: x[5], CPI[1996:01]. Para datos diarios data,
se debe de usar la forma YYYY:MM:DD, p.ej. ibm[1970:01:23].

Se puede modificar una observación individual de una serie por medio de
genr. Para hacerlo, hay que adjuntar al nombre de la variable en el lado
izquierdo de la fórmula, entre corchetes, un número de observación
válido o una fecha. Por ejemplo, genr x[3] = 30 o genr x[1950:04] = 303.7.

Aquí hay un par de sugerencias sobre variable ficticias:

  Supongamos que x está codificada con los valores 1, 2, o 3 y usted quiere
  tres variables ficticias, d1 = 1 si x = 1, 0 en otro caso, d2 = 1 si x =
  2, y así sucesivamente. Para crearlas, use las instrucciones:

	    genr d1 = (x=1)
	    genr d2 = (x=2)
	    genr d3 = (x=3)

  Para crear z = max(x,y) do

	    genr d = x>y
	    genr z = (x*d)+(y*(1-d))

  Fórmula              Comentario
  -------               -------
  y = x1^3              x1 al cubo
  y = ln((x1+x2)/x3)    
  z = x>y               z(t) = 1 si x(t) > y(t), en otro caso 0
  y = x(-2)             x retardada 2 periodos
  y = x(2)              x adelantada 2 periodos
  y = diff(x)           y(t) = x(t) - x(t-1)
  y = ldiff(x)          y(t) = log x(t) - log x(t-1), la tasa de crecimiento 
                        instantánea de x
  y = sort(x)           ordena x en orden creciente y lo guarda en y
  y = -sort(-x)         ordena x en orden decreciente
  y = int(x)            trunca x y guarda su valor entero como y
  y = abs(x)            guarda los valores absolutos de x
  y = sum(x)            suma los valores de x excluyendo los valores ausentes, 
                        con entradas -999
  y = cum(x)            acumulación: y(t) = la suma desde s=1 hasta s=t de 
                        x(s) 
  aa = $ess             hace aa igual a la suma de cuadrados de los residuos 
                        de la última regresión
  x = coeff(sqft)       guarda el coeficiente estimado de la variable sqft de 
                        la última regresión
  rho4 = rho(4)         guarda el coeficiente autorregresivo de 4º orden del 
                        último modelo (supone un modelo ar)
  cvx1x2 = vcv(x1, x2)  guarda la covarianza de los coeficientes estimados de 
                        las variables x1 y x2 del último modelo
  foo = uniform()       variable pseudo-aleatoria uniforme en el rango 0-1
  bar = 3 * normal()    variable pseudo-aleatoria normal, mu = 0, sigma = 3
  samp = !missing(x)    = 1 para las observaciones en las que no hay valores 
                        ausentes de x.

Menú gráfico: /Variable/Definir nueva variable
Otro acceso:  Menú emergente de la ventana principal

# gnuplot Graphs

Argumentos: yvars xvar [ dumvar ] 
Opciones:   --with-lines (usar líneas, no puntos)
            --with-impulses (usar líneas verticales)
            --suppress-fitted (no mostrar el ajuste mínimo-cuadrático)
            --dummy (ver abajo)
Ejemplos:   gnuplot y1 y2 x
            gnuplot x time --with-lines
            gnuplot wages educ gender --dummy

Sin la opción --dummy, las variables yvars se representan contra xvar. Con
--dummy, yvar se representa contra xvar con los puntos pintados de
diferentes colores dependiendo de si el valor de dumvar es 1 o 0.

La variable time se comporta de manera especial: si no existe, entonces se
generará automáticamente.

En modo interactivo los resultados se muestran inmediatamente. En modo batch
se escribe un fichero de instrucciones gnuplot con un nombre que sigue el
modelo gpttmpN.plt, empezando con N = 01. Los gráficos actuales se pueden
generar más tarde usando gnuplot (bajo MS Windows, wgnuplot).

Hay una nueva opción disponible en esta instrucción: después de la
especificación de las variables a representar y las opciones (si se elige
alguna), usted puede añadir instrucciones literales de gnuplot para
controlar la apariencia del gráfico (por ejemplo, poner el título del
gráfico y/o el rango de los ejes). Estas instrucciones deberían incluírse
entre paréntesis y cada instrucción gnuplot debe terminar con un punto y
coma. Se puede usar una barra invertida (/) para continuar un conjunto de
instrucciones gnuplot sobre más de una línea. He aquí un ejemplo de la
sintaxis:

{ set title 'Mi título'; set yrange [0:1000]; }

Menú gráfico: /Datos/Gráficos
Otro acceso:  Menúe emergente de la ventana principal, botón de gráfico de
      la barra de herramientas

# graph Graphs

Argumentos: yvars xvar 
Opción:     --tall (usar 40 filas)

Gráficos ASCII. Las variables yvars (que pueden determinarse por nombre o
número) se representan con respecto a xvar usando símbolos ASCII. La
opción --tall producirá un gráfico con 40 filas y 60 columnas. Sin ella,
el gráfico será de 20 por 60 (para salida por pantalla). Ver también
"gnuplot".

# hausman Tests

Este contraste sólo está disponible después de haber estimado un modelo
mediante la instrucción "ols" (ver también "panel" y "setobs"). Contrasta
el modelo simple combinado contra sus alternativas principales, el modelo de
efectos fijos y el modelo de efectos aleatorios.

El modelo de efectos fijos añade una variable ficticia para todas menos una
de las unidades de sección cruzada, permitiendo al intercepto de la
regresión variar a través de estas unidades. Se presenta un estadístico F
para el contraste de significación conjunta de estas variables ficticias.
El modelo de efectos aleatorios descompone la varianza residual en dos
partes, una parte específica de las unidades de sección cruzada y la otra
específica de cada observación particular. (Este estimador sólo puede
computarse si el número de unidades de sección cruzada es mayor que el
número de parámetros a estimar.) El estadístico LM de Breusch-Pagan sirve
para contrastar la hipótesis nula (de que el estimador MCO combinado es el
adecuado) contra la alternativa de efectos aleatorios.

El modelo de MCO combinados puede ser rechazado contra ambas alternativas,
el modelo de efectos fijos y el de efectos aleatorios. Si el error
específico de unidad o grupo está incorrelacionado con las variables
independientes, el estimador de efectos aleatorios es más eficiente que el
estimador de efectos fijos; en caso contrario el estimador de efectos
aleatorios sería inconsistente y sería preferible el estimador de efectos
fijos. La hipótesis nula para el contraste de Hausman es que el error
específico de grupo no está tan correlacionado (así que es preferible el
modelo de efectos aleatorios). Un valor p bajo para este contraste es un
síntoma en contra del modelo de efectos aleatorios y a favor del modelo de
efectos fijos.

Menú gráfico: Ventana de Modelo, /Contrastes/Diagnósticos de panel

# hccm Estimation

Argumentos: vardep varindeps 
Opción:     --vcv (presenta la matriz de covarianzas)

Matriz de covarianzas consistente ante heterocedasticidad: esta instrucción
ejecuta una regresión en la que los coeficientes se estiman mediante un
procedimiento MCO estándar, pero las desviaciones típicas de los
coeficientes estimados se calculan de una manera que es robusta ante
heterocedasticidad, en concreto usando el procedimiento "jackknife" de
MacKinnon-White.

Menú gráfico: /Modelo/HCCM

# help Utilities

Proporciona una lista de las instrucciones disponibles. "help" instrucción
describe la instrucción (p.ej. "help smpl"). Vd. puede escribir "man" en
lugar de "help" si lo desea.

Menú gráfico: /Ayuda

# hilu Estimation

Argumentos: vardep varindeps 
Opción:     --vcv (presenta la matriz de covarianzas)

Calcula estimaciones de los parámetros del modelo especificado usando el
procedimiento de búsqueda de Hildreth-Lu search procedure (refinado
mediante el procedimiento CORC). Este procedimiento está diseñado para
corregir las estimaciones teniendo en cuenta la correlación serial del
término de error. La suma de cuadrados de los residuos del modelo
transformado se representa con respecto al valor de rho desde -0.99 hasta
0.99.

Menú gráfico: /Modelo/Serie temporal/Hildreth-Lu

# hsk Estimation

Argumentos: vardep varindeps 
Opción:     --vcv (presenta la matriz de covarianzas)

Se calcula una regresión por MCO y se guardan los residuos. El logaritmo
del cuadrado de los residuos entonces pasa a ser la variable dependiente en
una regresión auxiliar, en cuyo lado derecho están las variables
independientes originales más sus cuadrados. Los valores ajustados en la
regresión auxiliar se usan entonces para construir una serie de
ponderaciones y el modelo original se reestima utilizando mínimos cuadrados
ponderados. El resultado final se presenta en un informe.

La serie de ponderaciones se forma como 1/sqrt(exp(y*)), donde y^* denota
los valores ajustados mediante la regresión auxiliar.

Menú gráfico: /Modelo/Corregido de Heterocedasticidad

# if Programming

Control de flujo para la ejecución de instrucciones. La sintaxis es:

	if condición
	   instrucciones1
	else
	   instrucciones2
	endif
            
condición debe ser una expresión Booleana, para su sintaxis ver "genr". El
bloque "else" es opcional; los bloques if ... endif pueden estar anidados.

# info Dataset

Presenta cualquier información suplemnentaria que se haya guardado con el
fichero de datos actual.

Menú gráfico: /Datos/Leer información
Otro acceso:  Ventanas de navegación de datos

# setinfo Dataset

Argumentos: nombre_var -d descripción -n nombre a mostrar 
Ejemplo:    label x1 -d "Descripción de x1" -n "Nombre en los gráficos"

Establece la etiqueta descriptiva de la variable determinada (si se da la
opción -d, seguida de una cadena de caracteres entre comillas) y/o el
"nombre a mostrar" para la variable (si se da la opción -n, seguida de una
cadena de caracteres entre comillas). Si una variable tiene un "nombre a
mostrar", se usará éste al generar los gráficos.

Menú gráfico: /Variable/Editar atributos
Otro acceso:  Menú emergente de la ventana principal

# labels Dataset

Presenta las etiquetas informativas de cualquier variable que haya sido
generada usando la instrucción "genr", y cualquier variable añadida al
conjunto de datos por medio del GUI.

# lad Estimation

Argumentos: vardep varindeps 

Calcula una regresión que minimiza la suma de las desviaciones absolutas de
los valores observados de la variable dependiente con respecto a los
ajustados. La estimaciones de los coeficientes se derivan usando el
algoritmo simplex de Barrodale-Roberts; se muestra un aviso si la solución
no es única. Las desviaciones típicas se derivan utilizando el
procedimiento bootstrap con 500 extracciones.

Menú gráfico: /Modelo/Mínima devsiación absoluta

# lags Transformations

Argumento:  listavar 

Crea variables nuevas que son valores retardados de cada una de las
variables de listavar. El número de variables retardadas es igual a la
periodicidad. Por ejemplo, si la periodicidad es 4 (trimestral), la
instrucción "lags x y" crea x_1 = x(t-1), x_2 = x(t-2), x_3 = x(t-3) y x_4
= x(t-4). Lo mismo para y. Estas variables deben ser referenciadas de manera
exacta, es decir, con el carácter de subrayado.

Menú gráfico: /Datos/Añadir variables/retardos de las variables seleccionadas

# ldiff Transformations

Argumento:  listavar 

Calcula la primera diferencia del logaritmo natural de cada variable de
listavar y guarda el resultado en una nueva variable con el prefijo ld_.
Así "ldiff x y" crea las nuevas variables ld_x = ln[x(t)] - ln[x(t-1)] y
ld_y = ln[y(t)] - ln[y(t-1)].

Menú gráfico: /Datos/Añadir variables/diferencias de logaritmos de las variables seleccionadas

# leverage Tests

Opción:     --save (guardar las variables)

Debe ejecutarse inmediatamente después de una instrucción "MCO". Calcula
el apalancamiento (h, que debe estar entre 0 y 1) para cada punto de datos
de la muestra sobre la que se estimó el último modelo. Presenta el residuo
(u) de cada observación junto a su apalancamiento y una medida de su
influencia sobre las estimaciones, u*h/(1-h). Los "puntos palanca" para los
cuales el valor de h es mayor que 2k/n (donde k es el número de parámetros
estimados y n es el tamaño muestral) se marcan con un asterisco. Para más
detalles sobre los conceptos de apalancamiento e influencia ver Davidson and
MacKinnon (1993, Capítulo 2).

También se presentan los valores DFFITS: estos son los "residuos
studentizados" (residuos predichos divididos por sus desviaciones típicas)
multiplicados por sqrt[h/(1 - h)]. Para más detalles sobre residuos
studentizados y DFFITS ver el libro de G. S. Maddala, Introduction to
Econometrics, capítulo 12; y también Belsley, Kuh y Welsch (1980). En
resumen, un "residuo predicho" es la diferencia entre el valor observado de
la variable dependiente en la observación t y el valor ajustado para la
observación t obtenido de una regresión en la que se omite esa
observación (o se añade una variable ficticia con valor 1 sólo para la
observación t); el residuo studentizado se obtiene dividiendo el residuo
predicho por su desviación típica.

Si con esta instrucción se da la opción --save, entonces los valores del
apalancamiento, influencia y DFFITS se añaden al conjunto de datos actual.

Menú gráfico: Ventana de Modelo, /Contrastes/observaciones influyentes

# lmtest Tests

Opciones:   --logs (no linealidad, logaritmos)
            --autocorr (correlación serial)
            --squares (no linealidad, cuadrados)
            --white (heterocedasticidad (Contraste de White))

Debe ejecutarse justo después de una instrucción "mco". Realiza alguna
combinación de lo siguiente: contrastes de Multiplicador de Lagrange de no
linealidad (logaritmos y cuadrados), contraste de heterocedasticidad de
White, y el contraste LMF de correlación serial hasta el orden de la
periodicidad (ver Kiviet, 1986). También se presentan los correspondientes
coeficientes de la regresión auxiliar. Ver Ramanathan, Capítulos 7, 8, y 9
para más detalles. En el,caso del contrastes de White, sólo se usan los
cuadrados de las variables independientes y no sus productos cruzados. En el
caso del contraste de autocorrelación, si el valor p del estadístico LMF
es menor que 0,05 (y el modelo no se había estimado originariamente con
desviaciones típicas robustas) entonces se calculan y se presentan las
desviaciones típicas robustas ante correlación serial. Para detalles sobre
el cálculo de estas desviaciones típicas ver Wooldridge (2002, Capítulo
12).

Menú gráfico: Ventan de Modelo, /Contrastes

# logistic Estimation

Argumentos: vardep varindeps [ ymax=valor ] 
Opción:     --vcv (mostrar la matriz de covarianzas)
Ejemplos:   logistic y const x
            logistic y const x ymax=50

Regresión logística: desarrolla una regresión MCO utilizando la
transformación logística de la variable dependiente,

  log(y/(ymax - y))

La variable dependiente debe ser estrictamente positiva. Si es una fracción
decimal, entre 0 y 1, por defecto se usa un valor y^* (el máximo
asintótico de la variable dependiente) of 1. Si la variable dependiente es
un porcentaje, entre 0 y 100, por defecto y^* es 100. Si Vd. desea
establecer otro valor máximo utilice el parámetro opcional ymax=valor
después de la lista de regresores. El valor proporcionado debe ser mayor
que todos los valores observados de la variable dependiente.

Los valores ajustados y los residuos de la regresión se transforman
automáticamente usando

  y = ymax / (1 + exp(-x))

donde x representa o un valor ajustado o un residuo de la regresión MCO
usando la variable dependiente transformada. Los valores que se presentan
son así comparables con los valores originales de la variable dependiente.

Nótese que si la variable dependiente es binaria, en lugar de esto se
debería usar la instrucción "logit".

Menú gráfico: /Modelo/Logístico

# logit Estimation

Argumentos: vardep varindeps 
Opción:     --vcv (mostrar la matriz de covarianzas)

Regresión binomial logit. La variable dependiente debería ser una variable
binaria. Se obtienen las estimaciones máximo-verosímiles de los
coeficientes de las variables varindeps por medio del método EM
(Expectation-Maximization method, ver Ruud, 2000, Capítulo 27). Como el
modelo no es lineal las pendientes dependen de los valores de las variables
independientes: las poendientes que se presentan se han evaluado en la media
de dichas variables. La hipótesis de que todos los coeficientes, aparte de
la constante, son cero se contrasta mediante el estadístico chi-cuadrado.

Si Vd. desea utilizar logit para el análisis de proporciones (donde la
variable dependiente, para cada observación, es la proporción de casos que
tienen una determinada característica, en lugar de un 1 o un 0 indicando si
la característica está presente o no) no debería usar la instrucción
"logit", sino mejor debería construir la variable logit (p.ej. genr lgt_p =
log(p/(1 - p))) y usarla como variable dependiente en una regresión MCO.
Ver Ramanathan, Capítulo 12.

Menú gráfico: /Modelo/Logit

# logs Transformations

Argumento:  listavar 

Se obtiene el logaritmo natural de cada una de las variables de listavar y
el resultado se guarda en una nueva variable con el prefijo l_ que es "ele"
y carácter de subrayadoe. "logs x y" crea las nuevas variables l_x = ln(x)
y l_y = ln(y).

Menú gráfico: /Datos/Añadir variables/logaritmos de las variables seleccionadas

# loop Programming

Argumento:  control 
Opción:     --progressive (permite formas especiales de ciertas instrucciones)
Ejemplos:   loop 1000
            loop 1000 --progressive
            loop while essdiff > .00001
            loop for i=1991..2000
            loop for (r=-.99; r<=.99; r+=.01)

El parámetro "control" debe tomar una de las cuatro formas posibles, tal y
como se muestra en los ejemplos: un número de veces entero a repetir las
instrucciones del bucle; "while" más una condición numérica; o "for" más
un rango de valores para la variable índice interna i; o "for" más tres
expresiones entre paréntesis, separadas por puntos y comas. En la última
forma, la expresión del lado izquierdo inicializa una variable, la del
medio establece una condición para que continúen las iteraciones, y la de
la derecha determina un incremento o decremento a aplicar al comienzo de la
segunda y siguientes iteraciones. (Esta es una forma restringida de la
instrucción for del lenguaje de programación C.)

Esta instrucción abre un modo de ejecución especial en el cual el programa
acepta instrucciones a ejecutar repetidamente. Dentro de un bucle sólo se
pueden utilizar ciertas instrucciones: "genr", "ols", "print", "printf",
"pvalue", "sim", "smpl", "store", "summary", "if", "else" y "endif". Se sale
del modo de introducción de instrucciones de bucle con "endloop": en este
punto se ejecutan todas las instrucciones que están en la cola del bucle.

Ver el manual de gretl para más detalles y ejemplos. El efecto de la
opción --progressive (que está diseñada para su uso en simulaciones de
Monte Carlo) se explica allí.

# meantest Tests

Argumentos: var1 var2 
Opción:     --unequal-vars (suponer que las varianzas son diferentes)

Calcula el estadístico t para la hipótesis nula de que las medias
poblacionales de las variables var1 y var2 son iguales, y presenta su valor
p. Por defecto se calcula el estadístico bajo el supuesto de que las
varianzas de las dos variables son iguales; con la opción --unequal-vars se
suponen varianzas distintas. Esto implicará una diferencia en el
estadístico de contraste sólo si hay un número diferente de valores no
ausentes para las dos variables.

Menú gráfico: /Datos/Diferencia de medias

# modeltab Utilities

Argumentos: add  o show  o free 

Sirve para manipular la "tabla de modelos" de gretl. Ver el manual de gretl
para más detalles. Las sub-instrucciones tienen los isguientes efectos:
"add" añade el último modelo estimado a la tabla de modelos, si es
posible; "show" presenta la tabla de modelos en una ventana; y "free" vacía
la tabla.

Menú gráfico: Ventana de sesión, icono de Tabla de modelos

# mpols Estimation

Argumentos: vardep varindeps 

Computa las estimaciones MCO para el modelo especificado, usando aritmética
de punto flotante con precisión múltiple. Esta instrucción sólo está
disponible si gretl se compila con soporte para la biblioteca Gnu de
Precisión Múltiple (GMP).

Para estimar un ajuste polinomial usando aritmética de precisión múltiple
para generar las potencias necesarias de la variable independiente use por
ejmplo la forma "mpols y 0 x ; 2 3 4". Esto realiza una regresión de y
sobre x, x cuadrado, x al cubo y x a la cuarta potencia. Es decir, los
números a la derecha del punto y coma (que deben ser enteros positivos)
determinan las potencias de x a utilizar. Si se especifica más de una
variable independiente, ha de considerarse que la última antes del punto y
coma es la variable que va a ser elevada a varias potencias.

Menú gráfico: /Modelo/MCO de alta precisión

# nls Estimation

Argumentos: función derivadas 
Opción:     --vcv (mostrar la matriz de covarianzas)

Desarrolla la estimación por Mínimos Cuadrados No Lineales (NLS)
utilizando una versión modificada del algoritmo de Levenberg-Marquardt. El
usuario debe suministrar la especificación de una función. Los parámetros
de esta función deben ser declarados antes y hay que asignarles unos
valores iniciales (usando la instrucción "genr") antes de la estimación.
Opcionalmente, el usuario puede especoficar las derivadas de la función de
regresión con respectyo a cada uno de los parámetros; si nbo se
proporcionan las derivadas analíticas se computa una aproximación
numérica al Jacobiano.

Es más sencillo mostrar lo que se necesita con un ejemplo. Lo siguiente es
un lote de instrucciones completo para estimar la función de consumo no
lineal definida en el libro de William Greene Econometric Analysis
(Capítulo 11 de la 4ª edición inglesa, o Capítulo 9 de la 5ª). Los
números a la izquierda de las líneas son para referencia y no son parte de
las instrucciones. Hay que señalar que la opción --vcv, para presentar la
matriz de covarianzas de las estimaciones de los parámetros se escribe
junto a la instrucción final, end nls.

	1   open greene11_3.gdt
	2   ols C 0 Y
	3   genr alfa = coeff(0)
	4   genr beta = coeff(Y)
	5   genr gamma = 1.0
	6   nls C = alfa + beta * Y^gamma
	7   deriv alfa = 1
	8   deriv beta = Y^gamma
	9   deriv gamma = beta * Y^gamma * log(Y)
	10  end nls --vcv

Muchas veces es conveniente inicializar los parámetros haciendo referencia
a un modelo lineal relacionado con el actual; esto se realiza aquí en las
líneas 2 a 5. A los parámetros alfa, beta y gamma se les podría asignar
cualesquiera valores iniciales (no necesariamente basados en un modelo
estimado por MCO), aunque la convergencia del procedimiento de MC no
lineales no está garantizada para un punto de inicio arbitrario.

Las instrucciones de MC no lineales actuales ocupan las líneas 6 a 10. En
la línea 6 se invoica la instrucción "nls": se especifica una variable
dependiente seguida de un signo igual y después la especificación de una
función. La sintaxis para la expresión de la derecha es la misma que para
la instrucción "genr". Las tres siguientes líneas determinan las derivadas
de la función de regresión con respecto a cada uno de los parámetros.
Cada línea comienza con la palabra "deriv", da el nombre de un parámetro,
un signo igual y una expresión por la que se calcula la derivada (de nuevo,
la sintaxis aquí es la misma que para "genr"). Estas líneas "deriv" son
opcionales, pero es conveniente proporcionarlas, si es posible. La línea
10, "end nls", completa la instrucción e invoca la estimación.

Para más detalles sobre la estimación por MC. no lineales ver el manual de
gretl.

Menú gráfico: /Modelo/Mínimos cuadrados no lineales

# nulldata Dataset

Argumento:  largura de la serie 
Ejemplo:    nulldata 500

Forma un conjunto de datos "vacío", que contiene sólo una constante y una
variable índice, con periodicidad 1 y el número de observaciones
especificado. Esto puede usarse para hacer simulaciones: algunas de las
instrucciones "genr" (p.ej. "genr uniform()", "genr normal()") generan,
desde cero, datos ficticios para rellenar el conjunto de datos. Esta
instrucción puede ser útil también junto a la instrucción "loop". Ver
también la opción "seed" de la instrucción "set".

Menú gráfico: /Archivo/Crear conjunto de datos

# ols Estimation

Argumentos: vardep varindeps 
Opciones:   --vcv (mostrar la matriz de covarianzas)
            --robust (desviaciones típicas robustas)
            --quiet (suprime la presentación de los resusltados)
            --no-df-corr (suprime la corrección de grados de libertad)
            --print-final (ver más abajo)
Ejemplos:   ols 1 0 2 4 6 7
            ols y 0 x1 x2 x3 --vcv
            ols y 0 x1 x2 x3 --quiet

Calcula las estimaciones de mínimos cuadrados ordinarios (MCO) con vardep
como variable dependiente y siendo varindeps la lista de variables
independientes. Las variables se pueden determinar por nombre o por su
número; hay que usar el número cero para el término constante.

Además de las estimaciones de los coeficientes y de las desviaciones
típicas, el programa también presenta los valores p de los estadísticos t
(a dos colas) y F. Un valor p inferior a 0,01 indica significatividad al
nivel del 1 por ciento y se denota mediante ***. ** indica un nivel de
significatividad entre el 1 y 5 por ciento y * indica significatividad entre
el 5 y 10 por ciento. También se presentan algunos estadísticos de
selección de modelos (se describen en Ramanathan, Sección 4.3).

Si se da la opción --no-df-corr, no se aplica la corrección habitual de
grados de libertad al calcular la estimación de la varianza de las
perturbaciones (y así tampoco en la estimación de las desviaciones
típicas de los estimadores de los parámetros).

La opción --print-final es aplicable sólo en el contexto de un bucle (ver
"loop"). Se encarga de que las regresiones se ejecuten "silenciosamente" en
todas las iteraciones excepto la iteración final del bucle. Ver el manual
de gretl para más detalles.

Algunas variables que se definen internamente al ejecutar la instrucción
"ols", pueden recuperarse mediante la instrucción "genr", teniendo en
cuenta que "genr" debe invocarse immediatamente después de la instrucción
"ols".

Mediante la instrucción "set" puede ajustarse la fórmula específica que
se usa para generar las desviaciones típicas robustas (cuando se da la
opción --robust).

Menú gráfico: /Modelo/Mínimos cuadrados ordinarios
Otro acceso:  Botón beta con sombrero en la barra de herramientas

# omit Tests

Argumento:  listavar 
Opciones:   --vcv (mostrar la matriz de covarianzas)
            --quiet (no mostrar las estimaciones del modelo reducido)
Ejemplo:    omit 5 7 9

Esta instrucción debe invocarse justo después de una instrucción de
estimación. Las variables seleccionadas se omiten del modelo anterior y se
estima el nuevo modelo. Si se omite más de una variable, se presentará el
estadístico F de Wald para las variables omitidas y su valor p (sólo para
el método MCO). Un valor p inferior a 0,05 indica que los coeficientes son
conjuntamente significativos al nivel de significación del 5 por ciento.

Si se da la opción --quiet el resultado que se muestra es sólo el
contraste de significación conjunta de las variables omitidas, en caso
contrario, también se presentan las estimaciones del modelo reducido. En
este último caso, la opción --vcv hace que también se muestre la matriz
de covarianzas de los coeficientes estimados.

Menú gráfico: ventana de Modelo, /Contrastes/omitir variables

# omitfrom Tests

Argumentos: ID_modelo listavar 
Opción:     --quiet (no mostrar las estimaciones del modelo reducido)
Ejemplo:    omitfrom 2 5 7 9

Funciona igual que "omit", excepto que aquí Vd. tiene que especificar un
modelo anterior (usando su número ID identificador de modelo, que se
presenta al principio de los resultados del modelo) que se toma como base
para omitir las variables. En el ejemplo de arriba se omiten del Modelo 2
las variables con números 5, 7 y 9.

Menú gráfico: Ventana de Modelo, /Contrastes/omitir variables

# open Dataset

Argumento:  fichero_de_datos 

Abre un fichero de datos. Si ya hay un fichero de datos abierto, se
reemplaza por el que ahora se abre. El programa tratará de detectar el
formato del fichero de datos (formato nativo de gretl, texto plano, CSV o
BOX1).

Esta instrucción también se puede usar para abrir una base de datos (de
fromato gretl o RATS 4.0). En este caso, después debería ejecutarse la
instrucción "data" para extraer de ella series determinadas.

Menú gráfico: /Archivo/Abrir datos
Otro acceso:  Arrastrar un fichero de datos sobre gretl (en MS Windows o Gnome)

# outfile Printing

Argumentos: nombre_de_fichero opción 
Opciones:   --append (añadir a un fichero)
            --close (cerrar el fichero)
            --write (sobreescribir el fichero)
Ejemplos:   outfile --write regres.txt
            outfile --close

Envía los resultados a nombre_de_fichero, hasta nuevo aviso. Use la opción
--append para añadir los resultados a un fichero ya existente o --write
para empezar un nuevo fichero (o sobreescribir uno existente). De esta forma
sólo se puede abrir un fichero en cada momento.

La opción --close se usa para cerrar un fichero de resultados que estuviera
abierto previamente. Los resultados se enviarán entonces a la salida por
defecto.

En el primer ejemplo de arriba, se abre el fichero regres.txt para
escritura, y en el segundo se cierra. Esta secuencia tendría sentido sólo
si se ejecutaran algunas instrucciones antes de --close. Por ejemplo si se
invocara una instrucción "ols", sus resultados irían a regres.txt en lugar
de a la pantalla.

# panel Dataset

Opciones:   --cross-section (secciones cruzadas apiladas)
            --time-series (series temporale apiladas)

Indica que el conjunto de datos actual debe ser interpretado como un panel
(combinando secciones cruzadas y series temporales). Por defecto, o usando
la opción --time-series, se considera que el conjunto de datos está en la
forma de series temporales apiladas (los sucesivos bloques de datos
contienen series temporales para cada unidad de sección cruzada). Con la
opción --cross-section, elconjunto de datos se lee como secciones cruzadas
apiladas (los sucesivos bloques de datos contienen secciones cruzadas para
cada periodo temporale). Ver también "setobs".

Menú gráfico: /Muestra/Interpretar como panel

# pca Statistics

Argumento:  listavar 
Opciones:   --save-all (guardar todos los componentes)
            --save (guardar los componentes más importantes)

Análisis de componentes principales. Presenta los valores propios de la
matriz de correlación de las variables de la lista listavar y la
proporción de la varianza conjunta explicada por cada uno de los
componentes. También presenta los vectores propios correspondientes (o
"ponderaciones de los componentes").

Si se da la opción --save, los componentes con valorres propios mayores que
1,0 se guardan como variables en el conjunto de datos, con nombres PC1, PC2
y así sucesivamente. Estas variables artificiales se forman como la suma de
(ponderaciones de los componentes) por (Xi estandarizadas), donde Xi denota
la i-ésima variable de la lista listavar.

Si se da la opción --save-all, se guardan todos los componentes de la
manera que se ha descrito arriba.

Menú gráfico: Menú emergente de la ventana principal (selección múltiple)

# pergm Statistics

Argumento:  nombre_var 
Opción:     --bartlett (usar la venatana de retardos de Bartlett)

Calcula y presenta (y si no se ejecuta en modo batch, representa
gráficamente) el espectro de la variable especificada. Sin la opción
--bartlett se ofrece el periodograma muestral; con dicha opción, se utiliza
una ventana de retardos de Bartlett de longitud 2*sqrt(T) (donde T es el
tamaño muestral) para estimar el espectro (ver Capítulo 18 del libro de
Greene Econometric Analysis). Cuando se presenta el periodograma muestral,
también se proporciona un contraste t sobre integración fraccional de la
serie ("memoria larga"): la hipótesis nula es que el orden de integración
es cero.

Menú gráfico: /Variable/Espectro
Otro acceso:  Menú emergente de la ventana principal (selección simple)

# plot Graphs

Argumento:  listavar 
Opción:     --one-scale (forzar una sóla escala)

Representa gráficamente los valores de las variables especificadas, para el
rango muestral que esté actualmente activo, utilizando símbolos ASCII.
Cada línea indica una observación y los valores se representan
horizontalmente. Por defecto, las variables se cambian a la escala más
adecuada. Ver también "gnuplot".

# print Printing

Argumentos: listavar  o cadena_literal 
Opciones:   --byobs (por observaciones)
            --ten (usar 10 dígitos significativos)
Ejemplos:   print x1 x2 --byobs
            print "Esto es una cadena de caracteres"

Si se da una lista listavar, presenta los valores de las variables
especificadas; si no se da ninguna lista, muestra los valores de todas las
variables del conjunto de datos actual. Si se da la opción --byobs, los
datos se presentan 'por observación', en caso contrario, se presentan 'por
variable'. Si se da la opción --ten, los datos se presentan por variable
mostrando 10 dígitos significativos.

Si el argumento de la instrucción "print" es una cadena literal (que debe
comenzar con comillas dobles, "), la cadena se presenta tal y como está.
Ver también "printf".

Menú gráfico: /Datos/Mostrar valores

# printf Printing

Argumentos: format args 

Presenta valores escalares bajo el control de una cadena de caracteres
(proporcionando así un subconjunto de las utilidades de la instrucción
printf() del lenguaje de programación C). Los formatos que se reconocen son
%g y %f, en cada caso con los diferentes modificadores disponibles en C.
Ejemplos: el formato %.10g presenta un valor con 10 dígitos significativos;
%12.6f presenta una valor con 6 decimales y con una anchura de 12
caracteres.

La propia cadena de caracteres que indica el formato debe de estar incluida
entre comillas. Los valores a mostrar deben seguir el formato de la cadena,
separados por comas. Estos valores deberían de tener la forma de (a)
nombres de variables del conjunto de datos, o (b) expresiones que sean
válidas para la instrucción "genr". En el siguiente ejemplo se muestran
los valores de dos variables más el de una expresión calculada:

	ols 1 0 2 3
	genr b = coeff(2)
	genr dt_b = stderr(2)
	printf "b = %.8g, desviación típica %.8g, t = %.4f\n", b, dt_b, b/dt_b

La largura máxima de una cadena de formato es de 127 caracteres. Se
reconocen las secuencias de escape \n (nueva línea), \t (tabulador), \v
(tabulador vertical) y \\ (backslash literal). Para presentar un signo de
porcentaje literal use %%.

# probit Estimation

Argumentos: vardep varindeps 
Opción:     --vcv (mostrar la matriz de covarianzas)

La variable dependiente debería ser una variable binaria. Se obtienen las
estimaciones máximo-verosímiles de los coeficientes de las variables
varindeps por medio de mínimos cuadrados iterativos (el método EM o
Expectation-Maximization). Como el modelo no es lineal las pendientes
dependen de los valores de las variables independientes: las pendientes que
se presentan están evaluadas en las medias de dichas variables. El
estadístico chi-cuadrado sirve para contrastar la hipótesis nula de que
todos los coeficientes, excepto la constante, son cero.

El análisis Probit de proporciones no está aún implementado en gretl.

Menú gráfico: /Modelo/Probit

# pvalue Utilities

Argumentos: dist [ params ] xval 
Ejemplos:   pvalue z zscore
            pvalue t 25 3.0
            pvalue X 3 5.6
            pvalue F 4 58 fval
            pvalue G xbar varx x

Calcula el área a la derecha de xval en la distribución especificada (z
para Gaussiana, t para la t de Student, X para la chi-cuadrado, F para la F
y G para la distribución gamma). Para las ditribuciones t y chi-cuadrado
deben proporcionarse los grados de libertad; para la F hay que proporcionar
los grados de libertad del numerador y del denominador; y para la
distribución gamma se necesitan la media y la varianza.

Menú gráfico: /Utilidades/buscador de valores-p

# pwe Estimation

Argumentos: vardep varindeps 
Opción:     --vcv (mostrar la matriz de covarianzas)
Ejemplo:    pwe 1 0 2 4 6 7

Calcula estimaciones de los parámetros utilizando el procedimiento de
Prais-Winsten, un método de Mínimos cuadrados generalizados factibles que
está diseñado para tener en cuenta la autocorrelación de primer orden del
término de error. El procedimiento es iterativo, igual que "corc"; la
diferencia es que mientras el método de Cochrane-Orcutt desperdicia la
primera observación, el de Prais-Winsten la utiliza. Para más detalles,
ver por ejemplo el Capítulo 13 del libro de Greene Econometric Analysis
(2000).

Menú gráfico: /Modelo/Serie temporal/Prais-Winsten

# quit Utilities

Sale del programa, dándole a Vd. la opción de guardar las órdenes y
resultados de su sesión al salir.

Menú gráfico: /Archivo/Salir

# rename Dataset

Argumentos: var_número nuevo_nombre 

Cambia el nombre de la variable con número de identificación var_número a
nuevo_nombre. El número var_número debe estar entre el 1 y el número de
variables en el conjunto de datos. El nuevo nombre debe tener como máximo 8
caracteres, debe empezar con una letra y debe estar formado sólo por letras
dígitos y el carácter de subrayado (_). character.

Menú gráfico: /Variable/Editar atributos
Otro acceso:  Menú emergente de la ventana principal (selección simple)

# reset Tests

Debe ejecutarse después de la estimación de un modelo vía MCO. Realiza el
contraste de especificación de modelos (no linealidad) RESET de Ramsey.
Para ello añade a la regresión el cuadrado y el cubo de los valores
ajustados y calcula el estadístico F para la hipótesis nula de que los
parámetros de las dos variables añadidas son cero.

Menú gráfico: Ventana de Modelo, /Contrastes/Contraste RESET de Ramsey

# restrict Tests

Evalúa un conjunto de restricciones sobre los parámetros del último
modelo estimado. En modo "guión de instrucciones", el conjunto de
restricciones debe incluirse entre "restrict" y "end restrict", pero en la
caja de diálogo sobre restricciones (en el entorno gráfico) pueden
omitirse esas líneas.

Cada restricción del conjunto debe expresarse como una ecuación, con una
combinación lineal de los parámetros a la izquierda y un valor numérico a
la derecha del signo igual. Los parámetros se referencian en la forma bN,
donde N representa la posición en la lista de regresores, comenzando en
cero. Por ejemplo, b1 denota al segundo parámetro de la regresión.

El segundo y siguientes términos bN de una ecuación pueden ir
premultiplicados por un número, utilizando * para representar la
multiplicación, por ejemplo 3.5*b4.

He aquí un ejemplo de un conjunto de restricciones:

	restrict
	 b1 = 0
	 b2 - b3 = 0
	 b4 + 2*b5 = 1
	end restrict

Las restricciones se evalúan mediante un contraste F de Wald, usando la
matriz de covarianzas de los coeficientes del modelo en cuestión.

Menú gráfico: Ventana de Modelo, /Contrastes/Restricciones lineales

# rhodiff Transformations

Argumentos: listarho ; listavar 
Ejemplos:   rhodiff .65 ; 2 3 4
            rhodiff r1 r2 ; x1 x2 x3

Crea las versiones rho-diferenciadas de las variables (dadas por nombre o
número) de la lista listavar y las añade al conjunto de datos, usando el
sufijo # para las nuevas variables. Dada la variable v1 una variable de
listavar, y las entradas r1 y r2 de listarho, se crea

	v1# = v1 - r1*v1(-1) - r2*v1(-2)

Las entradas de listarho pueden darse como valores numéricos o como nombres
de variables definidas previamente.

# rmplot Graphs

Argumento:  nombre_var 

Gráfico Rango-media plot: esta instrucción crea un sencillo gráfico para
ayudar a decidir si una serie temporal, y(t), tiene varianza constante o no.
Se toma la muestra completa t=1,...,T y se divide en pequeñas submuestras
de tamaño arbitrario k. La primera submuestra se forma con y(1),...,y(k),
la segunda con y(k+1), ..., y(2k), y así sucesivamente. Para cada submuetra
se calcula la media muestral y el rango (= el máximo menos el mínimo), y
se forma un gráfico con las medias en el eje horizontal y los rangos en el
vertical. Así, cada submuestra está representada por un punto en este
plano. Si la varianza de la serie es constante, se espera que los rangos de
las submuestras sean independientes de las medias; si vemos que los puntos
se distribuyen a lo largo de una línea de creciente, esto sugiere que la
varianza de la serie aumenta con la media; si los puntos siguen una línea
decreciente esto indica que la varianza disminuye a medida que la media
aumenta.

Además del gráfico, gretl presenta las medias y los rangos de cada
submuestra, el coeficiente para la pendiente en una regresión MCO de los
rangos sobre las medias y el valor p para el contraste de la hipótesis nula
de que dicha pendiente es cero. Si el coeficiente de la pendiente es
significativo, al nivel de significación del 10 por ciento, se muestra
también en el gráfico la recta de regresión estimada de los rangos sobre
las medias.

Menú gráfico: /Variable/Gráfico rango-media

# run Programming

Argumento:  inputfile 

Ejecuta las instrucciones de inputfile y devuelve el control a la línea de
instrucciones.

Menú gráfico: Icono de 'ejecutar' en la ventana de guión de instrucciones

# runs Tests

Argumento:  nombre_var 

Realiza el contraste "rachas" (no paramétrico) de aleatoriedad de la
variable especificada. Si Vd. desea contrastar la aleatoriedad de las
desviaciones respecto a la mediana, para una variable denominada x1 con
mediana distinta de cero, puede hacer lo siguiente:

	genr signx1 = x1 - median(x1)
	runs signx1

Menú gráfico: /Variable/Contraste de rachas

# scatters Graphs

Argumentos: yvar ; xlistavar  o ylistavar ; xvar 
Ejemplos:   scatters 1 ; 2 3 4 5
            scatters 1 2 3 4 5 6 ; 7

Dibuja gráficos bivarianes, de la variable yvar con respecto a todas las
variables de la lista xlistavar, o de todas las variables de la lista
ylistavar con respecto a xvar. El primer ejemplo de arriba sitúa la
variable 1 en el eje y y realiza cuatro gráficos, el primero con la
variable 2 en el eje x, el segundo con la variable 3 en el eje x, y así
sucesivamente. En el segundo ejemplo se representa cada una de las variables
1,..., 6 con respecto a la variable 7 en el eje x. Revisar un conjunto de
gráficos como estos puede ser útil al realizar análisis exploratorio de
datos. El número máximo de gráficos es seis; cualquier otra variable
extra en la lista será ignorada.

Menú gráfico: /Datos/Gráficos bivariantes múltiples

# set Programming

Argumentos: variable valor 

Establece los valores de varios parámetros del programa. Los valores dados
permanecen vigentes durante todo el desarrollo de la sesión de gretl, a no
ser que se cambien con una nueva llamada a la instrucción "set". Los
parámetros que pueden determinarse de esta forma se enumeran abajo. Hay que
señalar que los parámetros de hac_lag y hc_version se usan cuando se elige
la opción --robust en la instrucción "ols".

  echo: off u on (por defecto). Suprime o activa el eco de las instrucciones
  en la salida de gretl.

  qr: on u off (por defecto). Utiliza QR en lugar de la descomposición de
  Cholesky al calcular las estimaciones por MCO.

  hac_lag: nw1 (por defecto) o nw2, o un entero. Establece el retardo
  máximo, p, usado al calcular desviaciones típicas HAC
  (Heteroskedasticity and Autocorrelation Consistent) usando el método de
  Newey-West para datos de series temporales. nw1 y nw2 representan dos
  variantes para el cálculo automático basadas en el tamaño muestral, T:
  para nw1, p = 0.75 * T^(1/3), y para nw2, p = 4 * (T/100)^(2/9).

  hc_version: 0 (por defecto), 1, 2 o 3. Determina la variante usada al
  calcular desviaciones típicas consistentes ante heterocedasticidad con
  datos de sección cruzada. Las opciones corresponden a los valores HC0,
  HC1, HC2 y HC3 estudiadas por Davidson y MacKinnon en Econometric Theory
  and Methods, capítulo 5. HC0 produce lo que normalmente se llaman
  "desviaciones típicas de White".

  force_hc: off (por defecto) u on. Por defecto, con datos de series
  temporales y cuando se da la opción --robust en "ols", se usa el
  estimador HAC. Si se establece force_hc en "on", esto fuerza al cálculo
  de la Matriz de Covarianzas Consistente ante Heterocedasticidad regular
  (que no tiene en cuenta la autocorrelación).

  garch_vcv: unset, hessian, im (matriz de información) , op (matriz de
  productos externos), qml (estimador QML), bw (Bollerslev-Wooldridge).
  Especifica la variante que se usará para estimar la matriz de covarianzas
  de los coeficientes para modelos GARCH. Si se da unset (por defecto)
  entonces se usa el Hessiano a no ser que se dé también la opción
  "robust" para la instrucción garch, en cuyo caso se usa QML.

  hp_lambda: auto (por defecto), o un valor numérico. Determina el
  parámetro de suavizado para el filtro de Hodrick-Prescott (ver la
  función hpfilt bajo la instrucción "genr"). El valor por defecto es usar
  100 veces el cuadrado de la periodicidad, lo cual da 100 para datos
  anuales, 1600 para trimestrales, y así sucesivamente.

# setobs Dataset

Argumentos: periodicidad obs_inicial 
Ejemplos:   setobs 4 1990:1
            setobs 12 1978:03
            setobs 20 1:01

Fuerza al programa a interpretar el conjunto de datos actual como serie
temporal o como panel, cuando los datos se han leído como series simples
sin fechas. La periodicidad debe ser un entero; obs_inicial es una cadena de
caracteres que representa la fecha o identificación de panel de la primera
observación. Ver también "panel".

Menú gráfico: /Muestra/Establecer frecuencia, observación inicial

# setmiss Dataset

Argumentos: valor [ listavar ] 
Ejemplos:   setmiss -1
            setmiss 100 x2

Hace que el programa interprete algún valor numérico concreto (el primer
parámetro de la instrucción) como código para valor "ausente", en el caso
de datos importados. Si este valor es el único parámetro, como en el
primer ejemplo de arriba, la interpretación se aplicará a todas las series
del conjunto de datos. Si después de "valor" sigue una lista de variables,
por nombre o número, la interpretación se restringe a las variables
especificadas. Así, en el segundo ejemplo el valor 100 se interpreta como
código para "valor ausente", pero sólo para la variable x2.

Menú gráfico: /Muestra/Establecer código de 'valor perdido'

# shell Utilities

Argumento:  instrucción_de_shell 
Ejemplos:   ! ls -al
            ! notepad

Un "!" al comienzo de una línea de instrucciones se interpreta como un
escape al shell del usuario. Así se pueden ejecutar instrucciones de shell
arbitrarias desde dentro de gretl.

# smpl Dataset

Variantes:  smpl startobs endobs
            smpl +i -j
            smpl dumvar --dummy
            smpl condition --restrict
            smpl --no-missing [ varlist ]
            smpl n --random
            smpl full
Ejemplos:   smpl 3 10
            smpl 1960:2 1982:4
            smpl +1 -1
            smpl x > 3000 --restrict
            smpl y > 3000 --restrict --replace
            smpl 100 --random

Cambia el rango muestral. El nuevo rango puede definirse de varias formas.
En la primera forma alternativa (y los dos primeros ejemplos) de arriba
startobs y endobs deben ser coherentes con la periodicidad de los datos.
Cualquiera de ellos se puede sustituir por un punto y coma para dejar el
valor sin cambios. En la segunda forma los enteros i y j (que pueden ser
postivos o negativos y deberían tener signo) se toman como offsets respecto
al rango muestral existente. En la tercera forma, dummyvar debe ser una
variable indicador con valores 0 o 1 en cada observación; la muestra se
restringirá a las observaciones en las que el valor es 1. La cuarta forma,
usando --restrict restringe la muestra a las observaciones que satisfacen la
condición Booleana (que se especifica de acuerdo a la sintaxis de la
instrucción "genr").

Con la opción --no-missing, si se especifica listavar, las observaciones se
seleccionan con la condición de que todas las variables de listavar tengan
valores válidos en esa observación; cuando no se especifica listavar, las
observaciones se seleccionan con la condición de que todas las variables
tengan valores validos (no ausentes).

Con la opción --random, se extrae del conjunto de datos el número de
observaciones especificado, de manera aleatoria. Si se desea poder replicar
esta selección más adelante, se debe establecer primero una semilla para
el generador de números aleatorios (Véase la instrucción "set").

La forma final, smpl full, restablece el rango muestral completo.

Nótese que las restricciones sobre la muestra son, por defecto,
acumulativas: la base para cualquier orden smpl es la muestra actual. Si Vd.
desea que la instrucción actúe reemplazando cualquier restricción previa,
puede añadir la opción --replace al final de la instrucción.

Puede usarse la variable interna obs junto con la opción --restrict de smpl
para excluir observaciones particulares de la muestra. Por ejemplo,

	smpl obs!=4 --restrict

quitará sólo la cuarta observación. Si los datos se identifican mediante
etiquetas,

	smpl obs!="USA" --restrict

quitará la observación con etiqueta "USA".

Con respecto a las formas --dummy, --restrict y --no-missing de smpl, hay
que señalar que cualquier información "estructural" en el fichero de datos
(referente a la estructura de series temporales o de panel de los datos) se
pierde al ejecutar esta orden. Es posible reimponer la estructura inicial
con la instrucción "setobs".

Véase el manual de gretl para más detalles.

Menú gráfico: /Muestra

# spearman Statistics

Argumentos: x y 
Opción:     --verbose (mostrar los datos ordenados)

Presenta el coeficiente de rango de correlación para las dos variables x e
y. No es necesario antes ordenar y hacer el ranking de las variables, la
función se encarga de ello.

El ranking automático es de mayor a menor (es decir, el mayor valor de los
datos obtiene rango 1). Si Vd. necesita invertir este ranking cree una nueva
variable que sea el negativo de la primera original. Por ejemplo:

	genr altx = -x
	spearman altx y

Menú gráfico: /Modelo/Correlación por Rangos

# square Transformations

Argumento:  listavar 
Opción:     --cross (además de los cuadrados genera los productos cruzados)

Genera variables nuevas que son los cuadrados de las variables de la lista
listavar (más los productos cruzados, si se da la opción --cross). Por
ejemplo, "square x y" generará sq_x = x cuadrado, sq_y = y cuadrado and
(optionalmente) x_y = x por y. Si una determinada variable es una variable
ficticia, no será elevada al cuadrado, ya que se obtendría lo mismo.

Menú gráfico: /Datos/Añadir variables/cuadrados delas variables

# store Dataset

Argumentos: fichero_de_datos [ listavar ] 
Opciones:   --csv (usar formato CSV)
            --gnu-octave (usar formato GNU Octave)
            --gnu-R (usar formato GNU R)
            --traditional (usar el formato tradicional de ESL)
            --gzipped (aplicar la compresión mediante gzip)
            --dat (usar el formato ASCII de PcGive)

Guarda el conjunto de datos completo o, si se suministra una lista listavar,
el subconjunto especificado de variables del conjunto de datos actual, al
fichero dado en fichero_de_datos.

Por defecto los datos se guardan en formato gretl "nativo", pero las
distintas opciones permiten guardarlos en varios formatos alternativos. Los
datos CSV (Comma-Separated Values) pueden ser leídos por programas de hoja
de cálculos y también pueden manipularse mediante un editor de textos. Los
formatos de Octave, R y PcGive están diseñados para el uso con estos
respectivos programas. La compresión mediante Gzip puede ser útil para
grandes conjuntos de datos. Ver el manual de gretl para detalles sobre los
distintos formatos.

Hay que señalar que las variables escalares no serán guardadas
automáticamente: si Vd. desea guardar escalares debe escribirlas
explícitamente en la lista listavar.

Menú gráfico: /Archivo/Guardar datos; /Archivo/Exportar datos

# summary Statistics

Argumento:  [ listavar ] 

Presenta los estadísticos principales de las variables de la lista
listavar, o si se omite listavar, de todas las variables del conjunto de
datos. Se muestran la media, desviación típica, coeficiente de variación
(= dt/media), mediana, mínimo, máximo, coeficiente de asimetría y exceso
de curtosis.

Menú gráfico: /Datos/Estadísticos principales
Otro acceso:  Menú emergente de la ventana principal

# system Estimation

Argumentos: type savevars 
Ejemplos:   system type=sur
            system type=sur save=resids
            system type=3sls save=resids,fitted

Da comienzo a un sistema de ecuaciones. Actualmente se soportan dos tipos de
sistemas: "sur" (Seemingly Unrelated Regressions, ecuaciones de regresión
aparentemente no relacionadas) y "3sls" (Three-Stage Least Squares, mínimos
cuadrados en tres etapas). En el campor opcional "save=" se puede
especificar si guardar los residuos ("resids") y/o los valores ajustados
("fitted"). El sistemna debe contener al menos dos ecuaciones, que se
especifican por medio de la instrucción "equation", y debe terminarse con
la línea "end system".

En el contexto de un sistema de Mínimos Cuadrados en Tres Etapas, Vd. puede
proporcionar una lista de instrumentos (mediante nombre o número). Esta
debería ir en una linea por separado dentro del bloque "system", precedido
de la palabra "instr".

# tabprint Printing

Argumento:  [ -f fichero ] 
Opción:     --complete (Crea un documento completo)

Debe ejecutarse después de la estimación de un modelo. Presenta el modelo
estimado en forma de una tabla de LaTeX. Si se especifica un nombre de
fichero por medio de la opción -f el resultado va a ese fichero, en caso
contrario va a un fichero con un nombre de la forma model_N.tex, donde N es
el número de modelos estimados hasta ese momento en la sesión actual de
gretl. Ver también "eqnprint".

Si se da la opción --complete el fichero LaTeX será un documento completo,
listo para ser procesado; en caso contrario debería ser incluido en un
documento ya formado.

Menú gráfico: Ventana de Modelo, /LaTeX

# testuhat Tests

Debe ejecutarse después de una instrucción de estimación. Da la
distribución de frecuencias de los residuos del modelo y un contraste
chi-cuadrado de normalidad, basado en el procedimiento propuesto por Doornik
y Hansen (1984).

Menú gráfico: Ventana de Modelo, /Contrastes/normalidad de los residuos

# tobit Estimation

Argumentos: vardep varindeps 
Opciones:   --vcv (mostrar la matriz de covarianzas)
            --verbose (mostrar los detalles de las iteraciones)

Estima un modelo Tobit. Este modelo puede ser adecuado cuando la variable
dependiente es una variable "truncada". Por ejemplo, se observan valores
positivos y cero de las compras de bienes duraderos por parte de las
familias, pero no valores negativos. Sin embargo las decisiones sobre tales
compras pueden considerarse como resultados de una disposición subyacente a
la compra que puede ser negativa en algunos casos. Para detalles ver el
libro de Greene Econometric Analysis, Capítulo 20.

Menú gráfico: /Modelo/Tobit

# tsls Estimation

Argumentos: vardep varindeps ; instrumentos 
Opciones:   --vcv (mostrar la matriz de covarianzas)
            --robust (desviaciones típicas robustas)
Ejemplo:    tsls y1 0 y2 y3 x1 x2 ; 0 x1 x2 x3 x4 x5 x6

Calcula las estimaciones por mínimos cuadrados en dos etapas (MC2E o VI):
vardep es la variable dependiente, varindeps es la lista de variables
independientes (incluyendo las variables endógenas del lado derecho) en la
ecuación estructural para la cual se necesitan las estimaciones MC2E; y
instrumentos es la lista combinada de variables exógenas y predeterminadas
en todas las ecuaciones. Si la lista de instrumentos no es al menos tan
larga como varindeps, el modelo no está identificado.

En el ejemplo de arriba, las ys son las variables endógenas y las xs son
las exógenas y predeterminadas.

Menú gráfico: /Modelo/Mínimos cuadrados en dos etapas

# var Estimation

Argumentos: orden listavar ; detlist 
Opción:     --quiet (no mostrar respuestas al impulso etc.)
Ejemplo:    var 4 x1 x2 x3 ; const time

Construye y estima (usando MCO) un modelo autorregresivo vectorial (VAR). El
primer argumento especifica el orden de retardos, despues va la estructura
de la primera ecuación. No hay que incluir retardos entre los elementos de
listavar -- se añadirán automáticamente. El punto y coma separa las
variables estocásticas, para las que se incluirán un número orden de
retardos, de los terminos determinísticos de detlist, tales como la
constante, la tendencia temporal y las variables ficticias estacionales.

De hecho, gretl es capaz de reconocer las variables determinísticas más
comunes (constante, tendencia temporal, variables ficticias que no tengan
más valores que el 0 y el 1), así que estas no es necesario situarlas
después del punto y coma. Variables determinísticas más complejas (p.ej.
una tendencia temporal interactuando con una variable ficticia) deben
incluirse después del punto y coma.

Se ejecuta una regresión por separado para cada variable de listavar. La
salida de cada ecuación presenta los contrastes F de restricciones cero de
todos los retardos de cada variable; un contraste F de significatividad del
retardo máximo; descomposiciones de la varianza de predicción y las
funciones impulso-respuesta.

Las descomposiciones de la varianza y las funciones impulso-respuesta se
basan en la descomposición de Cholesky de la matriz de covarianzas
contemporánea, y en este contexto el orden en el que se dan las variables
(estocásticas) es importante. La primera variable de la lista se supone que
es "más exógena" dentro del periodo.

Menú gráfico: /Modelo/Serie temporal/Autorregresión vectorial (VAR)

# varlist Dataset

Presenta un listado de las variables actualmente disponibles. "list" y "ls"
son sinónimos.

# vartest Tests

Argumentos: var1 var2 

Calcula el estadístico F para contrastar la hipótesis nula de que las
varianzas poblacionales de las variables var1 y var2 son iguales, y muestra
su valor p.

Menú gráfico: /Datos/Diferencia de varianzas

# vif Tests

Debe ejecutarse inmediatamente después de la estimación de un modelo que
incluya al menos dos variables independientes. Calcula y muestra los
factores de inflación de varianza (VIFs) de los regresores. El factor de
inflación de varianza (VIF) del regresor j se define como

  1/(1 - Rj^2

donde R_j es el coeficiente de correlación múltiple entre el regresor j y
los demás regresores. El factor tiene un valor mínimo de 1,0 cuando la
variable en cuestión es ortogonal a las demás variables independientes.
Neter, Wasserman, y Kutner (1990) sugieren inspeccionar el mayor VIF como
una medida de diagnóstico para la multicolinealidad; un valor mayor que 10
se suele considerar que indica un grado de multicolinealidad problemático.

Menú gráfico: Model window, /Tests/collinearity

# wls Estimation

Argumentos: wtvar vardep varindeps 
Opción:     --vcv (mostrar la matriz de covarianzas)

Calcula las estimaciones de Mínimos cuadrados ponderados usando wtvar como
variable de ponderaciones, vardep como variable dependiente y varindeps como
lista de variables independientes. En concreto, se ejecuta una regresión
MCO de wtvar * vardep contra wtvar * varindeps. Si wtvar es una variable
ficticia, esto es equivalente a eliminar todas las observaciones en las que
wtvar tiene valor cero.

Menú gráfico: /Modelo/Mínimos cuadrados ponderados

