#!/usr/bin/python
#######################################################################
### FILE:	config
### PURPOSE:	Config module for greylistd
########################################################################

from debconf import *
from sys     import argv, stderr, exit
from os      import popen
from os.path import realpath
from pwd     import getpwnam
from grp     import getgrgid
from re      import compile

### Setup
db    = Debconf()
owner = "greylistd"
items = [ "ugid",
          "autoconfig_now_available",
          "autoconfig_exim4",
          "autoconfig_notdone" ]



def handconfigured_ugid ():
    pipe  = popen('. /etc/default/greylist; echo "$UGID"')
    ugid  = pipe.readline().strip()
    pipe.close()
    return ugid or None



def bound_process_owner (proto="tcp", port=25):
    pidEx = compile(r"^%s.*:%s .*:\* *LISTEN *(\d+)/.*$"%(proto, port))
    pipe  = popen("/bin/netstat -nltp")
    user  = None
    pid   = None
    for line in pipe:
        match = pidEx.match(line)
        if match:
            pid = match.group(1)
    pipe.close()

    if pid:
        pipe  = popen("/bin/ps h ouser p%s"%pid)
        for line in pipe:
            user = line.strip()
        pipe.close()

    return user or None


def group_name (userName):
    try:
        (username, userpass, uid, gid, gecos, dir, shell) = getpwnam(userName)
        (groupname, grouppass, gid, members) = getgrgid(int(gid))
        return groupname

    except KeyError:
        return None

    except ValueError:
        return None


def running_exim4 ():
    return False
    return realpath("/usr/sbin/sendmail") == "/usr/sbin/exim4"



def config_ugid (question):
    if priorversion:
        ugid      = handconfigured_ugid()
        priority  = LOW

    elif running_exim4():
        ugid      = "Debian-exim:Debian-exim"
        priority  = LOW

    else:
        username  = bound_process_owner("tcp", 25) or "mail"
        groupname = group_name(username) or "mail"
        ugid      = "%s:%s"%(username, groupname)
        priority  = MEDIUM

    if ugid:
        db.set(question, ugid)
    return priority


def config_autoconfig_now_available (question):
    if priorversion and (priorversion < "0.6") and running_exim4():
        return MEDIUM

    else:
        return None


def config_autoconfig_exim4 (question):
    if running_exim4():
        return MEDIUM

    else:
        db.set(question, "false")
        return None


def config_autoconfig_notdone (question):
    if running_exim4():
        return None

    else:
        return MEDIUM


def do_configure (oldversion=None):
    global priorversion
    priorversion = len(argv) > 2 and argv[2] or None
    index        = 0
    trail        = [ None ]

    while index in range(len(items)):
        item       = items[index]
        dbitem     = "%s/%s"%(owner, item)
        conffunc   = globals().get("config_" + item, None)

        if conffunc:
            priority   = conffunc(dbitem)

        else:
            stderr.write("Missing function: config_%s()\n"%item)
            priority = None

           
        if priority:
            try:
                db.input(priority, dbitem)

            except DebconfError:
                index += 1

            else:
                try:
                    db.go()

                except DebconfError:
                    index = trail.pop()

                else:
                    trail.append(index)
                    index += 1

        else:
            index += 1



if len(argv) < 2:
    stderr.write("%s: Missing command\n"%(argv[0]))
    exit(1)

else:
    name = "do_" + argv[1].lower().replace("-", "_")
    args = argv[2:]

    try:
        function = globals()[name]
        function(*args)

    except KeyError, e:
        stderr.write("%s: Unknown command: %s\n"%(argv[0], argv[1]))
        exit(1)

    except TypeError, e:
        stderr.write("%s: %s\n"%(argv[0], e))
        exit(1)

    else:
        exit(0)

