#!/usr/bin/python
# postinst script for greylistd
#
# see: dh_installdeb(1)
# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see /usr/share/doc/packaging-manual/
#
# quoting from the policy:
#     Any necessary prompting should almost always be confined to the
#     post-installation script, and should be protected with a conditional
#     so that unnecessary prompting doesn't happen if a package's
#     installation fails and the `postinst' is called with `abort-upgrade',
#     `abort-remove' or `abort-deconfigure'.

from debconf import *
from sys     import argv, stderr, exit
from os      import popen, spawnl, P_WAIT

defaults = "/etc/defaults/greylist"


def do_configure (oldversion):
    db = Debconf()
    
    stderr.write("Configuring oldversion=%s\n"%oldversion)
    
    

def do_abort_upgrade (newversion):
    pass


def do_abort_remove (infavour, package, newversion):
    pass


def do_abort_deconfigure (infavour, failedpackage, failedversion,
                          removing, conflictpackage, conflictversion):
    pass



def update_ugid (ugid):
    try:
        fp = file(defaults)
        inputLines = fp.readlines(True)
        fp.close()

    except IOError, e:
        return "Could not read from %s: %s"%(defaults, e[1])

    outputLines = []
    for line in inputLines:
        if line.strip().startswith("UGID="):
            outputLines.append("UGID=%s\n"%ugid)
        else:
            outputLines.append(line)

    if inputLines != outputLines:
        try:
            fp = file(defaults, "w")
            fp.writelines(outputLines)
            fp.close()

        except IOError, e:
            return "Could not write to %s: %s"%(defaults, e[1])


def autoconfig_exim4 ():
    try:
        pipe   = popen("/usr/sbin/greylistd-setup-exim4 add")
        lines  = pipe.readlines()
        status = pipe.close()
    except:
        pass
    ---HERE---
        

def invoke_rc_d (script, action):
    spawnl(P_WAIT, "/usr/sbin/invoke-rc.d", "invoke-rc.d", script, action)





if len(argv) < 2:
    stderr.write("%s: Missing command\n"%(argv[0]))
    exit(1)

else:
    name = "do_" + argv[1].lower().replace("-", "_")
    args = argv[2:]

    try:
        function = globals()[name]
        function(*args)

    except KeyError, e:
        stderr.write("%s: Unknown command: %s\n"%(argv[0], argv[1]))
        exit(1)

    except TypeError, e:
        stderr.write("%s: %s\n"%(argv[0], e))
        exit(1)

    else:
        exit(0)
