#if !defined(AFX_POPUPTIMECTRL_H__385DB666_D1FF_11D2_9702_0020AFA6CCC8__INCLUDED_)
#define AFX_POPUPTIMECTRL_H__385DB666_D1FF_11D2_9702_0020AFA6CCC8__INCLUDED_
/*___INFO__MARK_BEGIN__*/
/*************************************************************************
 * 
 *  The Contents of this file are made available subject to the terms of
 *  the Sun Industry Standards Source License Version 1.2
 * 
 *  Sun Microsystems Inc., March, 2001
 * 
 * 
 *  Sun Industry Standards Source License Version 1.2
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.2 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://gridengine.sunsource.net/Gridengine_SISSL_license.html
 * 
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 * 
 *   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 * 
 *   Copyright: 2001 by Sun Microsystems, Inc.
 * 
 *   All Rights Reserved.
 * 
 ************************************************************************/
/*___INFO__MARK_END__*/

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// PopupTimeCtrl.h : header file
//
#include <afxdtctl.h>

// Custom-defined notification code, to notify
// a parent that the hour of a CPopupTimeCtrl has changed
#define DTN_HOURCHANGE		(DTN_LAST + 1)

/////////////////////////////////////////////////////////////////////////////
// CPopupTimeCtrl window

class AFX_EXT_CLASS CPopupTimeCtrl : public CDateTimeCtrl
{
public:
	// Construction
	CPopupTimeCtrl();
	CPopupTimeCtrl(int ListCtrlRow, int ListCtrlCol, const CString &InitText);
	virtual ~CPopupTimeCtrl();
	
	// Operations
	CTime   StringToTime(const CString &timeString);
	CString TimeToString(const CTime   &timeString);
	BOOL    SetTime(const CTime &TimeNew);
	DWORD   GetTime(CTime &timeDest);

	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPopupTimeCtrl)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	//}}AFX_VIRTUAL

	// Generated message map functions
protected:
	afx_msg void OnContextMenu(CWnd*, CPoint point);

	//{{AFX_MSG(CPopupTimeCtrl)
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnNcDestroy();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnPopupTimeInfinity();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnDatetimechange(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnFormatquery(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnFormat(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnWmkeydown(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

private:
	bool		m_bIsEmbeddedIntoListCtrl;
	bool		m_bESC;	 	
	int			m_ListCtrlRow;
    int			m_ListCtrlCol;
	CString		m_InitText;
	
	int			m_Hours;
	int			m_Delta;
	int			m_KeyCount;
	bool		m_bInfinity;
	bool		m_bClick;
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_POPUPTIMECTRL_H__385DB666_D1FF_11D2_9702_0020AFA6CCC8__INCLUDED_)
