/* Gridlock
Copyright (c) 2002-2003 by Brian Nenninger. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#import "CheckersAI.h"
#import "CheckersGame.h"

@implementation CheckersAI

-(id)init {
  self = [super init];
  regWeight  = 1;
  kingWeight = 2;
  return self;
}

-(int)relativeUtilityForGame:(Game *)game player:(int)pnum {
  CheckersGame *cgame = game;
  int myutility  = 0;
  int opputility = 0;
  int oppnum = [cgame playerNumberMovingAfterPlayer:pnum];
  int total = 0;
  myutility  = regWeight*[cgame numberOfRegularPiecesForPlayer:pnum] +
              kingWeight*[cgame numberOfKingsForPlayer:pnum];
  opputility = regWeight*[cgame numberOfRegularPiecesForPlayer:oppnum] +
              kingWeight*[cgame numberOfKingsForPlayer:oppnum];

  total = (myutility-opputility)*1000;
  {
    // Look at the ratio of my vs. opponent's utility. This will encourage exchanges when we're ahead and
    // avoid them when we're behind.
    double logratio = 0.0;
    if (myutility==0) logratio=-2.0;
    else if (opputility==0) logratio=+2.0;
    else {
      logratio = log((1.0*myutility)/opputility);
      if (logratio<-2.0) logratio=-2.0;
      if (logratio>2.0) logratio=+2.0;
    }
    total += (500*logratio);
  }
  return total;
}

@end
