# please use current py2app trunk from svn

from distutils.core import setup
import py2app
import glob

# Build the .app file
setup(
    options=dict(
        py2app=dict(
            iconfile='images/griffith.icns',
            argv_emulation=1,
            optimize=2,
            site_packages=True,
includes="cairo,pangocairo,pysqlite2,pysqlite2.*,cgi,PIL,pysqlite2,pysqlite2.*,pango,atk,gobject,tempfile,csv,xml.dom,xml.dom.ext,xml.dom.minidom,xml.sax,threading,htmlentitydefs,sqlalchemy,sqlalchemy.*,sqlalchemy.mods.*,sqlalchemy.databases.*,sqlalchemy.engine.*,sqlalchemy.ext.*,sqlalchemy.orm.*,zipfile,webbrowser,shutil,reportlab,reportlab.pdfgen,reportlab.pdfgen.canvas,reportlab.platypus,reportlab.pdfbase.ttfonts,smtplib,platform,psycopg2,MySQLdb,pygtk", 
            resources=['COPYING', 'AUTHORS', ("",glob.glob("lib/*.*")), ("images",glob.glob("images/*.png")), ("lib/plugins/movie",glob.glob("lib/plugins/movie/*.*")), ("lib/plugins/export",glob.glob("lib/plugins/export/*.*")), ("glade",glob.glob("glade/*.*")), ("images/export_templates/html_tables",glob.glob("data/export_templates/html_tables/*.*")), ("images/export_templates/html_table",glob.glob("data/export_templates/html_table/*.*")), ("images/export_templates/latex",glob.glob("data/export_templates/latex/*.*")), ("images/export_templates/xml",glob.glob("data/export_templates/xml/*.*")), ("images/export_templates/csv",glob.glob("data/export_templates/csv/*.*")), ("images/export_templates",glob.glob("data/export_template/*.dtd")), ("lib/plugins/imp",glob.glob("lib/plugins/imp/*.*")), ("lib/plugins",glob.glob("lib/plugins/*.*"))],
            plist=dict(
                CFBundleName               = "Griffith",
                CFBundleShortVersionString = "0.9-rc2",     # must be in X.X.X format
                CFBundleGetInfoString      = "Griffith 0.9-rc2",
                CFBundleExecutable         = "Griffith",
                CFBundleIdentifier          = "de.berlios.griffith",
            ),
        ),
    ),
    app=[ 'griffith.py' ]
)
