/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  grig-druid-rig.c:  RIG module for the configuration druid.

  Copyright (C)  2001, 2002  Groundstation Software Suite Team.

  Authors: Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#include "hamlib-widgets.h"
#include "riglist-util.h"
#include "grig-druid-rig.h"

#if defined (HAVE_LIBHAMLIB) && defined (HAVE_HAMLIB_RIG_H)
#  include <hamlib/rig.h>
#endif

extern GdkColor headbg; /* defd in grig-druid.c */
extern GConfClient *confclient;  /* main.c */
static guint rigid;
static GtkWidget *page,*swin,*rigclist;
static GtkWidget *frame,*table,*hbox;
static GtkWidget *idlabel,*mfglabel,*mlabel,*drlabel;
static GtkWidget *port;

/* Provate function prototypes */
static void grig_druid_rig_select_row_cb (GtkWidget *, gint, gint, GdkEventButton *, gpointer);

const gchar *rportinfo = N_("Specify the device your radio is connected to, "\
			    "or the hostname if you wish to connect to rpc.rigd "\
			    "which is running on a remote machine.");


GtkWidget *grig_druid_rig_create (GtkWidget *druid)
{
	/* This function creates a GnomeDruidPageStandard containing
	   all necessary widgets for configuring the radios. This
	   function should only be called from the main configuration
	   druid function.
	*/

	GSList *riglist = NULL;
	GtkWidget *label;

	/* get list of drivers */
	riglist = riglist_get_list ();

	/* create a columned list */
	rigclist = hamlib_riglist_widget_new (riglist);
	gtk_signal_connect (GTK_OBJECT (rigclist), "select-row",
			    GTK_SIGNAL_FUNC (grig_druid_rig_select_row_cb),
			    NULL);
	/* don't need it anymore */
//	g_slist_free (riglist);
	
	/* pack the clist into a scrolled window */
	swin = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin),
					GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_container_add (GTK_CONTAINER (swin), rigclist);

	page = gnome_druid_page_standard_new_with_vals (_("Default Radio"),
							NULL);
	gnome_druid_page_standard_set_bg_color (GNOME_DRUID_PAGE_STANDARD (page),
						&headbg);
	gnome_druid_page_standard_set_logo_bg_color (GNOME_DRUID_PAGE_STANDARD (page),
						     &headbg);

	gtk_container_set_border_width (GTK_CONTAINER (GNOME_DRUID_PAGE_STANDARD (page)->vbox), 5);

	/* Status stuff */
	table = gtk_table_new (8, 2, TRUE);
	gtk_table_set_col_spacings (GTK_TABLE (table), 10);
	gtk_table_set_row_spacings (GTK_TABLE (table), 5);
	/* table contents */
	label = gtk_label_new (_("Hamlib ID:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);
	idlabel = gtk_label_new (NULL);
	gtk_misc_set_alignment (GTK_MISC (idlabel), 0.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), idlabel, 1, 2, 0, 1);
	label = gtk_label_new (_("Manufacturer:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);
	mfglabel = gtk_label_new (NULL);
	gtk_misc_set_alignment (GTK_MISC (mfglabel), 0.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), mfglabel, 1, 2, 1, 2);
	label = gtk_label_new (_("Model:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 2, 3);
	mlabel = gtk_label_new (NULL);
	gtk_misc_set_alignment (GTK_MISC (mlabel), 0.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), mlabel, 1, 2, 2, 3);
	label = gtk_label_new (_("Driver status:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 3, 4);
	drlabel = gtk_label_new (NULL);
	gtk_misc_set_alignment (GTK_MISC (drlabel), 0.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), drlabel, 1, 2, 3, 4);
	/* update labels... */
	grig_druid_rig_select_row_cb (rigclist, 0, 0, NULL, NULL);

	label = gtk_label_new (_("Port:"));
	gtk_misc_set_alignment (GTK_MISC (label), 1.0, 0.5);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 4, 5);

	/* port entry */
	port = gtk_entry_new ();
	gtk_widget_set (port, "width", 50, NULL);
	gtk_entry_set_text (GTK_ENTRY (port), "/dev/ttyS0");
	gtk_table_attach_defaults (GTK_TABLE (table), port, 1, 2, 4, 5);

	/* port info label */
	label = gtk_label_new (rportinfo);
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
	gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 2, 5, 8);

	/* frame */
	frame = gtk_frame_new (_("Selected Radio"));
	gtk_frame_set_label_align (GTK_FRAME (frame), 0.5, 0.5);
	gtk_container_add (GTK_CONTAINER (frame), table);

	/* horizontal box */
	hbox = gtk_hbox_new (FALSE, 10);
	gtk_box_pack_start_defaults (GTK_BOX (hbox), swin);
	gtk_box_pack_end_defaults (GTK_BOX (hbox), frame);

	/* add contents to druid page */
	gtk_box_pack_start_defaults (GTK_BOX (GNOME_DRUID_PAGE_STANDARD (page)->vbox), hbox);

	return page;
}



static void
grig_druid_rig_select_row_cb (GtkWidget *clist, gint row, gint column,
			      GdkEventButton *button, gpointer data)
{
	/* This function is called when the user selects a new radio
	   from the list.
	*/
	gchar *buff[50];

	rigid = GPOINTER_TO_UINT (gtk_clist_get_row_data (GTK_CLIST (clist), row));
	if (gtk_clist_get_text (GTK_CLIST (clist), row, 0, buff))
		gtk_label_set_text (GTK_LABEL (idlabel), *buff);
	if (gtk_clist_get_text (GTK_CLIST (clist), row, 1, buff))
		gtk_label_set_text (GTK_LABEL (mfglabel), *buff);
	if (gtk_clist_get_text (GTK_CLIST (clist), row, 2, buff))
		gtk_label_set_text (GTK_LABEL (mlabel), *buff);
	if (gtk_clist_get_text (GTK_CLIST (clist), row, 3, buff))
		gtk_label_set_text (GTK_LABEL (drlabel), *buff);
}



gint grig_druid_rig_cancel ()
{
	/* This function should be called by the main config druid
	   cancel callback. The function returns 0 if everything was
	   all right or 1 if an error has occured.
	*/
 
	
	return 0;
}


gint grig_druid_rig_finish ()
{
	/* This function should be called by the main config druid
	   finish callback function. The function returns 0 if
	   everything was all right or 1 if an error has occured.
	*/
	gboolean ok = TRUE;

	/* default radio is in /apps/grig/locations/0/ */
	ok = ok && gconf_client_set_int (confclient,
					 GRIG_CONFIG_RIG_DIR "/default",
					 0, NULL);
	/* nyumber of radios */
	ok = ok && gconf_client_set_int (confclient,
					 GRIG_CONFIG_RIG_DIR "/number",
					 1, NULL);
	/* RIG id */
	ok = ok && gconf_client_set_int (confclient,
					 GRIG_CONFIG_RIG_DIR "/0/ID",
					 rigid, NULL);
	/* Manufacturer */
	ok = ok && gconf_client_set_string (confclient,
					    GRIG_CONFIG_RIG_DIR "/0/Brand",
					    GTK_LABEL (mfglabel)->label,
					    NULL);
	/* Model */
	ok = ok && gconf_client_set_string (confclient,
					    GRIG_CONFIG_RIG_DIR "/0/Model",
					    GTK_LABEL (mlabel)->label,
					    NULL);
	/* Driver version */
/*  	ok = ok && gconf_client_set_string (confclient, */
/*  					    GRIG_CONFIG_RIG_DIR "/0/ver", */
/*  					    GTK_LABEL (drlabel)->label, */
/*  					    NULL); */
	/* port */
	ok = ok && gconf_client_set_string (confclient,
					    GRIG_CONFIG_RIG_DIR "/0/port",
					    gtk_entry_get_text (GTK_ENTRY (port)),
					    NULL);

	return (gint) !ok;  /* shoot me again, please! */
}

