/*
 * This file is part of the GROMACS molecular simulation package.
 *
 * Copyright (c) 2012,2013,2014,2015,2017,2018, by the GROMACS development team, led by
 * Mark Abraham, David van der Spoel, Berk Hess, and Erik Lindahl,
 * and including many others, as listed in the AUTHORS file in the
 * top-level source directory and at http://www.gromacs.org.
 *
 * GROMACS is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * GROMACS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GROMACS; if not, see
 * http://www.gnu.org/licenses, or write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * If you want to redistribute modifications to GROMACS, please
 * consider that scientific software is very special. Version
 * control is crucial - bugs must be traceable. We will be happy to
 * consider code for inclusion in the official distribution, but
 * derived work must not be called official GROMACS. Details are found
 * in the README & COPYING files - if they are missing, get the
 * official version at http://www.gromacs.org.
 *
 * To help us fund GROMACS development, we humbly ask that you cite
 * the research papers on the package. Check out http://www.gromacs.org.
 */
/*
 * Note: this file was generated by the GROMACS avx_128_fma_single kernel generator.
 */
#include "gmxpre.h"

#include "config.h"

#include <math.h>

#include "../nb_kernel.h"
#include "gromacs/gmxlib/nrnb.h"

#include "kernelutil_x86_avx_128_fma_single.h"

/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecRF_VdwNone_GeomW4W4_VF_avx_128_fma_single
 * Electrostatics interaction: ReactionField
 * VdW interaction:            None
 * Geometry:                   Water4-Water4
 * Calculate force/pot:        PotentialAndForce
 */
void
nb_kernel_ElecRF_VdwNone_GeomW4W4_VF_avx_128_fma_single
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     struct t_forcerec           * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or
     * just 0 for non-waters.
     * Suffixes A,B,C,D refer to j loop unrolling done with AVX_128, e.g. for the four different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB,jnrC,jnrD;
    int              jnrlistA,jnrlistB,jnrlistC,jnrlistD;
    int              j_coord_offsetA,j_coord_offsetB,j_coord_offsetC,j_coord_offsetD;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    real             *fjptrA,*fjptrB,*fjptrC,*fjptrD;
    real             scratch[4*DIM];
    __m128           fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset1;
    __m128           ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    int              vdwioffset2;
    __m128           ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwioffset3;
    __m128           ix3,iy3,iz3,fix3,fiy3,fiz3,iq3,isai3;
    int              vdwjidx1A,vdwjidx1B,vdwjidx1C,vdwjidx1D;
    __m128           jx1,jy1,jz1,fjx1,fjy1,fjz1,jq1,isaj1;
    int              vdwjidx2A,vdwjidx2B,vdwjidx2C,vdwjidx2D;
    __m128           jx2,jy2,jz2,fjx2,fjy2,fjz2,jq2,isaj2;
    int              vdwjidx3A,vdwjidx3B,vdwjidx3C,vdwjidx3D;
    __m128           jx3,jy3,jz3,fjx3,fjy3,fjz3,jq3,isaj3;
    __m128           dx11,dy11,dz11,rsq11,rinv11,rinvsq11,r11,qq11,c6_11,c12_11;
    __m128           dx12,dy12,dz12,rsq12,rinv12,rinvsq12,r12,qq12,c6_12,c12_12;
    __m128           dx13,dy13,dz13,rsq13,rinv13,rinvsq13,r13,qq13,c6_13,c12_13;
    __m128           dx21,dy21,dz21,rsq21,rinv21,rinvsq21,r21,qq21,c6_21,c12_21;
    __m128           dx22,dy22,dz22,rsq22,rinv22,rinvsq22,r22,qq22,c6_22,c12_22;
    __m128           dx23,dy23,dz23,rsq23,rinv23,rinvsq23,r23,qq23,c6_23,c12_23;
    __m128           dx31,dy31,dz31,rsq31,rinv31,rinvsq31,r31,qq31,c6_31,c12_31;
    __m128           dx32,dy32,dz32,rsq32,rinv32,rinvsq32,r32,qq32,c6_32,c12_32;
    __m128           dx33,dy33,dz33,rsq33,rinv33,rinvsq33,r33,qq33,c6_33,c12_33;
    __m128           velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    __m128           dummy_mask,cutoff_mask;
    __m128           signbit = _mm_castsi128_ps( _mm_set1_epi32(0x80000000) );
    __m128           one     = _mm_set1_ps(1.0);
    __m128           two     = _mm_set1_ps(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm_set1_ps(fr->ic->epsfac);
    charge           = mdatoms->chargeA;
    krf              = _mm_set1_ps(fr->ic->k_rf);
    krf2             = _mm_set1_ps(fr->ic->k_rf*2.0);
    crf              = _mm_set1_ps(fr->ic->c_rf);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq1              = _mm_mul_ps(facel,_mm_set1_ps(charge[inr+1]));
    iq2              = _mm_mul_ps(facel,_mm_set1_ps(charge[inr+2]));
    iq3              = _mm_mul_ps(facel,_mm_set1_ps(charge[inr+3]));

    jq1              = _mm_set1_ps(charge[inr+1]);
    jq2              = _mm_set1_ps(charge[inr+2]);
    jq3              = _mm_set1_ps(charge[inr+3]);
    qq11             = _mm_mul_ps(iq1,jq1);
    qq12             = _mm_mul_ps(iq1,jq2);
    qq13             = _mm_mul_ps(iq1,jq3);
    qq21             = _mm_mul_ps(iq2,jq1);
    qq22             = _mm_mul_ps(iq2,jq2);
    qq23             = _mm_mul_ps(iq2,jq3);
    qq31             = _mm_mul_ps(iq3,jq1);
    qq32             = _mm_mul_ps(iq3,jq2);
    qq33             = _mm_mul_ps(iq3,jq3);

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = jnrC = jnrD = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;
    j_coord_offsetC = 0;
    j_coord_offsetD = 0;

    outeriter        = 0;
    inneriter        = 0;

    for(iidx=0;iidx<4*DIM;iidx++)
    {
        scratch[iidx] = 0.0;
    }

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm_load_shift_and_3rvec_broadcast_ps(shiftvec+i_shift_offset,x+i_coord_offset+DIM,
                                                 &ix1,&iy1,&iz1,&ix2,&iy2,&iz2,&ix3,&iy3,&iz3);

        fix1             = _mm_setzero_ps();
        fiy1             = _mm_setzero_ps();
        fiz1             = _mm_setzero_ps();
        fix2             = _mm_setzero_ps();
        fiy2             = _mm_setzero_ps();
        fiz2             = _mm_setzero_ps();
        fix3             = _mm_setzero_ps();
        fiy3             = _mm_setzero_ps();
        fiz3             = _mm_setzero_ps();

        /* Reset potential sums */
        velecsum         = _mm_setzero_ps();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end && jjnr[jidx+3]>=0; jidx+=4)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            jnrC             = jjnr[jidx+2];
            jnrD             = jjnr[jidx+3];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_4ptr_swizzle_ps(x+j_coord_offsetA+DIM,x+j_coord_offsetB+DIM,
                                              x+j_coord_offsetC+DIM,x+j_coord_offsetD+DIM,
                                              &jx1,&jy1,&jz1,&jx2,&jy2,&jz2,&jx3,&jy3,&jz3);

            /* Calculate displacement vector */
            dx11             = _mm_sub_ps(ix1,jx1);
            dy11             = _mm_sub_ps(iy1,jy1);
            dz11             = _mm_sub_ps(iz1,jz1);
            dx12             = _mm_sub_ps(ix1,jx2);
            dy12             = _mm_sub_ps(iy1,jy2);
            dz12             = _mm_sub_ps(iz1,jz2);
            dx13             = _mm_sub_ps(ix1,jx3);
            dy13             = _mm_sub_ps(iy1,jy3);
            dz13             = _mm_sub_ps(iz1,jz3);
            dx21             = _mm_sub_ps(ix2,jx1);
            dy21             = _mm_sub_ps(iy2,jy1);
            dz21             = _mm_sub_ps(iz2,jz1);
            dx22             = _mm_sub_ps(ix2,jx2);
            dy22             = _mm_sub_ps(iy2,jy2);
            dz22             = _mm_sub_ps(iz2,jz2);
            dx23             = _mm_sub_ps(ix2,jx3);
            dy23             = _mm_sub_ps(iy2,jy3);
            dz23             = _mm_sub_ps(iz2,jz3);
            dx31             = _mm_sub_ps(ix3,jx1);
            dy31             = _mm_sub_ps(iy3,jy1);
            dz31             = _mm_sub_ps(iz3,jz1);
            dx32             = _mm_sub_ps(ix3,jx2);
            dy32             = _mm_sub_ps(iy3,jy2);
            dz32             = _mm_sub_ps(iz3,jz2);
            dx33             = _mm_sub_ps(ix3,jx3);
            dy33             = _mm_sub_ps(iy3,jy3);
            dz33             = _mm_sub_ps(iz3,jz3);

            /* Calculate squared distance and things based on it */
            rsq11            = gmx_mm_calc_rsq_ps(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_ps(dx12,dy12,dz12);
            rsq13            = gmx_mm_calc_rsq_ps(dx13,dy13,dz13);
            rsq21            = gmx_mm_calc_rsq_ps(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_ps(dx22,dy22,dz22);
            rsq23            = gmx_mm_calc_rsq_ps(dx23,dy23,dz23);
            rsq31            = gmx_mm_calc_rsq_ps(dx31,dy31,dz31);
            rsq32            = gmx_mm_calc_rsq_ps(dx32,dy32,dz32);
            rsq33            = gmx_mm_calc_rsq_ps(dx33,dy33,dz33);

            rinv11           = avx128fma_invsqrt_f(rsq11);
            rinv12           = avx128fma_invsqrt_f(rsq12);
            rinv13           = avx128fma_invsqrt_f(rsq13);
            rinv21           = avx128fma_invsqrt_f(rsq21);
            rinv22           = avx128fma_invsqrt_f(rsq22);
            rinv23           = avx128fma_invsqrt_f(rsq23);
            rinv31           = avx128fma_invsqrt_f(rsq31);
            rinv32           = avx128fma_invsqrt_f(rsq32);
            rinv33           = avx128fma_invsqrt_f(rsq33);

            rinvsq11         = _mm_mul_ps(rinv11,rinv11);
            rinvsq12         = _mm_mul_ps(rinv12,rinv12);
            rinvsq13         = _mm_mul_ps(rinv13,rinv13);
            rinvsq21         = _mm_mul_ps(rinv21,rinv21);
            rinvsq22         = _mm_mul_ps(rinv22,rinv22);
            rinvsq23         = _mm_mul_ps(rinv23,rinv23);
            rinvsq31         = _mm_mul_ps(rinv31,rinv31);
            rinvsq32         = _mm_mul_ps(rinv32,rinv32);
            rinvsq33         = _mm_mul_ps(rinv33,rinv33);

            fjx1             = _mm_setzero_ps();
            fjy1             = _mm_setzero_ps();
            fjz1             = _mm_setzero_ps();
            fjx2             = _mm_setzero_ps();
            fjy2             = _mm_setzero_ps();
            fjz2             = _mm_setzero_ps();
            fjx3             = _mm_setzero_ps();
            fjy3             = _mm_setzero_ps();
            fjz3             = _mm_setzero_ps();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq11,_mm_sub_ps(_mm_macc_ps(krf,rsq11,rinv11),crf));
            felec            = _mm_mul_ps(qq11,_mm_msub_ps(rinv11,rinvsq11,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

             /* Update vectorial force */
            fix1             = _mm_macc_ps(dx11,fscal,fix1);
            fiy1             = _mm_macc_ps(dy11,fscal,fiy1);
            fiz1             = _mm_macc_ps(dz11,fscal,fiz1);

            fjx1             = _mm_macc_ps(dx11,fscal,fjx1);
            fjy1             = _mm_macc_ps(dy11,fscal,fjy1);
            fjz1             = _mm_macc_ps(dz11,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq12,_mm_sub_ps(_mm_macc_ps(krf,rsq12,rinv12),crf));
            felec            = _mm_mul_ps(qq12,_mm_msub_ps(rinv12,rinvsq12,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

             /* Update vectorial force */
            fix1             = _mm_macc_ps(dx12,fscal,fix1);
            fiy1             = _mm_macc_ps(dy12,fscal,fiy1);
            fiz1             = _mm_macc_ps(dz12,fscal,fiz1);

            fjx2             = _mm_macc_ps(dx12,fscal,fjx2);
            fjy2             = _mm_macc_ps(dy12,fscal,fjy2);
            fjz2             = _mm_macc_ps(dz12,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq13,_mm_sub_ps(_mm_macc_ps(krf,rsq13,rinv13),crf));
            felec            = _mm_mul_ps(qq13,_mm_msub_ps(rinv13,rinvsq13,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

             /* Update vectorial force */
            fix1             = _mm_macc_ps(dx13,fscal,fix1);
            fiy1             = _mm_macc_ps(dy13,fscal,fiy1);
            fiz1             = _mm_macc_ps(dz13,fscal,fiz1);

            fjx3             = _mm_macc_ps(dx13,fscal,fjx3);
            fjy3             = _mm_macc_ps(dy13,fscal,fjy3);
            fjz3             = _mm_macc_ps(dz13,fscal,fjz3);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq21,_mm_sub_ps(_mm_macc_ps(krf,rsq21,rinv21),crf));
            felec            = _mm_mul_ps(qq21,_mm_msub_ps(rinv21,rinvsq21,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

             /* Update vectorial force */
            fix2             = _mm_macc_ps(dx21,fscal,fix2);
            fiy2             = _mm_macc_ps(dy21,fscal,fiy2);
            fiz2             = _mm_macc_ps(dz21,fscal,fiz2);

            fjx1             = _mm_macc_ps(dx21,fscal,fjx1);
            fjy1             = _mm_macc_ps(dy21,fscal,fjy1);
            fjz1             = _mm_macc_ps(dz21,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq22,_mm_sub_ps(_mm_macc_ps(krf,rsq22,rinv22),crf));
            felec            = _mm_mul_ps(qq22,_mm_msub_ps(rinv22,rinvsq22,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

             /* Update vectorial force */
            fix2             = _mm_macc_ps(dx22,fscal,fix2);
            fiy2             = _mm_macc_ps(dy22,fscal,fiy2);
            fiz2             = _mm_macc_ps(dz22,fscal,fiz2);

            fjx2             = _mm_macc_ps(dx22,fscal,fjx2);
            fjy2             = _mm_macc_ps(dy22,fscal,fjy2);
            fjz2             = _mm_macc_ps(dz22,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq23,_mm_sub_ps(_mm_macc_ps(krf,rsq23,rinv23),crf));
            felec            = _mm_mul_ps(qq23,_mm_msub_ps(rinv23,rinvsq23,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

             /* Update vectorial force */
            fix2             = _mm_macc_ps(dx23,fscal,fix2);
            fiy2             = _mm_macc_ps(dy23,fscal,fiy2);
            fiz2             = _mm_macc_ps(dz23,fscal,fiz2);

            fjx3             = _mm_macc_ps(dx23,fscal,fjx3);
            fjy3             = _mm_macc_ps(dy23,fscal,fjy3);
            fjz3             = _mm_macc_ps(dz23,fscal,fjz3);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq31,_mm_sub_ps(_mm_macc_ps(krf,rsq31,rinv31),crf));
            felec            = _mm_mul_ps(qq31,_mm_msub_ps(rinv31,rinvsq31,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

             /* Update vectorial force */
            fix3             = _mm_macc_ps(dx31,fscal,fix3);
            fiy3             = _mm_macc_ps(dy31,fscal,fiy3);
            fiz3             = _mm_macc_ps(dz31,fscal,fiz3);

            fjx1             = _mm_macc_ps(dx31,fscal,fjx1);
            fjy1             = _mm_macc_ps(dy31,fscal,fjy1);
            fjz1             = _mm_macc_ps(dz31,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq32,_mm_sub_ps(_mm_macc_ps(krf,rsq32,rinv32),crf));
            felec            = _mm_mul_ps(qq32,_mm_msub_ps(rinv32,rinvsq32,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

             /* Update vectorial force */
            fix3             = _mm_macc_ps(dx32,fscal,fix3);
            fiy3             = _mm_macc_ps(dy32,fscal,fiy3);
            fiz3             = _mm_macc_ps(dz32,fscal,fiz3);

            fjx2             = _mm_macc_ps(dx32,fscal,fjx2);
            fjy2             = _mm_macc_ps(dy32,fscal,fjy2);
            fjz2             = _mm_macc_ps(dz32,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq33,_mm_sub_ps(_mm_macc_ps(krf,rsq33,rinv33),crf));
            felec            = _mm_mul_ps(qq33,_mm_msub_ps(rinv33,rinvsq33,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

             /* Update vectorial force */
            fix3             = _mm_macc_ps(dx33,fscal,fix3);
            fiy3             = _mm_macc_ps(dy33,fscal,fiy3);
            fiz3             = _mm_macc_ps(dz33,fscal,fiz3);

            fjx3             = _mm_macc_ps(dx33,fscal,fjx3);
            fjy3             = _mm_macc_ps(dy33,fscal,fjy3);
            fjz3             = _mm_macc_ps(dz33,fscal,fjz3);

            fjptrA             = f+j_coord_offsetA;
            fjptrB             = f+j_coord_offsetB;
            fjptrC             = f+j_coord_offsetC;
            fjptrD             = f+j_coord_offsetD;

            gmx_mm_decrement_3rvec_4ptr_swizzle_ps(fjptrA+DIM,fjptrB+DIM,fjptrC+DIM,fjptrD+DIM,
                                                   fjx1,fjy1,fjz1,fjx2,fjy2,fjz2,fjx3,fjy3,fjz3);

            /* Inner loop uses 315 flops */
        }

        if(jidx<j_index_end)
        {

            /* Get j neighbor index, and coordinate index */
            jnrlistA         = jjnr[jidx];
            jnrlistB         = jjnr[jidx+1];
            jnrlistC         = jjnr[jidx+2];
            jnrlistD         = jjnr[jidx+3];
            /* Sign of each element will be negative for non-real atoms.
             * This mask will be 0xFFFFFFFF for dummy entries and 0x0 for real ones,
             * so use it as val = _mm_andnot_ps(mask,val) to clear dummy entries.
             */
            dummy_mask = gmx_mm_castsi128_ps(_mm_cmplt_epi32(_mm_loadu_si128((const __m128i *)(jjnr+jidx)),_mm_setzero_si128()));
            jnrA       = (jnrlistA>=0) ? jnrlistA : 0;
            jnrB       = (jnrlistB>=0) ? jnrlistB : 0;
            jnrC       = (jnrlistC>=0) ? jnrlistC : 0;
            jnrD       = (jnrlistD>=0) ? jnrlistD : 0;
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_4ptr_swizzle_ps(x+j_coord_offsetA+DIM,x+j_coord_offsetB+DIM,
                                              x+j_coord_offsetC+DIM,x+j_coord_offsetD+DIM,
                                              &jx1,&jy1,&jz1,&jx2,&jy2,&jz2,&jx3,&jy3,&jz3);

            /* Calculate displacement vector */
            dx11             = _mm_sub_ps(ix1,jx1);
            dy11             = _mm_sub_ps(iy1,jy1);
            dz11             = _mm_sub_ps(iz1,jz1);
            dx12             = _mm_sub_ps(ix1,jx2);
            dy12             = _mm_sub_ps(iy1,jy2);
            dz12             = _mm_sub_ps(iz1,jz2);
            dx13             = _mm_sub_ps(ix1,jx3);
            dy13             = _mm_sub_ps(iy1,jy3);
            dz13             = _mm_sub_ps(iz1,jz3);
            dx21             = _mm_sub_ps(ix2,jx1);
            dy21             = _mm_sub_ps(iy2,jy1);
            dz21             = _mm_sub_ps(iz2,jz1);
            dx22             = _mm_sub_ps(ix2,jx2);
            dy22             = _mm_sub_ps(iy2,jy2);
            dz22             = _mm_sub_ps(iz2,jz2);
            dx23             = _mm_sub_ps(ix2,jx3);
            dy23             = _mm_sub_ps(iy2,jy3);
            dz23             = _mm_sub_ps(iz2,jz3);
            dx31             = _mm_sub_ps(ix3,jx1);
            dy31             = _mm_sub_ps(iy3,jy1);
            dz31             = _mm_sub_ps(iz3,jz1);
            dx32             = _mm_sub_ps(ix3,jx2);
            dy32             = _mm_sub_ps(iy3,jy2);
            dz32             = _mm_sub_ps(iz3,jz2);
            dx33             = _mm_sub_ps(ix3,jx3);
            dy33             = _mm_sub_ps(iy3,jy3);
            dz33             = _mm_sub_ps(iz3,jz3);

            /* Calculate squared distance and things based on it */
            rsq11            = gmx_mm_calc_rsq_ps(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_ps(dx12,dy12,dz12);
            rsq13            = gmx_mm_calc_rsq_ps(dx13,dy13,dz13);
            rsq21            = gmx_mm_calc_rsq_ps(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_ps(dx22,dy22,dz22);
            rsq23            = gmx_mm_calc_rsq_ps(dx23,dy23,dz23);
            rsq31            = gmx_mm_calc_rsq_ps(dx31,dy31,dz31);
            rsq32            = gmx_mm_calc_rsq_ps(dx32,dy32,dz32);
            rsq33            = gmx_mm_calc_rsq_ps(dx33,dy33,dz33);

            rinv11           = avx128fma_invsqrt_f(rsq11);
            rinv12           = avx128fma_invsqrt_f(rsq12);
            rinv13           = avx128fma_invsqrt_f(rsq13);
            rinv21           = avx128fma_invsqrt_f(rsq21);
            rinv22           = avx128fma_invsqrt_f(rsq22);
            rinv23           = avx128fma_invsqrt_f(rsq23);
            rinv31           = avx128fma_invsqrt_f(rsq31);
            rinv32           = avx128fma_invsqrt_f(rsq32);
            rinv33           = avx128fma_invsqrt_f(rsq33);

            rinvsq11         = _mm_mul_ps(rinv11,rinv11);
            rinvsq12         = _mm_mul_ps(rinv12,rinv12);
            rinvsq13         = _mm_mul_ps(rinv13,rinv13);
            rinvsq21         = _mm_mul_ps(rinv21,rinv21);
            rinvsq22         = _mm_mul_ps(rinv22,rinv22);
            rinvsq23         = _mm_mul_ps(rinv23,rinv23);
            rinvsq31         = _mm_mul_ps(rinv31,rinv31);
            rinvsq32         = _mm_mul_ps(rinv32,rinv32);
            rinvsq33         = _mm_mul_ps(rinv33,rinv33);

            fjx1             = _mm_setzero_ps();
            fjy1             = _mm_setzero_ps();
            fjz1             = _mm_setzero_ps();
            fjx2             = _mm_setzero_ps();
            fjy2             = _mm_setzero_ps();
            fjz2             = _mm_setzero_ps();
            fjx3             = _mm_setzero_ps();
            fjy3             = _mm_setzero_ps();
            fjz3             = _mm_setzero_ps();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq11,_mm_sub_ps(_mm_macc_ps(krf,rsq11,rinv11),crf));
            felec            = _mm_mul_ps(qq11,_mm_msub_ps(rinv11,rinvsq11,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix1             = _mm_macc_ps(dx11,fscal,fix1);
            fiy1             = _mm_macc_ps(dy11,fscal,fiy1);
            fiz1             = _mm_macc_ps(dz11,fscal,fiz1);

            fjx1             = _mm_macc_ps(dx11,fscal,fjx1);
            fjy1             = _mm_macc_ps(dy11,fscal,fjy1);
            fjz1             = _mm_macc_ps(dz11,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq12,_mm_sub_ps(_mm_macc_ps(krf,rsq12,rinv12),crf));
            felec            = _mm_mul_ps(qq12,_mm_msub_ps(rinv12,rinvsq12,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix1             = _mm_macc_ps(dx12,fscal,fix1);
            fiy1             = _mm_macc_ps(dy12,fscal,fiy1);
            fiz1             = _mm_macc_ps(dz12,fscal,fiz1);

            fjx2             = _mm_macc_ps(dx12,fscal,fjx2);
            fjy2             = _mm_macc_ps(dy12,fscal,fjy2);
            fjz2             = _mm_macc_ps(dz12,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq13,_mm_sub_ps(_mm_macc_ps(krf,rsq13,rinv13),crf));
            felec            = _mm_mul_ps(qq13,_mm_msub_ps(rinv13,rinvsq13,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix1             = _mm_macc_ps(dx13,fscal,fix1);
            fiy1             = _mm_macc_ps(dy13,fscal,fiy1);
            fiz1             = _mm_macc_ps(dz13,fscal,fiz1);

            fjx3             = _mm_macc_ps(dx13,fscal,fjx3);
            fjy3             = _mm_macc_ps(dy13,fscal,fjy3);
            fjz3             = _mm_macc_ps(dz13,fscal,fjz3);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq21,_mm_sub_ps(_mm_macc_ps(krf,rsq21,rinv21),crf));
            felec            = _mm_mul_ps(qq21,_mm_msub_ps(rinv21,rinvsq21,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix2             = _mm_macc_ps(dx21,fscal,fix2);
            fiy2             = _mm_macc_ps(dy21,fscal,fiy2);
            fiz2             = _mm_macc_ps(dz21,fscal,fiz2);

            fjx1             = _mm_macc_ps(dx21,fscal,fjx1);
            fjy1             = _mm_macc_ps(dy21,fscal,fjy1);
            fjz1             = _mm_macc_ps(dz21,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq22,_mm_sub_ps(_mm_macc_ps(krf,rsq22,rinv22),crf));
            felec            = _mm_mul_ps(qq22,_mm_msub_ps(rinv22,rinvsq22,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix2             = _mm_macc_ps(dx22,fscal,fix2);
            fiy2             = _mm_macc_ps(dy22,fscal,fiy2);
            fiz2             = _mm_macc_ps(dz22,fscal,fiz2);

            fjx2             = _mm_macc_ps(dx22,fscal,fjx2);
            fjy2             = _mm_macc_ps(dy22,fscal,fjy2);
            fjz2             = _mm_macc_ps(dz22,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq23,_mm_sub_ps(_mm_macc_ps(krf,rsq23,rinv23),crf));
            felec            = _mm_mul_ps(qq23,_mm_msub_ps(rinv23,rinvsq23,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix2             = _mm_macc_ps(dx23,fscal,fix2);
            fiy2             = _mm_macc_ps(dy23,fscal,fiy2);
            fiz2             = _mm_macc_ps(dz23,fscal,fiz2);

            fjx3             = _mm_macc_ps(dx23,fscal,fjx3);
            fjy3             = _mm_macc_ps(dy23,fscal,fjy3);
            fjz3             = _mm_macc_ps(dz23,fscal,fjz3);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq31,_mm_sub_ps(_mm_macc_ps(krf,rsq31,rinv31),crf));
            felec            = _mm_mul_ps(qq31,_mm_msub_ps(rinv31,rinvsq31,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix3             = _mm_macc_ps(dx31,fscal,fix3);
            fiy3             = _mm_macc_ps(dy31,fscal,fiy3);
            fiz3             = _mm_macc_ps(dz31,fscal,fiz3);

            fjx1             = _mm_macc_ps(dx31,fscal,fjx1);
            fjy1             = _mm_macc_ps(dy31,fscal,fjy1);
            fjz1             = _mm_macc_ps(dz31,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq32,_mm_sub_ps(_mm_macc_ps(krf,rsq32,rinv32),crf));
            felec            = _mm_mul_ps(qq32,_mm_msub_ps(rinv32,rinvsq32,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix3             = _mm_macc_ps(dx32,fscal,fix3);
            fiy3             = _mm_macc_ps(dy32,fscal,fiy3);
            fiz3             = _mm_macc_ps(dz32,fscal,fiz3);

            fjx2             = _mm_macc_ps(dx32,fscal,fjx2);
            fjy2             = _mm_macc_ps(dy32,fscal,fjy2);
            fjz2             = _mm_macc_ps(dz32,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            velec            = _mm_mul_ps(qq33,_mm_sub_ps(_mm_macc_ps(krf,rsq33,rinv33),crf));
            felec            = _mm_mul_ps(qq33,_mm_msub_ps(rinv33,rinvsq33,krf2));

            /* Update potential sum for this i atom from the interaction with this j atom. */
            velec            = _mm_andnot_ps(dummy_mask,velec);
            velecsum         = _mm_add_ps(velecsum,velec);

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix3             = _mm_macc_ps(dx33,fscal,fix3);
            fiy3             = _mm_macc_ps(dy33,fscal,fiy3);
            fiz3             = _mm_macc_ps(dz33,fscal,fiz3);

            fjx3             = _mm_macc_ps(dx33,fscal,fjx3);
            fjy3             = _mm_macc_ps(dy33,fscal,fjy3);
            fjz3             = _mm_macc_ps(dz33,fscal,fjz3);

            fjptrA             = (jnrlistA>=0) ? f+j_coord_offsetA : scratch;
            fjptrB             = (jnrlistB>=0) ? f+j_coord_offsetB : scratch;
            fjptrC             = (jnrlistC>=0) ? f+j_coord_offsetC : scratch;
            fjptrD             = (jnrlistD>=0) ? f+j_coord_offsetD : scratch;

            gmx_mm_decrement_3rvec_4ptr_swizzle_ps(fjptrA+DIM,fjptrB+DIM,fjptrC+DIM,fjptrD+DIM,
                                                   fjx1,fjy1,fjz1,fjx2,fjy2,fjz2,fjx3,fjy3,fjz3);

            /* Inner loop uses 315 flops */
        }

        /* End of innermost loop */

        gmx_mm_update_iforce_3atom_swizzle_ps(fix1,fiy1,fiz1,fix2,fiy2,fiz2,fix3,fiy3,fiz3,
                                              f+i_coord_offset+DIM,fshift+i_shift_offset);

        ggid                        = gid[iidx];
        /* Update potential energies */
        gmx_mm_update_1pot_ps(velecsum,kernel_data->energygrp_elec+ggid);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 19 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_W4W4_VF,outeriter*19 + inneriter*315);
}
/*
 * Gromacs nonbonded kernel:   nb_kernel_ElecRF_VdwNone_GeomW4W4_F_avx_128_fma_single
 * Electrostatics interaction: ReactionField
 * VdW interaction:            None
 * Geometry:                   Water4-Water4
 * Calculate force/pot:        Force
 */
void
nb_kernel_ElecRF_VdwNone_GeomW4W4_F_avx_128_fma_single
                    (t_nblist                    * gmx_restrict       nlist,
                     rvec                        * gmx_restrict          xx,
                     rvec                        * gmx_restrict          ff,
                     struct t_forcerec           * gmx_restrict          fr,
                     t_mdatoms                   * gmx_restrict     mdatoms,
                     nb_kernel_data_t gmx_unused * gmx_restrict kernel_data,
                     t_nrnb                      * gmx_restrict        nrnb)
{
    /* Suffixes 0,1,2,3 refer to particle indices for waters in the inner or outer loop, or
     * just 0 for non-waters.
     * Suffixes A,B,C,D refer to j loop unrolling done with AVX_128, e.g. for the four different
     * jnr indices corresponding to data put in the four positions in the SIMD register.
     */
    int              i_shift_offset,i_coord_offset,outeriter,inneriter;
    int              j_index_start,j_index_end,jidx,nri,inr,ggid,iidx;
    int              jnrA,jnrB,jnrC,jnrD;
    int              jnrlistA,jnrlistB,jnrlistC,jnrlistD;
    int              j_coord_offsetA,j_coord_offsetB,j_coord_offsetC,j_coord_offsetD;
    int              *iinr,*jindex,*jjnr,*shiftidx,*gid;
    real             rcutoff_scalar;
    real             *shiftvec,*fshift,*x,*f;
    real             *fjptrA,*fjptrB,*fjptrC,*fjptrD;
    real             scratch[4*DIM];
    __m128           fscal,rcutoff,rcutoff2,jidxall;
    int              vdwioffset1;
    __m128           ix1,iy1,iz1,fix1,fiy1,fiz1,iq1,isai1;
    int              vdwioffset2;
    __m128           ix2,iy2,iz2,fix2,fiy2,fiz2,iq2,isai2;
    int              vdwioffset3;
    __m128           ix3,iy3,iz3,fix3,fiy3,fiz3,iq3,isai3;
    int              vdwjidx1A,vdwjidx1B,vdwjidx1C,vdwjidx1D;
    __m128           jx1,jy1,jz1,fjx1,fjy1,fjz1,jq1,isaj1;
    int              vdwjidx2A,vdwjidx2B,vdwjidx2C,vdwjidx2D;
    __m128           jx2,jy2,jz2,fjx2,fjy2,fjz2,jq2,isaj2;
    int              vdwjidx3A,vdwjidx3B,vdwjidx3C,vdwjidx3D;
    __m128           jx3,jy3,jz3,fjx3,fjy3,fjz3,jq3,isaj3;
    __m128           dx11,dy11,dz11,rsq11,rinv11,rinvsq11,r11,qq11,c6_11,c12_11;
    __m128           dx12,dy12,dz12,rsq12,rinv12,rinvsq12,r12,qq12,c6_12,c12_12;
    __m128           dx13,dy13,dz13,rsq13,rinv13,rinvsq13,r13,qq13,c6_13,c12_13;
    __m128           dx21,dy21,dz21,rsq21,rinv21,rinvsq21,r21,qq21,c6_21,c12_21;
    __m128           dx22,dy22,dz22,rsq22,rinv22,rinvsq22,r22,qq22,c6_22,c12_22;
    __m128           dx23,dy23,dz23,rsq23,rinv23,rinvsq23,r23,qq23,c6_23,c12_23;
    __m128           dx31,dy31,dz31,rsq31,rinv31,rinvsq31,r31,qq31,c6_31,c12_31;
    __m128           dx32,dy32,dz32,rsq32,rinv32,rinvsq32,r32,qq32,c6_32,c12_32;
    __m128           dx33,dy33,dz33,rsq33,rinv33,rinvsq33,r33,qq33,c6_33,c12_33;
    __m128           velec,felec,velecsum,facel,crf,krf,krf2;
    real             *charge;
    __m128           dummy_mask,cutoff_mask;
    __m128           signbit = _mm_castsi128_ps( _mm_set1_epi32(0x80000000) );
    __m128           one     = _mm_set1_ps(1.0);
    __m128           two     = _mm_set1_ps(2.0);
    x                = xx[0];
    f                = ff[0];

    nri              = nlist->nri;
    iinr             = nlist->iinr;
    jindex           = nlist->jindex;
    jjnr             = nlist->jjnr;
    shiftidx         = nlist->shift;
    gid              = nlist->gid;
    shiftvec         = fr->shift_vec[0];
    fshift           = fr->fshift[0];
    facel            = _mm_set1_ps(fr->ic->epsfac);
    charge           = mdatoms->chargeA;
    krf              = _mm_set1_ps(fr->ic->k_rf);
    krf2             = _mm_set1_ps(fr->ic->k_rf*2.0);
    crf              = _mm_set1_ps(fr->ic->c_rf);

    /* Setup water-specific parameters */
    inr              = nlist->iinr[0];
    iq1              = _mm_mul_ps(facel,_mm_set1_ps(charge[inr+1]));
    iq2              = _mm_mul_ps(facel,_mm_set1_ps(charge[inr+2]));
    iq3              = _mm_mul_ps(facel,_mm_set1_ps(charge[inr+3]));

    jq1              = _mm_set1_ps(charge[inr+1]);
    jq2              = _mm_set1_ps(charge[inr+2]);
    jq3              = _mm_set1_ps(charge[inr+3]);
    qq11             = _mm_mul_ps(iq1,jq1);
    qq12             = _mm_mul_ps(iq1,jq2);
    qq13             = _mm_mul_ps(iq1,jq3);
    qq21             = _mm_mul_ps(iq2,jq1);
    qq22             = _mm_mul_ps(iq2,jq2);
    qq23             = _mm_mul_ps(iq2,jq3);
    qq31             = _mm_mul_ps(iq3,jq1);
    qq32             = _mm_mul_ps(iq3,jq2);
    qq33             = _mm_mul_ps(iq3,jq3);

    /* Avoid stupid compiler warnings */
    jnrA = jnrB = jnrC = jnrD = 0;
    j_coord_offsetA = 0;
    j_coord_offsetB = 0;
    j_coord_offsetC = 0;
    j_coord_offsetD = 0;

    outeriter        = 0;
    inneriter        = 0;

    for(iidx=0;iidx<4*DIM;iidx++)
    {
        scratch[iidx] = 0.0;
    }

    /* Start outer loop over neighborlists */
    for(iidx=0; iidx<nri; iidx++)
    {
        /* Load shift vector for this list */
        i_shift_offset   = DIM*shiftidx[iidx];

        /* Load limits for loop over neighbors */
        j_index_start    = jindex[iidx];
        j_index_end      = jindex[iidx+1];

        /* Get outer coordinate index */
        inr              = iinr[iidx];
        i_coord_offset   = DIM*inr;

        /* Load i particle coords and add shift vector */
        gmx_mm_load_shift_and_3rvec_broadcast_ps(shiftvec+i_shift_offset,x+i_coord_offset+DIM,
                                                 &ix1,&iy1,&iz1,&ix2,&iy2,&iz2,&ix3,&iy3,&iz3);

        fix1             = _mm_setzero_ps();
        fiy1             = _mm_setzero_ps();
        fiz1             = _mm_setzero_ps();
        fix2             = _mm_setzero_ps();
        fiy2             = _mm_setzero_ps();
        fiz2             = _mm_setzero_ps();
        fix3             = _mm_setzero_ps();
        fiy3             = _mm_setzero_ps();
        fiz3             = _mm_setzero_ps();

        /* Start inner kernel loop */
        for(jidx=j_index_start; jidx<j_index_end && jjnr[jidx+3]>=0; jidx+=4)
        {

            /* Get j neighbor index, and coordinate index */
            jnrA             = jjnr[jidx];
            jnrB             = jjnr[jidx+1];
            jnrC             = jjnr[jidx+2];
            jnrD             = jjnr[jidx+3];
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_4ptr_swizzle_ps(x+j_coord_offsetA+DIM,x+j_coord_offsetB+DIM,
                                              x+j_coord_offsetC+DIM,x+j_coord_offsetD+DIM,
                                              &jx1,&jy1,&jz1,&jx2,&jy2,&jz2,&jx3,&jy3,&jz3);

            /* Calculate displacement vector */
            dx11             = _mm_sub_ps(ix1,jx1);
            dy11             = _mm_sub_ps(iy1,jy1);
            dz11             = _mm_sub_ps(iz1,jz1);
            dx12             = _mm_sub_ps(ix1,jx2);
            dy12             = _mm_sub_ps(iy1,jy2);
            dz12             = _mm_sub_ps(iz1,jz2);
            dx13             = _mm_sub_ps(ix1,jx3);
            dy13             = _mm_sub_ps(iy1,jy3);
            dz13             = _mm_sub_ps(iz1,jz3);
            dx21             = _mm_sub_ps(ix2,jx1);
            dy21             = _mm_sub_ps(iy2,jy1);
            dz21             = _mm_sub_ps(iz2,jz1);
            dx22             = _mm_sub_ps(ix2,jx2);
            dy22             = _mm_sub_ps(iy2,jy2);
            dz22             = _mm_sub_ps(iz2,jz2);
            dx23             = _mm_sub_ps(ix2,jx3);
            dy23             = _mm_sub_ps(iy2,jy3);
            dz23             = _mm_sub_ps(iz2,jz3);
            dx31             = _mm_sub_ps(ix3,jx1);
            dy31             = _mm_sub_ps(iy3,jy1);
            dz31             = _mm_sub_ps(iz3,jz1);
            dx32             = _mm_sub_ps(ix3,jx2);
            dy32             = _mm_sub_ps(iy3,jy2);
            dz32             = _mm_sub_ps(iz3,jz2);
            dx33             = _mm_sub_ps(ix3,jx3);
            dy33             = _mm_sub_ps(iy3,jy3);
            dz33             = _mm_sub_ps(iz3,jz3);

            /* Calculate squared distance and things based on it */
            rsq11            = gmx_mm_calc_rsq_ps(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_ps(dx12,dy12,dz12);
            rsq13            = gmx_mm_calc_rsq_ps(dx13,dy13,dz13);
            rsq21            = gmx_mm_calc_rsq_ps(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_ps(dx22,dy22,dz22);
            rsq23            = gmx_mm_calc_rsq_ps(dx23,dy23,dz23);
            rsq31            = gmx_mm_calc_rsq_ps(dx31,dy31,dz31);
            rsq32            = gmx_mm_calc_rsq_ps(dx32,dy32,dz32);
            rsq33            = gmx_mm_calc_rsq_ps(dx33,dy33,dz33);

            rinv11           = avx128fma_invsqrt_f(rsq11);
            rinv12           = avx128fma_invsqrt_f(rsq12);
            rinv13           = avx128fma_invsqrt_f(rsq13);
            rinv21           = avx128fma_invsqrt_f(rsq21);
            rinv22           = avx128fma_invsqrt_f(rsq22);
            rinv23           = avx128fma_invsqrt_f(rsq23);
            rinv31           = avx128fma_invsqrt_f(rsq31);
            rinv32           = avx128fma_invsqrt_f(rsq32);
            rinv33           = avx128fma_invsqrt_f(rsq33);

            rinvsq11         = _mm_mul_ps(rinv11,rinv11);
            rinvsq12         = _mm_mul_ps(rinv12,rinv12);
            rinvsq13         = _mm_mul_ps(rinv13,rinv13);
            rinvsq21         = _mm_mul_ps(rinv21,rinv21);
            rinvsq22         = _mm_mul_ps(rinv22,rinv22);
            rinvsq23         = _mm_mul_ps(rinv23,rinv23);
            rinvsq31         = _mm_mul_ps(rinv31,rinv31);
            rinvsq32         = _mm_mul_ps(rinv32,rinv32);
            rinvsq33         = _mm_mul_ps(rinv33,rinv33);

            fjx1             = _mm_setzero_ps();
            fjy1             = _mm_setzero_ps();
            fjz1             = _mm_setzero_ps();
            fjx2             = _mm_setzero_ps();
            fjy2             = _mm_setzero_ps();
            fjz2             = _mm_setzero_ps();
            fjx3             = _mm_setzero_ps();
            fjy3             = _mm_setzero_ps();
            fjz3             = _mm_setzero_ps();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq11,_mm_msub_ps(rinv11,rinvsq11,krf2));

            fscal            = felec;

             /* Update vectorial force */
            fix1             = _mm_macc_ps(dx11,fscal,fix1);
            fiy1             = _mm_macc_ps(dy11,fscal,fiy1);
            fiz1             = _mm_macc_ps(dz11,fscal,fiz1);

            fjx1             = _mm_macc_ps(dx11,fscal,fjx1);
            fjy1             = _mm_macc_ps(dy11,fscal,fjy1);
            fjz1             = _mm_macc_ps(dz11,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq12,_mm_msub_ps(rinv12,rinvsq12,krf2));

            fscal            = felec;

             /* Update vectorial force */
            fix1             = _mm_macc_ps(dx12,fscal,fix1);
            fiy1             = _mm_macc_ps(dy12,fscal,fiy1);
            fiz1             = _mm_macc_ps(dz12,fscal,fiz1);

            fjx2             = _mm_macc_ps(dx12,fscal,fjx2);
            fjy2             = _mm_macc_ps(dy12,fscal,fjy2);
            fjz2             = _mm_macc_ps(dz12,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq13,_mm_msub_ps(rinv13,rinvsq13,krf2));

            fscal            = felec;

             /* Update vectorial force */
            fix1             = _mm_macc_ps(dx13,fscal,fix1);
            fiy1             = _mm_macc_ps(dy13,fscal,fiy1);
            fiz1             = _mm_macc_ps(dz13,fscal,fiz1);

            fjx3             = _mm_macc_ps(dx13,fscal,fjx3);
            fjy3             = _mm_macc_ps(dy13,fscal,fjy3);
            fjz3             = _mm_macc_ps(dz13,fscal,fjz3);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq21,_mm_msub_ps(rinv21,rinvsq21,krf2));

            fscal            = felec;

             /* Update vectorial force */
            fix2             = _mm_macc_ps(dx21,fscal,fix2);
            fiy2             = _mm_macc_ps(dy21,fscal,fiy2);
            fiz2             = _mm_macc_ps(dz21,fscal,fiz2);

            fjx1             = _mm_macc_ps(dx21,fscal,fjx1);
            fjy1             = _mm_macc_ps(dy21,fscal,fjy1);
            fjz1             = _mm_macc_ps(dz21,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq22,_mm_msub_ps(rinv22,rinvsq22,krf2));

            fscal            = felec;

             /* Update vectorial force */
            fix2             = _mm_macc_ps(dx22,fscal,fix2);
            fiy2             = _mm_macc_ps(dy22,fscal,fiy2);
            fiz2             = _mm_macc_ps(dz22,fscal,fiz2);

            fjx2             = _mm_macc_ps(dx22,fscal,fjx2);
            fjy2             = _mm_macc_ps(dy22,fscal,fjy2);
            fjz2             = _mm_macc_ps(dz22,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq23,_mm_msub_ps(rinv23,rinvsq23,krf2));

            fscal            = felec;

             /* Update vectorial force */
            fix2             = _mm_macc_ps(dx23,fscal,fix2);
            fiy2             = _mm_macc_ps(dy23,fscal,fiy2);
            fiz2             = _mm_macc_ps(dz23,fscal,fiz2);

            fjx3             = _mm_macc_ps(dx23,fscal,fjx3);
            fjy3             = _mm_macc_ps(dy23,fscal,fjy3);
            fjz3             = _mm_macc_ps(dz23,fscal,fjz3);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq31,_mm_msub_ps(rinv31,rinvsq31,krf2));

            fscal            = felec;

             /* Update vectorial force */
            fix3             = _mm_macc_ps(dx31,fscal,fix3);
            fiy3             = _mm_macc_ps(dy31,fscal,fiy3);
            fiz3             = _mm_macc_ps(dz31,fscal,fiz3);

            fjx1             = _mm_macc_ps(dx31,fscal,fjx1);
            fjy1             = _mm_macc_ps(dy31,fscal,fjy1);
            fjz1             = _mm_macc_ps(dz31,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq32,_mm_msub_ps(rinv32,rinvsq32,krf2));

            fscal            = felec;

             /* Update vectorial force */
            fix3             = _mm_macc_ps(dx32,fscal,fix3);
            fiy3             = _mm_macc_ps(dy32,fscal,fiy3);
            fiz3             = _mm_macc_ps(dz32,fscal,fiz3);

            fjx2             = _mm_macc_ps(dx32,fscal,fjx2);
            fjy2             = _mm_macc_ps(dy32,fscal,fjy2);
            fjz2             = _mm_macc_ps(dz32,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq33,_mm_msub_ps(rinv33,rinvsq33,krf2));

            fscal            = felec;

             /* Update vectorial force */
            fix3             = _mm_macc_ps(dx33,fscal,fix3);
            fiy3             = _mm_macc_ps(dy33,fscal,fiy3);
            fiz3             = _mm_macc_ps(dz33,fscal,fiz3);

            fjx3             = _mm_macc_ps(dx33,fscal,fjx3);
            fjy3             = _mm_macc_ps(dy33,fscal,fjy3);
            fjz3             = _mm_macc_ps(dz33,fscal,fjz3);

            fjptrA             = f+j_coord_offsetA;
            fjptrB             = f+j_coord_offsetB;
            fjptrC             = f+j_coord_offsetC;
            fjptrD             = f+j_coord_offsetD;

            gmx_mm_decrement_3rvec_4ptr_swizzle_ps(fjptrA+DIM,fjptrB+DIM,fjptrC+DIM,fjptrD+DIM,
                                                   fjx1,fjy1,fjz1,fjx2,fjy2,fjz2,fjx3,fjy3,fjz3);

            /* Inner loop uses 270 flops */
        }

        if(jidx<j_index_end)
        {

            /* Get j neighbor index, and coordinate index */
            jnrlistA         = jjnr[jidx];
            jnrlistB         = jjnr[jidx+1];
            jnrlistC         = jjnr[jidx+2];
            jnrlistD         = jjnr[jidx+3];
            /* Sign of each element will be negative for non-real atoms.
             * This mask will be 0xFFFFFFFF for dummy entries and 0x0 for real ones,
             * so use it as val = _mm_andnot_ps(mask,val) to clear dummy entries.
             */
            dummy_mask = gmx_mm_castsi128_ps(_mm_cmplt_epi32(_mm_loadu_si128((const __m128i *)(jjnr+jidx)),_mm_setzero_si128()));
            jnrA       = (jnrlistA>=0) ? jnrlistA : 0;
            jnrB       = (jnrlistB>=0) ? jnrlistB : 0;
            jnrC       = (jnrlistC>=0) ? jnrlistC : 0;
            jnrD       = (jnrlistD>=0) ? jnrlistD : 0;
            j_coord_offsetA  = DIM*jnrA;
            j_coord_offsetB  = DIM*jnrB;
            j_coord_offsetC  = DIM*jnrC;
            j_coord_offsetD  = DIM*jnrD;

            /* load j atom coordinates */
            gmx_mm_load_3rvec_4ptr_swizzle_ps(x+j_coord_offsetA+DIM,x+j_coord_offsetB+DIM,
                                              x+j_coord_offsetC+DIM,x+j_coord_offsetD+DIM,
                                              &jx1,&jy1,&jz1,&jx2,&jy2,&jz2,&jx3,&jy3,&jz3);

            /* Calculate displacement vector */
            dx11             = _mm_sub_ps(ix1,jx1);
            dy11             = _mm_sub_ps(iy1,jy1);
            dz11             = _mm_sub_ps(iz1,jz1);
            dx12             = _mm_sub_ps(ix1,jx2);
            dy12             = _mm_sub_ps(iy1,jy2);
            dz12             = _mm_sub_ps(iz1,jz2);
            dx13             = _mm_sub_ps(ix1,jx3);
            dy13             = _mm_sub_ps(iy1,jy3);
            dz13             = _mm_sub_ps(iz1,jz3);
            dx21             = _mm_sub_ps(ix2,jx1);
            dy21             = _mm_sub_ps(iy2,jy1);
            dz21             = _mm_sub_ps(iz2,jz1);
            dx22             = _mm_sub_ps(ix2,jx2);
            dy22             = _mm_sub_ps(iy2,jy2);
            dz22             = _mm_sub_ps(iz2,jz2);
            dx23             = _mm_sub_ps(ix2,jx3);
            dy23             = _mm_sub_ps(iy2,jy3);
            dz23             = _mm_sub_ps(iz2,jz3);
            dx31             = _mm_sub_ps(ix3,jx1);
            dy31             = _mm_sub_ps(iy3,jy1);
            dz31             = _mm_sub_ps(iz3,jz1);
            dx32             = _mm_sub_ps(ix3,jx2);
            dy32             = _mm_sub_ps(iy3,jy2);
            dz32             = _mm_sub_ps(iz3,jz2);
            dx33             = _mm_sub_ps(ix3,jx3);
            dy33             = _mm_sub_ps(iy3,jy3);
            dz33             = _mm_sub_ps(iz3,jz3);

            /* Calculate squared distance and things based on it */
            rsq11            = gmx_mm_calc_rsq_ps(dx11,dy11,dz11);
            rsq12            = gmx_mm_calc_rsq_ps(dx12,dy12,dz12);
            rsq13            = gmx_mm_calc_rsq_ps(dx13,dy13,dz13);
            rsq21            = gmx_mm_calc_rsq_ps(dx21,dy21,dz21);
            rsq22            = gmx_mm_calc_rsq_ps(dx22,dy22,dz22);
            rsq23            = gmx_mm_calc_rsq_ps(dx23,dy23,dz23);
            rsq31            = gmx_mm_calc_rsq_ps(dx31,dy31,dz31);
            rsq32            = gmx_mm_calc_rsq_ps(dx32,dy32,dz32);
            rsq33            = gmx_mm_calc_rsq_ps(dx33,dy33,dz33);

            rinv11           = avx128fma_invsqrt_f(rsq11);
            rinv12           = avx128fma_invsqrt_f(rsq12);
            rinv13           = avx128fma_invsqrt_f(rsq13);
            rinv21           = avx128fma_invsqrt_f(rsq21);
            rinv22           = avx128fma_invsqrt_f(rsq22);
            rinv23           = avx128fma_invsqrt_f(rsq23);
            rinv31           = avx128fma_invsqrt_f(rsq31);
            rinv32           = avx128fma_invsqrt_f(rsq32);
            rinv33           = avx128fma_invsqrt_f(rsq33);

            rinvsq11         = _mm_mul_ps(rinv11,rinv11);
            rinvsq12         = _mm_mul_ps(rinv12,rinv12);
            rinvsq13         = _mm_mul_ps(rinv13,rinv13);
            rinvsq21         = _mm_mul_ps(rinv21,rinv21);
            rinvsq22         = _mm_mul_ps(rinv22,rinv22);
            rinvsq23         = _mm_mul_ps(rinv23,rinv23);
            rinvsq31         = _mm_mul_ps(rinv31,rinv31);
            rinvsq32         = _mm_mul_ps(rinv32,rinv32);
            rinvsq33         = _mm_mul_ps(rinv33,rinv33);

            fjx1             = _mm_setzero_ps();
            fjy1             = _mm_setzero_ps();
            fjz1             = _mm_setzero_ps();
            fjx2             = _mm_setzero_ps();
            fjy2             = _mm_setzero_ps();
            fjz2             = _mm_setzero_ps();
            fjx3             = _mm_setzero_ps();
            fjy3             = _mm_setzero_ps();
            fjz3             = _mm_setzero_ps();

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq11,_mm_msub_ps(rinv11,rinvsq11,krf2));

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix1             = _mm_macc_ps(dx11,fscal,fix1);
            fiy1             = _mm_macc_ps(dy11,fscal,fiy1);
            fiz1             = _mm_macc_ps(dz11,fscal,fiz1);

            fjx1             = _mm_macc_ps(dx11,fscal,fjx1);
            fjy1             = _mm_macc_ps(dy11,fscal,fjy1);
            fjz1             = _mm_macc_ps(dz11,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq12,_mm_msub_ps(rinv12,rinvsq12,krf2));

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix1             = _mm_macc_ps(dx12,fscal,fix1);
            fiy1             = _mm_macc_ps(dy12,fscal,fiy1);
            fiz1             = _mm_macc_ps(dz12,fscal,fiz1);

            fjx2             = _mm_macc_ps(dx12,fscal,fjx2);
            fjy2             = _mm_macc_ps(dy12,fscal,fjy2);
            fjz2             = _mm_macc_ps(dz12,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq13,_mm_msub_ps(rinv13,rinvsq13,krf2));

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix1             = _mm_macc_ps(dx13,fscal,fix1);
            fiy1             = _mm_macc_ps(dy13,fscal,fiy1);
            fiz1             = _mm_macc_ps(dz13,fscal,fiz1);

            fjx3             = _mm_macc_ps(dx13,fscal,fjx3);
            fjy3             = _mm_macc_ps(dy13,fscal,fjy3);
            fjz3             = _mm_macc_ps(dz13,fscal,fjz3);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq21,_mm_msub_ps(rinv21,rinvsq21,krf2));

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix2             = _mm_macc_ps(dx21,fscal,fix2);
            fiy2             = _mm_macc_ps(dy21,fscal,fiy2);
            fiz2             = _mm_macc_ps(dz21,fscal,fiz2);

            fjx1             = _mm_macc_ps(dx21,fscal,fjx1);
            fjy1             = _mm_macc_ps(dy21,fscal,fjy1);
            fjz1             = _mm_macc_ps(dz21,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq22,_mm_msub_ps(rinv22,rinvsq22,krf2));

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix2             = _mm_macc_ps(dx22,fscal,fix2);
            fiy2             = _mm_macc_ps(dy22,fscal,fiy2);
            fiz2             = _mm_macc_ps(dz22,fscal,fiz2);

            fjx2             = _mm_macc_ps(dx22,fscal,fjx2);
            fjy2             = _mm_macc_ps(dy22,fscal,fjy2);
            fjz2             = _mm_macc_ps(dz22,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq23,_mm_msub_ps(rinv23,rinvsq23,krf2));

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix2             = _mm_macc_ps(dx23,fscal,fix2);
            fiy2             = _mm_macc_ps(dy23,fscal,fiy2);
            fiz2             = _mm_macc_ps(dz23,fscal,fiz2);

            fjx3             = _mm_macc_ps(dx23,fscal,fjx3);
            fjy3             = _mm_macc_ps(dy23,fscal,fjy3);
            fjz3             = _mm_macc_ps(dz23,fscal,fjz3);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq31,_mm_msub_ps(rinv31,rinvsq31,krf2));

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix3             = _mm_macc_ps(dx31,fscal,fix3);
            fiy3             = _mm_macc_ps(dy31,fscal,fiy3);
            fiz3             = _mm_macc_ps(dz31,fscal,fiz3);

            fjx1             = _mm_macc_ps(dx31,fscal,fjx1);
            fjy1             = _mm_macc_ps(dy31,fscal,fjy1);
            fjz1             = _mm_macc_ps(dz31,fscal,fjz1);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq32,_mm_msub_ps(rinv32,rinvsq32,krf2));

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix3             = _mm_macc_ps(dx32,fscal,fix3);
            fiy3             = _mm_macc_ps(dy32,fscal,fiy3);
            fiz3             = _mm_macc_ps(dz32,fscal,fiz3);

            fjx2             = _mm_macc_ps(dx32,fscal,fjx2);
            fjy2             = _mm_macc_ps(dy32,fscal,fjy2);
            fjz2             = _mm_macc_ps(dz32,fscal,fjz2);

            /**************************
             * CALCULATE INTERACTIONS *
             **************************/

            /* REACTION-FIELD ELECTROSTATICS */
            felec            = _mm_mul_ps(qq33,_mm_msub_ps(rinv33,rinvsq33,krf2));

            fscal            = felec;

            fscal            = _mm_andnot_ps(dummy_mask,fscal);

             /* Update vectorial force */
            fix3             = _mm_macc_ps(dx33,fscal,fix3);
            fiy3             = _mm_macc_ps(dy33,fscal,fiy3);
            fiz3             = _mm_macc_ps(dz33,fscal,fiz3);

            fjx3             = _mm_macc_ps(dx33,fscal,fjx3);
            fjy3             = _mm_macc_ps(dy33,fscal,fjy3);
            fjz3             = _mm_macc_ps(dz33,fscal,fjz3);

            fjptrA             = (jnrlistA>=0) ? f+j_coord_offsetA : scratch;
            fjptrB             = (jnrlistB>=0) ? f+j_coord_offsetB : scratch;
            fjptrC             = (jnrlistC>=0) ? f+j_coord_offsetC : scratch;
            fjptrD             = (jnrlistD>=0) ? f+j_coord_offsetD : scratch;

            gmx_mm_decrement_3rvec_4ptr_swizzle_ps(fjptrA+DIM,fjptrB+DIM,fjptrC+DIM,fjptrD+DIM,
                                                   fjx1,fjy1,fjz1,fjx2,fjy2,fjz2,fjx3,fjy3,fjz3);

            /* Inner loop uses 270 flops */
        }

        /* End of innermost loop */

        gmx_mm_update_iforce_3atom_swizzle_ps(fix1,fiy1,fiz1,fix2,fiy2,fiz2,fix3,fiy3,fiz3,
                                              f+i_coord_offset+DIM,fshift+i_shift_offset);

        /* Increment number of inner iterations */
        inneriter                  += j_index_end - j_index_start;

        /* Outer loop uses 18 flops */
    }

    /* Increment number of outer iterations */
    outeriter        += nri;

    /* Update outer/inner flops */

    inc_nrnb(nrnb,eNR_NBKERNEL_ELEC_W4W4_F,outeriter*18 + inneriter*270);
}
