/*
 * $Id: gmx_random_gausstable.h,v 1.1.4.2 2008/02/29 07:02:43 spoel Exp $
 * 
 *                This source code is part of
 * 
 *                 G   R   O   M   A   C   S
 * 
 *          GROningen MAchine for Chemical Simulations
 * 
 *                        VERSION 3.3.3
 * Written by David van der Spoel, Erik Lindahl, Berk Hess, and others.
 * Copyright (c) 1991-2000, University of Groningen, The Netherlands.
 * Copyright (c) 2001-2008, The GROMACS development team,
 * check out http://www.gromacs.org for more information.

 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * If you want to redistribute modifications, please consider that
 * scientific software is very special. Version control is crucial -
 * bugs must be traceable. We will be happy to consider code for
 * inclusion in the official distribution, but derived work must not
 * be called official GROMACS. Details are found in the README & COPYING
 * files - if they are missing, get the official version at www.gromacs.org.
 * 
 * To help us fund GROMACS development, we humbly ask that you cite
 * the papers on the package - you can find them in the top README file.
 * 
 * For more info, check our website at http://www.gromacs.org
 * 
 * And Hey:
 * Groningen Machine for Chemical Simulation
 */
static const real 
gaussian_table[16384] = {
  -4.0255485e+00,-3.7595601e+00,-3.6167130e+00,-3.5255561e+00,
  -3.4572146e+00,-3.4021609e+00,-3.3558927e+00,-3.3158946e+00,
  -3.2806098e+00,-3.2490034e+00,-3.2203522e+00,-3.1941290e+00,
  -3.1699378e+00,-3.1474738e+00,-3.1264958e+00,-3.1068115e+00,
  -3.0882633e+00,-3.0707211e+00,-3.0540769e+00,-3.0382385e+00,
  -3.0231280e+00,-3.0086782e+00,-2.9948308e+00,-2.9815352e+00,
  -2.9687471e+00,-2.9564269e+00,-2.9445398e+00,-2.9330549e+00,
  -2.9219446e+00,-2.9111838e+00,-2.9007499e+00,-2.8906226e+00,
  -2.8807836e+00,-2.8712158e+00,-2.8619039e+00,-2.8528337e+00,
  -2.8439925e+00,-2.8353682e+00,-2.8269496e+00,-2.8187268e+00,
  -2.8106904e+00,-2.8028316e+00,-2.7951422e+00,-2.7876146e+00,
  -2.7802417e+00,-2.7730169e+00,-2.7659342e+00,-2.7589874e+00,
  -2.7521713e+00,-2.7454808e+00,-2.7389109e+00,-2.7324574e+00,
  -2.7261155e+00,-2.7198815e+00,-2.7137513e+00,-2.7077217e+00,
  -2.7017887e+00,-2.6959493e+00,-2.6902006e+00,-2.6845396e+00,
  -2.6789629e+00,-2.6734686e+00,-2.6680539e+00,-2.6627162e+00,
  -2.6574533e+00,-2.6522629e+00,-2.6471431e+00,-2.6420918e+00,
  -2.6371069e+00,-2.6321869e+00,-2.6273296e+00,-2.6225336e+00,
  -2.6177971e+00,-2.6131189e+00,-2.6084969e+00,-2.6039300e+00,
  -2.5994170e+00,-2.5949562e+00,-2.5905464e+00,-2.5861864e+00,
  -2.5818748e+00,-2.5776110e+00,-2.5733936e+00,-2.5692213e+00,
  -2.5650933e+00,-2.5610085e+00,-2.5569661e+00,-2.5529649e+00,
  -2.5490043e+00,-2.5450833e+00,-2.5412009e+00,-2.5373566e+00,
  -2.5335493e+00,-2.5297785e+00,-2.5260432e+00,-2.5223429e+00,
  -2.5186768e+00,-2.5150442e+00,-2.5114446e+00,-2.5078771e+00,
  -2.5043414e+00,-2.5008366e+00,-2.4973624e+00,-2.4939179e+00,
  -2.4905028e+00,-2.4871166e+00,-2.4837587e+00,-2.4804285e+00,
  -2.4771256e+00,-2.4738493e+00,-2.4705997e+00,-2.4673758e+00,
  -2.4641774e+00,-2.4610038e+00,-2.4578550e+00,-2.4547303e+00,
  -2.4516294e+00,-2.4485519e+00,-2.4454975e+00,-2.4424658e+00,
  -2.4394562e+00,-2.4364686e+00,-2.4335027e+00,-2.4305577e+00,
  -2.4276340e+00,-2.4247308e+00,-2.4218478e+00,-2.4189849e+00,
  -2.4161417e+00,-2.4133179e+00,-2.4105132e+00,-2.4077272e+00,
  -2.4049599e+00,-2.4022110e+00,-2.3994799e+00,-2.3967667e+00,
  -2.3940709e+00,-2.3913925e+00,-2.3887312e+00,-2.3860867e+00,
  -2.3834586e+00,-2.3808472e+00,-2.3782516e+00,-2.3756721e+00,
  -2.3731084e+00,-2.3705599e+00,-2.3680270e+00,-2.3655090e+00,
  -2.3630061e+00,-2.3605177e+00,-2.3580439e+00,-2.3555846e+00,
  -2.3531394e+00,-2.3507080e+00,-2.3482907e+00,-2.3458867e+00,
  -2.3434966e+00,-2.3411195e+00,-2.3387556e+00,-2.3364048e+00,
  -2.3340669e+00,-2.3317413e+00,-2.3294287e+00,-2.3271282e+00,
  -2.3248401e+00,-2.3225641e+00,-2.3203001e+00,-2.3180478e+00,
  -2.3158073e+00,-2.3135784e+00,-2.3113608e+00,-2.3091545e+00,
  -2.3069596e+00,-2.3047755e+00,-2.3026025e+00,-2.3004403e+00,
  -2.2982888e+00,-2.2961478e+00,-2.2940173e+00,-2.2918973e+00,
  -2.2897875e+00,-2.2876878e+00,-2.2855980e+00,-2.2835183e+00,
  -2.2814484e+00,-2.2793882e+00,-2.2773378e+00,-2.2752967e+00,
  -2.2732651e+00,-2.2712429e+00,-2.2692299e+00,-2.2672260e+00,
  -2.2652314e+00,-2.2632456e+00,-2.2612686e+00,-2.2593005e+00,
  -2.2573411e+00,-2.2553902e+00,-2.2534480e+00,-2.2515142e+00,
  -2.2495890e+00,-2.2476718e+00,-2.2457631e+00,-2.2438622e+00,
  -2.2419696e+00,-2.2400849e+00,-2.2382083e+00,-2.2363393e+00,
  -2.2344782e+00,-2.2326250e+00,-2.2307792e+00,-2.2289410e+00,
  -2.2271104e+00,-2.2252872e+00,-2.2234712e+00,-2.2216625e+00,
  -2.2198613e+00,-2.2180672e+00,-2.2162802e+00,-2.2145002e+00,
  -2.2127271e+00,-2.2109611e+00,-2.2092018e+00,-2.2074494e+00,
  -2.2057037e+00,-2.2039647e+00,-2.2022326e+00,-2.2005067e+00,
  -2.1987877e+00,-2.1970749e+00,-2.1953685e+00,-2.1936686e+00,
  -2.1919749e+00,-2.1902876e+00,-2.1886065e+00,-2.1869316e+00,
  -2.1852627e+00,-2.1835999e+00,-2.1819429e+00,-2.1802921e+00,
  -2.1786473e+00,-2.1770084e+00,-2.1753752e+00,-2.1737478e+00,
  -2.1721261e+00,-2.1705101e+00,-2.1688998e+00,-2.1672950e+00,
  -2.1656959e+00,-2.1641021e+00,-2.1625140e+00,-2.1609311e+00,
  -2.1593540e+00,-2.1577818e+00,-2.1562152e+00,-2.1546538e+00,
  -2.1530976e+00,-2.1515467e+00,-2.1500008e+00,-2.1484601e+00,
  -2.1469245e+00,-2.1453941e+00,-2.1438684e+00,-2.1423478e+00,
  -2.1408322e+00,-2.1393216e+00,-2.1378157e+00,-2.1363146e+00,
  -2.1348183e+00,-2.1333268e+00,-2.1318402e+00,-2.1303580e+00,
  -2.1288807e+00,-2.1274080e+00,-2.1259398e+00,-2.1244762e+00,
  -2.1230171e+00,-2.1215627e+00,-2.1201127e+00,-2.1186669e+00,
  -2.1172256e+00,-2.1157889e+00,-2.1143565e+00,-2.1129284e+00,
  -2.1115043e+00,-2.1100848e+00,-2.1086695e+00,-2.1072583e+00,
  -2.1058514e+00,-2.1044486e+00,-2.1030500e+00,-2.1016555e+00,
  -2.1002650e+00,-2.0988786e+00,-2.0974960e+00,-2.0961177e+00,
  -2.0947433e+00,-2.0933728e+00,-2.0920062e+00,-2.0906434e+00,
  -2.0892847e+00,-2.0879297e+00,-2.0865786e+00,-2.0852313e+00,
  -2.0838876e+00,-2.0825479e+00,-2.0812118e+00,-2.0798793e+00,
  -2.0785506e+00,-2.0772257e+00,-2.0759041e+00,-2.0745864e+00,
  -2.0732722e+00,-2.0719616e+00,-2.0706546e+00,-2.0693510e+00,
  -2.0680509e+00,-2.0667543e+00,-2.0654614e+00,-2.0641716e+00,
  -2.0628855e+00,-2.0616026e+00,-2.0603232e+00,-2.0590472e+00,
  -2.0577743e+00,-2.0565050e+00,-2.0552390e+00,-2.0539761e+00,
  -2.0527165e+00,-2.0514603e+00,-2.0502071e+00,-2.0489573e+00,
  -2.0477107e+00,-2.0464671e+00,-2.0452268e+00,-2.0439897e+00,
  -2.0427556e+00,-2.0415246e+00,-2.0402968e+00,-2.0390718e+00,
  -2.0378501e+00,-2.0366313e+00,-2.0354156e+00,-2.0342031e+00,
  -2.0329933e+00,-2.0317864e+00,-2.0305827e+00,-2.0293818e+00,
  -2.0281839e+00,-2.0269887e+00,-2.0257967e+00,-2.0246074e+00,
  -2.0234210e+00,-2.0222373e+00,-2.0210567e+00,-2.0198786e+00,
  -2.0187035e+00,-2.0175312e+00,-2.0163615e+00,-2.0151947e+00,
  -2.0140305e+00,-2.0128691e+00,-2.0117104e+00,-2.0105543e+00,
  -2.0094011e+00,-2.0082505e+00,-2.0071025e+00,-2.0059571e+00,
  -2.0048144e+00,-2.0036743e+00,-2.0025368e+00,-2.0014019e+00,
  -2.0002694e+00,-1.9991397e+00,-1.9980124e+00,-1.9968877e+00,
  -1.9957654e+00,-1.9946458e+00,-1.9935286e+00,-1.9924139e+00,
  -1.9913017e+00,-1.9901918e+00,-1.9890845e+00,-1.9879795e+00,
  -1.9868771e+00,-1.9857770e+00,-1.9846793e+00,-1.9835840e+00,
  -1.9824911e+00,-1.9814006e+00,-1.9803123e+00,-1.9792265e+00,
  -1.9781430e+00,-1.9770617e+00,-1.9759828e+00,-1.9749062e+00,
  -1.9738319e+00,-1.9727598e+00,-1.9716901e+00,-1.9706224e+00,
  -1.9695572e+00,-1.9684941e+00,-1.9674332e+00,-1.9663746e+00,
  -1.9653181e+00,-1.9642639e+00,-1.9632118e+00,-1.9621619e+00,
  -1.9611142e+00,-1.9600686e+00,-1.9590250e+00,-1.9579837e+00,
  -1.9569446e+00,-1.9559075e+00,-1.9548724e+00,-1.9538395e+00,
  -1.9528086e+00,-1.9517798e+00,-1.9507532e+00,-1.9497285e+00,
  -1.9487059e+00,-1.9476854e+00,-1.9466668e+00,-1.9456502e+00,
  -1.9446357e+00,-1.9436232e+00,-1.9426126e+00,-1.9416041e+00,
  -1.9405975e+00,-1.9395928e+00,-1.9385902e+00,-1.9375895e+00,
  -1.9365907e+00,-1.9355938e+00,-1.9345989e+00,-1.9336058e+00,
  -1.9326147e+00,-1.9316255e+00,-1.9306381e+00,-1.9296527e+00,
  -1.9286691e+00,-1.9276873e+00,-1.9267074e+00,-1.9257294e+00,
  -1.9247532e+00,-1.9237788e+00,-1.9228063e+00,-1.9218355e+00,
  -1.9208666e+00,-1.9198995e+00,-1.9189342e+00,-1.9179707e+00,
  -1.9170089e+00,-1.9160489e+00,-1.9150907e+00,-1.9141341e+00,
  -1.9131794e+00,-1.9122264e+00,-1.9112751e+00,-1.9103256e+00,
  -1.9093778e+00,-1.9084318e+00,-1.9074874e+00,-1.9065447e+00,
  -1.9056036e+00,-1.9046643e+00,-1.9037267e+00,-1.9027907e+00,
  -1.9018564e+00,-1.9009237e+00,-1.8999927e+00,-1.8990633e+00,
  -1.8981357e+00,-1.8972095e+00,-1.8962852e+00,-1.8953623e+00,
  -1.8944410e+00,-1.8935214e+00,-1.8926034e+00,-1.8916869e+00,
  -1.8907721e+00,-1.8898588e+00,-1.8889471e+00,-1.8880370e+00,
  -1.8871284e+00,-1.8862214e+00,-1.8853159e+00,-1.8844121e+00,
  -1.8835096e+00,-1.8826088e+00,-1.8817095e+00,-1.8808116e+00,
  -1.8799154e+00,-1.8790206e+00,-1.8781272e+00,-1.8772354e+00,
  -1.8763452e+00,-1.8754563e+00,-1.8745691e+00,-1.8736831e+00,
  -1.8727987e+00,-1.8719158e+00,-1.8710344e+00,-1.8701543e+00,
  -1.8692757e+00,-1.8683985e+00,-1.8675228e+00,-1.8666486e+00,
  -1.8657757e+00,-1.8649043e+00,-1.8640343e+00,-1.8631657e+00,
  -1.8622985e+00,-1.8614327e+00,-1.8605683e+00,-1.8597052e+00,
  -1.8588436e+00,-1.8579834e+00,-1.8571244e+00,-1.8562670e+00,
  -1.8554108e+00,-1.8545560e+00,-1.8537025e+00,-1.8528504e+00,
  -1.8519996e+00,-1.8511503e+00,-1.8503022e+00,-1.8494554e+00,
  -1.8486099e+00,-1.8477658e+00,-1.8469231e+00,-1.8460816e+00,
  -1.8452414e+00,-1.8444026e+00,-1.8435649e+00,-1.8427286e+00,
  -1.8418936e+00,-1.8410599e+00,-1.8402274e+00,-1.8393962e+00,
  -1.8385663e+00,-1.8377377e+00,-1.8369104e+00,-1.8360841e+00,
  -1.8352593e+00,-1.8344357e+00,-1.8336133e+00,-1.8327922e+00,
  -1.8319722e+00,-1.8311535e+00,-1.8303361e+00,-1.8295199e+00,
  -1.8287048e+00,-1.8278910e+00,-1.8270785e+00,-1.8262670e+00,
  -1.8254569e+00,-1.8246478e+00,-1.8238400e+00,-1.8230335e+00,
  -1.8222280e+00,-1.8214238e+00,-1.8206207e+00,-1.8198187e+00,
  -1.8190180e+00,-1.8182185e+00,-1.8174200e+00,-1.8166227e+00,
  -1.8158267e+00,-1.8150318e+00,-1.8142380e+00,-1.8134452e+00,
  -1.8126537e+00,-1.8118633e+00,-1.8110740e+00,-1.8102859e+00,
  -1.8094989e+00,-1.8087131e+00,-1.8079282e+00,-1.8071445e+00,
  -1.8063620e+00,-1.8055806e+00,-1.8048003e+00,-1.8040210e+00,
  -1.8032428e+00,-1.8024657e+00,-1.8016897e+00,-1.8009149e+00,
  -1.8001410e+00,-1.7993683e+00,-1.7985966e+00,-1.7978261e+00,
  -1.7970564e+00,-1.7962880e+00,-1.7955205e+00,-1.7947543e+00,
  -1.7939889e+00,-1.7932247e+00,-1.7924615e+00,-1.7916993e+00,
  -1.7909381e+00,-1.7901781e+00,-1.7894191e+00,-1.7886610e+00,
  -1.7879040e+00,-1.7871480e+00,-1.7863930e+00,-1.7856392e+00,
  -1.7848862e+00,-1.7841343e+00,-1.7833834e+00,-1.7826334e+00,
  -1.7818846e+00,-1.7811366e+00,-1.7803898e+00,-1.7796438e+00,
  -1.7788988e+00,-1.7781550e+00,-1.7774119e+00,-1.7766700e+00,
  -1.7759290e+00,-1.7751889e+00,-1.7744499e+00,-1.7737118e+00,
  -1.7729746e+00,-1.7722385e+00,-1.7715033e+00,-1.7707690e+00,
  -1.7700357e+00,-1.7693034e+00,-1.7685720e+00,-1.7678416e+00,
  -1.7671120e+00,-1.7663834e+00,-1.7656559e+00,-1.7649292e+00,
  -1.7642033e+00,-1.7634785e+00,-1.7627546e+00,-1.7620316e+00,
  -1.7613095e+00,-1.7605884e+00,-1.7598681e+00,-1.7591488e+00,
  -1.7584304e+00,-1.7577128e+00,-1.7569963e+00,-1.7562805e+00,
  -1.7555658e+00,-1.7548518e+00,-1.7541387e+00,-1.7534267e+00,
  -1.7527153e+00,-1.7520050e+00,-1.7512956e+00,-1.7505870e+00,
  -1.7498792e+00,-1.7491723e+00,-1.7484664e+00,-1.7477614e+00,
  -1.7470571e+00,-1.7463537e+00,-1.7456512e+00,-1.7449496e+00,
  -1.7442487e+00,-1.7435489e+00,-1.7428498e+00,-1.7421515e+00,
  -1.7414541e+00,-1.7407576e+00,-1.7400620e+00,-1.7393671e+00,
  -1.7386731e+00,-1.7379799e+00,-1.7372876e+00,-1.7365961e+00,
  -1.7359054e+00,-1.7352155e+00,-1.7345265e+00,-1.7338383e+00,
  -1.7331510e+00,-1.7324644e+00,-1.7317786e+00,-1.7310936e+00,
  -1.7304096e+00,-1.7297263e+00,-1.7290437e+00,-1.7283621e+00,
  -1.7276812e+00,-1.7270011e+00,-1.7263217e+00,-1.7256433e+00,
  -1.7249656e+00,-1.7242886e+00,-1.7236124e+00,-1.7229371e+00,
  -1.7222625e+00,-1.7215887e+00,-1.7209158e+00,-1.7202436e+00,
  -1.7195721e+00,-1.7189014e+00,-1.7182316e+00,-1.7175624e+00,
  -1.7168940e+00,-1.7162265e+00,-1.7155596e+00,-1.7148936e+00,
  -1.7142283e+00,-1.7135637e+00,-1.7128999e+00,-1.7122369e+00,
  -1.7115746e+00,-1.7109131e+00,-1.7102523e+00,-1.7095922e+00,
  -1.7089329e+00,-1.7082744e+00,-1.7076166e+00,-1.7069595e+00,
  -1.7063031e+00,-1.7056475e+00,-1.7049927e+00,-1.7043386e+00,
  -1.7036850e+00,-1.7030324e+00,-1.7023804e+00,-1.7017292e+00,
  -1.7010787e+00,-1.7004288e+00,-1.6997797e+00,-1.6991314e+00,
  -1.6984837e+00,-1.6978368e+00,-1.6971905e+00,-1.6965450e+00,
  -1.6959002e+00,-1.6952561e+00,-1.6946126e+00,-1.6939700e+00,
  -1.6933279e+00,-1.6926867e+00,-1.6920460e+00,-1.6914060e+00,
  -1.6907668e+00,-1.6901283e+00,-1.6894904e+00,-1.6888533e+00,
  -1.6882168e+00,-1.6875809e+00,-1.6869458e+00,-1.6863114e+00,
  -1.6856776e+00,-1.6850445e+00,-1.6844121e+00,-1.6837804e+00,
  -1.6831493e+00,-1.6825190e+00,-1.6818892e+00,-1.6812601e+00,
  -1.6806318e+00,-1.6800040e+00,-1.6793770e+00,-1.6787505e+00,
  -1.6781248e+00,-1.6774997e+00,-1.6768752e+00,-1.6762514e+00,
  -1.6756283e+00,-1.6750058e+00,-1.6743839e+00,-1.6737627e+00,
  -1.6731422e+00,-1.6725223e+00,-1.6719030e+00,-1.6712843e+00,
  -1.6706663e+00,-1.6700491e+00,-1.6694323e+00,-1.6688162e+00,
  -1.6682007e+00,-1.6675860e+00,-1.6669718e+00,-1.6663582e+00,
  -1.6657453e+00,-1.6651330e+00,-1.6645213e+00,-1.6639103e+00,
  -1.6632998e+00,-1.6626899e+00,-1.6620808e+00,-1.6614722e+00,
  -1.6608642e+00,-1.6602569e+00,-1.6596501e+00,-1.6590440e+00,
  -1.6584384e+00,-1.6578336e+00,-1.6572292e+00,-1.6566255e+00,
  -1.6560224e+00,-1.6554199e+00,-1.6548179e+00,-1.6542166e+00,
  -1.6536160e+00,-1.6530159e+00,-1.6524163e+00,-1.6518174e+00,
  -1.6512191e+00,-1.6506214e+00,-1.6500242e+00,-1.6494277e+00,
  -1.6488316e+00,-1.6482363e+00,-1.6476414e+00,-1.6470473e+00,
  -1.6464536e+00,-1.6458606e+00,-1.6452681e+00,-1.6446761e+00,
  -1.6440848e+00,-1.6434940e+00,-1.6429038e+00,-1.6423142e+00,
  -1.6417252e+00,-1.6411368e+00,-1.6405488e+00,-1.6399615e+00,
  -1.6393747e+00,-1.6387885e+00,-1.6382028e+00,-1.6376177e+00,
  -1.6370332e+00,-1.6364492e+00,-1.6358658e+00,-1.6352830e+00,
  -1.6347007e+00,-1.6341189e+00,-1.6335378e+00,-1.6329571e+00,
  -1.6323770e+00,-1.6317974e+00,-1.6312184e+00,-1.6306400e+00,
  -1.6300621e+00,-1.6294848e+00,-1.6289079e+00,-1.6283317e+00,
  -1.6277559e+00,-1.6271807e+00,-1.6266060e+00,-1.6260319e+00,
  -1.6254584e+00,-1.6248852e+00,-1.6243128e+00,-1.6237408e+00,
  -1.6231693e+00,-1.6225984e+00,-1.6220280e+00,-1.6214581e+00,
  -1.6208887e+00,-1.6203200e+00,-1.6197516e+00,-1.6191839e+00,
  -1.6186166e+00,-1.6180499e+00,-1.6174836e+00,-1.6169180e+00,
  -1.6163528e+00,-1.6157881e+00,-1.6152240e+00,-1.6146603e+00,
  -1.6140972e+00,-1.6135346e+00,-1.6129725e+00,-1.6124109e+00,
  -1.6118498e+00,-1.6112893e+00,-1.6107291e+00,-1.6101696e+00,
  -1.6096106e+00,-1.6090519e+00,-1.6084939e+00,-1.6079364e+00,
  -1.6073793e+00,-1.6068227e+00,-1.6062666e+00,-1.6057111e+00,
  -1.6051561e+00,-1.6046015e+00,-1.6040474e+00,-1.6034938e+00,
  -1.6029407e+00,-1.6023880e+00,-1.6018360e+00,-1.6012843e+00,
  -1.6007332e+00,-1.6001825e+00,-1.5996323e+00,-1.5990826e+00,
  -1.5985334e+00,-1.5979847e+00,-1.5974364e+00,-1.5968887e+00,
  -1.5963414e+00,-1.5957946e+00,-1.5952482e+00,-1.5947024e+00,
  -1.5941570e+00,-1.5936121e+00,-1.5930676e+00,-1.5925237e+00,
  -1.5919802e+00,-1.5914371e+00,-1.5908946e+00,-1.5903525e+00,
  -1.5898108e+00,-1.5892698e+00,-1.5887290e+00,-1.5881888e+00,
  -1.5876490e+00,-1.5871097e+00,-1.5865709e+00,-1.5860325e+00,
  -1.5854946e+00,-1.5849571e+00,-1.5844201e+00,-1.5838836e+00,
  -1.5833474e+00,-1.5828118e+00,-1.5822767e+00,-1.5817419e+00,
  -1.5812076e+00,-1.5806738e+00,-1.5801405e+00,-1.5796075e+00,
  -1.5790750e+00,-1.5785429e+00,-1.5780114e+00,-1.5774803e+00,
  -1.5769496e+00,-1.5764194e+00,-1.5758895e+00,-1.5753602e+00,
  -1.5748312e+00,-1.5743027e+00,-1.5737747e+00,-1.5732471e+00,
  -1.5727199e+00,-1.5721931e+00,-1.5716668e+00,-1.5711410e+00,
  -1.5706155e+00,-1.5700905e+00,-1.5695660e+00,-1.5690418e+00,
  -1.5685182e+00,-1.5679950e+00,-1.5674721e+00,-1.5669496e+00,
  -1.5664277e+00,-1.5659060e+00,-1.5653850e+00,-1.5648643e+00,
  -1.5643439e+00,-1.5638241e+00,-1.5633047e+00,-1.5627856e+00,
  -1.5622671e+00,-1.5617489e+00,-1.5612311e+00,-1.5607138e+00,
  -1.5601968e+00,-1.5596803e+00,-1.5591642e+00,-1.5586486e+00,
  -1.5581332e+00,-1.5576184e+00,-1.5571040e+00,-1.5565900e+00,
  -1.5560763e+00,-1.5555631e+00,-1.5550504e+00,-1.5545379e+00,
  -1.5540260e+00,-1.5535144e+00,-1.5530032e+00,-1.5524925e+00,
  -1.5519822e+00,-1.5514722e+00,-1.5509626e+00,-1.5504534e+00,
  -1.5499448e+00,-1.5494363e+00,-1.5489284e+00,-1.5484209e+00,
  -1.5479138e+00,-1.5474070e+00,-1.5469006e+00,-1.5463947e+00,
  -1.5458891e+00,-1.5453839e+00,-1.5448792e+00,-1.5443748e+00,
  -1.5438708e+00,-1.5433673e+00,-1.5428641e+00,-1.5423613e+00,
  -1.5418588e+00,-1.5413568e+00,-1.5408552e+00,-1.5403539e+00,
  -1.5398530e+00,-1.5393525e+00,-1.5388525e+00,-1.5383527e+00,
  -1.5378534e+00,-1.5373545e+00,-1.5368558e+00,-1.5363576e+00,
  -1.5358598e+00,-1.5353625e+00,-1.5348654e+00,-1.5343688e+00,
  -1.5338725e+00,-1.5333766e+00,-1.5328810e+00,-1.5323858e+00,
  -1.5318911e+00,-1.5313966e+00,-1.5309026e+00,-1.5304090e+00,
  -1.5299157e+00,-1.5294228e+00,-1.5289302e+00,-1.5284381e+00,
  -1.5279462e+00,-1.5274549e+00,-1.5269638e+00,-1.5264730e+00,
  -1.5259827e+00,-1.5254928e+00,-1.5250032e+00,-1.5245140e+00,
  -1.5240251e+00,-1.5235366e+00,-1.5230485e+00,-1.5225607e+00,
  -1.5220733e+00,-1.5215862e+00,-1.5210996e+00,-1.5206132e+00,
  -1.5201272e+00,-1.5196416e+00,-1.5191563e+00,-1.5186715e+00,
  -1.5181869e+00,-1.5177027e+00,-1.5172189e+00,-1.5167354e+00,
  -1.5162523e+00,-1.5157695e+00,-1.5152872e+00,-1.5148051e+00,
  -1.5143234e+00,-1.5138420e+00,-1.5133610e+00,-1.5128803e+00,
  -1.5124000e+00,-1.5119201e+00,-1.5114404e+00,-1.5109612e+00,
  -1.5104823e+00,-1.5100037e+00,-1.5095254e+00,-1.5090476e+00,
  -1.5085701e+00,-1.5080929e+00,-1.5076160e+00,-1.5071396e+00,
  -1.5066633e+00,-1.5061876e+00,-1.5057120e+00,-1.5052369e+00,
  -1.5047621e+00,-1.5042876e+00,-1.5038135e+00,-1.5033398e+00,
  -1.5028663e+00,-1.5023931e+00,-1.5019203e+00,-1.5014479e+00,
  -1.5009758e+00,-1.5005040e+00,-1.5000327e+00,-1.4995615e+00,
  -1.4990907e+00,-1.4986203e+00,-1.4981502e+00,-1.4976804e+00,
  -1.4972110e+00,-1.4967418e+00,-1.4962730e+00,-1.4958045e+00,
  -1.4953364e+00,-1.4948686e+00,-1.4944011e+00,-1.4939340e+00,
  -1.4934672e+00,-1.4930006e+00,-1.4925345e+00,-1.4920686e+00,
  -1.4916031e+00,-1.4911379e+00,-1.4906731e+00,-1.4902085e+00,
  -1.4897442e+00,-1.4892803e+00,-1.4888167e+00,-1.4883534e+00,
  -1.4878905e+00,-1.4874278e+00,-1.4869655e+00,-1.4865035e+00,
  -1.4860418e+00,-1.4855804e+00,-1.4851193e+00,-1.4846586e+00,
  -1.4841982e+00,-1.4837381e+00,-1.4832783e+00,-1.4828188e+00,
  -1.4823596e+00,-1.4819008e+00,-1.4814422e+00,-1.4809840e+00,
  -1.4805261e+00,-1.4800684e+00,-1.4796112e+00,-1.4791541e+00,
  -1.4786974e+00,-1.4782411e+00,-1.4777850e+00,-1.4773293e+00,
  -1.4768738e+00,-1.4764186e+00,-1.4759638e+00,-1.4755093e+00,
  -1.4750550e+00,-1.4746010e+00,-1.4741474e+00,-1.4736941e+00,
  -1.4732411e+00,-1.4727883e+00,-1.4723359e+00,-1.4718839e+00,
  -1.4714320e+00,-1.4709805e+00,-1.4705293e+00,-1.4700783e+00,
  -1.4696277e+00,-1.4691775e+00,-1.4687275e+00,-1.4682777e+00,
  -1.4678283e+00,-1.4673791e+00,-1.4669303e+00,-1.4664818e+00,
  -1.4660335e+00,-1.4655856e+00,-1.4651378e+00,-1.4646906e+00,
  -1.4642434e+00,-1.4637966e+00,-1.4633502e+00,-1.4629040e+00,
  -1.4624581e+00,-1.4620124e+00,-1.4615672e+00,-1.4611222e+00,
  -1.4606774e+00,-1.4602329e+00,-1.4597887e+00,-1.4593449e+00,
  -1.4589013e+00,-1.4584579e+00,-1.4580150e+00,-1.4575722e+00,
  -1.4571297e+00,-1.4566876e+00,-1.4562457e+00,-1.4558041e+00,
  -1.4553628e+00,-1.4549217e+00,-1.4544810e+00,-1.4540405e+00,
  -1.4536004e+00,-1.4531605e+00,-1.4527209e+00,-1.4522815e+00,
  -1.4518424e+00,-1.4514037e+00,-1.4509652e+00,-1.4505270e+00,
  -1.4500890e+00,-1.4496514e+00,-1.4492140e+00,-1.4487768e+00,
  -1.4483401e+00,-1.4479035e+00,-1.4474672e+00,-1.4470313e+00,
  -1.4465954e+00,-1.4461601e+00,-1.4457248e+00,-1.4452900e+00,
  -1.4448553e+00,-1.4444209e+00,-1.4439869e+00,-1.4435530e+00,
  -1.4431195e+00,-1.4426862e+00,-1.4422532e+00,-1.4418205e+00,
  -1.4413880e+00,-1.4409558e+00,-1.4405239e+00,-1.4400922e+00,
  -1.4396608e+00,-1.4392297e+00,-1.4387989e+00,-1.4383683e+00,
  -1.4379380e+00,-1.4375079e+00,-1.4370781e+00,-1.4366486e+00,
  -1.4362193e+00,-1.4357903e+00,-1.4353616e+00,-1.4349332e+00,
  -1.4345050e+00,-1.4340770e+00,-1.4336493e+00,-1.4332219e+00,
  -1.4327947e+00,-1.4323678e+00,-1.4319413e+00,-1.4315149e+00,
  -1.4310887e+00,-1.4306629e+00,-1.4302373e+00,-1.4298120e+00,
  -1.4293869e+00,-1.4289621e+00,-1.4285375e+00,-1.4281132e+00,
  -1.4276892e+00,-1.4272654e+00,-1.4268419e+00,-1.4264185e+00,
  -1.4259956e+00,-1.4255728e+00,-1.4251503e+00,-1.4247280e+00,
  -1.4243060e+00,-1.4238843e+00,-1.4234627e+00,-1.4230415e+00,
  -1.4226205e+00,-1.4221997e+00,-1.4217793e+00,-1.4213591e+00,
  -1.4209391e+00,-1.4205194e+00,-1.4200999e+00,-1.4196806e+00,
  -1.4192616e+00,-1.4188429e+00,-1.4184244e+00,-1.4180062e+00,
  -1.4175881e+00,-1.4171704e+00,-1.4167529e+00,-1.4163357e+00,
  -1.4159187e+00,-1.4155020e+00,-1.4150854e+00,-1.4146692e+00,
  -1.4142531e+00,-1.4138373e+00,-1.4134218e+00,-1.4130065e+00,
  -1.4125915e+00,-1.4121766e+00,-1.4117621e+00,-1.4113477e+00,
  -1.4109337e+00,-1.4105198e+00,-1.4101063e+00,-1.4096929e+00,
  -1.4092798e+00,-1.4088670e+00,-1.4084543e+00,-1.4080420e+00,
  -1.4076297e+00,-1.4072179e+00,-1.4068062e+00,-1.4063947e+00,
  -1.4059836e+00,-1.4055727e+00,-1.4051619e+00,-1.4047514e+00,
  -1.4043411e+00,-1.4039311e+00,-1.4035214e+00,-1.4031118e+00,
  -1.4027026e+00,-1.4022934e+00,-1.4018846e+00,-1.4014760e+00,
  -1.4010676e+00,-1.4006594e+00,-1.4002516e+00,-1.3998439e+00,
  -1.3994365e+00,-1.3990293e+00,-1.3986223e+00,-1.3982155e+00,
  -1.3978090e+00,-1.3974028e+00,-1.3969967e+00,-1.3965909e+00,
  -1.3961853e+00,-1.3957800e+00,-1.3953749e+00,-1.3949699e+00,
  -1.3945652e+00,-1.3941609e+00,-1.3937566e+00,-1.3933526e+00,
  -1.3929489e+00,-1.3925453e+00,-1.3921421e+00,-1.3917389e+00,
  -1.3913361e+00,-1.3909335e+00,-1.3905311e+00,-1.3901289e+00,
  -1.3897269e+00,-1.3893251e+00,-1.3889236e+00,-1.3885224e+00,
  -1.3881214e+00,-1.3877205e+00,-1.3873199e+00,-1.3869195e+00,
  -1.3865193e+00,-1.3861194e+00,-1.3857197e+00,-1.3853202e+00,
  -1.3849208e+00,-1.3845218e+00,-1.3841230e+00,-1.3837243e+00,
  -1.3833259e+00,-1.3829278e+00,-1.3825299e+00,-1.3821321e+00,
  -1.3817345e+00,-1.3813373e+00,-1.3809402e+00,-1.3805432e+00,
  -1.3801466e+00,-1.3797501e+00,-1.3793540e+00,-1.3789580e+00,
  -1.3785622e+00,-1.3781666e+00,-1.3777713e+00,-1.3773761e+00,
  -1.3769811e+00,-1.3765864e+00,-1.3761920e+00,-1.3757976e+00,
  -1.3754036e+00,-1.3750098e+00,-1.3746161e+00,-1.3742226e+00,
  -1.3738295e+00,-1.3734365e+00,-1.3730437e+00,-1.3726511e+00,
  -1.3722587e+00,-1.3718666e+00,-1.3714746e+00,-1.3710829e+00,
  -1.3706913e+00,-1.3703001e+00,-1.3699089e+00,-1.3695180e+00,
  -1.3691274e+00,-1.3687369e+00,-1.3683466e+00,-1.3679565e+00,
  -1.3675667e+00,-1.3671770e+00,-1.3667876e+00,-1.3663983e+00,
  -1.3660094e+00,-1.3656205e+00,-1.3652319e+00,-1.3648435e+00,
  -1.3644553e+00,-1.3640673e+00,-1.3636795e+00,-1.3632919e+00,
  -1.3629045e+00,-1.3625174e+00,-1.3621304e+00,-1.3617436e+00,
  -1.3613571e+00,-1.3609707e+00,-1.3605845e+00,-1.3601986e+00,
  -1.3598129e+00,-1.3594273e+00,-1.3590419e+00,-1.3586568e+00,
  -1.3582718e+00,-1.3578871e+00,-1.3575026e+00,-1.3571182e+00,
  -1.3567340e+00,-1.3563502e+00,-1.3559663e+00,-1.3555828e+00,
  -1.3551995e+00,-1.3548163e+00,-1.3544334e+00,-1.3540506e+00,
  -1.3536681e+00,-1.3532858e+00,-1.3529036e+00,-1.3525217e+00,
  -1.3521399e+00,-1.3517584e+00,-1.3513770e+00,-1.3509958e+00,
  -1.3506148e+00,-1.3502340e+00,-1.3498535e+00,-1.3494731e+00,
  -1.3490928e+00,-1.3487129e+00,-1.3483331e+00,-1.3479534e+00,
  -1.3475741e+00,-1.3471949e+00,-1.3468158e+00,-1.3464370e+00,
  -1.3460584e+00,-1.3456799e+00,-1.3453016e+00,-1.3449236e+00,
  -1.3445457e+00,-1.3441681e+00,-1.3437905e+00,-1.3434132e+00,
  -1.3430362e+00,-1.3426592e+00,-1.3422825e+00,-1.3419061e+00,
  -1.3415297e+00,-1.3411535e+00,-1.3407776e+00,-1.3404018e+00,
  -1.3400263e+00,-1.3396509e+00,-1.3392756e+00,-1.3389006e+00,
  -1.3385258e+00,-1.3381511e+00,-1.3377767e+00,-1.3374025e+00,
  -1.3370284e+00,-1.3366544e+00,-1.3362808e+00,-1.3359072e+00,
  -1.3355340e+00,-1.3351607e+00,-1.3347878e+00,-1.3344151e+00,
  -1.3340424e+00,-1.3336700e+00,-1.3332978e+00,-1.3329258e+00,
  -1.3325540e+00,-1.3321823e+00,-1.3318108e+00,-1.3314395e+00,
  -1.3310684e+00,-1.3306974e+00,-1.3303267e+00,-1.3299562e+00,
  -1.3295858e+00,-1.3292155e+00,-1.3288456e+00,-1.3284757e+00,
  -1.3281060e+00,-1.3277366e+00,-1.3273673e+00,-1.3269982e+00,
  -1.3266293e+00,-1.3262606e+00,-1.3258920e+00,-1.3255236e+00,
  -1.3251554e+00,-1.3247874e+00,-1.3244195e+00,-1.3240519e+00,
  -1.3236843e+00,-1.3233171e+00,-1.3229499e+00,-1.3225830e+00,
  -1.3222162e+00,-1.3218495e+00,-1.3214831e+00,-1.3211168e+00,
  -1.3207508e+00,-1.3203849e+00,-1.3200191e+00,-1.3196536e+00,
  -1.3192883e+00,-1.3189231e+00,-1.3185581e+00,-1.3181932e+00,
  -1.3178285e+00,-1.3174641e+00,-1.3170998e+00,-1.3167356e+00,
  -1.3163717e+00,-1.3160079e+00,-1.3156443e+00,-1.3152809e+00,
  -1.3149176e+00,-1.3145545e+00,-1.3141916e+00,-1.3138288e+00,
  -1.3134663e+00,-1.3131039e+00,-1.3127416e+00,-1.3123796e+00,
  -1.3120177e+00,-1.3116560e+00,-1.3112944e+00,-1.3109331e+00,
  -1.3105719e+00,-1.3102108e+00,-1.3098500e+00,-1.3094894e+00,
  -1.3091288e+00,-1.3087685e+00,-1.3084083e+00,-1.3080482e+00,
  -1.3076885e+00,-1.3073288e+00,-1.3069693e+00,-1.3066100e+00,
  -1.3062508e+00,-1.3058918e+00,-1.3055329e+00,-1.3051744e+00,
  -1.3048158e+00,-1.3044575e+00,-1.3040993e+00,-1.3037413e+00,
  -1.3033836e+00,-1.3030258e+00,-1.3026685e+00,-1.3023111e+00,
  -1.3019539e+00,-1.3015970e+00,-1.3012401e+00,-1.3008835e+00,
  -1.3005270e+00,-1.3001707e+00,-1.2998145e+00,-1.2994585e+00,
  -1.2991027e+00,-1.2987471e+00,-1.2983915e+00,-1.2980362e+00,
  -1.2976810e+00,-1.2973260e+00,-1.2969712e+00,-1.2966164e+00,
  -1.2962619e+00,-1.2959076e+00,-1.2955534e+00,-1.2951994e+00,
  -1.2948455e+00,-1.2944918e+00,-1.2941382e+00,-1.2937849e+00,
  -1.2934316e+00,-1.2930785e+00,-1.2927257e+00,-1.2923729e+00,
  -1.2920203e+00,-1.2916679e+00,-1.2913157e+00,-1.2909635e+00,
  -1.2906116e+00,-1.2902598e+00,-1.2899083e+00,-1.2895567e+00,
  -1.2892054e+00,-1.2888544e+00,-1.2885034e+00,-1.2881526e+00,
  -1.2878019e+00,-1.2874514e+00,-1.2871010e+00,-1.2867508e+00,
  -1.2864008e+00,-1.2860509e+00,-1.2857012e+00,-1.2853516e+00,
  -1.2850022e+00,-1.2846529e+00,-1.2843039e+00,-1.2839550e+00,
  -1.2836062e+00,-1.2832576e+00,-1.2829090e+00,-1.2825608e+00,
  -1.2822126e+00,-1.2818646e+00,-1.2815168e+00,-1.2811691e+00,
  -1.2808216e+00,-1.2804742e+00,-1.2801269e+00,-1.2797799e+00,
  -1.2794330e+00,-1.2790862e+00,-1.2787396e+00,-1.2783931e+00,
  -1.2780468e+00,-1.2777007e+00,-1.2773547e+00,-1.2770089e+00,
  -1.2766632e+00,-1.2763176e+00,-1.2759722e+00,-1.2756270e+00,
  -1.2752819e+00,-1.2749370e+00,-1.2745922e+00,-1.2742475e+00,
  -1.2739031e+00,-1.2735587e+00,-1.2732146e+00,-1.2728705e+00,
  -1.2725267e+00,-1.2721829e+00,-1.2718394e+00,-1.2714961e+00,
  -1.2711527e+00,-1.2708097e+00,-1.2704667e+00,-1.2701238e+00,
  -1.2697811e+00,-1.2694386e+00,-1.2690963e+00,-1.2687540e+00,
  -1.2684120e+00,-1.2680700e+00,-1.2677282e+00,-1.2673866e+00,
  -1.2670451e+00,-1.2667037e+00,-1.2663625e+00,-1.2660215e+00,
  -1.2656807e+00,-1.2653399e+00,-1.2649993e+00,-1.2646588e+00,
  -1.2643185e+00,-1.2639784e+00,-1.2636384e+00,-1.2632985e+00,
  -1.2629588e+00,-1.2626191e+00,-1.2622797e+00,-1.2619405e+00,
  -1.2616013e+00,-1.2612623e+00,-1.2609235e+00,-1.2605847e+00,
  -1.2602462e+00,-1.2599077e+00,-1.2595695e+00,-1.2592313e+00,
  -1.2588934e+00,-1.2585555e+00,-1.2582178e+00,-1.2578802e+00,
  -1.2575428e+00,-1.2572056e+00,-1.2568685e+00,-1.2565315e+00,
  -1.2561946e+00,-1.2558579e+00,-1.2555214e+00,-1.2551850e+00,
  -1.2548487e+00,-1.2545125e+00,-1.2541766e+00,-1.2538407e+00,
  -1.2535050e+00,-1.2531694e+00,-1.2528341e+00,-1.2524987e+00,
  -1.2521636e+00,-1.2518286e+00,-1.2514937e+00,-1.2511591e+00,
  -1.2508245e+00,-1.2504900e+00,-1.2501557e+00,-1.2498215e+00,
  -1.2494875e+00,-1.2491536e+00,-1.2488198e+00,-1.2484863e+00,
  -1.2481529e+00,-1.2478195e+00,-1.2474864e+00,-1.2471533e+00,
  -1.2468203e+00,-1.2464876e+00,-1.2461549e+00,-1.2458224e+00,
  -1.2454901e+00,-1.2451578e+00,-1.2448257e+00,-1.2444938e+00,
  -1.2441620e+00,-1.2438303e+00,-1.2434988e+00,-1.2431674e+00,
  -1.2428361e+00,-1.2425050e+00,-1.2421740e+00,-1.2418431e+00,
  -1.2415124e+00,-1.2411819e+00,-1.2408514e+00,-1.2405211e+00,
  -1.2401909e+00,-1.2398609e+00,-1.2395309e+00,-1.2392012e+00,
  -1.2388716e+00,-1.2385421e+00,-1.2382127e+00,-1.2378834e+00,
  -1.2375543e+00,-1.2372254e+00,-1.2368965e+00,-1.2365679e+00,
  -1.2362393e+00,-1.2359109e+00,-1.2355826e+00,-1.2352544e+00,
  -1.2349263e+00,-1.2345985e+00,-1.2342707e+00,-1.2339431e+00,
  -1.2336155e+00,-1.2332882e+00,-1.2329609e+00,-1.2326338e+00,
  -1.2323068e+00,-1.2319801e+00,-1.2316533e+00,-1.2313267e+00,
  -1.2310003e+00,-1.2306740e+00,-1.2303478e+00,-1.2300217e+00,
  -1.2296958e+00,-1.2293700e+00,-1.2290443e+00,-1.2287189e+00,
  -1.2283934e+00,-1.2280681e+00,-1.2277430e+00,-1.2274179e+00,
  -1.2270931e+00,-1.2267684e+00,-1.2264438e+00,-1.2261193e+00,
  -1.2257949e+00,-1.2254707e+00,-1.2251465e+00,-1.2248225e+00,
  -1.2244986e+00,-1.2241750e+00,-1.2238513e+00,-1.2235279e+00,
  -1.2232046e+00,-1.2228813e+00,-1.2225583e+00,-1.2222353e+00,
  -1.2219125e+00,-1.2215898e+00,-1.2212672e+00,-1.2209448e+00,
  -1.2206224e+00,-1.2203002e+00,-1.2199782e+00,-1.2196562e+00,
  -1.2193345e+00,-1.2190127e+00,-1.2186912e+00,-1.2183697e+00,
  -1.2180485e+00,-1.2177273e+00,-1.2174062e+00,-1.2170852e+00,
  -1.2167645e+00,-1.2164438e+00,-1.2161232e+00,-1.2158028e+00,
  -1.2154825e+00,-1.2151623e+00,-1.2148422e+00,-1.2145222e+00,
  -1.2142025e+00,-1.2138828e+00,-1.2135632e+00,-1.2132438e+00,
  -1.2129245e+00,-1.2126052e+00,-1.2122862e+00,-1.2119672e+00,
  -1.2116485e+00,-1.2113298e+00,-1.2110112e+00,-1.2106928e+00,
  -1.2103744e+00,-1.2100562e+00,-1.2097381e+00,-1.2094202e+00,
  -1.2091023e+00,-1.2087846e+00,-1.2084670e+00,-1.2081496e+00,
  -1.2078322e+00,-1.2075150e+00,-1.2071979e+00,-1.2068808e+00,
  -1.2065639e+00,-1.2062472e+00,-1.2059306e+00,-1.2056141e+00,
  -1.2052977e+00,-1.2049814e+00,-1.2046653e+00,-1.2043493e+00,
  -1.2040334e+00,-1.2037176e+00,-1.2034019e+00,-1.2030865e+00,
  -1.2027711e+00,-1.2024558e+00,-1.2021406e+00,-1.2018255e+00,
  -1.2015105e+00,-1.2011957e+00,-1.2008810e+00,-1.2005664e+00,
  -1.2002519e+00,-1.1999376e+00,-1.1996233e+00,-1.1993092e+00,
  -1.1989952e+00,-1.1986814e+00,-1.1983676e+00,-1.1980540e+00,
  -1.1977404e+00,-1.1974270e+00,-1.1971138e+00,-1.1968006e+00,
  -1.1964875e+00,-1.1961746e+00,-1.1958618e+00,-1.1955491e+00,
  -1.1952366e+00,-1.1949241e+00,-1.1946117e+00,-1.1942995e+00,
  -1.1939874e+00,-1.1936754e+00,-1.1933634e+00,-1.1930517e+00,
  -1.1927401e+00,-1.1924285e+00,-1.1921171e+00,-1.1918058e+00,
  -1.1914946e+00,-1.1911836e+00,-1.1908726e+00,-1.1905618e+00,
  -1.1902510e+00,-1.1899403e+00,-1.1896299e+00,-1.1893195e+00,
  -1.1890092e+00,-1.1886991e+00,-1.1883891e+00,-1.1880791e+00,
  -1.1877693e+00,-1.1874596e+00,-1.1871500e+00,-1.1868405e+00,
  -1.1865312e+00,-1.1862220e+00,-1.1859128e+00,-1.1856037e+00,
  -1.1852949e+00,-1.1849861e+00,-1.1846774e+00,-1.1843688e+00,
  -1.1840603e+00,-1.1837521e+00,-1.1834438e+00,-1.1831357e+00,
  -1.1828277e+00,-1.1825198e+00,-1.1822120e+00,-1.1819043e+00,
  -1.1815968e+00,-1.1812893e+00,-1.1809820e+00,-1.1806748e+00,
  -1.1803677e+00,-1.1800607e+00,-1.1797538e+00,-1.1794471e+00,
  -1.1791403e+00,-1.1788338e+00,-1.1785274e+00,-1.1782210e+00,
  -1.1779149e+00,-1.1776087e+00,-1.1773027e+00,-1.1769968e+00,
  -1.1766911e+00,-1.1763854e+00,-1.1760798e+00,-1.1757743e+00,
  -1.1754690e+00,-1.1751637e+00,-1.1748587e+00,-1.1745536e+00,
  -1.1742487e+00,-1.1739439e+00,-1.1736393e+00,-1.1733347e+00,
  -1.1730303e+00,-1.1727258e+00,-1.1724216e+00,-1.1721175e+00,
  -1.1718134e+00,-1.1715095e+00,-1.1712056e+00,-1.1709020e+00,
  -1.1705984e+00,-1.1702949e+00,-1.1699915e+00,-1.1696882e+00,
  -1.1693851e+00,-1.1690819e+00,-1.1687790e+00,-1.1684762e+00,
  -1.1681734e+00,-1.1678708e+00,-1.1675682e+00,-1.1672659e+00,
  -1.1669636e+00,-1.1666613e+00,-1.1663592e+00,-1.1660572e+00,
  -1.1657554e+00,-1.1654536e+00,-1.1651518e+00,-1.1648504e+00,
  -1.1645489e+00,-1.1642475e+00,-1.1639463e+00,-1.1636450e+00,
  -1.1633440e+00,-1.1630431e+00,-1.1627423e+00,-1.1624415e+00,
  -1.1621410e+00,-1.1618404e+00,-1.1615400e+00,-1.1612397e+00,
  -1.1609395e+00,-1.1606394e+00,-1.1603394e+00,-1.1600395e+00,
  -1.1597397e+00,-1.1594400e+00,-1.1591405e+00,-1.1588410e+00,
  -1.1585417e+00,-1.1582423e+00,-1.1579432e+00,-1.1576442e+00,
  -1.1573452e+00,-1.1570463e+00,-1.1567476e+00,-1.1564490e+00,
  -1.1561505e+00,-1.1558520e+00,-1.1555537e+00,-1.1552554e+00,
  -1.1549573e+00,-1.1546593e+00,-1.1543614e+00,-1.1540636e+00,
  -1.1537658e+00,-1.1534683e+00,-1.1531707e+00,-1.1528733e+00,
  -1.1525760e+00,-1.1522788e+00,-1.1519816e+00,-1.1516846e+00,
  -1.1513877e+00,-1.1510910e+00,-1.1507943e+00,-1.1504977e+00,
  -1.1502011e+00,-1.1499047e+00,-1.1496085e+00,-1.1493123e+00,
  -1.1490161e+00,-1.1487201e+00,-1.1484243e+00,-1.1481285e+00,
  -1.1478328e+00,-1.1475372e+00,-1.1472417e+00,-1.1469463e+00,
  -1.1466510e+00,-1.1463559e+00,-1.1460607e+00,-1.1457658e+00,
  -1.1454709e+00,-1.1451761e+00,-1.1448814e+00,-1.1445868e+00,
  -1.1442922e+00,-1.1439979e+00,-1.1437036e+00,-1.1434094e+00,
  -1.1431153e+00,-1.1428213e+00,-1.1425273e+00,-1.1422336e+00,
  -1.1419399e+00,-1.1416463e+00,-1.1413528e+00,-1.1410594e+00,
  -1.1407660e+00,-1.1404729e+00,-1.1401798e+00,-1.1398867e+00,
  -1.1395938e+00,-1.1393009e+00,-1.1390083e+00,-1.1387156e+00,
  -1.1384231e+00,-1.1381307e+00,-1.1378384e+00,-1.1375461e+00,
  -1.1372540e+00,-1.1369619e+00,-1.1366700e+00,-1.1363782e+00,
  -1.1360863e+00,-1.1357948e+00,-1.1355032e+00,-1.1352117e+00,
  -1.1349204e+00,-1.1346291e+00,-1.1343379e+00,-1.1340468e+00,
  -1.1337558e+00,-1.1334649e+00,-1.1331742e+00,-1.1328834e+00,
  -1.1325929e+00,-1.1323024e+00,-1.1320120e+00,-1.1317216e+00,
  -1.1314315e+00,-1.1311413e+00,-1.1308513e+00,-1.1305614e+00,
  -1.1302716e+00,-1.1299818e+00,-1.1296922e+00,-1.1294026e+00,
  -1.1291132e+00,-1.1288238e+00,-1.1285346e+00,-1.1282454e+00,
  -1.1279563e+00,-1.1276673e+00,-1.1273785e+00,-1.1270896e+00,
  -1.1268009e+00,-1.1265123e+00,-1.1262238e+00,-1.1259354e+00,
  -1.1256471e+00,-1.1253588e+00,-1.1250707e+00,-1.1247827e+00,
  -1.1244947e+00,-1.1242068e+00,-1.1239190e+00,-1.1236314e+00,
  -1.1233438e+00,-1.1230563e+00,-1.1227689e+00,-1.1224816e+00,
  -1.1221944e+00,-1.1219074e+00,-1.1216203e+00,-1.1213334e+00,
  -1.1210465e+00,-1.1207597e+00,-1.1204731e+00,-1.1201866e+00,
  -1.1199001e+00,-1.1196136e+00,-1.1193274e+00,-1.1190412e+00,
  -1.1187551e+00,-1.1184691e+00,-1.1181831e+00,-1.1178974e+00,
  -1.1176116e+00,-1.1173259e+00,-1.1170404e+00,-1.1167549e+00,
  -1.1164695e+00,-1.1161842e+00,-1.1158991e+00,-1.1156139e+00,
  -1.1153290e+00,-1.1150440e+00,-1.1147592e+00,-1.1144745e+00,
  -1.1141899e+00,-1.1139053e+00,-1.1136208e+00,-1.1133364e+00,
  -1.1130521e+00,-1.1127679e+00,-1.1124839e+00,-1.1121998e+00,
  -1.1119158e+00,-1.1116320e+00,-1.1113483e+00,-1.1110647e+00,
  -1.1107811e+00,-1.1104976e+00,-1.1102142e+00,-1.1099309e+00,
  -1.1096476e+00,-1.1093645e+00,-1.1090815e+00,-1.1087985e+00,
  -1.1085157e+00,-1.1082330e+00,-1.1079502e+00,-1.1076677e+00,
  -1.1073852e+00,-1.1071028e+00,-1.1068205e+00,-1.1065382e+00,
  -1.1062560e+00,-1.1059740e+00,-1.1056920e+00,-1.1054101e+00,
  -1.1051283e+00,-1.1048466e+00,-1.1045649e+00,-1.1042835e+00,
  -1.1040020e+00,-1.1037205e+00,-1.1034393e+00,-1.1031581e+00,
  -1.1028770e+00,-1.1025960e+00,-1.1023151e+00,-1.1020342e+00,
  -1.1017535e+00,-1.1014729e+00,-1.1011922e+00,-1.1009117e+00,
  -1.1006314e+00,-1.1003511e+00,-1.1000708e+00,-1.0997907e+00,
  -1.0995106e+00,-1.0992306e+00,-1.0989507e+00,-1.0986710e+00,
  -1.0983912e+00,-1.0981116e+00,-1.0978321e+00,-1.0975525e+00,
  -1.0972732e+00,-1.0969939e+00,-1.0967147e+00,-1.0964357e+00,
  -1.0961566e+00,-1.0958776e+00,-1.0955988e+00,-1.0953200e+00,
  -1.0950413e+00,-1.0947627e+00,-1.0944842e+00,-1.0942057e+00,
  -1.0939274e+00,-1.0936491e+00,-1.0933709e+00,-1.0930929e+00,
  -1.0928148e+00,-1.0925369e+00,-1.0922590e+00,-1.0919813e+00,
  -1.0917037e+00,-1.0914260e+00,-1.0911485e+00,-1.0908711e+00,
  -1.0905938e+00,-1.0903165e+00,-1.0900394e+00,-1.0897623e+00,
  -1.0894853e+00,-1.0892084e+00,-1.0889316e+00,-1.0886548e+00,
  -1.0883781e+00,-1.0881015e+00,-1.0878251e+00,-1.0875486e+00,
  -1.0872723e+00,-1.0869960e+00,-1.0867199e+00,-1.0864438e+00,
  -1.0861677e+00,-1.0858918e+00,-1.0856160e+00,-1.0853403e+00,
  -1.0850645e+00,-1.0847889e+00,-1.0845134e+00,-1.0842381e+00,
  -1.0839627e+00,-1.0836874e+00,-1.0834122e+00,-1.0831372e+00,
  -1.0828621e+00,-1.0825871e+00,-1.0823123e+00,-1.0820376e+00,
  -1.0817629e+00,-1.0814883e+00,-1.0812137e+00,-1.0809393e+00,
  -1.0806649e+00,-1.0803907e+00,-1.0801164e+00,-1.0798423e+00,
  -1.0795683e+00,-1.0792943e+00,-1.0790205e+00,-1.0787467e+00,
  -1.0784730e+00,-1.0781993e+00,-1.0779257e+00,-1.0776522e+00,
  -1.0773789e+00,-1.0771055e+00,-1.0768323e+00,-1.0765592e+00,
  -1.0762861e+00,-1.0760131e+00,-1.0757402e+00,-1.0754673e+00,
  -1.0751946e+00,-1.0749220e+00,-1.0746493e+00,-1.0743768e+00,
  -1.0741044e+00,-1.0738320e+00,-1.0735598e+00,-1.0732876e+00,
  -1.0730155e+00,-1.0727434e+00,-1.0724715e+00,-1.0721996e+00,
  -1.0719278e+00,-1.0716561e+00,-1.0713844e+00,-1.0711130e+00,
  -1.0708414e+00,-1.0705701e+00,-1.0702987e+00,-1.0700275e+00,
  -1.0697563e+00,-1.0694852e+00,-1.0692142e+00,-1.0689433e+00,
  -1.0686724e+00,-1.0684017e+00,-1.0681310e+00,-1.0678604e+00,
  -1.0675899e+00,-1.0673194e+00,-1.0670490e+00,-1.0667787e+00,
  -1.0665085e+00,-1.0662383e+00,-1.0659683e+00,-1.0656983e+00,
  -1.0654284e+00,-1.0651585e+00,-1.0648887e+00,-1.0646191e+00,
  -1.0643495e+00,-1.0640800e+00,-1.0638105e+00,-1.0635412e+00,
  -1.0632719e+00,-1.0630026e+00,-1.0627335e+00,-1.0624644e+00,
  -1.0621954e+00,-1.0619265e+00,-1.0616577e+00,-1.0613890e+00,
  -1.0611203e+00,-1.0608517e+00,-1.0605831e+00,-1.0603147e+00,
  -1.0600463e+00,-1.0597780e+00,-1.0595098e+00,-1.0592417e+00,
  -1.0589736e+00,-1.0587056e+00,-1.0584377e+00,-1.0581698e+00,
  -1.0579021e+00,-1.0576344e+00,-1.0573667e+00,-1.0570992e+00,
  -1.0568317e+00,-1.0565643e+00,-1.0562971e+00,-1.0560298e+00,
  -1.0557626e+00,-1.0554956e+00,-1.0552286e+00,-1.0549617e+00,
  -1.0546948e+00,-1.0544280e+00,-1.0541613e+00,-1.0538946e+00,
  -1.0536281e+00,-1.0533617e+00,-1.0530952e+00,-1.0528289e+00,
  -1.0525626e+00,-1.0522964e+00,-1.0520303e+00,-1.0517642e+00,
  -1.0514983e+00,-1.0512325e+00,-1.0509666e+00,-1.0507009e+00,
  -1.0504352e+00,-1.0501696e+00,-1.0499041e+00,-1.0496386e+00,
  -1.0493733e+00,-1.0491080e+00,-1.0488428e+00,-1.0485777e+00,
  -1.0483125e+00,-1.0480475e+00,-1.0477827e+00,-1.0475178e+00,
  -1.0472530e+00,-1.0469882e+00,-1.0467236e+00,-1.0464591e+00,
  -1.0461946e+00,-1.0459301e+00,-1.0456659e+00,-1.0454016e+00,
  -1.0451374e+00,-1.0448732e+00,-1.0446092e+00,-1.0443453e+00,
  -1.0440813e+00,-1.0438175e+00,-1.0435537e+00,-1.0432900e+00,
  -1.0430264e+00,-1.0427629e+00,-1.0424994e+00,-1.0422361e+00,
  -1.0419728e+00,-1.0417095e+00,-1.0414463e+00,-1.0411832e+00,
  -1.0409201e+00,-1.0406572e+00,-1.0403943e+00,-1.0401314e+00,
  -1.0398687e+00,-1.0396061e+00,-1.0393435e+00,-1.0390810e+00,
  -1.0388185e+00,-1.0385561e+00,-1.0382938e+00,-1.0380316e+00,
  -1.0377693e+00,-1.0375073e+00,-1.0372453e+00,-1.0369833e+00,
  -1.0367213e+00,-1.0364596e+00,-1.0361978e+00,-1.0359361e+00,
  -1.0356746e+00,-1.0354130e+00,-1.0351515e+00,-1.0348902e+00,
  -1.0346289e+00,-1.0343676e+00,-1.0341064e+00,-1.0338453e+00,
  -1.0335842e+00,-1.0333233e+00,-1.0330623e+00,-1.0328015e+00,
  -1.0325408e+00,-1.0322801e+00,-1.0320195e+00,-1.0317589e+00,
  -1.0314984e+00,-1.0312381e+00,-1.0309777e+00,-1.0307175e+00,
  -1.0304573e+00,-1.0301971e+00,-1.0299370e+00,-1.0296770e+00,
  -1.0294172e+00,-1.0291573e+00,-1.0288975e+00,-1.0286378e+00,
  -1.0283781e+00,-1.0281186e+00,-1.0278591e+00,-1.0275997e+00,
  -1.0273403e+00,-1.0270810e+00,-1.0268217e+00,-1.0265626e+00,
  -1.0263035e+00,-1.0260445e+00,-1.0257856e+00,-1.0255266e+00,
  -1.0252678e+00,-1.0250092e+00,-1.0247505e+00,-1.0244918e+00,
  -1.0242333e+00,-1.0239748e+00,-1.0237164e+00,-1.0234581e+00,
  -1.0231998e+00,-1.0229416e+00,-1.0226835e+00,-1.0224254e+00,
  -1.0221674e+00,-1.0219095e+00,-1.0216516e+00,-1.0213939e+00,
  -1.0211362e+00,-1.0208784e+00,-1.0206209e+00,-1.0203633e+00,
  -1.0201060e+00,-1.0198486e+00,-1.0195912e+00,-1.0193340e+00,
  -1.0190768e+00,-1.0188197e+00,-1.0185627e+00,-1.0183057e+00,
  -1.0180488e+00,-1.0177919e+00,-1.0175351e+00,-1.0172784e+00,
  -1.0170218e+00,-1.0167652e+00,-1.0165087e+00,-1.0162523e+00,
  -1.0159959e+00,-1.0157396e+00,-1.0154834e+00,-1.0152272e+00,
  -1.0149710e+00,-1.0147150e+00,-1.0144590e+00,-1.0142031e+00,
  -1.0139472e+00,-1.0136915e+00,-1.0134358e+00,-1.0131801e+00,
  -1.0129246e+00,-1.0126691e+00,-1.0124136e+00,-1.0121583e+00,
  -1.0119029e+00,-1.0116477e+00,-1.0113925e+00,-1.0111374e+00,
  -1.0108824e+00,-1.0106274e+00,-1.0103724e+00,-1.0101175e+00,
  -1.0098628e+00,-1.0096080e+00,-1.0093534e+00,-1.0090988e+00,
  -1.0088443e+00,-1.0085899e+00,-1.0083355e+00,-1.0080811e+00,
  -1.0078268e+00,-1.0075727e+00,-1.0073185e+00,-1.0070645e+00,
  -1.0068104e+00,-1.0065565e+00,-1.0063026e+00,-1.0060488e+00,
  -1.0057951e+00,-1.0055413e+00,-1.0052878e+00,-1.0050342e+00,
  -1.0047808e+00,-1.0045273e+00,-1.0042740e+00,-1.0040207e+00,
  -1.0037675e+00,-1.0035143e+00,-1.0032612e+00,-1.0030081e+00,
  -1.0027552e+00,-1.0025022e+00,-1.0022494e+00,-1.0019966e+00,
  -1.0017439e+00,-1.0014913e+00,-1.0012387e+00,-1.0009862e+00,
  -1.0007337e+00,-1.0004814e+00,-1.0002290e+00,-9.9997669e-01,
  -9.9972451e-01,-9.9947238e-01,-9.9922031e-01,-9.9896824e-01,
  -9.9871629e-01,-9.9846447e-01,-9.9821264e-01,-9.9796087e-01,
  -9.9770916e-01,-9.9745750e-01,-9.9720597e-01,-9.9695444e-01,
  -9.9670297e-01,-9.9645162e-01,-9.9620032e-01,-9.9594903e-01,
  -9.9569786e-01,-9.9544674e-01,-9.9519563e-01,-9.9494463e-01,
  -9.9469370e-01,-9.9444282e-01,-9.9419200e-01,-9.9394125e-01,
  -9.9369055e-01,-9.9343991e-01,-9.9318939e-01,-9.9293888e-01,
  -9.9268842e-01,-9.9243802e-01,-9.9218774e-01,-9.9193746e-01,
  -9.9168730e-01,-9.9143714e-01,-9.9118710e-01,-9.9093705e-01,
  -9.9068713e-01,-9.9043721e-01,-9.9018741e-01,-9.8993766e-01,
  -9.8968798e-01,-9.8943830e-01,-9.8918873e-01,-9.8893923e-01,
  -9.8868978e-01,-9.8844039e-01,-9.8819107e-01,-9.8794180e-01,
  -9.8769259e-01,-9.8744345e-01,-9.8719436e-01,-9.8694533e-01,
  -9.8669636e-01,-9.8644745e-01,-9.8619866e-01,-9.8594987e-01,
  -9.8570114e-01,-9.8545247e-01,-9.8520392e-01,-9.8495537e-01,
  -9.8470688e-01,-9.8445845e-01,-9.8421013e-01,-9.8396182e-01,
  -9.8371363e-01,-9.8346543e-01,-9.8321730e-01,-9.8296928e-01,
  -9.8272127e-01,-9.8247337e-01,-9.8222548e-01,-9.8197770e-01,
  -9.8172992e-01,-9.8148227e-01,-9.8123461e-01,-9.8098707e-01,
  -9.8073953e-01,-9.8049212e-01,-9.8024470e-01,-9.7999740e-01,
  -9.7975016e-01,-9.7950292e-01,-9.7925580e-01,-9.7900867e-01,
  -9.7876167e-01,-9.7851467e-01,-9.7826779e-01,-9.7802097e-01,
  -9.7777414e-01,-9.7752744e-01,-9.7728074e-01,-9.7703415e-01,
  -9.7678757e-01,-9.7654110e-01,-9.7629470e-01,-9.7604829e-01,
  -9.7580200e-01,-9.7555572e-01,-9.7530955e-01,-9.7506338e-01,
  -9.7481734e-01,-9.7457129e-01,-9.7432536e-01,-9.7407943e-01,
  -9.7383362e-01,-9.7358781e-01,-9.7334212e-01,-9.7309643e-01,
  -9.7285086e-01,-9.7260529e-01,-9.7235978e-01,-9.7211438e-01,
  -9.7186899e-01,-9.7162366e-01,-9.7137845e-01,-9.7113323e-01,
  -9.7088808e-01,-9.7064304e-01,-9.7039801e-01,-9.7015303e-01,
  -9.6990812e-01,-9.6966326e-01,-9.6941847e-01,-9.6917379e-01,
  -9.6892911e-01,-9.6868449e-01,-9.6843994e-01,-9.6819544e-01,
  -9.6795100e-01,-9.6770662e-01,-9.6746230e-01,-9.6721798e-01,
  -9.6697378e-01,-9.6672964e-01,-9.6648556e-01,-9.6624154e-01,
  -9.6599752e-01,-9.6575361e-01,-9.6550977e-01,-9.6526593e-01,
  -9.6502221e-01,-9.6477848e-01,-9.6453488e-01,-9.6429127e-01,
  -9.6404779e-01,-9.6380430e-01,-9.6356088e-01,-9.6331757e-01,
  -9.6307427e-01,-9.6283102e-01,-9.6258783e-01,-9.6234471e-01,
  -9.6210164e-01,-9.6185863e-01,-9.6161568e-01,-9.6137279e-01,
  -9.6112996e-01,-9.6088719e-01,-9.6064448e-01,-9.6040183e-01,
  -9.6015918e-01,-9.5991665e-01,-9.5967412e-01,-9.5943171e-01,
  -9.5918930e-01,-9.5894700e-01,-9.5870471e-01,-9.5846248e-01,
  -9.5822036e-01,-9.5797825e-01,-9.5773619e-01,-9.5749420e-01,
  -9.5725226e-01,-9.5701039e-01,-9.5676857e-01,-9.5652682e-01,
  -9.5628506e-01,-9.5604342e-01,-9.5580184e-01,-9.5556027e-01,
  -9.5531881e-01,-9.5507735e-01,-9.5483601e-01,-9.5459467e-01,
  -9.5435339e-01,-9.5411217e-01,-9.5387101e-01,-9.5362991e-01,
  -9.5338887e-01,-9.5314789e-01,-9.5290697e-01,-9.5266610e-01,
  -9.5242524e-01,-9.5218450e-01,-9.5194381e-01,-9.5170313e-01,
  -9.5146251e-01,-9.5122200e-01,-9.5098150e-01,-9.5074105e-01,
  -9.5050067e-01,-9.5026034e-01,-9.5002007e-01,-9.4977987e-01,
  -9.4953972e-01,-9.4929957e-01,-9.4905955e-01,-9.4881952e-01,
  -9.4857961e-01,-9.4833970e-01,-9.4809985e-01,-9.4786006e-01,
  -9.4762039e-01,-9.4738066e-01,-9.4714105e-01,-9.4690150e-01,
  -9.4666201e-01,-9.4642258e-01,-9.4618315e-01,-9.4594383e-01,
  -9.4570452e-01,-9.4546527e-01,-9.4522607e-01,-9.4498694e-01,
  -9.4474787e-01,-9.4450885e-01,-9.4426990e-01,-9.4403100e-01,
  -9.4379210e-01,-9.4355333e-01,-9.4331455e-01,-9.4307590e-01,
  -9.4283724e-01,-9.4259864e-01,-9.4236010e-01,-9.4212162e-01,
  -9.4188321e-01,-9.4164485e-01,-9.4140649e-01,-9.4116825e-01,
  -9.4093001e-01,-9.4069183e-01,-9.4045377e-01,-9.4021571e-01,
  -9.3997771e-01,-9.3973976e-01,-9.3950182e-01,-9.3926400e-01,
  -9.3902624e-01,-9.3878847e-01,-9.3855077e-01,-9.3831319e-01,
  -9.3807560e-01,-9.3783808e-01,-9.3760061e-01,-9.3736315e-01,
  -9.3712580e-01,-9.3688852e-01,-9.3665123e-01,-9.3641400e-01,
  -9.3617690e-01,-9.3593979e-01,-9.3570274e-01,-9.3546569e-01,
  -9.3522877e-01,-9.3499190e-01,-9.3475503e-01,-9.3451828e-01,
  -9.3428153e-01,-9.3404484e-01,-9.3380821e-01,-9.3357164e-01,
  -9.3333513e-01,-9.3309861e-01,-9.3286222e-01,-9.3262583e-01,
  -9.3238950e-01,-9.3215328e-01,-9.3191707e-01,-9.3168086e-01,
  -9.3144476e-01,-9.3120873e-01,-9.3097270e-01,-9.3073678e-01,
  -9.3050086e-01,-9.3026501e-01,-9.3002921e-01,-9.2979348e-01,
  -9.2955780e-01,-9.2932212e-01,-9.2908657e-01,-9.2885101e-01,
  -9.2861551e-01,-9.2838007e-01,-9.2814469e-01,-9.2790937e-01,
  -9.2767406e-01,-9.2743886e-01,-9.2720366e-01,-9.2696851e-01,
  -9.2673343e-01,-9.2649841e-01,-9.2626345e-01,-9.2602855e-01,
  -9.2579365e-01,-9.2555881e-01,-9.2532408e-01,-9.2508936e-01,
  -9.2485470e-01,-9.2462003e-01,-9.2438549e-01,-9.2415094e-01,
  -9.2391652e-01,-9.2368209e-01,-9.2344773e-01,-9.2321342e-01,
  -9.2297918e-01,-9.2274493e-01,-9.2251080e-01,-9.2227668e-01,
  -9.2204261e-01,-9.2180860e-01,-9.2157465e-01,-9.2134070e-01,
  -9.2110687e-01,-9.2087305e-01,-9.2063934e-01,-9.2040563e-01,
  -9.2017192e-01,-9.1993833e-01,-9.1970479e-01,-9.1947126e-01,
  -9.1923779e-01,-9.1900444e-01,-9.1877103e-01,-9.1853774e-01,
  -9.1830450e-01,-9.1807127e-01,-9.1783816e-01,-9.1760504e-01,
  -9.1737199e-01,-9.1713893e-01,-9.1690600e-01,-9.1667312e-01,
  -9.1644025e-01,-9.1620743e-01,-9.1597468e-01,-9.1574198e-01,
  -9.1550928e-01,-9.1527671e-01,-9.1504413e-01,-9.1481161e-01,
  -9.1457915e-01,-9.1434675e-01,-9.1411442e-01,-9.1388208e-01,
  -9.1364980e-01,-9.1341758e-01,-9.1318542e-01,-9.1295332e-01,
  -9.1272128e-01,-9.1248924e-01,-9.1225725e-01,-9.1202533e-01,
  -9.1179347e-01,-9.1156167e-01,-9.1132987e-01,-9.1109818e-01,
  -9.1086650e-01,-9.1063488e-01,-9.1040331e-01,-9.1017175e-01,
  -9.0994030e-01,-9.0970886e-01,-9.0947747e-01,-9.0924615e-01,
  -9.0901482e-01,-9.0878361e-01,-9.0855241e-01,-9.0832126e-01,
  -9.0809017e-01,-9.0785915e-01,-9.0762818e-01,-9.0739721e-01,
  -9.0716630e-01,-9.0693545e-01,-9.0670466e-01,-9.0647393e-01,
  -9.0624321e-01,-9.0601259e-01,-9.0578198e-01,-9.0555137e-01,
  -9.0532088e-01,-9.0509045e-01,-9.0486002e-01,-9.0462965e-01,
  -9.0439934e-01,-9.0416908e-01,-9.0393883e-01,-9.0370864e-01,
  -9.0347856e-01,-9.0324843e-01,-9.0301841e-01,-9.0278846e-01,
  -9.0255851e-01,-9.0232861e-01,-9.0209877e-01,-9.0186900e-01,
  -9.0163922e-01,-9.0140957e-01,-9.0117991e-01,-9.0095031e-01,
  -9.0072072e-01,-9.0049124e-01,-9.0026176e-01,-9.0003234e-01,
  -8.9980298e-01,-8.9957368e-01,-8.9934438e-01,-8.9911520e-01,
  -8.9888602e-01,-8.9865690e-01,-8.9842778e-01,-8.9819878e-01,
  -8.9796978e-01,-8.9774084e-01,-8.9751196e-01,-8.9728308e-01,
  -8.9705431e-01,-8.9682555e-01,-8.9659685e-01,-8.9636821e-01,
  -8.9613956e-01,-8.9591098e-01,-8.9568251e-01,-8.9545399e-01,
  -8.9522558e-01,-8.9499724e-01,-8.9476889e-01,-8.9454061e-01,
  -8.9431238e-01,-8.9408416e-01,-8.9385605e-01,-8.9362794e-01,
  -8.9339989e-01,-8.9317185e-01,-8.9294392e-01,-8.9271599e-01,
  -8.9248812e-01,-8.9226031e-01,-8.9203256e-01,-8.9180481e-01,
  -8.9157712e-01,-8.9134949e-01,-8.9112192e-01,-8.9089435e-01,
  -8.9066684e-01,-8.9043945e-01,-8.9021200e-01,-8.8998467e-01,
  -8.8975734e-01,-8.8953006e-01,-8.8930285e-01,-8.8907570e-01,
  -8.8884854e-01,-8.8862145e-01,-8.8839442e-01,-8.8816744e-01,
  -8.8794053e-01,-8.8771361e-01,-8.8748676e-01,-8.8725996e-01,
  -8.8703316e-01,-8.8680649e-01,-8.8657981e-01,-8.8635319e-01,
  -8.8612658e-01,-8.8590008e-01,-8.8567358e-01,-8.8544714e-01,
  -8.8522071e-01,-8.8499439e-01,-8.8476807e-01,-8.8454181e-01,
  -8.8431555e-01,-8.8408941e-01,-8.8386327e-01,-8.8363719e-01,
  -8.8341117e-01,-8.8318515e-01,-8.8295925e-01,-8.8273335e-01,
  -8.8250744e-01,-8.8228166e-01,-8.8205588e-01,-8.8183016e-01,
  -8.8160449e-01,-8.8137889e-01,-8.8115329e-01,-8.8092774e-01,
  -8.8070226e-01,-8.8047677e-01,-8.8025135e-01,-8.8002604e-01,
  -8.7980068e-01,-8.7957543e-01,-8.7935019e-01,-8.7912500e-01,
  -8.7889987e-01,-8.7867481e-01,-8.7844974e-01,-8.7822473e-01,
  -8.7799978e-01,-8.7777483e-01,-8.7754995e-01,-8.7732512e-01,
  -8.7710035e-01,-8.7687564e-01,-8.7665093e-01,-8.7642628e-01,
  -8.7620169e-01,-8.7597710e-01,-8.7575257e-01,-8.7552810e-01,
  -8.7530369e-01,-8.7507927e-01,-8.7485492e-01,-8.7463063e-01,
  -8.7440640e-01,-8.7418216e-01,-8.7395799e-01,-8.7373388e-01,
  -8.7350982e-01,-8.7328577e-01,-8.7306178e-01,-8.7283784e-01,
  -8.7261397e-01,-8.7239009e-01,-8.7216628e-01,-8.7194252e-01,
  -8.7171876e-01,-8.7149507e-01,-8.7127143e-01,-8.7104785e-01,
  -8.7082428e-01,-8.7060076e-01,-8.7037730e-01,-8.7015390e-01,
  -8.6993051e-01,-8.6970717e-01,-8.6948389e-01,-8.6926061e-01,
  -8.6903745e-01,-8.6881423e-01,-8.6859113e-01,-8.6836809e-01,
  -8.6814505e-01,-8.6792201e-01,-8.6769909e-01,-8.6747617e-01,
  -8.6725330e-01,-8.6703050e-01,-8.6680776e-01,-8.6658502e-01,
  -8.6636233e-01,-8.6613965e-01,-8.6591709e-01,-8.6569452e-01,
  -8.6547196e-01,-8.6524951e-01,-8.6502707e-01,-8.6480469e-01,
  -8.6458236e-01,-8.6436003e-01,-8.6413777e-01,-8.6391556e-01,
  -8.6369336e-01,-8.6347127e-01,-8.6324918e-01,-8.6302710e-01,
  -8.6280513e-01,-8.6258316e-01,-8.6236125e-01,-8.6213934e-01,
  -8.6191750e-01,-8.6169571e-01,-8.6147398e-01,-8.6125225e-01,
  -8.6103058e-01,-8.6080897e-01,-8.6058742e-01,-8.6036587e-01,
  -8.6014438e-01,-8.5992289e-01,-8.5970151e-01,-8.5948014e-01,
  -8.5925877e-01,-8.5903752e-01,-8.5881627e-01,-8.5859507e-01,
  -8.5837388e-01,-8.5815281e-01,-8.5793167e-01,-8.5771066e-01,
  -8.5748965e-01,-8.5726875e-01,-8.5704780e-01,-8.5682696e-01,
  -8.5660613e-01,-8.5638535e-01,-8.5616457e-01,-8.5594392e-01,
  -8.5572326e-01,-8.5550261e-01,-8.5528207e-01,-8.5506153e-01,
  -8.5484105e-01,-8.5462058e-01,-8.5440016e-01,-8.5417980e-01,
  -8.5395950e-01,-8.5373920e-01,-8.5351896e-01,-8.5329872e-01,
  -8.5307860e-01,-8.5285848e-01,-8.5263836e-01,-8.5241836e-01,
  -8.5219836e-01,-8.5197842e-01,-8.5175848e-01,-8.5153860e-01,
  -8.5131878e-01,-8.5109901e-01,-8.5087925e-01,-8.5065955e-01,
  -8.5043991e-01,-8.5022026e-01,-8.5000068e-01,-8.4978116e-01,
  -8.4956163e-01,-8.4934217e-01,-8.4912276e-01,-8.4890336e-01,
  -8.4868401e-01,-8.4846473e-01,-8.4824550e-01,-8.4802628e-01,
  -8.4780711e-01,-8.4758794e-01,-8.4736884e-01,-8.4714979e-01,
  -8.4693080e-01,-8.4671181e-01,-8.4649289e-01,-8.4627402e-01,
  -8.4605515e-01,-8.4583634e-01,-8.4561759e-01,-8.4539884e-01,
  -8.4518015e-01,-8.4496152e-01,-8.4474289e-01,-8.4452432e-01,
  -8.4430581e-01,-8.4408730e-01,-8.4386891e-01,-8.4365046e-01,
  -8.4343213e-01,-8.4321380e-01,-8.4299552e-01,-8.4277725e-01,
  -8.4255904e-01,-8.4234089e-01,-8.4212279e-01,-8.4190470e-01,
  -8.4168661e-01,-8.4146863e-01,-8.4125066e-01,-8.4103274e-01,
  -8.4081483e-01,-8.4059703e-01,-8.4037918e-01,-8.4016144e-01,
  -8.3994371e-01,-8.3972603e-01,-8.3950841e-01,-8.3929080e-01,
  -8.3907324e-01,-8.3885568e-01,-8.3863819e-01,-8.3842075e-01,
  -8.3820337e-01,-8.3798599e-01,-8.3776867e-01,-8.3755136e-01,
  -8.3733410e-01,-8.3711690e-01,-8.3689976e-01,-8.3668262e-01,
  -8.3646554e-01,-8.3624846e-01,-8.3603144e-01,-8.3581448e-01,
  -8.3559757e-01,-8.3538067e-01,-8.3516377e-01,-8.3494699e-01,
  -8.3473021e-01,-8.3451349e-01,-8.3429676e-01,-8.3408010e-01,
  -8.3386350e-01,-8.3364689e-01,-8.3343035e-01,-8.3321387e-01,
  -8.3299738e-01,-8.3278096e-01,-8.3256459e-01,-8.3234823e-01,
  -8.3213192e-01,-8.3191568e-01,-8.3169943e-01,-8.3148324e-01,
  -8.3126712e-01,-8.3105099e-01,-8.3083493e-01,-8.3061886e-01,
  -8.3040285e-01,-8.3018690e-01,-8.2997102e-01,-8.2975513e-01,
  -8.2953930e-01,-8.2932347e-01,-8.2910770e-01,-8.2889199e-01,
  -8.2867628e-01,-8.2846063e-01,-8.2824504e-01,-8.2802945e-01,
  -8.2781392e-01,-8.2759845e-01,-8.2738298e-01,-8.2716757e-01,
  -8.2695216e-01,-8.2673687e-01,-8.2652152e-01,-8.2630628e-01,
  -8.2609105e-01,-8.2587588e-01,-8.2566071e-01,-8.2544559e-01,
  -8.2523054e-01,-8.2501549e-01,-8.2480049e-01,-8.2458556e-01,
  -8.2437062e-01,-8.2415575e-01,-8.2394087e-01,-8.2372606e-01,
  -8.2351130e-01,-8.2329661e-01,-8.2308191e-01,-8.2286721e-01,
  -8.2265264e-01,-8.2243806e-01,-8.2222348e-01,-8.2200897e-01,
  -8.2179451e-01,-8.2158011e-01,-8.2136571e-01,-8.2115138e-01,
  -8.2093704e-01,-8.2072276e-01,-8.2050854e-01,-8.2029432e-01,
  -8.2008016e-01,-8.1986606e-01,-8.1965196e-01,-8.1943792e-01,
  -8.1922388e-01,-8.1900990e-01,-8.1879598e-01,-8.1858206e-01,
  -8.1836820e-01,-8.1815439e-01,-8.1794059e-01,-8.1772685e-01,
  -8.1751311e-01,-8.1729943e-01,-8.1708580e-01,-8.1687218e-01,
  -8.1665862e-01,-8.1644511e-01,-8.1623161e-01,-8.1601816e-01,
  -8.1580472e-01,-8.1559139e-01,-8.1537801e-01,-8.1516474e-01,
  -8.1495148e-01,-8.1473821e-01,-8.1452501e-01,-8.1431186e-01,
  -8.1409878e-01,-8.1388569e-01,-8.1367260e-01,-8.1345963e-01,
  -8.1324667e-01,-8.1303370e-01,-8.1282079e-01,-8.1260794e-01,
  -8.1239510e-01,-8.1218231e-01,-8.1196958e-01,-8.1175685e-01,
  -8.1154418e-01,-8.1133157e-01,-8.1111896e-01,-8.1090641e-01,
  -8.1069386e-01,-8.1048137e-01,-8.1026888e-01,-8.1005645e-01,
  -8.0984408e-01,-8.0963176e-01,-8.0941945e-01,-8.0920714e-01,
  -8.0899495e-01,-8.0878270e-01,-8.0857056e-01,-8.0835843e-01,
  -8.0814636e-01,-8.0793428e-01,-8.0772227e-01,-8.0751026e-01,
  -8.0729830e-01,-8.0708641e-01,-8.0687451e-01,-8.0666268e-01,
  -8.0645090e-01,-8.0623913e-01,-8.0602741e-01,-8.0581570e-01,
  -8.0560404e-01,-8.0539244e-01,-8.0518085e-01,-8.0496931e-01,
  -8.0475777e-01,-8.0454630e-01,-8.0433488e-01,-8.0412346e-01,
  -8.0391210e-01,-8.0370075e-01,-8.0348945e-01,-8.0327821e-01,
  -8.0306697e-01,-8.0285579e-01,-8.0264461e-01,-8.0243349e-01,
  -8.0222243e-01,-8.0201137e-01,-8.0180037e-01,-8.0158937e-01,
  -8.0137843e-01,-8.0116755e-01,-8.0095667e-01,-8.0074584e-01,
  -8.0053502e-01,-8.0032426e-01,-8.0011356e-01,-7.9990286e-01,
  -7.9969221e-01,-7.9948157e-01,-7.9927099e-01,-7.9906040e-01,
  -7.9884994e-01,-7.9863942e-01,-7.9842901e-01,-7.9821861e-01,
  -7.9800820e-01,-7.9779786e-01,-7.9758757e-01,-7.9737729e-01,
  -7.9716706e-01,-7.9695690e-01,-7.9674673e-01,-7.9653656e-01,
  -7.9632652e-01,-7.9611647e-01,-7.9590642e-01,-7.9569644e-01,
  -7.9548651e-01,-7.9527658e-01,-7.9506671e-01,-7.9485685e-01,
  -7.9464704e-01,-7.9443729e-01,-7.9422754e-01,-7.9401779e-01,
  -7.9380816e-01,-7.9359853e-01,-7.9338890e-01,-7.9317933e-01,
  -7.9296982e-01,-7.9276031e-01,-7.9255086e-01,-7.9234141e-01,
  -7.9213202e-01,-7.9192269e-01,-7.9171336e-01,-7.9150409e-01,
  -7.9129481e-01,-7.9108560e-01,-7.9087639e-01,-7.9066724e-01,
  -7.9045814e-01,-7.9024905e-01,-7.9004002e-01,-7.8983098e-01,
  -7.8962201e-01,-7.8941309e-01,-7.8920418e-01,-7.8899533e-01,
  -7.8878647e-01,-7.8857768e-01,-7.8836888e-01,-7.8816015e-01,
  -7.8795147e-01,-7.8774279e-01,-7.8753418e-01,-7.8732556e-01,
  -7.8711700e-01,-7.8690845e-01,-7.8669995e-01,-7.8649151e-01,
  -7.8628308e-01,-7.8607470e-01,-7.8586632e-01,-7.8565800e-01,
  -7.8544968e-01,-7.8524148e-01,-7.8503323e-01,-7.8482503e-01,
  -7.8461689e-01,-7.8440875e-01,-7.8420067e-01,-7.8399265e-01,
  -7.8378463e-01,-7.8357661e-01,-7.8336865e-01,-7.8316075e-01,
  -7.8295285e-01,-7.8274500e-01,-7.8253722e-01,-7.8232944e-01,
  -7.8212166e-01,-7.8191394e-01,-7.8170627e-01,-7.8149861e-01,
  -7.8129101e-01,-7.8108346e-01,-7.8087592e-01,-7.8066838e-01,
  -7.8046089e-01,-7.8025347e-01,-7.8004605e-01,-7.7983868e-01,
  -7.7963132e-01,-7.7942401e-01,-7.7921671e-01,-7.7900952e-01,
  -7.7880228e-01,-7.7859509e-01,-7.7838796e-01,-7.7818084e-01,
  -7.7797377e-01,-7.7776670e-01,-7.7755970e-01,-7.7735275e-01,
  -7.7714580e-01,-7.7693892e-01,-7.7673203e-01,-7.7652514e-01,
  -7.7631837e-01,-7.7611160e-01,-7.7590483e-01,-7.7569813e-01,
  -7.7549142e-01,-7.7528483e-01,-7.7507818e-01,-7.7487159e-01,
  -7.7466506e-01,-7.7445853e-01,-7.7425206e-01,-7.7404565e-01,
  -7.7383924e-01,-7.7363282e-01,-7.7342647e-01,-7.7322018e-01,
  -7.7301389e-01,-7.7280766e-01,-7.7260143e-01,-7.7239525e-01,
  -7.7218908e-01,-7.7198297e-01,-7.7177691e-01,-7.7157086e-01,
  -7.7136481e-01,-7.7115881e-01,-7.7095288e-01,-7.7074695e-01,
  -7.7054107e-01,-7.7033520e-01,-7.7012938e-01,-7.6992357e-01,
  -7.6971781e-01,-7.6951212e-01,-7.6930642e-01,-7.6910079e-01,
  -7.6889515e-01,-7.6868951e-01,-7.6848400e-01,-7.6827842e-01,
  -7.6807296e-01,-7.6786751e-01,-7.6766205e-01,-7.6745665e-01,
  -7.6725125e-01,-7.6704592e-01,-7.6684064e-01,-7.6663536e-01,
  -7.6643014e-01,-7.6622492e-01,-7.6601976e-01,-7.6581460e-01,
  -7.6560950e-01,-7.6540440e-01,-7.6519936e-01,-7.6499438e-01,
  -7.6478940e-01,-7.6458442e-01,-7.6437950e-01,-7.6417464e-01,
  -7.6396978e-01,-7.6376498e-01,-7.6356018e-01,-7.6335543e-01,
  -7.6315069e-01,-7.6294601e-01,-7.6274133e-01,-7.6253670e-01,
  -7.6233208e-01,-7.6212752e-01,-7.6192302e-01,-7.6171851e-01,
  -7.6151401e-01,-7.6130962e-01,-7.6110518e-01,-7.6090080e-01,
  -7.6069647e-01,-7.6049215e-01,-7.6028788e-01,-7.6008362e-01,
  -7.5987941e-01,-7.5967526e-01,-7.5947106e-01,-7.5926697e-01,
  -7.5906289e-01,-7.5885880e-01,-7.5865477e-01,-7.5845081e-01,
  -7.5824684e-01,-7.5804293e-01,-7.5783902e-01,-7.5763512e-01,
  -7.5743133e-01,-7.5722748e-01,-7.5702375e-01,-7.5681996e-01,
  -7.5661629e-01,-7.5641263e-01,-7.5620896e-01,-7.5600535e-01,
  -7.5580174e-01,-7.5559819e-01,-7.5539470e-01,-7.5519121e-01,
  -7.5498772e-01,-7.5478429e-01,-7.5458091e-01,-7.5437754e-01,
  -7.5417417e-01,-7.5397086e-01,-7.5376761e-01,-7.5356436e-01,
  -7.5336117e-01,-7.5315797e-01,-7.5295484e-01,-7.5275171e-01,
  -7.5254864e-01,-7.5234556e-01,-7.5214255e-01,-7.5193954e-01,
  -7.5173658e-01,-7.5153369e-01,-7.5133079e-01,-7.5112790e-01,
  -7.5092506e-01,-7.5072223e-01,-7.5051945e-01,-7.5031674e-01,
  -7.5011402e-01,-7.4991131e-01,-7.4970865e-01,-7.4950606e-01,
  -7.4930346e-01,-7.4910092e-01,-7.4889839e-01,-7.4869585e-01,
  -7.4849343e-01,-7.4829096e-01,-7.4808854e-01,-7.4788618e-01,
  -7.4768382e-01,-7.4748152e-01,-7.4727923e-01,-7.4707699e-01,
  -7.4687475e-01,-7.4667257e-01,-7.4647039e-01,-7.4626827e-01,
  -7.4606615e-01,-7.4586409e-01,-7.4566203e-01,-7.4546003e-01,
  -7.4525809e-01,-7.4505609e-01,-7.4485421e-01,-7.4465233e-01,
  -7.4445045e-01,-7.4424863e-01,-7.4404681e-01,-7.4384505e-01,
  -7.4364334e-01,-7.4344164e-01,-7.4323994e-01,-7.4303830e-01,
  -7.4283665e-01,-7.4263507e-01,-7.4243355e-01,-7.4223202e-01,
  -7.4203050e-01,-7.4182904e-01,-7.4162763e-01,-7.4142623e-01,
  -7.4122483e-01,-7.4102348e-01,-7.4082220e-01,-7.4062091e-01,
  -7.4041963e-01,-7.4021840e-01,-7.4001724e-01,-7.3981607e-01,
  -7.3961490e-01,-7.3941380e-01,-7.3921275e-01,-7.3901170e-01,
  -7.3881066e-01,-7.3860967e-01,-7.3840874e-01,-7.3820782e-01,
  -7.3800689e-01,-7.3780602e-01,-7.3760521e-01,-7.3740441e-01,
  -7.3720360e-01,-7.3700285e-01,-7.3680216e-01,-7.3660147e-01,
  -7.3640078e-01,-7.3620015e-01,-7.3599958e-01,-7.3579901e-01,
  -7.3559844e-01,-7.3539793e-01,-7.3519748e-01,-7.3499703e-01,
  -7.3479658e-01,-7.3459619e-01,-7.3439586e-01,-7.3419553e-01,
  -7.3399520e-01,-7.3379493e-01,-7.3359466e-01,-7.3339444e-01,
  -7.3319429e-01,-7.3299414e-01,-7.3279399e-01,-7.3259389e-01,
  -7.3239380e-01,-7.3219377e-01,-7.3199379e-01,-7.3179382e-01,
  -7.3159385e-01,-7.3139393e-01,-7.3119402e-01,-7.3099416e-01,
  -7.3079431e-01,-7.3059452e-01,-7.3039472e-01,-7.3019499e-01,
  -7.2999531e-01,-7.2979558e-01,-7.2959596e-01,-7.2939628e-01,
  -7.2919673e-01,-7.2899711e-01,-7.2879755e-01,-7.2859806e-01,
  -7.2839856e-01,-7.2819912e-01,-7.2799969e-01,-7.2780031e-01,
  -7.2760093e-01,-7.2740161e-01,-7.2720230e-01,-7.2700298e-01,
  -7.2680372e-01,-7.2660452e-01,-7.2640532e-01,-7.2620612e-01,
  -7.2600698e-01,-7.2580791e-01,-7.2560883e-01,-7.2540975e-01,
  -7.2521073e-01,-7.2501177e-01,-7.2481281e-01,-7.2461385e-01,
  -7.2441494e-01,-7.2421604e-01,-7.2401720e-01,-7.2381836e-01,
  -7.2361958e-01,-7.2342080e-01,-7.2322208e-01,-7.2302336e-01,
  -7.2282469e-01,-7.2262603e-01,-7.2242743e-01,-7.2222883e-01,
  -7.2203022e-01,-7.2183174e-01,-7.2163320e-01,-7.2143471e-01,
  -7.2123629e-01,-7.2103786e-01,-7.2083944e-01,-7.2064108e-01,
  -7.2044271e-01,-7.2024441e-01,-7.2004616e-01,-7.1984792e-01,
  -7.1964967e-01,-7.1945149e-01,-7.1925330e-01,-7.1905518e-01,
  -7.1885705e-01,-7.1865898e-01,-7.1846092e-01,-7.1826285e-01,
  -7.1806484e-01,-7.1786690e-01,-7.1766895e-01,-7.1747106e-01,
  -7.1727318e-01,-7.1707529e-01,-7.1687746e-01,-7.1667963e-01,
  -7.1648186e-01,-7.1628416e-01,-7.1608639e-01,-7.1588874e-01,
  -7.1569109e-01,-7.1549344e-01,-7.1529579e-01,-7.1509826e-01,
  -7.1490067e-01,-7.1470314e-01,-7.1450567e-01,-7.1430820e-01,
  -7.1411073e-01,-7.1391332e-01,-7.1371597e-01,-7.1351862e-01,
  -7.1332127e-01,-7.1312398e-01,-7.1292669e-01,-7.1272945e-01,
  -7.1253222e-01,-7.1233505e-01,-7.1213788e-01,-7.1194077e-01,
  -7.1174365e-01,-7.1154654e-01,-7.1134949e-01,-7.1115249e-01,
  -7.1095550e-01,-7.1075851e-01,-7.1056157e-01,-7.1036464e-01,
  -7.1016777e-01,-7.0997089e-01,-7.0977408e-01,-7.0957726e-01,
  -7.0938051e-01,-7.0918375e-01,-7.0898706e-01,-7.0879036e-01,
  -7.0859367e-01,-7.0839703e-01,-7.0820040e-01,-7.0800382e-01,
  -7.0780730e-01,-7.0761073e-01,-7.0741427e-01,-7.0721775e-01,
  -7.0702136e-01,-7.0682490e-01,-7.0662850e-01,-7.0643216e-01,
  -7.0623583e-01,-7.0603949e-01,-7.0584321e-01,-7.0564693e-01,
  -7.0545071e-01,-7.0525450e-01,-7.0505834e-01,-7.0486218e-01,
  -7.0466608e-01,-7.0446998e-01,-7.0427394e-01,-7.0407790e-01,
  -7.0388186e-01,-7.0368588e-01,-7.0348990e-01,-7.0329398e-01,
  -7.0309806e-01,-7.0290220e-01,-7.0270634e-01,-7.0251054e-01,
  -7.0231473e-01,-7.0211893e-01,-7.0192319e-01,-7.0172751e-01,
  -7.0153183e-01,-7.0133615e-01,-7.0114052e-01,-7.0094490e-01,
  -7.0074934e-01,-7.0055377e-01,-7.0035821e-01,-7.0016271e-01,
  -6.9996727e-01,-6.9977182e-01,-6.9957638e-01,-6.9938099e-01,
  -6.9918561e-01,-6.9899029e-01,-6.9879496e-01,-6.9859970e-01,
  -6.9840443e-01,-6.9820917e-01,-6.9801396e-01,-6.9781876e-01,
  -6.9762361e-01,-6.9742852e-01,-6.9723338e-01,-6.9703835e-01,
  -6.9684327e-01,-6.9664824e-01,-6.9645327e-01,-6.9625831e-01,
  -6.9606334e-01,-6.9586843e-01,-6.9567353e-01,-6.9547868e-01,
  -6.9528383e-01,-6.9508904e-01,-6.9489425e-01,-6.9469947e-01,
  -6.9450474e-01,-6.9431007e-01,-6.9411534e-01,-6.9392073e-01,
  -6.9372606e-01,-6.9353145e-01,-6.9333690e-01,-6.9314235e-01,
  -6.9294786e-01,-6.9275331e-01,-6.9255888e-01,-6.9236445e-01,
  -6.9217002e-01,-6.9197559e-01,-6.9178128e-01,-6.9158691e-01,
  -6.9139260e-01,-6.9119835e-01,-6.9100404e-01,-6.9080985e-01,
  -6.9061559e-01,-6.9042146e-01,-6.9022727e-01,-6.9003314e-01,
  -6.8983907e-01,-6.8964499e-01,-6.8945092e-01,-6.8925691e-01,
  -6.8906289e-01,-6.8886894e-01,-6.8867499e-01,-6.8848103e-01,
  -6.8828714e-01,-6.8809330e-01,-6.8789941e-01,-6.8770564e-01,
  -6.8751180e-01,-6.8731803e-01,-6.8712431e-01,-6.8693060e-01,
  -6.8673688e-01,-6.8654323e-01,-6.8634963e-01,-6.8615597e-01,
  -6.8596238e-01,-6.8576884e-01,-6.8557531e-01,-6.8538177e-01,
  -6.8518829e-01,-6.8499488e-01,-6.8480140e-01,-6.8460798e-01,
  -6.8441463e-01,-6.8422127e-01,-6.8402797e-01,-6.8383461e-01,
  -6.8364137e-01,-6.8344808e-01,-6.8325490e-01,-6.8306166e-01,
  -6.8286848e-01,-6.8267536e-01,-6.8248224e-01,-6.8228912e-01,
  -6.8209606e-01,-6.8190300e-01,-6.8170995e-01,-6.8151695e-01,
  -6.8132401e-01,-6.8113106e-01,-6.8093812e-01,-6.8074524e-01,
  -6.8055236e-01,-6.8035948e-01,-6.8016666e-01,-6.7997390e-01,
  -6.7978114e-01,-6.7958838e-01,-6.7939562e-01,-6.7920297e-01,
  -6.7901027e-01,-6.7881763e-01,-6.7862499e-01,-6.7843240e-01,
  -6.7823982e-01,-6.7804730e-01,-6.7785478e-01,-6.7766231e-01,
  -6.7746985e-01,-6.7727739e-01,-6.7708498e-01,-6.7689258e-01,
  -6.7670017e-01,-6.7650783e-01,-6.7631555e-01,-6.7612326e-01,
  -6.7593098e-01,-6.7573875e-01,-6.7554653e-01,-6.7535430e-01,
  -6.7516214e-01,-6.7496997e-01,-6.7477787e-01,-6.7458576e-01,
  -6.7439371e-01,-6.7420167e-01,-6.7400968e-01,-6.7381763e-01,
  -6.7362571e-01,-6.7343372e-01,-6.7324179e-01,-6.7304993e-01,
  -6.7285806e-01,-6.7266619e-01,-6.7247438e-01,-6.7228258e-01,
  -6.7209083e-01,-6.7189908e-01,-6.7170733e-01,-6.7151564e-01,
  -6.7132396e-01,-6.7113233e-01,-6.7094070e-01,-6.7074913e-01,
  -6.7055756e-01,-6.7036599e-01,-6.7017448e-01,-6.6998297e-01,
  -6.6979146e-01,-6.6960001e-01,-6.6940862e-01,-6.6921723e-01,
  -6.6902584e-01,-6.6883445e-01,-6.6864312e-01,-6.6845185e-01,
  -6.6826057e-01,-6.6806930e-01,-6.6787809e-01,-6.6768688e-01,
  -6.6749567e-01,-6.6730452e-01,-6.6711336e-01,-6.6692227e-01,
  -6.6673118e-01,-6.6654015e-01,-6.6634911e-01,-6.6615808e-01,
  -6.6596711e-01,-6.6577613e-01,-6.6558522e-01,-6.6539431e-01,
  -6.6520339e-01,-6.6501254e-01,-6.6482168e-01,-6.6463089e-01,
  -6.6444010e-01,-6.6424930e-01,-6.6405857e-01,-6.6386783e-01,
  -6.6367716e-01,-6.6348648e-01,-6.6329581e-01,-6.6310519e-01,
  -6.6291457e-01,-6.6272402e-01,-6.6253346e-01,-6.6234291e-01,
  -6.6215241e-01,-6.6196197e-01,-6.6177148e-01,-6.6158104e-01,
  -6.6139066e-01,-6.6120028e-01,-6.6100991e-01,-6.6081959e-01,
  -6.6062927e-01,-6.6043895e-01,-6.6024870e-01,-6.6005844e-01,
  -6.5986824e-01,-6.5967804e-01,-6.5948790e-01,-6.5929776e-01,
  -6.5910763e-01,-6.5891755e-01,-6.5872747e-01,-6.5853739e-01,
  -6.5834737e-01,-6.5815735e-01,-6.5796739e-01,-6.5777743e-01,
  -6.5758753e-01,-6.5739763e-01,-6.5720773e-01,-6.5701783e-01,
  -6.5682805e-01,-6.5663821e-01,-6.5644842e-01,-6.5625864e-01,
  -6.5606892e-01,-6.5587920e-01,-6.5568948e-01,-6.5549982e-01,
  -6.5531015e-01,-6.5512055e-01,-6.5493095e-01,-6.5474141e-01,
  -6.5455180e-01,-6.5436232e-01,-6.5417278e-01,-6.5398329e-01,
  -6.5379387e-01,-6.5360439e-01,-6.5341502e-01,-6.5322560e-01,
  -6.5303624e-01,-6.5284693e-01,-6.5265757e-01,-6.5246826e-01,
  -6.5227902e-01,-6.5208977e-01,-6.5190053e-01,-6.5171134e-01,
  -6.5152216e-01,-6.5133303e-01,-6.5114385e-01,-6.5095478e-01,
  -6.5076566e-01,-6.5057659e-01,-6.5038759e-01,-6.5019858e-01,
  -6.5000957e-01,-6.4982063e-01,-6.4963168e-01,-6.4944273e-01,
  -6.4925385e-01,-6.4906496e-01,-6.4887613e-01,-6.4868730e-01,
  -6.4849848e-01,-6.4830971e-01,-6.4812094e-01,-6.4793217e-01,
  -6.4774346e-01,-6.4755476e-01,-6.4736611e-01,-6.4717746e-01,
  -6.4698887e-01,-6.4680022e-01,-6.4661169e-01,-6.4642310e-01,
  -6.4623457e-01,-6.4604610e-01,-6.4585757e-01,-6.4566916e-01,
  -6.4548069e-01,-6.4529228e-01,-6.4510387e-01,-6.4491552e-01,
  -6.4472717e-01,-6.4453882e-01,-6.4435053e-01,-6.4416224e-01,
  -6.4397401e-01,-6.4378577e-01,-6.4359754e-01,-6.4340937e-01,
  -6.4322120e-01,-6.4303309e-01,-6.4284497e-01,-6.4265686e-01,
  -6.4246881e-01,-6.4228076e-01,-6.4209270e-01,-6.4190471e-01,
  -6.4171672e-01,-6.4152879e-01,-6.4134085e-01,-6.4115292e-01,
  -6.4096504e-01,-6.4077717e-01,-6.4058930e-01,-6.4040148e-01,
  -6.4021367e-01,-6.4002591e-01,-6.3983816e-01,-6.3965040e-01,
  -6.3946271e-01,-6.3927501e-01,-6.3908732e-01,-6.3889968e-01,
  -6.3871205e-01,-6.3852447e-01,-6.3833690e-01,-6.3814932e-01,
  -6.3796180e-01,-6.3777429e-01,-6.3758683e-01,-6.3739938e-01,
  -6.3721192e-01,-6.3702452e-01,-6.3683712e-01,-6.3664973e-01,
  -6.3646239e-01,-6.3627505e-01,-6.3608772e-01,-6.3590044e-01,
  -6.3571316e-01,-6.3552594e-01,-6.3533872e-01,-6.3515151e-01,
  -6.3496435e-01,-6.3477719e-01,-6.3459009e-01,-6.3440299e-01,
  -6.3421589e-01,-6.3402879e-01,-6.3384175e-01,-6.3365477e-01,
  -6.3346779e-01,-6.3328081e-01,-6.3309383e-01,-6.3290691e-01,
  -6.3271999e-01,-6.3253313e-01,-6.3234627e-01,-6.3215941e-01,
  -6.3197261e-01,-6.3178581e-01,-6.3159901e-01,-6.3141227e-01,
  -6.3122553e-01,-6.3103884e-01,-6.3085216e-01,-6.3066548e-01,
  -6.3047886e-01,-6.3029224e-01,-6.3010561e-01,-6.2991905e-01,
  -6.2973249e-01,-6.2954593e-01,-6.2935942e-01,-6.2917292e-01,
  -6.2898648e-01,-6.2880003e-01,-6.2861359e-01,-6.2842721e-01,
  -6.2824082e-01,-6.2805444e-01,-6.2786812e-01,-6.2768179e-01,
  -6.2749553e-01,-6.2730926e-01,-6.2712300e-01,-6.2693679e-01,
  -6.2675059e-01,-6.2656438e-01,-6.2637824e-01,-6.2619209e-01,
  -6.2600595e-01,-6.2581986e-01,-6.2563378e-01,-6.2544775e-01,
  -6.2526166e-01,-6.2507570e-01,-6.2488967e-01,-6.2470371e-01,
  -6.2451780e-01,-6.2433183e-01,-6.2414593e-01,-6.2396008e-01,
  -6.2377423e-01,-6.2358838e-01,-6.2340254e-01,-6.2321675e-01,
  -6.2303096e-01,-6.2284523e-01,-6.2265950e-01,-6.2247378e-01,
  -6.2228811e-01,-6.2210244e-01,-6.2191677e-01,-6.2173116e-01,
  -6.2154555e-01,-6.2136000e-01,-6.2117440e-01,-6.2098891e-01,
  -6.2080336e-01,-6.2061787e-01,-6.2043238e-01,-6.2024695e-01,
  -6.2006152e-01,-6.1987609e-01,-6.1969072e-01,-6.1950535e-01,
  -6.1931998e-01,-6.1913466e-01,-6.1894935e-01,-6.1876410e-01,
  -6.1857885e-01,-6.1839360e-01,-6.1820835e-01,-6.1802316e-01,
  -6.1783803e-01,-6.1765283e-01,-6.1746770e-01,-6.1728263e-01,
  -6.1709750e-01,-6.1691242e-01,-6.1672741e-01,-6.1654234e-01,
  -6.1635733e-01,-6.1617237e-01,-6.1598742e-01,-6.1580247e-01,
  -6.1561751e-01,-6.1543262e-01,-6.1524773e-01,-6.1506289e-01,
  -6.1487806e-01,-6.1469322e-01,-6.1450845e-01,-6.1432368e-01,
  -6.1413890e-01,-6.1395419e-01,-6.1376947e-01,-6.1358476e-01,
  -6.1340010e-01,-6.1321545e-01,-6.1303085e-01,-6.1284620e-01,
  -6.1266160e-01,-6.1247706e-01,-6.1229253e-01,-6.1210799e-01,
  -6.1192352e-01,-6.1173898e-01,-6.1155456e-01,-6.1137009e-01,
  -6.1118567e-01,-6.1100125e-01,-6.1081690e-01,-6.1063254e-01,
  -6.1044818e-01,-6.1026388e-01,-6.1007959e-01,-6.0989529e-01,
  -6.0971105e-01,-6.0952681e-01,-6.0934263e-01,-6.0915840e-01,
  -6.0897428e-01,-6.0879010e-01,-6.0860598e-01,-6.0842186e-01,
  -6.0823774e-01,-6.0805368e-01,-6.0786963e-01,-6.0768563e-01,
  -6.0750163e-01,-6.0731763e-01,-6.0713369e-01,-6.0694975e-01,
  -6.0676581e-01,-6.0658187e-01,-6.0639799e-01,-6.0621417e-01,
  -6.0603029e-01,-6.0584646e-01,-6.0566270e-01,-6.0547888e-01,
  -6.0529512e-01,-6.0511142e-01,-6.0492766e-01,-6.0474396e-01,
  -6.0456032e-01,-6.0437661e-01,-6.0419297e-01,-6.0400939e-01,
  -6.0382581e-01,-6.0364223e-01,-6.0345864e-01,-6.0327512e-01,
  -6.0309160e-01,-6.0290807e-01,-6.0272461e-01,-6.0254115e-01,
  -6.0235775e-01,-6.0217434e-01,-6.0199094e-01,-6.0180753e-01,
  -6.0162419e-01,-6.0144085e-01,-6.0125756e-01,-6.0107428e-01,
  -6.0089099e-01,-6.0070771e-01,-6.0052449e-01,-6.0034126e-01,
  -6.0015810e-01,-5.9997493e-01,-5.9979177e-01,-5.9960866e-01,
  -5.9942549e-01,-5.9924245e-01,-5.9905934e-01,-5.9887630e-01,
  -5.9869325e-01,-5.9851027e-01,-5.9832728e-01,-5.9814429e-01,
  -5.9796137e-01,-5.9777844e-01,-5.9759551e-01,-5.9741259e-01,
  -5.9722972e-01,-5.9704691e-01,-5.9686404e-01,-5.9668124e-01,
  -5.9649843e-01,-5.9631568e-01,-5.9613293e-01,-5.9595019e-01,
  -5.9576750e-01,-5.9558481e-01,-5.9540212e-01,-5.9521949e-01,
  -5.9503686e-01,-5.9485424e-01,-5.9467161e-01,-5.9448904e-01,
  -5.9430653e-01,-5.9412396e-01,-5.9394145e-01,-5.9375894e-01,
  -5.9357649e-01,-5.9339404e-01,-5.9321159e-01,-5.9302920e-01,
  -5.9284681e-01,-5.9266442e-01,-5.9248203e-01,-5.9229970e-01,
  -5.9211743e-01,-5.9193510e-01,-5.9175283e-01,-5.9157056e-01,
  -5.9138834e-01,-5.9120613e-01,-5.9102392e-01,-5.9084171e-01,
  -5.9065956e-01,-5.9047747e-01,-5.9029531e-01,-5.9011322e-01,
  -5.8993113e-01,-5.8974910e-01,-5.8956701e-01,-5.8938503e-01,
  -5.8920300e-01,-5.8902103e-01,-5.8883905e-01,-5.8865714e-01,
  -5.8847517e-01,-5.8829331e-01,-5.8811140e-01,-5.8792955e-01,
  -5.8774769e-01,-5.8756584e-01,-5.8738405e-01,-5.8720225e-01,
  -5.8702052e-01,-5.8683872e-01,-5.8665699e-01,-5.8647531e-01,
  -5.8629364e-01,-5.8611196e-01,-5.8593029e-01,-5.8574867e-01,
  -5.8556706e-01,-5.8538544e-01,-5.8520389e-01,-5.8502233e-01,
  -5.8484077e-01,-5.8465928e-01,-5.8447778e-01,-5.8429629e-01,
  -5.8411479e-01,-5.8393335e-01,-5.8375198e-01,-5.8357054e-01,
  -5.8338916e-01,-5.8320779e-01,-5.8302647e-01,-5.8284515e-01,
  -5.8266383e-01,-5.8248252e-01,-5.8230126e-01,-5.8212000e-01,
  -5.8193880e-01,-5.8175761e-01,-5.8157641e-01,-5.8139521e-01,
  -5.8121407e-01,-5.8103293e-01,-5.8085179e-01,-5.8067071e-01,
  -5.8048964e-01,-5.8030856e-01,-5.8012754e-01,-5.7994652e-01,
  -5.7976550e-01,-5.7958454e-01,-5.7940358e-01,-5.7922262e-01,
  -5.7904172e-01,-5.7886082e-01,-5.7867992e-01,-5.7849902e-01,
  -5.7831818e-01,-5.7813734e-01,-5.7795656e-01,-5.7777578e-01,
  -5.7759500e-01,-5.7741421e-01,-5.7723349e-01,-5.7705277e-01,
  -5.7687205e-01,-5.7669139e-01,-5.7651073e-01,-5.7633007e-01,
  -5.7614946e-01,-5.7596886e-01,-5.7578826e-01,-5.7560772e-01,
  -5.7542717e-01,-5.7524663e-01,-5.7506609e-01,-5.7488561e-01,
  -5.7470512e-01,-5.7452470e-01,-5.7434428e-01,-5.7416385e-01,
  -5.7398343e-01,-5.7380307e-01,-5.7362270e-01,-5.7344234e-01,
  -5.7326204e-01,-5.7308173e-01,-5.7290143e-01,-5.7272118e-01,
  -5.7254094e-01,-5.7236069e-01,-5.7218051e-01,-5.7200027e-01,
  -5.7182014e-01,-5.7163996e-01,-5.7145983e-01,-5.7127970e-01,
  -5.7109958e-01,-5.7091951e-01,-5.7073945e-01,-5.7055938e-01,
  -5.7037938e-01,-5.7019937e-01,-5.7001936e-01,-5.6983942e-01,
  -5.6965947e-01,-5.6947953e-01,-5.6929958e-01,-5.6911969e-01,
  -5.6893981e-01,-5.6875998e-01,-5.6858015e-01,-5.6840032e-01,
  -5.6822050e-01,-5.6804073e-01,-5.6786096e-01,-5.6768119e-01,
  -5.6750149e-01,-5.6732172e-01,-5.6714207e-01,-5.6696236e-01,
  -5.6678271e-01,-5.6660306e-01,-5.6642348e-01,-5.6624383e-01,
  -5.6606424e-01,-5.6588471e-01,-5.6570512e-01,-5.6552559e-01,
  -5.6534612e-01,-5.6516659e-01,-5.6498712e-01,-5.6480765e-01,
  -5.6462824e-01,-5.6444883e-01,-5.6426942e-01,-5.6409001e-01,
  -5.6391066e-01,-5.6373131e-01,-5.6355196e-01,-5.6337267e-01,
  -5.6319338e-01,-5.6301409e-01,-5.6283480e-01,-5.6265557e-01,
  -5.6247634e-01,-5.6229717e-01,-5.6211799e-01,-5.6193882e-01,
  -5.6175965e-01,-5.6158054e-01,-5.6140143e-01,-5.6122231e-01,
  -5.6104320e-01,-5.6086415e-01,-5.6068510e-01,-5.6050611e-01,
  -5.6032711e-01,-5.6014812e-01,-5.5996913e-01,-5.5979019e-01,
  -5.5961126e-01,-5.5943233e-01,-5.5925345e-01,-5.5907458e-01,
  -5.5889571e-01,-5.5871683e-01,-5.5853802e-01,-5.5835921e-01,
  -5.5818039e-01,-5.5800164e-01,-5.5782288e-01,-5.5764413e-01,
  -5.5746543e-01,-5.5728674e-01,-5.5710804e-01,-5.5692935e-01,
  -5.5675071e-01,-5.5657208e-01,-5.5639350e-01,-5.5621487e-01,
  -5.5603629e-01,-5.5585772e-01,-5.5567920e-01,-5.5550069e-01,
  -5.5532217e-01,-5.5514365e-01,-5.5496520e-01,-5.5478674e-01,
  -5.5460835e-01,-5.5442989e-01,-5.5425149e-01,-5.5407310e-01,
  -5.5389476e-01,-5.5371642e-01,-5.5353808e-01,-5.5335975e-01,
  -5.5318147e-01,-5.5300319e-01,-5.5282491e-01,-5.5264670e-01,
  -5.5246848e-01,-5.5229026e-01,-5.5211204e-01,-5.5193388e-01,
  -5.5175573e-01,-5.5157757e-01,-5.5139947e-01,-5.5122137e-01,
  -5.5104327e-01,-5.5086523e-01,-5.5068713e-01,-5.5050915e-01,
  -5.5033112e-01,-5.5015314e-01,-5.4997516e-01,-5.4979718e-01,
  -5.4961920e-01,-5.4944128e-01,-5.4926342e-01,-5.4908550e-01,
  -5.4890764e-01,-5.4872978e-01,-5.4855192e-01,-5.4837412e-01,
  -5.4819632e-01,-5.4801852e-01,-5.4784071e-01,-5.4766297e-01,
  -5.4748523e-01,-5.4730749e-01,-5.4712981e-01,-5.4695213e-01,
  -5.4677445e-01,-5.4659683e-01,-5.4641914e-01,-5.4624158e-01,
  -5.4606396e-01,-5.4588640e-01,-5.4570884e-01,-5.4553127e-01,
  -5.4535371e-01,-5.4517621e-01,-5.4499871e-01,-5.4482126e-01,
  -5.4464376e-01,-5.4446632e-01,-5.4428893e-01,-5.4411149e-01,
  -5.4393411e-01,-5.4375672e-01,-5.4357940e-01,-5.4340202e-01,
  -5.4322469e-01,-5.4304737e-01,-5.4287010e-01,-5.4269284e-01,
  -5.4251558e-01,-5.4233831e-01,-5.4216111e-01,-5.4198390e-01,
  -5.4180670e-01,-5.4162955e-01,-5.4145241e-01,-5.4127526e-01,
  -5.4109812e-01,-5.4092103e-01,-5.4074395e-01,-5.4056686e-01,
  -5.4038984e-01,-5.4021281e-01,-5.4003578e-01,-5.3985876e-01,
  -5.3968179e-01,-5.3950483e-01,-5.3932786e-01,-5.3915095e-01,
  -5.3897399e-01,-5.3879714e-01,-5.3862023e-01,-5.3844339e-01,
  -5.3826654e-01,-5.3808969e-01,-5.3791285e-01,-5.3773606e-01,
  -5.3755927e-01,-5.3738254e-01,-5.3720576e-01,-5.3702903e-01,
  -5.3685230e-01,-5.3667563e-01,-5.3649896e-01,-5.3632230e-01,
  -5.3614563e-01,-5.3596902e-01,-5.3579235e-01,-5.3561580e-01,
  -5.3543919e-01,-5.3526264e-01,-5.3508610e-01,-5.3490955e-01,
  -5.3473306e-01,-5.3455651e-01,-5.3438008e-01,-5.3420359e-01,
  -5.3402716e-01,-5.3385073e-01,-5.3367430e-01,-5.3349787e-01,
  -5.3332150e-01,-5.3314513e-01,-5.3296882e-01,-5.3279245e-01,
  -5.3261614e-01,-5.3243983e-01,-5.3226358e-01,-5.3208733e-01,
  -5.3191108e-01,-5.3173482e-01,-5.3155863e-01,-5.3138238e-01,
  -5.3120625e-01,-5.3103006e-01,-5.3085393e-01,-5.3067780e-01,
  -5.3050166e-01,-5.3032553e-01,-5.3014946e-01,-5.2997339e-01,
  -5.2979738e-01,-5.2962130e-01,-5.2944529e-01,-5.2926928e-01,
  -5.2909333e-01,-5.2891731e-01,-5.2874136e-01,-5.2856547e-01,
  -5.2838951e-01,-5.2821362e-01,-5.2803773e-01,-5.2786183e-01,
  -5.2768600e-01,-5.2751017e-01,-5.2733433e-01,-5.2715856e-01,
  -5.2698272e-01,-5.2680695e-01,-5.2663124e-01,-5.2645546e-01,
  -5.2627975e-01,-5.2610403e-01,-5.2592838e-01,-5.2575266e-01,
  -5.2557701e-01,-5.2540135e-01,-5.2522576e-01,-5.2505010e-01,
  -5.2487451e-01,-5.2469897e-01,-5.2452338e-01,-5.2434784e-01,
  -5.2417231e-01,-5.2399683e-01,-5.2382129e-01,-5.2364582e-01,
  -5.2347034e-01,-5.2329493e-01,-5.2311945e-01,-5.2294403e-01,
  -5.2276868e-01,-5.2259326e-01,-5.2241790e-01,-5.2224255e-01,
  -5.2206719e-01,-5.2189189e-01,-5.2171659e-01,-5.2154130e-01,
  -5.2136600e-01,-5.2119076e-01,-5.2101552e-01,-5.2084029e-01,
  -5.2066511e-01,-5.2048987e-01,-5.2031469e-01,-5.2013958e-01,
  -5.1996440e-01,-5.1978928e-01,-5.1961416e-01,-5.1943904e-01,
  -5.1926398e-01,-5.1908892e-01,-5.1891387e-01,-5.1873887e-01,
  -5.1856381e-01,-5.1838881e-01,-5.1821381e-01,-5.1803887e-01,
  -5.1786393e-01,-5.1768899e-01,-5.1751405e-01,-5.1733917e-01,
  -5.1716423e-01,-5.1698935e-01,-5.1681453e-01,-5.1663965e-01,
  -5.1646483e-01,-5.1629001e-01,-5.1611525e-01,-5.1594043e-01,
  -5.1576567e-01,-5.1559097e-01,-5.1541620e-01,-5.1524150e-01,
  -5.1506680e-01,-5.1489210e-01,-5.1471746e-01,-5.1454276e-01,
  -5.1436812e-01,-5.1419353e-01,-5.1401889e-01,-5.1384431e-01,
  -5.1366973e-01,-5.1349521e-01,-5.1332062e-01,-5.1314610e-01,
  -5.1297158e-01,-5.1279712e-01,-5.1262259e-01,-5.1244813e-01,
  -5.1227367e-01,-5.1209927e-01,-5.1192486e-01,-5.1175046e-01,
  -5.1157606e-01,-5.1140165e-01,-5.1122731e-01,-5.1105297e-01,
  -5.1087862e-01,-5.1070434e-01,-5.1053005e-01,-5.1035577e-01,
  -5.1018149e-01,-5.1000726e-01,-5.0983304e-01,-5.0965881e-01,
  -5.0948459e-01,-5.0931042e-01,-5.0913620e-01,-5.0896209e-01,
  -5.0878793e-01,-5.0861382e-01,-5.0843972e-01,-5.0826561e-01,
  -5.0809151e-01,-5.0791746e-01,-5.0774342e-01,-5.0756937e-01,
  -5.0739533e-01,-5.0722134e-01,-5.0704736e-01,-5.0687337e-01,
  -5.0669944e-01,-5.0652552e-01,-5.0635159e-01,-5.0617766e-01,
  -5.0600374e-01,-5.0582987e-01,-5.0565600e-01,-5.0548220e-01,
  -5.0530833e-01,-5.0513452e-01,-5.0496072e-01,-5.0478691e-01,
  -5.0461316e-01,-5.0443941e-01,-5.0426567e-01,-5.0409192e-01,
  -5.0391823e-01,-5.0374454e-01,-5.0357085e-01,-5.0339717e-01,
  -5.0322354e-01,-5.0304991e-01,-5.0287628e-01,-5.0270265e-01,
  -5.0252908e-01,-5.0235552e-01,-5.0218195e-01,-5.0200838e-01,
  -5.0183487e-01,-5.0166136e-01,-5.0148785e-01,-5.0131434e-01,
  -5.0114089e-01,-5.0096744e-01,-5.0079399e-01,-5.0062054e-01,
  -5.0044715e-01,-5.0027376e-01,-5.0010037e-01,-4.9992701e-01,
  -4.9975368e-01,-4.9958032e-01,-4.9940702e-01,-4.9923372e-01,
  -4.9906042e-01,-4.9888715e-01,-4.9871388e-01,-4.9854064e-01,
  -4.9836743e-01,-4.9819419e-01,-4.9802101e-01,-4.9784783e-01,
  -4.9767464e-01,-4.9750149e-01,-4.9732834e-01,-4.9715522e-01,
  -4.9698213e-01,-4.9680904e-01,-4.9663594e-01,-4.9646288e-01,
  -4.9628982e-01,-4.9611679e-01,-4.9594378e-01,-4.9577075e-01,
  -4.9559778e-01,-4.9542481e-01,-4.9525183e-01,-4.9507889e-01,
  -4.9490595e-01,-4.9473304e-01,-4.9456015e-01,-4.9438724e-01,
  -4.9421439e-01,-4.9404153e-01,-4.9386868e-01,-4.9369586e-01,
  -4.9352303e-01,-4.9335024e-01,-4.9317744e-01,-4.9300468e-01,
  -4.9283192e-01,-4.9265918e-01,-4.9248648e-01,-4.9231374e-01,
  -4.9214107e-01,-4.9196836e-01,-4.9179572e-01,-4.9162304e-01,
  -4.9145043e-01,-4.9127778e-01,-4.9110520e-01,-4.9093258e-01,
  -4.9076003e-01,-4.9058744e-01,-4.9041489e-01,-4.9024236e-01,
  -4.9006984e-01,-4.8989734e-01,-4.8972484e-01,-4.8955238e-01,
  -4.8937991e-01,-4.8920748e-01,-4.8903504e-01,-4.8886260e-01,
  -4.8869020e-01,-4.8851782e-01,-4.8834544e-01,-4.8817310e-01,
  -4.8800075e-01,-4.8782840e-01,-4.8765609e-01,-4.8748380e-01,
  -4.8731151e-01,-4.8713923e-01,-4.8696697e-01,-4.8679471e-01,
  -4.8662248e-01,-4.8645028e-01,-4.8627809e-01,-4.8610589e-01,
  -4.8593372e-01,-4.8576155e-01,-4.8558941e-01,-4.8541728e-01,
  -4.8524517e-01,-4.8507306e-01,-4.8490098e-01,-4.8472890e-01,
  -4.8455685e-01,-4.8438480e-01,-4.8421279e-01,-4.8404077e-01,
  -4.8386878e-01,-4.8369679e-01,-4.8352480e-01,-4.8335287e-01,
  -4.8318091e-01,-4.8300898e-01,-4.8283708e-01,-4.8266518e-01,
  -4.8249328e-01,-4.8232141e-01,-4.8214954e-01,-4.8197770e-01,
  -4.8180589e-01,-4.8163408e-01,-4.8146227e-01,-4.8129049e-01,
  -4.8111871e-01,-4.8094696e-01,-4.8077521e-01,-4.8060349e-01,
  -4.8043177e-01,-4.8026007e-01,-4.8008838e-01,-4.7991669e-01,
  -4.7974506e-01,-4.7957340e-01,-4.7940177e-01,-4.7923017e-01,
  -4.7905856e-01,-4.7888696e-01,-4.7871539e-01,-4.7854382e-01,
  -4.7837228e-01,-4.7820076e-01,-4.7802925e-01,-4.7785774e-01,
  -4.7768626e-01,-4.7751477e-01,-4.7734332e-01,-4.7717187e-01,
  -4.7700042e-01,-4.7682902e-01,-4.7665760e-01,-4.7648621e-01,
  -4.7631484e-01,-4.7614348e-01,-4.7597212e-01,-4.7580078e-01,
  -4.7562948e-01,-4.7545815e-01,-4.7528687e-01,-4.7511560e-01,
  -4.7494432e-01,-4.7477308e-01,-4.7460184e-01,-4.7443059e-01,
  -4.7425941e-01,-4.7408819e-01,-4.7391701e-01,-4.7374585e-01,
  -4.7357470e-01,-4.7340354e-01,-4.7323242e-01,-4.7306132e-01,
  -4.7289023e-01,-4.7271913e-01,-4.7254807e-01,-4.7237700e-01,
  -4.7220597e-01,-4.7203493e-01,-4.7186393e-01,-4.7169292e-01,
  -4.7152191e-01,-4.7135094e-01,-4.7117999e-01,-4.7100905e-01,
  -4.7083810e-01,-4.7066718e-01,-4.7049630e-01,-4.7032538e-01,
  -4.7015452e-01,-4.6998364e-01,-4.6981281e-01,-4.6964195e-01,
  -4.6947113e-01,-4.6930033e-01,-4.6912953e-01,-4.6895874e-01,
  -4.6878797e-01,-4.6861723e-01,-4.6844649e-01,-4.6827576e-01,
  -4.6810505e-01,-4.6793434e-01,-4.6776366e-01,-4.6759298e-01,
  -4.6742234e-01,-4.6725169e-01,-4.6708104e-01,-4.6691042e-01,
  -4.6673983e-01,-4.6656922e-01,-4.6639866e-01,-4.6622810e-01,
  -4.6605754e-01,-4.6588701e-01,-4.6571648e-01,-4.6554595e-01,
  -4.6537545e-01,-4.6520498e-01,-4.6503451e-01,-4.6486405e-01,
  -4.6469361e-01,-4.6452320e-01,-4.6435279e-01,-4.6418238e-01,
  -4.6401197e-01,-4.6384162e-01,-4.6367124e-01,-4.6350089e-01,
  -4.6333057e-01,-4.6316025e-01,-4.6298993e-01,-4.6281964e-01,
  -4.6264935e-01,-4.6247908e-01,-4.6230882e-01,-4.6213859e-01,
  -4.6196836e-01,-4.6179816e-01,-4.6162796e-01,-4.6145776e-01,
  -4.6128759e-01,-4.6111742e-01,-4.6094728e-01,-4.6077716e-01,
  -4.6060702e-01,-4.6043691e-01,-4.6026683e-01,-4.6009675e-01,
  -4.5992669e-01,-4.5975661e-01,-4.5958659e-01,-4.5941657e-01,
  -4.5924655e-01,-4.5907655e-01,-4.5890656e-01,-4.5873657e-01,
  -4.5856661e-01,-4.5839667e-01,-4.5822674e-01,-4.5805681e-01,
  -4.5788690e-01,-4.5771700e-01,-4.5754713e-01,-4.5737725e-01,
  -4.5720741e-01,-4.5703757e-01,-4.5686772e-01,-4.5669791e-01,
  -4.5652813e-01,-4.5635834e-01,-4.5618856e-01,-4.5601878e-01,
  -4.5584905e-01,-4.5567930e-01,-4.5550957e-01,-4.5533988e-01,
  -4.5517018e-01,-4.5500049e-01,-4.5483083e-01,-4.5466116e-01,
  -4.5449153e-01,-4.5432189e-01,-4.5415226e-01,-4.5398265e-01,
  -4.5381308e-01,-4.5364347e-01,-4.5347393e-01,-4.5330435e-01,
  -4.5313483e-01,-4.5296529e-01,-4.5279577e-01,-4.5262629e-01,
  -4.5245680e-01,-4.5228732e-01,-4.5211786e-01,-4.5194840e-01,
  -4.5177898e-01,-4.5160955e-01,-4.5144013e-01,-4.5127073e-01,
  -4.5110136e-01,-4.5093197e-01,-4.5076263e-01,-4.5059326e-01,
  -4.5042393e-01,-4.5025462e-01,-4.5008531e-01,-4.4991601e-01,
  -4.4974673e-01,-4.4957748e-01,-4.4940820e-01,-4.4923896e-01,
  -4.4906974e-01,-4.4890052e-01,-4.4873130e-01,-4.4856212e-01,
  -4.4839296e-01,-4.4822377e-01,-4.4805464e-01,-4.4788548e-01,
  -4.4771636e-01,-4.4754726e-01,-4.4737816e-01,-4.4720906e-01,
  -4.4703999e-01,-4.4687092e-01,-4.4670185e-01,-4.4653282e-01,
  -4.4636381e-01,-4.4619480e-01,-4.4602579e-01,-4.4585681e-01,
  -4.4568783e-01,-4.4551888e-01,-4.4534993e-01,-4.4518098e-01,
  -4.4501206e-01,-4.4484314e-01,-4.4467425e-01,-4.4450536e-01,
  -4.4433650e-01,-4.4416764e-01,-4.4399878e-01,-4.4382995e-01,
  -4.4366112e-01,-4.4349232e-01,-4.4332352e-01,-4.4315475e-01,
  -4.4298598e-01,-4.4281721e-01,-4.4264847e-01,-4.4247973e-01,
  -4.4231102e-01,-4.4214231e-01,-4.4197360e-01,-4.4180492e-01,
  -4.4163626e-01,-4.4146761e-01,-4.4129896e-01,-4.4113031e-01,
  -4.4096169e-01,-4.4079310e-01,-4.4062451e-01,-4.4045591e-01,
  -4.4028735e-01,-4.4011879e-01,-4.3995023e-01,-4.3978170e-01,
  -4.3961319e-01,-4.3944469e-01,-4.3927619e-01,-4.3910772e-01,
  -4.3893924e-01,-4.3877077e-01,-4.3860233e-01,-4.3843389e-01,
  -4.3826547e-01,-4.3809706e-01,-4.3792868e-01,-4.3776029e-01,
  -4.3759191e-01,-4.3742356e-01,-4.3725520e-01,-4.3708688e-01,
  -4.3691856e-01,-4.3675026e-01,-4.3658197e-01,-4.3641368e-01,
  -4.3624541e-01,-4.3607715e-01,-4.3590888e-01,-4.3574065e-01,
  -4.3557245e-01,-4.3540421e-01,-4.3523604e-01,-4.3506783e-01,
  -4.3489966e-01,-4.3473151e-01,-4.3456337e-01,-4.3439522e-01,
  -4.3422711e-01,-4.3405899e-01,-4.3389088e-01,-4.3372279e-01,
  -4.3355474e-01,-4.3338665e-01,-4.3321860e-01,-4.3305057e-01,
  -4.3288255e-01,-4.3271452e-01,-4.3254653e-01,-4.3237853e-01,
  -4.3221056e-01,-4.3204260e-01,-4.3187466e-01,-4.3170670e-01,
  -4.3153879e-01,-4.3137085e-01,-4.3120295e-01,-4.3103507e-01,
  -4.3086720e-01,-4.3069932e-01,-4.3053147e-01,-4.3036363e-01,
  -4.3019578e-01,-4.3002796e-01,-4.2986017e-01,-4.2969236e-01,
  -4.2952460e-01,-4.2935681e-01,-4.2918906e-01,-4.2902130e-01,
  -4.2885357e-01,-4.2868584e-01,-4.2851815e-01,-4.2835045e-01,
  -4.2818275e-01,-4.2801508e-01,-4.2784742e-01,-4.2767978e-01,
  -4.2751214e-01,-4.2734450e-01,-4.2717689e-01,-4.2700928e-01,
  -4.2684171e-01,-4.2667413e-01,-4.2650655e-01,-4.2633900e-01,
  -4.2617145e-01,-4.2600393e-01,-4.2583641e-01,-4.2566890e-01,
  -4.2550141e-01,-4.2533392e-01,-4.2516646e-01,-4.2499900e-01,
  -4.2483154e-01,-4.2466411e-01,-4.2449671e-01,-4.2432928e-01,
  -4.2416188e-01,-4.2399451e-01,-4.2382711e-01,-4.2365977e-01,
  -4.2349240e-01,-4.2332506e-01,-4.2315775e-01,-4.2299041e-01,
  -4.2282313e-01,-4.2265582e-01,-4.2248854e-01,-4.2232129e-01,
  -4.2215401e-01,-4.2198679e-01,-4.2181954e-01,-4.2165232e-01,
  -4.2148513e-01,-4.2131791e-01,-4.2115071e-01,-4.2098355e-01,
  -4.2081639e-01,-4.2064923e-01,-4.2048210e-01,-4.2031497e-01,
  -4.2014787e-01,-4.1998076e-01,-4.1981366e-01,-4.1964659e-01,
  -4.1947952e-01,-4.1931245e-01,-4.1914541e-01,-4.1897836e-01,
  -4.1881135e-01,-4.1864434e-01,-4.1847736e-01,-4.1831037e-01,
  -4.1814339e-01,-4.1797641e-01,-4.1780946e-01,-4.1764253e-01,
  -4.1747561e-01,-4.1730869e-01,-4.1714177e-01,-4.1697487e-01,
  -4.1680801e-01,-4.1664115e-01,-4.1647428e-01,-4.1630742e-01,
  -4.1614059e-01,-4.1597375e-01,-4.1580695e-01,-4.1564015e-01,
  -4.1547337e-01,-4.1530660e-01,-4.1513982e-01,-4.1497305e-01,
  -4.1480631e-01,-4.1463959e-01,-4.1447288e-01,-4.1430616e-01,
  -4.1413945e-01,-4.1397277e-01,-4.1380611e-01,-4.1363943e-01,
  -4.1347280e-01,-4.1330615e-01,-4.1313952e-01,-4.1297290e-01,
  -4.1280630e-01,-4.1263971e-01,-4.1247311e-01,-4.1230655e-01,
  -4.1213998e-01,-4.1197345e-01,-4.1180691e-01,-4.1164038e-01,
  -4.1147387e-01,-4.1130736e-01,-4.1114089e-01,-4.1097438e-01,
  -4.1080794e-01,-4.1064146e-01,-4.1047502e-01,-4.1030860e-01,
  -4.1014215e-01,-4.0997577e-01,-4.0980935e-01,-4.0964296e-01,
  -4.0947658e-01,-4.0931022e-01,-4.0914387e-01,-4.0897754e-01,
  -4.0881118e-01,-4.0864488e-01,-4.0847856e-01,-4.0831226e-01,
  -4.0814599e-01,-4.0797970e-01,-4.0781343e-01,-4.0764719e-01,
  -4.0748096e-01,-4.0731472e-01,-4.0714851e-01,-4.0698227e-01,
  -4.0681610e-01,-4.0664992e-01,-4.0648374e-01,-4.0631756e-01,
  -4.0615141e-01,-4.0598527e-01,-4.0581915e-01,-4.0565303e-01,
  -4.0548691e-01,-4.0532082e-01,-4.0515473e-01,-4.0498868e-01,
  -4.0482262e-01,-4.0465656e-01,-4.0449050e-01,-4.0432447e-01,
  -4.0415847e-01,-4.0399247e-01,-4.0382648e-01,-4.0366048e-01,
  -4.0349451e-01,-4.0332854e-01,-4.0316260e-01,-4.0299666e-01,
  -4.0283072e-01,-4.0266481e-01,-4.0249890e-01,-4.0233302e-01,
  -4.0216711e-01,-4.0200126e-01,-4.0183538e-01,-4.0166953e-01,
  -4.0150368e-01,-4.0133786e-01,-4.0117204e-01,-4.0100625e-01,
  -4.0084043e-01,-4.0067467e-01,-4.0050888e-01,-4.0034312e-01,
  -4.0017736e-01,-4.0001163e-01,-3.9984590e-01,-3.9968017e-01,
  -3.9951447e-01,-3.9934877e-01,-3.9918309e-01,-3.9901742e-01,
  -3.9885175e-01,-3.9868611e-01,-3.9852047e-01,-3.9835483e-01,
  -3.9818922e-01,-3.9802361e-01,-3.9785799e-01,-3.9769241e-01,
  -3.9752683e-01,-3.9736128e-01,-3.9719570e-01,-3.9703017e-01,
  -3.9686462e-01,-3.9669910e-01,-3.9653361e-01,-3.9636809e-01,
  -3.9620259e-01,-3.9603713e-01,-3.9587167e-01,-3.9570621e-01,
  -3.9554074e-01,-3.9537531e-01,-3.9520991e-01,-3.9504448e-01,
  -3.9487907e-01,-3.9471370e-01,-3.9454830e-01,-3.9438292e-01,
  -3.9421758e-01,-3.9405224e-01,-3.9388689e-01,-3.9372155e-01,
  -3.9355624e-01,-3.9339092e-01,-3.9322564e-01,-3.9306036e-01,
  -3.9289507e-01,-3.9272982e-01,-3.9256456e-01,-3.9239931e-01,
  -3.9223409e-01,-3.9206886e-01,-3.9190367e-01,-3.9173847e-01,
  -3.9157328e-01,-3.9140809e-01,-3.9124292e-01,-3.9107779e-01,
  -3.9091262e-01,-3.9074749e-01,-3.9058238e-01,-3.9041725e-01,
  -3.9025214e-01,-3.9008707e-01,-3.8992199e-01,-3.8975692e-01,
  -3.8959184e-01,-3.8942680e-01,-3.8926175e-01,-3.8909674e-01,
  -3.8893172e-01,-3.8876671e-01,-3.8860172e-01,-3.8843673e-01,
  -3.8827175e-01,-3.8810679e-01,-3.8794184e-01,-3.8777688e-01,
  -3.8761196e-01,-3.8744703e-01,-3.8728210e-01,-3.8711721e-01,
  -3.8695231e-01,-3.8678744e-01,-3.8662258e-01,-3.8645771e-01,
  -3.8629287e-01,-3.8612801e-01,-3.8596320e-01,-3.8579836e-01,
  -3.8563356e-01,-3.8546878e-01,-3.8530397e-01,-3.8513920e-01,
  -3.8497445e-01,-3.8480970e-01,-3.8464496e-01,-3.8448021e-01,
  -3.8431549e-01,-3.8415077e-01,-3.8398609e-01,-3.8382137e-01,
  -3.8365671e-01,-3.8349202e-01,-3.8332736e-01,-3.8316271e-01,
  -3.8299808e-01,-3.8283345e-01,-3.8266882e-01,-3.8250422e-01,
  -3.8233963e-01,-3.8217503e-01,-3.8201046e-01,-3.8184589e-01,
  -3.8168132e-01,-3.8151678e-01,-3.8135225e-01,-3.8118771e-01,
  -3.8102320e-01,-3.8085869e-01,-3.8069418e-01,-3.8052970e-01,
  -3.8036522e-01,-3.8020077e-01,-3.8003632e-01,-3.7987188e-01,
  -3.7970743e-01,-3.7954301e-01,-3.7937859e-01,-3.7921420e-01,
  -3.7904981e-01,-3.7888542e-01,-3.7872106e-01,-3.7855670e-01,
  -3.7839234e-01,-3.7822798e-01,-3.7806365e-01,-3.7789935e-01,
  -3.7773502e-01,-3.7757072e-01,-3.7740645e-01,-3.7724215e-01,
  -3.7707788e-01,-3.7691364e-01,-3.7674937e-01,-3.7658513e-01,
  -3.7642092e-01,-3.7625667e-01,-3.7609249e-01,-3.7592828e-01,
  -3.7576410e-01,-3.7559992e-01,-3.7543574e-01,-3.7527159e-01,
  -3.7510744e-01,-3.7494329e-01,-3.7477916e-01,-3.7461504e-01,
  -3.7445095e-01,-3.7428683e-01,-3.7412277e-01,-3.7395868e-01,
  -3.7379462e-01,-3.7363055e-01,-3.7346649e-01,-3.7330246e-01,
  -3.7313843e-01,-3.7297443e-01,-3.7281042e-01,-3.7264642e-01,
  -3.7248242e-01,-3.7231845e-01,-3.7215447e-01,-3.7199053e-01,
  -3.7182659e-01,-3.7166265e-01,-3.7149870e-01,-3.7133479e-01,
  -3.7117088e-01,-3.7100700e-01,-3.7084311e-01,-3.7067923e-01,
  -3.7051535e-01,-3.7035149e-01,-3.7018764e-01,-3.7002382e-01,
  -3.6985999e-01,-3.6969617e-01,-3.6953235e-01,-3.6936855e-01,
  -3.6920476e-01,-3.6904100e-01,-3.6887723e-01,-3.6871347e-01,
  -3.6854970e-01,-3.6838597e-01,-3.6822224e-01,-3.6805853e-01,
  -3.6789483e-01,-3.6773112e-01,-3.6756742e-01,-3.6740375e-01,
  -3.6724007e-01,-3.6707643e-01,-3.6691278e-01,-3.6674914e-01,
  -3.6658549e-01,-3.6642188e-01,-3.6625826e-01,-3.6609468e-01,
  -3.6593106e-01,-3.6576751e-01,-3.6560392e-01,-3.6544037e-01,
  -3.6527681e-01,-3.6511326e-01,-3.6494973e-01,-3.6478621e-01,
  -3.6462271e-01,-3.6445919e-01,-3.6429569e-01,-3.6413223e-01,
  -3.6396876e-01,-3.6380529e-01,-3.6364183e-01,-3.6347839e-01,
  -3.6331496e-01,-3.6315152e-01,-3.6298811e-01,-3.6282471e-01,
  -3.6266130e-01,-3.6249793e-01,-3.6233455e-01,-3.6217117e-01,
  -3.6200783e-01,-3.6184445e-01,-3.6168113e-01,-3.6151779e-01,
  -3.6135447e-01,-3.6119115e-01,-3.6102787e-01,-3.6086458e-01,
  -3.6070129e-01,-3.6053804e-01,-3.6037478e-01,-3.6021152e-01,
  -3.6004826e-01,-3.5988504e-01,-3.5972181e-01,-3.5955861e-01,
  -3.5939538e-01,-3.5923222e-01,-3.5906902e-01,-3.5890585e-01,
  -3.5874268e-01,-3.5857952e-01,-3.5841638e-01,-3.5825324e-01,
  -3.5809010e-01,-3.5792699e-01,-3.5776389e-01,-3.5760078e-01,
  -3.5743770e-01,-3.5727462e-01,-3.5711154e-01,-3.5694849e-01,
  -3.5678545e-01,-3.5662240e-01,-3.5645935e-01,-3.5629633e-01,
  -3.5613331e-01,-3.5597032e-01,-3.5580733e-01,-3.5564435e-01,
  -3.5548136e-01,-3.5531840e-01,-3.5515544e-01,-3.5499248e-01,
  -3.5482955e-01,-3.5466662e-01,-3.5450372e-01,-3.5434079e-01,
  -3.5417789e-01,-3.5401499e-01,-3.5385212e-01,-3.5368925e-01,
  -3.5352638e-01,-3.5336354e-01,-3.5320070e-01,-3.5303786e-01,
  -3.5287502e-01,-3.5271221e-01,-3.5254940e-01,-3.5238662e-01,
  -3.5222381e-01,-3.5206103e-01,-3.5189828e-01,-3.5173550e-01,
  -3.5157275e-01,-3.5141003e-01,-3.5124728e-01,-3.5108456e-01,
  -3.5092187e-01,-3.5075915e-01,-3.5059646e-01,-3.5043377e-01,
  -3.5027111e-01,-3.5010841e-01,-3.4994578e-01,-3.4978312e-01,
  -3.4962049e-01,-3.4945786e-01,-3.4929523e-01,-3.4913263e-01,
  -3.4897003e-01,-3.4880742e-01,-3.4864485e-01,-3.4848228e-01,
  -3.4831971e-01,-3.4815714e-01,-3.4799460e-01,-3.4783205e-01,
  -3.4766954e-01,-3.4750700e-01,-3.4734452e-01,-3.4718201e-01,
  -3.4701952e-01,-3.4685704e-01,-3.4669456e-01,-3.4653208e-01,
  -3.4636962e-01,-3.4620720e-01,-3.4604475e-01,-3.4588233e-01,
  -3.4571990e-01,-3.4555748e-01,-3.4539509e-01,-3.4523270e-01,
  -3.4507033e-01,-3.4490794e-01,-3.4474558e-01,-3.4458324e-01,
  -3.4442088e-01,-3.4425855e-01,-3.4409621e-01,-3.4393391e-01,
  -3.4377158e-01,-3.4360930e-01,-3.4344700e-01,-3.4328473e-01,
  -3.4312245e-01,-3.4296018e-01,-3.4279794e-01,-3.4263566e-01,
  -3.4247345e-01,-3.4231120e-01,-3.4214899e-01,-3.4198678e-01,
  -3.4182459e-01,-3.4166238e-01,-3.4150019e-01,-3.4133804e-01,
  -3.4117585e-01,-3.4101370e-01,-3.4085155e-01,-3.4068942e-01,
  -3.4052730e-01,-3.4036517e-01,-3.4020305e-01,-3.4004095e-01,
  -3.3987886e-01,-3.3971679e-01,-3.3955470e-01,-3.3939263e-01,
  -3.3923057e-01,-3.3906853e-01,-3.3890650e-01,-3.3874446e-01,
  -3.3858243e-01,-3.3842042e-01,-3.3825842e-01,-3.3809641e-01,
  -3.3793443e-01,-3.3777246e-01,-3.3761048e-01,-3.3744854e-01,
  -3.3728656e-01,-3.3712465e-01,-3.3696270e-01,-3.3680078e-01,
  -3.3663887e-01,-3.3647695e-01,-3.3631504e-01,-3.3615315e-01,
  -3.3599129e-01,-3.3582941e-01,-3.3566755e-01,-3.3550569e-01,
  -3.3534384e-01,-3.3518201e-01,-3.3502018e-01,-3.3485836e-01,
  -3.3469656e-01,-3.3453473e-01,-3.3437297e-01,-3.3421117e-01,
  -3.3404940e-01,-3.3388764e-01,-3.3372587e-01,-3.3356413e-01,
  -3.3340237e-01,-3.3324066e-01,-3.3307892e-01,-3.3291721e-01,
  -3.3275551e-01,-3.3259380e-01,-3.3243212e-01,-3.3227044e-01,
  -3.3210877e-01,-3.3194712e-01,-3.3178544e-01,-3.3162379e-01,
  -3.3146217e-01,-3.3130056e-01,-3.3113891e-01,-3.3097732e-01,
  -3.3081570e-01,-3.3065411e-01,-3.3049253e-01,-3.3033097e-01,
  -3.3016938e-01,-3.3000782e-01,-3.2984629e-01,-3.2968473e-01,
  -3.2952321e-01,-3.2936168e-01,-3.2920018e-01,-3.2903865e-01,
  -3.2887715e-01,-3.2871568e-01,-3.2855418e-01,-3.2839271e-01,
  -3.2823125e-01,-3.2806981e-01,-3.2790837e-01,-3.2774693e-01,
  -3.2758549e-01,-3.2742405e-01,-3.2726264e-01,-3.2710126e-01,
  -3.2693985e-01,-3.2677847e-01,-3.2661709e-01,-3.2645571e-01,
  -3.2629436e-01,-3.2613301e-01,-3.2597166e-01,-3.2581031e-01,
  -3.2564899e-01,-3.2548767e-01,-3.2532635e-01,-3.2516506e-01,
  -3.2500377e-01,-3.2484248e-01,-3.2468119e-01,-3.2451993e-01,
  -3.2435867e-01,-3.2419741e-01,-3.2403618e-01,-3.2387495e-01,
  -3.2371372e-01,-3.2355249e-01,-3.2339129e-01,-3.2323009e-01,
  -3.2306889e-01,-3.2290772e-01,-3.2274655e-01,-3.2258537e-01,
  -3.2242420e-01,-3.2226306e-01,-3.2210192e-01,-3.2194078e-01,
  -3.2177964e-01,-3.2161853e-01,-3.2145742e-01,-3.2129633e-01,
  -3.2113522e-01,-3.2097414e-01,-3.2081306e-01,-3.2065201e-01,
  -3.2049096e-01,-3.2032990e-01,-3.2016885e-01,-3.2000783e-01,
  -3.1984678e-01,-3.1968579e-01,-3.1952477e-01,-3.1936377e-01,
  -3.1920278e-01,-3.1904179e-01,-3.1888083e-01,-3.1871983e-01,
  -3.1855887e-01,-3.1839794e-01,-3.1823698e-01,-3.1807604e-01,
  -3.1791514e-01,-3.1775421e-01,-3.1759331e-01,-3.1743240e-01,
  -3.1727150e-01,-3.1711063e-01,-3.1694973e-01,-3.1678888e-01,
  -3.1662801e-01,-3.1646717e-01,-3.1630632e-01,-3.1614548e-01,
  -3.1598464e-01,-3.1582382e-01,-3.1566301e-01,-3.1550223e-01,
  -3.1534141e-01,-3.1518063e-01,-3.1501985e-01,-3.1485909e-01,
  -3.1469831e-01,-3.1453755e-01,-3.1437680e-01,-3.1421608e-01,
  -3.1405535e-01,-3.1389463e-01,-3.1373391e-01,-3.1357321e-01,
  -3.1341252e-01,-3.1325182e-01,-3.1309113e-01,-3.1293046e-01,
  -3.1276980e-01,-3.1260914e-01,-3.1244847e-01,-3.1228784e-01,
  -3.1212720e-01,-3.1196660e-01,-3.1180596e-01,-3.1164536e-01,
  -3.1148475e-01,-3.1132415e-01,-3.1116357e-01,-3.1100300e-01,
  -3.1084242e-01,-3.1068188e-01,-3.1052130e-01,-3.1036076e-01,
  -3.1020024e-01,-3.1003970e-01,-3.0987918e-01,-3.0971867e-01,
  -3.0955815e-01,-3.0939767e-01,-3.0923718e-01,-3.0907670e-01,
  -3.0891621e-01,-3.0875576e-01,-3.0859530e-01,-3.0843484e-01,
  -3.0827442e-01,-3.0811396e-01,-3.0795354e-01,-3.0779314e-01,
  -3.0763271e-01,-3.0747232e-01,-3.0731192e-01,-3.0715156e-01,
  -3.0699116e-01,-3.0683079e-01,-3.0667043e-01,-3.0651006e-01,
  -3.0634972e-01,-3.0618939e-01,-3.0602905e-01,-3.0586874e-01,
  -3.0570841e-01,-3.0554810e-01,-3.0538782e-01,-3.0522752e-01,
  -3.0506724e-01,-3.0490696e-01,-3.0474669e-01,-3.0458644e-01,
  -3.0442619e-01,-3.0426595e-01,-3.0410570e-01,-3.0394548e-01,
  -3.0378526e-01,-3.0362505e-01,-3.0346483e-01,-3.0330464e-01,
  -3.0314445e-01,-3.0298427e-01,-3.0282408e-01,-3.0266392e-01,
  -3.0250376e-01,-3.0234361e-01,-3.0218348e-01,-3.0202332e-01,
  -3.0186319e-01,-3.0170310e-01,-3.0154297e-01,-3.0138287e-01,
  -3.0122277e-01,-3.0106267e-01,-3.0090261e-01,-3.0074254e-01,
  -3.0058247e-01,-3.0042240e-01,-3.0026236e-01,-3.0010229e-01,
  -2.9994226e-01,-2.9978225e-01,-2.9962221e-01,-2.9946220e-01,
  -2.9930219e-01,-2.9914221e-01,-2.9898220e-01,-2.9882222e-01,
  -2.9866228e-01,-2.9850230e-01,-2.9834235e-01,-2.9818240e-01,
  -2.9802245e-01,-2.9786250e-01,-2.9770258e-01,-2.9754266e-01,
  -2.9738274e-01,-2.9722282e-01,-2.9706293e-01,-2.9690304e-01,
  -2.9674315e-01,-2.9658329e-01,-2.9642344e-01,-2.9626358e-01,
  -2.9610372e-01,-2.9594386e-01,-2.9578403e-01,-2.9562420e-01,
  -2.9546437e-01,-2.9530457e-01,-2.9514477e-01,-2.9498497e-01,
  -2.9482517e-01,-2.9466537e-01,-2.9450560e-01,-2.9434583e-01,
  -2.9418609e-01,-2.9402632e-01,-2.9386657e-01,-2.9370683e-01,
  -2.9354709e-01,-2.9338738e-01,-2.9322764e-01,-2.9306796e-01,
  -2.9290825e-01,-2.9274854e-01,-2.9258886e-01,-2.9242918e-01,
  -2.9226950e-01,-2.9210985e-01,-2.9195020e-01,-2.9179054e-01,
  -2.9163089e-01,-2.9147127e-01,-2.9131162e-01,-2.9115203e-01,
  -2.9099241e-01,-2.9083279e-01,-2.9067320e-01,-2.9051360e-01,
  -2.9035401e-01,-2.9019445e-01,-2.9003489e-01,-2.8987533e-01,
  -2.8971577e-01,-2.8955624e-01,-2.8939667e-01,-2.8923714e-01,
  -2.8907764e-01,-2.8891811e-01,-2.8875861e-01,-2.8859910e-01,
  -2.8843960e-01,-2.8828013e-01,-2.8812063e-01,-2.8796116e-01,
  -2.8780171e-01,-2.8764224e-01,-2.8748280e-01,-2.8732336e-01,
  -2.8716391e-01,-2.8700447e-01,-2.8684506e-01,-2.8668565e-01,
  -2.8652623e-01,-2.8636685e-01,-2.8620744e-01,-2.8604805e-01,
  -2.8588867e-01,-2.8572932e-01,-2.8556997e-01,-2.8541058e-01,
  -2.8525126e-01,-2.8509191e-01,-2.8493258e-01,-2.8477323e-01,
  -2.8461394e-01,-2.8445461e-01,-2.8429532e-01,-2.8413600e-01,
  -2.8397670e-01,-2.8381744e-01,-2.8365815e-01,-2.8349888e-01,
  -2.8333962e-01,-2.8318036e-01,-2.8302112e-01,-2.8286189e-01,
  -2.8270265e-01,-2.8254342e-01,-2.8238422e-01,-2.8222498e-01,
  -2.8206578e-01,-2.8190657e-01,-2.8174740e-01,-2.8158823e-01,
  -2.8142905e-01,-2.8126988e-01,-2.8111070e-01,-2.8095156e-01,
  -2.8079242e-01,-2.8063327e-01,-2.8047413e-01,-2.8031501e-01,
  -2.8015590e-01,-2.7999678e-01,-2.7983767e-01,-2.7967858e-01,
  -2.7951947e-01,-2.7936038e-01,-2.7920133e-01,-2.7904224e-01,
  -2.7888319e-01,-2.7872413e-01,-2.7856508e-01,-2.7840602e-01,
  -2.7824700e-01,-2.7808797e-01,-2.7792895e-01,-2.7776995e-01,
  -2.7761093e-01,-2.7745193e-01,-2.7729294e-01,-2.7713397e-01,
  -2.7697498e-01,-2.7681601e-01,-2.7665704e-01,-2.7649808e-01,
  -2.7633914e-01,-2.7618021e-01,-2.7602127e-01,-2.7586234e-01,
  -2.7570340e-01,-2.7554449e-01,-2.7538559e-01,-2.7522668e-01,
  -2.7506778e-01,-2.7490890e-01,-2.7475002e-01,-2.7459115e-01,
  -2.7443227e-01,-2.7427343e-01,-2.7411455e-01,-2.7395570e-01,
  -2.7379689e-01,-2.7363804e-01,-2.7347922e-01,-2.7332041e-01,
  -2.7316159e-01,-2.7300277e-01,-2.7284399e-01,-2.7268520e-01,
  -2.7252641e-01,-2.7236763e-01,-2.7220887e-01,-2.7205011e-01,
  -2.7189136e-01,-2.7173260e-01,-2.7157384e-01,-2.7141511e-01,
  -2.7125639e-01,-2.7109766e-01,-2.7093893e-01,-2.7078024e-01,
  -2.7062154e-01,-2.7046284e-01,-2.7030414e-01,-2.7014548e-01,
  -2.6998681e-01,-2.6982814e-01,-2.6966947e-01,-2.6951081e-01,
  -2.6935217e-01,-2.6919353e-01,-2.6903489e-01,-2.6887625e-01,
  -2.6871765e-01,-2.6855904e-01,-2.6840043e-01,-2.6824182e-01,
  -2.6808321e-01,-2.6792464e-01,-2.6776606e-01,-2.6760748e-01,
  -2.6744893e-01,-2.6729035e-01,-2.6713181e-01,-2.6697326e-01,
  -2.6681474e-01,-2.6665619e-01,-2.6649767e-01,-2.6633915e-01,
  -2.6618063e-01,-2.6602212e-01,-2.6586363e-01,-2.6570514e-01,
  -2.6554665e-01,-2.6538816e-01,-2.6522970e-01,-2.6507124e-01,
  -2.6491278e-01,-2.6475433e-01,-2.6459587e-01,-2.6443744e-01,
  -2.6427901e-01,-2.6412058e-01,-2.6396215e-01,-2.6380375e-01,
  -2.6364532e-01,-2.6348692e-01,-2.6332855e-01,-2.6317015e-01,
  -2.6301178e-01,-2.6285341e-01,-2.6269504e-01,-2.6253667e-01,
  -2.6237831e-01,-2.6221997e-01,-2.6206163e-01,-2.6190329e-01,
  -2.6174498e-01,-2.6158664e-01,-2.6142833e-01,-2.6127002e-01,
  -2.6111174e-01,-2.6095343e-01,-2.6079515e-01,-2.6063687e-01,
  -2.6047859e-01,-2.6032031e-01,-2.6016206e-01,-2.6000381e-01,
  -2.5984555e-01,-2.5968730e-01,-2.5952908e-01,-2.5937083e-01,
  -2.5921261e-01,-2.5905439e-01,-2.5889620e-01,-2.5873798e-01,
  -2.5857979e-01,-2.5842160e-01,-2.5826341e-01,-2.5810525e-01,
  -2.5794709e-01,-2.5778890e-01,-2.5763074e-01,-2.5747260e-01,
  -2.5731444e-01,-2.5715631e-01,-2.5699818e-01,-2.5684005e-01,
  -2.5668195e-01,-2.5652382e-01,-2.5636572e-01,-2.5620762e-01,
  -2.5604951e-01,-2.5589144e-01,-2.5573334e-01,-2.5557527e-01,
  -2.5541720e-01,-2.5525916e-01,-2.5510108e-01,-2.5494304e-01,
  -2.5478500e-01,-2.5462696e-01,-2.5446895e-01,-2.5431091e-01,
  -2.5415289e-01,-2.5399488e-01,-2.5383687e-01,-2.5367889e-01,
  -2.5352088e-01,-2.5336289e-01,-2.5320491e-01,-2.5304696e-01,
  -2.5288898e-01,-2.5273103e-01,-2.5257307e-01,-2.5241512e-01,
  -2.5225717e-01,-2.5209925e-01,-2.5194132e-01,-2.5178340e-01,
  -2.5162548e-01,-2.5146756e-01,-2.5130966e-01,-2.5115177e-01,
  -2.5099388e-01,-2.5083598e-01,-2.5067809e-01,-2.5052023e-01,
  -2.5036237e-01,-2.5020450e-01,-2.5004664e-01,-2.4988881e-01,
  -2.4973096e-01,-2.4957313e-01,-2.4941529e-01,-2.4925748e-01,
  -2.4909966e-01,-2.4894185e-01,-2.4878405e-01,-2.4862625e-01,
  -2.4846846e-01,-2.4831067e-01,-2.4815290e-01,-2.4799512e-01,
  -2.4783735e-01,-2.4767959e-01,-2.4752183e-01,-2.4736409e-01,
  -2.4720635e-01,-2.4704860e-01,-2.4689087e-01,-2.4673316e-01,
  -2.4657543e-01,-2.4641773e-01,-2.4626002e-01,-2.4610232e-01,
  -2.4594462e-01,-2.4578694e-01,-2.4562925e-01,-2.4547158e-01,
  -2.4531391e-01,-2.4515624e-01,-2.4499859e-01,-2.4484095e-01,
  -2.4468330e-01,-2.4452566e-01,-2.4436803e-01,-2.4421041e-01,
  -2.4405278e-01,-2.4389517e-01,-2.4373756e-01,-2.4357995e-01,
  -2.4342236e-01,-2.4326476e-01,-2.4310718e-01,-2.4294960e-01,
  -2.4279204e-01,-2.4263448e-01,-2.4247691e-01,-2.4231936e-01,
  -2.4216181e-01,-2.4200428e-01,-2.4184673e-01,-2.4168921e-01,
  -2.4153168e-01,-2.4137416e-01,-2.4121664e-01,-2.4105914e-01,
  -2.4090165e-01,-2.4074414e-01,-2.4058667e-01,-2.4042918e-01,
  -2.4027170e-01,-2.4011423e-01,-2.3995677e-01,-2.3979931e-01,
  -2.3964186e-01,-2.3948441e-01,-2.3932697e-01,-2.3916954e-01,
  -2.3901211e-01,-2.3885469e-01,-2.3869728e-01,-2.3853986e-01,
  -2.3838246e-01,-2.3822506e-01,-2.3806766e-01,-2.3791027e-01,
  -2.3775290e-01,-2.3759551e-01,-2.3743816e-01,-2.3728079e-01,
  -2.3712343e-01,-2.3696607e-01,-2.3680873e-01,-2.3665139e-01,
  -2.3649406e-01,-2.3633672e-01,-2.3617941e-01,-2.3602208e-01,
  -2.3586477e-01,-2.3570748e-01,-2.3555018e-01,-2.3539288e-01,
  -2.3523560e-01,-2.3507832e-01,-2.3492104e-01,-2.3476377e-01,
  -2.3460650e-01,-2.3444925e-01,-2.3429200e-01,-2.3413475e-01,
  -2.3397751e-01,-2.3382027e-01,-2.3366304e-01,-2.3350582e-01,
  -2.3334859e-01,-2.3319139e-01,-2.3303418e-01,-2.3287699e-01,
  -2.3271978e-01,-2.3256260e-01,-2.3240541e-01,-2.3224823e-01,
  -2.3209107e-01,-2.3193389e-01,-2.3177674e-01,-2.3161958e-01,
  -2.3146243e-01,-2.3130529e-01,-2.3114815e-01,-2.3099102e-01,
  -2.3083389e-01,-2.3067677e-01,-2.3051965e-01,-2.3036255e-01,
  -2.3020545e-01,-2.3004834e-01,-2.2989126e-01,-2.2973417e-01,
  -2.2957709e-01,-2.2942002e-01,-2.2926295e-01,-2.2910587e-01,
  -2.2894882e-01,-2.2879177e-01,-2.2863473e-01,-2.2847769e-01,
  -2.2832064e-01,-2.2816361e-01,-2.2800660e-01,-2.2784957e-01,
  -2.2769256e-01,-2.2753556e-01,-2.2737855e-01,-2.2722156e-01,
  -2.2706456e-01,-2.2690758e-01,-2.2675060e-01,-2.2659363e-01,
  -2.2643666e-01,-2.2627969e-01,-2.2612274e-01,-2.2596578e-01,
  -2.2580884e-01,-2.2565190e-01,-2.2549497e-01,-2.2533804e-01,
  -2.2518112e-01,-2.2502419e-01,-2.2486728e-01,-2.2471038e-01,
  -2.2455348e-01,-2.2439659e-01,-2.2423969e-01,-2.2408280e-01,
  -2.2392592e-01,-2.2376905e-01,-2.2361219e-01,-2.2345532e-01,
  -2.2329846e-01,-2.2314161e-01,-2.2298476e-01,-2.2282793e-01,
  -2.2267109e-01,-2.2251426e-01,-2.2235744e-01,-2.2220062e-01,
  -2.2204380e-01,-2.2188699e-01,-2.2173019e-01,-2.2157340e-01,
  -2.2141661e-01,-2.2125982e-01,-2.2110303e-01,-2.2094625e-01,
  -2.2078949e-01,-2.2063272e-01,-2.2047597e-01,-2.2031921e-01,
  -2.2016247e-01,-2.2000572e-01,-2.1984898e-01,-2.1969225e-01,
  -2.1953553e-01,-2.1937880e-01,-2.1922208e-01,-2.1906538e-01,
  -2.1890867e-01,-2.1875197e-01,-2.1859528e-01,-2.1843858e-01,
  -2.1828191e-01,-2.1812522e-01,-2.1796855e-01,-2.1781188e-01,
  -2.1765523e-01,-2.1749857e-01,-2.1734191e-01,-2.1718527e-01,
  -2.1702863e-01,-2.1687199e-01,-2.1671537e-01,-2.1655874e-01,
  -2.1640211e-01,-2.1624550e-01,-2.1608889e-01,-2.1593229e-01,
  -2.1577568e-01,-2.1561910e-01,-2.1546251e-01,-2.1530592e-01,
  -2.1514934e-01,-2.1499278e-01,-2.1483621e-01,-2.1467964e-01,
  -2.1452309e-01,-2.1436654e-01,-2.1420999e-01,-2.1405345e-01,
  -2.1389692e-01,-2.1374039e-01,-2.1358387e-01,-2.1342735e-01,
  -2.1327083e-01,-2.1311432e-01,-2.1295781e-01,-2.1280132e-01,
  -2.1264483e-01,-2.1248834e-01,-2.1233186e-01,-2.1217538e-01,
  -2.1201891e-01,-2.1186243e-01,-2.1170597e-01,-2.1154952e-01,
  -2.1139307e-01,-2.1123663e-01,-2.1108018e-01,-2.1092375e-01,
  -2.1076731e-01,-2.1061088e-01,-2.1045446e-01,-2.1029805e-01,
  -2.1014164e-01,-2.0998523e-01,-2.0982882e-01,-2.0967244e-01,
  -2.0951605e-01,-2.0935966e-01,-2.0920329e-01,-2.0904690e-01,
  -2.0889054e-01,-2.0873417e-01,-2.0857781e-01,-2.0842145e-01,
  -2.0826511e-01,-2.0810877e-01,-2.0795242e-01,-2.0779610e-01,
  -2.0763977e-01,-2.0748344e-01,-2.0732713e-01,-2.0717081e-01,
  -2.0701450e-01,-2.0685819e-01,-2.0670189e-01,-2.0654561e-01,
  -2.0638931e-01,-2.0623302e-01,-2.0607676e-01,-2.0592047e-01,
  -2.0576420e-01,-2.0560795e-01,-2.0545170e-01,-2.0529544e-01,
  -2.0513919e-01,-2.0498295e-01,-2.0482671e-01,-2.0467047e-01,
  -2.0451425e-01,-2.0435803e-01,-2.0420180e-01,-2.0404559e-01,
  -2.0388938e-01,-2.0373318e-01,-2.0357698e-01,-2.0342079e-01,
  -2.0326459e-01,-2.0310842e-01,-2.0295224e-01,-2.0279607e-01,
  -2.0263989e-01,-2.0248373e-01,-2.0232758e-01,-2.0217142e-01,
  -2.0201527e-01,-2.0185913e-01,-2.0170298e-01,-2.0154685e-01,
  -2.0139073e-01,-2.0123459e-01,-2.0107847e-01,-2.0092237e-01,
  -2.0076625e-01,-2.0061015e-01,-2.0045406e-01,-2.0029795e-01,
  -2.0014186e-01,-1.9998579e-01,-1.9982970e-01,-1.9967362e-01,
  -1.9951756e-01,-1.9936149e-01,-1.9920543e-01,-1.9904937e-01,
  -1.9889332e-01,-1.9873728e-01,-1.9858123e-01,-1.9842520e-01,
  -1.9826917e-01,-1.9811314e-01,-1.9795711e-01,-1.9780110e-01,
  -1.9764508e-01,-1.9748908e-01,-1.9733308e-01,-1.9717708e-01,
  -1.9702108e-01,-1.9686510e-01,-1.9670911e-01,-1.9655314e-01,
  -1.9639716e-01,-1.9624120e-01,-1.9608523e-01,-1.9592927e-01,
  -1.9577332e-01,-1.9561736e-01,-1.9546142e-01,-1.9530548e-01,
  -1.9514954e-01,-1.9499362e-01,-1.9483769e-01,-1.9468176e-01,
  -1.9452584e-01,-1.9436993e-01,-1.9421403e-01,-1.9405812e-01,
  -1.9390222e-01,-1.9374633e-01,-1.9359045e-01,-1.9343455e-01,
  -1.9327869e-01,-1.9312280e-01,-1.9296694e-01,-1.9281107e-01,
  -1.9265521e-01,-1.9249935e-01,-1.9234350e-01,-1.9218765e-01,
  -1.9203182e-01,-1.9187598e-01,-1.9172014e-01,-1.9156432e-01,
  -1.9140849e-01,-1.9125268e-01,-1.9109686e-01,-1.9094105e-01,
  -1.9078524e-01,-1.9062945e-01,-1.9047365e-01,-1.9031785e-01,
  -1.9016208e-01,-1.9000629e-01,-1.8985051e-01,-1.8969475e-01,
  -1.8953897e-01,-1.8938321e-01,-1.8922745e-01,-1.8907170e-01,
  -1.8891595e-01,-1.8876021e-01,-1.8860446e-01,-1.8844873e-01,
  -1.8829300e-01,-1.8813728e-01,-1.8798155e-01,-1.8782583e-01,
  -1.8767013e-01,-1.8751441e-01,-1.8735871e-01,-1.8720300e-01,
  -1.8704732e-01,-1.8689163e-01,-1.8673594e-01,-1.8658026e-01,
  -1.8642458e-01,-1.8626891e-01,-1.8611324e-01,-1.8595758e-01,
  -1.8580192e-01,-1.8564627e-01,-1.8549062e-01,-1.8533497e-01,
  -1.8517934e-01,-1.8502370e-01,-1.8486807e-01,-1.8471244e-01,
  -1.8455681e-01,-1.8440120e-01,-1.8424559e-01,-1.8408997e-01,
  -1.8393438e-01,-1.8377876e-01,-1.8362318e-01,-1.8346758e-01,
  -1.8331200e-01,-1.8315642e-01,-1.8300083e-01,-1.8284526e-01,
  -1.8268970e-01,-1.8253413e-01,-1.8237856e-01,-1.8222301e-01,
  -1.8206745e-01,-1.8191192e-01,-1.8175636e-01,-1.8160082e-01,
  -1.8144530e-01,-1.8128976e-01,-1.8113424e-01,-1.8097872e-01,
  -1.8082321e-01,-1.8066770e-01,-1.8051219e-01,-1.8035668e-01,
  -1.8020119e-01,-1.8004569e-01,-1.7989020e-01,-1.7973471e-01,
  -1.7957923e-01,-1.7942375e-01,-1.7926829e-01,-1.7911281e-01,
  -1.7895734e-01,-1.7880189e-01,-1.7864643e-01,-1.7849098e-01,
  -1.7833553e-01,-1.7818010e-01,-1.7802465e-01,-1.7786922e-01,
  -1.7771380e-01,-1.7755836e-01,-1.7740294e-01,-1.7724752e-01,
  -1.7709212e-01,-1.7693670e-01,-1.7678130e-01,-1.7662591e-01,
  -1.7647050e-01,-1.7631511e-01,-1.7615972e-01,-1.7600435e-01,
  -1.7584896e-01,-1.7569359e-01,-1.7553823e-01,-1.7538285e-01,
  -1.7522749e-01,-1.7507213e-01,-1.7491679e-01,-1.7476144e-01,
  -1.7460610e-01,-1.7445076e-01,-1.7429541e-01,-1.7414008e-01,
  -1.7398475e-01,-1.7382944e-01,-1.7367411e-01,-1.7351879e-01,
  -1.7336349e-01,-1.7320818e-01,-1.7305288e-01,-1.7289758e-01,
  -1.7274229e-01,-1.7258699e-01,-1.7243171e-01,-1.7227642e-01,
  -1.7212115e-01,-1.7196588e-01,-1.7181061e-01,-1.7165534e-01,
  -1.7150009e-01,-1.7134482e-01,-1.7118958e-01,-1.7103432e-01,
  -1.7087908e-01,-1.7072384e-01,-1.7056860e-01,-1.7041337e-01,
  -1.7025813e-01,-1.7010292e-01,-1.6994770e-01,-1.6979249e-01,
  -1.6963726e-01,-1.6948207e-01,-1.6932686e-01,-1.6917166e-01,
  -1.6901647e-01,-1.6886127e-01,-1.6870609e-01,-1.6855091e-01,
  -1.6839573e-01,-1.6824055e-01,-1.6808538e-01,-1.6793022e-01,
  -1.6777505e-01,-1.6761988e-01,-1.6746473e-01,-1.6730958e-01,
  -1.6715443e-01,-1.6699930e-01,-1.6684416e-01,-1.6668902e-01,
  -1.6653389e-01,-1.6637877e-01,-1.6622365e-01,-1.6606852e-01,
  -1.6591340e-01,-1.6575830e-01,-1.6560319e-01,-1.6544808e-01,
  -1.6529299e-01,-1.6513789e-01,-1.6498280e-01,-1.6482772e-01,
  -1.6467263e-01,-1.6451755e-01,-1.6436248e-01,-1.6420740e-01,
  -1.6405234e-01,-1.6389728e-01,-1.6374221e-01,-1.6358717e-01,
  -1.6343211e-01,-1.6327706e-01,-1.6312201e-01,-1.6296698e-01,
  -1.6281195e-01,-1.6265692e-01,-1.6250189e-01,-1.6234685e-01,
  -1.6219184e-01,-1.6203682e-01,-1.6188180e-01,-1.6172680e-01,
  -1.6157180e-01,-1.6141680e-01,-1.6126180e-01,-1.6110681e-01,
  -1.6095182e-01,-1.6079684e-01,-1.6064185e-01,-1.6048688e-01,
  -1.6033190e-01,-1.6017693e-01,-1.6002196e-01,-1.5986700e-01,
  -1.5971205e-01,-1.5955709e-01,-1.5940215e-01,-1.5924719e-01,
  -1.5909225e-01,-1.5893732e-01,-1.5878238e-01,-1.5862745e-01,
  -1.5847252e-01,-1.5831760e-01,-1.5816268e-01,-1.5800776e-01,
  -1.5785284e-01,-1.5769795e-01,-1.5754303e-01,-1.5738814e-01,
  -1.5723324e-01,-1.5707834e-01,-1.5692346e-01,-1.5676856e-01,
  -1.5661368e-01,-1.5645881e-01,-1.5630393e-01,-1.5614906e-01,
  -1.5599419e-01,-1.5583932e-01,-1.5568447e-01,-1.5552962e-01,
  -1.5537477e-01,-1.5521991e-01,-1.5506507e-01,-1.5491022e-01,
  -1.5475538e-01,-1.5460056e-01,-1.5444572e-01,-1.5429090e-01,
  -1.5413608e-01,-1.5398125e-01,-1.5382645e-01,-1.5367164e-01,
  -1.5351683e-01,-1.5336202e-01,-1.5320723e-01,-1.5305242e-01,
  -1.5289763e-01,-1.5274285e-01,-1.5258805e-01,-1.5243328e-01,
  -1.5227850e-01,-1.5212372e-01,-1.5196896e-01,-1.5181418e-01,
  -1.5165941e-01,-1.5150465e-01,-1.5134990e-01,-1.5119515e-01,
  -1.5104041e-01,-1.5088566e-01,-1.5073091e-01,-1.5057617e-01,
  -1.5042144e-01,-1.5026671e-01,-1.5011197e-01,-1.4995725e-01,
  -1.4980254e-01,-1.4964782e-01,-1.4949310e-01,-1.4933839e-01,
  -1.4918369e-01,-1.4902899e-01,-1.4887428e-01,-1.4871959e-01,
  -1.4856490e-01,-1.4841022e-01,-1.4825553e-01,-1.4810084e-01,
  -1.4794616e-01,-1.4779149e-01,-1.4763682e-01,-1.4748216e-01,
  -1.4732748e-01,-1.4717282e-01,-1.4701818e-01,-1.4686352e-01,
  -1.4670888e-01,-1.4655423e-01,-1.4639959e-01,-1.4624494e-01,
  -1.4609031e-01,-1.4593567e-01,-1.4578104e-01,-1.4562643e-01,
  -1.4547180e-01,-1.4531718e-01,-1.4516257e-01,-1.4500795e-01,
  -1.4485335e-01,-1.4469874e-01,-1.4454414e-01,-1.4438954e-01,
  -1.4423496e-01,-1.4408036e-01,-1.4392577e-01,-1.4377119e-01,
  -1.4361662e-01,-1.4346203e-01,-1.4330746e-01,-1.4315289e-01,
  -1.4299832e-01,-1.4284377e-01,-1.4268920e-01,-1.4253464e-01,
  -1.4238009e-01,-1.4222555e-01,-1.4207099e-01,-1.4191645e-01,
  -1.4176191e-01,-1.4160737e-01,-1.4145285e-01,-1.4129832e-01,
  -1.4114380e-01,-1.4098927e-01,-1.4083475e-01,-1.4068024e-01,
  -1.4052573e-01,-1.4037122e-01,-1.4021671e-01,-1.4006221e-01,
  -1.3990770e-01,-1.3975321e-01,-1.3959873e-01,-1.3944423e-01,
  -1.3928975e-01,-1.3913527e-01,-1.3898079e-01,-1.3882631e-01,
  -1.3867185e-01,-1.3851736e-01,-1.3836290e-01,-1.3820843e-01,
  -1.3805398e-01,-1.3789953e-01,-1.3774507e-01,-1.3759063e-01,
  -1.3743618e-01,-1.3728173e-01,-1.3712730e-01,-1.3697286e-01,
  -1.3681842e-01,-1.3666400e-01,-1.3650957e-01,-1.3635515e-01,
  -1.3620073e-01,-1.3604632e-01,-1.3589190e-01,-1.3573749e-01,
  -1.3558309e-01,-1.3542868e-01,-1.3527428e-01,-1.3511989e-01,
  -1.3496549e-01,-1.3481110e-01,-1.3465671e-01,-1.3450232e-01,
  -1.3434795e-01,-1.3419357e-01,-1.3403919e-01,-1.3388482e-01,
  -1.3373046e-01,-1.3357610e-01,-1.3342173e-01,-1.3326737e-01,
  -1.3311301e-01,-1.3295867e-01,-1.3280430e-01,-1.3264996e-01,
  -1.3249563e-01,-1.3234128e-01,-1.3218695e-01,-1.3203262e-01,
  -1.3187829e-01,-1.3172396e-01,-1.3156962e-01,-1.3141531e-01,
  -1.3126099e-01,-1.3110667e-01,-1.3095237e-01,-1.3079806e-01,
  -1.3064376e-01,-1.3048945e-01,-1.3033515e-01,-1.3018085e-01,
  -1.3002656e-01,-1.2987228e-01,-1.2971799e-01,-1.2956370e-01,
  -1.2940942e-01,-1.2925515e-01,-1.2910087e-01,-1.2894660e-01,
  -1.2879233e-01,-1.2863807e-01,-1.2848380e-01,-1.2832955e-01,
  -1.2817529e-01,-1.2802103e-01,-1.2786679e-01,-1.2771255e-01,
  -1.2755829e-01,-1.2740405e-01,-1.2724982e-01,-1.2709558e-01,
  -1.2694135e-01,-1.2678713e-01,-1.2663290e-01,-1.2647867e-01,
  -1.2632446e-01,-1.2617023e-01,-1.2601602e-01,-1.2586181e-01,
  -1.2570761e-01,-1.2555340e-01,-1.2539920e-01,-1.2524500e-01,
  -1.2509081e-01,-1.2493662e-01,-1.2478243e-01,-1.2462824e-01,
  -1.2447406e-01,-1.2431987e-01,-1.2416570e-01,-1.2401152e-01,
  -1.2385735e-01,-1.2370318e-01,-1.2354901e-01,-1.2339485e-01,
  -1.2324069e-01,-1.2308653e-01,-1.2293238e-01,-1.2277823e-01,
  -1.2262408e-01,-1.2246993e-01,-1.2231579e-01,-1.2216165e-01,
  -1.2200751e-01,-1.2185338e-01,-1.2169925e-01,-1.2154512e-01,
  -1.2139100e-01,-1.2123688e-01,-1.2108275e-01,-1.2092864e-01,
  -1.2077452e-01,-1.2062041e-01,-1.2046631e-01,-1.2031220e-01,
  -1.2015810e-01,-1.2000400e-01,-1.1984990e-01,-1.1969581e-01,
  -1.1954172e-01,-1.1938763e-01,-1.1923354e-01,-1.1907946e-01,
  -1.1892538e-01,-1.1877131e-01,-1.1861723e-01,-1.1846316e-01,
  -1.1830909e-01,-1.1815502e-01,-1.1800096e-01,-1.1784691e-01,
  -1.1769284e-01,-1.1753879e-01,-1.1738474e-01,-1.1723069e-01,
  -1.1707664e-01,-1.1692260e-01,-1.1676856e-01,-1.1661452e-01,
  -1.1646049e-01,-1.1630645e-01,-1.1615243e-01,-1.1599840e-01,
  -1.1584438e-01,-1.1569036e-01,-1.1553634e-01,-1.1538232e-01,
  -1.1522831e-01,-1.1507430e-01,-1.1492029e-01,-1.1476628e-01,
  -1.1461229e-01,-1.1445829e-01,-1.1430429e-01,-1.1415029e-01,
  -1.1399630e-01,-1.1384232e-01,-1.1368833e-01,-1.1353435e-01,
  -1.1338037e-01,-1.1322639e-01,-1.1307242e-01,-1.1291844e-01,
  -1.1276447e-01,-1.1261050e-01,-1.1245654e-01,-1.1230258e-01,
  -1.1214862e-01,-1.1199466e-01,-1.1184071e-01,-1.1168676e-01,
  -1.1153281e-01,-1.1137886e-01,-1.1122492e-01,-1.1107098e-01,
  -1.1091705e-01,-1.1076311e-01,-1.1060917e-01,-1.1045524e-01,
  -1.1030132e-01,-1.1014739e-01,-1.0999347e-01,-1.0983955e-01,
  -1.0968564e-01,-1.0953172e-01,-1.0937781e-01,-1.0922390e-01,
  -1.0907000e-01,-1.0891609e-01,-1.0876219e-01,-1.0860829e-01,
  -1.0845440e-01,-1.0830050e-01,-1.0814661e-01,-1.0799272e-01,
  -1.0783884e-01,-1.0768496e-01,-1.0753107e-01,-1.0737719e-01,
  -1.0722332e-01,-1.0706945e-01,-1.0691557e-01,-1.0676171e-01,
  -1.0660784e-01,-1.0645398e-01,-1.0630012e-01,-1.0614626e-01,
  -1.0599241e-01,-1.0583855e-01,-1.0568470e-01,-1.0553085e-01,
  -1.0537700e-01,-1.0522316e-01,-1.0506932e-01,-1.0491548e-01,
  -1.0476165e-01,-1.0460781e-01,-1.0445399e-01,-1.0430016e-01,
  -1.0414633e-01,-1.0399251e-01,-1.0383869e-01,-1.0368487e-01,
  -1.0353106e-01,-1.0337724e-01,-1.0322343e-01,-1.0306962e-01,
  -1.0291582e-01,-1.0276201e-01,-1.0260821e-01,-1.0245441e-01,
  -1.0230061e-01,-1.0214682e-01,-1.0199303e-01,-1.0183924e-01,
  -1.0168546e-01,-1.0153167e-01,-1.0137789e-01,-1.0122411e-01,
  -1.0107033e-01,-1.0091656e-01,-1.0076278e-01,-1.0060901e-01,
  -1.0045525e-01,-1.0030148e-01,-1.0014772e-01,-9.9993959e-02,
  -9.9840201e-02,-9.9686444e-02,-9.9532694e-02,-9.9378943e-02,
  -9.9225193e-02,-9.9071443e-02,-9.8917700e-02,-9.8763958e-02,
  -9.8610222e-02,-9.8456487e-02,-9.8302752e-02,-9.8149016e-02,
  -9.7995289e-02,-9.7841561e-02,-9.7687833e-02,-9.7534113e-02,
  -9.7380392e-02,-9.7226672e-02,-9.7072959e-02,-9.6919239e-02,
  -9.6765533e-02,-9.6611820e-02,-9.6458115e-02,-9.6304409e-02,
  -9.6150704e-02,-9.5997006e-02,-9.5843308e-02,-9.5689617e-02,
  -9.5535919e-02,-9.5382228e-02,-9.5228538e-02,-9.5074855e-02,
  -9.4921172e-02,-9.4767489e-02,-9.4613805e-02,-9.4460130e-02,
  -9.4306454e-02,-9.4152778e-02,-9.3999110e-02,-9.3845442e-02,
  -9.3691774e-02,-9.3538113e-02,-9.3384452e-02,-9.3230791e-02,
  -9.3077131e-02,-9.2923477e-02,-9.2769824e-02,-9.2616171e-02,
  -9.2462525e-02,-9.2308879e-02,-9.2155233e-02,-9.2001587e-02,
  -9.1847949e-02,-9.1694310e-02,-9.1540672e-02,-9.1387041e-02,
  -9.1233410e-02,-9.1079779e-02,-9.0926155e-02,-9.0772524e-02,
  -9.0618901e-02,-9.0465285e-02,-9.0311661e-02,-9.0158045e-02,
  -9.0004437e-02,-8.9850821e-02,-8.9697212e-02,-8.9543603e-02,
  -8.9389995e-02,-8.9236394e-02,-8.9082792e-02,-8.8929191e-02,
  -8.8775598e-02,-8.8621996e-02,-8.8468403e-02,-8.8314816e-02,
  -8.8161223e-02,-8.8007636e-02,-8.7854050e-02,-8.7700471e-02,
  -8.7546885e-02,-8.7393306e-02,-8.7239735e-02,-8.7086156e-02,
  -8.6932585e-02,-8.6779013e-02,-8.6625449e-02,-8.6471878e-02,
  -8.6318314e-02,-8.6164750e-02,-8.6011194e-02,-8.5857637e-02,
  -8.5704081e-02,-8.5550524e-02,-8.5396968e-02,-8.5243419e-02,
  -8.5089870e-02,-8.4936328e-02,-8.4782779e-02,-8.4629238e-02,
  -8.4475696e-02,-8.4322162e-02,-8.4168628e-02,-8.4015094e-02,
  -8.3861560e-02,-8.3708026e-02,-8.3554499e-02,-8.3400972e-02,
  -8.3247446e-02,-8.3093926e-02,-8.2940407e-02,-8.2786888e-02,
  -8.2633369e-02,-8.2479857e-02,-8.2326345e-02,-8.2172833e-02,
  -8.2019322e-02,-8.1865817e-02,-8.1712313e-02,-8.1558809e-02,
  -8.1405304e-02,-8.1251808e-02,-8.1098311e-02,-8.0944814e-02,
  -8.0791324e-02,-8.0637828e-02,-8.0484338e-02,-8.0330849e-02,
  -8.0177367e-02,-8.0023885e-02,-7.9870403e-02,-7.9716921e-02,
  -7.9563439e-02,-7.9409964e-02,-7.9256490e-02,-7.9103015e-02,
  -7.8949548e-02,-7.8796074e-02,-7.8642607e-02,-7.8489147e-02,
  -7.8335680e-02,-7.8182220e-02,-7.8028761e-02,-7.7875301e-02,
  -7.7721842e-02,-7.7568389e-02,-7.7414937e-02,-7.7261485e-02,
  -7.7108040e-02,-7.6954588e-02,-7.6801144e-02,-7.6647706e-02,
  -7.6494262e-02,-7.6340824e-02,-7.6187387e-02,-7.6033950e-02,
  -7.5880513e-02,-7.5727083e-02,-7.5573653e-02,-7.5420223e-02,
  -7.5266793e-02,-7.5113371e-02,-7.4959941e-02,-7.4806519e-02,
  -7.4653104e-02,-7.4499682e-02,-7.4346267e-02,-7.4192852e-02,
  -7.4039437e-02,-7.3886029e-02,-7.3732615e-02,-7.3579207e-02,
  -7.3425800e-02,-7.3272400e-02,-7.3118992e-02,-7.2965592e-02,
  -7.2812192e-02,-7.2658800e-02,-7.2505400e-02,-7.2352007e-02,
  -7.2198614e-02,-7.2045222e-02,-7.1891837e-02,-7.1738444e-02,
  -7.1585059e-02,-7.1431674e-02,-7.1278296e-02,-7.1124911e-02,
  -7.0971534e-02,-7.0818156e-02,-7.0664778e-02,-7.0511408e-02,
  -7.0358038e-02,-7.0204668e-02,-7.0051298e-02,-6.9897927e-02,
  -6.9744565e-02,-6.9591194e-02,-6.9437832e-02,-6.9284476e-02,
  -6.9131114e-02,-6.8977758e-02,-6.8824403e-02,-6.8671048e-02,
  -6.8517692e-02,-6.8364345e-02,-6.8210997e-02,-6.8057649e-02,
  -6.7904301e-02,-6.7750953e-02,-6.7597613e-02,-6.7444272e-02,
  -6.7290932e-02,-6.7137592e-02,-6.6984251e-02,-6.6830918e-02,
  -6.6677585e-02,-6.6524252e-02,-6.6370919e-02,-6.6217594e-02,
  -6.6064268e-02,-6.5910943e-02,-6.5757617e-02,-6.5604292e-02,
  -6.5450974e-02,-6.5297648e-02,-6.5144330e-02,-6.4991020e-02,
  -6.4837702e-02,-6.4684391e-02,-6.4531073e-02,-6.4377762e-02,
  -6.4224459e-02,-6.4071149e-02,-6.3917845e-02,-6.3764535e-02,
  -6.3611232e-02,-6.3457936e-02,-6.3304633e-02,-6.3151337e-02,
  -6.2998042e-02,-6.2844746e-02,-6.2691450e-02,-6.2538154e-02,
  -6.2384866e-02,-6.2231574e-02,-6.2078286e-02,-6.1925001e-02,
  -6.1771713e-02,-6.1618429e-02,-6.1465148e-02,-6.1311867e-02,
  -6.1158586e-02,-6.1005309e-02,-6.0852032e-02,-6.0698759e-02,
  -6.0545482e-02,-6.0392212e-02,-6.0238939e-02,-6.0085669e-02,
  -5.9932403e-02,-5.9779137e-02,-5.9625871e-02,-5.9472606e-02,
  -5.9319343e-02,-5.9166081e-02,-5.9012823e-02,-5.8859564e-02,
  -5.8706306e-02,-5.8553051e-02,-5.8399796e-02,-5.8246545e-02,
  -5.8093295e-02,-5.7940044e-02,-5.7786793e-02,-5.7633545e-02,
  -5.7480302e-02,-5.7327054e-02,-5.7173811e-02,-5.7020571e-02,
  -5.6867331e-02,-5.6714091e-02,-5.6560852e-02,-5.6407616e-02,
  -5.6254379e-02,-5.6101147e-02,-5.5947915e-02,-5.5794682e-02,
  -5.5641454e-02,-5.5488225e-02,-5.5334996e-02,-5.5181768e-02,
  -5.5028547e-02,-5.4875322e-02,-5.4722100e-02,-5.4568879e-02,
  -5.4415658e-02,-5.4262441e-02,-5.4109223e-02,-5.3956006e-02,
  -5.3802792e-02,-5.3649578e-02,-5.3496365e-02,-5.3343154e-02,
  -5.3189944e-02,-5.3036738e-02,-5.2883528e-02,-5.2730326e-02,
  -5.2577119e-02,-5.2423917e-02,-5.2270714e-02,-5.2117512e-02,
  -5.1964313e-02,-5.1811114e-02,-5.1657919e-02,-5.1504720e-02,
  -5.1351525e-02,-5.1198334e-02,-5.1045138e-02,-5.0891947e-02,
  -5.0738759e-02,-5.0585568e-02,-5.0432380e-02,-5.0279196e-02,
  -5.0126009e-02,-4.9972825e-02,-4.9819645e-02,-4.9666461e-02,
  -4.9513280e-02,-4.9360100e-02,-4.9206924e-02,-4.9053743e-02,
  -4.8900571e-02,-4.8747394e-02,-4.8594221e-02,-4.8441049e-02,
  -4.8287876e-02,-4.8134707e-02,-4.7981538e-02,-4.7828369e-02,
  -4.7675204e-02,-4.7522034e-02,-4.7368873e-02,-4.7215708e-02,
  -4.7062546e-02,-4.6909384e-02,-4.6756223e-02,-4.6603065e-02,
  -4.6449907e-02,-4.6296749e-02,-4.6143591e-02,-4.5990437e-02,
  -4.5837283e-02,-4.5684133e-02,-4.5530979e-02,-4.5377828e-02,
  -4.5224681e-02,-4.5071531e-02,-4.4918384e-02,-4.4765238e-02,
  -4.4612091e-02,-4.4458948e-02,-4.4305805e-02,-4.4152662e-02,
  -4.3999523e-02,-4.3846380e-02,-4.3693241e-02,-4.3540105e-02,
  -4.3386966e-02,-4.3233830e-02,-4.3080695e-02,-4.2927563e-02,
  -4.2774428e-02,-4.2621296e-02,-4.2468168e-02,-4.2315036e-02,
  -4.2161908e-02,-4.2008780e-02,-4.1855652e-02,-4.1702528e-02,
  -4.1549399e-02,-4.1396279e-02,-4.1243155e-02,-4.1090030e-02,
  -4.0936910e-02,-4.0783789e-02,-4.0630672e-02,-4.0477552e-02,
  -4.0324435e-02,-4.0171318e-02,-4.0018205e-02,-3.9865088e-02,
  -3.9711975e-02,-3.9558861e-02,-3.9405752e-02,-3.9252639e-02,
  -3.9099529e-02,-3.8946420e-02,-3.8793314e-02,-3.8640205e-02,
  -3.8487099e-02,-3.8333993e-02,-3.8180891e-02,-3.8027786e-02,
  -3.7874684e-02,-3.7721582e-02,-3.7568480e-02,-3.7415382e-02,
  -3.7262283e-02,-3.7109185e-02,-3.6956087e-02,-3.6802988e-02,
  -3.6649894e-02,-3.6496799e-02,-3.6343705e-02,-3.6190614e-02,
  -3.6037520e-02,-3.5884429e-02,-3.5731338e-02,-3.5578247e-02,
  -3.5425160e-02,-3.5272073e-02,-3.5118986e-02,-3.4965899e-02,
  -3.4812812e-02,-3.4659728e-02,-3.4506645e-02,-3.4353562e-02,
  -3.4200478e-02,-3.4047395e-02,-3.3894315e-02,-3.3741236e-02,
  -3.3588156e-02,-3.3435080e-02,-3.3282001e-02,-3.3128925e-02,
  -3.2975849e-02,-3.2822773e-02,-3.2669697e-02,-3.2516625e-02,
  -3.2363553e-02,-3.2210480e-02,-3.2057408e-02,-3.1904336e-02,
  -3.1751268e-02,-3.1598199e-02,-3.1445131e-02,-3.1292062e-02,
  -3.1138994e-02,-3.0985929e-02,-3.0832862e-02,-3.0679798e-02,
  -3.0526733e-02,-3.0373670e-02,-3.0220607e-02,-3.0067546e-02,
  -2.9914485e-02,-2.9761424e-02,-2.9608363e-02,-2.9455304e-02,
  -2.9302247e-02,-2.9149190e-02,-2.8996132e-02,-2.8843075e-02,
  -2.8690020e-02,-2.8536964e-02,-2.8383911e-02,-2.8230855e-02,
  -2.8077804e-02,-2.7924750e-02,-2.7771698e-02,-2.7618648e-02,
  -2.7465597e-02,-2.7312547e-02,-2.7159499e-02,-2.7006449e-02,
  -2.6853401e-02,-2.6700355e-02,-2.6547307e-02,-2.6394261e-02,
  -2.6241217e-02,-2.6088171e-02,-2.5935126e-02,-2.5782084e-02,
  -2.5629040e-02,-2.5475997e-02,-2.5322957e-02,-2.5169915e-02,
  -2.5016874e-02,-2.4863834e-02,-2.4710795e-02,-2.4557756e-02,
  -2.4404718e-02,-2.4251681e-02,-2.4098642e-02,-2.3945605e-02,
  -2.3792570e-02,-2.3639536e-02,-2.3486501e-02,-2.3333466e-02,
  -2.3180431e-02,-2.3027398e-02,-2.2874366e-02,-2.2721333e-02,
  -2.2568302e-02,-2.2415271e-02,-2.2262240e-02,-2.2109210e-02,
  -2.1956179e-02,-2.1803152e-02,-2.1650122e-02,-2.1497095e-02,
  -2.1344068e-02,-2.1191040e-02,-2.1038013e-02,-2.0884987e-02,
  -2.0731961e-02,-2.0578936e-02,-2.0425912e-02,-2.0272888e-02,
  -2.0119864e-02,-1.9966841e-02,-1.9813819e-02,-1.9660797e-02,
  -1.9507775e-02,-1.9354753e-02,-1.9201731e-02,-1.9048711e-02,
  -1.8895691e-02,-1.8742671e-02,-1.8589653e-02,-1.8436635e-02,
  -1.8283617e-02,-1.8130599e-02,-1.7977580e-02,-1.7824564e-02,
  -1.7671548e-02,-1.7518532e-02,-1.7365515e-02,-1.7212501e-02,
  -1.7059484e-02,-1.6906470e-02,-1.6753457e-02,-1.6600443e-02,
  -1.6447430e-02,-1.6294416e-02,-1.6141403e-02,-1.5988393e-02,
  -1.5835380e-02,-1.5682369e-02,-1.5529358e-02,-1.5376347e-02,
  -1.5223336e-02,-1.5070327e-02,-1.4917317e-02,-1.4764308e-02,
  -1.4611298e-02,-1.4458290e-02,-1.4305281e-02,-1.4152274e-02,
  -1.3999267e-02,-1.3846259e-02,-1.3693252e-02,-1.3540246e-02,
  -1.3387239e-02,-1.3234233e-02,-1.3081227e-02,-1.2928222e-02,
  -1.2775217e-02,-1.2622212e-02,-1.2469208e-02,-1.2316204e-02,
  -1.2163199e-02,-1.2010196e-02,-1.1857193e-02,-1.1704190e-02,
  -1.1551186e-02,-1.1398184e-02,-1.1245182e-02,-1.1092179e-02,
  -1.0939178e-02,-1.0786177e-02,-1.0633175e-02,-1.0480175e-02,
  -1.0327173e-02,-1.0174173e-02,-1.0021173e-02,-9.8681729e-03,
  -9.7151734e-03,-9.5621739e-03,-9.4091743e-03,-9.2561757e-03,
  -9.1031762e-03,-8.9501776e-03,-8.7971790e-03,-8.6441813e-03,
  -8.4911827e-03,-8.3381850e-03,-8.1851874e-03,-8.0321897e-03,
  -7.8791929e-03,-7.7261953e-03,-7.5731985e-03,-7.4202018e-03,
  -7.2672050e-03,-7.1142088e-03,-6.9612125e-03,-6.8082167e-03,
  -6.6552204e-03,-6.5022251e-03,-6.3492293e-03,-6.1962339e-03,
  -6.0432386e-03,-5.8902432e-03,-5.7372483e-03,-5.5842535e-03,
  -5.4312586e-03,-5.2782642e-03,-5.1252693e-03,-4.9722749e-03,
  -4.8192809e-03,-4.6662865e-03,-4.5132926e-03,-4.3602986e-03,
  -4.2073047e-03,-4.0543112e-03,-3.9013172e-03,-3.7483238e-03,
  -3.5953303e-03,-3.4423368e-03,-3.2893436e-03,-3.1363503e-03,
  -2.9833571e-03,-2.8303640e-03,-2.6773710e-03,-2.5243780e-03,
  -2.3713852e-03,-2.2183922e-03,-2.0653994e-03,-1.9124068e-03,
  -1.7594141e-03,-1.6064214e-03,-1.4534288e-03,-1.3004362e-03,
  -1.1474437e-03,-9.9445111e-04,-8.4145856e-04,-6.8846607e-04,
  -5.3547358e-04,-3.8248114e-04,-2.2948868e-04,-7.6496224e-05,
   7.6496224e-05, 2.2948868e-04, 3.8248114e-04, 5.3547358e-04,
   6.8846607e-04, 8.4145856e-04, 9.9445111e-04, 1.1474437e-03,
   1.3004362e-03, 1.4534288e-03, 1.6064214e-03, 1.7594141e-03,
   1.9124068e-03, 2.0653994e-03, 2.2183922e-03, 2.3713852e-03,
   2.5243780e-03, 2.6773710e-03, 2.8303640e-03, 2.9833571e-03,
   3.1363503e-03, 3.2893436e-03, 3.4423368e-03, 3.5953303e-03,
   3.7483238e-03, 3.9013172e-03, 4.0543112e-03, 4.2073047e-03,
   4.3602986e-03, 4.5132926e-03, 4.6662865e-03, 4.8192809e-03,
   4.9722749e-03, 5.1252693e-03, 5.2782642e-03, 5.4312586e-03,
   5.5842535e-03, 5.7372483e-03, 5.8902432e-03, 6.0432386e-03,
   6.1962339e-03, 6.3492293e-03, 6.5022251e-03, 6.6552204e-03,
   6.8082167e-03, 6.9612125e-03, 7.1142088e-03, 7.2672050e-03,
   7.4202018e-03, 7.5731985e-03, 7.7261953e-03, 7.8791929e-03,
   8.0321897e-03, 8.1851874e-03, 8.3381850e-03, 8.4911827e-03,
   8.6441813e-03, 8.7971790e-03, 8.9501776e-03, 9.1031762e-03,
   9.2561757e-03, 9.4091743e-03, 9.5621739e-03, 9.7151734e-03,
   9.8681729e-03, 1.0021173e-02, 1.0174173e-02, 1.0327173e-02,
   1.0480175e-02, 1.0633175e-02, 1.0786177e-02, 1.0939178e-02,
   1.1092179e-02, 1.1245182e-02, 1.1398184e-02, 1.1551186e-02,
   1.1704190e-02, 1.1857193e-02, 1.2010196e-02, 1.2163199e-02,
   1.2316204e-02, 1.2469208e-02, 1.2622212e-02, 1.2775217e-02,
   1.2928222e-02, 1.3081227e-02, 1.3234233e-02, 1.3387239e-02,
   1.3540246e-02, 1.3693252e-02, 1.3846259e-02, 1.3999267e-02,
   1.4152274e-02, 1.4305281e-02, 1.4458290e-02, 1.4611298e-02,
   1.4764308e-02, 1.4917317e-02, 1.5070327e-02, 1.5223336e-02,
   1.5376347e-02, 1.5529358e-02, 1.5682369e-02, 1.5835380e-02,
   1.5988393e-02, 1.6141403e-02, 1.6294416e-02, 1.6447430e-02,
   1.6600443e-02, 1.6753457e-02, 1.6906470e-02, 1.7059484e-02,
   1.7212501e-02, 1.7365515e-02, 1.7518532e-02, 1.7671548e-02,
   1.7824564e-02, 1.7977580e-02, 1.8130599e-02, 1.8283617e-02,
   1.8436635e-02, 1.8589653e-02, 1.8742671e-02, 1.8895691e-02,
   1.9048711e-02, 1.9201731e-02, 1.9354753e-02, 1.9507775e-02,
   1.9660797e-02, 1.9813819e-02, 1.9966841e-02, 2.0119864e-02,
   2.0272888e-02, 2.0425912e-02, 2.0578936e-02, 2.0731961e-02,
   2.0884987e-02, 2.1038013e-02, 2.1191040e-02, 2.1344068e-02,
   2.1497095e-02, 2.1650122e-02, 2.1803152e-02, 2.1956179e-02,
   2.2109210e-02, 2.2262240e-02, 2.2415271e-02, 2.2568302e-02,
   2.2721333e-02, 2.2874366e-02, 2.3027398e-02, 2.3180431e-02,
   2.3333466e-02, 2.3486501e-02, 2.3639536e-02, 2.3792570e-02,
   2.3945605e-02, 2.4098642e-02, 2.4251681e-02, 2.4404718e-02,
   2.4557756e-02, 2.4710795e-02, 2.4863834e-02, 2.5016874e-02,
   2.5169915e-02, 2.5322957e-02, 2.5475997e-02, 2.5629040e-02,
   2.5782084e-02, 2.5935126e-02, 2.6088171e-02, 2.6241217e-02,
   2.6394261e-02, 2.6547307e-02, 2.6700355e-02, 2.6853401e-02,
   2.7006449e-02, 2.7159499e-02, 2.7312547e-02, 2.7465597e-02,
   2.7618648e-02, 2.7771698e-02, 2.7924750e-02, 2.8077804e-02,
   2.8230855e-02, 2.8383911e-02, 2.8536964e-02, 2.8690020e-02,
   2.8843075e-02, 2.8996132e-02, 2.9149190e-02, 2.9302247e-02,
   2.9455304e-02, 2.9608363e-02, 2.9761424e-02, 2.9914485e-02,
   3.0067546e-02, 3.0220607e-02, 3.0373670e-02, 3.0526733e-02,
   3.0679798e-02, 3.0832862e-02, 3.0985929e-02, 3.1138994e-02,
   3.1292062e-02, 3.1445131e-02, 3.1598199e-02, 3.1751268e-02,
   3.1904336e-02, 3.2057408e-02, 3.2210480e-02, 3.2363553e-02,
   3.2516625e-02, 3.2669697e-02, 3.2822773e-02, 3.2975849e-02,
   3.3128925e-02, 3.3282001e-02, 3.3435080e-02, 3.3588156e-02,
   3.3741236e-02, 3.3894315e-02, 3.4047395e-02, 3.4200478e-02,
   3.4353562e-02, 3.4506645e-02, 3.4659728e-02, 3.4812812e-02,
   3.4965899e-02, 3.5118986e-02, 3.5272073e-02, 3.5425160e-02,
   3.5578247e-02, 3.5731338e-02, 3.5884429e-02, 3.6037520e-02,
   3.6190614e-02, 3.6343705e-02, 3.6496799e-02, 3.6649894e-02,
   3.6802988e-02, 3.6956087e-02, 3.7109185e-02, 3.7262283e-02,
   3.7415382e-02, 3.7568480e-02, 3.7721582e-02, 3.7874684e-02,
   3.8027786e-02, 3.8180891e-02, 3.8333993e-02, 3.8487099e-02,
   3.8640205e-02, 3.8793314e-02, 3.8946420e-02, 3.9099529e-02,
   3.9252639e-02, 3.9405752e-02, 3.9558861e-02, 3.9711975e-02,
   3.9865088e-02, 4.0018205e-02, 4.0171318e-02, 4.0324435e-02,
   4.0477552e-02, 4.0630672e-02, 4.0783789e-02, 4.0936910e-02,
   4.1090030e-02, 4.1243155e-02, 4.1396279e-02, 4.1549399e-02,
   4.1702528e-02, 4.1855652e-02, 4.2008780e-02, 4.2161908e-02,
   4.2315036e-02, 4.2468168e-02, 4.2621296e-02, 4.2774428e-02,
   4.2927563e-02, 4.3080695e-02, 4.3233830e-02, 4.3386966e-02,
   4.3540105e-02, 4.3693241e-02, 4.3846380e-02, 4.3999523e-02,
   4.4152662e-02, 4.4305805e-02, 4.4458948e-02, 4.4612091e-02,
   4.4765238e-02, 4.4918384e-02, 4.5071531e-02, 4.5224681e-02,
   4.5377828e-02, 4.5530979e-02, 4.5684133e-02, 4.5837283e-02,
   4.5990437e-02, 4.6143591e-02, 4.6296749e-02, 4.6449907e-02,
   4.6603065e-02, 4.6756223e-02, 4.6909384e-02, 4.7062546e-02,
   4.7215708e-02, 4.7368873e-02, 4.7522034e-02, 4.7675204e-02,
   4.7828369e-02, 4.7981538e-02, 4.8134707e-02, 4.8287876e-02,
   4.8441049e-02, 4.8594221e-02, 4.8747394e-02, 4.8900571e-02,
   4.9053743e-02, 4.9206924e-02, 4.9360100e-02, 4.9513280e-02,
   4.9666461e-02, 4.9819645e-02, 4.9972825e-02, 5.0126009e-02,
   5.0279196e-02, 5.0432380e-02, 5.0585568e-02, 5.0738759e-02,
   5.0891947e-02, 5.1045138e-02, 5.1198334e-02, 5.1351525e-02,
   5.1504720e-02, 5.1657919e-02, 5.1811114e-02, 5.1964313e-02,
   5.2117512e-02, 5.2270714e-02, 5.2423917e-02, 5.2577119e-02,
   5.2730326e-02, 5.2883528e-02, 5.3036738e-02, 5.3189944e-02,
   5.3343154e-02, 5.3496365e-02, 5.3649578e-02, 5.3802792e-02,
   5.3956006e-02, 5.4109223e-02, 5.4262441e-02, 5.4415658e-02,
   5.4568879e-02, 5.4722100e-02, 5.4875322e-02, 5.5028547e-02,
   5.5181768e-02, 5.5334996e-02, 5.5488225e-02, 5.5641454e-02,
   5.5794682e-02, 5.5947915e-02, 5.6101147e-02, 5.6254379e-02,
   5.6407616e-02, 5.6560852e-02, 5.6714091e-02, 5.6867331e-02,
   5.7020571e-02, 5.7173811e-02, 5.7327054e-02, 5.7480302e-02,
   5.7633545e-02, 5.7786793e-02, 5.7940044e-02, 5.8093295e-02,
   5.8246545e-02, 5.8399796e-02, 5.8553051e-02, 5.8706306e-02,
   5.8859564e-02, 5.9012823e-02, 5.9166081e-02, 5.9319343e-02,
   5.9472606e-02, 5.9625871e-02, 5.9779137e-02, 5.9932403e-02,
   6.0085669e-02, 6.0238939e-02, 6.0392212e-02, 6.0545482e-02,
   6.0698759e-02, 6.0852032e-02, 6.1005309e-02, 6.1158586e-02,
   6.1311867e-02, 6.1465148e-02, 6.1618429e-02, 6.1771713e-02,
   6.1925001e-02, 6.2078286e-02, 6.2231574e-02, 6.2384866e-02,
   6.2538154e-02, 6.2691450e-02, 6.2844746e-02, 6.2998042e-02,
   6.3151337e-02, 6.3304633e-02, 6.3457936e-02, 6.3611232e-02,
   6.3764535e-02, 6.3917845e-02, 6.4071149e-02, 6.4224459e-02,
   6.4377762e-02, 6.4531073e-02, 6.4684391e-02, 6.4837702e-02,
   6.4991020e-02, 6.5144330e-02, 6.5297648e-02, 6.5450974e-02,
   6.5604292e-02, 6.5757617e-02, 6.5910943e-02, 6.6064268e-02,
   6.6217594e-02, 6.6370919e-02, 6.6524252e-02, 6.6677585e-02,
   6.6830918e-02, 6.6984251e-02, 6.7137592e-02, 6.7290932e-02,
   6.7444272e-02, 6.7597613e-02, 6.7750953e-02, 6.7904301e-02,
   6.8057649e-02, 6.8210997e-02, 6.8364345e-02, 6.8517692e-02,
   6.8671048e-02, 6.8824403e-02, 6.8977758e-02, 6.9131114e-02,
   6.9284476e-02, 6.9437832e-02, 6.9591194e-02, 6.9744565e-02,
   6.9897927e-02, 7.0051298e-02, 7.0204668e-02, 7.0358038e-02,
   7.0511408e-02, 7.0664778e-02, 7.0818156e-02, 7.0971534e-02,
   7.1124911e-02, 7.1278296e-02, 7.1431674e-02, 7.1585059e-02,
   7.1738444e-02, 7.1891837e-02, 7.2045222e-02, 7.2198614e-02,
   7.2352007e-02, 7.2505400e-02, 7.2658800e-02, 7.2812192e-02,
   7.2965592e-02, 7.3118992e-02, 7.3272400e-02, 7.3425800e-02,
   7.3579207e-02, 7.3732615e-02, 7.3886029e-02, 7.4039437e-02,
   7.4192852e-02, 7.4346267e-02, 7.4499682e-02, 7.4653104e-02,
   7.4806519e-02, 7.4959941e-02, 7.5113371e-02, 7.5266793e-02,
   7.5420223e-02, 7.5573653e-02, 7.5727083e-02, 7.5880513e-02,
   7.6033950e-02, 7.6187387e-02, 7.6340824e-02, 7.6494262e-02,
   7.6647706e-02, 7.6801144e-02, 7.6954588e-02, 7.7108040e-02,
   7.7261485e-02, 7.7414937e-02, 7.7568389e-02, 7.7721842e-02,
   7.7875301e-02, 7.8028761e-02, 7.8182220e-02, 7.8335680e-02,
   7.8489147e-02, 7.8642607e-02, 7.8796074e-02, 7.8949548e-02,
   7.9103015e-02, 7.9256490e-02, 7.9409964e-02, 7.9563439e-02,
   7.9716921e-02, 7.9870403e-02, 8.0023885e-02, 8.0177367e-02,
   8.0330849e-02, 8.0484338e-02, 8.0637828e-02, 8.0791324e-02,
   8.0944814e-02, 8.1098311e-02, 8.1251808e-02, 8.1405304e-02,
   8.1558809e-02, 8.1712313e-02, 8.1865817e-02, 8.2019322e-02,
   8.2172833e-02, 8.2326345e-02, 8.2479857e-02, 8.2633369e-02,
   8.2786888e-02, 8.2940407e-02, 8.3093926e-02, 8.3247446e-02,
   8.3400972e-02, 8.3554499e-02, 8.3708026e-02, 8.3861560e-02,
   8.4015094e-02, 8.4168628e-02, 8.4322162e-02, 8.4475696e-02,
   8.4629238e-02, 8.4782779e-02, 8.4936328e-02, 8.5089870e-02,
   8.5243419e-02, 8.5396968e-02, 8.5550524e-02, 8.5704081e-02,
   8.5857637e-02, 8.6011194e-02, 8.6164750e-02, 8.6318314e-02,
   8.6471878e-02, 8.6625449e-02, 8.6779013e-02, 8.6932585e-02,
   8.7086156e-02, 8.7239735e-02, 8.7393306e-02, 8.7546885e-02,
   8.7700471e-02, 8.7854050e-02, 8.8007636e-02, 8.8161223e-02,
   8.8314816e-02, 8.8468403e-02, 8.8621996e-02, 8.8775598e-02,
   8.8929191e-02, 8.9082792e-02, 8.9236394e-02, 8.9389995e-02,
   8.9543603e-02, 8.9697212e-02, 8.9850821e-02, 9.0004437e-02,
   9.0158045e-02, 9.0311661e-02, 9.0465285e-02, 9.0618901e-02,
   9.0772524e-02, 9.0926155e-02, 9.1079779e-02, 9.1233410e-02,
   9.1387041e-02, 9.1540672e-02, 9.1694310e-02, 9.1847949e-02,
   9.2001587e-02, 9.2155233e-02, 9.2308879e-02, 9.2462525e-02,
   9.2616171e-02, 9.2769824e-02, 9.2923477e-02, 9.3077131e-02,
   9.3230791e-02, 9.3384452e-02, 9.3538113e-02, 9.3691774e-02,
   9.3845442e-02, 9.3999110e-02, 9.4152778e-02, 9.4306454e-02,
   9.4460130e-02, 9.4613805e-02, 9.4767489e-02, 9.4921172e-02,
   9.5074855e-02, 9.5228538e-02, 9.5382228e-02, 9.5535919e-02,
   9.5689617e-02, 9.5843308e-02, 9.5997006e-02, 9.6150704e-02,
   9.6304409e-02, 9.6458115e-02, 9.6611820e-02, 9.6765533e-02,
   9.6919239e-02, 9.7072959e-02, 9.7226672e-02, 9.7380392e-02,
   9.7534113e-02, 9.7687833e-02, 9.7841561e-02, 9.7995289e-02,
   9.8149016e-02, 9.8302752e-02, 9.8456487e-02, 9.8610222e-02,
   9.8763958e-02, 9.8917700e-02, 9.9071443e-02, 9.9225193e-02,
   9.9378943e-02, 9.9532694e-02, 9.9686444e-02, 9.9840201e-02,
   9.9993959e-02, 1.0014772e-01, 1.0030148e-01, 1.0045525e-01,
   1.0060901e-01, 1.0076278e-01, 1.0091656e-01, 1.0107033e-01,
   1.0122411e-01, 1.0137789e-01, 1.0153167e-01, 1.0168546e-01,
   1.0183924e-01, 1.0199303e-01, 1.0214682e-01, 1.0230061e-01,
   1.0245441e-01, 1.0260821e-01, 1.0276201e-01, 1.0291582e-01,
   1.0306962e-01, 1.0322343e-01, 1.0337724e-01, 1.0353106e-01,
   1.0368487e-01, 1.0383869e-01, 1.0399251e-01, 1.0414633e-01,
   1.0430016e-01, 1.0445399e-01, 1.0460781e-01, 1.0476165e-01,
   1.0491548e-01, 1.0506932e-01, 1.0522316e-01, 1.0537700e-01,
   1.0553085e-01, 1.0568470e-01, 1.0583855e-01, 1.0599241e-01,
   1.0614626e-01, 1.0630012e-01, 1.0645398e-01, 1.0660784e-01,
   1.0676171e-01, 1.0691557e-01, 1.0706945e-01, 1.0722332e-01,
   1.0737719e-01, 1.0753107e-01, 1.0768496e-01, 1.0783884e-01,
   1.0799272e-01, 1.0814661e-01, 1.0830050e-01, 1.0845440e-01,
   1.0860829e-01, 1.0876219e-01, 1.0891609e-01, 1.0907000e-01,
   1.0922390e-01, 1.0937781e-01, 1.0953172e-01, 1.0968564e-01,
   1.0983955e-01, 1.0999347e-01, 1.1014739e-01, 1.1030132e-01,
   1.1045524e-01, 1.1060917e-01, 1.1076311e-01, 1.1091705e-01,
   1.1107098e-01, 1.1122492e-01, 1.1137886e-01, 1.1153281e-01,
   1.1168676e-01, 1.1184071e-01, 1.1199466e-01, 1.1214862e-01,
   1.1230258e-01, 1.1245654e-01, 1.1261050e-01, 1.1276447e-01,
   1.1291844e-01, 1.1307242e-01, 1.1322639e-01, 1.1338037e-01,
   1.1353435e-01, 1.1368833e-01, 1.1384232e-01, 1.1399630e-01,
   1.1415029e-01, 1.1430429e-01, 1.1445829e-01, 1.1461229e-01,
   1.1476628e-01, 1.1492029e-01, 1.1507430e-01, 1.1522831e-01,
   1.1538232e-01, 1.1553634e-01, 1.1569036e-01, 1.1584438e-01,
   1.1599840e-01, 1.1615243e-01, 1.1630645e-01, 1.1646049e-01,
   1.1661452e-01, 1.1676856e-01, 1.1692260e-01, 1.1707664e-01,
   1.1723069e-01, 1.1738474e-01, 1.1753879e-01, 1.1769284e-01,
   1.1784691e-01, 1.1800096e-01, 1.1815502e-01, 1.1830909e-01,
   1.1846316e-01, 1.1861723e-01, 1.1877131e-01, 1.1892538e-01,
   1.1907946e-01, 1.1923354e-01, 1.1938763e-01, 1.1954172e-01,
   1.1969581e-01, 1.1984990e-01, 1.2000400e-01, 1.2015810e-01,
   1.2031220e-01, 1.2046631e-01, 1.2062041e-01, 1.2077452e-01,
   1.2092864e-01, 1.2108275e-01, 1.2123688e-01, 1.2139100e-01,
   1.2154512e-01, 1.2169925e-01, 1.2185338e-01, 1.2200751e-01,
   1.2216165e-01, 1.2231579e-01, 1.2246993e-01, 1.2262408e-01,
   1.2277823e-01, 1.2293238e-01, 1.2308653e-01, 1.2324069e-01,
   1.2339485e-01, 1.2354901e-01, 1.2370318e-01, 1.2385735e-01,
   1.2401152e-01, 1.2416570e-01, 1.2431987e-01, 1.2447406e-01,
   1.2462824e-01, 1.2478243e-01, 1.2493662e-01, 1.2509081e-01,
   1.2524500e-01, 1.2539920e-01, 1.2555340e-01, 1.2570761e-01,
   1.2586181e-01, 1.2601602e-01, 1.2617023e-01, 1.2632446e-01,
   1.2647867e-01, 1.2663290e-01, 1.2678713e-01, 1.2694135e-01,
   1.2709558e-01, 1.2724982e-01, 1.2740405e-01, 1.2755829e-01,
   1.2771255e-01, 1.2786679e-01, 1.2802103e-01, 1.2817529e-01,
   1.2832955e-01, 1.2848380e-01, 1.2863807e-01, 1.2879233e-01,
   1.2894660e-01, 1.2910087e-01, 1.2925515e-01, 1.2940942e-01,
   1.2956370e-01, 1.2971799e-01, 1.2987228e-01, 1.3002656e-01,
   1.3018085e-01, 1.3033515e-01, 1.3048945e-01, 1.3064376e-01,
   1.3079806e-01, 1.3095237e-01, 1.3110667e-01, 1.3126099e-01,
   1.3141531e-01, 1.3156962e-01, 1.3172396e-01, 1.3187829e-01,
   1.3203262e-01, 1.3218695e-01, 1.3234128e-01, 1.3249563e-01,
   1.3264996e-01, 1.3280430e-01, 1.3295867e-01, 1.3311301e-01,
   1.3326737e-01, 1.3342173e-01, 1.3357610e-01, 1.3373046e-01,
   1.3388482e-01, 1.3403919e-01, 1.3419357e-01, 1.3434795e-01,
   1.3450232e-01, 1.3465671e-01, 1.3481110e-01, 1.3496549e-01,
   1.3511989e-01, 1.3527428e-01, 1.3542868e-01, 1.3558309e-01,
   1.3573749e-01, 1.3589190e-01, 1.3604632e-01, 1.3620073e-01,
   1.3635515e-01, 1.3650957e-01, 1.3666400e-01, 1.3681842e-01,
   1.3697286e-01, 1.3712730e-01, 1.3728173e-01, 1.3743618e-01,
   1.3759063e-01, 1.3774507e-01, 1.3789953e-01, 1.3805398e-01,
   1.3820843e-01, 1.3836290e-01, 1.3851736e-01, 1.3867185e-01,
   1.3882631e-01, 1.3898079e-01, 1.3913527e-01, 1.3928975e-01,
   1.3944423e-01, 1.3959873e-01, 1.3975321e-01, 1.3990770e-01,
   1.4006221e-01, 1.4021671e-01, 1.4037122e-01, 1.4052573e-01,
   1.4068024e-01, 1.4083475e-01, 1.4098927e-01, 1.4114380e-01,
   1.4129832e-01, 1.4145285e-01, 1.4160737e-01, 1.4176191e-01,
   1.4191645e-01, 1.4207099e-01, 1.4222555e-01, 1.4238009e-01,
   1.4253464e-01, 1.4268920e-01, 1.4284377e-01, 1.4299832e-01,
   1.4315289e-01, 1.4330746e-01, 1.4346203e-01, 1.4361662e-01,
   1.4377119e-01, 1.4392577e-01, 1.4408036e-01, 1.4423496e-01,
   1.4438954e-01, 1.4454414e-01, 1.4469874e-01, 1.4485335e-01,
   1.4500795e-01, 1.4516257e-01, 1.4531718e-01, 1.4547180e-01,
   1.4562643e-01, 1.4578104e-01, 1.4593567e-01, 1.4609031e-01,
   1.4624494e-01, 1.4639959e-01, 1.4655423e-01, 1.4670888e-01,
   1.4686352e-01, 1.4701818e-01, 1.4717282e-01, 1.4732748e-01,
   1.4748216e-01, 1.4763682e-01, 1.4779149e-01, 1.4794616e-01,
   1.4810084e-01, 1.4825553e-01, 1.4841022e-01, 1.4856490e-01,
   1.4871959e-01, 1.4887428e-01, 1.4902899e-01, 1.4918369e-01,
   1.4933839e-01, 1.4949310e-01, 1.4964782e-01, 1.4980254e-01,
   1.4995725e-01, 1.5011197e-01, 1.5026671e-01, 1.5042144e-01,
   1.5057617e-01, 1.5073091e-01, 1.5088566e-01, 1.5104041e-01,
   1.5119515e-01, 1.5134990e-01, 1.5150465e-01, 1.5165941e-01,
   1.5181418e-01, 1.5196896e-01, 1.5212372e-01, 1.5227850e-01,
   1.5243328e-01, 1.5258805e-01, 1.5274285e-01, 1.5289763e-01,
   1.5305242e-01, 1.5320723e-01, 1.5336202e-01, 1.5351683e-01,
   1.5367164e-01, 1.5382645e-01, 1.5398125e-01, 1.5413608e-01,
   1.5429090e-01, 1.5444572e-01, 1.5460056e-01, 1.5475538e-01,
   1.5491022e-01, 1.5506507e-01, 1.5521991e-01, 1.5537477e-01,
   1.5552962e-01, 1.5568447e-01, 1.5583932e-01, 1.5599419e-01,
   1.5614906e-01, 1.5630393e-01, 1.5645881e-01, 1.5661368e-01,
   1.5676856e-01, 1.5692346e-01, 1.5707834e-01, 1.5723324e-01,
   1.5738814e-01, 1.5754303e-01, 1.5769795e-01, 1.5785284e-01,
   1.5800776e-01, 1.5816268e-01, 1.5831760e-01, 1.5847252e-01,
   1.5862745e-01, 1.5878238e-01, 1.5893732e-01, 1.5909225e-01,
   1.5924719e-01, 1.5940215e-01, 1.5955709e-01, 1.5971205e-01,
   1.5986700e-01, 1.6002196e-01, 1.6017693e-01, 1.6033190e-01,
   1.6048688e-01, 1.6064185e-01, 1.6079684e-01, 1.6095182e-01,
   1.6110681e-01, 1.6126180e-01, 1.6141680e-01, 1.6157180e-01,
   1.6172680e-01, 1.6188180e-01, 1.6203682e-01, 1.6219184e-01,
   1.6234685e-01, 1.6250189e-01, 1.6265692e-01, 1.6281195e-01,
   1.6296698e-01, 1.6312201e-01, 1.6327706e-01, 1.6343211e-01,
   1.6358717e-01, 1.6374221e-01, 1.6389728e-01, 1.6405234e-01,
   1.6420740e-01, 1.6436248e-01, 1.6451755e-01, 1.6467263e-01,
   1.6482772e-01, 1.6498280e-01, 1.6513789e-01, 1.6529299e-01,
   1.6544808e-01, 1.6560319e-01, 1.6575830e-01, 1.6591340e-01,
   1.6606852e-01, 1.6622365e-01, 1.6637877e-01, 1.6653389e-01,
   1.6668902e-01, 1.6684416e-01, 1.6699930e-01, 1.6715443e-01,
   1.6730958e-01, 1.6746473e-01, 1.6761988e-01, 1.6777505e-01,
   1.6793022e-01, 1.6808538e-01, 1.6824055e-01, 1.6839573e-01,
   1.6855091e-01, 1.6870609e-01, 1.6886127e-01, 1.6901647e-01,
   1.6917166e-01, 1.6932686e-01, 1.6948207e-01, 1.6963726e-01,
   1.6979249e-01, 1.6994770e-01, 1.7010292e-01, 1.7025813e-01,
   1.7041337e-01, 1.7056860e-01, 1.7072384e-01, 1.7087908e-01,
   1.7103432e-01, 1.7118958e-01, 1.7134482e-01, 1.7150009e-01,
   1.7165534e-01, 1.7181061e-01, 1.7196588e-01, 1.7212115e-01,
   1.7227642e-01, 1.7243171e-01, 1.7258699e-01, 1.7274229e-01,
   1.7289758e-01, 1.7305288e-01, 1.7320818e-01, 1.7336349e-01,
   1.7351879e-01, 1.7367411e-01, 1.7382944e-01, 1.7398475e-01,
   1.7414008e-01, 1.7429541e-01, 1.7445076e-01, 1.7460610e-01,
   1.7476144e-01, 1.7491679e-01, 1.7507213e-01, 1.7522749e-01,
   1.7538285e-01, 1.7553823e-01, 1.7569359e-01, 1.7584896e-01,
   1.7600435e-01, 1.7615972e-01, 1.7631511e-01, 1.7647050e-01,
   1.7662591e-01, 1.7678130e-01, 1.7693670e-01, 1.7709212e-01,
   1.7724752e-01, 1.7740294e-01, 1.7755836e-01, 1.7771380e-01,
   1.7786922e-01, 1.7802465e-01, 1.7818010e-01, 1.7833553e-01,
   1.7849098e-01, 1.7864643e-01, 1.7880189e-01, 1.7895734e-01,
   1.7911281e-01, 1.7926829e-01, 1.7942375e-01, 1.7957923e-01,
   1.7973471e-01, 1.7989020e-01, 1.8004569e-01, 1.8020119e-01,
   1.8035668e-01, 1.8051219e-01, 1.8066770e-01, 1.8082321e-01,
   1.8097872e-01, 1.8113424e-01, 1.8128976e-01, 1.8144530e-01,
   1.8160082e-01, 1.8175636e-01, 1.8191192e-01, 1.8206745e-01,
   1.8222301e-01, 1.8237856e-01, 1.8253413e-01, 1.8268970e-01,
   1.8284526e-01, 1.8300083e-01, 1.8315642e-01, 1.8331200e-01,
   1.8346758e-01, 1.8362318e-01, 1.8377876e-01, 1.8393438e-01,
   1.8408997e-01, 1.8424559e-01, 1.8440120e-01, 1.8455681e-01,
   1.8471244e-01, 1.8486807e-01, 1.8502370e-01, 1.8517934e-01,
   1.8533497e-01, 1.8549062e-01, 1.8564627e-01, 1.8580192e-01,
   1.8595758e-01, 1.8611324e-01, 1.8626891e-01, 1.8642458e-01,
   1.8658026e-01, 1.8673594e-01, 1.8689163e-01, 1.8704732e-01,
   1.8720300e-01, 1.8735871e-01, 1.8751441e-01, 1.8767013e-01,
   1.8782583e-01, 1.8798155e-01, 1.8813728e-01, 1.8829300e-01,
   1.8844873e-01, 1.8860446e-01, 1.8876021e-01, 1.8891595e-01,
   1.8907170e-01, 1.8922745e-01, 1.8938321e-01, 1.8953897e-01,
   1.8969475e-01, 1.8985051e-01, 1.9000629e-01, 1.9016208e-01,
   1.9031785e-01, 1.9047365e-01, 1.9062945e-01, 1.9078524e-01,
   1.9094105e-01, 1.9109686e-01, 1.9125268e-01, 1.9140849e-01,
   1.9156432e-01, 1.9172014e-01, 1.9187598e-01, 1.9203182e-01,
   1.9218765e-01, 1.9234350e-01, 1.9249935e-01, 1.9265521e-01,
   1.9281107e-01, 1.9296694e-01, 1.9312280e-01, 1.9327869e-01,
   1.9343455e-01, 1.9359045e-01, 1.9374633e-01, 1.9390222e-01,
   1.9405812e-01, 1.9421403e-01, 1.9436993e-01, 1.9452584e-01,
   1.9468176e-01, 1.9483769e-01, 1.9499362e-01, 1.9514954e-01,
   1.9530548e-01, 1.9546142e-01, 1.9561736e-01, 1.9577332e-01,
   1.9592927e-01, 1.9608523e-01, 1.9624120e-01, 1.9639716e-01,
   1.9655314e-01, 1.9670911e-01, 1.9686510e-01, 1.9702108e-01,
   1.9717708e-01, 1.9733308e-01, 1.9748908e-01, 1.9764508e-01,
   1.9780110e-01, 1.9795711e-01, 1.9811314e-01, 1.9826917e-01,
   1.9842520e-01, 1.9858123e-01, 1.9873728e-01, 1.9889332e-01,
   1.9904937e-01, 1.9920543e-01, 1.9936149e-01, 1.9951756e-01,
   1.9967362e-01, 1.9982970e-01, 1.9998579e-01, 2.0014186e-01,
   2.0029795e-01, 2.0045406e-01, 2.0061015e-01, 2.0076625e-01,
   2.0092237e-01, 2.0107847e-01, 2.0123459e-01, 2.0139073e-01,
   2.0154685e-01, 2.0170298e-01, 2.0185913e-01, 2.0201527e-01,
   2.0217142e-01, 2.0232758e-01, 2.0248373e-01, 2.0263989e-01,
   2.0279607e-01, 2.0295224e-01, 2.0310842e-01, 2.0326459e-01,
   2.0342079e-01, 2.0357698e-01, 2.0373318e-01, 2.0388938e-01,
   2.0404559e-01, 2.0420180e-01, 2.0435803e-01, 2.0451425e-01,
   2.0467047e-01, 2.0482671e-01, 2.0498295e-01, 2.0513919e-01,
   2.0529544e-01, 2.0545170e-01, 2.0560795e-01, 2.0576420e-01,
   2.0592047e-01, 2.0607676e-01, 2.0623302e-01, 2.0638931e-01,
   2.0654561e-01, 2.0670189e-01, 2.0685819e-01, 2.0701450e-01,
   2.0717081e-01, 2.0732713e-01, 2.0748344e-01, 2.0763977e-01,
   2.0779610e-01, 2.0795242e-01, 2.0810877e-01, 2.0826511e-01,
   2.0842145e-01, 2.0857781e-01, 2.0873417e-01, 2.0889054e-01,
   2.0904690e-01, 2.0920329e-01, 2.0935966e-01, 2.0951605e-01,
   2.0967244e-01, 2.0982882e-01, 2.0998523e-01, 2.1014164e-01,
   2.1029805e-01, 2.1045446e-01, 2.1061088e-01, 2.1076731e-01,
   2.1092375e-01, 2.1108018e-01, 2.1123663e-01, 2.1139307e-01,
   2.1154952e-01, 2.1170597e-01, 2.1186243e-01, 2.1201891e-01,
   2.1217538e-01, 2.1233186e-01, 2.1248834e-01, 2.1264483e-01,
   2.1280132e-01, 2.1295781e-01, 2.1311432e-01, 2.1327083e-01,
   2.1342735e-01, 2.1358387e-01, 2.1374039e-01, 2.1389692e-01,
   2.1405345e-01, 2.1420999e-01, 2.1436654e-01, 2.1452309e-01,
   2.1467964e-01, 2.1483621e-01, 2.1499278e-01, 2.1514934e-01,
   2.1530592e-01, 2.1546251e-01, 2.1561910e-01, 2.1577568e-01,
   2.1593229e-01, 2.1608889e-01, 2.1624550e-01, 2.1640211e-01,
   2.1655874e-01, 2.1671537e-01, 2.1687199e-01, 2.1702863e-01,
   2.1718527e-01, 2.1734191e-01, 2.1749857e-01, 2.1765523e-01,
   2.1781188e-01, 2.1796855e-01, 2.1812522e-01, 2.1828191e-01,
   2.1843858e-01, 2.1859528e-01, 2.1875197e-01, 2.1890867e-01,
   2.1906538e-01, 2.1922208e-01, 2.1937880e-01, 2.1953553e-01,
   2.1969225e-01, 2.1984898e-01, 2.2000572e-01, 2.2016247e-01,
   2.2031921e-01, 2.2047597e-01, 2.2063272e-01, 2.2078949e-01,
   2.2094625e-01, 2.2110303e-01, 2.2125982e-01, 2.2141661e-01,
   2.2157340e-01, 2.2173019e-01, 2.2188699e-01, 2.2204380e-01,
   2.2220062e-01, 2.2235744e-01, 2.2251426e-01, 2.2267109e-01,
   2.2282793e-01, 2.2298476e-01, 2.2314161e-01, 2.2329846e-01,
   2.2345532e-01, 2.2361219e-01, 2.2376905e-01, 2.2392592e-01,
   2.2408280e-01, 2.2423969e-01, 2.2439659e-01, 2.2455348e-01,
   2.2471038e-01, 2.2486728e-01, 2.2502419e-01, 2.2518112e-01,
   2.2533804e-01, 2.2549497e-01, 2.2565190e-01, 2.2580884e-01,
   2.2596578e-01, 2.2612274e-01, 2.2627969e-01, 2.2643666e-01,
   2.2659363e-01, 2.2675060e-01, 2.2690758e-01, 2.2706456e-01,
   2.2722156e-01, 2.2737855e-01, 2.2753556e-01, 2.2769256e-01,
   2.2784957e-01, 2.2800660e-01, 2.2816361e-01, 2.2832064e-01,
   2.2847769e-01, 2.2863473e-01, 2.2879177e-01, 2.2894882e-01,
   2.2910587e-01, 2.2926295e-01, 2.2942002e-01, 2.2957709e-01,
   2.2973417e-01, 2.2989126e-01, 2.3004834e-01, 2.3020545e-01,
   2.3036255e-01, 2.3051965e-01, 2.3067677e-01, 2.3083389e-01,
   2.3099102e-01, 2.3114815e-01, 2.3130529e-01, 2.3146243e-01,
   2.3161958e-01, 2.3177674e-01, 2.3193389e-01, 2.3209107e-01,
   2.3224823e-01, 2.3240541e-01, 2.3256260e-01, 2.3271978e-01,
   2.3287699e-01, 2.3303418e-01, 2.3319139e-01, 2.3334859e-01,
   2.3350582e-01, 2.3366304e-01, 2.3382027e-01, 2.3397751e-01,
   2.3413475e-01, 2.3429200e-01, 2.3444925e-01, 2.3460650e-01,
   2.3476377e-01, 2.3492104e-01, 2.3507832e-01, 2.3523560e-01,
   2.3539288e-01, 2.3555018e-01, 2.3570748e-01, 2.3586477e-01,
   2.3602208e-01, 2.3617941e-01, 2.3633672e-01, 2.3649406e-01,
   2.3665139e-01, 2.3680873e-01, 2.3696607e-01, 2.3712343e-01,
   2.3728079e-01, 2.3743816e-01, 2.3759551e-01, 2.3775290e-01,
   2.3791027e-01, 2.3806766e-01, 2.3822506e-01, 2.3838246e-01,
   2.3853986e-01, 2.3869728e-01, 2.3885469e-01, 2.3901211e-01,
   2.3916954e-01, 2.3932697e-01, 2.3948441e-01, 2.3964186e-01,
   2.3979931e-01, 2.3995677e-01, 2.4011423e-01, 2.4027170e-01,
   2.4042918e-01, 2.4058667e-01, 2.4074414e-01, 2.4090165e-01,
   2.4105914e-01, 2.4121664e-01, 2.4137416e-01, 2.4153168e-01,
   2.4168921e-01, 2.4184673e-01, 2.4200428e-01, 2.4216181e-01,
   2.4231936e-01, 2.4247691e-01, 2.4263448e-01, 2.4279204e-01,
   2.4294960e-01, 2.4310718e-01, 2.4326476e-01, 2.4342236e-01,
   2.4357995e-01, 2.4373756e-01, 2.4389517e-01, 2.4405278e-01,
   2.4421041e-01, 2.4436803e-01, 2.4452566e-01, 2.4468330e-01,
   2.4484095e-01, 2.4499859e-01, 2.4515624e-01, 2.4531391e-01,
   2.4547158e-01, 2.4562925e-01, 2.4578694e-01, 2.4594462e-01,
   2.4610232e-01, 2.4626002e-01, 2.4641773e-01, 2.4657543e-01,
   2.4673316e-01, 2.4689087e-01, 2.4704860e-01, 2.4720635e-01,
   2.4736409e-01, 2.4752183e-01, 2.4767959e-01, 2.4783735e-01,
   2.4799512e-01, 2.4815290e-01, 2.4831067e-01, 2.4846846e-01,
   2.4862625e-01, 2.4878405e-01, 2.4894185e-01, 2.4909966e-01,
   2.4925748e-01, 2.4941529e-01, 2.4957313e-01, 2.4973096e-01,
   2.4988881e-01, 2.5004664e-01, 2.5020450e-01, 2.5036237e-01,
   2.5052023e-01, 2.5067809e-01, 2.5083598e-01, 2.5099388e-01,
   2.5115177e-01, 2.5130966e-01, 2.5146756e-01, 2.5162548e-01,
   2.5178340e-01, 2.5194132e-01, 2.5209925e-01, 2.5225717e-01,
   2.5241512e-01, 2.5257307e-01, 2.5273103e-01, 2.5288898e-01,
   2.5304696e-01, 2.5320491e-01, 2.5336289e-01, 2.5352088e-01,
   2.5367889e-01, 2.5383687e-01, 2.5399488e-01, 2.5415289e-01,
   2.5431091e-01, 2.5446895e-01, 2.5462696e-01, 2.5478500e-01,
   2.5494304e-01, 2.5510108e-01, 2.5525916e-01, 2.5541720e-01,
   2.5557527e-01, 2.5573334e-01, 2.5589144e-01, 2.5604951e-01,
   2.5620762e-01, 2.5636572e-01, 2.5652382e-01, 2.5668195e-01,
   2.5684005e-01, 2.5699818e-01, 2.5715631e-01, 2.5731444e-01,
   2.5747260e-01, 2.5763074e-01, 2.5778890e-01, 2.5794709e-01,
   2.5810525e-01, 2.5826341e-01, 2.5842160e-01, 2.5857979e-01,
   2.5873798e-01, 2.5889620e-01, 2.5905439e-01, 2.5921261e-01,
   2.5937083e-01, 2.5952908e-01, 2.5968730e-01, 2.5984555e-01,
   2.6000381e-01, 2.6016206e-01, 2.6032031e-01, 2.6047859e-01,
   2.6063687e-01, 2.6079515e-01, 2.6095343e-01, 2.6111174e-01,
   2.6127002e-01, 2.6142833e-01, 2.6158664e-01, 2.6174498e-01,
   2.6190329e-01, 2.6206163e-01, 2.6221997e-01, 2.6237831e-01,
   2.6253667e-01, 2.6269504e-01, 2.6285341e-01, 2.6301178e-01,
   2.6317015e-01, 2.6332855e-01, 2.6348692e-01, 2.6364532e-01,
   2.6380375e-01, 2.6396215e-01, 2.6412058e-01, 2.6427901e-01,
   2.6443744e-01, 2.6459587e-01, 2.6475433e-01, 2.6491278e-01,
   2.6507124e-01, 2.6522970e-01, 2.6538816e-01, 2.6554665e-01,
   2.6570514e-01, 2.6586363e-01, 2.6602212e-01, 2.6618063e-01,
   2.6633915e-01, 2.6649767e-01, 2.6665619e-01, 2.6681474e-01,
   2.6697326e-01, 2.6713181e-01, 2.6729035e-01, 2.6744893e-01,
   2.6760748e-01, 2.6776606e-01, 2.6792464e-01, 2.6808321e-01,
   2.6824182e-01, 2.6840043e-01, 2.6855904e-01, 2.6871765e-01,
   2.6887625e-01, 2.6903489e-01, 2.6919353e-01, 2.6935217e-01,
   2.6951081e-01, 2.6966947e-01, 2.6982814e-01, 2.6998681e-01,
   2.7014548e-01, 2.7030414e-01, 2.7046284e-01, 2.7062154e-01,
   2.7078024e-01, 2.7093893e-01, 2.7109766e-01, 2.7125639e-01,
   2.7141511e-01, 2.7157384e-01, 2.7173260e-01, 2.7189136e-01,
   2.7205011e-01, 2.7220887e-01, 2.7236763e-01, 2.7252641e-01,
   2.7268520e-01, 2.7284399e-01, 2.7300277e-01, 2.7316159e-01,
   2.7332041e-01, 2.7347922e-01, 2.7363804e-01, 2.7379689e-01,
   2.7395570e-01, 2.7411455e-01, 2.7427343e-01, 2.7443227e-01,
   2.7459115e-01, 2.7475002e-01, 2.7490890e-01, 2.7506778e-01,
   2.7522668e-01, 2.7538559e-01, 2.7554449e-01, 2.7570340e-01,
   2.7586234e-01, 2.7602127e-01, 2.7618021e-01, 2.7633914e-01,
   2.7649808e-01, 2.7665704e-01, 2.7681601e-01, 2.7697498e-01,
   2.7713397e-01, 2.7729294e-01, 2.7745193e-01, 2.7761093e-01,
   2.7776995e-01, 2.7792895e-01, 2.7808797e-01, 2.7824700e-01,
   2.7840602e-01, 2.7856508e-01, 2.7872413e-01, 2.7888319e-01,
   2.7904224e-01, 2.7920133e-01, 2.7936038e-01, 2.7951947e-01,
   2.7967858e-01, 2.7983767e-01, 2.7999678e-01, 2.8015590e-01,
   2.8031501e-01, 2.8047413e-01, 2.8063327e-01, 2.8079242e-01,
   2.8095156e-01, 2.8111070e-01, 2.8126988e-01, 2.8142905e-01,
   2.8158823e-01, 2.8174740e-01, 2.8190657e-01, 2.8206578e-01,
   2.8222498e-01, 2.8238422e-01, 2.8254342e-01, 2.8270265e-01,
   2.8286189e-01, 2.8302112e-01, 2.8318036e-01, 2.8333962e-01,
   2.8349888e-01, 2.8365815e-01, 2.8381744e-01, 2.8397670e-01,
   2.8413600e-01, 2.8429532e-01, 2.8445461e-01, 2.8461394e-01,
   2.8477323e-01, 2.8493258e-01, 2.8509191e-01, 2.8525126e-01,
   2.8541058e-01, 2.8556997e-01, 2.8572932e-01, 2.8588867e-01,
   2.8604805e-01, 2.8620744e-01, 2.8636685e-01, 2.8652623e-01,
   2.8668565e-01, 2.8684506e-01, 2.8700447e-01, 2.8716391e-01,
   2.8732336e-01, 2.8748280e-01, 2.8764224e-01, 2.8780171e-01,
   2.8796116e-01, 2.8812063e-01, 2.8828013e-01, 2.8843960e-01,
   2.8859910e-01, 2.8875861e-01, 2.8891811e-01, 2.8907764e-01,
   2.8923714e-01, 2.8939667e-01, 2.8955624e-01, 2.8971577e-01,
   2.8987533e-01, 2.9003489e-01, 2.9019445e-01, 2.9035401e-01,
   2.9051360e-01, 2.9067320e-01, 2.9083279e-01, 2.9099241e-01,
   2.9115203e-01, 2.9131162e-01, 2.9147127e-01, 2.9163089e-01,
   2.9179054e-01, 2.9195020e-01, 2.9210985e-01, 2.9226950e-01,
   2.9242918e-01, 2.9258886e-01, 2.9274854e-01, 2.9290825e-01,
   2.9306796e-01, 2.9322764e-01, 2.9338738e-01, 2.9354709e-01,
   2.9370683e-01, 2.9386657e-01, 2.9402632e-01, 2.9418609e-01,
   2.9434583e-01, 2.9450560e-01, 2.9466537e-01, 2.9482517e-01,
   2.9498497e-01, 2.9514477e-01, 2.9530457e-01, 2.9546437e-01,
   2.9562420e-01, 2.9578403e-01, 2.9594386e-01, 2.9610372e-01,
   2.9626358e-01, 2.9642344e-01, 2.9658329e-01, 2.9674315e-01,
   2.9690304e-01, 2.9706293e-01, 2.9722282e-01, 2.9738274e-01,
   2.9754266e-01, 2.9770258e-01, 2.9786250e-01, 2.9802245e-01,
   2.9818240e-01, 2.9834235e-01, 2.9850230e-01, 2.9866228e-01,
   2.9882222e-01, 2.9898220e-01, 2.9914221e-01, 2.9930219e-01,
   2.9946220e-01, 2.9962221e-01, 2.9978225e-01, 2.9994226e-01,
   3.0010229e-01, 3.0026236e-01, 3.0042240e-01, 3.0058247e-01,
   3.0074254e-01, 3.0090261e-01, 3.0106267e-01, 3.0122277e-01,
   3.0138287e-01, 3.0154297e-01, 3.0170310e-01, 3.0186319e-01,
   3.0202332e-01, 3.0218348e-01, 3.0234361e-01, 3.0250376e-01,
   3.0266392e-01, 3.0282408e-01, 3.0298427e-01, 3.0314445e-01,
   3.0330464e-01, 3.0346483e-01, 3.0362505e-01, 3.0378526e-01,
   3.0394548e-01, 3.0410570e-01, 3.0426595e-01, 3.0442619e-01,
   3.0458644e-01, 3.0474669e-01, 3.0490696e-01, 3.0506724e-01,
   3.0522752e-01, 3.0538782e-01, 3.0554810e-01, 3.0570841e-01,
   3.0586874e-01, 3.0602905e-01, 3.0618939e-01, 3.0634972e-01,
   3.0651006e-01, 3.0667043e-01, 3.0683079e-01, 3.0699116e-01,
   3.0715156e-01, 3.0731192e-01, 3.0747232e-01, 3.0763271e-01,
   3.0779314e-01, 3.0795354e-01, 3.0811396e-01, 3.0827442e-01,
   3.0843484e-01, 3.0859530e-01, 3.0875576e-01, 3.0891621e-01,
   3.0907670e-01, 3.0923718e-01, 3.0939767e-01, 3.0955815e-01,
   3.0971867e-01, 3.0987918e-01, 3.1003970e-01, 3.1020024e-01,
   3.1036076e-01, 3.1052130e-01, 3.1068188e-01, 3.1084242e-01,
   3.1100300e-01, 3.1116357e-01, 3.1132415e-01, 3.1148475e-01,
   3.1164536e-01, 3.1180596e-01, 3.1196660e-01, 3.1212720e-01,
   3.1228784e-01, 3.1244847e-01, 3.1260914e-01, 3.1276980e-01,
   3.1293046e-01, 3.1309113e-01, 3.1325182e-01, 3.1341252e-01,
   3.1357321e-01, 3.1373391e-01, 3.1389463e-01, 3.1405535e-01,
   3.1421608e-01, 3.1437680e-01, 3.1453755e-01, 3.1469831e-01,
   3.1485909e-01, 3.1501985e-01, 3.1518063e-01, 3.1534141e-01,
   3.1550223e-01, 3.1566301e-01, 3.1582382e-01, 3.1598464e-01,
   3.1614548e-01, 3.1630632e-01, 3.1646717e-01, 3.1662801e-01,
   3.1678888e-01, 3.1694973e-01, 3.1711063e-01, 3.1727150e-01,
   3.1743240e-01, 3.1759331e-01, 3.1775421e-01, 3.1791514e-01,
   3.1807604e-01, 3.1823698e-01, 3.1839794e-01, 3.1855887e-01,
   3.1871983e-01, 3.1888083e-01, 3.1904179e-01, 3.1920278e-01,
   3.1936377e-01, 3.1952477e-01, 3.1968579e-01, 3.1984678e-01,
   3.2000783e-01, 3.2016885e-01, 3.2032990e-01, 3.2049096e-01,
   3.2065201e-01, 3.2081306e-01, 3.2097414e-01, 3.2113522e-01,
   3.2129633e-01, 3.2145742e-01, 3.2161853e-01, 3.2177964e-01,
   3.2194078e-01, 3.2210192e-01, 3.2226306e-01, 3.2242420e-01,
   3.2258537e-01, 3.2274655e-01, 3.2290772e-01, 3.2306889e-01,
   3.2323009e-01, 3.2339129e-01, 3.2355249e-01, 3.2371372e-01,
   3.2387495e-01, 3.2403618e-01, 3.2419741e-01, 3.2435867e-01,
   3.2451993e-01, 3.2468119e-01, 3.2484248e-01, 3.2500377e-01,
   3.2516506e-01, 3.2532635e-01, 3.2548767e-01, 3.2564899e-01,
   3.2581031e-01, 3.2597166e-01, 3.2613301e-01, 3.2629436e-01,
   3.2645571e-01, 3.2661709e-01, 3.2677847e-01, 3.2693985e-01,
   3.2710126e-01, 3.2726264e-01, 3.2742405e-01, 3.2758549e-01,
   3.2774693e-01, 3.2790837e-01, 3.2806981e-01, 3.2823125e-01,
   3.2839271e-01, 3.2855418e-01, 3.2871568e-01, 3.2887715e-01,
   3.2903865e-01, 3.2920018e-01, 3.2936168e-01, 3.2952321e-01,
   3.2968473e-01, 3.2984629e-01, 3.3000782e-01, 3.3016938e-01,
   3.3033097e-01, 3.3049253e-01, 3.3065411e-01, 3.3081570e-01,
   3.3097732e-01, 3.3113891e-01, 3.3130056e-01, 3.3146217e-01,
   3.3162379e-01, 3.3178544e-01, 3.3194712e-01, 3.3210877e-01,
   3.3227044e-01, 3.3243212e-01, 3.3259380e-01, 3.3275551e-01,
   3.3291721e-01, 3.3307892e-01, 3.3324066e-01, 3.3340237e-01,
   3.3356413e-01, 3.3372587e-01, 3.3388764e-01, 3.3404940e-01,
   3.3421117e-01, 3.3437297e-01, 3.3453473e-01, 3.3469656e-01,
   3.3485836e-01, 3.3502018e-01, 3.3518201e-01, 3.3534384e-01,
   3.3550569e-01, 3.3566755e-01, 3.3582941e-01, 3.3599129e-01,
   3.3615315e-01, 3.3631504e-01, 3.3647695e-01, 3.3663887e-01,
   3.3680078e-01, 3.3696270e-01, 3.3712465e-01, 3.3728656e-01,
   3.3744854e-01, 3.3761048e-01, 3.3777246e-01, 3.3793443e-01,
   3.3809641e-01, 3.3825842e-01, 3.3842042e-01, 3.3858243e-01,
   3.3874446e-01, 3.3890650e-01, 3.3906853e-01, 3.3923057e-01,
   3.3939263e-01, 3.3955470e-01, 3.3971679e-01, 3.3987886e-01,
   3.4004095e-01, 3.4020305e-01, 3.4036517e-01, 3.4052730e-01,
   3.4068942e-01, 3.4085155e-01, 3.4101370e-01, 3.4117585e-01,
   3.4133804e-01, 3.4150019e-01, 3.4166238e-01, 3.4182459e-01,
   3.4198678e-01, 3.4214899e-01, 3.4231120e-01, 3.4247345e-01,
   3.4263566e-01, 3.4279794e-01, 3.4296018e-01, 3.4312245e-01,
   3.4328473e-01, 3.4344700e-01, 3.4360930e-01, 3.4377158e-01,
   3.4393391e-01, 3.4409621e-01, 3.4425855e-01, 3.4442088e-01,
   3.4458324e-01, 3.4474558e-01, 3.4490794e-01, 3.4507033e-01,
   3.4523270e-01, 3.4539509e-01, 3.4555748e-01, 3.4571990e-01,
   3.4588233e-01, 3.4604475e-01, 3.4620720e-01, 3.4636962e-01,
   3.4653208e-01, 3.4669456e-01, 3.4685704e-01, 3.4701952e-01,
   3.4718201e-01, 3.4734452e-01, 3.4750700e-01, 3.4766954e-01,
   3.4783205e-01, 3.4799460e-01, 3.4815714e-01, 3.4831971e-01,
   3.4848228e-01, 3.4864485e-01, 3.4880742e-01, 3.4897003e-01,
   3.4913263e-01, 3.4929523e-01, 3.4945786e-01, 3.4962049e-01,
   3.4978312e-01, 3.4994578e-01, 3.5010841e-01, 3.5027111e-01,
   3.5043377e-01, 3.5059646e-01, 3.5075915e-01, 3.5092187e-01,
   3.5108456e-01, 3.5124728e-01, 3.5141003e-01, 3.5157275e-01,
   3.5173550e-01, 3.5189828e-01, 3.5206103e-01, 3.5222381e-01,
   3.5238662e-01, 3.5254940e-01, 3.5271221e-01, 3.5287502e-01,
   3.5303786e-01, 3.5320070e-01, 3.5336354e-01, 3.5352638e-01,
   3.5368925e-01, 3.5385212e-01, 3.5401499e-01, 3.5417789e-01,
   3.5434079e-01, 3.5450372e-01, 3.5466662e-01, 3.5482955e-01,
   3.5499248e-01, 3.5515544e-01, 3.5531840e-01, 3.5548136e-01,
   3.5564435e-01, 3.5580733e-01, 3.5597032e-01, 3.5613331e-01,
   3.5629633e-01, 3.5645935e-01, 3.5662240e-01, 3.5678545e-01,
   3.5694849e-01, 3.5711154e-01, 3.5727462e-01, 3.5743770e-01,
   3.5760078e-01, 3.5776389e-01, 3.5792699e-01, 3.5809010e-01,
   3.5825324e-01, 3.5841638e-01, 3.5857952e-01, 3.5874268e-01,
   3.5890585e-01, 3.5906902e-01, 3.5923222e-01, 3.5939538e-01,
   3.5955861e-01, 3.5972181e-01, 3.5988504e-01, 3.6004826e-01,
   3.6021152e-01, 3.6037478e-01, 3.6053804e-01, 3.6070129e-01,
   3.6086458e-01, 3.6102787e-01, 3.6119115e-01, 3.6135447e-01,
   3.6151779e-01, 3.6168113e-01, 3.6184445e-01, 3.6200783e-01,
   3.6217117e-01, 3.6233455e-01, 3.6249793e-01, 3.6266130e-01,
   3.6282471e-01, 3.6298811e-01, 3.6315152e-01, 3.6331496e-01,
   3.6347839e-01, 3.6364183e-01, 3.6380529e-01, 3.6396876e-01,
   3.6413223e-01, 3.6429569e-01, 3.6445919e-01, 3.6462271e-01,
   3.6478621e-01, 3.6494973e-01, 3.6511326e-01, 3.6527681e-01,
   3.6544037e-01, 3.6560392e-01, 3.6576751e-01, 3.6593106e-01,
   3.6609468e-01, 3.6625826e-01, 3.6642188e-01, 3.6658549e-01,
   3.6674914e-01, 3.6691278e-01, 3.6707643e-01, 3.6724007e-01,
   3.6740375e-01, 3.6756742e-01, 3.6773112e-01, 3.6789483e-01,
   3.6805853e-01, 3.6822224e-01, 3.6838597e-01, 3.6854970e-01,
   3.6871347e-01, 3.6887723e-01, 3.6904100e-01, 3.6920476e-01,
   3.6936855e-01, 3.6953235e-01, 3.6969617e-01, 3.6985999e-01,
   3.7002382e-01, 3.7018764e-01, 3.7035149e-01, 3.7051535e-01,
   3.7067923e-01, 3.7084311e-01, 3.7100700e-01, 3.7117088e-01,
   3.7133479e-01, 3.7149870e-01, 3.7166265e-01, 3.7182659e-01,
   3.7199053e-01, 3.7215447e-01, 3.7231845e-01, 3.7248242e-01,
   3.7264642e-01, 3.7281042e-01, 3.7297443e-01, 3.7313843e-01,
   3.7330246e-01, 3.7346649e-01, 3.7363055e-01, 3.7379462e-01,
   3.7395868e-01, 3.7412277e-01, 3.7428683e-01, 3.7445095e-01,
   3.7461504e-01, 3.7477916e-01, 3.7494329e-01, 3.7510744e-01,
   3.7527159e-01, 3.7543574e-01, 3.7559992e-01, 3.7576410e-01,
   3.7592828e-01, 3.7609249e-01, 3.7625667e-01, 3.7642092e-01,
   3.7658513e-01, 3.7674937e-01, 3.7691364e-01, 3.7707788e-01,
   3.7724215e-01, 3.7740645e-01, 3.7757072e-01, 3.7773502e-01,
   3.7789935e-01, 3.7806365e-01, 3.7822798e-01, 3.7839234e-01,
   3.7855670e-01, 3.7872106e-01, 3.7888542e-01, 3.7904981e-01,
   3.7921420e-01, 3.7937859e-01, 3.7954301e-01, 3.7970743e-01,
   3.7987188e-01, 3.8003632e-01, 3.8020077e-01, 3.8036522e-01,
   3.8052970e-01, 3.8069418e-01, 3.8085869e-01, 3.8102320e-01,
   3.8118771e-01, 3.8135225e-01, 3.8151678e-01, 3.8168132e-01,
   3.8184589e-01, 3.8201046e-01, 3.8217503e-01, 3.8233963e-01,
   3.8250422e-01, 3.8266882e-01, 3.8283345e-01, 3.8299808e-01,
   3.8316271e-01, 3.8332736e-01, 3.8349202e-01, 3.8365671e-01,
   3.8382137e-01, 3.8398609e-01, 3.8415077e-01, 3.8431549e-01,
   3.8448021e-01, 3.8464496e-01, 3.8480970e-01, 3.8497445e-01,
   3.8513920e-01, 3.8530397e-01, 3.8546878e-01, 3.8563356e-01,
   3.8579836e-01, 3.8596320e-01, 3.8612801e-01, 3.8629287e-01,
   3.8645771e-01, 3.8662258e-01, 3.8678744e-01, 3.8695231e-01,
   3.8711721e-01, 3.8728210e-01, 3.8744703e-01, 3.8761196e-01,
   3.8777688e-01, 3.8794184e-01, 3.8810679e-01, 3.8827175e-01,
   3.8843673e-01, 3.8860172e-01, 3.8876671e-01, 3.8893172e-01,
   3.8909674e-01, 3.8926175e-01, 3.8942680e-01, 3.8959184e-01,
   3.8975692e-01, 3.8992199e-01, 3.9008707e-01, 3.9025214e-01,
   3.9041725e-01, 3.9058238e-01, 3.9074749e-01, 3.9091262e-01,
   3.9107779e-01, 3.9124292e-01, 3.9140809e-01, 3.9157328e-01,
   3.9173847e-01, 3.9190367e-01, 3.9206886e-01, 3.9223409e-01,
   3.9239931e-01, 3.9256456e-01, 3.9272982e-01, 3.9289507e-01,
   3.9306036e-01, 3.9322564e-01, 3.9339092e-01, 3.9355624e-01,
   3.9372155e-01, 3.9388689e-01, 3.9405224e-01, 3.9421758e-01,
   3.9438292e-01, 3.9454830e-01, 3.9471370e-01, 3.9487907e-01,
   3.9504448e-01, 3.9520991e-01, 3.9537531e-01, 3.9554074e-01,
   3.9570621e-01, 3.9587167e-01, 3.9603713e-01, 3.9620259e-01,
   3.9636809e-01, 3.9653361e-01, 3.9669910e-01, 3.9686462e-01,
   3.9703017e-01, 3.9719570e-01, 3.9736128e-01, 3.9752683e-01,
   3.9769241e-01, 3.9785799e-01, 3.9802361e-01, 3.9818922e-01,
   3.9835483e-01, 3.9852047e-01, 3.9868611e-01, 3.9885175e-01,
   3.9901742e-01, 3.9918309e-01, 3.9934877e-01, 3.9951447e-01,
   3.9968017e-01, 3.9984590e-01, 4.0001163e-01, 4.0017736e-01,
   4.0034312e-01, 4.0050888e-01, 4.0067467e-01, 4.0084043e-01,
   4.0100625e-01, 4.0117204e-01, 4.0133786e-01, 4.0150368e-01,
   4.0166953e-01, 4.0183538e-01, 4.0200126e-01, 4.0216711e-01,
   4.0233302e-01, 4.0249890e-01, 4.0266481e-01, 4.0283072e-01,
   4.0299666e-01, 4.0316260e-01, 4.0332854e-01, 4.0349451e-01,
   4.0366048e-01, 4.0382648e-01, 4.0399247e-01, 4.0415847e-01,
   4.0432447e-01, 4.0449050e-01, 4.0465656e-01, 4.0482262e-01,
   4.0498868e-01, 4.0515473e-01, 4.0532082e-01, 4.0548691e-01,
   4.0565303e-01, 4.0581915e-01, 4.0598527e-01, 4.0615141e-01,
   4.0631756e-01, 4.0648374e-01, 4.0664992e-01, 4.0681610e-01,
   4.0698227e-01, 4.0714851e-01, 4.0731472e-01, 4.0748096e-01,
   4.0764719e-01, 4.0781343e-01, 4.0797970e-01, 4.0814599e-01,
   4.0831226e-01, 4.0847856e-01, 4.0864488e-01, 4.0881118e-01,
   4.0897754e-01, 4.0914387e-01, 4.0931022e-01, 4.0947658e-01,
   4.0964296e-01, 4.0980935e-01, 4.0997577e-01, 4.1014215e-01,
   4.1030860e-01, 4.1047502e-01, 4.1064146e-01, 4.1080794e-01,
   4.1097438e-01, 4.1114089e-01, 4.1130736e-01, 4.1147387e-01,
   4.1164038e-01, 4.1180691e-01, 4.1197345e-01, 4.1213998e-01,
   4.1230655e-01, 4.1247311e-01, 4.1263971e-01, 4.1280630e-01,
   4.1297290e-01, 4.1313952e-01, 4.1330615e-01, 4.1347280e-01,
   4.1363943e-01, 4.1380611e-01, 4.1397277e-01, 4.1413945e-01,
   4.1430616e-01, 4.1447288e-01, 4.1463959e-01, 4.1480631e-01,
   4.1497305e-01, 4.1513982e-01, 4.1530660e-01, 4.1547337e-01,
   4.1564015e-01, 4.1580695e-01, 4.1597375e-01, 4.1614059e-01,
   4.1630742e-01, 4.1647428e-01, 4.1664115e-01, 4.1680801e-01,
   4.1697487e-01, 4.1714177e-01, 4.1730869e-01, 4.1747561e-01,
   4.1764253e-01, 4.1780946e-01, 4.1797641e-01, 4.1814339e-01,
   4.1831037e-01, 4.1847736e-01, 4.1864434e-01, 4.1881135e-01,
   4.1897836e-01, 4.1914541e-01, 4.1931245e-01, 4.1947952e-01,
   4.1964659e-01, 4.1981366e-01, 4.1998076e-01, 4.2014787e-01,
   4.2031497e-01, 4.2048210e-01, 4.2064923e-01, 4.2081639e-01,
   4.2098355e-01, 4.2115071e-01, 4.2131791e-01, 4.2148513e-01,
   4.2165232e-01, 4.2181954e-01, 4.2198679e-01, 4.2215401e-01,
   4.2232129e-01, 4.2248854e-01, 4.2265582e-01, 4.2282313e-01,
   4.2299041e-01, 4.2315775e-01, 4.2332506e-01, 4.2349240e-01,
   4.2365977e-01, 4.2382711e-01, 4.2399451e-01, 4.2416188e-01,
   4.2432928e-01, 4.2449671e-01, 4.2466411e-01, 4.2483154e-01,
   4.2499900e-01, 4.2516646e-01, 4.2533392e-01, 4.2550141e-01,
   4.2566890e-01, 4.2583641e-01, 4.2600393e-01, 4.2617145e-01,
   4.2633900e-01, 4.2650655e-01, 4.2667413e-01, 4.2684171e-01,
   4.2700928e-01, 4.2717689e-01, 4.2734450e-01, 4.2751214e-01,
   4.2767978e-01, 4.2784742e-01, 4.2801508e-01, 4.2818275e-01,
   4.2835045e-01, 4.2851815e-01, 4.2868584e-01, 4.2885357e-01,
   4.2902130e-01, 4.2918906e-01, 4.2935681e-01, 4.2952460e-01,
   4.2969236e-01, 4.2986017e-01, 4.3002796e-01, 4.3019578e-01,
   4.3036363e-01, 4.3053147e-01, 4.3069932e-01, 4.3086720e-01,
   4.3103507e-01, 4.3120295e-01, 4.3137085e-01, 4.3153879e-01,
   4.3170670e-01, 4.3187466e-01, 4.3204260e-01, 4.3221056e-01,
   4.3237853e-01, 4.3254653e-01, 4.3271452e-01, 4.3288255e-01,
   4.3305057e-01, 4.3321860e-01, 4.3338665e-01, 4.3355474e-01,
   4.3372279e-01, 4.3389088e-01, 4.3405899e-01, 4.3422711e-01,
   4.3439522e-01, 4.3456337e-01, 4.3473151e-01, 4.3489966e-01,
   4.3506783e-01, 4.3523604e-01, 4.3540421e-01, 4.3557245e-01,
   4.3574065e-01, 4.3590888e-01, 4.3607715e-01, 4.3624541e-01,
   4.3641368e-01, 4.3658197e-01, 4.3675026e-01, 4.3691856e-01,
   4.3708688e-01, 4.3725520e-01, 4.3742356e-01, 4.3759191e-01,
   4.3776029e-01, 4.3792868e-01, 4.3809706e-01, 4.3826547e-01,
   4.3843389e-01, 4.3860233e-01, 4.3877077e-01, 4.3893924e-01,
   4.3910772e-01, 4.3927619e-01, 4.3944469e-01, 4.3961319e-01,
   4.3978170e-01, 4.3995023e-01, 4.4011879e-01, 4.4028735e-01,
   4.4045591e-01, 4.4062451e-01, 4.4079310e-01, 4.4096169e-01,
   4.4113031e-01, 4.4129896e-01, 4.4146761e-01, 4.4163626e-01,
   4.4180492e-01, 4.4197360e-01, 4.4214231e-01, 4.4231102e-01,
   4.4247973e-01, 4.4264847e-01, 4.4281721e-01, 4.4298598e-01,
   4.4315475e-01, 4.4332352e-01, 4.4349232e-01, 4.4366112e-01,
   4.4382995e-01, 4.4399878e-01, 4.4416764e-01, 4.4433650e-01,
   4.4450536e-01, 4.4467425e-01, 4.4484314e-01, 4.4501206e-01,
   4.4518098e-01, 4.4534993e-01, 4.4551888e-01, 4.4568783e-01,
   4.4585681e-01, 4.4602579e-01, 4.4619480e-01, 4.4636381e-01,
   4.4653282e-01, 4.4670185e-01, 4.4687092e-01, 4.4703999e-01,
   4.4720906e-01, 4.4737816e-01, 4.4754726e-01, 4.4771636e-01,
   4.4788548e-01, 4.4805464e-01, 4.4822377e-01, 4.4839296e-01,
   4.4856212e-01, 4.4873130e-01, 4.4890052e-01, 4.4906974e-01,
   4.4923896e-01, 4.4940820e-01, 4.4957748e-01, 4.4974673e-01,
   4.4991601e-01, 4.5008531e-01, 4.5025462e-01, 4.5042393e-01,
   4.5059326e-01, 4.5076263e-01, 4.5093197e-01, 4.5110136e-01,
   4.5127073e-01, 4.5144013e-01, 4.5160955e-01, 4.5177898e-01,
   4.5194840e-01, 4.5211786e-01, 4.5228732e-01, 4.5245680e-01,
   4.5262629e-01, 4.5279577e-01, 4.5296529e-01, 4.5313483e-01,
   4.5330435e-01, 4.5347393e-01, 4.5364347e-01, 4.5381308e-01,
   4.5398265e-01, 4.5415226e-01, 4.5432189e-01, 4.5449153e-01,
   4.5466116e-01, 4.5483083e-01, 4.5500049e-01, 4.5517018e-01,
   4.5533988e-01, 4.5550957e-01, 4.5567930e-01, 4.5584905e-01,
   4.5601878e-01, 4.5618856e-01, 4.5635834e-01, 4.5652813e-01,
   4.5669791e-01, 4.5686772e-01, 4.5703757e-01, 4.5720741e-01,
   4.5737725e-01, 4.5754713e-01, 4.5771700e-01, 4.5788690e-01,
   4.5805681e-01, 4.5822674e-01, 4.5839667e-01, 4.5856661e-01,
   4.5873657e-01, 4.5890656e-01, 4.5907655e-01, 4.5924655e-01,
   4.5941657e-01, 4.5958659e-01, 4.5975661e-01, 4.5992669e-01,
   4.6009675e-01, 4.6026683e-01, 4.6043691e-01, 4.6060702e-01,
   4.6077716e-01, 4.6094728e-01, 4.6111742e-01, 4.6128759e-01,
   4.6145776e-01, 4.6162796e-01, 4.6179816e-01, 4.6196836e-01,
   4.6213859e-01, 4.6230882e-01, 4.6247908e-01, 4.6264935e-01,
   4.6281964e-01, 4.6298993e-01, 4.6316025e-01, 4.6333057e-01,
   4.6350089e-01, 4.6367124e-01, 4.6384162e-01, 4.6401197e-01,
   4.6418238e-01, 4.6435279e-01, 4.6452320e-01, 4.6469361e-01,
   4.6486405e-01, 4.6503451e-01, 4.6520498e-01, 4.6537545e-01,
   4.6554595e-01, 4.6571648e-01, 4.6588701e-01, 4.6605754e-01,
   4.6622810e-01, 4.6639866e-01, 4.6656922e-01, 4.6673983e-01,
   4.6691042e-01, 4.6708104e-01, 4.6725169e-01, 4.6742234e-01,
   4.6759298e-01, 4.6776366e-01, 4.6793434e-01, 4.6810505e-01,
   4.6827576e-01, 4.6844649e-01, 4.6861723e-01, 4.6878797e-01,
   4.6895874e-01, 4.6912953e-01, 4.6930033e-01, 4.6947113e-01,
   4.6964195e-01, 4.6981281e-01, 4.6998364e-01, 4.7015452e-01,
   4.7032538e-01, 4.7049630e-01, 4.7066718e-01, 4.7083810e-01,
   4.7100905e-01, 4.7117999e-01, 4.7135094e-01, 4.7152191e-01,
   4.7169292e-01, 4.7186393e-01, 4.7203493e-01, 4.7220597e-01,
   4.7237700e-01, 4.7254807e-01, 4.7271913e-01, 4.7289023e-01,
   4.7306132e-01, 4.7323242e-01, 4.7340354e-01, 4.7357470e-01,
   4.7374585e-01, 4.7391701e-01, 4.7408819e-01, 4.7425941e-01,
   4.7443059e-01, 4.7460184e-01, 4.7477308e-01, 4.7494432e-01,
   4.7511560e-01, 4.7528687e-01, 4.7545815e-01, 4.7562948e-01,
   4.7580078e-01, 4.7597212e-01, 4.7614348e-01, 4.7631484e-01,
   4.7648621e-01, 4.7665760e-01, 4.7682902e-01, 4.7700042e-01,
   4.7717187e-01, 4.7734332e-01, 4.7751477e-01, 4.7768626e-01,
   4.7785774e-01, 4.7802925e-01, 4.7820076e-01, 4.7837228e-01,
   4.7854382e-01, 4.7871539e-01, 4.7888696e-01, 4.7905856e-01,
   4.7923017e-01, 4.7940177e-01, 4.7957340e-01, 4.7974506e-01,
   4.7991669e-01, 4.8008838e-01, 4.8026007e-01, 4.8043177e-01,
   4.8060349e-01, 4.8077521e-01, 4.8094696e-01, 4.8111871e-01,
   4.8129049e-01, 4.8146227e-01, 4.8163408e-01, 4.8180589e-01,
   4.8197770e-01, 4.8214954e-01, 4.8232141e-01, 4.8249328e-01,
   4.8266518e-01, 4.8283708e-01, 4.8300898e-01, 4.8318091e-01,
   4.8335287e-01, 4.8352480e-01, 4.8369679e-01, 4.8386878e-01,
   4.8404077e-01, 4.8421279e-01, 4.8438480e-01, 4.8455685e-01,
   4.8472890e-01, 4.8490098e-01, 4.8507306e-01, 4.8524517e-01,
   4.8541728e-01, 4.8558941e-01, 4.8576155e-01, 4.8593372e-01,
   4.8610589e-01, 4.8627809e-01, 4.8645028e-01, 4.8662248e-01,
   4.8679471e-01, 4.8696697e-01, 4.8713923e-01, 4.8731151e-01,
   4.8748380e-01, 4.8765609e-01, 4.8782840e-01, 4.8800075e-01,
   4.8817310e-01, 4.8834544e-01, 4.8851782e-01, 4.8869020e-01,
   4.8886260e-01, 4.8903504e-01, 4.8920748e-01, 4.8937991e-01,
   4.8955238e-01, 4.8972484e-01, 4.8989734e-01, 4.9006984e-01,
   4.9024236e-01, 4.9041489e-01, 4.9058744e-01, 4.9076003e-01,
   4.9093258e-01, 4.9110520e-01, 4.9127778e-01, 4.9145043e-01,
   4.9162304e-01, 4.9179572e-01, 4.9196836e-01, 4.9214107e-01,
   4.9231374e-01, 4.9248648e-01, 4.9265918e-01, 4.9283192e-01,
   4.9300468e-01, 4.9317744e-01, 4.9335024e-01, 4.9352303e-01,
   4.9369586e-01, 4.9386868e-01, 4.9404153e-01, 4.9421439e-01,
   4.9438724e-01, 4.9456015e-01, 4.9473304e-01, 4.9490595e-01,
   4.9507889e-01, 4.9525183e-01, 4.9542481e-01, 4.9559778e-01,
   4.9577075e-01, 4.9594378e-01, 4.9611679e-01, 4.9628982e-01,
   4.9646288e-01, 4.9663594e-01, 4.9680904e-01, 4.9698213e-01,
   4.9715522e-01, 4.9732834e-01, 4.9750149e-01, 4.9767464e-01,
   4.9784783e-01, 4.9802101e-01, 4.9819419e-01, 4.9836743e-01,
   4.9854064e-01, 4.9871388e-01, 4.9888715e-01, 4.9906042e-01,
   4.9923372e-01, 4.9940702e-01, 4.9958032e-01, 4.9975368e-01,
   4.9992701e-01, 5.0010037e-01, 5.0027376e-01, 5.0044715e-01,
   5.0062054e-01, 5.0079399e-01, 5.0096744e-01, 5.0114089e-01,
   5.0131434e-01, 5.0148785e-01, 5.0166136e-01, 5.0183487e-01,
   5.0200838e-01, 5.0218195e-01, 5.0235552e-01, 5.0252908e-01,
   5.0270265e-01, 5.0287628e-01, 5.0304991e-01, 5.0322354e-01,
   5.0339717e-01, 5.0357085e-01, 5.0374454e-01, 5.0391823e-01,
   5.0409192e-01, 5.0426567e-01, 5.0443941e-01, 5.0461316e-01,
   5.0478691e-01, 5.0496072e-01, 5.0513452e-01, 5.0530833e-01,
   5.0548220e-01, 5.0565600e-01, 5.0582987e-01, 5.0600374e-01,
   5.0617766e-01, 5.0635159e-01, 5.0652552e-01, 5.0669944e-01,
   5.0687337e-01, 5.0704736e-01, 5.0722134e-01, 5.0739533e-01,
   5.0756937e-01, 5.0774342e-01, 5.0791746e-01, 5.0809151e-01,
   5.0826561e-01, 5.0843972e-01, 5.0861382e-01, 5.0878793e-01,
   5.0896209e-01, 5.0913620e-01, 5.0931042e-01, 5.0948459e-01,
   5.0965881e-01, 5.0983304e-01, 5.1000726e-01, 5.1018149e-01,
   5.1035577e-01, 5.1053005e-01, 5.1070434e-01, 5.1087862e-01,
   5.1105297e-01, 5.1122731e-01, 5.1140165e-01, 5.1157606e-01,
   5.1175046e-01, 5.1192486e-01, 5.1209927e-01, 5.1227367e-01,
   5.1244813e-01, 5.1262259e-01, 5.1279712e-01, 5.1297158e-01,
   5.1314610e-01, 5.1332062e-01, 5.1349521e-01, 5.1366973e-01,
   5.1384431e-01, 5.1401889e-01, 5.1419353e-01, 5.1436812e-01,
   5.1454276e-01, 5.1471746e-01, 5.1489210e-01, 5.1506680e-01,
   5.1524150e-01, 5.1541620e-01, 5.1559097e-01, 5.1576567e-01,
   5.1594043e-01, 5.1611525e-01, 5.1629001e-01, 5.1646483e-01,
   5.1663965e-01, 5.1681453e-01, 5.1698935e-01, 5.1716423e-01,
   5.1733917e-01, 5.1751405e-01, 5.1768899e-01, 5.1786393e-01,
   5.1803887e-01, 5.1821381e-01, 5.1838881e-01, 5.1856381e-01,
   5.1873887e-01, 5.1891387e-01, 5.1908892e-01, 5.1926398e-01,
   5.1943904e-01, 5.1961416e-01, 5.1978928e-01, 5.1996440e-01,
   5.2013958e-01, 5.2031469e-01, 5.2048987e-01, 5.2066511e-01,
   5.2084029e-01, 5.2101552e-01, 5.2119076e-01, 5.2136600e-01,
   5.2154130e-01, 5.2171659e-01, 5.2189189e-01, 5.2206719e-01,
   5.2224255e-01, 5.2241790e-01, 5.2259326e-01, 5.2276868e-01,
   5.2294403e-01, 5.2311945e-01, 5.2329493e-01, 5.2347034e-01,
   5.2364582e-01, 5.2382129e-01, 5.2399683e-01, 5.2417231e-01,
   5.2434784e-01, 5.2452338e-01, 5.2469897e-01, 5.2487451e-01,
   5.2505010e-01, 5.2522576e-01, 5.2540135e-01, 5.2557701e-01,
   5.2575266e-01, 5.2592838e-01, 5.2610403e-01, 5.2627975e-01,
   5.2645546e-01, 5.2663124e-01, 5.2680695e-01, 5.2698272e-01,
   5.2715856e-01, 5.2733433e-01, 5.2751017e-01, 5.2768600e-01,
   5.2786183e-01, 5.2803773e-01, 5.2821362e-01, 5.2838951e-01,
   5.2856547e-01, 5.2874136e-01, 5.2891731e-01, 5.2909333e-01,
   5.2926928e-01, 5.2944529e-01, 5.2962130e-01, 5.2979738e-01,
   5.2997339e-01, 5.3014946e-01, 5.3032553e-01, 5.3050166e-01,
   5.3067780e-01, 5.3085393e-01, 5.3103006e-01, 5.3120625e-01,
   5.3138238e-01, 5.3155863e-01, 5.3173482e-01, 5.3191108e-01,
   5.3208733e-01, 5.3226358e-01, 5.3243983e-01, 5.3261614e-01,
   5.3279245e-01, 5.3296882e-01, 5.3314513e-01, 5.3332150e-01,
   5.3349787e-01, 5.3367430e-01, 5.3385073e-01, 5.3402716e-01,
   5.3420359e-01, 5.3438008e-01, 5.3455651e-01, 5.3473306e-01,
   5.3490955e-01, 5.3508610e-01, 5.3526264e-01, 5.3543919e-01,
   5.3561580e-01, 5.3579235e-01, 5.3596902e-01, 5.3614563e-01,
   5.3632230e-01, 5.3649896e-01, 5.3667563e-01, 5.3685230e-01,
   5.3702903e-01, 5.3720576e-01, 5.3738254e-01, 5.3755927e-01,
   5.3773606e-01, 5.3791285e-01, 5.3808969e-01, 5.3826654e-01,
   5.3844339e-01, 5.3862023e-01, 5.3879714e-01, 5.3897399e-01,
   5.3915095e-01, 5.3932786e-01, 5.3950483e-01, 5.3968179e-01,
   5.3985876e-01, 5.4003578e-01, 5.4021281e-01, 5.4038984e-01,
   5.4056686e-01, 5.4074395e-01, 5.4092103e-01, 5.4109812e-01,
   5.4127526e-01, 5.4145241e-01, 5.4162955e-01, 5.4180670e-01,
   5.4198390e-01, 5.4216111e-01, 5.4233831e-01, 5.4251558e-01,
   5.4269284e-01, 5.4287010e-01, 5.4304737e-01, 5.4322469e-01,
   5.4340202e-01, 5.4357940e-01, 5.4375672e-01, 5.4393411e-01,
   5.4411149e-01, 5.4428893e-01, 5.4446632e-01, 5.4464376e-01,
   5.4482126e-01, 5.4499871e-01, 5.4517621e-01, 5.4535371e-01,
   5.4553127e-01, 5.4570884e-01, 5.4588640e-01, 5.4606396e-01,
   5.4624158e-01, 5.4641914e-01, 5.4659683e-01, 5.4677445e-01,
   5.4695213e-01, 5.4712981e-01, 5.4730749e-01, 5.4748523e-01,
   5.4766297e-01, 5.4784071e-01, 5.4801852e-01, 5.4819632e-01,
   5.4837412e-01, 5.4855192e-01, 5.4872978e-01, 5.4890764e-01,
   5.4908550e-01, 5.4926342e-01, 5.4944128e-01, 5.4961920e-01,
   5.4979718e-01, 5.4997516e-01, 5.5015314e-01, 5.5033112e-01,
   5.5050915e-01, 5.5068713e-01, 5.5086523e-01, 5.5104327e-01,
   5.5122137e-01, 5.5139947e-01, 5.5157757e-01, 5.5175573e-01,
   5.5193388e-01, 5.5211204e-01, 5.5229026e-01, 5.5246848e-01,
   5.5264670e-01, 5.5282491e-01, 5.5300319e-01, 5.5318147e-01,
   5.5335975e-01, 5.5353808e-01, 5.5371642e-01, 5.5389476e-01,
   5.5407310e-01, 5.5425149e-01, 5.5442989e-01, 5.5460835e-01,
   5.5478674e-01, 5.5496520e-01, 5.5514365e-01, 5.5532217e-01,
   5.5550069e-01, 5.5567920e-01, 5.5585772e-01, 5.5603629e-01,
   5.5621487e-01, 5.5639350e-01, 5.5657208e-01, 5.5675071e-01,
   5.5692935e-01, 5.5710804e-01, 5.5728674e-01, 5.5746543e-01,
   5.5764413e-01, 5.5782288e-01, 5.5800164e-01, 5.5818039e-01,
   5.5835921e-01, 5.5853802e-01, 5.5871683e-01, 5.5889571e-01,
   5.5907458e-01, 5.5925345e-01, 5.5943233e-01, 5.5961126e-01,
   5.5979019e-01, 5.5996913e-01, 5.6014812e-01, 5.6032711e-01,
   5.6050611e-01, 5.6068510e-01, 5.6086415e-01, 5.6104320e-01,
   5.6122231e-01, 5.6140143e-01, 5.6158054e-01, 5.6175965e-01,
   5.6193882e-01, 5.6211799e-01, 5.6229717e-01, 5.6247634e-01,
   5.6265557e-01, 5.6283480e-01, 5.6301409e-01, 5.6319338e-01,
   5.6337267e-01, 5.6355196e-01, 5.6373131e-01, 5.6391066e-01,
   5.6409001e-01, 5.6426942e-01, 5.6444883e-01, 5.6462824e-01,
   5.6480765e-01, 5.6498712e-01, 5.6516659e-01, 5.6534612e-01,
   5.6552559e-01, 5.6570512e-01, 5.6588471e-01, 5.6606424e-01,
   5.6624383e-01, 5.6642348e-01, 5.6660306e-01, 5.6678271e-01,
   5.6696236e-01, 5.6714207e-01, 5.6732172e-01, 5.6750149e-01,
   5.6768119e-01, 5.6786096e-01, 5.6804073e-01, 5.6822050e-01,
   5.6840032e-01, 5.6858015e-01, 5.6875998e-01, 5.6893981e-01,
   5.6911969e-01, 5.6929958e-01, 5.6947953e-01, 5.6965947e-01,
   5.6983942e-01, 5.7001936e-01, 5.7019937e-01, 5.7037938e-01,
   5.7055938e-01, 5.7073945e-01, 5.7091951e-01, 5.7109958e-01,
   5.7127970e-01, 5.7145983e-01, 5.7163996e-01, 5.7182014e-01,
   5.7200027e-01, 5.7218051e-01, 5.7236069e-01, 5.7254094e-01,
   5.7272118e-01, 5.7290143e-01, 5.7308173e-01, 5.7326204e-01,
   5.7344234e-01, 5.7362270e-01, 5.7380307e-01, 5.7398343e-01,
   5.7416385e-01, 5.7434428e-01, 5.7452470e-01, 5.7470512e-01,
   5.7488561e-01, 5.7506609e-01, 5.7524663e-01, 5.7542717e-01,
   5.7560772e-01, 5.7578826e-01, 5.7596886e-01, 5.7614946e-01,
   5.7633007e-01, 5.7651073e-01, 5.7669139e-01, 5.7687205e-01,
   5.7705277e-01, 5.7723349e-01, 5.7741421e-01, 5.7759500e-01,
   5.7777578e-01, 5.7795656e-01, 5.7813734e-01, 5.7831818e-01,
   5.7849902e-01, 5.7867992e-01, 5.7886082e-01, 5.7904172e-01,
   5.7922262e-01, 5.7940358e-01, 5.7958454e-01, 5.7976550e-01,
   5.7994652e-01, 5.8012754e-01, 5.8030856e-01, 5.8048964e-01,
   5.8067071e-01, 5.8085179e-01, 5.8103293e-01, 5.8121407e-01,
   5.8139521e-01, 5.8157641e-01, 5.8175761e-01, 5.8193880e-01,
   5.8212000e-01, 5.8230126e-01, 5.8248252e-01, 5.8266383e-01,
   5.8284515e-01, 5.8302647e-01, 5.8320779e-01, 5.8338916e-01,
   5.8357054e-01, 5.8375198e-01, 5.8393335e-01, 5.8411479e-01,
   5.8429629e-01, 5.8447778e-01, 5.8465928e-01, 5.8484077e-01,
   5.8502233e-01, 5.8520389e-01, 5.8538544e-01, 5.8556706e-01,
   5.8574867e-01, 5.8593029e-01, 5.8611196e-01, 5.8629364e-01,
   5.8647531e-01, 5.8665699e-01, 5.8683872e-01, 5.8702052e-01,
   5.8720225e-01, 5.8738405e-01, 5.8756584e-01, 5.8774769e-01,
   5.8792955e-01, 5.8811140e-01, 5.8829331e-01, 5.8847517e-01,
   5.8865714e-01, 5.8883905e-01, 5.8902103e-01, 5.8920300e-01,
   5.8938503e-01, 5.8956701e-01, 5.8974910e-01, 5.8993113e-01,
   5.9011322e-01, 5.9029531e-01, 5.9047747e-01, 5.9065956e-01,
   5.9084171e-01, 5.9102392e-01, 5.9120613e-01, 5.9138834e-01,
   5.9157056e-01, 5.9175283e-01, 5.9193510e-01, 5.9211743e-01,
   5.9229970e-01, 5.9248203e-01, 5.9266442e-01, 5.9284681e-01,
   5.9302920e-01, 5.9321159e-01, 5.9339404e-01, 5.9357649e-01,
   5.9375894e-01, 5.9394145e-01, 5.9412396e-01, 5.9430653e-01,
   5.9448904e-01, 5.9467161e-01, 5.9485424e-01, 5.9503686e-01,
   5.9521949e-01, 5.9540212e-01, 5.9558481e-01, 5.9576750e-01,
   5.9595019e-01, 5.9613293e-01, 5.9631568e-01, 5.9649843e-01,
   5.9668124e-01, 5.9686404e-01, 5.9704691e-01, 5.9722972e-01,
   5.9741259e-01, 5.9759551e-01, 5.9777844e-01, 5.9796137e-01,
   5.9814429e-01, 5.9832728e-01, 5.9851027e-01, 5.9869325e-01,
   5.9887630e-01, 5.9905934e-01, 5.9924245e-01, 5.9942549e-01,
   5.9960866e-01, 5.9979177e-01, 5.9997493e-01, 6.0015810e-01,
   6.0034126e-01, 6.0052449e-01, 6.0070771e-01, 6.0089099e-01,
   6.0107428e-01, 6.0125756e-01, 6.0144085e-01, 6.0162419e-01,
   6.0180753e-01, 6.0199094e-01, 6.0217434e-01, 6.0235775e-01,
   6.0254115e-01, 6.0272461e-01, 6.0290807e-01, 6.0309160e-01,
   6.0327512e-01, 6.0345864e-01, 6.0364223e-01, 6.0382581e-01,
   6.0400939e-01, 6.0419297e-01, 6.0437661e-01, 6.0456032e-01,
   6.0474396e-01, 6.0492766e-01, 6.0511142e-01, 6.0529512e-01,
   6.0547888e-01, 6.0566270e-01, 6.0584646e-01, 6.0603029e-01,
   6.0621417e-01, 6.0639799e-01, 6.0658187e-01, 6.0676581e-01,
   6.0694975e-01, 6.0713369e-01, 6.0731763e-01, 6.0750163e-01,
   6.0768563e-01, 6.0786963e-01, 6.0805368e-01, 6.0823774e-01,
   6.0842186e-01, 6.0860598e-01, 6.0879010e-01, 6.0897428e-01,
   6.0915840e-01, 6.0934263e-01, 6.0952681e-01, 6.0971105e-01,
   6.0989529e-01, 6.1007959e-01, 6.1026388e-01, 6.1044818e-01,
   6.1063254e-01, 6.1081690e-01, 6.1100125e-01, 6.1118567e-01,
   6.1137009e-01, 6.1155456e-01, 6.1173898e-01, 6.1192352e-01,
   6.1210799e-01, 6.1229253e-01, 6.1247706e-01, 6.1266160e-01,
   6.1284620e-01, 6.1303085e-01, 6.1321545e-01, 6.1340010e-01,
   6.1358476e-01, 6.1376947e-01, 6.1395419e-01, 6.1413890e-01,
   6.1432368e-01, 6.1450845e-01, 6.1469322e-01, 6.1487806e-01,
   6.1506289e-01, 6.1524773e-01, 6.1543262e-01, 6.1561751e-01,
   6.1580247e-01, 6.1598742e-01, 6.1617237e-01, 6.1635733e-01,
   6.1654234e-01, 6.1672741e-01, 6.1691242e-01, 6.1709750e-01,
   6.1728263e-01, 6.1746770e-01, 6.1765283e-01, 6.1783803e-01,
   6.1802316e-01, 6.1820835e-01, 6.1839360e-01, 6.1857885e-01,
   6.1876410e-01, 6.1894935e-01, 6.1913466e-01, 6.1931998e-01,
   6.1950535e-01, 6.1969072e-01, 6.1987609e-01, 6.2006152e-01,
   6.2024695e-01, 6.2043238e-01, 6.2061787e-01, 6.2080336e-01,
   6.2098891e-01, 6.2117440e-01, 6.2136000e-01, 6.2154555e-01,
   6.2173116e-01, 6.2191677e-01, 6.2210244e-01, 6.2228811e-01,
   6.2247378e-01, 6.2265950e-01, 6.2284523e-01, 6.2303096e-01,
   6.2321675e-01, 6.2340254e-01, 6.2358838e-01, 6.2377423e-01,
   6.2396008e-01, 6.2414593e-01, 6.2433183e-01, 6.2451780e-01,
   6.2470371e-01, 6.2488967e-01, 6.2507570e-01, 6.2526166e-01,
   6.2544775e-01, 6.2563378e-01, 6.2581986e-01, 6.2600595e-01,
   6.2619209e-01, 6.2637824e-01, 6.2656438e-01, 6.2675059e-01,
   6.2693679e-01, 6.2712300e-01, 6.2730926e-01, 6.2749553e-01,
   6.2768179e-01, 6.2786812e-01, 6.2805444e-01, 6.2824082e-01,
   6.2842721e-01, 6.2861359e-01, 6.2880003e-01, 6.2898648e-01,
   6.2917292e-01, 6.2935942e-01, 6.2954593e-01, 6.2973249e-01,
   6.2991905e-01, 6.3010561e-01, 6.3029224e-01, 6.3047886e-01,
   6.3066548e-01, 6.3085216e-01, 6.3103884e-01, 6.3122553e-01,
   6.3141227e-01, 6.3159901e-01, 6.3178581e-01, 6.3197261e-01,
   6.3215941e-01, 6.3234627e-01, 6.3253313e-01, 6.3271999e-01,
   6.3290691e-01, 6.3309383e-01, 6.3328081e-01, 6.3346779e-01,
   6.3365477e-01, 6.3384175e-01, 6.3402879e-01, 6.3421589e-01,
   6.3440299e-01, 6.3459009e-01, 6.3477719e-01, 6.3496435e-01,
   6.3515151e-01, 6.3533872e-01, 6.3552594e-01, 6.3571316e-01,
   6.3590044e-01, 6.3608772e-01, 6.3627505e-01, 6.3646239e-01,
   6.3664973e-01, 6.3683712e-01, 6.3702452e-01, 6.3721192e-01,
   6.3739938e-01, 6.3758683e-01, 6.3777429e-01, 6.3796180e-01,
   6.3814932e-01, 6.3833690e-01, 6.3852447e-01, 6.3871205e-01,
   6.3889968e-01, 6.3908732e-01, 6.3927501e-01, 6.3946271e-01,
   6.3965040e-01, 6.3983816e-01, 6.4002591e-01, 6.4021367e-01,
   6.4040148e-01, 6.4058930e-01, 6.4077717e-01, 6.4096504e-01,
   6.4115292e-01, 6.4134085e-01, 6.4152879e-01, 6.4171672e-01,
   6.4190471e-01, 6.4209270e-01, 6.4228076e-01, 6.4246881e-01,
   6.4265686e-01, 6.4284497e-01, 6.4303309e-01, 6.4322120e-01,
   6.4340937e-01, 6.4359754e-01, 6.4378577e-01, 6.4397401e-01,
   6.4416224e-01, 6.4435053e-01, 6.4453882e-01, 6.4472717e-01,
   6.4491552e-01, 6.4510387e-01, 6.4529228e-01, 6.4548069e-01,
   6.4566916e-01, 6.4585757e-01, 6.4604610e-01, 6.4623457e-01,
   6.4642310e-01, 6.4661169e-01, 6.4680022e-01, 6.4698887e-01,
   6.4717746e-01, 6.4736611e-01, 6.4755476e-01, 6.4774346e-01,
   6.4793217e-01, 6.4812094e-01, 6.4830971e-01, 6.4849848e-01,
   6.4868730e-01, 6.4887613e-01, 6.4906496e-01, 6.4925385e-01,
   6.4944273e-01, 6.4963168e-01, 6.4982063e-01, 6.5000957e-01,
   6.5019858e-01, 6.5038759e-01, 6.5057659e-01, 6.5076566e-01,
   6.5095478e-01, 6.5114385e-01, 6.5133303e-01, 6.5152216e-01,
   6.5171134e-01, 6.5190053e-01, 6.5208977e-01, 6.5227902e-01,
   6.5246826e-01, 6.5265757e-01, 6.5284693e-01, 6.5303624e-01,
   6.5322560e-01, 6.5341502e-01, 6.5360439e-01, 6.5379387e-01,
   6.5398329e-01, 6.5417278e-01, 6.5436232e-01, 6.5455180e-01,
   6.5474141e-01, 6.5493095e-01, 6.5512055e-01, 6.5531015e-01,
   6.5549982e-01, 6.5568948e-01, 6.5587920e-01, 6.5606892e-01,
   6.5625864e-01, 6.5644842e-01, 6.5663821e-01, 6.5682805e-01,
   6.5701783e-01, 6.5720773e-01, 6.5739763e-01, 6.5758753e-01,
   6.5777743e-01, 6.5796739e-01, 6.5815735e-01, 6.5834737e-01,
   6.5853739e-01, 6.5872747e-01, 6.5891755e-01, 6.5910763e-01,
   6.5929776e-01, 6.5948790e-01, 6.5967804e-01, 6.5986824e-01,
   6.6005844e-01, 6.6024870e-01, 6.6043895e-01, 6.6062927e-01,
   6.6081959e-01, 6.6100991e-01, 6.6120028e-01, 6.6139066e-01,
   6.6158104e-01, 6.6177148e-01, 6.6196197e-01, 6.6215241e-01,
   6.6234291e-01, 6.6253346e-01, 6.6272402e-01, 6.6291457e-01,
   6.6310519e-01, 6.6329581e-01, 6.6348648e-01, 6.6367716e-01,
   6.6386783e-01, 6.6405857e-01, 6.6424930e-01, 6.6444010e-01,
   6.6463089e-01, 6.6482168e-01, 6.6501254e-01, 6.6520339e-01,
   6.6539431e-01, 6.6558522e-01, 6.6577613e-01, 6.6596711e-01,
   6.6615808e-01, 6.6634911e-01, 6.6654015e-01, 6.6673118e-01,
   6.6692227e-01, 6.6711336e-01, 6.6730452e-01, 6.6749567e-01,
   6.6768688e-01, 6.6787809e-01, 6.6806930e-01, 6.6826057e-01,
   6.6845185e-01, 6.6864312e-01, 6.6883445e-01, 6.6902584e-01,
   6.6921723e-01, 6.6940862e-01, 6.6960001e-01, 6.6979146e-01,
   6.6998297e-01, 6.7017448e-01, 6.7036599e-01, 6.7055756e-01,
   6.7074913e-01, 6.7094070e-01, 6.7113233e-01, 6.7132396e-01,
   6.7151564e-01, 6.7170733e-01, 6.7189908e-01, 6.7209083e-01,
   6.7228258e-01, 6.7247438e-01, 6.7266619e-01, 6.7285806e-01,
   6.7304993e-01, 6.7324179e-01, 6.7343372e-01, 6.7362571e-01,
   6.7381763e-01, 6.7400968e-01, 6.7420167e-01, 6.7439371e-01,
   6.7458576e-01, 6.7477787e-01, 6.7496997e-01, 6.7516214e-01,
   6.7535430e-01, 6.7554653e-01, 6.7573875e-01, 6.7593098e-01,
   6.7612326e-01, 6.7631555e-01, 6.7650783e-01, 6.7670017e-01,
   6.7689258e-01, 6.7708498e-01, 6.7727739e-01, 6.7746985e-01,
   6.7766231e-01, 6.7785478e-01, 6.7804730e-01, 6.7823982e-01,
   6.7843240e-01, 6.7862499e-01, 6.7881763e-01, 6.7901027e-01,
   6.7920297e-01, 6.7939562e-01, 6.7958838e-01, 6.7978114e-01,
   6.7997390e-01, 6.8016666e-01, 6.8035948e-01, 6.8055236e-01,
   6.8074524e-01, 6.8093812e-01, 6.8113106e-01, 6.8132401e-01,
   6.8151695e-01, 6.8170995e-01, 6.8190300e-01, 6.8209606e-01,
   6.8228912e-01, 6.8248224e-01, 6.8267536e-01, 6.8286848e-01,
   6.8306166e-01, 6.8325490e-01, 6.8344808e-01, 6.8364137e-01,
   6.8383461e-01, 6.8402797e-01, 6.8422127e-01, 6.8441463e-01,
   6.8460798e-01, 6.8480140e-01, 6.8499488e-01, 6.8518829e-01,
   6.8538177e-01, 6.8557531e-01, 6.8576884e-01, 6.8596238e-01,
   6.8615597e-01, 6.8634963e-01, 6.8654323e-01, 6.8673688e-01,
   6.8693060e-01, 6.8712431e-01, 6.8731803e-01, 6.8751180e-01,
   6.8770564e-01, 6.8789941e-01, 6.8809330e-01, 6.8828714e-01,
   6.8848103e-01, 6.8867499e-01, 6.8886894e-01, 6.8906289e-01,
   6.8925691e-01, 6.8945092e-01, 6.8964499e-01, 6.8983907e-01,
   6.9003314e-01, 6.9022727e-01, 6.9042146e-01, 6.9061559e-01,
   6.9080985e-01, 6.9100404e-01, 6.9119835e-01, 6.9139260e-01,
   6.9158691e-01, 6.9178128e-01, 6.9197559e-01, 6.9217002e-01,
   6.9236445e-01, 6.9255888e-01, 6.9275331e-01, 6.9294786e-01,
   6.9314235e-01, 6.9333690e-01, 6.9353145e-01, 6.9372606e-01,
   6.9392073e-01, 6.9411534e-01, 6.9431007e-01, 6.9450474e-01,
   6.9469947e-01, 6.9489425e-01, 6.9508904e-01, 6.9528383e-01,
   6.9547868e-01, 6.9567353e-01, 6.9586843e-01, 6.9606334e-01,
   6.9625831e-01, 6.9645327e-01, 6.9664824e-01, 6.9684327e-01,
   6.9703835e-01, 6.9723338e-01, 6.9742852e-01, 6.9762361e-01,
   6.9781876e-01, 6.9801396e-01, 6.9820917e-01, 6.9840443e-01,
   6.9859970e-01, 6.9879496e-01, 6.9899029e-01, 6.9918561e-01,
   6.9938099e-01, 6.9957638e-01, 6.9977182e-01, 6.9996727e-01,
   7.0016271e-01, 7.0035821e-01, 7.0055377e-01, 7.0074934e-01,
   7.0094490e-01, 7.0114052e-01, 7.0133615e-01, 7.0153183e-01,
   7.0172751e-01, 7.0192319e-01, 7.0211893e-01, 7.0231473e-01,
   7.0251054e-01, 7.0270634e-01, 7.0290220e-01, 7.0309806e-01,
   7.0329398e-01, 7.0348990e-01, 7.0368588e-01, 7.0388186e-01,
   7.0407790e-01, 7.0427394e-01, 7.0446998e-01, 7.0466608e-01,
   7.0486218e-01, 7.0505834e-01, 7.0525450e-01, 7.0545071e-01,
   7.0564693e-01, 7.0584321e-01, 7.0603949e-01, 7.0623583e-01,
   7.0643216e-01, 7.0662850e-01, 7.0682490e-01, 7.0702136e-01,
   7.0721775e-01, 7.0741427e-01, 7.0761073e-01, 7.0780730e-01,
   7.0800382e-01, 7.0820040e-01, 7.0839703e-01, 7.0859367e-01,
   7.0879036e-01, 7.0898706e-01, 7.0918375e-01, 7.0938051e-01,
   7.0957726e-01, 7.0977408e-01, 7.0997089e-01, 7.1016777e-01,
   7.1036464e-01, 7.1056157e-01, 7.1075851e-01, 7.1095550e-01,
   7.1115249e-01, 7.1134949e-01, 7.1154654e-01, 7.1174365e-01,
   7.1194077e-01, 7.1213788e-01, 7.1233505e-01, 7.1253222e-01,
   7.1272945e-01, 7.1292669e-01, 7.1312398e-01, 7.1332127e-01,
   7.1351862e-01, 7.1371597e-01, 7.1391332e-01, 7.1411073e-01,
   7.1430820e-01, 7.1450567e-01, 7.1470314e-01, 7.1490067e-01,
   7.1509826e-01, 7.1529579e-01, 7.1549344e-01, 7.1569109e-01,
   7.1588874e-01, 7.1608639e-01, 7.1628416e-01, 7.1648186e-01,
   7.1667963e-01, 7.1687746e-01, 7.1707529e-01, 7.1727318e-01,
   7.1747106e-01, 7.1766895e-01, 7.1786690e-01, 7.1806484e-01,
   7.1826285e-01, 7.1846092e-01, 7.1865898e-01, 7.1885705e-01,
   7.1905518e-01, 7.1925330e-01, 7.1945149e-01, 7.1964967e-01,
   7.1984792e-01, 7.2004616e-01, 7.2024441e-01, 7.2044271e-01,
   7.2064108e-01, 7.2083944e-01, 7.2103786e-01, 7.2123629e-01,
   7.2143471e-01, 7.2163320e-01, 7.2183174e-01, 7.2203022e-01,
   7.2222883e-01, 7.2242743e-01, 7.2262603e-01, 7.2282469e-01,
   7.2302336e-01, 7.2322208e-01, 7.2342080e-01, 7.2361958e-01,
   7.2381836e-01, 7.2401720e-01, 7.2421604e-01, 7.2441494e-01,
   7.2461385e-01, 7.2481281e-01, 7.2501177e-01, 7.2521073e-01,
   7.2540975e-01, 7.2560883e-01, 7.2580791e-01, 7.2600698e-01,
   7.2620612e-01, 7.2640532e-01, 7.2660452e-01, 7.2680372e-01,
   7.2700298e-01, 7.2720230e-01, 7.2740161e-01, 7.2760093e-01,
   7.2780031e-01, 7.2799969e-01, 7.2819912e-01, 7.2839856e-01,
   7.2859806e-01, 7.2879755e-01, 7.2899711e-01, 7.2919673e-01,
   7.2939628e-01, 7.2959596e-01, 7.2979558e-01, 7.2999531e-01,
   7.3019499e-01, 7.3039472e-01, 7.3059452e-01, 7.3079431e-01,
   7.3099416e-01, 7.3119402e-01, 7.3139393e-01, 7.3159385e-01,
   7.3179382e-01, 7.3199379e-01, 7.3219377e-01, 7.3239380e-01,
   7.3259389e-01, 7.3279399e-01, 7.3299414e-01, 7.3319429e-01,
   7.3339444e-01, 7.3359466e-01, 7.3379493e-01, 7.3399520e-01,
   7.3419553e-01, 7.3439586e-01, 7.3459619e-01, 7.3479658e-01,
   7.3499703e-01, 7.3519748e-01, 7.3539793e-01, 7.3559844e-01,
   7.3579901e-01, 7.3599958e-01, 7.3620015e-01, 7.3640078e-01,
   7.3660147e-01, 7.3680216e-01, 7.3700285e-01, 7.3720360e-01,
   7.3740441e-01, 7.3760521e-01, 7.3780602e-01, 7.3800689e-01,
   7.3820782e-01, 7.3840874e-01, 7.3860967e-01, 7.3881066e-01,
   7.3901170e-01, 7.3921275e-01, 7.3941380e-01, 7.3961490e-01,
   7.3981607e-01, 7.4001724e-01, 7.4021840e-01, 7.4041963e-01,
   7.4062091e-01, 7.4082220e-01, 7.4102348e-01, 7.4122483e-01,
   7.4142623e-01, 7.4162763e-01, 7.4182904e-01, 7.4203050e-01,
   7.4223202e-01, 7.4243355e-01, 7.4263507e-01, 7.4283665e-01,
   7.4303830e-01, 7.4323994e-01, 7.4344164e-01, 7.4364334e-01,
   7.4384505e-01, 7.4404681e-01, 7.4424863e-01, 7.4445045e-01,
   7.4465233e-01, 7.4485421e-01, 7.4505609e-01, 7.4525809e-01,
   7.4546003e-01, 7.4566203e-01, 7.4586409e-01, 7.4606615e-01,
   7.4626827e-01, 7.4647039e-01, 7.4667257e-01, 7.4687475e-01,
   7.4707699e-01, 7.4727923e-01, 7.4748152e-01, 7.4768382e-01,
   7.4788618e-01, 7.4808854e-01, 7.4829096e-01, 7.4849343e-01,
   7.4869585e-01, 7.4889839e-01, 7.4910092e-01, 7.4930346e-01,
   7.4950606e-01, 7.4970865e-01, 7.4991131e-01, 7.5011402e-01,
   7.5031674e-01, 7.5051945e-01, 7.5072223e-01, 7.5092506e-01,
   7.5112790e-01, 7.5133079e-01, 7.5153369e-01, 7.5173658e-01,
   7.5193954e-01, 7.5214255e-01, 7.5234556e-01, 7.5254864e-01,
   7.5275171e-01, 7.5295484e-01, 7.5315797e-01, 7.5336117e-01,
   7.5356436e-01, 7.5376761e-01, 7.5397086e-01, 7.5417417e-01,
   7.5437754e-01, 7.5458091e-01, 7.5478429e-01, 7.5498772e-01,
   7.5519121e-01, 7.5539470e-01, 7.5559819e-01, 7.5580174e-01,
   7.5600535e-01, 7.5620896e-01, 7.5641263e-01, 7.5661629e-01,
   7.5681996e-01, 7.5702375e-01, 7.5722748e-01, 7.5743133e-01,
   7.5763512e-01, 7.5783902e-01, 7.5804293e-01, 7.5824684e-01,
   7.5845081e-01, 7.5865477e-01, 7.5885880e-01, 7.5906289e-01,
   7.5926697e-01, 7.5947106e-01, 7.5967526e-01, 7.5987941e-01,
   7.6008362e-01, 7.6028788e-01, 7.6049215e-01, 7.6069647e-01,
   7.6090080e-01, 7.6110518e-01, 7.6130962e-01, 7.6151401e-01,
   7.6171851e-01, 7.6192302e-01, 7.6212752e-01, 7.6233208e-01,
   7.6253670e-01, 7.6274133e-01, 7.6294601e-01, 7.6315069e-01,
   7.6335543e-01, 7.6356018e-01, 7.6376498e-01, 7.6396978e-01,
   7.6417464e-01, 7.6437950e-01, 7.6458442e-01, 7.6478940e-01,
   7.6499438e-01, 7.6519936e-01, 7.6540440e-01, 7.6560950e-01,
   7.6581460e-01, 7.6601976e-01, 7.6622492e-01, 7.6643014e-01,
   7.6663536e-01, 7.6684064e-01, 7.6704592e-01, 7.6725125e-01,
   7.6745665e-01, 7.6766205e-01, 7.6786751e-01, 7.6807296e-01,
   7.6827842e-01, 7.6848400e-01, 7.6868951e-01, 7.6889515e-01,
   7.6910079e-01, 7.6930642e-01, 7.6951212e-01, 7.6971781e-01,
   7.6992357e-01, 7.7012938e-01, 7.7033520e-01, 7.7054107e-01,
   7.7074695e-01, 7.7095288e-01, 7.7115881e-01, 7.7136481e-01,
   7.7157086e-01, 7.7177691e-01, 7.7198297e-01, 7.7218908e-01,
   7.7239525e-01, 7.7260143e-01, 7.7280766e-01, 7.7301389e-01,
   7.7322018e-01, 7.7342647e-01, 7.7363282e-01, 7.7383924e-01,
   7.7404565e-01, 7.7425206e-01, 7.7445853e-01, 7.7466506e-01,
   7.7487159e-01, 7.7507818e-01, 7.7528483e-01, 7.7549142e-01,
   7.7569813e-01, 7.7590483e-01, 7.7611160e-01, 7.7631837e-01,
   7.7652514e-01, 7.7673203e-01, 7.7693892e-01, 7.7714580e-01,
   7.7735275e-01, 7.7755970e-01, 7.7776670e-01, 7.7797377e-01,
   7.7818084e-01, 7.7838796e-01, 7.7859509e-01, 7.7880228e-01,
   7.7900952e-01, 7.7921671e-01, 7.7942401e-01, 7.7963132e-01,
   7.7983868e-01, 7.8004605e-01, 7.8025347e-01, 7.8046089e-01,
   7.8066838e-01, 7.8087592e-01, 7.8108346e-01, 7.8129101e-01,
   7.8149861e-01, 7.8170627e-01, 7.8191394e-01, 7.8212166e-01,
   7.8232944e-01, 7.8253722e-01, 7.8274500e-01, 7.8295285e-01,
   7.8316075e-01, 7.8336865e-01, 7.8357661e-01, 7.8378463e-01,
   7.8399265e-01, 7.8420067e-01, 7.8440875e-01, 7.8461689e-01,
   7.8482503e-01, 7.8503323e-01, 7.8524148e-01, 7.8544968e-01,
   7.8565800e-01, 7.8586632e-01, 7.8607470e-01, 7.8628308e-01,
   7.8649151e-01, 7.8669995e-01, 7.8690845e-01, 7.8711700e-01,
   7.8732556e-01, 7.8753418e-01, 7.8774279e-01, 7.8795147e-01,
   7.8816015e-01, 7.8836888e-01, 7.8857768e-01, 7.8878647e-01,
   7.8899533e-01, 7.8920418e-01, 7.8941309e-01, 7.8962201e-01,
   7.8983098e-01, 7.9004002e-01, 7.9024905e-01, 7.9045814e-01,
   7.9066724e-01, 7.9087639e-01, 7.9108560e-01, 7.9129481e-01,
   7.9150409e-01, 7.9171336e-01, 7.9192269e-01, 7.9213202e-01,
   7.9234141e-01, 7.9255086e-01, 7.9276031e-01, 7.9296982e-01,
   7.9317933e-01, 7.9338890e-01, 7.9359853e-01, 7.9380816e-01,
   7.9401779e-01, 7.9422754e-01, 7.9443729e-01, 7.9464704e-01,
   7.9485685e-01, 7.9506671e-01, 7.9527658e-01, 7.9548651e-01,
   7.9569644e-01, 7.9590642e-01, 7.9611647e-01, 7.9632652e-01,
   7.9653656e-01, 7.9674673e-01, 7.9695690e-01, 7.9716706e-01,
   7.9737729e-01, 7.9758757e-01, 7.9779786e-01, 7.9800820e-01,
   7.9821861e-01, 7.9842901e-01, 7.9863942e-01, 7.9884994e-01,
   7.9906040e-01, 7.9927099e-01, 7.9948157e-01, 7.9969221e-01,
   7.9990286e-01, 8.0011356e-01, 8.0032426e-01, 8.0053502e-01,
   8.0074584e-01, 8.0095667e-01, 8.0116755e-01, 8.0137843e-01,
   8.0158937e-01, 8.0180037e-01, 8.0201137e-01, 8.0222243e-01,
   8.0243349e-01, 8.0264461e-01, 8.0285579e-01, 8.0306697e-01,
   8.0327821e-01, 8.0348945e-01, 8.0370075e-01, 8.0391210e-01,
   8.0412346e-01, 8.0433488e-01, 8.0454630e-01, 8.0475777e-01,
   8.0496931e-01, 8.0518085e-01, 8.0539244e-01, 8.0560404e-01,
   8.0581570e-01, 8.0602741e-01, 8.0623913e-01, 8.0645090e-01,
   8.0666268e-01, 8.0687451e-01, 8.0708641e-01, 8.0729830e-01,
   8.0751026e-01, 8.0772227e-01, 8.0793428e-01, 8.0814636e-01,
   8.0835843e-01, 8.0857056e-01, 8.0878270e-01, 8.0899495e-01,
   8.0920714e-01, 8.0941945e-01, 8.0963176e-01, 8.0984408e-01,
   8.1005645e-01, 8.1026888e-01, 8.1048137e-01, 8.1069386e-01,
   8.1090641e-01, 8.1111896e-01, 8.1133157e-01, 8.1154418e-01,
   8.1175685e-01, 8.1196958e-01, 8.1218231e-01, 8.1239510e-01,
   8.1260794e-01, 8.1282079e-01, 8.1303370e-01, 8.1324667e-01,
   8.1345963e-01, 8.1367260e-01, 8.1388569e-01, 8.1409878e-01,
   8.1431186e-01, 8.1452501e-01, 8.1473821e-01, 8.1495148e-01,
   8.1516474e-01, 8.1537801e-01, 8.1559139e-01, 8.1580472e-01,
   8.1601816e-01, 8.1623161e-01, 8.1644511e-01, 8.1665862e-01,
   8.1687218e-01, 8.1708580e-01, 8.1729943e-01, 8.1751311e-01,
   8.1772685e-01, 8.1794059e-01, 8.1815439e-01, 8.1836820e-01,
   8.1858206e-01, 8.1879598e-01, 8.1900990e-01, 8.1922388e-01,
   8.1943792e-01, 8.1965196e-01, 8.1986606e-01, 8.2008016e-01,
   8.2029432e-01, 8.2050854e-01, 8.2072276e-01, 8.2093704e-01,
   8.2115138e-01, 8.2136571e-01, 8.2158011e-01, 8.2179451e-01,
   8.2200897e-01, 8.2222348e-01, 8.2243806e-01, 8.2265264e-01,
   8.2286721e-01, 8.2308191e-01, 8.2329661e-01, 8.2351130e-01,
   8.2372606e-01, 8.2394087e-01, 8.2415575e-01, 8.2437062e-01,
   8.2458556e-01, 8.2480049e-01, 8.2501549e-01, 8.2523054e-01,
   8.2544559e-01, 8.2566071e-01, 8.2587588e-01, 8.2609105e-01,
   8.2630628e-01, 8.2652152e-01, 8.2673687e-01, 8.2695216e-01,
   8.2716757e-01, 8.2738298e-01, 8.2759845e-01, 8.2781392e-01,
   8.2802945e-01, 8.2824504e-01, 8.2846063e-01, 8.2867628e-01,
   8.2889199e-01, 8.2910770e-01, 8.2932347e-01, 8.2953930e-01,
   8.2975513e-01, 8.2997102e-01, 8.3018690e-01, 8.3040285e-01,
   8.3061886e-01, 8.3083493e-01, 8.3105099e-01, 8.3126712e-01,
   8.3148324e-01, 8.3169943e-01, 8.3191568e-01, 8.3213192e-01,
   8.3234823e-01, 8.3256459e-01, 8.3278096e-01, 8.3299738e-01,
   8.3321387e-01, 8.3343035e-01, 8.3364689e-01, 8.3386350e-01,
   8.3408010e-01, 8.3429676e-01, 8.3451349e-01, 8.3473021e-01,
   8.3494699e-01, 8.3516377e-01, 8.3538067e-01, 8.3559757e-01,
   8.3581448e-01, 8.3603144e-01, 8.3624846e-01, 8.3646554e-01,
   8.3668262e-01, 8.3689976e-01, 8.3711690e-01, 8.3733410e-01,
   8.3755136e-01, 8.3776867e-01, 8.3798599e-01, 8.3820337e-01,
   8.3842075e-01, 8.3863819e-01, 8.3885568e-01, 8.3907324e-01,
   8.3929080e-01, 8.3950841e-01, 8.3972603e-01, 8.3994371e-01,
   8.4016144e-01, 8.4037918e-01, 8.4059703e-01, 8.4081483e-01,
   8.4103274e-01, 8.4125066e-01, 8.4146863e-01, 8.4168661e-01,
   8.4190470e-01, 8.4212279e-01, 8.4234089e-01, 8.4255904e-01,
   8.4277725e-01, 8.4299552e-01, 8.4321380e-01, 8.4343213e-01,
   8.4365046e-01, 8.4386891e-01, 8.4408730e-01, 8.4430581e-01,
   8.4452432e-01, 8.4474289e-01, 8.4496152e-01, 8.4518015e-01,
   8.4539884e-01, 8.4561759e-01, 8.4583634e-01, 8.4605515e-01,
   8.4627402e-01, 8.4649289e-01, 8.4671181e-01, 8.4693080e-01,
   8.4714979e-01, 8.4736884e-01, 8.4758794e-01, 8.4780711e-01,
   8.4802628e-01, 8.4824550e-01, 8.4846473e-01, 8.4868401e-01,
   8.4890336e-01, 8.4912276e-01, 8.4934217e-01, 8.4956163e-01,
   8.4978116e-01, 8.5000068e-01, 8.5022026e-01, 8.5043991e-01,
   8.5065955e-01, 8.5087925e-01, 8.5109901e-01, 8.5131878e-01,
   8.5153860e-01, 8.5175848e-01, 8.5197842e-01, 8.5219836e-01,
   8.5241836e-01, 8.5263836e-01, 8.5285848e-01, 8.5307860e-01,
   8.5329872e-01, 8.5351896e-01, 8.5373920e-01, 8.5395950e-01,
   8.5417980e-01, 8.5440016e-01, 8.5462058e-01, 8.5484105e-01,
   8.5506153e-01, 8.5528207e-01, 8.5550261e-01, 8.5572326e-01,
   8.5594392e-01, 8.5616457e-01, 8.5638535e-01, 8.5660613e-01,
   8.5682696e-01, 8.5704780e-01, 8.5726875e-01, 8.5748965e-01,
   8.5771066e-01, 8.5793167e-01, 8.5815281e-01, 8.5837388e-01,
   8.5859507e-01, 8.5881627e-01, 8.5903752e-01, 8.5925877e-01,
   8.5948014e-01, 8.5970151e-01, 8.5992289e-01, 8.6014438e-01,
   8.6036587e-01, 8.6058742e-01, 8.6080897e-01, 8.6103058e-01,
   8.6125225e-01, 8.6147398e-01, 8.6169571e-01, 8.6191750e-01,
   8.6213934e-01, 8.6236125e-01, 8.6258316e-01, 8.6280513e-01,
   8.6302710e-01, 8.6324918e-01, 8.6347127e-01, 8.6369336e-01,
   8.6391556e-01, 8.6413777e-01, 8.6436003e-01, 8.6458236e-01,
   8.6480469e-01, 8.6502707e-01, 8.6524951e-01, 8.6547196e-01,
   8.6569452e-01, 8.6591709e-01, 8.6613965e-01, 8.6636233e-01,
   8.6658502e-01, 8.6680776e-01, 8.6703050e-01, 8.6725330e-01,
   8.6747617e-01, 8.6769909e-01, 8.6792201e-01, 8.6814505e-01,
   8.6836809e-01, 8.6859113e-01, 8.6881423e-01, 8.6903745e-01,
   8.6926061e-01, 8.6948389e-01, 8.6970717e-01, 8.6993051e-01,
   8.7015390e-01, 8.7037730e-01, 8.7060076e-01, 8.7082428e-01,
   8.7104785e-01, 8.7127143e-01, 8.7149507e-01, 8.7171876e-01,
   8.7194252e-01, 8.7216628e-01, 8.7239009e-01, 8.7261397e-01,
   8.7283784e-01, 8.7306178e-01, 8.7328577e-01, 8.7350982e-01,
   8.7373388e-01, 8.7395799e-01, 8.7418216e-01, 8.7440640e-01,
   8.7463063e-01, 8.7485492e-01, 8.7507927e-01, 8.7530369e-01,
   8.7552810e-01, 8.7575257e-01, 8.7597710e-01, 8.7620169e-01,
   8.7642628e-01, 8.7665093e-01, 8.7687564e-01, 8.7710035e-01,
   8.7732512e-01, 8.7754995e-01, 8.7777483e-01, 8.7799978e-01,
   8.7822473e-01, 8.7844974e-01, 8.7867481e-01, 8.7889987e-01,
   8.7912500e-01, 8.7935019e-01, 8.7957543e-01, 8.7980068e-01,
   8.8002604e-01, 8.8025135e-01, 8.8047677e-01, 8.8070226e-01,
   8.8092774e-01, 8.8115329e-01, 8.8137889e-01, 8.8160449e-01,
   8.8183016e-01, 8.8205588e-01, 8.8228166e-01, 8.8250744e-01,
   8.8273335e-01, 8.8295925e-01, 8.8318515e-01, 8.8341117e-01,
   8.8363719e-01, 8.8386327e-01, 8.8408941e-01, 8.8431555e-01,
   8.8454181e-01, 8.8476807e-01, 8.8499439e-01, 8.8522071e-01,
   8.8544714e-01, 8.8567358e-01, 8.8590008e-01, 8.8612658e-01,
   8.8635319e-01, 8.8657981e-01, 8.8680649e-01, 8.8703316e-01,
   8.8725996e-01, 8.8748676e-01, 8.8771361e-01, 8.8794053e-01,
   8.8816744e-01, 8.8839442e-01, 8.8862145e-01, 8.8884854e-01,
   8.8907570e-01, 8.8930285e-01, 8.8953006e-01, 8.8975734e-01,
   8.8998467e-01, 8.9021200e-01, 8.9043945e-01, 8.9066684e-01,
   8.9089435e-01, 8.9112192e-01, 8.9134949e-01, 8.9157712e-01,
   8.9180481e-01, 8.9203256e-01, 8.9226031e-01, 8.9248812e-01,
   8.9271599e-01, 8.9294392e-01, 8.9317185e-01, 8.9339989e-01,
   8.9362794e-01, 8.9385605e-01, 8.9408416e-01, 8.9431238e-01,
   8.9454061e-01, 8.9476889e-01, 8.9499724e-01, 8.9522558e-01,
   8.9545399e-01, 8.9568251e-01, 8.9591098e-01, 8.9613956e-01,
   8.9636821e-01, 8.9659685e-01, 8.9682555e-01, 8.9705431e-01,
   8.9728308e-01, 8.9751196e-01, 8.9774084e-01, 8.9796978e-01,
   8.9819878e-01, 8.9842778e-01, 8.9865690e-01, 8.9888602e-01,
   8.9911520e-01, 8.9934438e-01, 8.9957368e-01, 8.9980298e-01,
   9.0003234e-01, 9.0026176e-01, 9.0049124e-01, 9.0072072e-01,
   9.0095031e-01, 9.0117991e-01, 9.0140957e-01, 9.0163922e-01,
   9.0186900e-01, 9.0209877e-01, 9.0232861e-01, 9.0255851e-01,
   9.0278846e-01, 9.0301841e-01, 9.0324843e-01, 9.0347856e-01,
   9.0370864e-01, 9.0393883e-01, 9.0416908e-01, 9.0439934e-01,
   9.0462965e-01, 9.0486002e-01, 9.0509045e-01, 9.0532088e-01,
   9.0555137e-01, 9.0578198e-01, 9.0601259e-01, 9.0624321e-01,
   9.0647393e-01, 9.0670466e-01, 9.0693545e-01, 9.0716630e-01,
   9.0739721e-01, 9.0762818e-01, 9.0785915e-01, 9.0809017e-01,
   9.0832126e-01, 9.0855241e-01, 9.0878361e-01, 9.0901482e-01,
   9.0924615e-01, 9.0947747e-01, 9.0970886e-01, 9.0994030e-01,
   9.1017175e-01, 9.1040331e-01, 9.1063488e-01, 9.1086650e-01,
   9.1109818e-01, 9.1132987e-01, 9.1156167e-01, 9.1179347e-01,
   9.1202533e-01, 9.1225725e-01, 9.1248924e-01, 9.1272128e-01,
   9.1295332e-01, 9.1318542e-01, 9.1341758e-01, 9.1364980e-01,
   9.1388208e-01, 9.1411442e-01, 9.1434675e-01, 9.1457915e-01,
   9.1481161e-01, 9.1504413e-01, 9.1527671e-01, 9.1550928e-01,
   9.1574198e-01, 9.1597468e-01, 9.1620743e-01, 9.1644025e-01,
   9.1667312e-01, 9.1690600e-01, 9.1713893e-01, 9.1737199e-01,
   9.1760504e-01, 9.1783816e-01, 9.1807127e-01, 9.1830450e-01,
   9.1853774e-01, 9.1877103e-01, 9.1900444e-01, 9.1923779e-01,
   9.1947126e-01, 9.1970479e-01, 9.1993833e-01, 9.2017192e-01,
   9.2040563e-01, 9.2063934e-01, 9.2087305e-01, 9.2110687e-01,
   9.2134070e-01, 9.2157465e-01, 9.2180860e-01, 9.2204261e-01,
   9.2227668e-01, 9.2251080e-01, 9.2274493e-01, 9.2297918e-01,
   9.2321342e-01, 9.2344773e-01, 9.2368209e-01, 9.2391652e-01,
   9.2415094e-01, 9.2438549e-01, 9.2462003e-01, 9.2485470e-01,
   9.2508936e-01, 9.2532408e-01, 9.2555881e-01, 9.2579365e-01,
   9.2602855e-01, 9.2626345e-01, 9.2649841e-01, 9.2673343e-01,
   9.2696851e-01, 9.2720366e-01, 9.2743886e-01, 9.2767406e-01,
   9.2790937e-01, 9.2814469e-01, 9.2838007e-01, 9.2861551e-01,
   9.2885101e-01, 9.2908657e-01, 9.2932212e-01, 9.2955780e-01,
   9.2979348e-01, 9.3002921e-01, 9.3026501e-01, 9.3050086e-01,
   9.3073678e-01, 9.3097270e-01, 9.3120873e-01, 9.3144476e-01,
   9.3168086e-01, 9.3191707e-01, 9.3215328e-01, 9.3238950e-01,
   9.3262583e-01, 9.3286222e-01, 9.3309861e-01, 9.3333513e-01,
   9.3357164e-01, 9.3380821e-01, 9.3404484e-01, 9.3428153e-01,
   9.3451828e-01, 9.3475503e-01, 9.3499190e-01, 9.3522877e-01,
   9.3546569e-01, 9.3570274e-01, 9.3593979e-01, 9.3617690e-01,
   9.3641400e-01, 9.3665123e-01, 9.3688852e-01, 9.3712580e-01,
   9.3736315e-01, 9.3760061e-01, 9.3783808e-01, 9.3807560e-01,
   9.3831319e-01, 9.3855077e-01, 9.3878847e-01, 9.3902624e-01,
   9.3926400e-01, 9.3950182e-01, 9.3973976e-01, 9.3997771e-01,
   9.4021571e-01, 9.4045377e-01, 9.4069183e-01, 9.4093001e-01,
   9.4116825e-01, 9.4140649e-01, 9.4164485e-01, 9.4188321e-01,
   9.4212162e-01, 9.4236010e-01, 9.4259864e-01, 9.4283724e-01,
   9.4307590e-01, 9.4331455e-01, 9.4355333e-01, 9.4379210e-01,
   9.4403100e-01, 9.4426990e-01, 9.4450885e-01, 9.4474787e-01,
   9.4498694e-01, 9.4522607e-01, 9.4546527e-01, 9.4570452e-01,
   9.4594383e-01, 9.4618315e-01, 9.4642258e-01, 9.4666201e-01,
   9.4690150e-01, 9.4714105e-01, 9.4738066e-01, 9.4762039e-01,
   9.4786006e-01, 9.4809985e-01, 9.4833970e-01, 9.4857961e-01,
   9.4881952e-01, 9.4905955e-01, 9.4929957e-01, 9.4953972e-01,
   9.4977987e-01, 9.5002007e-01, 9.5026034e-01, 9.5050067e-01,
   9.5074105e-01, 9.5098150e-01, 9.5122200e-01, 9.5146251e-01,
   9.5170313e-01, 9.5194381e-01, 9.5218450e-01, 9.5242524e-01,
   9.5266610e-01, 9.5290697e-01, 9.5314789e-01, 9.5338887e-01,
   9.5362991e-01, 9.5387101e-01, 9.5411217e-01, 9.5435339e-01,
   9.5459467e-01, 9.5483601e-01, 9.5507735e-01, 9.5531881e-01,
   9.5556027e-01, 9.5580184e-01, 9.5604342e-01, 9.5628506e-01,
   9.5652682e-01, 9.5676857e-01, 9.5701039e-01, 9.5725226e-01,
   9.5749420e-01, 9.5773619e-01, 9.5797825e-01, 9.5822036e-01,
   9.5846248e-01, 9.5870471e-01, 9.5894700e-01, 9.5918930e-01,
   9.5943171e-01, 9.5967412e-01, 9.5991665e-01, 9.6015918e-01,
   9.6040183e-01, 9.6064448e-01, 9.6088719e-01, 9.6112996e-01,
   9.6137279e-01, 9.6161568e-01, 9.6185863e-01, 9.6210164e-01,
   9.6234471e-01, 9.6258783e-01, 9.6283102e-01, 9.6307427e-01,
   9.6331757e-01, 9.6356088e-01, 9.6380430e-01, 9.6404779e-01,
   9.6429127e-01, 9.6453488e-01, 9.6477848e-01, 9.6502221e-01,
   9.6526593e-01, 9.6550977e-01, 9.6575361e-01, 9.6599752e-01,
   9.6624154e-01, 9.6648556e-01, 9.6672964e-01, 9.6697378e-01,
   9.6721798e-01, 9.6746230e-01, 9.6770662e-01, 9.6795100e-01,
   9.6819544e-01, 9.6843994e-01, 9.6868449e-01, 9.6892911e-01,
   9.6917379e-01, 9.6941847e-01, 9.6966326e-01, 9.6990812e-01,
   9.7015303e-01, 9.7039801e-01, 9.7064304e-01, 9.7088808e-01,
   9.7113323e-01, 9.7137845e-01, 9.7162366e-01, 9.7186899e-01,
   9.7211438e-01, 9.7235978e-01, 9.7260529e-01, 9.7285086e-01,
   9.7309643e-01, 9.7334212e-01, 9.7358781e-01, 9.7383362e-01,
   9.7407943e-01, 9.7432536e-01, 9.7457129e-01, 9.7481734e-01,
   9.7506338e-01, 9.7530955e-01, 9.7555572e-01, 9.7580200e-01,
   9.7604829e-01, 9.7629470e-01, 9.7654110e-01, 9.7678757e-01,
   9.7703415e-01, 9.7728074e-01, 9.7752744e-01, 9.7777414e-01,
   9.7802097e-01, 9.7826779e-01, 9.7851467e-01, 9.7876167e-01,
   9.7900867e-01, 9.7925580e-01, 9.7950292e-01, 9.7975016e-01,
   9.7999740e-01, 9.8024470e-01, 9.8049212e-01, 9.8073953e-01,
   9.8098707e-01, 9.8123461e-01, 9.8148227e-01, 9.8172992e-01,
   9.8197770e-01, 9.8222548e-01, 9.8247337e-01, 9.8272127e-01,
   9.8296928e-01, 9.8321730e-01, 9.8346543e-01, 9.8371363e-01,
   9.8396182e-01, 9.8421013e-01, 9.8445845e-01, 9.8470688e-01,
   9.8495537e-01, 9.8520392e-01, 9.8545247e-01, 9.8570114e-01,
   9.8594987e-01, 9.8619866e-01, 9.8644745e-01, 9.8669636e-01,
   9.8694533e-01, 9.8719436e-01, 9.8744345e-01, 9.8769259e-01,
   9.8794180e-01, 9.8819107e-01, 9.8844039e-01, 9.8868978e-01,
   9.8893923e-01, 9.8918873e-01, 9.8943830e-01, 9.8968798e-01,
   9.8993766e-01, 9.9018741e-01, 9.9043721e-01, 9.9068713e-01,
   9.9093705e-01, 9.9118710e-01, 9.9143714e-01, 9.9168730e-01,
   9.9193746e-01, 9.9218774e-01, 9.9243802e-01, 9.9268842e-01,
   9.9293888e-01, 9.9318939e-01, 9.9343991e-01, 9.9369055e-01,
   9.9394125e-01, 9.9419200e-01, 9.9444282e-01, 9.9469370e-01,
   9.9494463e-01, 9.9519563e-01, 9.9544674e-01, 9.9569786e-01,
   9.9594903e-01, 9.9620032e-01, 9.9645162e-01, 9.9670297e-01,
   9.9695444e-01, 9.9720597e-01, 9.9745750e-01, 9.9770916e-01,
   9.9796087e-01, 9.9821264e-01, 9.9846447e-01, 9.9871629e-01,
   9.9896824e-01, 9.9922031e-01, 9.9947238e-01, 9.9972451e-01,
   9.9997669e-01, 1.0002290e+00, 1.0004814e+00, 1.0007337e+00,
   1.0009862e+00, 1.0012387e+00, 1.0014913e+00, 1.0017439e+00,
   1.0019966e+00, 1.0022494e+00, 1.0025022e+00, 1.0027552e+00,
   1.0030081e+00, 1.0032612e+00, 1.0035143e+00, 1.0037675e+00,
   1.0040207e+00, 1.0042740e+00, 1.0045273e+00, 1.0047808e+00,
   1.0050342e+00, 1.0052878e+00, 1.0055413e+00, 1.0057951e+00,
   1.0060488e+00, 1.0063026e+00, 1.0065565e+00, 1.0068104e+00,
   1.0070645e+00, 1.0073185e+00, 1.0075727e+00, 1.0078268e+00,
   1.0080811e+00, 1.0083355e+00, 1.0085899e+00, 1.0088443e+00,
   1.0090988e+00, 1.0093534e+00, 1.0096080e+00, 1.0098628e+00,
   1.0101175e+00, 1.0103724e+00, 1.0106274e+00, 1.0108824e+00,
   1.0111374e+00, 1.0113925e+00, 1.0116477e+00, 1.0119029e+00,
   1.0121583e+00, 1.0124136e+00, 1.0126691e+00, 1.0129246e+00,
   1.0131801e+00, 1.0134358e+00, 1.0136915e+00, 1.0139472e+00,
   1.0142031e+00, 1.0144590e+00, 1.0147150e+00, 1.0149710e+00,
   1.0152272e+00, 1.0154834e+00, 1.0157396e+00, 1.0159959e+00,
   1.0162523e+00, 1.0165087e+00, 1.0167652e+00, 1.0170218e+00,
   1.0172784e+00, 1.0175351e+00, 1.0177919e+00, 1.0180488e+00,
   1.0183057e+00, 1.0185627e+00, 1.0188197e+00, 1.0190768e+00,
   1.0193340e+00, 1.0195912e+00, 1.0198486e+00, 1.0201060e+00,
   1.0203633e+00, 1.0206209e+00, 1.0208784e+00, 1.0211362e+00,
   1.0213939e+00, 1.0216516e+00, 1.0219095e+00, 1.0221674e+00,
   1.0224254e+00, 1.0226835e+00, 1.0229416e+00, 1.0231998e+00,
   1.0234581e+00, 1.0237164e+00, 1.0239748e+00, 1.0242333e+00,
   1.0244918e+00, 1.0247505e+00, 1.0250092e+00, 1.0252678e+00,
   1.0255266e+00, 1.0257856e+00, 1.0260445e+00, 1.0263035e+00,
   1.0265626e+00, 1.0268217e+00, 1.0270810e+00, 1.0273403e+00,
   1.0275997e+00, 1.0278591e+00, 1.0281186e+00, 1.0283781e+00,
   1.0286378e+00, 1.0288975e+00, 1.0291573e+00, 1.0294172e+00,
   1.0296770e+00, 1.0299370e+00, 1.0301971e+00, 1.0304573e+00,
   1.0307175e+00, 1.0309777e+00, 1.0312381e+00, 1.0314984e+00,
   1.0317589e+00, 1.0320195e+00, 1.0322801e+00, 1.0325408e+00,
   1.0328015e+00, 1.0330623e+00, 1.0333233e+00, 1.0335842e+00,
   1.0338453e+00, 1.0341064e+00, 1.0343676e+00, 1.0346289e+00,
   1.0348902e+00, 1.0351515e+00, 1.0354130e+00, 1.0356746e+00,
   1.0359361e+00, 1.0361978e+00, 1.0364596e+00, 1.0367213e+00,
   1.0369833e+00, 1.0372453e+00, 1.0375073e+00, 1.0377693e+00,
   1.0380316e+00, 1.0382938e+00, 1.0385561e+00, 1.0388185e+00,
   1.0390810e+00, 1.0393435e+00, 1.0396061e+00, 1.0398687e+00,
   1.0401314e+00, 1.0403943e+00, 1.0406572e+00, 1.0409201e+00,
   1.0411832e+00, 1.0414463e+00, 1.0417095e+00, 1.0419728e+00,
   1.0422361e+00, 1.0424994e+00, 1.0427629e+00, 1.0430264e+00,
   1.0432900e+00, 1.0435537e+00, 1.0438175e+00, 1.0440813e+00,
   1.0443453e+00, 1.0446092e+00, 1.0448732e+00, 1.0451374e+00,
   1.0454016e+00, 1.0456659e+00, 1.0459301e+00, 1.0461946e+00,
   1.0464591e+00, 1.0467236e+00, 1.0469882e+00, 1.0472530e+00,
   1.0475178e+00, 1.0477827e+00, 1.0480475e+00, 1.0483125e+00,
   1.0485777e+00, 1.0488428e+00, 1.0491080e+00, 1.0493733e+00,
   1.0496386e+00, 1.0499041e+00, 1.0501696e+00, 1.0504352e+00,
   1.0507009e+00, 1.0509666e+00, 1.0512325e+00, 1.0514983e+00,
   1.0517642e+00, 1.0520303e+00, 1.0522964e+00, 1.0525626e+00,
   1.0528289e+00, 1.0530952e+00, 1.0533617e+00, 1.0536281e+00,
   1.0538946e+00, 1.0541613e+00, 1.0544280e+00, 1.0546948e+00,
   1.0549617e+00, 1.0552286e+00, 1.0554956e+00, 1.0557626e+00,
   1.0560298e+00, 1.0562971e+00, 1.0565643e+00, 1.0568317e+00,
   1.0570992e+00, 1.0573667e+00, 1.0576344e+00, 1.0579021e+00,
   1.0581698e+00, 1.0584377e+00, 1.0587056e+00, 1.0589736e+00,
   1.0592417e+00, 1.0595098e+00, 1.0597780e+00, 1.0600463e+00,
   1.0603147e+00, 1.0605831e+00, 1.0608517e+00, 1.0611203e+00,
   1.0613890e+00, 1.0616577e+00, 1.0619265e+00, 1.0621954e+00,
   1.0624644e+00, 1.0627335e+00, 1.0630026e+00, 1.0632719e+00,
   1.0635412e+00, 1.0638105e+00, 1.0640800e+00, 1.0643495e+00,
   1.0646191e+00, 1.0648887e+00, 1.0651585e+00, 1.0654284e+00,
   1.0656983e+00, 1.0659683e+00, 1.0662383e+00, 1.0665085e+00,
   1.0667787e+00, 1.0670490e+00, 1.0673194e+00, 1.0675899e+00,
   1.0678604e+00, 1.0681310e+00, 1.0684017e+00, 1.0686724e+00,
   1.0689433e+00, 1.0692142e+00, 1.0694852e+00, 1.0697563e+00,
   1.0700275e+00, 1.0702987e+00, 1.0705701e+00, 1.0708414e+00,
   1.0711130e+00, 1.0713844e+00, 1.0716561e+00, 1.0719278e+00,
   1.0721996e+00, 1.0724715e+00, 1.0727434e+00, 1.0730155e+00,
   1.0732876e+00, 1.0735598e+00, 1.0738320e+00, 1.0741044e+00,
   1.0743768e+00, 1.0746493e+00, 1.0749220e+00, 1.0751946e+00,
   1.0754673e+00, 1.0757402e+00, 1.0760131e+00, 1.0762861e+00,
   1.0765592e+00, 1.0768323e+00, 1.0771055e+00, 1.0773789e+00,
   1.0776522e+00, 1.0779257e+00, 1.0781993e+00, 1.0784730e+00,
   1.0787467e+00, 1.0790205e+00, 1.0792943e+00, 1.0795683e+00,
   1.0798423e+00, 1.0801164e+00, 1.0803907e+00, 1.0806649e+00,
   1.0809393e+00, 1.0812137e+00, 1.0814883e+00, 1.0817629e+00,
   1.0820376e+00, 1.0823123e+00, 1.0825871e+00, 1.0828621e+00,
   1.0831372e+00, 1.0834122e+00, 1.0836874e+00, 1.0839627e+00,
   1.0842381e+00, 1.0845134e+00, 1.0847889e+00, 1.0850645e+00,
   1.0853403e+00, 1.0856160e+00, 1.0858918e+00, 1.0861677e+00,
   1.0864438e+00, 1.0867199e+00, 1.0869960e+00, 1.0872723e+00,
   1.0875486e+00, 1.0878251e+00, 1.0881015e+00, 1.0883781e+00,
   1.0886548e+00, 1.0889316e+00, 1.0892084e+00, 1.0894853e+00,
   1.0897623e+00, 1.0900394e+00, 1.0903165e+00, 1.0905938e+00,
   1.0908711e+00, 1.0911485e+00, 1.0914260e+00, 1.0917037e+00,
   1.0919813e+00, 1.0922590e+00, 1.0925369e+00, 1.0928148e+00,
   1.0930929e+00, 1.0933709e+00, 1.0936491e+00, 1.0939274e+00,
   1.0942057e+00, 1.0944842e+00, 1.0947627e+00, 1.0950413e+00,
   1.0953200e+00, 1.0955988e+00, 1.0958776e+00, 1.0961566e+00,
   1.0964357e+00, 1.0967147e+00, 1.0969939e+00, 1.0972732e+00,
   1.0975525e+00, 1.0978321e+00, 1.0981116e+00, 1.0983912e+00,
   1.0986710e+00, 1.0989507e+00, 1.0992306e+00, 1.0995106e+00,
   1.0997907e+00, 1.1000708e+00, 1.1003511e+00, 1.1006314e+00,
   1.1009117e+00, 1.1011922e+00, 1.1014729e+00, 1.1017535e+00,
   1.1020342e+00, 1.1023151e+00, 1.1025960e+00, 1.1028770e+00,
   1.1031581e+00, 1.1034393e+00, 1.1037205e+00, 1.1040020e+00,
   1.1042835e+00, 1.1045649e+00, 1.1048466e+00, 1.1051283e+00,
   1.1054101e+00, 1.1056920e+00, 1.1059740e+00, 1.1062560e+00,
   1.1065382e+00, 1.1068205e+00, 1.1071028e+00, 1.1073852e+00,
   1.1076677e+00, 1.1079502e+00, 1.1082330e+00, 1.1085157e+00,
   1.1087985e+00, 1.1090815e+00, 1.1093645e+00, 1.1096476e+00,
   1.1099309e+00, 1.1102142e+00, 1.1104976e+00, 1.1107811e+00,
   1.1110647e+00, 1.1113483e+00, 1.1116320e+00, 1.1119158e+00,
   1.1121998e+00, 1.1124839e+00, 1.1127679e+00, 1.1130521e+00,
   1.1133364e+00, 1.1136208e+00, 1.1139053e+00, 1.1141899e+00,
   1.1144745e+00, 1.1147592e+00, 1.1150440e+00, 1.1153290e+00,
   1.1156139e+00, 1.1158991e+00, 1.1161842e+00, 1.1164695e+00,
   1.1167549e+00, 1.1170404e+00, 1.1173259e+00, 1.1176116e+00,
   1.1178974e+00, 1.1181831e+00, 1.1184691e+00, 1.1187551e+00,
   1.1190412e+00, 1.1193274e+00, 1.1196136e+00, 1.1199001e+00,
   1.1201866e+00, 1.1204731e+00, 1.1207597e+00, 1.1210465e+00,
   1.1213334e+00, 1.1216203e+00, 1.1219074e+00, 1.1221944e+00,
   1.1224816e+00, 1.1227689e+00, 1.1230563e+00, 1.1233438e+00,
   1.1236314e+00, 1.1239190e+00, 1.1242068e+00, 1.1244947e+00,
   1.1247827e+00, 1.1250707e+00, 1.1253588e+00, 1.1256471e+00,
   1.1259354e+00, 1.1262238e+00, 1.1265123e+00, 1.1268009e+00,
   1.1270896e+00, 1.1273785e+00, 1.1276673e+00, 1.1279563e+00,
   1.1282454e+00, 1.1285346e+00, 1.1288238e+00, 1.1291132e+00,
   1.1294026e+00, 1.1296922e+00, 1.1299818e+00, 1.1302716e+00,
   1.1305614e+00, 1.1308513e+00, 1.1311413e+00, 1.1314315e+00,
   1.1317216e+00, 1.1320120e+00, 1.1323024e+00, 1.1325929e+00,
   1.1328834e+00, 1.1331742e+00, 1.1334649e+00, 1.1337558e+00,
   1.1340468e+00, 1.1343379e+00, 1.1346291e+00, 1.1349204e+00,
   1.1352117e+00, 1.1355032e+00, 1.1357948e+00, 1.1360863e+00,
   1.1363782e+00, 1.1366700e+00, 1.1369619e+00, 1.1372540e+00,
   1.1375461e+00, 1.1378384e+00, 1.1381307e+00, 1.1384231e+00,
   1.1387156e+00, 1.1390083e+00, 1.1393009e+00, 1.1395938e+00,
   1.1398867e+00, 1.1401798e+00, 1.1404729e+00, 1.1407660e+00,
   1.1410594e+00, 1.1413528e+00, 1.1416463e+00, 1.1419399e+00,
   1.1422336e+00, 1.1425273e+00, 1.1428213e+00, 1.1431153e+00,
   1.1434094e+00, 1.1437036e+00, 1.1439979e+00, 1.1442922e+00,
   1.1445868e+00, 1.1448814e+00, 1.1451761e+00, 1.1454709e+00,
   1.1457658e+00, 1.1460607e+00, 1.1463559e+00, 1.1466510e+00,
   1.1469463e+00, 1.1472417e+00, 1.1475372e+00, 1.1478328e+00,
   1.1481285e+00, 1.1484243e+00, 1.1487201e+00, 1.1490161e+00,
   1.1493123e+00, 1.1496085e+00, 1.1499047e+00, 1.1502011e+00,
   1.1504977e+00, 1.1507943e+00, 1.1510910e+00, 1.1513877e+00,
   1.1516846e+00, 1.1519816e+00, 1.1522788e+00, 1.1525760e+00,
   1.1528733e+00, 1.1531707e+00, 1.1534683e+00, 1.1537658e+00,
   1.1540636e+00, 1.1543614e+00, 1.1546593e+00, 1.1549573e+00,
   1.1552554e+00, 1.1555537e+00, 1.1558520e+00, 1.1561505e+00,
   1.1564490e+00, 1.1567476e+00, 1.1570463e+00, 1.1573452e+00,
   1.1576442e+00, 1.1579432e+00, 1.1582423e+00, 1.1585417e+00,
   1.1588410e+00, 1.1591405e+00, 1.1594400e+00, 1.1597397e+00,
   1.1600395e+00, 1.1603394e+00, 1.1606394e+00, 1.1609395e+00,
   1.1612397e+00, 1.1615400e+00, 1.1618404e+00, 1.1621410e+00,
   1.1624415e+00, 1.1627423e+00, 1.1630431e+00, 1.1633440e+00,
   1.1636450e+00, 1.1639463e+00, 1.1642475e+00, 1.1645489e+00,
   1.1648504e+00, 1.1651518e+00, 1.1654536e+00, 1.1657554e+00,
   1.1660572e+00, 1.1663592e+00, 1.1666613e+00, 1.1669636e+00,
   1.1672659e+00, 1.1675682e+00, 1.1678708e+00, 1.1681734e+00,
   1.1684762e+00, 1.1687790e+00, 1.1690819e+00, 1.1693851e+00,
   1.1696882e+00, 1.1699915e+00, 1.1702949e+00, 1.1705984e+00,
   1.1709020e+00, 1.1712056e+00, 1.1715095e+00, 1.1718134e+00,
   1.1721175e+00, 1.1724216e+00, 1.1727258e+00, 1.1730303e+00,
   1.1733347e+00, 1.1736393e+00, 1.1739439e+00, 1.1742487e+00,
   1.1745536e+00, 1.1748587e+00, 1.1751637e+00, 1.1754690e+00,
   1.1757743e+00, 1.1760798e+00, 1.1763854e+00, 1.1766911e+00,
   1.1769968e+00, 1.1773027e+00, 1.1776087e+00, 1.1779149e+00,
   1.1782210e+00, 1.1785274e+00, 1.1788338e+00, 1.1791403e+00,
   1.1794471e+00, 1.1797538e+00, 1.1800607e+00, 1.1803677e+00,
   1.1806748e+00, 1.1809820e+00, 1.1812893e+00, 1.1815968e+00,
   1.1819043e+00, 1.1822120e+00, 1.1825198e+00, 1.1828277e+00,
   1.1831357e+00, 1.1834438e+00, 1.1837521e+00, 1.1840603e+00,
   1.1843688e+00, 1.1846774e+00, 1.1849861e+00, 1.1852949e+00,
   1.1856037e+00, 1.1859128e+00, 1.1862220e+00, 1.1865312e+00,
   1.1868405e+00, 1.1871500e+00, 1.1874596e+00, 1.1877693e+00,
   1.1880791e+00, 1.1883891e+00, 1.1886991e+00, 1.1890092e+00,
   1.1893195e+00, 1.1896299e+00, 1.1899403e+00, 1.1902510e+00,
   1.1905618e+00, 1.1908726e+00, 1.1911836e+00, 1.1914946e+00,
   1.1918058e+00, 1.1921171e+00, 1.1924285e+00, 1.1927401e+00,
   1.1930517e+00, 1.1933634e+00, 1.1936754e+00, 1.1939874e+00,
   1.1942995e+00, 1.1946117e+00, 1.1949241e+00, 1.1952366e+00,
   1.1955491e+00, 1.1958618e+00, 1.1961746e+00, 1.1964875e+00,
   1.1968006e+00, 1.1971138e+00, 1.1974270e+00, 1.1977404e+00,
   1.1980540e+00, 1.1983676e+00, 1.1986814e+00, 1.1989952e+00,
   1.1993092e+00, 1.1996233e+00, 1.1999376e+00, 1.2002519e+00,
   1.2005664e+00, 1.2008810e+00, 1.2011957e+00, 1.2015105e+00,
   1.2018255e+00, 1.2021406e+00, 1.2024558e+00, 1.2027711e+00,
   1.2030865e+00, 1.2034019e+00, 1.2037176e+00, 1.2040334e+00,
   1.2043493e+00, 1.2046653e+00, 1.2049814e+00, 1.2052977e+00,
   1.2056141e+00, 1.2059306e+00, 1.2062472e+00, 1.2065639e+00,
   1.2068808e+00, 1.2071979e+00, 1.2075150e+00, 1.2078322e+00,
   1.2081496e+00, 1.2084670e+00, 1.2087846e+00, 1.2091023e+00,
   1.2094202e+00, 1.2097381e+00, 1.2100562e+00, 1.2103744e+00,
   1.2106928e+00, 1.2110112e+00, 1.2113298e+00, 1.2116485e+00,
   1.2119672e+00, 1.2122862e+00, 1.2126052e+00, 1.2129245e+00,
   1.2132438e+00, 1.2135632e+00, 1.2138828e+00, 1.2142025e+00,
   1.2145222e+00, 1.2148422e+00, 1.2151623e+00, 1.2154825e+00,
   1.2158028e+00, 1.2161232e+00, 1.2164438e+00, 1.2167645e+00,
   1.2170852e+00, 1.2174062e+00, 1.2177273e+00, 1.2180485e+00,
   1.2183697e+00, 1.2186912e+00, 1.2190127e+00, 1.2193345e+00,
   1.2196562e+00, 1.2199782e+00, 1.2203002e+00, 1.2206224e+00,
   1.2209448e+00, 1.2212672e+00, 1.2215898e+00, 1.2219125e+00,
   1.2222353e+00, 1.2225583e+00, 1.2228813e+00, 1.2232046e+00,
   1.2235279e+00, 1.2238513e+00, 1.2241750e+00, 1.2244986e+00,
   1.2248225e+00, 1.2251465e+00, 1.2254707e+00, 1.2257949e+00,
   1.2261193e+00, 1.2264438e+00, 1.2267684e+00, 1.2270931e+00,
   1.2274179e+00, 1.2277430e+00, 1.2280681e+00, 1.2283934e+00,
   1.2287189e+00, 1.2290443e+00, 1.2293700e+00, 1.2296958e+00,
   1.2300217e+00, 1.2303478e+00, 1.2306740e+00, 1.2310003e+00,
   1.2313267e+00, 1.2316533e+00, 1.2319801e+00, 1.2323068e+00,
   1.2326338e+00, 1.2329609e+00, 1.2332882e+00, 1.2336155e+00,
   1.2339431e+00, 1.2342707e+00, 1.2345985e+00, 1.2349263e+00,
   1.2352544e+00, 1.2355826e+00, 1.2359109e+00, 1.2362393e+00,
   1.2365679e+00, 1.2368965e+00, 1.2372254e+00, 1.2375543e+00,
   1.2378834e+00, 1.2382127e+00, 1.2385421e+00, 1.2388716e+00,
   1.2392012e+00, 1.2395309e+00, 1.2398609e+00, 1.2401909e+00,
   1.2405211e+00, 1.2408514e+00, 1.2411819e+00, 1.2415124e+00,
   1.2418431e+00, 1.2421740e+00, 1.2425050e+00, 1.2428361e+00,
   1.2431674e+00, 1.2434988e+00, 1.2438303e+00, 1.2441620e+00,
   1.2444938e+00, 1.2448257e+00, 1.2451578e+00, 1.2454901e+00,
   1.2458224e+00, 1.2461549e+00, 1.2464876e+00, 1.2468203e+00,
   1.2471533e+00, 1.2474864e+00, 1.2478195e+00, 1.2481529e+00,
   1.2484863e+00, 1.2488198e+00, 1.2491536e+00, 1.2494875e+00,
   1.2498215e+00, 1.2501557e+00, 1.2504900e+00, 1.2508245e+00,
   1.2511591e+00, 1.2514937e+00, 1.2518286e+00, 1.2521636e+00,
   1.2524987e+00, 1.2528341e+00, 1.2531694e+00, 1.2535050e+00,
   1.2538407e+00, 1.2541766e+00, 1.2545125e+00, 1.2548487e+00,
   1.2551850e+00, 1.2555214e+00, 1.2558579e+00, 1.2561946e+00,
   1.2565315e+00, 1.2568685e+00, 1.2572056e+00, 1.2575428e+00,
   1.2578802e+00, 1.2582178e+00, 1.2585555e+00, 1.2588934e+00,
   1.2592313e+00, 1.2595695e+00, 1.2599077e+00, 1.2602462e+00,
   1.2605847e+00, 1.2609235e+00, 1.2612623e+00, 1.2616013e+00,
   1.2619405e+00, 1.2622797e+00, 1.2626191e+00, 1.2629588e+00,
   1.2632985e+00, 1.2636384e+00, 1.2639784e+00, 1.2643185e+00,
   1.2646588e+00, 1.2649993e+00, 1.2653399e+00, 1.2656807e+00,
   1.2660215e+00, 1.2663625e+00, 1.2667037e+00, 1.2670451e+00,
   1.2673866e+00, 1.2677282e+00, 1.2680700e+00, 1.2684120e+00,
   1.2687540e+00, 1.2690963e+00, 1.2694386e+00, 1.2697811e+00,
   1.2701238e+00, 1.2704667e+00, 1.2708097e+00, 1.2711527e+00,
   1.2714961e+00, 1.2718394e+00, 1.2721829e+00, 1.2725267e+00,
   1.2728705e+00, 1.2732146e+00, 1.2735587e+00, 1.2739031e+00,
   1.2742475e+00, 1.2745922e+00, 1.2749370e+00, 1.2752819e+00,
   1.2756270e+00, 1.2759722e+00, 1.2763176e+00, 1.2766632e+00,
   1.2770089e+00, 1.2773547e+00, 1.2777007e+00, 1.2780468e+00,
   1.2783931e+00, 1.2787396e+00, 1.2790862e+00, 1.2794330e+00,
   1.2797799e+00, 1.2801269e+00, 1.2804742e+00, 1.2808216e+00,
   1.2811691e+00, 1.2815168e+00, 1.2818646e+00, 1.2822126e+00,
   1.2825608e+00, 1.2829090e+00, 1.2832576e+00, 1.2836062e+00,
   1.2839550e+00, 1.2843039e+00, 1.2846529e+00, 1.2850022e+00,
   1.2853516e+00, 1.2857012e+00, 1.2860509e+00, 1.2864008e+00,
   1.2867508e+00, 1.2871010e+00, 1.2874514e+00, 1.2878019e+00,
   1.2881526e+00, 1.2885034e+00, 1.2888544e+00, 1.2892054e+00,
   1.2895567e+00, 1.2899083e+00, 1.2902598e+00, 1.2906116e+00,
   1.2909635e+00, 1.2913157e+00, 1.2916679e+00, 1.2920203e+00,
   1.2923729e+00, 1.2927257e+00, 1.2930785e+00, 1.2934316e+00,
   1.2937849e+00, 1.2941382e+00, 1.2944918e+00, 1.2948455e+00,
   1.2951994e+00, 1.2955534e+00, 1.2959076e+00, 1.2962619e+00,
   1.2966164e+00, 1.2969712e+00, 1.2973260e+00, 1.2976810e+00,
   1.2980362e+00, 1.2983915e+00, 1.2987471e+00, 1.2991027e+00,
   1.2994585e+00, 1.2998145e+00, 1.3001707e+00, 1.3005270e+00,
   1.3008835e+00, 1.3012401e+00, 1.3015970e+00, 1.3019539e+00,
   1.3023111e+00, 1.3026685e+00, 1.3030258e+00, 1.3033836e+00,
   1.3037413e+00, 1.3040993e+00, 1.3044575e+00, 1.3048158e+00,
   1.3051744e+00, 1.3055329e+00, 1.3058918e+00, 1.3062508e+00,
   1.3066100e+00, 1.3069693e+00, 1.3073288e+00, 1.3076885e+00,
   1.3080482e+00, 1.3084083e+00, 1.3087685e+00, 1.3091288e+00,
   1.3094894e+00, 1.3098500e+00, 1.3102108e+00, 1.3105719e+00,
   1.3109331e+00, 1.3112944e+00, 1.3116560e+00, 1.3120177e+00,
   1.3123796e+00, 1.3127416e+00, 1.3131039e+00, 1.3134663e+00,
   1.3138288e+00, 1.3141916e+00, 1.3145545e+00, 1.3149176e+00,
   1.3152809e+00, 1.3156443e+00, 1.3160079e+00, 1.3163717e+00,
   1.3167356e+00, 1.3170998e+00, 1.3174641e+00, 1.3178285e+00,
   1.3181932e+00, 1.3185581e+00, 1.3189231e+00, 1.3192883e+00,
   1.3196536e+00, 1.3200191e+00, 1.3203849e+00, 1.3207508e+00,
   1.3211168e+00, 1.3214831e+00, 1.3218495e+00, 1.3222162e+00,
   1.3225830e+00, 1.3229499e+00, 1.3233171e+00, 1.3236843e+00,
   1.3240519e+00, 1.3244195e+00, 1.3247874e+00, 1.3251554e+00,
   1.3255236e+00, 1.3258920e+00, 1.3262606e+00, 1.3266293e+00,
   1.3269982e+00, 1.3273673e+00, 1.3277366e+00, 1.3281060e+00,
   1.3284757e+00, 1.3288456e+00, 1.3292155e+00, 1.3295858e+00,
   1.3299562e+00, 1.3303267e+00, 1.3306974e+00, 1.3310684e+00,
   1.3314395e+00, 1.3318108e+00, 1.3321823e+00, 1.3325540e+00,
   1.3329258e+00, 1.3332978e+00, 1.3336700e+00, 1.3340424e+00,
   1.3344151e+00, 1.3347878e+00, 1.3351607e+00, 1.3355340e+00,
   1.3359072e+00, 1.3362808e+00, 1.3366544e+00, 1.3370284e+00,
   1.3374025e+00, 1.3377767e+00, 1.3381511e+00, 1.3385258e+00,
   1.3389006e+00, 1.3392756e+00, 1.3396509e+00, 1.3400263e+00,
   1.3404018e+00, 1.3407776e+00, 1.3411535e+00, 1.3415297e+00,
   1.3419061e+00, 1.3422825e+00, 1.3426592e+00, 1.3430362e+00,
   1.3434132e+00, 1.3437905e+00, 1.3441681e+00, 1.3445457e+00,
   1.3449236e+00, 1.3453016e+00, 1.3456799e+00, 1.3460584e+00,
   1.3464370e+00, 1.3468158e+00, 1.3471949e+00, 1.3475741e+00,
   1.3479534e+00, 1.3483331e+00, 1.3487129e+00, 1.3490928e+00,
   1.3494731e+00, 1.3498535e+00, 1.3502340e+00, 1.3506148e+00,
   1.3509958e+00, 1.3513770e+00, 1.3517584e+00, 1.3521399e+00,
   1.3525217e+00, 1.3529036e+00, 1.3532858e+00, 1.3536681e+00,
   1.3540506e+00, 1.3544334e+00, 1.3548163e+00, 1.3551995e+00,
   1.3555828e+00, 1.3559663e+00, 1.3563502e+00, 1.3567340e+00,
   1.3571182e+00, 1.3575026e+00, 1.3578871e+00, 1.3582718e+00,
   1.3586568e+00, 1.3590419e+00, 1.3594273e+00, 1.3598129e+00,
   1.3601986e+00, 1.3605845e+00, 1.3609707e+00, 1.3613571e+00,
   1.3617436e+00, 1.3621304e+00, 1.3625174e+00, 1.3629045e+00,
   1.3632919e+00, 1.3636795e+00, 1.3640673e+00, 1.3644553e+00,
   1.3648435e+00, 1.3652319e+00, 1.3656205e+00, 1.3660094e+00,
   1.3663983e+00, 1.3667876e+00, 1.3671770e+00, 1.3675667e+00,
   1.3679565e+00, 1.3683466e+00, 1.3687369e+00, 1.3691274e+00,
   1.3695180e+00, 1.3699089e+00, 1.3703001e+00, 1.3706913e+00,
   1.3710829e+00, 1.3714746e+00, 1.3718666e+00, 1.3722587e+00,
   1.3726511e+00, 1.3730437e+00, 1.3734365e+00, 1.3738295e+00,
   1.3742226e+00, 1.3746161e+00, 1.3750098e+00, 1.3754036e+00,
   1.3757976e+00, 1.3761920e+00, 1.3765864e+00, 1.3769811e+00,
   1.3773761e+00, 1.3777713e+00, 1.3781666e+00, 1.3785622e+00,
   1.3789580e+00, 1.3793540e+00, 1.3797501e+00, 1.3801466e+00,
   1.3805432e+00, 1.3809402e+00, 1.3813373e+00, 1.3817345e+00,
   1.3821321e+00, 1.3825299e+00, 1.3829278e+00, 1.3833259e+00,
   1.3837243e+00, 1.3841230e+00, 1.3845218e+00, 1.3849208e+00,
   1.3853202e+00, 1.3857197e+00, 1.3861194e+00, 1.3865193e+00,
   1.3869195e+00, 1.3873199e+00, 1.3877205e+00, 1.3881214e+00,
   1.3885224e+00, 1.3889236e+00, 1.3893251e+00, 1.3897269e+00,
   1.3901289e+00, 1.3905311e+00, 1.3909335e+00, 1.3913361e+00,
   1.3917389e+00, 1.3921421e+00, 1.3925453e+00, 1.3929489e+00,
   1.3933526e+00, 1.3937566e+00, 1.3941609e+00, 1.3945652e+00,
   1.3949699e+00, 1.3953749e+00, 1.3957800e+00, 1.3961853e+00,
   1.3965909e+00, 1.3969967e+00, 1.3974028e+00, 1.3978090e+00,
   1.3982155e+00, 1.3986223e+00, 1.3990293e+00, 1.3994365e+00,
   1.3998439e+00, 1.4002516e+00, 1.4006594e+00, 1.4010676e+00,
   1.4014760e+00, 1.4018846e+00, 1.4022934e+00, 1.4027026e+00,
   1.4031118e+00, 1.4035214e+00, 1.4039311e+00, 1.4043411e+00,
   1.4047514e+00, 1.4051619e+00, 1.4055727e+00, 1.4059836e+00,
   1.4063947e+00, 1.4068062e+00, 1.4072179e+00, 1.4076297e+00,
   1.4080420e+00, 1.4084543e+00, 1.4088670e+00, 1.4092798e+00,
   1.4096929e+00, 1.4101063e+00, 1.4105198e+00, 1.4109337e+00,
   1.4113477e+00, 1.4117621e+00, 1.4121766e+00, 1.4125915e+00,
   1.4130065e+00, 1.4134218e+00, 1.4138373e+00, 1.4142531e+00,
   1.4146692e+00, 1.4150854e+00, 1.4155020e+00, 1.4159187e+00,
   1.4163357e+00, 1.4167529e+00, 1.4171704e+00, 1.4175881e+00,
   1.4180062e+00, 1.4184244e+00, 1.4188429e+00, 1.4192616e+00,
   1.4196806e+00, 1.4200999e+00, 1.4205194e+00, 1.4209391e+00,
   1.4213591e+00, 1.4217793e+00, 1.4221997e+00, 1.4226205e+00,
   1.4230415e+00, 1.4234627e+00, 1.4238843e+00, 1.4243060e+00,
   1.4247280e+00, 1.4251503e+00, 1.4255728e+00, 1.4259956e+00,
   1.4264185e+00, 1.4268419e+00, 1.4272654e+00, 1.4276892e+00,
   1.4281132e+00, 1.4285375e+00, 1.4289621e+00, 1.4293869e+00,
   1.4298120e+00, 1.4302373e+00, 1.4306629e+00, 1.4310887e+00,
   1.4315149e+00, 1.4319413e+00, 1.4323678e+00, 1.4327947e+00,
   1.4332219e+00, 1.4336493e+00, 1.4340770e+00, 1.4345050e+00,
   1.4349332e+00, 1.4353616e+00, 1.4357903e+00, 1.4362193e+00,
   1.4366486e+00, 1.4370781e+00, 1.4375079e+00, 1.4379380e+00,
   1.4383683e+00, 1.4387989e+00, 1.4392297e+00, 1.4396608e+00,
   1.4400922e+00, 1.4405239e+00, 1.4409558e+00, 1.4413880e+00,
   1.4418205e+00, 1.4422532e+00, 1.4426862e+00, 1.4431195e+00,
   1.4435530e+00, 1.4439869e+00, 1.4444209e+00, 1.4448553e+00,
   1.4452900e+00, 1.4457248e+00, 1.4461601e+00, 1.4465954e+00,
   1.4470313e+00, 1.4474672e+00, 1.4479035e+00, 1.4483401e+00,
   1.4487768e+00, 1.4492140e+00, 1.4496514e+00, 1.4500890e+00,
   1.4505270e+00, 1.4509652e+00, 1.4514037e+00, 1.4518424e+00,
   1.4522815e+00, 1.4527209e+00, 1.4531605e+00, 1.4536004e+00,
   1.4540405e+00, 1.4544810e+00, 1.4549217e+00, 1.4553628e+00,
   1.4558041e+00, 1.4562457e+00, 1.4566876e+00, 1.4571297e+00,
   1.4575722e+00, 1.4580150e+00, 1.4584579e+00, 1.4589013e+00,
   1.4593449e+00, 1.4597887e+00, 1.4602329e+00, 1.4606774e+00,
   1.4611222e+00, 1.4615672e+00, 1.4620124e+00, 1.4624581e+00,
   1.4629040e+00, 1.4633502e+00, 1.4637966e+00, 1.4642434e+00,
   1.4646906e+00, 1.4651378e+00, 1.4655856e+00, 1.4660335e+00,
   1.4664818e+00, 1.4669303e+00, 1.4673791e+00, 1.4678283e+00,
   1.4682777e+00, 1.4687275e+00, 1.4691775e+00, 1.4696277e+00,
   1.4700783e+00, 1.4705293e+00, 1.4709805e+00, 1.4714320e+00,
   1.4718839e+00, 1.4723359e+00, 1.4727883e+00, 1.4732411e+00,
   1.4736941e+00, 1.4741474e+00, 1.4746010e+00, 1.4750550e+00,
   1.4755093e+00, 1.4759638e+00, 1.4764186e+00, 1.4768738e+00,
   1.4773293e+00, 1.4777850e+00, 1.4782411e+00, 1.4786974e+00,
   1.4791541e+00, 1.4796112e+00, 1.4800684e+00, 1.4805261e+00,
   1.4809840e+00, 1.4814422e+00, 1.4819008e+00, 1.4823596e+00,
   1.4828188e+00, 1.4832783e+00, 1.4837381e+00, 1.4841982e+00,
   1.4846586e+00, 1.4851193e+00, 1.4855804e+00, 1.4860418e+00,
   1.4865035e+00, 1.4869655e+00, 1.4874278e+00, 1.4878905e+00,
   1.4883534e+00, 1.4888167e+00, 1.4892803e+00, 1.4897442e+00,
   1.4902085e+00, 1.4906731e+00, 1.4911379e+00, 1.4916031e+00,
   1.4920686e+00, 1.4925345e+00, 1.4930006e+00, 1.4934672e+00,
   1.4939340e+00, 1.4944011e+00, 1.4948686e+00, 1.4953364e+00,
   1.4958045e+00, 1.4962730e+00, 1.4967418e+00, 1.4972110e+00,
   1.4976804e+00, 1.4981502e+00, 1.4986203e+00, 1.4990907e+00,
   1.4995615e+00, 1.5000327e+00, 1.5005040e+00, 1.5009758e+00,
   1.5014479e+00, 1.5019203e+00, 1.5023931e+00, 1.5028663e+00,
   1.5033398e+00, 1.5038135e+00, 1.5042876e+00, 1.5047621e+00,
   1.5052369e+00, 1.5057120e+00, 1.5061876e+00, 1.5066633e+00,
   1.5071396e+00, 1.5076160e+00, 1.5080929e+00, 1.5085701e+00,
   1.5090476e+00, 1.5095254e+00, 1.5100037e+00, 1.5104823e+00,
   1.5109612e+00, 1.5114404e+00, 1.5119201e+00, 1.5124000e+00,
   1.5128803e+00, 1.5133610e+00, 1.5138420e+00, 1.5143234e+00,
   1.5148051e+00, 1.5152872e+00, 1.5157695e+00, 1.5162523e+00,
   1.5167354e+00, 1.5172189e+00, 1.5177027e+00, 1.5181869e+00,
   1.5186715e+00, 1.5191563e+00, 1.5196416e+00, 1.5201272e+00,
   1.5206132e+00, 1.5210996e+00, 1.5215862e+00, 1.5220733e+00,
   1.5225607e+00, 1.5230485e+00, 1.5235366e+00, 1.5240251e+00,
   1.5245140e+00, 1.5250032e+00, 1.5254928e+00, 1.5259827e+00,
   1.5264730e+00, 1.5269638e+00, 1.5274549e+00, 1.5279462e+00,
   1.5284381e+00, 1.5289302e+00, 1.5294228e+00, 1.5299157e+00,
   1.5304090e+00, 1.5309026e+00, 1.5313966e+00, 1.5318911e+00,
   1.5323858e+00, 1.5328810e+00, 1.5333766e+00, 1.5338725e+00,
   1.5343688e+00, 1.5348654e+00, 1.5353625e+00, 1.5358598e+00,
   1.5363576e+00, 1.5368558e+00, 1.5373545e+00, 1.5378534e+00,
   1.5383527e+00, 1.5388525e+00, 1.5393525e+00, 1.5398530e+00,
   1.5403539e+00, 1.5408552e+00, 1.5413568e+00, 1.5418588e+00,
   1.5423613e+00, 1.5428641e+00, 1.5433673e+00, 1.5438708e+00,
   1.5443748e+00, 1.5448792e+00, 1.5453839e+00, 1.5458891e+00,
   1.5463947e+00, 1.5469006e+00, 1.5474070e+00, 1.5479138e+00,
   1.5484209e+00, 1.5489284e+00, 1.5494363e+00, 1.5499448e+00,
   1.5504534e+00, 1.5509626e+00, 1.5514722e+00, 1.5519822e+00,
   1.5524925e+00, 1.5530032e+00, 1.5535144e+00, 1.5540260e+00,
   1.5545379e+00, 1.5550504e+00, 1.5555631e+00, 1.5560763e+00,
   1.5565900e+00, 1.5571040e+00, 1.5576184e+00, 1.5581332e+00,
   1.5586486e+00, 1.5591642e+00, 1.5596803e+00, 1.5601968e+00,
   1.5607138e+00, 1.5612311e+00, 1.5617489e+00, 1.5622671e+00,
   1.5627856e+00, 1.5633047e+00, 1.5638241e+00, 1.5643439e+00,
   1.5648643e+00, 1.5653850e+00, 1.5659060e+00, 1.5664277e+00,
   1.5669496e+00, 1.5674721e+00, 1.5679950e+00, 1.5685182e+00,
   1.5690418e+00, 1.5695660e+00, 1.5700905e+00, 1.5706155e+00,
   1.5711410e+00, 1.5716668e+00, 1.5721931e+00, 1.5727199e+00,
   1.5732471e+00, 1.5737747e+00, 1.5743027e+00, 1.5748312e+00,
   1.5753602e+00, 1.5758895e+00, 1.5764194e+00, 1.5769496e+00,
   1.5774803e+00, 1.5780114e+00, 1.5785429e+00, 1.5790750e+00,
   1.5796075e+00, 1.5801405e+00, 1.5806738e+00, 1.5812076e+00,
   1.5817419e+00, 1.5822767e+00, 1.5828118e+00, 1.5833474e+00,
   1.5838836e+00, 1.5844201e+00, 1.5849571e+00, 1.5854946e+00,
   1.5860325e+00, 1.5865709e+00, 1.5871097e+00, 1.5876490e+00,
   1.5881888e+00, 1.5887290e+00, 1.5892698e+00, 1.5898108e+00,
   1.5903525e+00, 1.5908946e+00, 1.5914371e+00, 1.5919802e+00,
   1.5925237e+00, 1.5930676e+00, 1.5936121e+00, 1.5941570e+00,
   1.5947024e+00, 1.5952482e+00, 1.5957946e+00, 1.5963414e+00,
   1.5968887e+00, 1.5974364e+00, 1.5979847e+00, 1.5985334e+00,
   1.5990826e+00, 1.5996323e+00, 1.6001825e+00, 1.6007332e+00,
   1.6012843e+00, 1.6018360e+00, 1.6023880e+00, 1.6029407e+00,
   1.6034938e+00, 1.6040474e+00, 1.6046015e+00, 1.6051561e+00,
   1.6057111e+00, 1.6062666e+00, 1.6068227e+00, 1.6073793e+00,
   1.6079364e+00, 1.6084939e+00, 1.6090519e+00, 1.6096106e+00,
   1.6101696e+00, 1.6107291e+00, 1.6112893e+00, 1.6118498e+00,
   1.6124109e+00, 1.6129725e+00, 1.6135346e+00, 1.6140972e+00,
   1.6146603e+00, 1.6152240e+00, 1.6157881e+00, 1.6163528e+00,
   1.6169180e+00, 1.6174836e+00, 1.6180499e+00, 1.6186166e+00,
   1.6191839e+00, 1.6197516e+00, 1.6203200e+00, 1.6208887e+00,
   1.6214581e+00, 1.6220280e+00, 1.6225984e+00, 1.6231693e+00,
   1.6237408e+00, 1.6243128e+00, 1.6248852e+00, 1.6254584e+00,
   1.6260319e+00, 1.6266060e+00, 1.6271807e+00, 1.6277559e+00,
   1.6283317e+00, 1.6289079e+00, 1.6294848e+00, 1.6300621e+00,
   1.6306400e+00, 1.6312184e+00, 1.6317974e+00, 1.6323770e+00,
   1.6329571e+00, 1.6335378e+00, 1.6341189e+00, 1.6347007e+00,
   1.6352830e+00, 1.6358658e+00, 1.6364492e+00, 1.6370332e+00,
   1.6376177e+00, 1.6382028e+00, 1.6387885e+00, 1.6393747e+00,
   1.6399615e+00, 1.6405488e+00, 1.6411368e+00, 1.6417252e+00,
   1.6423142e+00, 1.6429038e+00, 1.6434940e+00, 1.6440848e+00,
   1.6446761e+00, 1.6452681e+00, 1.6458606e+00, 1.6464536e+00,
   1.6470473e+00, 1.6476414e+00, 1.6482363e+00, 1.6488316e+00,
   1.6494277e+00, 1.6500242e+00, 1.6506214e+00, 1.6512191e+00,
   1.6518174e+00, 1.6524163e+00, 1.6530159e+00, 1.6536160e+00,
   1.6542166e+00, 1.6548179e+00, 1.6554199e+00, 1.6560224e+00,
   1.6566255e+00, 1.6572292e+00, 1.6578336e+00, 1.6584384e+00,
   1.6590440e+00, 1.6596501e+00, 1.6602569e+00, 1.6608642e+00,
   1.6614722e+00, 1.6620808e+00, 1.6626899e+00, 1.6632998e+00,
   1.6639103e+00, 1.6645213e+00, 1.6651330e+00, 1.6657453e+00,
   1.6663582e+00, 1.6669718e+00, 1.6675860e+00, 1.6682007e+00,
   1.6688162e+00, 1.6694323e+00, 1.6700491e+00, 1.6706663e+00,
   1.6712843e+00, 1.6719030e+00, 1.6725223e+00, 1.6731422e+00,
   1.6737627e+00, 1.6743839e+00, 1.6750058e+00, 1.6756283e+00,
   1.6762514e+00, 1.6768752e+00, 1.6774997e+00, 1.6781248e+00,
   1.6787505e+00, 1.6793770e+00, 1.6800040e+00, 1.6806318e+00,
   1.6812601e+00, 1.6818892e+00, 1.6825190e+00, 1.6831493e+00,
   1.6837804e+00, 1.6844121e+00, 1.6850445e+00, 1.6856776e+00,
   1.6863114e+00, 1.6869458e+00, 1.6875809e+00, 1.6882168e+00,
   1.6888533e+00, 1.6894904e+00, 1.6901283e+00, 1.6907668e+00,
   1.6914060e+00, 1.6920460e+00, 1.6926867e+00, 1.6933279e+00,
   1.6939700e+00, 1.6946126e+00, 1.6952561e+00, 1.6959002e+00,
   1.6965450e+00, 1.6971905e+00, 1.6978368e+00, 1.6984837e+00,
   1.6991314e+00, 1.6997797e+00, 1.7004288e+00, 1.7010787e+00,
   1.7017292e+00, 1.7023804e+00, 1.7030324e+00, 1.7036850e+00,
   1.7043386e+00, 1.7049927e+00, 1.7056475e+00, 1.7063031e+00,
   1.7069595e+00, 1.7076166e+00, 1.7082744e+00, 1.7089329e+00,
   1.7095922e+00, 1.7102523e+00, 1.7109131e+00, 1.7115746e+00,
   1.7122369e+00, 1.7128999e+00, 1.7135637e+00, 1.7142283e+00,
   1.7148936e+00, 1.7155596e+00, 1.7162265e+00, 1.7168940e+00,
   1.7175624e+00, 1.7182316e+00, 1.7189014e+00, 1.7195721e+00,
   1.7202436e+00, 1.7209158e+00, 1.7215887e+00, 1.7222625e+00,
   1.7229371e+00, 1.7236124e+00, 1.7242886e+00, 1.7249656e+00,
   1.7256433e+00, 1.7263217e+00, 1.7270011e+00, 1.7276812e+00,
   1.7283621e+00, 1.7290437e+00, 1.7297263e+00, 1.7304096e+00,
   1.7310936e+00, 1.7317786e+00, 1.7324644e+00, 1.7331510e+00,
   1.7338383e+00, 1.7345265e+00, 1.7352155e+00, 1.7359054e+00,
   1.7365961e+00, 1.7372876e+00, 1.7379799e+00, 1.7386731e+00,
   1.7393671e+00, 1.7400620e+00, 1.7407576e+00, 1.7414541e+00,
   1.7421515e+00, 1.7428498e+00, 1.7435489e+00, 1.7442487e+00,
   1.7449496e+00, 1.7456512e+00, 1.7463537e+00, 1.7470571e+00,
   1.7477614e+00, 1.7484664e+00, 1.7491723e+00, 1.7498792e+00,
   1.7505870e+00, 1.7512956e+00, 1.7520050e+00, 1.7527153e+00,
   1.7534267e+00, 1.7541387e+00, 1.7548518e+00, 1.7555658e+00,
   1.7562805e+00, 1.7569963e+00, 1.7577128e+00, 1.7584304e+00,
   1.7591488e+00, 1.7598681e+00, 1.7605884e+00, 1.7613095e+00,
   1.7620316e+00, 1.7627546e+00, 1.7634785e+00, 1.7642033e+00,
   1.7649292e+00, 1.7656559e+00, 1.7663834e+00, 1.7671120e+00,
   1.7678416e+00, 1.7685720e+00, 1.7693034e+00, 1.7700357e+00,
   1.7707690e+00, 1.7715033e+00, 1.7722385e+00, 1.7729746e+00,
   1.7737118e+00, 1.7744499e+00, 1.7751889e+00, 1.7759290e+00,
   1.7766700e+00, 1.7774119e+00, 1.7781550e+00, 1.7788988e+00,
   1.7796438e+00, 1.7803898e+00, 1.7811366e+00, 1.7818846e+00,
   1.7826334e+00, 1.7833834e+00, 1.7841343e+00, 1.7848862e+00,
   1.7856392e+00, 1.7863930e+00, 1.7871480e+00, 1.7879040e+00,
   1.7886610e+00, 1.7894191e+00, 1.7901781e+00, 1.7909381e+00,
   1.7916993e+00, 1.7924615e+00, 1.7932247e+00, 1.7939889e+00,
   1.7947543e+00, 1.7955205e+00, 1.7962880e+00, 1.7970564e+00,
   1.7978261e+00, 1.7985966e+00, 1.7993683e+00, 1.8001410e+00,
   1.8009149e+00, 1.8016897e+00, 1.8024657e+00, 1.8032428e+00,
   1.8040210e+00, 1.8048003e+00, 1.8055806e+00, 1.8063620e+00,
   1.8071445e+00, 1.8079282e+00, 1.8087131e+00, 1.8094989e+00,
   1.8102859e+00, 1.8110740e+00, 1.8118633e+00, 1.8126537e+00,
   1.8134452e+00, 1.8142380e+00, 1.8150318e+00, 1.8158267e+00,
   1.8166227e+00, 1.8174200e+00, 1.8182185e+00, 1.8190180e+00,
   1.8198187e+00, 1.8206207e+00, 1.8214238e+00, 1.8222280e+00,
   1.8230335e+00, 1.8238400e+00, 1.8246478e+00, 1.8254569e+00,
   1.8262670e+00, 1.8270785e+00, 1.8278910e+00, 1.8287048e+00,
   1.8295199e+00, 1.8303361e+00, 1.8311535e+00, 1.8319722e+00,
   1.8327922e+00, 1.8336133e+00, 1.8344357e+00, 1.8352593e+00,
   1.8360841e+00, 1.8369104e+00, 1.8377377e+00, 1.8385663e+00,
   1.8393962e+00, 1.8402274e+00, 1.8410599e+00, 1.8418936e+00,
   1.8427286e+00, 1.8435649e+00, 1.8444026e+00, 1.8452414e+00,
   1.8460816e+00, 1.8469231e+00, 1.8477658e+00, 1.8486099e+00,
   1.8494554e+00, 1.8503022e+00, 1.8511503e+00, 1.8519996e+00,
   1.8528504e+00, 1.8537025e+00, 1.8545560e+00, 1.8554108e+00,
   1.8562670e+00, 1.8571244e+00, 1.8579834e+00, 1.8588436e+00,
   1.8597052e+00, 1.8605683e+00, 1.8614327e+00, 1.8622985e+00,
   1.8631657e+00, 1.8640343e+00, 1.8649043e+00, 1.8657757e+00,
   1.8666486e+00, 1.8675228e+00, 1.8683985e+00, 1.8692757e+00,
   1.8701543e+00, 1.8710344e+00, 1.8719158e+00, 1.8727987e+00,
   1.8736831e+00, 1.8745691e+00, 1.8754563e+00, 1.8763452e+00,
   1.8772354e+00, 1.8781272e+00, 1.8790206e+00, 1.8799154e+00,
   1.8808116e+00, 1.8817095e+00, 1.8826088e+00, 1.8835096e+00,
   1.8844121e+00, 1.8853159e+00, 1.8862214e+00, 1.8871284e+00,
   1.8880370e+00, 1.8889471e+00, 1.8898588e+00, 1.8907721e+00,
   1.8916869e+00, 1.8926034e+00, 1.8935214e+00, 1.8944410e+00,
   1.8953623e+00, 1.8962852e+00, 1.8972095e+00, 1.8981357e+00,
   1.8990633e+00, 1.8999927e+00, 1.9009237e+00, 1.9018564e+00,
   1.9027907e+00, 1.9037267e+00, 1.9046643e+00, 1.9056036e+00,
   1.9065447e+00, 1.9074874e+00, 1.9084318e+00, 1.9093778e+00,
   1.9103256e+00, 1.9112751e+00, 1.9122264e+00, 1.9131794e+00,
   1.9141341e+00, 1.9150907e+00, 1.9160489e+00, 1.9170089e+00,
   1.9179707e+00, 1.9189342e+00, 1.9198995e+00, 1.9208666e+00,
   1.9218355e+00, 1.9228063e+00, 1.9237788e+00, 1.9247532e+00,
   1.9257294e+00, 1.9267074e+00, 1.9276873e+00, 1.9286691e+00,
   1.9296527e+00, 1.9306381e+00, 1.9316255e+00, 1.9326147e+00,
   1.9336058e+00, 1.9345989e+00, 1.9355938e+00, 1.9365907e+00,
   1.9375895e+00, 1.9385902e+00, 1.9395928e+00, 1.9405975e+00,
   1.9416041e+00, 1.9426126e+00, 1.9436232e+00, 1.9446357e+00,
   1.9456502e+00, 1.9466668e+00, 1.9476854e+00, 1.9487059e+00,
   1.9497285e+00, 1.9507532e+00, 1.9517798e+00, 1.9528086e+00,
   1.9538395e+00, 1.9548724e+00, 1.9559075e+00, 1.9569446e+00,
   1.9579837e+00, 1.9590250e+00, 1.9600686e+00, 1.9611142e+00,
   1.9621619e+00, 1.9632118e+00, 1.9642639e+00, 1.9653181e+00,
   1.9663746e+00, 1.9674332e+00, 1.9684941e+00, 1.9695572e+00,
   1.9706224e+00, 1.9716901e+00, 1.9727598e+00, 1.9738319e+00,
   1.9749062e+00, 1.9759828e+00, 1.9770617e+00, 1.9781430e+00,
   1.9792265e+00, 1.9803123e+00, 1.9814006e+00, 1.9824911e+00,
   1.9835840e+00, 1.9846793e+00, 1.9857770e+00, 1.9868771e+00,
   1.9879795e+00, 1.9890845e+00, 1.9901918e+00, 1.9913017e+00,
   1.9924139e+00, 1.9935286e+00, 1.9946458e+00, 1.9957654e+00,
   1.9968877e+00, 1.9980124e+00, 1.9991397e+00, 2.0002694e+00,
   2.0014019e+00, 2.0025368e+00, 2.0036743e+00, 2.0048144e+00,
   2.0059571e+00, 2.0071025e+00, 2.0082505e+00, 2.0094011e+00,
   2.0105543e+00, 2.0117104e+00, 2.0128691e+00, 2.0140305e+00,
   2.0151947e+00, 2.0163615e+00, 2.0175312e+00, 2.0187035e+00,
   2.0198786e+00, 2.0210567e+00, 2.0222373e+00, 2.0234210e+00,
   2.0246074e+00, 2.0257967e+00, 2.0269887e+00, 2.0281839e+00,
   2.0293818e+00, 2.0305827e+00, 2.0317864e+00, 2.0329933e+00,
   2.0342031e+00, 2.0354156e+00, 2.0366313e+00, 2.0378501e+00,
   2.0390718e+00, 2.0402968e+00, 2.0415246e+00, 2.0427556e+00,
   2.0439897e+00, 2.0452268e+00, 2.0464671e+00, 2.0477107e+00,
   2.0489573e+00, 2.0502071e+00, 2.0514603e+00, 2.0527165e+00,
   2.0539761e+00, 2.0552390e+00, 2.0565050e+00, 2.0577743e+00,
   2.0590472e+00, 2.0603232e+00, 2.0616026e+00, 2.0628855e+00,
   2.0641716e+00, 2.0654614e+00, 2.0667543e+00, 2.0680509e+00,
   2.0693510e+00, 2.0706546e+00, 2.0719616e+00, 2.0732722e+00,
   2.0745864e+00, 2.0759041e+00, 2.0772257e+00, 2.0785506e+00,
   2.0798793e+00, 2.0812118e+00, 2.0825479e+00, 2.0838876e+00,
   2.0852313e+00, 2.0865786e+00, 2.0879297e+00, 2.0892847e+00,
   2.0906434e+00, 2.0920062e+00, 2.0933728e+00, 2.0947433e+00,
   2.0961177e+00, 2.0974960e+00, 2.0988786e+00, 2.1002650e+00,
   2.1016555e+00, 2.1030500e+00, 2.1044486e+00, 2.1058514e+00,
   2.1072583e+00, 2.1086695e+00, 2.1100848e+00, 2.1115043e+00,
   2.1129284e+00, 2.1143565e+00, 2.1157889e+00, 2.1172256e+00,
   2.1186669e+00, 2.1201127e+00, 2.1215627e+00, 2.1230171e+00,
   2.1244762e+00, 2.1259398e+00, 2.1274080e+00, 2.1288807e+00,
   2.1303580e+00, 2.1318402e+00, 2.1333268e+00, 2.1348183e+00,
   2.1363146e+00, 2.1378157e+00, 2.1393216e+00, 2.1408322e+00,
   2.1423478e+00, 2.1438684e+00, 2.1453941e+00, 2.1469245e+00,
   2.1484601e+00, 2.1500008e+00, 2.1515467e+00, 2.1530976e+00,
   2.1546538e+00, 2.1562152e+00, 2.1577818e+00, 2.1593540e+00,
   2.1609311e+00, 2.1625140e+00, 2.1641021e+00, 2.1656959e+00,
   2.1672950e+00, 2.1688998e+00, 2.1705101e+00, 2.1721261e+00,
   2.1737478e+00, 2.1753752e+00, 2.1770084e+00, 2.1786473e+00,
   2.1802921e+00, 2.1819429e+00, 2.1835999e+00, 2.1852627e+00,
   2.1869316e+00, 2.1886065e+00, 2.1902876e+00, 2.1919749e+00,
   2.1936686e+00, 2.1953685e+00, 2.1970749e+00, 2.1987877e+00,
   2.2005067e+00, 2.2022326e+00, 2.2039647e+00, 2.2057037e+00,
   2.2074494e+00, 2.2092018e+00, 2.2109611e+00, 2.2127271e+00,
   2.2145002e+00, 2.2162802e+00, 2.2180672e+00, 2.2198613e+00,
   2.2216625e+00, 2.2234712e+00, 2.2252872e+00, 2.2271104e+00,
   2.2289410e+00, 2.2307792e+00, 2.2326250e+00, 2.2344782e+00,
   2.2363393e+00, 2.2382083e+00, 2.2400849e+00, 2.2419696e+00,
   2.2438622e+00, 2.2457631e+00, 2.2476718e+00, 2.2495890e+00,
   2.2515142e+00, 2.2534480e+00, 2.2553902e+00, 2.2573411e+00,
   2.2593005e+00, 2.2612686e+00, 2.2632456e+00, 2.2652314e+00,
   2.2672260e+00, 2.2692299e+00, 2.2712429e+00, 2.2732651e+00,
   2.2752967e+00, 2.2773378e+00, 2.2793882e+00, 2.2814484e+00,
   2.2835183e+00, 2.2855980e+00, 2.2876878e+00, 2.2897875e+00,
   2.2918973e+00, 2.2940173e+00, 2.2961478e+00, 2.2982888e+00,
   2.3004403e+00, 2.3026025e+00, 2.3047755e+00, 2.3069596e+00,
   2.3091545e+00, 2.3113608e+00, 2.3135784e+00, 2.3158073e+00,
   2.3180478e+00, 2.3203001e+00, 2.3225641e+00, 2.3248401e+00,
   2.3271282e+00, 2.3294287e+00, 2.3317413e+00, 2.3340669e+00,
   2.3364048e+00, 2.3387556e+00, 2.3411195e+00, 2.3434966e+00,
   2.3458867e+00, 2.3482907e+00, 2.3507080e+00, 2.3531394e+00,
   2.3555846e+00, 2.3580439e+00, 2.3605177e+00, 2.3630061e+00,
   2.3655090e+00, 2.3680270e+00, 2.3705599e+00, 2.3731084e+00,
   2.3756721e+00, 2.3782516e+00, 2.3808472e+00, 2.3834586e+00,
   2.3860867e+00, 2.3887312e+00, 2.3913925e+00, 2.3940709e+00,
   2.3967667e+00, 2.3994799e+00, 2.4022110e+00, 2.4049599e+00,
   2.4077272e+00, 2.4105132e+00, 2.4133179e+00, 2.4161417e+00,
   2.4189849e+00, 2.4218478e+00, 2.4247308e+00, 2.4276340e+00,
   2.4305577e+00, 2.4335027e+00, 2.4364686e+00, 2.4394562e+00,
   2.4424658e+00, 2.4454975e+00, 2.4485519e+00, 2.4516294e+00,
   2.4547303e+00, 2.4578550e+00, 2.4610038e+00, 2.4641774e+00,
   2.4673758e+00, 2.4705997e+00, 2.4738493e+00, 2.4771256e+00,
   2.4804285e+00, 2.4837587e+00, 2.4871166e+00, 2.4905028e+00,
   2.4939179e+00, 2.4973624e+00, 2.5008366e+00, 2.5043414e+00,
   2.5078771e+00, 2.5114446e+00, 2.5150442e+00, 2.5186768e+00,
   2.5223429e+00, 2.5260432e+00, 2.5297785e+00, 2.5335493e+00,
   2.5373566e+00, 2.5412009e+00, 2.5450833e+00, 2.5490043e+00,
   2.5529649e+00, 2.5569661e+00, 2.5610085e+00, 2.5650933e+00,
   2.5692213e+00, 2.5733936e+00, 2.5776110e+00, 2.5818748e+00,
   2.5861864e+00, 2.5905464e+00, 2.5949562e+00, 2.5994170e+00,
   2.6039300e+00, 2.6084969e+00, 2.6131189e+00, 2.6177971e+00,
   2.6225336e+00, 2.6273296e+00, 2.6321869e+00, 2.6371069e+00,
   2.6420918e+00, 2.6471431e+00, 2.6522629e+00, 2.6574533e+00,
   2.6627162e+00, 2.6680539e+00, 2.6734686e+00, 2.6789629e+00,
   2.6845396e+00, 2.6902006e+00, 2.6959493e+00, 2.7017887e+00,
   2.7077217e+00, 2.7137513e+00, 2.7198815e+00, 2.7261155e+00,
   2.7324574e+00, 2.7389109e+00, 2.7454808e+00, 2.7521713e+00,
   2.7589874e+00, 2.7659342e+00, 2.7730169e+00, 2.7802417e+00,
   2.7876146e+00, 2.7951422e+00, 2.8028316e+00, 2.8106904e+00,
   2.8187268e+00, 2.8269496e+00, 2.8353682e+00, 2.8439925e+00,
   2.8528337e+00, 2.8619039e+00, 2.8712158e+00, 2.8807836e+00,
   2.8906226e+00, 2.9007499e+00, 2.9111838e+00, 2.9219446e+00,
   2.9330549e+00, 2.9445398e+00, 2.9564269e+00, 2.9687471e+00,
   2.9815352e+00, 2.9948308e+00, 3.0086782e+00, 3.0231280e+00,
   3.0382385e+00, 3.0540769e+00, 3.0707211e+00, 3.0882633e+00,
   3.1068115e+00, 3.1264958e+00, 3.1474738e+00, 3.1699378e+00,
   3.1941290e+00, 3.2203522e+00, 3.2490034e+00, 3.2806098e+00,
   3.3158946e+00, 3.3558927e+00, 3.4021609e+00, 3.4572146e+00,
   3.5255561e+00, 3.6167130e+00, 3.7595601e+00, 4.0255485e+00
};
