/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package groovy

import groovy.bugs.TestSupport

class SerializableCompatibilityTest extends TestSupport {
    void testSerialize() {
        def obj = new GroovyRuntimeException('boom')
        assert obj instanceof GroovyRuntimeException
        assert obj.message == 'boom'

        def out = new ByteArrayOutputStream();
        out.withObjectOutputStream{
            it.writeObject(obj)
        }

        println out.toByteArray().encodeBase64().toString()
    }

    void testDeserialize() {
        // generated by testSerialize
        def serializedObjectStr_2_4_X = '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'
        new ByteArrayInputStream(serializedObjectStr_2_4_X.decodeBase64()).withObjectInputStream {
            def newObj = it.readObject()
            assert newObj instanceof GroovyRuntimeException
            assert newObj.message == 'boom'
        }
    }
}
