/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Socket glue.  Right now we just have this for Unix/winsock.  Later we
 * will have an NSStream version.
 */

#include <Grouch/GrouchSocket.h>

@protocol GrouchSocketBackend
- (int)write:(const void*)buf length:(int)len;
- (int)read:(void*)buf length:(int)len;

- (void)startWriteThread;
- (void)setBlocking:(BOOL)b;
- (GrouchSocketEvent)pollSocketEvents;

- (BOOL)lastOperationWasError;
@end

#if defined(GNUSTEP) && !defined(_WIN32)
#define USE_GNUSTEP_EXTENSION
#endif

#ifdef USE_GNUSTEP_EXTENSION
#import <Foundation/NSRunLoop.h>
#import <Foundation/NSDate.h>
@class GrouchSocketWatcher;
#else
#import <Foundation/NSTimer.h>
#endif

#ifdef WIN32
#include <windows.h>
#include <winsock2.h>
#else
typedef int SOCKET;
#endif

@interface GrouchSocketUnix : NSObject <GrouchSocketBackend>
{
	GrouchSocket *socketObject;
	SOCKET fd;
	NSRunLoop *loop;
#ifdef USE_GNUSTEP_EXTENSION
	GrouchSocketWatcher *watcher;
#else
	NSTimer *timer;
#endif
	BOOL error;
}

+ (GrouchSocketUnix*)socketForHost:(NSString*)host atPort:(int)port
  withRunLoop:(NSRunLoop*)loop forSocket:(GrouchSocket*)sock;
- initForHost:(NSString*)host atPort:(int)port
  withRunLoop:(NSRunLoop*)loop forSocket:(GrouchSocket*)sock;

- (SOCKET)fd;

- (void)startWriteThread;
- (GrouchSocketEvent)pollSocketEvents;
- (void)setBlocking:(BOOL)b;

- (int)write:(const void*)buf length:(int)len;
- (int)read:(void*)buf length:(int)len;

- (BOOL)lastOperationWasError;
@end

#ifdef USE_GNUSTEP_EXTENSION
@interface GrouchSocketWatcher : NSObject <RunLoopEvents>
{
	GrouchSocket *sock;
	BOOL writeThreadLive;
}
+ watcherForSock:(GrouchSocket*)sock;
- initForSock:(GrouchSocket*)sock;

- (NSDate*)timedOutEvent:(void*)data type:(RunLoopEventType)type
	forMode:(NSString*)mode;
- (void)receivedEvent:(void*)data type:(RunLoopEventType)type
	extra:(void*)extra forMode:(NSString*)mode;

- (void)startWriteThread;
@end
#endif
